/*
 * Decompiled with CFR 0.152.
 */
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ChessGame
implements Runnable {
    public static final byte SERVER = -1;
    public int turn = 0;
    public int side = 0;
    private int _$2133 = 0;
    int result;
    String serverURL = null;
    public boolean gameOver = true;
    Position selected = null;
    Piece selectedPiece = null;
    ChessCanvas canvas;
    private int _$2137;
    protected Vector validMoves;
    protected Hashtable validMovesH;
    public Board board;
    protected Vector allMoves;
    protected Vector totalMoves;
    protected Vector futureMoves;
    protected boolean showPreviousMove = false;
    protected Hashtable options = new Hashtable();
    protected int initialTime;
    protected int timeIncrement;
    protected int timePerMove;
    long[] timerTimeLeft = new long[2];
    long timerLastUpdate = 0L;
    long timerTurnStartTime = 0L;
    boolean timerIsActive = false;
    boolean timerPaused = false;
    Thread timerThread = null;
    byte[] whiteDigits;
    byte[] blackDigits;

    public ChessGame(ChessCanvas chessCanvas) {
        this.canvas = chessCanvas;
        this.board = new Board(this);
        this.allMoves = new Vector();
        this.totalMoves = new Vector();
        this.futureMoves = new Vector();
        this.whiteDigits = new byte[4];
        this.blackDigits = new byte[4];
    }

    public int calcSquareIndex(Position position) {
        if (this.side == 0) {
            return position.x + (7 - position.y) * 8;
        }
        return 7 - position.x + position.y * 8;
    }

    public void setOption(Integer n, Integer n2) {
        int n3 = n;
        this.options.put(n, n2);
        if (n3 == 0) {
            this.initialTime = n2;
        } else if (n3 == 1) {
            this.timeIncrement = n2;
        } else if (n3 == 2) {
            this.timePerMove = n2;
        }
    }

    public void stopGame(int n) {
        this.gameOver = true;
        this.timerIsActive = false;
        this.result = n;
    }

    public Vector getAllMoves() {
        return this.totalMoves;
    }

    public void initStandardGame(int n) {
        this.turn = 0;
        this.side = n;
        this.allMoves.removeAllElements();
        this.futureMoves.removeAllElements();
        this.totalMoves.removeAllElements();
        this._$2133 = 0;
        this.board.initBoard();
        this._$2153();
        this.gameOver = false;
        this.canvas.setMyMove(n == this.turn);
        if (this.initialTime != 0) {
            this.timerTimeLeft[0] = this.initialTime * 1000 * 60;
            this.timerTimeLeft[1] = this.initialTime * 1000 * 60;
            this.timerLastUpdate = this.timerTurnStartTime = System.currentTimeMillis();
            this.timerIsActive = true;
            this.timerThread = new Thread(this);
            this.timerThread.start();
        } else {
            this.timerIsActive = false;
        }
    }

    private synchronized boolean _$2154() {
        long l = System.currentTimeMillis();
        int n = this.turn == 0 ? 0 : 1;
        this.timerTimeLeft[n] = this.timerTimeLeft[n] - (l - this.timerLastUpdate);
        this.timerLastUpdate = l;
        return this.timerTimeLeft[this.turn == 0 ? 0 : 1] > 0L || l - this.timerTurnStartTime > (long)(this.timePerMove * 60 * 1000);
    }

    public void disableTimer() {
        this.timerIsActive = false;
    }

    public void run() {
        while (this.timerIsActive) {
            try {
                Thread.sleep(this.timerTimeLeft[this.turn == 0 ? 0 : 1] % 1000L + 15L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.timerPaused) continue;
            if (!this._$2154()) {
                this.timerTimeLeft[this.turn == 0 ? 0 : 1] = 0L;
                this.timerIsActive = false;
            }
            this._$2156(0, this.whiteDigits, (int)this.timerTimeLeft[0]);
            this._$2156(8, this.blackDigits, (int)this.timerTimeLeft[1]);
            this.canvas.serviceRepaints();
        }
    }

    public void setTimeLeft(int n, int n2) {
        this.setTimeLeft(n, n2, true);
    }

    public void setTimeLeft(int n, int n2, boolean bl) {
        if (this.timerIsActive) {
            if (bl && this.allMoves.size() > 0) {
                Move move = (Move)this.allMoves.elementAt(this.allMoves.size() - 1);
                move.timeLeft = n2;
            }
            this.timerTimeLeft[n == 0 ? 0 : 1] = n2;
            this.timerPaused = false;
            this._$2156(n, n == 0 ? this.whiteDigits : this.blackDigits, n2);
            this.canvas.serviceRepaints();
        }
    }

    public int getTimeLeft(int n) {
        return (int)this.timerTimeLeft[n == 0 ? 0 : 1];
    }

    private void _$2162() {
        if (this.timerIsActive) {
            this._$2154();
            int n = this.turn == 0 ? 0 : 1;
            this.timerTimeLeft[n] = this.timerTimeLeft[n] + (long)(this.timeIncrement * 1000);
            this.timerPaused = true;
            this.timerTurnStartTime = System.currentTimeMillis();
        }
        this.turn ^= 8;
        if (this.timerIsActive) {
            this._$2156(0, this.whiteDigits, (int)this.timerTimeLeft[0]);
            this._$2156(8, this.blackDigits, (int)this.timerTimeLeft[1]);
            this.canvas.serviceRepaints();
        }
    }

    private void _$2156(int n, byte[] byArray, int n2) {
        byArray[0] = (byte)(n2 / 600000 % 6);
        byArray[1] = (byte)(n2 / 60000 % 10);
        byArray[2] = (byte)(n2 / 10000 % 6);
        byArray[3] = (byte)(n2 / 1000 % 10);
        this.canvas.paintTimeLeft(n, byArray);
    }

    public boolean isValidMove(Position position) {
        if (this.selected != null) {
            Move move = new Move(this.selected, position);
            return this.validMoves.contains(move);
        }
        return false;
    }

    public boolean isNullMove(Position position) {
        return position.equals(this.selected);
    }

    public boolean isSelectable(Position position) {
        if (!position.equals(this.selected)) {
            Piece piece = this.board.getPiece(position);
            return piece != null && piece.getColor() == this.turn && piece.getPossibleMoves() != null && piece.getPossibleMoves().size() > 0;
        }
        return false;
    }

    public void cancelSelection() {
        this.selected = null;
        this.selectedPiece = null;
    }

    public boolean selectPiece(Position position) {
        boolean bl = this.isSelectable(position);
        if (bl) {
            this.selected = position;
            this.selectedPiece = this.board.getPiece(position);
        }
        return bl;
    }

    public boolean moveSelected(Position position) {
        return this.moveSelected(position, -1);
    }

    public boolean moveSelected(Position position, int n) {
        boolean bl = this.makeMove(this.selected, position, n);
        if (bl) {
            this.selected = null;
            this.selectedPiece = null;
        }
        return bl;
    }

    public boolean isWhitesTurn() {
        return this.getNumMovesMade() % 2 == 0;
    }

    public boolean isBlacksTurn() {
        return !this.isWhitesTurn();
    }

    public boolean makeMove(Move move) {
        return this.makeMove(move, -1);
    }

    public boolean makeMove(Move move, int n) {
        return this.makeMove(move, n, false);
    }

    public boolean makeMove(Move move, int n, boolean bl) {
        Move move2 = move;
        Position position = null;
        Position position2 = null;
        if ((this.validMoves.contains(move2) || bl) && this.board.getPiece(move2.from) != null) {
            Object object;
            Piece piece;
            Move move3 = bl ? move : (Move)this.validMoves.elementAt(this.validMoves.indexOf(move2));
            move3.pieceType = this.board.getPiece(move3.from).getType();
            if (move3.pieceType == 6 && (this.turn == 0 && move3.to.y == 7 || this.turn == 8 && move3.to.y == 0)) {
                if (!bl && n == -1) {
                    this.canvas.askPromotion();
                    return false;
                }
                if (!bl) {
                    move3.promotionType = n;
                }
            }
            if ((piece = this.board.getPiece(move3.to)) != null) {
                this.board.removePiece(move3.to);
                this.canvas.addCaptured(piece.color, piece.type);
            } else if (move3.enPassant && this.board.getPiece((Position)(object = new Position(move3.to.x, move3.from.y))) != null) {
                this.board.removePiece((Position)object);
                this.canvas.addCaptured(this.turn ^ 8, 6);
            }
            this.board.movePiece(move3.from, move3.to);
            if (move3.promotionType != -1) {
                this.board.removePiece(move3.to);
                this.board.addPiece(move3.promotionType, this.turn, move3.to);
            }
            this.canvas.setPreviousMove(move3);
            this.canvas.paintSquare(this.calcSquareIndex(move3.from));
            this.canvas.paintSquare(this.calcSquareIndex(move3.to));
            if (!this.board.getPiece(move3.to).hasMoved()) {
                move3.hadMoved = false;
            }
            this.board.getPiece(move3.to).setHasMoved();
            if (this.board.getPiece(move3.to).getType() == 1 && move3.from.y == move3.to.y) {
                int n2 = move3.to.x - move3.from.x;
                if (n2 == 2) {
                    position = new Position(7, move3.from.y);
                    position2 = new Position(5, move3.from.y);
                    if (this.board.movePiece(position, position2)) {
                        this.board.getPiece(position2).setHasMoved();
                        this.canvas.paintSquare(this.calcSquareIndex(position));
                        this.canvas.paintSquare(this.calcSquareIndex(position2));
                    }
                } else if (n2 == -2 && this.board.movePiece(position = new Position(0, move3.from.y), position2 = new Position(3, move3.from.y))) {
                    this.board.getPiece(position2).setHasMoved();
                    this.canvas.paintSquare(this.calcSquareIndex(position));
                    this.canvas.paintSquare(this.calcSquareIndex(position2));
                }
            }
            if (!this.gameOver) {
                Piece.kingCheckInProgress = true;
                this._$2153();
                object = this.validMoves.elements();
                Position position3 = this.board.getKingPosition(this.turn ^ 8);
                while (object.hasMoreElements()) {
                    Move move4 = (Move)object.nextElement();
                    if (!move4.to.equals(position3)) continue;
                    move3.check = true;
                    break;
                }
                Piece.kingCheckInProgress = false;
            }
            this.canvas.playerMoved(this.turn != 0 ? 1 : 0, move3);
            this._$2162();
            if (this.initialTime != 0) {
                if (!bl) {
                    move3.timeLeft = (int)this.timerTimeLeft[this.turn == 0 ? 1 : 0];
                } else if (this.turn == 0) {
                    this._$2156(8, this.blackDigits, move3.timeLeft);
                } else {
                    this._$2156(0, this.whiteDigits, move3.timeLeft);
                }
            }
            ++this._$2133;
            if (!this.gameOver) {
                this._$2153();
                if (this.validMoves.size() == 0) {
                    if (move3.check) {
                        move3.checkMate = true;
                    } else {
                        move3.staleMate = true;
                    }
                    this.gameOver = true;
                }
            }
            this.canvas.setTurn(this.turn);
            this.allMoves.addElement(move3);
            this.totalMoves.addElement(move3);
            return true;
        }
        return false;
    }

    private void _$2153() {
        this.validMoves = this.isWhitesTurn() ? this.board.getValidMoves(0) : this.board.getValidMoves(8);
        this.validMovesH = new Hashtable();
        Enumeration enumeration = this.validMoves.elements();
        while (enumeration.hasMoreElements()) {
            Move move = (Move)enumeration.nextElement();
            Object var3_3 = null;
            Vector<Position> vector = (Vector<Position>)this.validMovesH.get(move.from);
            if (vector == null) {
                vector = new Vector<Position>();
                this.validMovesH.put(move.from, vector);
            }
            vector.addElement(move.to);
        }
    }

    public Vector getValidMoves() {
        return this.validMoves;
    }

    public Hashtable getValidMovesH() {
        return this.validMovesH;
    }

    public boolean makeMove(Position position, Position position2) {
        return this.makeMove(position, position2, -1);
    }

    public boolean makeMove(Position position, Position position2, int n) {
        return this.makeMove(new Move(new Position(position.x, position.y), new Position(position2.x, position2.y)), n);
    }

    public boolean makeMove(int n, int n2, int n3, int n4) {
        return this.makeMove(n, n2, n3, n4, -1);
    }

    public boolean makeMove(int n, int n2, int n3, int n4, int n5) {
        return this.makeMove(new Move(new Position(n, n2), new Position(n3, n4)), n5);
    }

    public int getNumMovesMade() {
        return this._$2133;
    }

    public boolean redoMove() {
        if (this.futureMoves.size() > 0) {
            Move move = (Move)this.futureMoves.elementAt(this.futureMoves.size() - 1);
            this.futureMoves.removeElementAt(this.futureMoves.size() - 1);
            this.makeMove(move, -1, true);
            return true;
        }
        return false;
    }

    public boolean undoMove() {
        if (this.allMoves.size() > 0) {
            Object object;
            Move move = (Move)this.allMoves.elementAt(this.allMoves.size() - 1);
            this.allMoves.removeElementAt(this.allMoves.size() - 1);
            if (this.gameOver) {
                this.futureMoves.addElement(move);
            } else {
                this.totalMoves.removeElementAt(this.totalMoves.size() - 1);
            }
            if (move.promotionType != -1) {
                this.board.removePiece(move.to);
                this.board.addPiece(6, this.turn ^ 8, move.to);
            }
            if (!move.hadMoved) {
                this.board.getPiece(move.to).clearHasMoved();
            }
            this.board.movePiece(move.to, move.from);
            if (move.captures) {
                if (move.enPassant) {
                    object = new Position(move.to.x, move.from.y);
                    this.board.addPiece(6, this.turn, (Position)object);
                    Pawn pawn = (Pawn)this.board.getPiece((Position)object);
                    pawn.enPassantMove = this._$2133 - 2;
                    this.canvas.paintSquare(this.calcSquareIndex((Position)object));
                } else {
                    this.board.addPiece(move.capturedPieceType, this.turn, move.to);
                    if (!move.capturedHadMoved) {
                        this.board.getPiece(move.to).clearHasMoved();
                    }
                }
            }
            if (move.pieceType == 1 && move.from.y == move.to.y) {
                Position position;
                Position position2;
                int n = move.to.x - move.from.x;
                if (n == 2) {
                    Position position3 = new Position(5, move.from.y);
                    Position position4 = new Position(7, move.from.y);
                    if (this.board.movePiece(position3, position4)) {
                        this.canvas.paintSquare(this.calcSquareIndex(position4));
                        this.canvas.paintSquare(this.calcSquareIndex(position3));
                        this.board.getPiece(position4).clearHasMoved();
                    }
                } else if (n == -2 && this.board.movePiece(position2 = new Position(3, move.from.y), position = new Position(0, move.from.y))) {
                    this.canvas.paintSquare(this.calcSquareIndex(position));
                    this.canvas.paintSquare(this.calcSquareIndex(position2));
                    this.board.getPiece(position).clearHasMoved();
                }
            }
            object = null;
            if (this.allMoves.size() > 0) {
                object = (Move)this.allMoves.elementAt(this.allMoves.size() - 1);
            }
            this.canvas.setPreviousMove((Move)object);
            this.canvas.playerMoved(this.turn != 0 ? 1 : 0, (Move)object, true);
            this.canvas.paintSquare(this.calcSquareIndex(move.from));
            this.canvas.paintSquare(this.calcSquareIndex(move.to));
            if (object != null) {
                this.canvas.paintSquare(this.calcSquareIndex(((Move)object).from));
                this.canvas.paintSquare(this.calcSquareIndex(((Move)object).to));
                if (this.initialTime != 0) {
                    if (this.turn == 8) {
                        this._$2156(0, this.whiteDigits, ((Move)object).timeLeft);
                    } else {
                        this._$2156(8, this.blackDigits, ((Move)object).timeLeft);
                    }
                }
            } else if (this.initialTime != 0) {
                this._$2156(0, this.whiteDigits, this.initialTime * 1000 * 60);
                this._$2156(8, this.blackDigits, this.initialTime * 1000 * 60);
            }
            if (move.captures) {
                this.canvas.removeCaptured(this.turn);
            }
            this._$2162();
            --this._$2133;
            if (!this.gameOver) {
                this._$2153();
            }
            this.canvas.setTurn(this.turn);
            return true;
        }
        return false;
    }
}

