/*
 * Decompiled with CFR 0.152.
 */
class Move {
    public boolean hadMoved = true;
    public boolean capturedHadMoved = true;
    public boolean captures = false;
    public int capturedPieceType = -1;
    public int pieceType = -1;
    public boolean check = false;
    public boolean checkMate = false;
    public boolean staleMate = false;
    public boolean castling = false;
    public boolean enPassant = false;
    public int promotionType = -1;
    public int timeLeft;
    public Position from;
    public Position to;
    public byte fdata;
    public byte tdata;

    public Move(Position position, Position position2) {
        this.from = position;
        this.to = position2;
    }

    public Move(int n, int n2) {
        this.from = new Position(n % 8, n >>> 3);
        this.to = new Position(n2 % 8, n2 >>> 3);
    }

    public int hashCode() {
        return this.from.hashCode() + this.to.hashCode();
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof Move) {
            Move move = (Move)object;
            return this.from.equals(move.from) && this.to.equals(move.to);
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.castling) {
            switch (this.pieceType) {
                case 3: {
                    stringBuffer.append("R");
                    break;
                }
                case 5: {
                    stringBuffer.append("B");
                    break;
                }
                case 1: {
                    stringBuffer.append("K");
                    break;
                }
                case 4: {
                    stringBuffer.append("N");
                    break;
                }
                case 2: {
                    stringBuffer.append("Q");
                    break;
                }
            }
            stringBuffer.append(this.from.toString());
            if (this.captures) {
                stringBuffer.append("x");
            } else {
                stringBuffer.append("-");
            }
            stringBuffer.append(this.to.toString());
            switch (this.promotionType) {
                case 5: {
                    stringBuffer.append("B");
                    break;
                }
                case 3: {
                    stringBuffer.append("R");
                    break;
                }
                case 4: {
                    stringBuffer.append("N");
                    break;
                }
                case 2: {
                    stringBuffer.append("Q");
                    break;
                }
            }
            if (this.checkMate) {
                stringBuffer.append("#");
            } else if (this.check) {
                stringBuffer.append("+");
            }
        } else if (this.to.x - this.from.x > 0) {
            stringBuffer.append("O-O");
        } else {
            stringBuffer.append("O-O-O");
        }
        return stringBuffer.toString();
    }
}

