/*
 * Decompiled with CFR 0.152.
 */
import java.util.Enumeration;
import java.util.Vector;

public abstract class Piece {
    public static final byte KING = 1;
    public static final byte QUEEN = 2;
    public static final byte ROOK = 3;
    public static final byte KNIGHT = 4;
    public static final byte BISHOP = 5;
    public static final byte PAWN = 6;
    public static final byte WHITE = 0;
    public static final byte BLACK = 8;
    protected Position position = null;
    protected int type;
    protected int color;
    protected boolean moved = false;
    protected Vector possibleMoves;
    protected int possibleMovesUpdated = -1;
    protected Board board;
    protected static boolean kingCheckInProgress = false;

    public Piece(int n, int n2, Position position) {
        this.type = n;
        this.color = n2;
        this.position = position;
        this.possibleMoves = new Vector();
    }

    public void setBoard(Board board) {
        this.board = board;
    }

    public Board getBoard() {
        return this.board;
    }

    public ChessGame getGame() {
        if (this.board != null) {
            return this.board.getGame();
        }
        return null;
    }

    public int getType() {
        return this.type;
    }

    public int getColor() {
        return this.color;
    }

    public boolean hasMoved() {
        return this.moved;
    }

    public void setHasMoved() {
        this.moved = true;
    }

    public void clearHasMoved() {
        this.moved = false;
    }

    public Position getPosition() {
        return this.position;
    }

    public abstract Vector getPossibleMoves();

    public boolean threatens(Position position) {
        Enumeration enumeration = this.getPossibleMoves().elements();
        while (enumeration.hasMoreElements()) {
            Move move = (Move)enumeration.nextElement();
            if (!move.to.equals(position)) continue;
            return true;
        }
        return false;
    }

    public void checkPossibleMovesForCheck() {
        Board board = this.board;
        if (board != null) {
            Position position = new Position();
            int n = 0;
            while (n < this.possibleMoves.size()) {
                Move move = (Move)this.possibleMoves.elementAt(n);
                position.x = move.from.x;
                position.y = move.from.y;
                Piece piece = this.board.getPiece(move.to);
                if (piece != null) {
                    this.board.removePiece(move.to);
                }
                this.board.movePiece(position, move.to);
                if (board.isUnderThreat(board.getKingPosition(this.color), this.color ^ 8)) {
                    this.possibleMoves.removeElementAt(n);
                    --n;
                }
                this.board.movePiece(move.to, position);
                if (piece != null) {
                    this.board.addPiece(piece);
                }
                ++n;
            }
        }
    }

    public void move(Position position) {
        if (this.position == null) {
            this.position = new Position();
        }
        this.position.x = position.x;
        this.position.y = position.y;
    }

    protected void getSlideMoves(int n, int n2, int n3, int n4, Vector vector) {
        if (this.board == null || vector == null) {
            return;
        }
        Position position = new Position();
        position.x = n;
        position.y = n2;
        while (true) {
            Move move;
            position.x += n3;
            position.y += n4;
            if (!this.board.isOnBoard(position.x, position.y)) break;
            Piece piece = this.board.getPiece(position.x, position.y);
            if (piece != null) {
                if (piece.getColor() == this.color) break;
                move = new Move(new Position(this.position.x, this.position.y), position);
                move.pieceType = this.type;
                move.captures = true;
                if (!piece.hasMoved()) {
                    move.capturedHadMoved = false;
                }
                move.capturedPieceType = piece.getType();
                vector.addElement(move);
                position = new Position(position.x, position.y);
                break;
            }
            move = new Move(new Position(this.position.x, this.position.y), position);
            move.pieceType = this.type;
            vector.addElement(move);
            position = new Position(position.x, position.y);
        }
    }
}

