/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;

public class Pawn
extends Piece {
    int enPassantMove = -2;
    int deltaMove = 0;

    public Pawn(int n, Position position) {
        super(6, n, position);
        this.deltaMove = n == 0 ? 1 : -1;
    }

    public void move(Position position) {
        ChessGame chessGame = this.getGame();
        if (chessGame != null) {
            if (this.color == 0) {
                if (this.position.y == 1 && position.y == 3) {
                    this.enPassantMove = chessGame.getNumMovesMade();
                }
            } else if (this.position.y == 6 && position.y == 4) {
                this.enPassantMove = chessGame.getNumMovesMade();
            }
        }
        super.move(position);
    }

    public int getEnPassantMove() {
        return this.enPassantMove;
    }

    public Vector getPossibleMoves() {
        if (this.board == null) {
            return new Vector();
        }
        ChessGame chessGame = this.getGame();
        if (chessGame == null || chessGame != null && chessGame.getNumMovesMade() != this.possibleMovesUpdated || Piece.kingCheckInProgress) {
            Move move;
            Object object;
            this.possibleMoves = new Vector();
            Position position = new Position();
            position.x = this.position.x;
            position.y = this.position.y + this.deltaMove;
            if (this.board.isOnBoard(position) && this.board.getPiece(position) == null) {
                object = new Move(new Position(this.position.x, this.position.y), position);
                ((Move)object).pieceType = this.type;
                this.possibleMoves.addElement(object);
                position = new Position();
                if (!this.hasMoved()) {
                    position.x = this.position.x;
                    position.y = this.position.y + this.deltaMove + this.deltaMove;
                    if (this.board.isOnBoard(position) && this.board.getPiece(position) == null) {
                        object = new Move(new Position(this.position.x, this.position.y), position);
                        ((Move)object).pieceType = this.type;
                        this.possibleMoves.addElement(object);
                        position = new Position();
                    }
                }
            }
            position.x = this.position.x - this.deltaMove;
            position.y = this.position.y + this.deltaMove;
            if (this.board.isOnBoard(position) && this.board.getPiece(position) != null && this.board.getPiece(position).getColor() != this.color) {
                object = new Move(new Position(this.position.x, this.position.y), position);
                ((Move)object).pieceType = this.type;
                if (!this.board.getPiece(position).hasMoved()) {
                    ((Move)object).capturedHadMoved = false;
                }
                ((Move)object).captures = true;
                ((Move)object).capturedPieceType = this.board.getPiece(position).getType();
                this.possibleMoves.addElement(object);
                position = new Position();
            }
            position.x = this.position.x + this.deltaMove;
            position.y = this.position.y + this.deltaMove;
            if (this.board.isOnBoard(position) && this.board.getPiece(position) != null && this.board.getPiece(position).getColor() != this.color) {
                object = new Move(new Position(this.position.x, this.position.y), position);
                ((Move)object).captures = true;
                if (!this.board.getPiece(position).hasMoved()) {
                    ((Move)object).capturedHadMoved = false;
                }
                ((Move)object).capturedPieceType = this.board.getPiece(position).getType();
                ((Move)object).pieceType = this.type;
                this.possibleMoves.addElement(object);
                position = new Position();
            }
            position.x = this.position.x - this.deltaMove;
            position.y = this.position.y;
            if (this.board.isOnBoard(position) && this.board.getPiece(position) != null && this.board.getPiece(position).getColor() == (this.color ^ 8) && this.board.getPiece(position).getType() == 6) {
                object = (Pawn)this.board.getPiece(position);
                if (chessGame == null || chessGame != null && ((Pawn)object).getEnPassantMove() == chessGame.getNumMovesMade() - 1) {
                    move = new Move(new Position(this.position.x, this.position.y), new Position(position.x, position.y + this.deltaMove));
                    move.captures = true;
                    move.enPassant = true;
                    move.capturedPieceType = 6;
                    move.pieceType = this.type;
                    this.possibleMoves.addElement(move);
                }
            }
            position.x = this.position.x + this.deltaMove;
            position.y = this.position.y;
            if (this.board.isOnBoard(position) && this.board.getPiece(position) != null && this.board.getPiece(position).getColor() == (this.color ^ 8) && this.board.getPiece(position).getType() == 6) {
                object = (Pawn)this.board.getPiece(position);
                if (chessGame == null || chessGame != null && ((Pawn)object).getEnPassantMove() == chessGame.getNumMovesMade() - 1) {
                    move = new Move(new Position(this.position.x, this.position.y), new Position(position.x, position.y + this.deltaMove));
                    move.captures = true;
                    move.enPassant = true;
                    move.capturedPieceType = 6;
                    move.pieceType = this.type;
                    this.possibleMoves.addElement(move);
                }
            }
            if (!Piece.kingCheckInProgress) {
                Piece.kingCheckInProgress = true;
                this.checkPossibleMovesForCheck();
                Piece.kingCheckInProgress = false;
            }
            if (chessGame != null) {
                this.possibleMovesUpdated = chessGame.getNumMovesMade();
            }
        }
        return this.possibleMoves;
    }
}

