/*
 * Decompiled with CFR 0.152.
 */
package akna;

import akna.Clock;
import akna.GamePanel;
import akna.Mezo;
import akna.ScoreBoard;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.TextBox;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;

public class Akna
extends MIDlet
implements CommandListener {
    public static final byte EMPTY = 0;
    public static final byte ONE = 1;
    public static final byte TWO = 2;
    public static final byte THREE = 3;
    public static final byte FOUR = 4;
    public static final byte FIVE = 5;
    public static final byte SIX = 6;
    public static final byte SEVEN = 7;
    public static final byte EIGHT = 8;
    public static final byte BOMB = 9;
    public static final byte COVERED = 10;
    public static final byte FLAG = 11;
    public static final byte ERROR = 12;
    public static final byte KILLER = 13;
    public static final byte SELECTED = 100;
    public static int szinek;
    public int x = 0;
    public int y = 0;
    public int px = 0;
    public int py = 0;
    public int maradek = 0;
    public int tick = 0;
    private int darab = 10;
    private Clock clock = null;
    private Timer timer = null;
    private byte[][] table = null;
    public byte[][] view = null;
    private Hashtable flyweight = new Hashtable();
    private int kesz = 0;
    private boolean megjo = true;
    private boolean nyert = false;
    private boolean started = false;
    private GamePanel jatek = null;
    private ScoreBoard score = null;
    private TextBox nev = new TextBox("Enter your name:", null, 10, 0);
    private Command exitCommand = new Command("Exit", 7, 1);
    private Command backCommand = new Command("Back", 2, 1);
    private Command okCommand = new Command("OK", 4, 1);
    private Command newCommand = new Command("New", 1, 1);
    private Command aboutCommand = new Command("About", 1, 1);
    private Image bomba = this.loadImage("/akna/icons/bomba.png");

    public Akna() {
        this.score = new ScoreBoard();
        this.score.addCommand(this.backCommand);
        this.score.setCommandListener(this);
        this.nev.addCommand(this.okCommand);
        this.nev.setCommandListener((CommandListener)this);
        this.x = 8;
        this.y = 8;
        this.jatek = new GamePanel(this);
        this.jatek.addCommand(this.exitCommand);
        this.jatek.addCommand(this.newCommand);
        this.jatek.addCommand(this.aboutCommand);
        this.jatek.setCommandListener(this);
        this.darab = 10;
        this.coverTable();
    }

    public void decAkna() {
        --this.maradek;
    }

    public void incAkna() {
        ++this.maradek;
    }

    public void tick() {
        ++this.tick;
        this.jatek.repaint();
    }

    public void coverTable() {
        if (this.clock != null) {
            this.clock.cancel();
            this.clock = null;
        }
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
        this.px = 0;
        this.py = 0;
        this.kesz = 0;
        this.megjo = true;
        this.nyert = false;
        this.maradek = this.darab;
        this.tick = 0;
        this.started = false;
        this.table = new byte[this.x][this.y];
        this.view = new byte[this.x][this.y];
        for (int i = 0; i < this.x; ++i) {
            for (int j = 0; j < this.y; ++j) {
                this.table[i][j] = 10;
                this.view[i][j] = 10;
            }
        }
        this.view[this.px][this.py] = (byte)(this.view[this.px][this.py] + 100);
        this.jatek.repaint();
    }

    public void generateTable(int xk, int yk) {
        int k = this.darab;
        Random rand = new Random();
        while (k > 0) {
            int y0;
            int x0 = Math.abs(rand.nextInt()) % (this.x - 1);
            if (this.table[x0][y0 = Math.abs(rand.nextInt()) % (this.y - 1)] == 9 || x0 == xk || y0 == yk) continue;
            this.table[x0][y0] = 9;
            --k;
        }
        for (int i = 0; i < this.x; ++i) {
            for (int j = 0; j < this.y; ++j) {
                if (this.table[i][j] == 9) continue;
                this.table[i][j] = this.szomszed(i, j);
            }
        }
        this.started = true;
    }

    public void moveUP() {
        if (this.px > 0) {
            --this.px;
            this.view[this.px + 1][this.py] = (byte)(this.view[this.px + 1][this.py] - 100);
            this.view[this.px][this.py] = (byte)(this.view[this.px][this.py] + 100);
        }
    }

    public void moveDOWN() {
        if (this.px < this.x - 1) {
            ++this.px;
            this.view[this.px - 1][this.py] = (byte)(this.view[this.px - 1][this.py] - 100);
            this.view[this.px][this.py] = (byte)(this.view[this.px][this.py] + 100);
        }
    }

    public void moveLEFT() {
        if (this.py > 0) {
            --this.py;
            this.view[this.px][this.py + 1] = (byte)(this.view[this.px][this.py + 1] - 100);
            this.view[this.px][this.py] = (byte)(this.view[this.px][this.py] + 100);
        }
    }

    public void moveRIGHT() {
        if (this.py < this.y - 1) {
            ++this.py;
            this.view[this.px][this.py - 1] = (byte)(this.view[this.px][this.py - 1] - 100);
            this.view[this.px][this.py] = (byte)(this.view[this.px][this.py] + 100);
        }
    }

    public byte szomszed(int a, int b) {
        byte szakna = 0;
        if (a - 1 >= 0 && b - 1 >= 0 && this.table[a - 1][b - 1] == 9) {
            szakna = (byte)(szakna + 1);
        }
        if (a - 1 >= 0 && this.table[a - 1][b] == 9) {
            szakna = (byte)(szakna + 1);
        }
        if (a - 1 >= 0 && b + 1 < this.y && this.table[a - 1][b + 1] == 9) {
            szakna = (byte)(szakna + 1);
        }
        if (b - 1 >= 0 && this.table[a][b - 1] == 9) {
            szakna = (byte)(szakna + 1);
        }
        if (b + 1 < this.y && this.table[a][b + 1] == 9) {
            szakna = (byte)(szakna + 1);
        }
        if (a + 1 < this.x && b - 1 >= 0 && this.table[a + 1][b - 1] == 9) {
            szakna = (byte)(szakna + 1);
        }
        if (a + 1 < this.x && this.table[a + 1][b] == 9) {
            szakna = (byte)(szakna + 1);
        }
        if (a + 1 < this.x && b + 1 < this.y && this.table[a + 1][b + 1] == 9) {
            szakna = (byte)(szakna + 1);
        }
        return szakna;
    }

    public Mezo getComp(byte type) {
        Mezo tmp = (Mezo)this.flyweight.get(new Integer(type));
        if (tmp == null) {
            tmp = new Mezo(type);
            this.flyweight.put(new Integer(type), tmp);
        }
        return tmp;
    }

    public void vege() {
        Alert end;
        if (this.clock != null) {
            this.clock.cancel();
        }
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.timer = null;
        this.clock = null;
        if (!this.nyert) {
            end = new Alert("End", "You lost!", null, AlertType.INFO);
            Display.getDisplay((MIDlet)this).setCurrent(end, (Displayable)this.score);
            this.score.printScores();
        } else {
            end = new Alert("End", "You win!", null, AlertType.INFO);
            Display.getDisplay((MIDlet)this).setCurrent(end, (Displayable)this.nev);
        }
        this.megjo = false;
        for (int i = 0; i < this.x; ++i) {
            for (int j = 0; j < this.y; ++j) {
                if (this.view[i][j] == 10 && this.table[i][j] == 9) {
                    this.view[i][j] = this.table[i][j];
                    continue;
                }
                if (this.view[i][j] == 110 && this.table[i][j] == 9) {
                    this.view[i][j] = (byte)(this.table[i][j] + 100);
                    continue;
                }
                if (this.view[i][j] == 11 && this.table[i][j] != 9) {
                    this.view[i][j] = 12;
                    continue;
                }
                if (this.view[i][j] != 111 || this.table[i][j] == 9) continue;
                this.view[i][j] = 112;
            }
        }
        this.jatek.repaint();
    }

    public void oraIndit() {
        this.clock = new Clock(this);
        this.timer = new Timer();
        this.timer.scheduleAtFixedRate((TimerTask)this.clock, 1000L, 1000L);
    }

    public void kesz() {
        if (this.kesz == 0 && this.megjo) {
            this.oraIndit();
        }
        ++this.kesz;
        if (this.kesz + this.darab == this.x * this.y && this.megjo) {
            this.nyert = true;
            this.vege();
        }
    }

    public void fire() {
        if (this.view[this.px][this.py] == 10 || this.view[this.px][this.py] == 110) {
            this.felfed(this.px, this.py);
        } else if (this.view[this.px][this.py] != 11 && this.view[this.px][this.py] != 111) {
            this.duplakatt(this.px, this.py);
        }
    }

    public void felfed(int a, int b) {
        if (!this.started) {
            this.generateTable(a, b);
        }
        if (this.view[a][b] != 110 && this.view[a][b] != 10) {
            return;
        }
        if (this.view[a][b] == 10) {
            this.view[a][b] = this.table[a][b];
        } else if (this.view[a][b] == 110) {
            this.view[a][b] = (byte)(this.table[a][b] + 100);
        }
        this.jatek.repaint();
        if (this.table[a][b] != 9) {
            this.kesz();
        } else {
            if (this.view[a][b] == 9) {
                this.view[a][b] = 13;
            } else if (this.view[a][b] == 109) {
                this.view[a][b] = 113;
            }
            this.vege();
        }
        if (this.table[a][b] != 0) {
            return;
        }
        if (a - 1 >= 0 && b - 1 >= 0) {
            this.felfed(a - 1, b - 1);
        }
        if (a - 1 >= 0) {
            this.felfed(a - 1, b);
        }
        if (a - 1 >= 0 && b + 1 < this.y) {
            this.felfed(a - 1, b + 1);
        }
        if (b - 1 >= 0) {
            this.felfed(a, b - 1);
        }
        if (b + 1 < this.y) {
            this.felfed(a, b + 1);
        }
        if (a + 1 < this.x && b - 1 >= 0) {
            this.felfed(a + 1, b - 1);
        }
        if (a + 1 < this.x) {
            this.felfed(a + 1, b);
        }
        if (a + 1 < this.x && b + 1 < this.y) {
            this.felfed(a + 1, b + 1);
        }
    }

    public void jelol() {
        this.megjelol(this.px, this.py);
    }

    public void megjelol(int a, int b) {
        if (!this.megjo) {
            return;
        }
        if (this.view[a][b] == 110) {
            this.view[a][b] = 111;
            this.jatek.repaint();
            this.decAkna();
        } else if (this.view[a][b] == 111) {
            this.view[a][b] = 110;
            this.jatek.repaint();
            this.incAkna();
        } else if (this.view[a][b] == 10) {
            this.view[a][b] = 11;
            this.jatek.repaint();
            this.decAkna();
        } else if (this.view[a][b] == 11) {
            this.view[a][b] = 10;
            this.jatek.repaint();
            this.incAkna();
        }
    }

    public void duplakatt(int a, int b) {
        int db = 0;
        if (a - 1 >= 0 && b - 1 >= 0 && this.view[a - 1][b - 1] == 11) {
            ++db;
        }
        if (a - 1 >= 0 && this.view[a - 1][b] == 11) {
            ++db;
        }
        if (a - 1 >= 0 && b + 1 < this.y && this.view[a - 1][b + 1] == 11) {
            ++db;
        }
        if (b - 1 >= 0 && this.view[a][b - 1] == 11) {
            ++db;
        }
        if (b + 1 < this.y && this.view[a][b + 1] == 11) {
            ++db;
        }
        if (a + 1 < this.x && b - 1 >= 0 && this.view[a + 1][b - 1] == 11) {
            ++db;
        }
        if (a + 1 < this.x && this.view[a + 1][b] == 11) {
            ++db;
        }
        if (a + 1 < this.x && b + 1 < this.y && this.view[a + 1][b + 1] == 11) {
            ++db;
        }
        if (db == this.table[a][b]) {
            if (a - 1 >= 0 && b - 1 >= 0 && this.view[a - 1][b - 1] != 11) {
                this.felfed(a - 1, b - 1);
            }
            if (a - 1 >= 0 && this.view[a - 1][b] != 11) {
                this.felfed(a - 1, b);
            }
            if (a - 1 >= 0 && b + 1 < this.y && this.view[a - 1][b + 1] != 11) {
                this.felfed(a - 1, b + 1);
            }
            if (b - 1 >= 0 && this.view[a][b - 1] != 11) {
                this.felfed(a, b - 1);
            }
            if (b + 1 < this.y && this.view[a][b + 1] != 11) {
                this.felfed(a, b + 1);
            }
            if (a + 1 < this.x && b - 1 >= 0 && this.view[a + 1][b - 1] != 11) {
                this.felfed(a + 1, b - 1);
            }
            if (a + 1 < this.x && this.view[a + 1][b] != 11) {
                this.felfed(a + 1, b);
            }
            if (a + 1 < this.x && b + 1 < this.y && this.view[a + 1][b + 1] != 11) {
                this.felfed(a + 1, b + 1);
            }
        }
    }

    public void startApp() throws MIDletStateChangeException {
        Display tmp = Display.getDisplay((MIDlet)this);
        szinek = tmp.numColors();
        Alert about = new Alert("", "Minesweeper\nWritten by Gergely Herenyi\ne-mail: h.gergo@freemail.hu", this.bomba, AlertType.INFO);
        about.setTimeout(-2);
        tmp.setCurrent(about, (Displayable)this.jatek);
    }

    public void pauseApp() {
    }

    public void destroyApp(boolean unconditional) throws MIDletStateChangeException {
        this.score.close();
    }

    public void commandAction(Command c, Displayable s) {
        if (c == this.exitCommand) {
            try {
                this.destroyApp(false);
            }
            catch (MIDletStateChangeException mIDletStateChangeException) {
                // empty catch block
            }
            this.notifyDestroyed();
        } else if (c == this.newCommand) {
            this.coverTable();
        } else if (c == this.backCommand) {
            Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.jatek);
        } else if (c == this.okCommand) {
            this.score.addScore(this.tick, this.nev.getString());
            this.score.printScores();
            Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.score);
        } else if (c == this.aboutCommand) {
            Alert about = new Alert("About", "Minesweeper\nWritten by Gergely Herenyi\ne-mail: h.gergo@freemail.hu\nMore info on http://www.motoros.hu/akna.wml", this.bomba, AlertType.INFO);
            about.setTimeout(-2);
            Display.getDisplay((MIDlet)this).setCurrent((Displayable)about);
        }
    }

    private Image loadImage(String imageFile) {
        Image image = null;
        try {
            image = Image.createImage((String)imageFile);
        }
        catch (IOException e) {
            System.out.println(e);
        }
        return image;
    }

    static {
        EMPTY = 0;
        ONE = 1;
        TWO = (byte)2;
        THREE = (byte)3;
        FOUR = (byte)4;
        FIVE = (byte)5;
        SIX = (byte)6;
        SEVEN = (byte)7;
        EIGHT = (byte)8;
        BOMB = (byte)9;
        COVERED = (byte)10;
        FLAG = (byte)11;
        ERROR = (byte)12;
        KILLER = (byte)13;
        SELECTED = (byte)100;
        szinek = 0;
    }
}

