/*
 * Decompiled with CFR 0.152.
 */
package akna;

import akna.Akna;
import akna.Mezo;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class GamePanel
extends Canvas {
    Akna parent = null;
    public int width = 0;
    public int height = 0;
    private Image table = null;
    private int scrollheight = 4;

    public GamePanel(Akna parent) {
        this.parent = parent;
        this.width = this.getWidth();
        this.height = this.getHeight();
        this.table = Image.createImage((int)(parent.y * Mezo.size + 3), (int)(parent.x * Mezo.size + 3));
    }

    void paintTable() {
        Graphics g = this.table.getGraphics();
        g.setColor(0xFFFFFF);
        g.fillRect(0, 0, this.table.getWidth(), this.table.getHeight());
        g.setColor(0);
        g.drawRect(0, 0, this.table.getWidth() - 1, this.table.getHeight() - 1);
        Mezo tmp = null;
        int x = 2;
        int y = 2;
        for (int i = 0; i < this.parent.x; ++i) {
            for (int j = 0; j < this.parent.y; ++j) {
                tmp = this.parent.getComp(this.parent.view[i][j]);
                tmp.draw(g, x, y, this);
                x += Mezo.size;
            }
            y += Mezo.size;
            x = 2;
        }
    }

    public void paint(Graphics g) {
        g.setColor(0xFFFFFF);
        g.fillRect(0, 0, this.width, this.height);
        this.paintInfos(g);
        this.paintTable();
        g.setClip(0, Font.getDefaultFont().getHeight(), this.width - this.scrollheight, this.height - Font.getDefaultFont().getHeight() - this.scrollheight);
        if (this.table.getWidth() > this.width - this.scrollheight || this.table.getHeight() > this.height - this.scrollheight) {
            if (this.table.getWidth() > this.width - this.scrollheight && this.table.getHeight() > this.height - this.scrollheight) {
                int newx = this.width / 2 - this.parent.py * Mezo.size;
                int newy = this.height / 2 - this.parent.px * Mezo.size;
                if (newx > 0) {
                    newx = 0;
                }
                if (newy > Font.getDefaultFont().getHeight()) {
                    newy = Font.getDefaultFont().getHeight();
                }
                if (newx + this.table.getWidth() < this.width - this.scrollheight) {
                    newx = this.width - this.table.getWidth() - this.scrollheight;
                }
                if (newy + this.table.getHeight() < this.height - this.scrollheight) {
                    newy = this.height - this.table.getHeight() - this.scrollheight;
                }
                g.drawImage(this.table, newx, newy, 20);
                this.paintScrollVbar(g, newy);
                this.paintScrollHbar(g, newx);
            } else if (this.table.getWidth() > this.width - this.scrollheight) {
                int newx = this.width / 2 - this.parent.py * Mezo.size;
                if (newx > 0) {
                    newx = 0;
                }
                if (newx + this.table.getWidth() < this.width - this.scrollheight) {
                    newx = this.width - this.table.getWidth() - this.scrollheight;
                }
                g.drawImage(this.table, newx, Font.getDefaultFont().getHeight(), 20);
                this.paintScrollHbar(g, newx);
            } else if (this.table.getHeight() > this.height - this.scrollheight) {
                int newy = this.height / 2 - this.parent.px * Mezo.size;
                if (newy > Font.getDefaultFont().getHeight()) {
                    newy = Font.getDefaultFont().getHeight();
                }
                if (newy + this.table.getHeight() < this.height - this.scrollheight) {
                    newy = this.height - this.table.getHeight() - this.scrollheight;
                }
                g.drawImage(this.table, this.width / 2, newy, 17);
                this.paintScrollVbar(g, newy);
            }
        } else {
            g.drawImage(this.table, this.width / 2, this.height / 2, 3);
        }
    }

    private void paintScrollVbar(Graphics g, int ny) {
        int clipheight = this.height - Font.getDefaultFont().getHeight() - this.scrollheight;
        int scrollbarh = clipheight * clipheight / this.table.getHeight();
        int sy = Font.getDefaultFont().getHeight() + Math.abs(Font.getDefaultFont().getHeight() - ny) * (this.height - 1 - Font.getDefaultFont().getHeight() - scrollbarh) / (this.table.getHeight() - clipheight);
        g.setClip(0, Font.getDefaultFont().getHeight(), this.width, this.height - Font.getDefaultFont().getHeight());
        g.drawLine(this.width - 2, Font.getDefaultFont().getHeight(), this.width - 2, this.height - 1);
        g.fillRect(this.width - 3, sy, 3, scrollbarh);
    }

    private void paintScrollHbar(Graphics g, int nx) {
        int clipwidth = this.width - this.scrollheight;
        int scrollbarw = clipwidth * clipwidth / this.table.getWidth();
        int sx = Math.abs(nx) * (this.width - 1 - scrollbarw) / (this.table.getWidth() - clipwidth);
        g.setClip(0, Font.getDefaultFont().getHeight(), this.width, this.height - Font.getDefaultFont().getHeight());
        g.drawLine(0, this.height - 2, this.width - 1, this.height - 2);
        g.fillRect(sx, this.height - 3, scrollbarw, 3);
    }

    private void paintInfos(Graphics g) {
        g.setColor(0);
        String tmp = String.valueOf(String.valueOf(new StringBuffer("Mines = ").append(String.valueOf(this.parent.maradek)).append(" Time = ").append(this.parent.tick)));
        if (Font.getDefaultFont().stringWidth(tmp) > this.width) {
            tmp = String.valueOf(String.valueOf(new StringBuffer("M=").append(String.valueOf(this.parent.maradek)).append(" T=").append(this.parent.tick)));
        }
        g.drawString(tmp, this.width / 2, 1, 17);
    }

    public void keyRepeated(int keyCode) {
        this.keyPressed(keyCode);
    }

    public void keyPressed(int keyCode) {
        int action = this.getGameAction(keyCode);
        switch (action) {
            case 6: {
                this.parent.moveDOWN();
                break;
            }
            case 1: {
                this.parent.moveUP();
                break;
            }
            case 5: {
                this.parent.moveRIGHT();
                break;
            }
            case 2: {
                this.parent.moveLEFT();
                break;
            }
            case 8: {
                this.parent.fire();
                break;
            }
            case 9: {
                this.parent.jelol();
            }
        }
        this.repaint();
    }

    public void pointerReleased(int xk, int yk) {
    }

    public void pointerDragged(int xk, int yk) {
    }

    public void pointerPressed(int xk, int yk) {
        int a = -1;
        int b = -1;
        int x = (this.width - this.parent.x * Mezo.size) / 2;
        int y = (this.height - this.parent.y * Mezo.size) / 2;
        for (int i = 0; i < this.parent.x; ++i) {
            for (int j = 0; j < this.parent.y; ++j) {
                if (xk > x && xk < x + Mezo.size && yk > y && yk < yk + Mezo.size) {
                    a = i;
                    b = j;
                }
                x += Mezo.size;
            }
            y += Mezo.size;
            x = (this.width - this.parent.x * Mezo.size) / 2;
        }
        if (a > -1 && b > -1) {
            if (this.parent.view[a][b] == 10 || this.parent.view[a][b] == 110) {
                this.parent.felfed(a, b);
            } else if (this.parent.view[a][b] != 10 && this.parent.view[a][b] != 11) {
                this.parent.duplakatt(a, b);
            }
        }
    }
}

