/*
 * Decompiled with CFR 0.152.
 */
package akna;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import javax.microedition.lcdui.Form;
import javax.microedition.rms.RecordComparator;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class ScoreBoard
extends Form
implements RecordComparator {
    private RecordStore recordStore = null;

    public int compare(byte[] rec1, byte[] rec2) {
        ByteArrayInputStream bais1 = new ByteArrayInputStream(rec1);
        DataInputStream inputStream1 = new DataInputStream(bais1);
        ByteArrayInputStream bais2 = new ByteArrayInputStream(rec2);
        DataInputStream inputStream2 = new DataInputStream(bais2);
        int score1 = 0;
        int score2 = 0;
        try {
            score1 = inputStream1.readInt();
            score2 = inputStream2.readInt();
        }
        catch (EOFException eofe) {
            System.out.println(eofe);
            eofe.printStackTrace();
        }
        catch (IOException eofe) {
            System.out.println(eofe);
            eofe.printStackTrace();
        }
        if (score1 < score2) {
            return -1;
        }
        if (score1 > score2) {
            return 1;
        }
        return 0;
    }

    public ScoreBoard() {
        super("Results");
        try {
            this.recordStore = RecordStore.openRecordStore((String)"scores", (boolean)true);
        }
        catch (RecordStoreException rse) {
            System.out.println((Object)rse);
            rse.printStackTrace();
        }
    }

    public void addScore(int score, String playerName) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream outputStream = new DataOutputStream(baos);
        try {
            outputStream.writeInt(score);
            outputStream.writeUTF(playerName);
        }
        catch (IOException ioe) {
            System.out.println(ioe);
            ioe.printStackTrace();
        }
        byte[] b = baos.toByteArray();
        try {
            this.recordStore = RecordStore.openRecordStore((String)"scores", (boolean)true);
            this.recordStore.addRecord(b, 0, b.length);
        }
        catch (RecordStoreException rse) {
            System.out.println((Object)rse);
            rse.printStackTrace();
        }
    }

    private void printScoresHelper(RecordEnumeration re) {
        int tmpsize = this.size();
        for (int i = 0; i < tmpsize; ++i) {
            this.delete(0);
        }
        try {
            while (re.hasNextElement()) {
                int id = re.nextRecordId();
                ByteArrayInputStream bais = new ByteArrayInputStream(this.recordStore.getRecord(id));
                DataInputStream inputStream = new DataInputStream(bais);
                try {
                    int score = inputStream.readInt();
                    String playerName = inputStream.readUTF();
                    this.append(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(playerName))).append(" = ").append(score).append("\n"))));
                }
                catch (EOFException eofe) {
                    System.out.println(eofe);
                    eofe.printStackTrace();
                }
            }
        }
        catch (RecordStoreException rse) {
            System.out.println((Object)rse);
            rse.printStackTrace();
        }
        catch (IOException ioe) {
            System.out.println(ioe);
            ioe.printStackTrace();
        }
    }

    public void printScores() {
        try {
            RecordEnumeration re = this.recordStore.enumerateRecords(null, (RecordComparator)this, true);
            this.printScoresHelper(re);
        }
        catch (RecordStoreException rse) {
            System.out.println((Object)rse);
            rse.printStackTrace();
        }
    }

    public void close() {
        try {
            if (this.recordStore != null) {
                this.recordStore.closeRecordStore();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

