/*
 * Decompiled with CFR 0.152.
 */
package tinke.gemgame;

import java.util.Random;
import javax.microedition.lcdui.Graphics;
import tinke.gemgame.GameFullCanvas;

public class Board {
    protected static Random rnd = new Random();
    private final int BOARD_WIDTH;
    private final int BOARD_HEIGHT;
    private int[][] tiles = new int[10][10];
    int multi = 1;

    public Board() {
        this.BOARD_WIDTH = 10;
        this.BOARD_HEIGHT = 10;
        for (int i = 0; i < 10; ++i) {
            for (int j = 0; j < 10; ++j) {
                int n = Math.abs(rnd.nextInt() % 7) + 1;
                while (i > 1 && this.tiles[i - 2][j] == n && this.tiles[i - 1][j] == n || j > 1 && this.tiles[i][j - 2] == n && this.tiles[i][j - 1] == n) {
                    n = Math.abs(rnd.nextInt() % 7) + 1;
                }
                this.tiles[i][j] = n;
            }
        }
    }

    public void draw(Graphics g) {
        for (int i = 0; i < 10; ++i) {
            for (int j = 0; j < 10; ++j) {
                g.drawImage(GameFullCanvas.gems[this.tiles[i][j]], i * 10 + 6, j * 10 + 2, 20);
            }
        }
    }

    public boolean swap(int xMove, int yMove, int xPos, int yPos) {
        int j;
        int i;
        int n = this.tiles[xMove][yMove];
        this.tiles[xMove][yMove] = this.tiles[xPos][yPos];
        this.tiles[xPos][yPos] = n;
        this.multi = 1;
        for (i = 2; i < 10; ++i) {
            for (j = 0; j < 10; ++j) {
                if (this.tiles[i - 2][j] != this.tiles[i - 1][j] || this.tiles[i - 1][j] != this.tiles[i][j]) continue;
                return true;
            }
        }
        for (i = 0; i < 10; ++i) {
            for (j = 2; j < 10; ++j) {
                if (this.tiles[i][j - 2] != this.tiles[i][j - 1] || this.tiles[i][j - 1] != this.tiles[i][j]) continue;
                return true;
            }
        }
        n = this.tiles[xPos][yPos];
        this.tiles[xPos][yPos] = this.tiles[xMove][yMove];
        this.tiles[xMove][yMove] = n;
        return false;
    }

    public int removeGems(GameFullCanvas f) {
        int net = 0;
        int worth = 0;
        boolean removable = true;
        while (removable) {
            this.markHorizontal();
            this.markVertical();
            worth = this.removeMarked(f);
            this.fillBlanks(f);
            if (worth == 0) {
                removable = false;
            } else {
                net += this.multi * worth;
            }
            this.multi *= 2;
        }
        return net;
    }

    public void markHorizontal() {
        for (int i = 2; i < 10; ++i) {
            for (int j = 0; j < 10; ++j) {
                if (this.tiles[i - 2][j] % 10 != this.tiles[i - 1][j] % 10 || this.tiles[i - 1][j] % 10 != this.tiles[i][j] % 10) continue;
                int[] nArray = this.tiles[i - 2];
                int n = j;
                nArray[n] = nArray[n] + 10;
                int[] nArray2 = this.tiles[i - 1];
                int n2 = j;
                nArray2[n2] = nArray2[n2] + 10;
                int[] nArray3 = this.tiles[i];
                int n3 = j;
                nArray3[n3] = nArray3[n3] + 10;
            }
        }
    }

    public void markVertical() {
        for (int i = 0; i < 10; ++i) {
            for (int j = 2; j < 10; ++j) {
                if (this.tiles[i][j - 2] % 10 != this.tiles[i][j - 1] % 10 || this.tiles[i][j - 1] % 10 != this.tiles[i][j] % 10) continue;
                int[] nArray = this.tiles[i];
                int n = j - 2;
                nArray[n] = nArray[n] + 10;
                int[] nArray2 = this.tiles[i];
                int n2 = j - 1;
                nArray2[n2] = nArray2[n2] + 10;
                int[] nArray3 = this.tiles[i];
                int n3 = j;
                nArray3[n3] = nArray3[n3] + 10;
            }
        }
    }

    public int removeMarked(GameFullCanvas f) {
        int s = 0;
        for (int i = 0; i < 10; ++i) {
            for (int j = 0; j < 10; ++j) {
                if (this.tiles[i][j] <= 10) continue;
                s += this.tiles[i][j] / 10 * (this.tiles[i][j] / 10);
                this.tiles[i][j] = 0;
                f.repaint();
            }
        }
        return s;
    }

    public void fillBlanks(GameFullCanvas f) {
        boolean full = false;
        while (!full) {
            int i;
            for (i = 0; i < 10; ++i) {
                for (int j = 8; j > -1; --j) {
                    if (this.tiles[i][j + 1] != 0) continue;
                    for (int k = j; k > -1; --k) {
                        this.tiles[i][k + 1] = this.tiles[i][k];
                        this.tiles[i][k] = 0;
                        f.repaint();
                    }
                }
            }
            full = true;
            for (i = 0; i < 10; ++i) {
                int n;
                if (this.tiles[i][0] != 0) continue;
                full = false;
                this.tiles[i][0] = n = Math.abs(rnd.nextInt() % 7) + 1;
            }
            f.repaint();
        }
    }

    public boolean movesLeft() {
        int a;
        int j;
        int i;
        for (i = 0; i < 7; ++i) {
            for (j = 0; j < 10; ++j) {
                a = this.tiles[i][j];
                if ((this.tiles[i + 1][j] == a || this.tiles[i + 2][j] == a) && this.tiles[i + 3][j] == a) {
                    return true;
                }
                a = this.tiles[j][i];
                if (this.tiles[j][i + 1] != a && this.tiles[j][i + 2] != a || this.tiles[j][i + 3] != a) continue;
                return true;
            }
        }
        for (i = 0; i < 8; ++i) {
            for (j = 0; j < 9; ++j) {
                a = this.tiles[i][j];
                if (this.tiles[i + 1][j] == a && this.tiles[i + 2][j + 1] == a) {
                    return true;
                }
                if (j > 0 && this.tiles[i + 1][j] == a && this.tiles[i + 2][j - 1] == a) {
                    return true;
                }
                if (this.tiles[i + 1][j + 1] == a && (this.tiles[i + 2][j] == a || this.tiles[i + 2][j + 1] == a)) {
                    return true;
                }
                if (j > 0 && this.tiles[i + 1][j - 1] == a && (this.tiles[i + 2][j] == a || this.tiles[i + 2][j - 1] == a)) {
                    return true;
                }
                a = this.tiles[j][i];
                if (this.tiles[j][i + 1] == a && this.tiles[j + 1][i + 2] == a) {
                    return true;
                }
                if (j > 0 && this.tiles[j][i + 1] == a && this.tiles[j - 1][i + 2] == a) {
                    return true;
                }
                if (this.tiles[j + 1][i + 1] == a && (this.tiles[j][i + 2] == a || this.tiles[j + 1][i + 2] == a)) {
                    return true;
                }
                if (j <= 0 || this.tiles[j - 1][i + 1] != a || this.tiles[j][i + 2] != a && this.tiles[j - 1][i + 2] != a) continue;
                return true;
            }
        }
        return false;
    }
}

