/*
 * Decompiled with CFR 0.152.
 */
package tinke.gemgame;

import com.nokia.mid.ui.FullCanvas;
import java.io.IOException;
import java.util.Timer;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import tinke.gemgame.Board;
import tinke.gemgame.EffectsPlayer;
import tinke.gemgame.GemGameMIDlet;
import tinke.gemgame.HighScore;
import tinke.gemgame.MainMenu;
import tinke.gemgame.NameInput;
import tinke.gemgame.Resources;
import tinke.gemgame.SetScore;

public class GameFullCanvas
extends FullCanvas
implements Runnable {
    private GemGameMIDlet parent = null;
    private MainMenu menu = null;
    private SetScore setScore = null;
    private HighScore highScore = null;
    private NameInput nameInput = null;
    private boolean gamePaused = false;
    private Timer timer = null;
    private static final long MILLIS_PER_TICK = 200L;
    private final int WIDTH = this.getWidth();
    private final int HEIGHT = this.getHeight();
    public static Image[] gems;
    public static Image cursor;
    private Board board;
    private int xPos = 0;
    private int yPos = 0;
    private boolean move = false;
    private int xMove = 0;
    private int yMove = 0;
    private long endTime = 0L;
    public boolean noMoreMoves = false;
    private boolean outOfTime = false;
    private boolean gameOver = false;
    private long remainingTime = 90000L;
    protected int hiScore = 0;
    private int score = 0;
    private volatile Thread tickThread = null;
    private EffectsPlayer fx = null;

    public GameFullCanvas(GemGameMIDlet parent, MainMenu menu) {
        this.parent = parent;
        this.fx = new EffectsPlayer(parent);
        this.menu = menu;
        this.setScore = new SetScore();
        this.highScore = new HighScore(parent, menu, this.setScore);
        this.hiScore = this.highScore.getHighScore();
        gems = new Image[8];
        for (int i = 0; i < 8; ++i) {
            try {
                GameFullCanvas.gems[i] = Image.createImage((String)String.valueOf(String.valueOf(new StringBuffer("/image").append(i).append(".png"))));
                continue;
            }
            catch (IOException e) {
                System.out.println(String.valueOf(String.valueOf(new StringBuffer("Gem image 'image").append(i).append(".png' not found."))));
            }
        }
        this.board = new Board();
        this.fx.playStart();
        this.start();
    }

    synchronized void start() {
        this.tickThread = new Thread(this);
        this.tickThread.start();
        this.endTime = System.currentTimeMillis() + this.remainingTime;
    }

    synchronized void stop() {
        this.tickThread = null;
    }

    public void run() {
        Thread currentThread = Thread.currentThread();
        try {
            while (currentThread == this.tickThread) {
                long startTime = System.currentTimeMillis();
                this.repaint(0, 0, this.WIDTH, this.HEIGHT);
                this.serviceRepaints();
                long timeTaken = System.currentTimeMillis() - startTime;
                if (timeTaken < 200L) {
                    GameFullCanvas gameFullCanvas = this;
                    synchronized (gameFullCanvas) {
                        this.wait(200L - timeTaken);
                    }
                } else {
                    Thread.yield();
                }
                if (System.currentTimeMillis() <= this.endTime || this.gameOver) continue;
                this.gameOver = true;
                this.outOfTime = true;
                this.fx.vibrate(100, 2000);
                this.fx.playGameOver();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void paint(Graphics g) {
        this.drawBackground(g);
        this.board.draw(g);
        this.drawScore(g);
        this.drawCursor(g);
        if (this.outOfTime) {
            g.setColor(0, 0, 0);
            g.fillRect(this.WIDTH / 2 - 48, this.HEIGHT / 2 - 18, 96, 20);
            g.setFont(Font.getFont((int)32, (int)1, (int)0));
            g.setColor(255, 0, 0);
            g.drawString(Resources.getString(21), this.WIDTH / 2, this.HEIGHT / 2, 33);
            this.stop();
        }
        if (this.noMoreMoves) {
            g.setColor(0, 0, 0);
            g.fillRect(this.WIDTH / 2 - 48, this.HEIGHT / 2 - 18, 96, 20);
            g.setFont(Font.getFont((int)32, (int)1, (int)0));
            g.setColor(255, 0, 0);
            g.drawString(Resources.getString(22), this.WIDTH / 2, this.HEIGHT / 2, 33);
            this.stop();
        }
    }

    public void keyPressed(int keyCode) {
        block20: {
            if (this.gameOver) {
                this.chooseScreen();
            }
            if (!this.gameOver) {
                switch (this.getGameAction(keyCode)) {
                    case 1: {
                        --this.yPos;
                        if (this.yPos >= 0) break;
                        this.yPos = 9;
                        break;
                    }
                    case 6: {
                        ++this.yPos;
                        if (this.yPos <= 9) break;
                        this.yPos = 0;
                        break;
                    }
                    case 2: {
                        --this.xPos;
                        if (this.xPos >= 0) break;
                        this.xPos = 9;
                        break;
                    }
                    case 5: {
                        ++this.xPos;
                        if (this.xPos <= 9) break;
                        this.xPos = 0;
                        break;
                    }
                    case 8: {
                        if (!this.move) {
                            this.xMove = this.xPos;
                            this.yMove = this.yPos;
                            this.move = true;
                            break;
                        }
                        if (this.xPos == this.xMove && this.yPos == this.yMove) {
                            this.move = false;
                            break;
                        }
                        if (Math.abs(this.xPos - this.xMove) == 1 && Math.abs(this.yPos - this.yMove) == 0 || Math.abs(this.yPos - this.yMove) == 1 && Math.abs(this.xPos - this.xMove) == 0) {
                            if (this.board.swap(this.xMove, this.yMove, this.xPos, this.yPos)) {
                                int sc = this.board.removeGems(this);
                                if (sc < 20) {
                                    this.fx.vibrate(25, 50);
                                    this.fx.playPoints();
                                } else if (sc < 100) {
                                    this.fx.vibrate(50, 250);
                                    this.fx.playTwentyPoints();
                                } else {
                                    this.fx.vibrate(75, 1000);
                                    this.fx.playHundredPoints();
                                }
                                this.endTime += (long)3000;
                                this.score += sc;
                                if (this.score > this.hiScore) {
                                    this.hiScore = this.score;
                                }
                                if (!this.board.movesLeft() && !this.gameOver) {
                                    this.gameOver = true;
                                    this.noMoreMoves = true;
                                    this.fx.vibrate(100, 2000);
                                    this.fx.playGameOver();
                                }
                            } else {
                                this.fx.playNoMove();
                            }
                        }
                        this.move = false;
                        break;
                    }
                }
            }
            if (keyCode != -6 && keyCode != -7 || this.gameOver) break block20;
            this.pauseGame();
        }
    }

    public void keyRepeated(int keyCode) {
        switch (this.getGameAction(keyCode)) {
            case 1: {
                --this.yPos;
                if (this.yPos >= 0) break;
                this.yPos = 9;
                break;
            }
            case 6: {
                ++this.yPos;
                if (this.yPos <= 9) break;
                this.yPos = 0;
                break;
            }
            case 2: {
                --this.xPos;
                if (this.xPos >= 0) break;
                this.xPos = 9;
                break;
            }
            case 5: {
                ++this.xPos;
                if (this.xPos <= 9) break;
                this.xPos = 0;
                break;
            }
        }
    }

    public void drawBackground(Graphics g) {
        int k = (int)(this.endTime - System.currentTimeMillis());
        if (k > 0 && k < 5000) {
            g.setColor(k % 250, k % 250, k % 250);
            g.fillRect(0, 0, this.WIDTH, this.HEIGHT);
        } else {
            g.setColor(0, 0, 0);
            g.fillRect(0, 0, this.WIDTH, this.HEIGHT);
            for (int i = 0; i < 16; ++i) {
                g.setColor(0, 0, i * 16);
                g.fillRect(0, i * 8, this.WIDTH, 8);
            }
        }
    }

    public void drawScore(Graphics g) {
        g.setFont(Font.getFont((int)32, (int)1, (int)8));
        g.setColor(255, 255, 0);
        g.drawString(Resources.getString(19), 2, 104, 20);
        g.drawString(Resources.getString(20), 64, 104, 20);
        g.setColor(255, 255, 255);
        g.drawString(Integer.toString(this.hiScore), 126, 126, 40);
        if (!this.gameOver) {
            g.setFont(Font.getFont((int)32, (int)1, (int)8));
            g.drawString(Integer.toString((int)((this.endTime - System.currentTimeMillis()) / (long)1000)), 126, 10, 24);
        }
        g.setFont(Font.getFont((int)32, (int)1, (int)0));
        g.drawString(Integer.toString(this.score), 60, 128, 40);
    }

    public void drawCursor(Graphics g) {
        g.setColor(255, 255, 255);
        g.drawRect(this.xPos * 10 + 5, this.yPos * 10 + 1, 10, 10);
        g.drawRect(this.xPos * 10 + 6, this.yPos * 10 + 2, 8, 8);
        if (this.move) {
            g.setColor(255, 255, 0);
            g.drawRect(this.xMove * 10 + 5, this.yMove * 10 + 1, 10, 10);
            g.drawRect(this.xMove * 10 + 6, this.yMove * 10 + 2, 8, 8);
        }
    }

    public void gameContinue() {
        this.gamePaused = false;
        this.start();
    }

    public boolean isPaused() {
        return this.gamePaused;
    }

    public void pauseGame() {
        this.gamePaused = true;
        this.remainingTime = this.endTime - System.currentTimeMillis();
        this.stop();
        this.menu.init(this.parent);
        this.parent.setDisplayable((Displayable)this.menu);
    }

    public void chooseScreen() {
        int i = this.setScore.compareRecord(this.score);
        if (i == 0) {
            this.parent.setDisplayable((Displayable)this.highScore);
        } else {
            this.nameInput = new NameInput(this.parent, this.setScore, this.score, i);
            this.fx.playHighScore();
            this.parent.setDisplayable((Displayable)this.nameInput);
        }
    }

    public void hideNotify() {
        if (!this.gameOver) {
            this.pauseGame();
        }
    }

    public void showNotify() {
    }

    static {
        MILLIS_PER_TICK = 200L;
    }
}

