/*
 * Decompiled with CFR 0.152.
 */
package msame;

import java.util.Random;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import msame.Arena;
import msame.BlockColour;

public class SameCanvas
extends Canvas {
    Display display;
    private static final int FLAVOURS = 5;
    int xSize;
    int ySize;
    int width;
    int height;
    int hspace;
    int vspace;
    int slength;
    int hindent;
    int vindent;
    int cposX;
    int cposY;
    int points = 0;
    int gPoints = 0;
    Arena theArena;
    boolean noMoreMoves = false;
    Random rnd = new Random();

    public SameCanvas(Display display, int n, int n2) {
        this.display = display;
        this.width = this.getWidth();
        this.height = this.getHeight();
        if (n != 0 || n2 != 0) {
            this.xSize = n;
            this.ySize = n2;
        }
        this.hspace = (this.width - 2) / n;
        this.vspace = (this.height - 2) / n2;
        if (this.hspace < this.vspace) {
            this.vspace = this.hspace;
        } else {
            this.hspace = this.vspace;
        }
        this.hindent = (this.width - this.hspace * this.xSize) / 2;
        this.vindent = this.height - this.vspace * this.ySize - 1;
        this.theArena = new Arena(n, n2);
        this.cposX = this.xSize / 2;
        this.cposY = this.ySize / 2;
    }

    void destroy() {
        this.theArena = null;
    }

    boolean isPaused() {
        return false;
    }

    public void keyPressed(int n) {
        int n2 = this.getGameAction(n);
        if (!this.noMoreMoves) {
            switch (n2) {
                case 2: {
                    if (this.cposX <= 0) break;
                    --this.cposX;
                    break;
                }
                case 5: {
                    if (this.cposX >= this.xSize - 1) break;
                    ++this.cposX;
                    break;
                }
                case 1: {
                    if (this.cposY <= 0) break;
                    --this.cposY;
                    break;
                }
                case 6: {
                    if (this.cposY >= this.ySize - 1) break;
                    ++this.cposY;
                    break;
                }
                case 8: {
                    this.points = this.theArena.removeBlock(this.cposX, this.cposY, true);
                    this.gPoints += this.points;
                    if (this.theArena.hasMoves) break;
                    this.noMoreMoves = true;
                }
            }
            this.repaint();
        }
    }

    protected void paint(Graphics graphics) {
        graphics.setColor(0);
        graphics.fillRect(0, 0, this.width - 1, this.height - 1);
        graphics.setColor(0);
        graphics.drawRect(this.hindent, this.vindent, this.width - 1 - this.hindent, this.height - 1 - this.vindent);
        int n = 0;
        while (n < this.ySize) {
            int n2 = 0;
            while (n2 < this.xSize) {
                graphics.setColor(BlockColour.getRGBColour(this.theArena.getBlock(n2, n).getColour()));
                graphics.fillRect(this.hindent + n2 * this.hspace, this.vindent + n * this.vspace, this.hspace, this.vspace);
                ++n2;
            }
            ++n;
        }
        graphics.setColor(0);
        if (this.theArena.getBlock(this.cposX, this.cposY).getColour() == 0) {
            graphics.setColor(0xFFFFFF);
        }
        graphics.drawRect(this.hindent + this.hspace * this.cposX, this.vindent + this.vspace * this.cposY, this.hspace - 1, this.vspace - 1);
        graphics.setColor(0xFFFFFF);
        graphics.drawString("Score: " + Integer.toString(this.gPoints), 1, 0, 0);
        if (this.noMoreMoves) {
            graphics.setColor(0xFFFFFF);
            graphics.fillRect(this.width / 2 - 21, this.height / 2 - 10, 42, 20);
            graphics.setColor(0);
            graphics.drawRect(this.width / 2 - 21, this.height / 2 - 10, 42, 20);
            graphics.drawString("No more", this.width / 2 - 19, this.height / 2 - 12, 0);
            graphics.drawString("moves!", this.width / 2 - 16, this.height / 2 - 3, 0);
        }
    }

    void pause() {
    }

    void start() {
        this.display.setCurrent((Displayable)this);
        this.repaint();
    }
}

