/*
 * Decompiled with CFR 0.152.
 */
package msame;

import java.util.Random;
import msame.Block;
import msame.BlockColour;

public class Arena {
    private static final int FLAVOURS = 5;
    private int aBreite;
    private int breite;
    private int hoehe;
    private int tempPoints = 0;
    public boolean hasMoves = false;
    public boolean undoable = false;
    private BlockColour bc;
    private int[][] letzterStand;
    private Block[][] playField;

    public Arena(int n, int n2) {
        Random random = new Random();
        this.aBreite = n;
        this.breite = n;
        this.hoehe = n2;
        this.letzterStand = new int[n][n2];
        this.playField = new Block[n][n2];
        int n3 = 0;
        while (n3 < this.hoehe) {
            int n4 = 0;
            while (n4 < this.breite) {
                int n5 = 1 + Math.abs(random.nextInt() % 5);
                this.playField[n4][n3] = new Block(n4, n3, n5);
                ++n4;
            }
            ++n3;
        }
        this.update();
    }

    public Block getBlock(int n, int n2) {
        return this.playField[n][n2];
    }

    private boolean possibleMove(int n, int n2) {
        boolean bl = false;
        int n3 = this.playField[n][n2].getColour();
        if (n3 != 0) {
            if (n < this.breite - 1 && this.playField[n + 1][n2].getColour() == n3) {
                bl = true;
            }
            if (n > 0 && this.playField[n - 1][n2].getColour() == n3) {
                bl = true;
            }
            if (n2 < this.hoehe - 1 && this.playField[n][n2 + 1].getColour() == n3) {
                bl = true;
            }
            if (n2 > 0 && this.playField[n][n2 - 1].getColour() == n3) {
                bl = true;
            }
            if (bl) {
                this.hasMoves = true;
            }
        }
        return bl;
    }

    private void recursiveDelete(int n, int n2, int n3, boolean bl) {
        if (n >= 0 && n < this.breite && n2 >= 0 && n2 < this.hoehe && this.playField[n][n2].getColour() == n3 && (!this.playField[n][n2].isHit() || bl)) {
            this.playField[n][n2].hitIt();
            if (bl) {
                this.playField[n][n2].setColour(0);
                this.playField[n][n2].unhitIt();
            }
            ++this.tempPoints;
            this.recursiveDelete(n + 1, n2, n3, bl);
            this.recursiveDelete(n, n2 + 1, n3, bl);
            this.recursiveDelete(n - 1, n2, n3, bl);
            this.recursiveDelete(n, n2 - 1, n3, bl);
        }
    }

    public int removeBlock(int n, int n2, boolean bl) {
        this.tempPoints = 0;
        if (this.possibleMove(n, n2)) {
            int n3 = this.playField[n][n2].getColour();
            if (bl) {
                this.save();
            }
            this.tempPoints = 0;
            this.recursiveDelete(n, n2, n3, bl);
            if (bl) {
                this.update();
            }
        }
        return this.tempPoints;
    }

    public void save() {
        int n = 0;
        while (n < this.aBreite) {
            int n2 = 0;
            while (n2 < this.hoehe) {
                this.letzterStand[n][n2] = this.playField[n][n2].getColour();
                ++n2;
            }
            ++n;
        }
        this.undoable = true;
    }

    private void scrollDown(int n, int n2) {
        int n3 = n2;
        while (n3 > 0) {
            this.playField[n][n3].setColour(this.playField[n][n3 - 1].getColour());
            this.playField[n][n3].setHit(this.playField[n][n3 - 1].getHit());
            --n3;
        }
        this.playField[n][0].setColour(0);
        this.playField[n][0].unhitIt();
    }

    private void scrollLeft(int n, int n2) {
        int n3 = n;
        while (n3 < this.breite - 1) {
            this.playField[n3][n2].setColour(this.playField[n3 + 1][n2].getColour());
            this.playField[n3][n2].setHit(this.playField[n3 + 1][n2].getHit());
            ++n3;
        }
        this.playField[this.breite - 1][n2].setColour(0);
        this.playField[this.breite - 1][n2].unhitIt();
    }

    public String toString() {
        String string = new String("------------------------------\n");
        int n = 0;
        while (n < this.hoehe) {
            string = String.valueOf(string) + "[" + n + "]";
            int n2 = 0;
            while (n2 < this.breite) {
                string = String.valueOf(string) + String.valueOf(this.playField[n2][n].getColour());
                ++n2;
            }
            string = String.valueOf(string) + "\n";
            ++n;
        }
        string = String.valueOf(string) + "------------------------------";
        return string;
    }

    public void undo() {
        if (this.undoable) {
            int n = 0;
            while (n < this.aBreite) {
                int n2 = 0;
                while (n2 < this.hoehe) {
                    this.playField[n][n2].setColour(this.letzterStand[n][n2]);
                    this.playField[n][n2].unhitIt();
                    ++n2;
                }
                ++n;
            }
            this.undoable = false;
        }
    }

    public void update() {
        int n;
        int n2;
        int n3 = 0;
        while (n3 < this.breite) {
            boolean bl = true;
            n2 = 0;
            while (n2 < this.hoehe) {
                if (this.playField[n3][n2].isSolid()) {
                    bl = false;
                }
                ++n2;
            }
            if (bl) {
                n = 0;
                while (n < this.hoehe) {
                    this.scrollLeft(n3, n);
                    ++n;
                }
                --this.breite;
                --n3;
            }
            ++n3;
        }
        n2 = 0;
        while (n2 < this.breite) {
            n = 0;
            while (n < this.hoehe) {
                if (this.playField[n2][n].getColour() == 0) {
                    this.scrollDown(n2, n);
                }
                if (this.playField[n2][n].isHit()) {
                    this.playField[n2][n].unhitIt();
                }
                ++n;
            }
            ++n2;
        }
        this.hasMoves = false;
        n = 0;
        while (n < this.breite && !this.hasMoves) {
            int n4 = this.hoehe - 1;
            while (n4 > 0 && !this.hasMoves) {
                this.possibleMove(n, n4);
                --n4;
            }
            ++n;
        }
    }
}

