/*
 * Decompiled with CFR 0.152.
 */
package com.lunagames.atc;

import com.lunagames.atc.Airplane;
import com.lunagames.atc.PhysicsObject;
import com.lunagames.dig.DigGame;
import java.io.DataInputStream;
import java.io.DataOutputStream;

public final class AtcGame
extends DigGame {
    private boolean m_helpSkipped;
    static final int VIEW_MAIN = 100;
    static final int VIEW_PRELEVEL = 101;
    static final int VIEW_COMPLETED = 133;
    static final int VIEW_LOST = 111;
    static final int VIEW_CRASH = 122;
    static final int VIEW_LEVEL = 105;
    static final int VIEW_HELP = 148;
    static final int VIEW_PRACTICE = 149;
    static final int VIEW_EXIT = 150;
    static final int VIEW_HOLD = 151;
    static final int MAX_PLAINS = 14;
    static final int FLASH_OBJECT_TIME = 5000;
    static final int EXIT_BOX_SIZE = 10;
    static final int INNER_PLANE_BOX = 4;
    static final int LIGHT_SPEED = 600;
    static final int BUSYX = 60;
    static final int BUSYY = 66;
    static final int BUSYHEIGHT = 10;
    static final int SEL_BUSYX = 56;
    static final int SEL_BUSYY = 69;
    static final int SEL2_BUSYX = 111;
    static final int SEL2_BUSYY = 69;
    static final int SEL_LEVELX = 56;
    static final int SEL_LEVELY = 54;
    static final int SEL2_LEVELX = 111;
    static final int SEL2_LEVELY = 54;
    static final int MENU_LEFT = 10;
    static final int MENU_OFFSET = 9;
    static final int MENU_HEIGHT = 12;
    static final int MENU_SPACE = 0;
    static final int MENU_WIDTH = 48;
    static final int MENU_XOFFSET_LEVELTXT = 62;
    static final int MENU_YOFFSET_LEVELTXT = 49;
    static final int MENU_YOFFSET_LEVELTXT2 = 88;
    static final int IMG_FIRST_EXIT = 16;
    static final int IMG_FIRST_PLANE = 0;
    static final int IMG_FIRST_HELP = 22;
    static final int IMG_MENU_HOLD = 21;
    static final int SOUND_MUSIC = 0;
    static final int SOUND_NEW = 1;
    static final int SOUND_WARNING = 2;
    static final int IMG_CRASH_POPUP = 31;
    static final int IMG_LOST_POPUP = 30;
    static final int POPUP_TIME = 3000;
    long m_popupTm;
    int m_popUp;
    Airplane m_planePopUp;
    static int m_levelTick;
    long m_levelTm;
    long m_spare;
    int m_newPlaneInterval;
    int m_newDepartureInterval;
    long m_newPlainTm;
    long m_newDepartureTm;
    int m_baseSpeed;
    int m_planesDone;
    int m_planesLost;
    int m_planesCrashed;
    int m_level = 1;
    int m_maxLevel = 1;
    int m_practiceLevel = 10;
    int m_planeToDo;
    boolean m_practice;
    boolean m_soundOn = true;
    boolean m_planeInWarning;
    boolean m_warningSoundDone;
    int m_selected;
    Airplane[] m_plains;
    int m_enum;
    int m_rw_x;
    int m_rw_y;
    int m_rw_w;
    int m_rw_h;
    int m_landbox_x;
    int m_landbox_y;
    int m_landbox_x2;
    int m_landbox_y2;
    int m_rw2_x;
    int m_rw2_y;
    long m_rwLightsTm;
    int m_rwLightsTick;
    int m_displaySize;
    boolean m_levelLoaded;
    boolean m_help;
    int m_helpStep;
    long m_helpStepTm;
    long m_helpActionTm;
    int m_helpx;
    int m_helpy;
    int m_helpbox;
    boolean m_helpStepDone;

    int getTickerTime() {
        return 500;
    }

    public void initSpeedAndTimers(int level) {
        this.m_baseSpeed = 900 + level * 8;
        this.m_newPlaneInterval = 44000 - level * 380;
        this.m_newDepartureInterval = 70000 - level * 450;
        if (this.m_newPlaneInterval < 6000) {
            this.m_newPlaneInterval = 6000;
        }
        if (this.m_newDepartureInterval < 25000) {
            this.m_newDepartureInterval = 25000;
        }
    }

    public void initLevel(int level) {
        if (level == 1) {
            this.m_planeToDo = 3;
        }
        if (level == 2) {
            this.m_planeToDo = 5;
        }
        if (level == 3) {
            this.m_planeToDo = 10;
        }
        if (level > 3 && level <= 10) {
            this.m_planeToDo = 20;
        }
        if (level > 10 && level <= 20) {
            this.m_planeToDo = 25;
        }
        if (level > 20 && level <= 30) {
            this.m_planeToDo = 30;
        }
        if (level > 30) {
            this.m_planeToDo = 40;
        }
        if (level >= 100) {
            this.m_planeToDo = 100;
        }
        this.initSpeedAndTimers(level);
        this.clearPlains();
        this.m_selected = -1;
        m_levelTick = this.getTickerTime();
        this.m_levelTm = 0L;
        this.m_newPlainTm = 0L;
        this.m_newDepartureTm = System.currentTimeMillis() + (long)this.m_newDepartureInterval;
        this.m_planesDone = 0;
        this.m_planesLost = 0;
        this.m_planesCrashed = 0;
        this.m_rwLightsTm = 0L;
        this.m_planeInWarning = false;
        this.m_warningSoundDone = true;
        this.m_practice = false;
        this.m_help = false;
    }

    public void initPractice(int level) {
        this.initLevel(level);
        this.initSpeedAndTimers(level);
        this.m_planeToDo = 1000;
        this.m_practice = true;
    }

    public void initHelp() {
        this.initLevel(1);
        this.initSpeedAndTimers(1);
        this.m_planeToDo = 1000;
        this.clearPlains();
        this.m_selected = -1;
        m_levelTick = 100;
        this.m_levelTm = 0L;
        this.m_newPlainTm = 0L;
        this.m_newDepartureTm = System.currentTimeMillis() + (long)this.m_newDepartureInterval;
        this.m_planesDone = 0;
        this.m_planesLost = 0;
        this.m_planesCrashed = 0;
        this.m_practice = true;
        this.m_help = true;
        this.m_helpStep = 0;
        this.m_helpStepTm = 0L;
        this.m_helpActionTm = 0L;
        this.m_helpx = 0;
        this.m_helpy = 0;
        this.m_helpbox = -1;
        this.m_helpStepDone = false;
        this.m_helpSkipped = false;
    }

    public void clearPlains() {
        int i = 0;
        while (i < 14) {
            this.m_plains[i].setActive(false);
            ++i;
        }
    }

    public void initPlains() {
        this.m_plains = new Airplane[14];
        int i = 0;
        while (i < 14) {
            this.m_plains[i] = new Airplane();
            this.m_plains[i].setActive(false);
            ++i;
        }
    }

    public int addPlain() {
        int i = 0;
        while (i < 14) {
            if (!this.m_plains[i].isActive()) {
                this.m_plains[i].reset();
                return i;
            }
            ++i;
        }
        return -1;
    }

    public Airplane getPlain(int ndx) {
        if (ndx >= 0 && ndx < 14) {
            if (this.m_plains[ndx].isActive()) {
                return this.m_plains[ndx];
            }
            return null;
        }
        return null;
    }

    public void removePlain(int ndx) {
        if (ndx == this.m_selected) {
            this.m_selected = -1;
        }
        this.m_plains[ndx].setActive(false);
    }

    public int enumPlains() {
        this.m_enum = 14;
        this.m_enum = this.enumNextPlain();
        return this.m_enum;
    }

    public int enumNextPlain() {
        if (this.m_enum > 0) {
            int i = this.m_enum - 1;
            while (i >= 0) {
                if (this.m_plains[i].isActive()) {
                    this.m_enum = i;
                    return i;
                }
                --i;
            }
        }
        this.m_enum = -1;
        return this.m_enum;
    }

    public void clearSelection() {
        this.m_selected = -1;
    }

    public void selectNext() {
        int i = this.m_selected + 1;
        while (i < 14) {
            if (this.m_plains[i].isActive() && this.m_plains[i].getState() == 0) {
                this.m_selected = i;
                return;
            }
            ++i;
        }
        i = 0;
        while (i < this.m_selected) {
            if (this.m_plains[i].isActive() && this.m_plains[i].getState() == 0) {
                this.m_selected = i;
                return;
            }
            ++i;
        }
    }

    public void selectPrevious() {
        int i = this.m_selected - 1;
        while (i >= 0) {
            if (this.m_plains[i].isActive() && this.m_plains[i].getState() == 0) {
                this.m_selected = i;
                return;
            }
            --i;
        }
        i = 13;
        while (i > this.m_selected) {
            if (this.m_plains[i].isActive() && this.m_plains[i].getState() == 0) {
                this.m_selected = i;
                return;
            }
            --i;
        }
    }

    public int getSelected() {
        return this.m_selected;
    }

    public Airplane getSelectedPlane() {
        return this.getPlain(this.getSelected());
    }

    public void addRandomPlain() {
        int rnd = this.getRandom(8);
        int coordW = PhysicsObject.getWorldScale() / 4;
        int coordH = PhysicsObject.screenToWorld(this.getDisplayHeight()) / 4;
        int x = 0;
        int y = 0;
        int d = 0;
        int exit = this.getRandom(5) + 16;
        switch (rnd) {
            case 0: {
                x = coordW;
                y = 0;
                d = 180;
                if (exit != 16) break;
                exit = 20;
                break;
            }
            case 1: {
                x = coordW * 3;
                y = 0;
                d = 180;
                if (exit != 16) break;
                exit = 20;
                break;
            }
            case 2: {
                x = PhysicsObject.getWorldScale();
                y = coordH;
                d = 270;
                if (exit != 17) break;
                exit = 20;
                break;
            }
            case 3: {
                x = PhysicsObject.getWorldScale();
                y = coordH * 3;
                d = 270;
                if (exit != 17) break;
                exit = 20;
                break;
            }
            case 4: {
                x = coordW * 3;
                y = PhysicsObject.screenToWorld(this.getDisplayHeight());
                d = 0;
                if (exit != 18) break;
                exit = 20;
                break;
            }
            case 5: {
                x = coordW;
                y = PhysicsObject.screenToWorld(this.getDisplayHeight());
                d = 0;
                if (exit != 18) break;
                exit = 20;
                break;
            }
            case 6: {
                x = 0;
                y = coordH * 3;
                d = 90;
                if (exit != 19) break;
                exit = 20;
                break;
            }
            case 7: {
                x = 0;
                y = coordH;
                d = 90;
                if (exit != 19) break;
                exit = 20;
            }
        }
        int p = this.addPlain();
        if (p != -1) {
            Airplane plain = this.getPlain(p);
            plain.setX(x);
            plain.setY(y);
            plain.setDirection(d);
            plain.setDestination(exit);
            this.planeStartFlight(plain);
        }
    }

    public void addDeparture() {
        int x = 0;
        int y = 0;
        int d = 0;
        x = PhysicsObject.screenToWorld(this.m_rw2_x + 2);
        y = PhysicsObject.screenToWorld(this.m_rw2_y + 1);
        d = 90;
        int p = this.addPlain();
        if (p != -1) {
            Airplane plain = this.getPlain(p);
            plain.setX(x);
            plain.setY(y);
            plain.setDirection(d);
            plain.setDestination(this.getRandom(5) + 16);
            if (plain.getDestination() == 20) {
                plain.setDestination(17);
            }
            plain.startTaxiout();
        }
    }

    public static int getSpeedMultiplier() {
        return m_levelTick / 100;
    }

    int getLevelFlightSpeed() {
        return this.m_baseSpeed * AtcGame.getSpeedMultiplier();
    }

    void playGameSound(int snd) {
        if (this.m_soundOn) {
            if (snd == 0) {
                if (this.isSupported(4)) {
                    this.playSound(-1, 0);
                } else if (this.isSupported(3) && (this.getCurrentView() == 100 || this.getCurrentView() == 133)) {
                    this.playSound(1, 0);
                }
            }
            if (snd == 1) {
                this.playSound(1, 1);
            }
            if (snd == 2) {
                this.playSound(1, 2);
            }
        }
    }

    protected boolean onSample() {
        if (this.m_levelLoaded && (this.getCurrentView() == 105 || this.getCurrentView() == 148)) {
            if (this.m_levelTm < System.currentTimeMillis()) {
                if (this.m_popupTm == 0L) {
                    this.m_levelTm = System.currentTimeMillis() + (long)m_levelTick;
                    int n = this.enumPlains();
                    while (n != -1) {
                        Airplane p = this.getPlain(n);
                        p.calcPhysics();
                        p.setWarning(false);
                        switch (p.getState()) {
                            case 0: {
                                this.sampleFlightState(p);
                                break;
                            }
                            case 3: {
                                this.sampleExitState(p);
                                break;
                            }
                            case 6: {
                                this.sampleTakeoffDoneState(p);
                                break;
                            }
                            case 1: {
                                this.sampleTaxiinState(p);
                            }
                        }
                        n = this.enumNextPlain();
                    }
                    this.checkCollisionsAndLost();
                    if (!this.isFlashed()) {
                        this.m_warningSoundDone = false;
                    }
                    if (this.m_planeInWarning && !this.m_warningSoundDone) {
                        this.playGameSound(2);
                        this.m_warningSoundDone = true;
                    }
                    if (this.getCurrentView() == 105) {
                        if (this.m_newPlainTm < System.currentTimeMillis()) {
                            this.m_newPlainTm = System.currentTimeMillis() + (long)this.m_newPlaneInterval;
                            this.addRandomPlain();
                        }
                        if (this.m_newDepartureTm < System.currentTimeMillis()) {
                            this.m_newDepartureTm = System.currentTimeMillis() + (long)this.m_newDepartureInterval;
                            this.addDeparture();
                        }
                    } else if (this.getCurrentView() == 148) {
                        this.sampleHelp();
                    }
                }
            } else {
                try {
                    this.m_spare = this.m_levelTm - System.currentTimeMillis();
                    Thread.sleep(this.m_spare);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return true;
    }

    private void sampleTakeoffDoneState(Airplane p) {
        this.planeStartFlight(p);
    }

    private void sampleTaxiinState(Airplane p) {
        if (p.getTimeInState() > 5000L) {
            this.planeLanded(p);
        }
    }

    private void sampleExitState(Airplane p) {
        if (p.getTimeInState() > 5000L) {
            this.planeExit(p);
        }
    }

    private void sampleFlightState(Airplane p) {
        if (p.getDestination() == 20 && p.getDirection() == 0 && p.getDisplayX() >= this.m_landbox_x && p.getDisplayX() <= this.m_landbox_x2 && p.getDisplayY() >= this.m_landbox_y && p.getDisplayY() <= this.m_landbox_y2) {
            this.planeStartLanding(p);
        }
        int i = 0;
        while (i < 4) {
            if (p.getDestination() == 16 + i && this.isPlaneInExit(p, 16 + i)) {
                p.startExit();
            }
            ++i;
        }
    }

    void sampleHelp() {
        if (!this.m_helpStepDone) {
            this.m_helpStepDone = true;
            switch (this.m_helpStep) {
                case 0: {
                    int p = this.addPlain();
                    Airplane plain = this.getPlain(p);
                    plain.setX(PhysicsObject.screenToWorld(this.getDisplaySize() - 10));
                    plain.setY(PhysicsObject.screenToWorld(this.getDisplaySize() - 20));
                    plain.setDirection(270);
                    plain.setDestination(16);
                    plain.setSpeed(550 * AtcGame.getSpeedMultiplier());
                    p = this.addPlain();
                    plain = this.getPlain(p);
                    plain.setX(PhysicsObject.screenToWorld(this.getDisplaySize() >> 1));
                    plain.setY(PhysicsObject.screenToWorld(this.getDisplaySize() - 10));
                    plain.setDirection(0);
                    plain.setDestination(20);
                    plain.setSpeed(550 * AtcGame.getSpeedMultiplier());
                    break;
                }
                case 1: {
                    this.m_helpbox = 22;
                    this.m_helpx = (this.getDisplaySize() >> 1) - (this.getImageWidth(this.m_helpbox, 0) >> 1);
                    this.m_helpy = (this.getDisplaySize() >> 1) - (this.getImageHeight(this.m_helpbox, 0) >> 1);
                    this.m_helpStepTm = System.currentTimeMillis() + 10000L;
                    break;
                }
                case 2: {
                    this.m_helpbox = 23;
                    this.m_helpx = this.getDisplaySize() - this.getImageWidth(this.m_helpbox, 0) - 1;
                    this.m_helpy = this.getDisplaySize() - this.getImageHeight(this.m_helpbox, 0);
                    this.m_helpStepTm = System.currentTimeMillis() + 10000L;
                    break;
                }
                case 3: {
                    this.m_helpbox = 24;
                    this.m_helpx = this.getDisplaySize() - this.getImageWidth(this.m_helpbox, 0) - 1;
                    this.m_helpy = 1;
                    this.m_helpStepTm = System.currentTimeMillis() + 10000L;
                    this.selectNext();
                    break;
                }
                case 4: {
                    this.m_helpbox = 25;
                    this.m_helpx = this.getDisplaySize() - this.getImageWidth(this.m_helpbox, 0) - 1;
                    this.m_helpy = 1;
                    this.m_helpStepTm = System.currentTimeMillis() + 10000L;
                    ++this.m_helpStep;
                    this.m_helpStepDone = false;
                    break;
                }
                case 5: {
                    this.m_helpStepDone = false;
                    if (this.m_helpActionTm >= System.currentTimeMillis()) break;
                    this.m_helpActionTm = System.currentTimeMillis() + 2200L;
                    this.selectNext();
                    break;
                }
                case 6: {
                    this.m_helpbox = 26;
                    this.m_helpx = this.getDisplaySize() - this.getImageWidth(this.m_helpbox, 0) - 1;
                    this.m_helpy = 1;
                    this.m_helpStepTm = System.currentTimeMillis() + 15200L;
                    ++this.m_helpStep;
                    this.m_helpStepDone = false;
                    break;
                }
                case 7: {
                    this.m_helpStepDone = false;
                    if (this.m_helpSkipped) {
                        Airplane ap = this.getSelectedPlane();
                        this.selectNext();
                        Airplane ap2 = this.getSelectedPlane();
                        if (ap.getX() < ap2.getX()) {
                            this.selectNext();
                        }
                    }
                    if (this.m_helpActionTm >= System.currentTimeMillis()) break;
                    this.getSelectedPlane().rotate(45);
                    this.m_helpActionTm = System.currentTimeMillis() + 2500L;
                    break;
                }
                case 8: {
                    int n = this.enumPlains();
                    while (n != -1) {
                        this.getPlain(n).setSpeed(1200 * AtcGame.getSpeedMultiplier());
                        n = this.enumNextPlain();
                    }
                    if (this.getSelectedPlane().getDirection() != 270) {
                        this.getSelectedPlane().setDirection(270);
                    }
                    this.m_helpbox = 27;
                    this.m_helpx = this.getDisplaySize() - this.getImageWidth(this.m_helpbox, 0) - 1;
                    this.m_helpy = 1;
                    this.m_helpStepTm = System.currentTimeMillis() + 25000L;
                    ++this.m_helpStep;
                    this.m_helpStepDone = false;
                    break;
                }
                case 9: {
                    this.m_helpStepDone = false;
                    Airplane ap = this.getSelectedPlane();
                    if (ap == null || ap.getDisplayX() >= this.m_landbox_x2 || this.m_helpActionTm >= System.currentTimeMillis() || ap.getDirection() == 0) break;
                    this.getSelectedPlane().rotate(45);
                    this.m_helpActionTm = System.currentTimeMillis() + 2300L;
                    break;
                }
                case 10: {
                    int n = this.enumPlains();
                    while (n != -1) {
                        this.getPlain(n).setSpeed(1600 * AtcGame.getSpeedMultiplier());
                        n = this.enumNextPlain();
                    }
                    if (this.m_helpSkipped) {
                        Airplane ap = this.getSelectedPlane();
                        ap.setDirection(0);
                        ap.setX(PhysicsObject.screenToWorld(this.m_landbox_x2 - 1));
                    }
                    this.m_helpbox = 28;
                    this.m_helpx = this.getDisplaySize() - this.getImageWidth(this.m_helpbox, 0) - 1;
                    this.m_helpy = 1;
                    this.m_helpStepTm = System.currentTimeMillis() + 10000L;
                    break;
                }
                case 11: {
                    this.m_helpbox = 29;
                    this.m_helpx = (this.getDisplaySize() >> 1) - (this.getImageWidth(this.m_helpbox, 0) >> 1);
                    this.m_helpy = (this.getDisplaySize() >> 1) - (this.getImageHeight(this.m_helpbox, 0) >> 1);
                    this.m_helpStepTm = System.currentTimeMillis() + 9000L;
                    break;
                }
                case 12: {
                    this.activateView(100);
                }
            }
        }
        if (this.m_helpStepTm < System.currentTimeMillis()) {
            ++this.m_helpStep;
            this.m_helpStepDone = false;
        }
    }

    private void checkCollisionsAndLost() {
        this.m_planeInWarning = false;
        int width = PhysicsObject.screenToWorld(this.getImageWidth(0, 0));
        int n = this.enumPlains();
        Airplane p = null;
        n = this.enumPlains();
        while (n != -1) {
            p = this.getPlain(n);
            int i = 0;
            while (i < 14) {
                Airplane p2 = this.getPlain(i);
                if (p2 != null && n != i && !p2.isWarning() && p.getAltitude() == p2.getAltitude() && p2.getAltitude() != 1 && p.getState() != 5) {
                    long x1 = p2.getX() - (long)width;
                    long x2 = p2.getX() + (long)width;
                    long y1 = p2.getY() - (long)width;
                    long y2 = p2.getY() + (long)width;
                    if (p.getX() > x1 && p.getX() < x2 && p.getY() > y1 && p.getY() < y2) {
                        this.m_planeInWarning = true;
                        p.setWarning(true);
                        p2.setWarning(true);
                        long xdiff = p.getX() - p2.getX();
                        long ydiff = p.getY() - p2.getY();
                        long diff = PhysicsObject.screenToWorld(4);
                        if (xdiff > -diff && xdiff < diff && ydiff > -diff && ydiff < diff) {
                            this.planeCollision(p, p2);
                        }
                    }
                }
                ++i;
            }
            if ((p.getX() <= 0L || p.getX() >= (long)PhysicsObject.getWorldScale() || p.getY() <= 0L || p.getY() >= (long)PhysicsObject.screenToWorld(this.getDisplayHeight())) && p.getTimeInState() > 5000L) {
                this.m_planeInWarning = true;
                p.setWarning(true);
                int w = PhysicsObject.screenToWorld(2);
                if (p.getX() <= (long)(-w) || p.getX() >= (long)(PhysicsObject.getWorldScale() + w) || p.getY() <= (long)(-w) || p.getY() >= (long)(PhysicsObject.screenToWorld(this.getDisplayHeight()) + w)) {
                    this.planeLost(p);
                }
            }
            n = this.enumNextPlain();
        }
    }

    private boolean isPlaneInExit(Airplane p, int box) {
        boolean b = false;
        switch (box) {
            case 16: {
                int x = (this.getDisplaySize() >> 1) - (this.getImageWidth(16, 0) >> 1);
                int y = 0;
                if (p.getDisplayX() < x || p.getDisplayX() > x + this.getImageWidth(16, 0) || p.getDisplayY() < y || p.getDisplayY() > y + this.getImageHeight(16, 0)) break;
                b = true;
                break;
            }
            case 17: {
                int x = this.getDisplaySize() - this.getImageWidth(17, 0);
                int y = (this.getDisplayHeight() >> 1) - (this.getImageHeight(17, 0) >> 1);
                if (p.getDisplayX() < x || p.getDisplayX() > x + this.getImageWidth(17, 0) || p.getDisplayY() < y || p.getDisplayY() > y + this.getImageHeight(17, 0)) break;
                b = true;
                break;
            }
            case 18: {
                int x = (this.getDisplaySize() >> 1) - (this.getImageWidth(18, 0) >> 1);
                int y = this.getDisplayHeight() - this.getImageHeight(18, 0);
                if (p.getDisplayX() < x || p.getDisplayX() > x + this.getImageWidth(18, 0) || p.getDisplayY() < y || p.getDisplayY() > y + this.getImageHeight(18, 0)) break;
                b = true;
                break;
            }
            case 19: {
                int x = 0;
                int y = (this.getDisplayHeight() >> 1) - (this.getImageHeight(19, 0) >> 1);
                if (p.getDisplayX() < x || p.getDisplayX() > x + this.getImageWidth(19, 0) || p.getDisplayY() < y || p.getDisplayY() > y + this.getImageHeight(19, 0)) break;
                b = true;
            }
        }
        return b;
    }

    private void paintMenuSelectIcon(int x1, int y1, int x2, int y2) {
        if (this.isFlashed()) {
            this.setColor(255, 255, 255);
            this.drawLine(x1, y1 + 1, x1, y1 + 1);
            this.drawLine(x1 + 1, y1, x1 + 1, y1 + 2);
            this.drawLine(x2, y2, x2, y2 + 2);
            this.drawLine(x2 + 1, y2 + 1, x2 + 1, y2 + 1);
        }
    }

    protected void onPaint() {
        if (this.isLoading() && this.getCurrentView() != 105 && this.getCurrentView() != 0) {
            this.drawLoading();
        } else {
            switch (this.getCurrentView()) {
                case 100: {
                    this.drawImageEx(0, 0, 0, 1);
                    break;
                }
                case 151: {
                    this.drawImage(21, 0, 0);
                    break;
                }
                case 101: {
                    this.drawImageEx(0, 0, 0, 1);
                    this.setColor(0, 255, 0);
                    this.drawString("" + this.m_level, 62, 49);
                    this.drawString("" + this.m_planeToDo, 62, 88);
                    this.setColor(52, 94, 75);
                    this.fillRect(60 + (this.m_level >> 1), 66, 49 - (this.m_level >> 1), 10);
                    if (this.m_maxLevel <= 1) break;
                    this.paintMenuSelectIcon(56, 54, 111, 54);
                    break;
                }
                case 149: {
                    this.drawImageEx(0, 0, 0, 1);
                    this.setColor(0, 255, 0);
                    this.drawString("-", 62, 49);
                    this.drawString("" + this.m_planeToDo, 62, 88);
                    this.paintMenuSelectIcon(56, 69, 111, 69);
                    this.setColor(52, 94, 75);
                    this.fillRect(60 + (this.m_practiceLevel >> 1), 66, 49 - (this.m_practiceLevel >> 1), 10);
                    break;
                }
                case 122: {
                    this.drawImageEx(0, 0, 0, 1);
                    break;
                }
                case 148: {
                    this.paintLevel();
                    if (this.m_helpbox == -1) break;
                    this.drawImageEx(this.m_helpbox, this.m_helpx, this.m_helpy, 0);
                    break;
                }
                case 133: {
                    this.drawImageEx(0, 0, 0, 1);
                    break;
                }
                case 111: {
                    this.drawImageEx(0, 0, 0, 1);
                    break;
                }
                case 105: {
                    this.paintLevel();
                }
            }
        }
    }

    protected void paintLevel() {
        int y;
        int x;
        int w;
        int dy;
        int dx;
        Airplane plain;
        this.drawImageEx(0, 0, 0, 1);
        if (this.m_rwLightsTm < System.currentTimeMillis()) {
            this.m_rwLightsTm = System.currentTimeMillis() + 600L;
            ++this.m_rwLightsTick;
            if (this.m_rwLightsTick >= 3) {
                this.m_rwLightsTick = 0;
            }
        }
        if (this.m_rwLightsTick == 0) {
            this.setColor(255, 255, 255);
            this.drawLine(this.m_landbox_x, this.m_landbox_y, this.m_landbox_x, this.m_landbox_y);
            this.drawLine(this.m_landbox_x + this.m_rw_w, this.m_landbox_y, this.m_landbox_x + this.m_rw_w, this.m_landbox_y);
        }
        if (this.m_rwLightsTick == 1) {
            this.setColor(255, 190, 50);
            this.drawLine(this.m_landbox_x, this.m_landbox_y - (this.m_landbox_y - (this.m_rw_y + this.m_rw_h) >> 1), this.m_landbox_x, this.m_landbox_y - (this.m_landbox_y - (this.m_rw_y + this.m_rw_h) >> 1));
            this.drawLine(this.m_landbox_x + this.m_rw_w, this.m_landbox_y - (this.m_landbox_y - (this.m_rw_y + this.m_rw_h) >> 1), this.m_landbox_x + this.m_rw_w, this.m_landbox_y - (this.m_landbox_y - (this.m_rw_y + this.m_rw_h) >> 1));
        }
        if (this.m_rwLightsTick == 2) {
            this.setColor(255, 255, 255);
            this.drawLine(this.m_rw_x - 1, this.m_rw_y + this.m_rw_h, this.m_rw_x - 1, this.m_rw_y + this.m_rw_h);
            this.drawLine(this.m_rw_x + this.m_rw_w - 1, this.m_rw_y + this.m_rw_h, this.m_rw_x + this.m_rw_w - 1, this.m_rw_y + this.m_rw_h);
        }
        int n = this.enumPlains();
        while (n != -1) {
            plain = this.getPlain(n);
            if (plain.getTimeInState() < 5000L && this.isFlashed() && (plain.getState() == 1 || plain.getState() == 0 || plain.getState() == 2 || plain.getState() == 3 || plain.getState() == 4) || plain.getTimeInState() > 5000L || plain.getState() == 5) {
                this.drawImage(plain.getDirection() / 45 + 8, plain.getDisplayX() - (this.getImageWidth(0, 0) >> 1) + plain.getAltitude(), plain.getDisplayY() - (this.getImageHeight(0, 0) >> 1) + plain.getAltitude());
            }
            n = this.enumNextPlain();
        }
        plain = this.getPlain(this.getSelected());
        int offset = this.getImageWidth(16, 0) - 10 >> 1;
        if (!this.m_help || this.m_helpStep == 1 && this.isFlashed() || this.m_helpStep != 1) {
            this.drawImage(16, (this.getDisplaySize() >> 1) - (this.getImageWidth(16, 0) >> 1), 0 - offset);
            this.drawImage(17, this.getDisplaySize() - this.getImageWidth(17, 0) + offset, (this.getDisplayHeight() >> 1) - (this.getImageHeight(17, 0) >> 1));
            this.drawImage(18, (this.getDisplaySize() >> 1) - (this.getImageWidth(18, 0) >> 1), this.getDisplayHeight() - this.getImageHeight(18, 0) + offset);
            this.drawImage(19, 0 - offset, (this.getDisplayHeight() >> 1) - (this.getImageHeight(19, 0) >> 1));
        }
        if (!this.m_help || this.m_helpStep == 2 && this.isFlashed() || this.m_helpStep != 2) {
            this.drawImage(20, this.m_rw_x - 1 - this.getImageWidth(20, 0), this.m_rw_y + (this.m_rw_h - this.getImageHeight(20, 0)));
        }
        n = this.enumPlains();
        while (n != -1) {
            plain = this.getPlain(n);
            if (plain.getTimeInState() < 5000L && this.isFlashed() && (plain.getState() == 1 || plain.getState() == 0 || plain.getState() == 2 || plain.getState() == 3 || plain.getState() == 4) || plain.getTimeInState() > 5000L || plain.getState() == 5) {
                this.drawImage(plain.getDirection() / 45, plain.getDisplayX() - (this.getImageWidth(0, 0) >> 1), plain.getDisplayY() - (this.getImageHeight(0, 0) >> 1));
                if (plain.isWarning() && this.isFlashed()) {
                    int w2 = this.getImageWidth(plain.getDirection() / 45, 0);
                    int x2 = plain.getDisplayX() - (this.getImageWidth(0, 0) >> 1);
                    int y2 = plain.getDisplayY() - (this.getImageHeight(0, 0) >> 1);
                    this.setColor(255, 255, 0);
                    this.drawRect(x2, y2, w2, w2);
                }
            }
            n = this.enumNextPlain();
        }
        plain = this.getPlain(this.getSelected());
        if (plain != null) {
            dx = plain.getDisplayX();
            dy = plain.getDisplayY();
            w = this.getImageWidth(plain.getDirection() / 45, 0);
            x = dx - (this.getImageWidth(0, 0) >> 1);
            y = dy - (this.getImageHeight(0, 0) >> 1);
            if (!plain.isWarning() || !this.isFlashed()) {
                this.setColor(10, 255, 10);
                this.drawRect(x, y, w, w);
            }
            if (dx < this.getDisplayWidth() >> 1) {
                x += w;
                x -= this.getImageWidth(plain.getDestination(), 0) - 10;
            } else {
                x -= this.getImageHeight(plain.getDestination(), 0);
                x += this.getImageWidth(plain.getDestination(), 0) - 10;
            }
            if (dy < this.getDisplayHeight() >> 1) {
                y += w;
                y -= this.getImageHeight(plain.getDestination(), 0) - 10;
            } else {
                y -= this.getImageHeight(plain.getDestination(), 0);
                y += this.getImageHeight(plain.getDestination(), 0) - 10;
            }
            if (!this.m_help || this.m_helpStep == 3 && this.isFlashed() || this.m_helpStep != 3) {
                this.drawImage(plain.getDestination(), x, y);
            }
        }
        if (!this.m_help) {
            this.setColor(0, 255, 0);
            this.drawString(String.valueOf(this.m_planesDone) + "/" + this.m_planeToDo, 1, this.getDisplayHeight() - 13);
        }
        if (this.m_popupTm != 0L) {
            if (this.m_popupTm > System.currentTimeMillis()) {
                if (!this.isFlashed()) {
                    this.drawImage(this.m_popUp, (this.getDisplayWidth() >> 1) - (this.getImageWidth(this.m_popUp, 0) >> 1), (this.getDisplayHeight() >> 1) - (this.getImageHeight(this.m_popUp, 0) >> 1));
                }
                dx = this.m_planePopUp.getDisplayX();
                dy = this.m_planePopUp.getDisplayY();
                w = this.getImageWidth(this.m_planePopUp.getDirection() / 45, 0);
                x = dx - (this.getImageWidth(0, 0) >> 1);
                y = dy - (this.getImageHeight(0, 0) >> 1);
                if (this.isFlashed()) {
                    this.setColor(255, 0, 0);
                    this.drawRect(x - 1, y - 1, w + 2, w + 2);
                }
            } else {
                this.m_popupTm = 0L;
                if (!this.m_practice) {
                    if (this.m_popUp == 30) {
                        this.gameOverLost();
                    } else {
                        this.gameOverCrash();
                    }
                } else {
                    this.m_planePopUp.setActive(false);
                }
            }
        }
    }

    private int getDisplaySize() {
        return this.m_displaySize;
    }

    protected void onStart() {
        if (this.getDisplayWidth() >= this.getDisplayHeight()) {
            this.m_displaySize = this.getDisplayHeight();
        }
        if (this.getDisplayWidth() < this.getDisplayHeight()) {
            this.m_displaySize = this.getDisplayWidth();
        }
        PhysicsObject.setScale(this.m_displaySize);
        this.initSoundSystem(3);
        this.loadSound("/music", 0);
        this.loadSound("/new", 1);
        this.loadSound("/warning", 2);
        this.initPlains();
        this.m_rw_y = this.m_rw_x = PhysicsObject.worldToScreen(PhysicsObject.getWorldScale() / 3);
        this.m_rw_w = 3;
        this.m_rw_h = PhysicsObject.worldToScreen(PhysicsObject.getWorldScale() / 5);
        this.m_rw2_x = this.m_rw_x + (this.m_rw_w << 1);
        this.m_rw2_y = this.m_rw_y + this.m_rw_w;
        this.m_landbox_x = this.m_rw_x - 1;
        this.m_landbox_x2 = this.m_rw_x + this.m_rw_w + 1;
        this.m_landbox_y = this.m_rw_y + this.m_rw_h + (this.m_rw_h >> 1);
        this.m_landbox_y2 = this.m_rw_y + this.m_rw_h * 2;
        try {
            this.loadGame(1);
        }
        catch (Exception e) {
            this.m_level = 1;
            this.m_maxLevel = 1;
        }
        this.loadImages("/", 32, 0, 0);
        this.m_levelLoaded = true;
        this.activateView(100);
    }

    protected void onPause() {
        if (this.getCurrentView() != 105) {
            this.stopSound(0);
            try {
                this.saveGame(1);
            }
            catch (Exception e) {}
        } else {
            this.activateView(151);
        }
    }

    protected void onResume() {
        if (this.getCurrentView() == 151) {
            this.m_newPlainTm = System.currentTimeMillis() + (long)this.m_newPlaneInterval;
            this.m_newDepartureTm = System.currentTimeMillis() + (long)this.m_newDepartureInterval;
        }
    }

    protected void onEnd() {
        try {
            this.saveGame(1);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void onKeyEvent(int type, int key) {
        if (type == DigGame.KEY_PRESSED_EVENT) {
            if (key == DigGame.KEY_SOFT2) {
                if (this.getCurrentView() == 105) {
                    this.activateView(151);
                }
                if (this.getCurrentView() == 148) {
                    this.activateView(100);
                }
            }
            if (key == DigGame.KEY_SOFT1) {
                this.getCurrentView();
                if (this.getCurrentView() == 148) {
                    this.m_helpStepDone = true;
                    this.m_helpStepTm = System.currentTimeMillis();
                    this.m_helpSkipped = true;
                }
            }
            if (key == DigGame.KEY_0) {
                if (this.getCurrentView() == 105) {
                    this.activateView(100);
                }
                if (this.getCurrentView() == 148) {
                    this.activateView(100);
                }
            }
            if (key == DigGame.KEY_9) {
                boolean bl = this.m_soundOn = !this.m_soundOn;
                if (this.m_soundOn) {
                    if (this.getCurrentView() != 105) {
                        this.playGameSound(0);
                    }
                } else {
                    this.stopSound(0);
                }
            }
        }
        if (type == DigGame.KEY_RELEASED_EVENT) {
            if (this.getCurrentView() == 105) {
                Airplane plain = this.getPlain(this.m_selected);
                if (plain != null) {
                    if (key == DigGame.KEY_LEFT) {
                        plain.rotate(-45);
                    }
                    if (key == DigGame.KEY_RIGHT) {
                        plain.rotate(45);
                    }
                }
                if (key == DigGame.KEY_UP) {
                    this.selectPrevious();
                }
                if (key == DigGame.KEY_DOWN) {
                    this.selectNext();
                }
            }
            if (this.getCurrentView() == 101 && (key == DigGame.KEY_LEFT || key == DigGame.KEY_RIGHT)) {
                if (key == DigGame.KEY_LEFT) {
                    --this.m_level;
                }
                if (key == DigGame.KEY_RIGHT) {
                    ++this.m_level;
                }
                if (this.m_level <= 0) {
                    this.m_level = 1;
                }
                if (this.m_level > this.m_maxLevel) {
                    this.m_level = this.m_maxLevel;
                }
                this.initLevel(this.m_level);
            }
            if (this.getCurrentView() == 149 && (key == DigGame.KEY_LEFT || key == DigGame.KEY_RIGHT)) {
                if (key == DigGame.KEY_LEFT) {
                    this.m_practiceLevel -= 2;
                }
                if (key == DigGame.KEY_RIGHT) {
                    this.m_practiceLevel += 2;
                }
                if (this.m_practiceLevel <= 0) {
                    this.m_practiceLevel = 1;
                }
                if (this.m_practiceLevel > 100) {
                    this.m_practiceLevel = 100;
                }
                this.initPractice(this.m_practiceLevel);
            }
        }
    }

    protected boolean onMenuEvent(int menuItem, int reserved) {
        if (this.getCurrentView() == 151) {
            this.m_newPlainTm = System.currentTimeMillis() + (long)this.m_newPlaneInterval;
            this.m_newDepartureTm = System.currentTimeMillis() + (long)this.m_newDepartureInterval;
        }
        return true;
    }

    protected void onPaintMenuItem(int menuItem, int userData, int x, int y, int w, int h) {
        if (this.getSelectedMenu() == menuItem) {
            this.setColor(0, 255, 0);
            this.drawRect(10, y, 48, h);
            if (this.isFlashed()) {
                this.setColor(255, 255, 255);
                this.drawLine(13, y + 4, 13, y + 8);
                this.drawLine(14, y + 5, 14, y + 7);
                this.drawLine(15, y + 6, 15, y + 6);
            }
        }
    }

    protected void onViewChange(int view) {
        switch (view) {
            case 100: {
                this.stopSound(0);
                this.loadImages("/", 1, 100, 1);
                this.initMenu(4, 9, 0, this.getDisplayWidth(), 12, -1);
                this.setMenuItemTarget(0, 101, -1);
                this.setMenuItemTarget(1, 149, -1);
                this.setMenuItemTarget(2, 148, -1);
                this.setMenuItemTarget(3, 150, -1);
                this.playGameSound(0);
                break;
            }
            case 151: {
                this.initMenu(2, 9, 0, this.getDisplayWidth(), 12, -1);
                this.setMenuItemTarget(0, 105, -1);
                this.setMenuItemTarget(1, 100, -1);
                break;
            }
            case 101: {
                this.stopSound(0);
                this.loadImages("/", 1, 101, 1);
                this.initMenu(2, 9, 0, this.getDisplayWidth(), 12, 100);
                this.setMenuItemTarget(0, 105, -1);
                this.setMenuItemTarget(1, 100, -1);
                this.initLevel(this.m_level);
                this.playGameSound(0);
                break;
            }
            case 149: {
                this.stopSound(0);
                this.loadImages("/", 1, 101, 1);
                this.initMenu(2, 9, 0, this.getDisplayWidth(), 12, 100);
                this.setMenuItemTarget(0, 105, -1);
                this.setMenuItemTarget(1, 100, -1);
                this.initPractice(this.m_practiceLevel);
                this.playGameSound(0);
                break;
            }
            case 105: {
                this.stopSound(0);
                if (!this.m_levelLoaded) {
                    this.loadImages("/", 32, 0, 0);
                    this.m_levelLoaded = true;
                }
                this.loadImages("/", 1, 105, 1);
                DigGame.activateSoftKey(2);
                break;
            }
            case 133: {
                this.stopSound(0);
                this.loadImages("/", 1, 133, 1);
                this.initMenu(2, 9, 0, this.getDisplayWidth(), 12, 101);
                this.setMenuItemTarget(0, 101, -1);
                this.setMenuItemTarget(1, 100, -1);
                this.playGameSound(0);
                break;
            }
            case 122: {
                this.loadImages("/", 1, 122, 1);
                this.initMenu(2, 9, 0, this.getDisplayWidth(), 12, 101);
                this.setMenuItemTarget(0, 101, -1);
                this.setMenuItemTarget(1, 100, -1);
                this.playGameSound(0);
                break;
            }
            case 111: {
                this.loadImages("/", 1, 111, 1);
                this.initMenu(2, 9, 0, this.getDisplayWidth(), 12, 101);
                this.setMenuItemTarget(0, 101, -1);
                this.setMenuItemTarget(1, 100, -1);
                this.playGameSound(0);
                break;
            }
            case 148: {
                this.stopSound(0);
                this.initHelp();
                if (!this.m_levelLoaded) {
                    this.loadImages("/", 32, 0, 0);
                    this.m_levelLoaded = true;
                }
                this.loadImages("/", 1, 105, 1);
                this.playGameSound(0);
                DigGame.activateSoftKey(2);
                DigGame.activateSoftKey(3);
                break;
            }
            case 150: {
                this.stopSound(0);
                this.terminate();
            }
        }
    }

    protected void onSerialize(DataInputStream in, DataOutputStream out) throws Exception {
        if (in != null) {
            this.m_level = in.readInt();
            this.m_maxLevel = in.readInt();
            this.m_soundOn = in.readBoolean();
        }
        if (out != null) {
            out.writeInt(this.m_level);
            out.writeInt(this.m_maxLevel);
            out.writeBoolean(this.m_soundOn);
        }
    }

    protected void onLoaded(int set, int res) {
        this.m_levelLoaded = true;
        this.setLoading(false);
    }

    void gameOverCrash() {
        this.activateView(122);
    }

    void gameOverLost() {
        this.activateView(111);
    }

    void levelComplete() {
        ++this.m_level;
        if (this.m_level > this.m_maxLevel) {
            this.m_maxLevel = this.m_level;
        }
        this.activateView(133);
    }

    void planeStartLanding(Airplane p) {
        p.startLanding();
        Airplane sp = this.getSelectedPlane();
        if (sp != null && sp == p) {
            this.clearSelection();
        }
    }

    void planeStartFlight(Airplane p) {
        if (!this.m_planeInWarning) {
            this.playGameSound(1);
        }
        p.startFlight();
        p.setSpeed(this.getLevelFlightSpeed());
    }

    void planeLanded(Airplane p) {
        this.planeDoneOk(p);
    }

    void planeExit(Airplane p) {
        this.planeDoneOk(p);
    }

    void planeDoneOk(Airplane p) {
        ++this.m_planesDone;
        p.setActive(false);
        if (this.m_planesDone >= this.m_planeToDo) {
            this.levelComplete();
        }
    }

    void planeLost(Airplane p) {
        Airplane sp = this.getSelectedPlane();
        if (sp != null && sp == p) {
            this.clearSelection();
        }
        ++this.m_planesLost;
        this.m_planePopUp = p;
        this.m_popupTm = System.currentTimeMillis() + 3000L;
        this.m_popUp = 30;
    }

    void planeCollision(Airplane p1, Airplane p2) {
        Airplane sp = this.getSelectedPlane();
        if (sp != null) {
            if (sp == p1) {
                this.clearSelection();
            }
            if (sp == p2) {
                this.clearSelection();
            }
        }
        this.m_planesLost += 2;
        this.m_planePopUp = p1;
        p2.setActive(false);
        this.m_popupTm = System.currentTimeMillis() + 3000L;
        this.m_popUp = 31;
    }
}

