/*
 * Decompiled with CFR 0.152.
 */
package com.lunagames.atc;

import com.lunagames.atc.Float;

public class PhysicsObject {
    private static int[] s_arrySin;
    private static int[] s_arryCos;
    private long m_xpos;
    private long m_ypos;
    private int m_speed;
    private int m_direction;
    private static final int WORLD_SCALE = 10000;
    private static int m_scale;

    public PhysicsObject() {
        this.init();
        this.reset();
    }

    public void reset() {
        this.m_xpos = 0L;
        this.m_ypos = 0L;
        this.m_speed = 0;
        this.m_direction = 0;
    }

    public static int getWorldScale() {
        return 10000;
    }

    public static int worldToScreen(int coord) {
        return coord / m_scale;
    }

    public static int screenToWorld(int coord) {
        return coord * m_scale;
    }

    public static void setScale(int displayDimension) {
        m_scale = 10000 / (displayDimension - 1);
    }

    public void setState(int x, int y, int d, int s) {
        this.m_xpos = x;
        this.m_ypos = y;
        this.m_direction = d;
        this.m_speed = s;
    }

    public long getX() {
        return this.m_xpos;
    }

    public long getY() {
        return this.m_ypos;
    }

    public void setX(long x) {
        this.m_xpos = x;
    }

    public void setY(long y) {
        this.m_ypos = y;
    }

    public int getDisplayX() {
        return (int)(this.m_xpos / (long)m_scale);
    }

    public int getDisplayY() {
        return (int)(this.m_ypos / (long)m_scale);
    }

    public void setDirection(int degrees) {
        this.m_direction = degrees;
    }

    public int getDirection() {
        return this.m_direction;
    }

    public void setSpeed(int s) {
        this.m_speed = s;
    }

    public int getSpeed() {
        return this.m_speed;
    }

    public void rotate(int degrees) {
        this.m_direction += degrees;
        if (this.m_direction < 0) {
            this.m_direction += 360;
        }
        if (this.m_direction > 359) {
            this.m_direction -= 360;
        }
    }

    public void calcPhysics() {
        this.m_xpos += (long)(s_arrySin[this.m_direction] * (this.m_speed / 100) / 100);
        this.m_ypos += (long)(-(s_arryCos[this.m_direction] * (this.m_speed / 100) / 100));
    }

    public void init() {
        if (s_arrySin == null) {
            s_arrySin = new int[360];
            s_arryCos = new int[360];
            int i = 0;
            while (i < 360) {
                if (i == 0 || i == 45 || i == 90 || i == 135 || i == 180 || i == 225 || i == 270 || i == 315) {
                    Float fl = new Float(i);
                    fl = fl.Mul(Float.PI).Div(180L);
                    PhysicsObject.s_arrySin[i] = (int)Float.sin(fl).Mul(100L).toLong();
                    PhysicsObject.s_arryCos[i] = (int)Float.cos(fl).Mul(100L).toLong();
                }
                ++i;
            }
        }
    }
}

