/*
 * Decompiled with CFR 0.152.
 */
package com.lunagames.dig;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.util.Random;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreNotFoundException;

public abstract class DigGame
extends MIDlet
implements Runnable {
    private Object m_mutexPaint;
    private Object m_mutexEvents;
    private Object m_pauseNotify = new Object();
    private boolean m_paused;
    private Image[] m_imageSet0;
    private Image[] m_imageSet1;
    private int m_imageSet0Size;
    private int m_imageSet1Size;
    private static int s_seed;
    private Random m_random;
    private boolean m_flashed;
    private long m_flashTm;
    private int m_flashInterval = 500;
    private boolean m_loading = true;
    private Image m_imgLoading;
    private static boolean m_splash;
    private Player[] m_players;
    private Graphics m_gfxBuffer;
    private int s_activateView = -1;
    String m_debug = "";
    public static int KEY_0;
    public static int KEY_1;
    public static int KEY_2;
    public static int KEY_3;
    public static int KEY_4;
    public static int KEY_5;
    public static int KEY_6;
    public static int KEY_7;
    public static int KEY_8;
    public static int KEY_9;
    public static int KEY_ASTERISK;
    public static int KEY_DOWN;
    public static int KEY_LEFT;
    public static int KEY_POUNT;
    public static int KEY_PRESSED_EVENT;
    public static int KEY_RELEASED_EVENT;
    public static int KEY_RIGHT;
    public static int KEY_SELECT;
    public static int KEY_SOFT1;
    public static int KEY_SOFT2;
    public static int KEY_UP;
    public static final int CAPS_SOUND = 1;
    public static final int CAPS_SOUND_TONES = 3;
    public static final int CAPS_SOUND_RICH = 4;
    public static final int CAPS_VIBRA = 2;
    public static final int SOFTKEY_NONE = -1;
    public static final int SOFTKEY_SELECT = 1;
    public static final int SOFTKEY_BACK = 2;
    public static final int SOFTKEY_NEXT = 3;
    private static boolean s_soft1;
    private static boolean s_soft1cnt;
    private static boolean s_soft2;
    private DigCanvas m_canvas;
    private Thread m_thread;
    private static final int MAX_MENU_ITEMS = 50;
    private int[] m_menuItems = new int[50];
    private int[] m_menuUserData = new int[50];
    private int m_menuSelected;
    private int m_menuScroll;
    private int m_menuNrOfActiveItems;
    private int m_menuOffset;
    private boolean m_menuActive;
    private int m_menuSpacing;
    private int m_menuWidth;
    private int m_menuHeight;
    private int m_menuBackView;
    private int m_view;
    static final int XDRAW_OFFSET = 2;

    static {
        m_splash = true;
        KEY_0 = 48;
        KEY_1 = 49;
        KEY_2 = 50;
        KEY_3 = 51;
        KEY_4 = 52;
        KEY_5 = 53;
        KEY_6 = 54;
        KEY_7 = 55;
        KEY_8 = 56;
        KEY_9 = 57;
        KEY_ASTERISK = 10;
        KEY_DOWN = -60;
        KEY_LEFT = -61;
        KEY_POUNT = 11;
        KEY_PRESSED_EVENT = 0;
        KEY_RELEASED_EVENT = 1;
        KEY_RIGHT = -62;
        KEY_SELECT = -26;
        KEY_SOFT1 = -1;
        KEY_SOFT2 = -4;
        KEY_UP = -59;
        s_soft1 = false;
        s_soft1cnt = false;
        s_soft2 = false;
    }

    public static void activateSoftKey(int type) {
        if (type == 2) {
            s_soft2 = true;
        }
        if (type == 3) {
            s_soft1cnt = true;
        }
        if (type == 1) {
            s_soft1 = true;
        }
    }

    public static void resetSoftKeys() {
        s_soft1 = false;
        s_soft1cnt = false;
        s_soft2 = false;
    }

    private String getCommandText(int type) {
        switch (type) {
            case 1: {
                String prop = this.getAppProperty("dig-select");
                if (prop != null && prop.length() > 0) {
                    return prop;
                }
                return "Select";
            }
            case 2: {
                String prop = this.getAppProperty("dig-back");
                if (prop != null && prop.length() > 0) {
                    return prop;
                }
                return "Back";
            }
            case 3: {
                String prop = this.getAppProperty("dig-next");
                if (prop != null && prop.length() > 0) {
                    return prop;
                }
                return "Continue";
            }
        }
        return " ";
    }

    public DigGame() {
        this.m_canvas = new DigCanvas();
    }

    public int getDisplayWidth() {
        return 128;
    }

    public int getDisplayHeight() {
        return 160;
    }

    public final void startApp() {
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.m_canvas);
        this.m_paused = false;
    }

    private final void startThread() {
        this.m_thread = new Thread(this);
        this.m_thread.start();
    }

    public final void pauseApp() {
        this.m_paused = true;
    }

    public final void destroyApp(boolean unconditional) {
        this.m_thread = null;
        Object object = this.m_mutexEvents;
        synchronized (object) {
            this.onEnd();
        }
        this.flushImages(0);
        this.flushImages(1);
        int i = 0;
        while (i < this.m_players.length) {
            this.m_players[i] = null;
            ++i;
        }
        this.m_players = null;
        this.m_random = null;
        this.m_imgLoading = null;
        this.m_gfxBuffer = null;
        this.m_canvas = null;
        System.gc();
        this.notifyDestroyed();
    }

    public final void run() {
        Thread currentThread = Thread.currentThread();
        try {
            Object object;
            this.onStart();
            if (this.s_activateView > -1) {
                object = this.m_mutexEvents;
                synchronized (object) {
                    this.onViewChange(this.s_activateView);
                }
                this.m_view = this.s_activateView;
                this.s_activateView = -1;
            }
            m_splash = false;
            this.m_loading = false;
            while (currentThread == this.m_thread) {
                if (this.m_paused) {
                    object = this.m_pauseNotify;
                    synchronized (object) {
                        this.m_pauseNotify.wait();
                        continue;
                    }
                }
                object = this.m_mutexEvents;
                synchronized (object) {
                    if (!this.onSample()) {
                        break;
                    }
                }
                if (this.m_flashTm < System.currentTimeMillis()) {
                    this.m_flashTm = System.currentTimeMillis() + (long)this.m_flashInterval;
                    boolean bl = this.m_flashed = !this.m_flashed;
                }
                if (this.s_activateView > -1) {
                    this.m_canvas.synchronizedRepaint();
                    DigGame.resetSoftKeys();
                    this.clearMenu();
                    object = this.m_mutexEvents;
                    synchronized (object) {
                        this.onViewChange(this.s_activateView);
                    }
                    this.m_view = this.s_activateView;
                    this.m_loading = false;
                    this.s_activateView = -1;
                }
                this.m_canvas.synchronizedRepaint();
            }
            this.terminate();
        }
        catch (InterruptedException interruptedException) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void terminate() {
        this.destroyApp(false);
    }

    private Image createImage(String piResourceId) throws Exception {
        return Image.createImage((String)(String.valueOf(piResourceId) + ".png"));
    }

    private int getMenuItemLeft(int ndx) {
        return this.getDisplayWidth() - this.getMenuItemWidth(0) >> 1;
    }

    private void clearMenu() {
        this.m_menuNrOfActiveItems = 0;
        this.m_menuOffset = 0;
        this.m_menuWidth = 0;
        this.m_menuHeight = 0;
        this.m_menuSelected = 0;
        this.m_menuScroll = 0;
        this.m_menuBackView = -1;
        int i = 0;
        while (i < 50) {
            this.m_menuItems[i] = -1;
            this.m_menuUserData[i] = -1;
            ++i;
        }
        this.m_menuActive = false;
    }

    private int getMenuItemTop(int ndx) {
        int top = this.m_menuOffset;
        int i = this.getFirstMenuItemToDisplay();
        while (i < ndx) {
            top += this.getMenuItemHeight(i);
            top += this.m_menuSpacing;
            ++i;
        }
        return top;
    }

    private int getFirstMenuItemToDisplay() {
        int first = this.m_menuScroll + 1 - this.getNrOfMenuItemsInView();
        if (first < 0) {
            return 0;
        }
        return first;
    }

    private int getNrOfMenuItemsInView() {
        return 5;
    }

    private int getMenuItemWidth(int ndx) {
        return this.m_menuWidth;
    }

    private int getMenuItemHeight(int ndx) {
        return this.m_menuHeight;
    }

    private boolean isMenuVisable(int ndx) {
        return ndx >= this.getFirstMenuItemToDisplay() && ndx < this.getFirstMenuItemToDisplay() + this.getNrOfMenuItemsInView();
    }

    private int getNrOfActiveMenuItems() {
        return this.m_menuNrOfActiveItems;
    }

    private void processMenuEvent(int type, int param) {
        if (type == KEY_PRESSED_EVENT) {
            if (param == KEY_SOFT2 && this.m_menuBackView != -1) {
                this.activateView(this.m_menuBackView);
            }
            if (param == KEY_UP) {
                --this.m_menuSelected;
                if (this.m_menuSelected + (this.getNrOfMenuItemsInView() - 1) < this.m_menuScroll) {
                    --this.m_menuScroll;
                    if (this.m_menuScroll < 0) {
                        this.m_menuScroll = 0;
                    }
                }
                if (this.m_menuSelected < 0) {
                    this.m_menuSelected = 0;
                }
            }
            if (param == KEY_DOWN) {
                ++this.m_menuSelected;
                if (this.m_menuSelected > this.m_menuNrOfActiveItems - 1) {
                    this.m_menuSelected = this.m_menuNrOfActiveItems - 1;
                }
                this.m_menuScroll = this.m_menuSelected;
            }
            if (param == KEY_SELECT || param == KEY_SOFT1) {
                if (this.m_menuNrOfActiveItems > 0) {
                    if (this.onMenuEvent(this.m_menuSelected, 0) && this.m_menuItems[this.m_menuSelected] > -1) {
                        this.activateView(this.m_menuItems[this.m_menuSelected]);
                    }
                } else if (this.onMenuEvent(-1, 0)) {
                    this.activateView(this.m_menuSelected);
                }
            }
        }
    }

    public void saveGame(int ndx) throws Exception {
        try {
            RecordStore.deleteRecordStore((String)("f" + ndx));
        }
        catch (RecordStoreNotFoundException recordStoreNotFoundException) {
            // empty catch block
        }
        RecordStore rs = RecordStore.openRecordStore((String)("f" + ndx), (boolean)true);
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            DataOutputStream dout = new DataOutputStream(bout);
            Object object = this.m_mutexEvents;
            synchronized (object) {
                this.onSerialize(null, dout);
            }
            rs.addRecord(bout.toByteArray(), 0, bout.size());
            dout.close();
            bout.close();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        rs.closeRecordStore();
    }

    public void loadGame(int ndx) throws Exception {
        RecordStore rs;
        block5: {
            rs = RecordStore.openRecordStore((String)("f" + ndx), (boolean)false);
            try {
                RecordEnumeration recordEnumeration = rs.enumerateRecords(null, null, false);
                if (!recordEnumeration.hasNextElement()) break block5;
                byte[] data = recordEnumeration.nextRecord();
                ByteArrayInputStream bin = new ByteArrayInputStream(data);
                DataInputStream din = new DataInputStream(bin);
                Object object = this.m_mutexEvents;
                synchronized (object) {
                    this.onSerialize(din, null);
                }
                din.close();
                bin.close();
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
        rs.closeRecordStore();
    }

    public void loadImages(String prefix, int numOfImages) {
        this.loadImages(prefix, numOfImages, 0, 0);
    }

    public void loadImages(String prefix, int numOfImages, int startNdx, int imageSet) {
        this.flushImages(imageSet);
        try {
            if (imageSet == 0) {
                this.m_imageSet0 = new Image[numOfImages];
                int i = startNdx;
                while (i < numOfImages + startNdx) {
                    this.m_imageSet0[i - startNdx] = this.createImage(String.valueOf(prefix) + i);
                    ++i;
                }
                this.m_imageSet0Size = numOfImages;
            } else if (imageSet == 1) {
                this.m_imageSet1 = new Image[numOfImages];
                int i = startNdx;
                while (i < numOfImages + startNdx) {
                    this.m_imageSet1[i - startNdx] = this.createImage(String.valueOf(prefix) + i);
                    ++i;
                }
                this.m_imageSet1Size = numOfImages;
            }
        }
        catch (Exception e) {
            if (imageSet == 0) {
                this.m_imageSet0Size = 0;
            }
            if (imageSet == 1) {
                this.m_imageSet1Size = 0;
            }
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
    }

    public void flushImages(int imageSet) {
        if (imageSet == 0) {
            int i = 0;
            while (i < this.m_imageSet0Size) {
                this.m_imageSet0[i] = null;
                ++i;
            }
            this.m_imageSet0 = null;
            this.m_imageSet0Size = 0;
        } else if (imageSet == 1) {
            int i = 0;
            while (i < this.m_imageSet1Size) {
                this.m_imageSet1[i] = null;
                ++i;
            }
            this.m_imageSet1 = null;
            this.m_imageSet1Size = 0;
        }
        System.gc();
    }

    public int getImageWidth(int ndx, int set) {
        if (set == 0) {
            return this.m_imageSet0[ndx].getWidth();
        }
        if (set == 1) {
            return this.m_imageSet1[ndx].getWidth();
        }
        return 0;
    }

    public int getImageHeight(int ndx, int set) {
        if (set == 0) {
            return this.m_imageSet0[ndx].getHeight();
        }
        if (set == 1) {
            return this.m_imageSet1[ndx].getHeight();
        }
        return 0;
    }

    public void drawImage(int imgNum, int x, int y) {
        this.m_gfxBuffer.drawImage(this.m_imageSet0[imgNum], x += 2, y, 20);
    }

    public void drawImageEx(int imgNum, int x, int y, int imageSet) {
        x += 2;
        if (imageSet == 0) {
            this.m_gfxBuffer.drawImage(this.m_imageSet0[imgNum], x, y, 20);
        } else if (imageSet == 1) {
            this.m_gfxBuffer.drawImage(this.m_imageSet1[imgNum], x, y, 20);
        }
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        this.m_gfxBuffer.drawLine(x1 += 2, y1, x2 += 2, y2);
    }

    public void fillRect(int x, int y, int w, int h) {
        this.m_gfxBuffer.fillRect(x += 2, y, w, h);
    }

    public void drawRect(int x, int y, int w, int h) {
        this.m_gfxBuffer.drawRect(x += 2, y, w, h);
    }

    public void drawString(String s, int x, int y) {
        this.m_gfxBuffer.drawString(s, x += 2, y, 20);
    }

    public void setColor(int r, int g, int b) {
        this.m_gfxBuffer.setColor(r, g, b);
    }

    public void drawLoading() {
        if (this.m_imgLoading != null) {
            this.m_gfxBuffer.drawImage(this.m_imgLoading, (this.getDisplayWidth() >> 1) - (this.m_imgLoading.getWidth() >> 1), (this.getDisplayHeight() >> 1) - (this.m_imgLoading.getHeight() >> 1), 20);
        }
    }

    public boolean initSoundSystem(int nrOfSoundsInMem) {
        this.m_players = new Player[nrOfSoundsInMem];
        return true;
    }

    public boolean loadSound(String res, int ndx) {
        try {
            InputStream is = this.getClass().getResourceAsStream(String.valueOf(res) + ".mid");
            this.m_players[ndx] = Manager.createPlayer((InputStream)is, (String)"audio/midi");
            this.m_players[ndx].prefetch();
            return true;
        }
        catch (Exception e) {
            this.m_players[ndx] = null;
            return false;
        }
    }

    public void playSound(int loop, int ndx) {
        if (this.m_players != null && this.m_players[ndx] != null) {
            try {
                this.m_players[ndx].setLoopCount(loop);
                this.m_players[ndx].start();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void stopSound(int ndx) {
        if (this.m_players != null && this.m_players[ndx] != null) {
            try {
                this.m_players[ndx].stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void vibrate(boolean onState, int reserved) {
    }

    public void setFullScreen(boolean b) {
        this.m_canvas.setFullScreenMode(b);
    }

    public int getRandom(int maxNr) {
        int r = this.m_random.nextInt() % maxNr;
        if (r < 0) {
            r = -r;
        }
        return r;
    }

    public void setLoading(boolean l) {
        this.m_loading = l;
    }

    public boolean isLoading() {
        return this.m_loading;
    }

    public boolean isFlashed() {
        return this.m_flashed;
    }

    public void setFlashInterval(int i) {
        this.m_flashInterval = i;
    }

    public boolean isSupported(int capability) {
        return true;
    }

    protected int getCurrentView() {
        return this.m_view;
    }

    protected int getSelectedMenu() {
        return this.m_menuSelected;
    }

    protected void initMenu(int nrOfItems, int yOffset, int space, int width, int height, int viewBack) {
        this.m_menuNrOfActiveItems = nrOfItems;
        this.m_menuOffset = yOffset;
        this.m_menuWidth = width;
        this.m_menuHeight = height;
        this.m_menuBackView = viewBack;
        this.m_menuSpacing = space;
        this.m_menuActive = true;
        DigGame.activateSoftKey(1);
        if (viewBack != -1) {
            DigGame.activateSoftKey(2);
        }
    }

    protected void initSplashMenu(int view, int viewBack) {
        this.m_menuSelected = view;
        this.m_menuBackView = viewBack;
        this.m_menuActive = true;
    }

    protected void activateView(int view) {
        this.m_loading = true;
        this.s_activateView = view;
    }

    public boolean canMenuScrollUp() {
        return this.getFirstMenuItemToDisplay() > 0;
    }

    public boolean canMenuScrollDown() {
        return this.getFirstMenuItemToDisplay() + this.getNrOfMenuItemsInView() < this.getNrOfActiveMenuItems();
    }

    public void setMenuItemTarget(int ndx, int view, int userData) {
        this.m_menuItems[ndx] = view;
        this.m_menuUserData[ndx] = userData;
    }

    public int getMenuItemTarget(int ndx) {
        return this.m_menuItems[ndx];
    }

    protected abstract boolean onSample();

    protected abstract void onPaint();

    protected abstract void onStart();

    protected void onPause() {
    }

    protected void onResume() {
    }

    protected void onEnd() {
    }

    protected void onKeyEvent(int type, int key) {
    }

    protected boolean onMenuEvent(int menuItem, int reserved) {
        return true;
    }

    protected void onPaintMenuItem(int menuItem, int userData, int x, int y, int w, int h) {
    }

    protected void onViewChange(int view) {
    }

    protected void onSerialize(DataInputStream in, DataOutputStream out) throws Exception {
    }

    private class DigCanvas
    extends Canvas {
        public DigCanvas() {
            DigGame.this.m_mutexPaint = new Object();
            DigGame.this.m_mutexEvents = new Object();
            DigGame.this.m_random = new Random();
            DigGame.this.m_random.setSeed(System.currentTimeMillis());
            try {
                DigGame.this.m_imgLoading = DigGame.this.createImage("/digloading");
                DigGame.this.loadImages("/digsplash", 1);
            }
            catch (Exception e) {
                DigGame.this.m_imgLoading = null;
            }
        }

        public final void showNotify() {
            if (DigGame.this.m_thread == null) {
                this.setFullScreenMode(true);
                DigGame.this.startThread();
            } else {
                DigGame.this.m_paused = false;
                Object object = DigGame.this.m_mutexEvents;
                synchronized (object) {
                    DigGame.this.onResume();
                }
                try {
                    object = DigGame.this.m_pauseNotify;
                    synchronized (object) {
                        DigGame.this.m_pauseNotify.notifyAll();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public final void keyPressed(int keyCode) {
            Object object = DigGame.this.m_mutexEvents;
            synchronized (object) {
                DigGame.this.onKeyEvent(KEY_PRESSED_EVENT, keyCode);
                if (DigGame.this.m_menuActive) {
                    DigGame.this.processMenuEvent(KEY_PRESSED_EVENT, keyCode);
                }
            }
        }

        public final void keyReleased(int keyCode) {
            Object object = DigGame.this.m_mutexEvents;
            synchronized (object) {
                DigGame.this.onKeyEvent(KEY_RELEASED_EVENT, keyCode);
            }
        }

        public final void synchronizedRepaint() {
            this.repaint();
            Object object = DigGame.this.m_mutexPaint;
            synchronized (object) {
                this.serviceRepaints();
            }
        }

        public final void paint(Graphics g) {
            Graphics graphics = g;
            synchronized (graphics) {
                DigGame.this.m_gfxBuffer = g;
                if (DigGame.this.m_gfxBuffer != null) {
                    DigGame.this.setColor(0, 0, 0);
                    g.fillRect(0, 0, DigGame.this.m_canvas.getWidth(), DigGame.this.m_canvas.getHeight());
                    g.setFont(Font.getFont((int)0, (int)0, (int)8));
                    if (m_splash) {
                        DigGame.this.drawImage(0, (DigGame.this.getDisplayWidth() >> 1) - (DigGame.this.getImageWidth(0, 0) >> 1), (DigGame.this.getDisplayHeight() >> 1) - (DigGame.this.getImageHeight(0, 0) >> 1));
                        m_splash = false;
                    }
                    DigGame.this.onPaint();
                    if (DigGame.this.m_menuActive && !DigGame.this.m_loading) {
                        int i = 0;
                        while (i < DigGame.this.m_menuNrOfActiveItems) {
                            if (DigGame.this.isMenuVisable(i)) {
                                DigGame.this.onPaintMenuItem(i, DigGame.this.m_menuUserData[i], DigGame.this.getMenuItemLeft(i), DigGame.this.getMenuItemTop(i), DigGame.this.getMenuItemWidth(i), DigGame.this.getMenuItemHeight(i));
                            }
                            ++i;
                        }
                    }
                    g.setColor(0, 196, 0);
                    g.fillRect(2, DigGame.this.getDisplayHeight(), DigGame.this.getDisplayWidth(), DigGame.this.m_canvas.getHeight() - DigGame.this.getDisplayHeight());
                    if (s_soft1) {
                        DigGame.this.setColor(0, 0, 0);
                        DigGame.this.m_gfxBuffer.drawString(DigGame.this.getCommandText(1), 3, DigGame.this.m_canvas.getHeight(), 36);
                        DigGame.this.setColor(255, 255, 255);
                        DigGame.this.m_gfxBuffer.drawString(DigGame.this.getCommandText(1), 2, DigGame.this.m_canvas.getHeight() - 1, 36);
                    }
                    if (s_soft1cnt) {
                        DigGame.this.setColor(0, 0, 0);
                        DigGame.this.m_gfxBuffer.drawString(DigGame.this.getCommandText(3), 3, DigGame.this.m_canvas.getHeight(), 36);
                        DigGame.this.setColor(255, 255, 255);
                        DigGame.this.m_gfxBuffer.drawString(DigGame.this.getCommandText(3), 2, DigGame.this.m_canvas.getHeight() - 1, 36);
                    }
                    if (s_soft2) {
                        DigGame.this.setColor(0, 0, 0);
                        DigGame.this.m_gfxBuffer.drawString(DigGame.this.getCommandText(2), DigGame.this.getDisplayWidth(), DigGame.this.m_canvas.getHeight(), 40);
                        DigGame.this.setColor(255, 255, 255);
                        DigGame.this.m_gfxBuffer.drawString(DigGame.this.getCommandText(2), DigGame.this.getDisplayWidth(), DigGame.this.m_canvas.getHeight() - 1, 40);
                    }
                    DigGame.this.m_gfxBuffer = null;
                }
            }
        }

        protected void hideNotify() {
            DigGame.this.m_paused = true;
            Object object = DigGame.this.m_mutexEvents;
            synchronized (object) {
                DigGame.this.onPause();
            }
            super.hideNotify();
        }
    }
}

