/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;

class SoundManager {
    public static int nSoundsLoaded = 0;
    private static final int MAX_SOUND_VOLUME = 5;
    private static int nVolume = 5;
    public static String szSoundDebug = null;
    public static boolean boSoundsLoaded = false;
    private static boolean boSoundOn = true;
    public static final int FORMAT_INVALID = -1;
    public static final int FORMAT_BEEP = 0;
    public static final int FORMAT_MIDI = 1;
    public static final int FORMAT_WAVE = 2;
    public static final int FORMAT_AMR = 3;
    public static final int FORMAT_TONE = 4;
    public static SoundData[] hSoundData = null;
    public static Player m_player = null;
    private static int SOUND_INVALID;
    public static int nLastSoundPlayed;
    public static SoundManager hInstance;
    public static final String FORMAT_MIDI_STRING = "audio/midi";
    public static final int SOUND_TITLE_MUSIC = 0;
    public static final int SOUND_INGAME_MUSIC = 1;
    public static final int SOUND_GAME_OVER = 2;
    public static final int SOUND_LEVEL_DONE = 3;
    public static final int NUM_SOUNDS_EFFECTS = 4;

    public static void LoadSounds() {
        try {
            SoundManager.CreateSound(0, 1, "/eggo_title_zero.mid");
            SoundManager.CreateSound(1, 1, "/eggo_ingame_zero.mid");
            SoundManager.CreateSound(2, 1, "/eggo_lose_v3_zero.mid");
            SoundManager.CreateSound(3, 1, "/eggo_win_zero.mid");
        }
        catch (Exception exception) {
            MFCanvas.log("Exception loading sounds" + exception.toString());
        }
        boSoundsLoaded = true;
    }

    public SoundManager() {
        hInstance = this;
    }

    public static boolean getSoundEnabled() {
        return false;
    }

    public static boolean getSoundVolumeControl() {
        return false;
    }

    public static int getSoundVolume() {
        return nVolume;
    }

    public static void setSoundVolume(int n) {
        if (n > 0 && n <= 5) {
            nVolume = n;
        }
    }

    public static boolean getSoundOn() {
        return boSoundOn;
    }

    public static void setSoundOn(boolean bl) {
        boSoundOn = bl;
    }

    public static void toggleSoundOn() {
        boSoundOn = !boSoundOn;
    }

    public static void Close() {
    }

    public static int GetSoundNumber(int n) {
        return n;
    }

    public static void Initialise() {
        hSoundData = new SoundData[4];
    }

    private static void playFile(String string, int n, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(string);
        try {
            InputStream inputStream = null;
            try {
                inputStream = hInstance.getClass().getResourceAsStream(string);
                System.out.println("Reading uncached file.");
            }
            catch (Exception exception) {
                MFCanvas.log("Error openeing resource stream " + string + " : " + exception.toString());
            }
            if (inputStream == null) {
                System.out.println("Error Playing sound");
                System.out.println("Could not find file " + stringBuffer.toString());
                return;
            }
            if (n == 1) {
                m_player = Manager.createPlayer((InputStream)inputStream, (String)FORMAT_MIDI_STRING);
            } else if (n == 2) {
                m_player = Manager.createPlayer((InputStream)inputStream, (String)"audio/wav");
            } else if (n == 3) {
                m_player = Manager.createPlayer((InputStream)inputStream, (String)"audio/amr");
            } else {
                MFCanvas.log("Unknown file format " + n + " for file " + stringBuffer.toString());
                return;
            }
            m_player.realize();
            m_player.prefetch();
            if (bl) {
                m_player.setLoopCount(-1);
            }
            m_player.start();
        }
        catch (Exception exception) {
            MFCanvas.log("Error playing sound file " + string + ", " + n + ", " + bl + ", " + exception.toString());
        }
    }

    private static void playTone(int n, int n2) {
        try {
            Manager.playTone((int)n, (int)n2, (int)(nVolume * 60 / 5));
        }
        catch (Exception exception) {
            MFCanvas.log("Error playing tone " + n + ", " + n2);
        }
    }

    public static boolean StopGameSound(int n) {
        try {
            if (n != -1 && nLastSoundPlayed == n && m_player != null) {
                try {
                    m_player.stop();
                }
                catch (Exception exception) {
                    System.out.println("m_player.stop() threw :" + exception.toString());
                }
                try {
                    m_player.start();
                }
                catch (Exception exception) {
                    MFCanvas.log("Exception restarting sound " + exception.toString());
                }
                return true;
            }
            if (m_player != null) {
                m_player.stop();
                if (n != -1) {
                    m_player.deallocate();
                    m_player.close();
                    m_player = null;
                }
            }
        }
        catch (Exception exception) {
            System.out.println("Error stopping sound");
            System.out.println(exception.toString());
            MFCanvas.log("Error stopping sound : " + exception.toString());
        }
        return false;
    }

    public static void Play(int n) {
        szSoundDebug = "P " + n;
        SoundManager.Play(n, false);
    }

    public static void Play(int n, boolean bl) {
        boolean bl2 = false;
        szSoundDebug = "P " + n + " " + bl;
        int n2 = SoundManager.GetSoundNumber(n);
        if (!boSoundOn || nVolume == 0) {
            n2 = -1;
        }
        szSoundDebug = "SE =  " + n2;
        try {
            bl2 = SoundManager.StopGameSound(n2);
        }
        catch (Exception exception) {
            System.out.println("Exception in stopping sound");
        }
        if (!bl2) {
            if (n2 != -1) {
                try {
                    System.out.println("PlaySoundEffect(" + n2 + ", " + bl + ")");
                    SoundManager.PlaySoundEffect(n2, bl);
                    System.out.println("skipping sound");
                }
                catch (Exception exception) {
                    MFCanvas.log("Error in playsound " + n + ", " + bl + " : " + exception.toString());
                }
            }
        } else {
            szSoundDebug = "restart?";
        }
    }

    public static void PlaySoundEffect(int n, boolean bl) {
        szSoundDebug = "PSE " + n;
        if (bl) {
            boolean bl2 = false;
        } else {
            boolean bl3 = true;
        }
        try {
            if (hSoundData[n] == null) {
                return;
            }
            if (SoundManager.hSoundData[n].nFormat == 0) {
                SoundManager.playTone(SoundManager.hSoundData[n].nFrequency, SoundManager.hSoundData[n].nLength);
            } else if (SoundManager.hSoundData[n].nFormat == 1 || SoundManager.hSoundData[n].nFormat == 2 || SoundManager.hSoundData[n].nFormat == 3) {
                SoundManager.playFile(SoundManager.hSoundData[n].szSoundFileName, SoundManager.hSoundData[n].nFormat, bl);
            }
        }
        catch (Exception exception) {
            MFCanvas.log("Error in PlaySoundEffect " + n + ", " + bl + " : " + exception.toString());
        }
        nLastSoundPlayed = n;
    }

    public static void CreateSound(int n, int n2, String string) {
        if (n == -1) {
            MFCanvas.log("Trying to create sound -1 from resource " + string);
            return;
        }
        try {
            SoundManager.hSoundData[n] = new SoundData(n2, string);
        }
        catch (Exception exception) {
            MFCanvas.log("Exception CreateSound " + n + " " + n2 + " " + string + " : " + exception.toString());
        }
        ++nSoundsLoaded;
    }

    public static void CreateSound(int n, int n2, int n3, int n4) {
        try {
            SoundManager.hSoundData[n] = new SoundData(n2, n3, n4);
        }
        catch (Exception exception) {
            MFCanvas.log("Error in CreateSound for tone" + n2 + " " + n3 + " " + n4 + " : " + exception.toString());
        }
        ++nSoundsLoaded;
    }

    public static void CreateSound(int n, int n2) {
        if (n2 != -1) {
            MFCanvas.log("Trying to create sound from nothing");
        }
        ++nSoundsLoaded;
    }

    public static void CreateSound(int n, int n2, byte[] byArray) {
        ++nSoundsLoaded;
    }

    public static void CreateSound(int n, int n2, int n3) {
        ++nSoundsLoaded;
    }

    static {
        nLastSoundPlayed = SOUND_INVALID = -1;
    }
}

