/*
 * Decompiled with CFR 0.152.
 */
import com.hellomoto.fullscreen.FullCn;
import javax.microedition.lcdui.Graphics;

public class MFCanvas
extends FullCn {
    public static final int NUM_KEYS = 21;
    public static final int OBJECTS_TO_LOAD = 41;
    public MFMain parent;
    public boolean[] keys;
    public boolean any_key_pressed;
    public int current_key;
    public static int nObjectsLoaded = 0;
    public static final int MAX_DEBUG_POINTS = 10;
    public static final int[] anDebugPoint = new int[20];
    public static int nDebugPoints = 0;
    public static int nBackGroundPosition = 0;
    boolean bFullScreen = false;

    public MFCanvas(MFMain mFMain) {
        this.parent = mFMain;
        this.setFullScreenMode(true);
        MFCache.getDispProperties(this);
        this.keys = new boolean[21];
        this.any_key_pressed = false;
    }

    protected void sizeChanged(int n, int n2) {
        MFCache.disp_width = n;
        MFCache.disp_height = n2;
        MFCache.disp_centerx = MFCache.disp_width >> 1;
        MFCache.disp_centery = MFCache.disp_height >> 1;
        MFCache.disp_xoff = (MFCache.disp_width - 176) / 2;
        if (MFCache.disp_xoff < 0) {
            MFCache.disp_xoff = 0;
        }
        if ((MFCache.disp_yoff = (MFCache.disp_height - 176) / 2) < 0) {
            MFCache.disp_yoff = 0;
        }
    }

    public static void AddDebugPos(int n, int n2) {
        if (nDebugPoints < 10) {
            System.out.println("Logging " + n + ", " + n2);
            MFCanvas.anDebugPoint[2 * MFCanvas.nDebugPoints] = n + MFCache.disp_xoff;
            MFCanvas.anDebugPoint[2 * MFCanvas.nDebugPoints + 1] = n2 + MFCache.disp_yoff;
            ++nDebugPoints;
        }
    }

    public static void DrawDebug(Graphics graphics) {
        for (int i = 0; i < nDebugPoints; ++i) {
            graphics.drawImage(MFMain.imgTarget, anDebugPoint[2 * i] - MFMain.imgTarget.getWidth() / 2, anDebugPoint[2 * i + 1] - MFMain.imgTarget.getHeight() / 2 - nBackGroundPosition, 20);
        }
        nDebugPoints = 0;
    }

    public void showgameCommandListener() {
    }

    public void hidegameCommandListener() {
    }

    public void clean() {
        this.parent = null;
        this.keys = null;
        MFCache.forceGC();
    }

    protected void paint(Graphics graphics) {
        if (!this.bFullScreen) {
            this.setFullScreenMode(true);
            this.bFullScreen = true;
            return;
        }
        MFCache.getDispProperties(this);
        if (!MFMain.boFinishedInitialisation) {
            MFCanvas.DrawPlainLoadingScreen(graphics);
            return;
        }
        try {
            this.parent.draw(graphics);
            graphics.setClip(0, 0, MFCache.disp_width, MFCache.disp_height);
            MFCanvas.DrawDebug(graphics);
        }
        catch (Exception exception) {
            try {
                System.out.println("Exception Painting game : " + exception.toString());
                exception.printStackTrace();
                Thread.sleep(4000L);
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
    }

    protected void KEYPRESSED(int n) {
        this.setKey(n, true);
        if (this.parent.demo_mode) {
            MFMain.pscore = 0;
            this.parent.demo_mode = false;
            this.parent.ingame_active = false;
            this.clearAllKeys();
        }
        this.any_key_pressed = true;
    }

    protected void KEYRELEASED(int n) {
        this.setKey(n, false);
        this.any_key_pressed = false;
    }

    protected void setKey(int n, boolean bl) {
        int n2 = 0;
        try {
            n2 = this.getGameAction(n);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            n2 = 0;
        }
        this.parent.demo_start_time = 0;
        if (n == -7) {
            this.keys[14] = bl;
        } else if (n == -6) {
            this.keys[16] = bl;
        } else if (n2 == 1) {
            this.keys[20] = bl;
        } else if (n2 == 6) {
            this.keys[19] = bl;
        } else if (n2 == 2) {
            this.keys[18] = bl;
        } else if (n2 == 5) {
            this.keys[17] = bl;
        } else if (n2 == 8) {
            this.keys[15] = bl;
            this.keys[7] = bl;
        }
        if (n >= 48 && n <= 57) {
            this.keys[n - 48] = bl;
        }
    }

    public void clearAllKeys() {
        for (int i = 0; i < 21; ++i) {
            this.keys[i] = false;
        }
    }

    protected void showNotify() {
        this.parent.game_paused = false;
        MFMain.app_paused = false;
        MFMain.clear_screen = true;
        MFMain.full_refresh = true;
        this.parent.chiscore_screen = true;
        this.parent.update_wobblem = true;
    }

    protected void hideNotify() {
        if (this.parent != null) {
            this.parent.game_paused = true;
            MFMain.app_paused = true;
        }
    }

    public static void log(String string) {
        System.out.println(string);
    }

    public static void loadProgress() {
        ++nObjectsLoaded;
        MFMain.repaintGame();
    }

    public static void drawShadowedText(Graphics graphics, String string, int n, int n2, int n3) {
        graphics.setClip(0, 0, MFCache.disp_width, MFCache.disp_height);
        graphics.setColor(0);
        graphics.fillRect(n, n2, 40, 15);
        graphics.drawString(string, n + 1, n2 + 1, n3);
        graphics.setColor(0xFFFFFF);
        graphics.drawString(string, n, n2, n3);
    }

    public static void DrawPlainLoadingScreen(Graphics graphics) {
        graphics.setClip(0, 0, MFCache.disp_width, MFCache.disp_height);
        graphics.setColor(0);
        graphics.fillRect(0, 0, MFCache.disp_width, MFCache.disp_height);
        graphics.setColor(0xFFFFFF);
        graphics.drawString("Loading", MFCache.disp_width / 2, MFCache.disp_height / 2, 17);
        int n = MFCache.disp_width / 2;
        int n2 = 3 * MFCache.disp_height / 4;
        int n3 = 20;
        int n4 = MFCache.disp_width * 4 / 5;
        int n5 = n4 * nObjectsLoaded / 41;
        graphics.drawRect(n - n4 / 2, n2, n4, n3);
        graphics.fillRect(n - n5 / 2, n2, n5, n3);
    }
}

