/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Juego
extends Canvas
implements Runnable {
    private int ancho = this.getWidth();
    private int alto = this.getHeight();
    private Vector ranas;
    private Image fondo = null;
    private Image presentacion = null;
    private Image gameOver = null;
    public static Juego instancia;
    public static final String VERSION = "0.3b";
    protected int cantRanas;
    protected int tiempoPresentacion;
    protected int tiempoGameOver;
    protected int puntos;
    protected Font fuentePuntos;

    public Juego() {
        Hoja.crear(this.ancho, this.alto);
        Vidas.crear(this.ancho, this.alto);
        this.fondo = Grafico.crearImagen("/imagenes/fondo.png", this.ancho, this.alto, 0xAAAA22);
        this.presentacion = Grafico.crearImagen("/imagenes/presentacion.png", this.ancho, this.alto, 0x2222AA);
        this.gameOver = Grafico.crearImagen("/imagenes/gameover.png", this.ancho, 50, 0);
        instancia = this;
        this.restart();
        this.fuentePuntos = Font.getFont((int)64, (int)1, (int)0);
    }

    protected void mover() {
        Hoja.instancia.mover();
        for (int i = 0; i < this.ranas.size(); ++i) {
            ((Rana)this.ranas.elementAt(i)).mover();
        }
        Vidas.instancia.mover();
    }

    protected void draw(Graphics g) {
        Rana rene;
        int i;
        g.drawImage(this.fondo, 0, 0, 0);
        for (i = 0; i < this.ranas.size(); ++i) {
            rene = (Rana)this.ranas.elementAt(i);
            if (!rene.getEstaNadando()) continue;
            rene.draw(g);
        }
        Hoja.instancia.draw(g);
        for (i = 0; i < this.ranas.size(); ++i) {
            rene = (Rana)this.ranas.elementAt(i);
            if (rene.getEstaNadando()) continue;
            rene.draw(g);
        }
        Vidas.instancia.draw(g);
    }

    public void colocarPuntos(Graphics g) {
        g.setFont(this.fuentePuntos);
        String aux = this.puntos + " points";
        int auxLargo = aux.length();
        char[] auxBytes = aux.toCharArray();
        g.setColor(0xFFFFFF);
        g.drawChars(auxBytes, 0, auxLargo, 6, 2, 0);
        g.drawChars(auxBytes, 0, auxLargo, 4, 2, 0);
        g.drawChars(auxBytes, 0, auxLargo, 6, 0, 0);
        g.drawChars(auxBytes, 0, auxLargo, 4, 0, 0);
        g.setColor(0);
        g.drawChars(auxBytes, 0, auxLargo, 5, 1, 0);
    }

    protected void paint(Graphics g) {
        if (this.tiempoPresentacion > 0) {
            g.drawImage(this.presentacion, 0, 0, 0);
            g.setFont(this.fuentePuntos);
            g.setColor(0);
            g.drawChars("version 0.3b".toCharArray(), 0, "version 0.3b".length(), 6, 2, 0);
            g.setColor(0x77BB77);
            g.drawChars("version 0.3b".toCharArray(), 0, "version 0.3b".length(), 5, 1, 0);
            --this.tiempoPresentacion;
        } else {
            if (this.tiempoGameOver > 0) {
                g.drawImage(this.gameOver, (this.ancho - this.gameOver.getWidth()) / 2, (this.alto - this.gameOver.getHeight()) / 2, 0);
                --this.tiempoGameOver;
                if (this.tiempoGameOver == 0) {
                    this.restart();
                }
            } else {
                this.mover();
                this.mover();
                this.draw(g);
            }
            this.colocarPuntos(g);
        }
    }

    public Vector getRanas() {
        return this.ranas;
    }

    public void run() {
        while (true) {
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (Vidas.instancia.getVidas() == 0 && this.tiempoGameOver == 0) {
                this.tiempoGameOver = 2000;
            }
            this.repaint();
        }
    }

    public void agregarRana() {
        this.ranas.addElement(new Rana(this.ancho, this.alto));
        ++this.cantRanas;
    }

    public int getCantRanas() {
        return this.cantRanas;
    }

    public void sumarPuntos() {
        this.puntos += 5;
    }

    public void restart() {
        this.ranas = new Vector();
        this.cantRanas = 0;
        this.agregarRana();
        for (int i = 0; i < this.ranas.size(); ++i) {
            ((Rana)this.ranas.elementAt(i)).init();
        }
        Hoja.instancia.init();
        Vidas.instancia.init();
        this.tiempoPresentacion = 100;
        this.tiempoGameOver = 0;
        this.puntos = 0;
    }

    public void keyPressed(int keyCode) {
        block0 : switch (this.getGameAction(keyCode)) {
            case 1: {
                Hoja.instancia.cambiar();
                break;
            }
            case 6: {
                Hoja.instancia.cambiar();
                break;
            }
            case 2: {
                Hoja.instancia.cambiar();
                break;
            }
            case 5: {
                Hoja.instancia.cambiar();
                break;
            }
            case 0: {
                switch (keyCode) {
                    case 53: {
                        Hoja.instancia.cambiar();
                        break block0;
                    }
                    case 56: {
                        Hoja.instancia.cambiar();
                        break block0;
                    }
                    case 52: {
                        Hoja.instancia.cambiar();
                        break block0;
                    }
                    case 54: {
                        Hoja.instancia.cambiar();
                    }
                }
            }
        }
    }
}

