/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public abstract class Grafico {
    protected int x;
    protected int y;
    protected int vx;
    protected int vy;
    private int anchoCanvasReal;
    private int altoCanvasReal;
    private int relacionAnchoCanvas;
    private int relacionAltoCanvas;
    protected static final int anchoCanvas = 1000000;
    protected static final int altoCanvas = 1000000;
    protected int anchoImagen;
    protected int altoImagen;

    public Grafico(int anchoCanvasReal, int altoCanvasReal) {
        this.anchoCanvasReal = anchoCanvasReal;
        this.altoCanvasReal = altoCanvasReal;
        this.relacionAnchoCanvas = 1000000 / anchoCanvasReal;
        this.relacionAltoCanvas = 1000000 / altoCanvasReal;
        this.x = 0;
        this.y = 0;
        this.vx = 0;
        this.vy = 0;
        this.anchoImagen = 0;
        this.altoImagen = 0;
    }

    abstract void draw(Graphics var1);

    abstract void init();

    abstract void mover();

    public static Image crearImagen(String nombre, int ancho, int alto, int color) {
        Image aux = null;
        try {
            aux = Image.createImage((String)nombre);
        }
        catch (IOException ex) {
            aux = Image.createImage((int)ancho, (int)alto);
            Graphics g = aux.getGraphics();
            g.setColor(color);
            g.fillRect(0, 0, ancho, alto);
        }
        return aux;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getVx() {
        return this.vx;
    }

    public int getVy() {
        return this.vy;
    }

    public int getAncho() {
        return this.anchoImagen;
    }

    public int getAlto() {
        return this.anchoImagen;
    }

    public int getXFinal() {
        return this.x + this.anchoImagen;
    }

    public int getYFinal() {
        return this.y + this.anchoImagen;
    }

    public int getXCanvas() {
        return this.x / this.relacionAnchoCanvas;
    }

    public int getYCanvas() {
        return this.y / this.relacionAnchoCanvas;
    }

    protected void setAncho(int ancho) {
        this.anchoImagen = ancho * this.relacionAnchoCanvas;
    }

    protected void setAlto(int alto) {
        this.altoImagen = alto * this.relacionAltoCanvas;
    }

    protected void setAtributosDesdeImagen(Image img) {
        this.setAncho(img.getWidth());
        this.setAlto(img.getHeight());
    }

    protected void dibujarImagen(Image img, int x, int y, Graphics g) {
        g.drawImage(img, x / this.relacionAnchoCanvas, y / this.relacionAltoCanvas, 0);
    }

    public boolean colision(Grafico grafico) {
        if (this.getX() + this.getAncho() / 4 < grafico.getX()) {
            return false;
        }
        if (this.getXFinal() - this.getAncho() / 4 > grafico.getXFinal()) {
            return false;
        }
        if (this.getY() + this.getAlto() / 4 < grafico.getY()) {
            return false;
        }
        return this.getYFinal() - this.getAlto() / 4 <= grafico.getYFinal();
    }
}

