/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Rana
extends Grafico {
    private static Image rana = null;
    private static Image nadando = null;
    private static int vg = 30;
    private static int ranasSobreLaHoja = 0;
    private int alturaPiso = 800000;
    private int tiempoEspera;
    private int tiempo;
    private int tiempoBorde;
    private int tiempoDesaparece;
    private boolean sobreLaHoja;
    private boolean llegoAlBorde;
    private boolean estaNadando;
    private static int VelocidadX = 5000;
    private static int VelocidadY = 10000;
    private int difXHoja;

    public Rana(int anchoCanvasReal, int altoCanvasReal) {
        super(anchoCanvasReal, altoCanvasReal);
        if (rana == null) {
            rana = Rana.crearImagen("/imagenes/rana.png", 15, 15, 0x55FF55);
        }
        if (nadando == null) {
            nadando = Rana.crearImagen("/imagenes/nadando.png", 20, 20, 0x55FF55);
        }
        this.setAtributosDesdeImagen(rana);
        this.init();
    }

    public void init() {
        if (Main.random(2) == 1) {
            this.x = 10000;
            this.vx = VelocidadX + Main.random(VelocidadX);
        } else {
            this.x = 1000000 - this.getAncho() - 10000;
            this.vx = 0 - VelocidadX - Main.random(VelocidadX);
        }
        this.y = 100000 + Main.random(100000);
        this.vy = 0 - VelocidadY;
        this.tiempoEspera = 100 + Main.random(300);
        this.tiempo = 0;
        this.sobreLaHoja = false;
        this.llegoAlBorde = false;
        this.tiempoDesaparece = 0;
        this.estaNadando = false;
        this.difXHoja = 0;
    }

    public void nadar() {
        this.x += this.vx;
        if (this.x < -500000 || this.x > 1500000) {
            Vidas.instancia.escapoRana();
            this.init();
        }
    }

    public void entrarEnLaHoja() {
        this.difXHoja = this.getX() - Hoja.instancia.getX();
        if (++ranasSobreLaHoja >= 6) {
            Vector ranas = Juego.instancia.getRanas();
            int tiradas = 0;
            for (int i = 0; i < ranas.size(); ++i) {
                Rana rene = (Rana)ranas.elementAt(i);
                if (!rene.sobreLaHoja || tiradas >= 2) continue;
                ++tiradas;
                rene.sobreLaHoja = false;
                rene.y = this.alturaPiso;
                --ranasSobreLaHoja;
            }
        }
    }

    public boolean getEstaNadando() {
        return this.estaNadando;
    }

    public void caer() {
        this.x += this.vx;
        if (this.y < this.alturaPiso) {
            this.y += this.vy + this.tiempo * this.tiempo * vg;
        } else {
            this.estaNadando = true;
            if (this.vx > 0) {
                this.vx *= -1;
            }
        }
        if (!this.estaNadando) {
            this.sobreLaHoja = this.colision(Hoja.instancia);
            if (this.sobreLaHoja) {
                this.entrarEnLaHoja();
            }
        }
    }

    public void esperarBorde() {
        if (!Hoja.instancia.llegoAlBorde()) {
            this.x = Hoja.instancia.getX() + this.difXHoja;
            this.tiempoBorde = 20;
        } else {
            --this.tiempoBorde;
            if (this.tiempoBorde == 0) {
                this.llegoAlBorde = true;
                this.tiempoDesaparece = 200;
                Vidas.instancia.llegoRana();
                Juego.instancia.sumarPuntos();
                --ranasSobreLaHoja;
            }
        }
    }

    public void parpadear() {
        --this.tiempoDesaparece;
        if (this.tiempoDesaparece == 0) {
            this.init();
        }
    }

    public void mover() {
        if (this.tiempoEspera > 0) {
            --this.tiempoEspera;
            return;
        }
        this.tiempoEspera = 1;
        ++this.tiempo;
        if (this.estaNadando) {
            this.nadar();
        } else if (!this.sobreLaHoja) {
            this.caer();
        } else if (!this.llegoAlBorde) {
            this.esperarBorde();
        } else {
            this.parpadear();
        }
    }

    public void draw(Graphics g) {
        if (this.estaNadando) {
            this.dibujarImagen(nadando, this.x, this.y, g);
        } else if (this.tiempoDesaparece / 20 % 2 == 0) {
            this.dibujarImagen(rana, this.x, this.y, g);
        }
    }
}

