/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

class BubbleControllerDestroy
extends BubbleController {
    private static final int MAX_STEP = 5;
    private byte m_step = 0;
    private boolean m_first_flag = true;
    private byte m_repaint_flag = 0;

    public int DelayTime() {
        if (this.m_repaint_flag == 1) {
            this.m_repaint_flag = (byte)2;
            try {
                Thread.currentThread();
                Thread.sleep(400L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return 400;
        }
        try {
            Thread.currentThread();
            Thread.sleep(50L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 50;
    }

    public void SetRepaintFlag() {
        this.m_repaint_flag = 1;
    }

    public boolean IsRepaint() {
        return this.m_repaint_flag != 0;
    }

    public void Repaint(BubbleGame bubblegame) {
        if (this.m_repaint_flag == 2) {
            bubblegame.repaint();
            this.m_repaint_flag = 0;
        }
    }

    public void FirstTime() {
        this.m_first_flag = true;
    }

    public void Init(BubbleGame bubblegame, Image image) {
        BubbleController.m_offscreen = image;
        this.m_step = 0;
    }

    public void CreateOffscreen(BubbleGame bubblegame) {
        Graphics g = BubbleController.m_offscreen.getGraphics();
        BubblePool bubblepool = bubblegame.GetBubblePool();
        Image image = BubbleSmile.GetImage();
        for (byte byte1 = 0; byte1 < 9; byte1 = (byte)(byte1 + 1)) {
            for (byte byte0 = 0; byte0 < 7; byte0 = (byte)(byte0 + 1)) {
                Bubble bubble = bubblepool.GetBubble(byte0, byte1);
                if (bubble == null || !bubble.IsDelete()) continue;
                int k = bubblegame.Pos2Pixel(byte0, byte1);
                int i = k & 0xFFFF;
                int j = k >> 16 & 0xFFFF;
                g.setClip(i, j, 15, 15);
                g.drawImage(image, i - 100, j, 20);
            }
        }
        g.setClip(0, 0, 132, 176);
    }

    public void KeyPressed(BubbleGame bubblegame, int i) {
    }

    public void Final(Graphics g, BubbleGame bubblegame) {
        BubblePool bubblepool = bubblegame.GetBubblePool();
        boolean flag = bubblepool.DeleteBubbles();
        ScorePool scorepool = bubblegame.GetScorePool();
        scorepool.UnlockScores();
        if (flag) {
            BubbleControllerDownAndFill bubblecontrollerdownandfill = new BubbleControllerDownAndFill();
            bubblecontrollerdownandfill.Init(BubbleController.m_offscreen);
            this.SetActive(false);
            bubblecontrollerdownandfill.SetActive(true);
            bubblegame.repaint();
            return;
        }
        this.SetActive(false);
        bubblegame.repaint();
    }

    public void Draw(Graphics g, BubbleGame bubblegame) {
        if (this.m_first_flag) {
            ScorePool scorepool = bubblegame.GetScorePool();
            scorepool.IncreaseComboCnt();
            BubblePool bubblepool = bubblegame.GetBubblePool();
            Checker checker = bubblegame.GetChecker();
            boolean flag = checker.CheckSame(bubblepool, bubblegame);
            if (!flag) {
                bubblegame.repaint();
                this.SetActive(false);
                return;
            }
            this.m_first_flag = false;
            this.CreateOffscreen(bubblegame);
            BubbleSmile.PlaySound(2);
        }
        this.DrawBubbles(BubbleController.m_offscreen.getGraphics(), bubblegame);
        g.drawImage(BubbleController.m_offscreen, 0, 0, 20);
        bubblegame.DrawScore(g);
        bubblegame.DrawConstraint(g);
        bubblegame.DrawCombos(g);
        this.m_step = (byte)(this.m_step + 1);
        if (this.m_step >= 5) {
            this.Final(g, bubblegame);
        }
        bubblegame.repaint();
    }

    public void DrawBubbles(Graphics g, BubbleGame bubblegame) {
        BubblePool bubblepool = bubblegame.GetBubblePool();
        Image image = bubblegame.GetBubbleImages();
        for (byte byte1 = 0; byte1 < 9; byte1 = (byte)(byte1 + 1)) {
            for (byte byte0 = 0; byte0 < 7; byte0 = (byte)(byte0 + 1)) {
                Bubble bubble = bubblepool.GetBubble(byte0, byte1);
                if (bubble == null) continue;
                int i = bubblegame.Pos2Pixel(byte0, byte1);
                if (!bubble.IsDelete()) continue;
                bubble.Draw(g, image, i & 0xFFFF, i >> 16 & 0xFFFF);
                bubble.NextDeleteStatus();
            }
        }
    }
}

