/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

class BubbleControllerMove
extends BubbleController {
    private static final int MAX_STEP = 0;
    private static final byte[] m_step_delta_x = new byte[]{5, 7};
    private static final byte[] m_step_delta_y = new byte[]{4, 8};
    private byte m_step;
    private boolean m_immediate_mode = false;

    public void Init(BubbleGame bubblegame, Image image) {
        this.m_step = 0;
        BubbleController.m_offscreen = image;
    }

    public void Final(BubbleGame bubblegame) {
        BubblePool bubblepool = bubblegame.GetBubblePool();
        bubblepool.MoveBubble();
        this.SetActive(false);
    }

    public void KeyPressed(BubbleGame bubblegame, int i) {
    }

    public void Draw(Graphics g, BubbleGame bubblegame) {
        g.drawImage(BubbleController.m_offscreen, 0, 0, 20);
        bubblegame.DrawScore(g);
        bubblegame.DrawConstraint(g);
        this.DrawBubbles(g, bubblegame, false);
        this.m_step = (byte)(this.m_step + 1);
        if (this.m_step >= 0) {
            this.Final(bubblegame);
        }
    }

    public void DrawBubbles(Graphics g, BubbleGame bubblegame, boolean flag) {
        BubblePool bubblepool = bubblegame.GetBubblePool();
        Image image = bubblegame.GetBubbleImages();
        for (byte byte0 = 0; byte0 < 7; byte0 = (byte)(byte0 + 1)) {
            for (byte byte1 = 8; byte1 >= 0; byte1 = (byte)(byte1 - 1)) {
                Bubble bubble = bubblepool.GetBubble(byte0, byte1);
                if (bubble == null || !bubble.IsMoving()) continue;
                int i = bubblegame.Pos2Pixel(byte0, byte1);
                i = BubbleControllerMove.ApplyDirectionWithStep(bubble, i);
                bubble.NextMovingStatus();
                bubble.Draw(g, image, i & 0xFFFF, i >> 16 & 0xFFFF);
            }
        }
    }

    public static int ApplyDirectionWithStep(Bubble bubble, int i) {
        int j = i & 0xFFFF;
        int k = i >> 16 & 0xFFFF;
        switch (bubble.GetDirection()) {
            case 1: {
                j += m_step_delta_x[0];
                k -= m_step_delta_y[0];
                break;
            }
            case 2: {
                j += m_step_delta_x[0];
                k += m_step_delta_y[0];
                break;
            }
            case 3: {
                j -= m_step_delta_x[0];
                break;
            }
            case -1: {
                j -= m_step_delta_x[0];
                k += m_step_delta_y[0];
                break;
            }
            case -2: {
                j -= m_step_delta_x[0];
                k -= m_step_delta_y[0];
                break;
            }
            case -3: {
                j += m_step_delta_x[0];
            }
        }
        return j | k << 16;
    }

    public int DelayTime() {
        return 0;
    }

    public void SetImmediateMode(boolean flag) {
        this.m_immediate_mode = flag;
    }
}

