/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class BubbleControllerNormal
extends BubbleController {
    private byte[] m_bonus_flag = null;
    private int[] m_bonus_bondary = null;

    public boolean IsRepaint() {
        return true;
    }

    public void Init(BubbleGame bubblegame) {
        Graphics g = BubbleController.m_offscreen.getGraphics();
        this.DrawOffscreen(g, bubblegame);
        this.m_bonus_flag = new byte[5];
        for (int i = 0; i < this.m_bonus_flag.length; ++i) {
            this.m_bonus_flag[i] = 0;
        }
        this.m_bonus_bondary = new int[6];
        this.m_bonus_bondary[0] = 500;
        this.m_bonus_bondary[1] = 2000;
        this.m_bonus_bondary[2] = 4000;
        this.m_bonus_bondary[3] = 6000;
        this.m_bonus_bondary[4] = 8000;
        this.m_bonus_bondary[5] = 16000;
    }

    public void AdjustBonusFlagByScore(int i) {
        for (int j = 0; j < 5; ++j) {
            if (i <= this.m_bonus_bondary[j]) continue;
            this.m_bonus_flag[j] = 1;
        }
    }

    public void Draw(Graphics g, BubbleGame bubblegame) {
        BubbleGameMode bubblegamemode = bubblegame.GetBubbleGameMode();
        if (!bubblegamemode.IsValid()) {
            BubbleControllerGameOver bubblecontrollergameover = new BubbleControllerGameOver();
            this.SetActive(false);
            bubblecontrollergameover.SetActive(true);
            return;
        }
        boolean flag = false;
        ScorePool scorepool = bubblegame.GetScorePool();
        int i = scorepool.GetTotalScore();
        for (int j = 0; j < 5; ++j) {
            if (this.m_bonus_flag[j] != 0 || i < this.m_bonus_bondary[j] || i >= this.m_bonus_bondary[j + 1]) continue;
            this.m_bonus_flag[j] = 1;
            Checker checker = bubblegame.GetChecker();
            checker.SetBonusMode();
            BubbleSmile.PlaySound(6);
            flag = true;
            break;
        }
        if (bubblegamemode.IsTimedMode()) {
            bubblegamemode.MoveTimer();
        }
        g.drawImage(BubbleController.m_offscreen, 0, 0, 20);
        this.DrawBubbles(g, bubblegame);
        bubblegame.DrawScore(g);
        bubblegame.DrawConstraint(g);
        bubblegame.DrawCursor(g);
        bubblegame.DrawCombos(g);
        if (flag) {
            scorepool.Clear();
            BubbleControllerDestroy bubblecontrollerdestroy = new BubbleControllerDestroy();
            BubbleControllerDownAndFill.FirstTime();
            bubblecontrollerdestroy.Init(bubblegame, BubbleController.m_offscreen);
            bubblecontrollerdestroy.SetRepaintFlag();
            bubblecontrollerdestroy.SetActive(true);
            bubblegame.repaint();
        }
    }

    void DrawOffscreen(Graphics g, BubbleGame bubblegame) {
        bubblegame.DrawBoard(g);
        BubblePool bubblepool = bubblegame.GetBubblePool();
        Image image = bubblegame.GetBubbleImages();
        for (byte byte1 = 0; byte1 < 9; byte1 = (byte)(byte1 + 1)) {
            for (byte byte0 = 0; byte0 < 7; byte0 = (byte)(byte0 + 1)) {
                Bubble bubble = bubblepool.GetBubble(byte0, byte1);
                if (bubble == null) continue;
                int i = bubblegame.Pos2Pixel(byte0, byte1);
                bubble.Draw(g, image, i & 0xFFFF, i >> 16 & 0xFFFF);
            }
        }
        BubbleGameMode bubblegamemode = bubblegame.GetBubbleGameMode();
        if (bubblegamemode.IsSkilledMode()) {
            g.setClip(76, 1, 21, 8);
            g.drawImage(BubbleSmile.GetImage(), 76, -24, 20);
        }
    }

    public void KeyPressed(BubbleGame bubblegame, int i) {
        bubblegame.GetScorePool().Clear();
        Cursor cursor = bubblegame.GetCursor();
        BubbleGameMode bubblegamemode = bubblegame.GetBubbleGameMode();
        switch (i) {
            case -61: 
            case 52: {
                cursor.Move((byte)0);
                break;
            }
            case -62: 
            case 54: {
                cursor.Move((byte)1);
                break;
            }
            case -59: 
            case 50: {
                cursor.Move((byte)2);
                break;
            }
            case -60: 
            case 56: {
                cursor.Move((byte)3);
                break;
            }
            case -4: 
            case -1: 
            case 49: 
            case 51: {
                BubbleController bubblecontroller = BubbleController.CurrentController();
                if (bubblecontroller == null) {
                    return;
                }
                if (!bubblecontroller.getClass().getName().equals("BubbleControllerNormal")) break;
                if (bubblegamemode.IsSkilledMode()) {
                    bubblegamemode.DecreaseRotation();
                }
                BubbleControllerRotator bubblecontrollerrotator = new BubbleControllerRotator();
                if (i == 51 || i == -4) {
                    bubblecontrollerrotator.Init(bubblegame, true, BubbleController.m_offscreen);
                } else {
                    bubblecontrollerrotator.Init(bubblegame, false, BubbleController.m_offscreen);
                }
                bubblecontrollerrotator.SetActive(true);
                bubblegame.repaint();
                break;
            }
            default: {
                return;
            }
        }
    }

    public void DrawBubbles(Graphics g, BubbleGame bubblegame) {
        BubblePool bubblepool = bubblegame.GetBubblePool();
        Image image = bubblegame.GetBubbleImages();
        for (byte byte1 = 0; byte1 < 9; byte1 = (byte)(byte1 + 1)) {
            for (byte byte0 = 0; byte0 < 7; byte0 = (byte)(byte0 + 1)) {
                Bubble bubble = bubblepool.GetBubble(byte0, byte1);
                if (bubble == null) continue;
                bubble.RandomizeNormalStatus();
                if (!bubble.IsGrin()) continue;
                int i = bubblegame.Pos2Pixel(byte0, byte1);
                bubble.Draw(g, image, i & 0xFFFF, i >> 16 & 0xFFFF);
            }
        }
    }
}

