/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

class BubbleControllerRotator
extends BubbleController {
    private boolean m_first = true;
    private boolean m_dir = true;
    private short m_p1 = 0;
    private short m_p2 = 0;
    private short m_p3 = 0;

    BubbleControllerRotator() {
    }

    public void Init(BubbleGame bubblegame, boolean flag, Image image) {
        this.m_first = true;
        this.m_dir = flag;
        BubbleController.m_offscreen = image;
    }

    public void First(BubbleGame bubblegame) {
        Graphics g = BubbleController.m_offscreen.getGraphics();
        this.EraseBubbles(g, bubblegame);
        Cursor cursor = bubblegame.GetCursor();
        this.m_p1 = cursor.GetAt(0);
        this.m_p2 = cursor.GetAt(1);
        this.m_p3 = cursor.GetAt(2);
        cursor.Rotation(bubblegame, this.m_dir);
    }

    public void Final(BubbleGame bubblegame) {
        Graphics g = BubbleController.m_offscreen.getGraphics();
        BubblePool bubblepool = bubblegame.GetBubblePool();
        Cursor cursor = bubblegame.GetCursor();
        Image image = bubblegame.GetBubbleImages();
        short word0 = 0;
        for (int i = 0; i < 3; ++i) {
            switch (i) {
                case 0: {
                    word0 = this.m_p1;
                    break;
                }
                case 1: {
                    word0 = this.m_p2;
                    break;
                }
                case 2: {
                    word0 = this.m_p3;
                }
            }
            byte byte0 = (byte)(word0 & 0xFF);
            byte byte1 = (byte)(word0 >> 8 & 0xFF);
            Bubble bubble = bubblepool.GetBubble(byte0, byte1);
            int j = bubblegame.Pos2Pixel(byte0, byte1);
            bubble.DrawNormal(g, image, j & 0xFFFF, j >> 16 & 0xFFFF);
        }
    }

    public void Draw(Graphics g, BubbleGame bubblegame) {
        if (this.m_first) {
            this.m_first = false;
            this.First(bubblegame);
            g.drawImage(BubbleController.m_offscreen, 0, 0, 20);
            this.DrawBubbles(g, bubblegame);
            BubbleSmile.PlaySound(3);
        } else {
            BubblePool bubblepool = bubblegame.GetBubblePool();
            bubblepool.MoveBubble();
            this.Final(bubblegame);
            g.drawImage(BubbleController.m_offscreen, 0, 0, 20);
            BubbleControllerDestroy bubblecontrollerdestroy = new BubbleControllerDestroy();
            BubbleControllerDownAndFill.FirstTime();
            bubblecontrollerdestroy.Init(bubblegame, BubbleController.m_offscreen);
            this.SetActive(false);
            bubblecontrollerdestroy.SetActive(true);
        }
        bubblegame.DrawScore(g);
        bubblegame.DrawConstraint(g);
        bubblegame.DrawCombos(g);
        bubblegame.repaint();
    }

    public int DelayTime() {
        try {
            Thread.currentThread();
            Thread.sleep(50L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 50;
    }

    public void EraseBubbles(Graphics g, BubbleGame bubblegame) {
        Cursor cursor = bubblegame.GetCursor();
        BubblePool bubblepool = bubblegame.GetBubblePool();
        Image image = BubbleSmile.GetImage();
        for (int k = 0; k < 3; ++k) {
            short word0 = cursor.GetAt(k);
            byte byte0 = (byte)(word0 & 0xFF);
            byte byte1 = (byte)(word0 >> 8 & 0xFF);
            Bubble bubble = bubblepool.GetBubble(byte0, byte1);
            int l = bubblegame.Pos2Pixel(byte0, byte1);
            int i = l & 0xFFFF;
            int j = l >> 16 & 0xFFFF;
            g.setClip(i, j, 15, 15);
            g.drawImage(image, i - 100, j, 20);
        }
    }

    public void DrawBubbles(Graphics g, BubbleGame bubblegame) {
        BubblePool bubblepool = bubblegame.GetBubblePool();
        Image image = bubblegame.GetBubbleImages();
        for (byte byte0 = 0; byte0 < 7; byte0 = (byte)(byte0 + 1)) {
            for (byte byte1 = 8; byte1 >= 0; byte1 = (byte)(byte1 - 1)) {
                Bubble bubble = bubblepool.GetBubble(byte0, byte1);
                if (bubble == null || !bubble.IsMoving()) continue;
                int i = bubblegame.Pos2Pixel(byte0, byte1);
                i = BubbleControllerMove.ApplyDirectionWithStep(bubble, i);
                bubble.NextMovingStatus();
                bubble.Draw(g, image, i & 0xFFFF, i >> 16 & 0xFFFF);
            }
        }
    }
}

