/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.util.Random;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.rms.InvalidRecordIDException;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreNotOpenException;

public class BubbleGame
extends Canvas {
    public static final int OFFSET_X_OF_ODD_LINE = 8;
    public static final int OFFSET_Y_OF_ODD_LINE = 5;
    public static final int BUBBLE_IMAGE_W = 15;
    public static final int BUBBLE_IMAGE_H = 15;
    private static final int BUBBLE_OFFSET_X = 7;
    private static final int BUBBLE_OFFSET_Y = 11;
    private static final int GAUGE_LEN = 8;
    private static final String STG = "BUBBLESMILE";
    BubbleSmile m_bs;
    private Image m_img_back;
    private Image m_img_bubble;
    private Image m_img_offscreen;
    private BubblePool m_pool;
    private Cursor m_cursor;
    private Checker m_checker;
    private ScorePool m_sp;
    private BubbleGameMode m_mode;
    private BubbleGameThread m_thread;
    private int m_gauge_pos;
    private boolean m_continue_flag;
    private boolean m_first_draw_flag;
    private Graphics m_real_g;
    private boolean m_key_flag;

    public final Image GetOffScreen() {
        return this.m_img_offscreen;
    }

    public final Graphics GetRealGraphics() {
        return this.m_real_g;
    }

    public BubbleGame(BubbleSmile bubblesmile, BubbleGameMode bubblegamemode, boolean flag) {
        this.setFullScreenMode(true);
        this.m_bs = null;
        this.m_img_back = null;
        this.m_img_bubble = null;
        this.m_img_offscreen = null;
        this.m_pool = null;
        this.m_cursor = null;
        this.m_checker = null;
        this.m_sp = null;
        this.m_mode = null;
        this.m_thread = null;
        this.m_gauge_pos = 0;
        this.m_continue_flag = false;
        this.m_first_draw_flag = true;
        this.m_real_g = null;
        this.m_key_flag = false;
        this.m_bs = bubblesmile;
        this.m_mode = bubblegamemode;
        this.m_continue_flag = flag;
    }

    private void InitImages() {
        try {
            this.m_img_back = Image.createImage((String)"/back.png");
            this.m_img_bubble = Image.createImage((String)"/bubbles.png");
            this.m_img_offscreen = Image.createImage((int)132, (int)176);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void InitBubbles() {
        Bubble.InitClass();
        this.m_pool = new BubblePool();
        this.m_pool.InitBubbles();
        Random random = new Random();
        int i = random.nextInt();
        if (i < 0) {
            i = -i;
        }
        i %= 10;
        while (i > 0) {
            byte byte0 = (byte)random.nextInt();
            byte byte1 = (byte)random.nextInt();
            if (byte0 < 0) {
                byte0 = -byte0;
            }
            if (byte1 < 0) {
                byte1 = -byte1;
            }
            if (byte0 > 56) {
                byte0 = 56;
            }
            if (byte1 > 56) {
                byte1 = 56;
            }
            byte1 = (byte)(byte1 % 7);
            byte0 = (byte)(byte0 % 9);
            try {
                this.m_pool.PutBubble(byte1, byte0, null);
            }
            catch (ArrayIndexOutOfBoundsException arrayindexoutofboundsexception) {
                // empty catch block
            }
            --i;
        }
        random = null;
        System.gc();
    }

    private void InitCursor() {
        this.m_cursor = new Cursor();
    }

    private void InitThread() {
        this.m_thread = new BubbleGameThread(this);
        this.m_thread.setPriority(10);
        this.m_thread.start();
    }

    private void InitController() {
        BubbleController.InitClass();
        BubbleController.ClearControllerStack();
        BubbleController.m_mover = new BubbleControllerMove();
        BubbleControllerDownAndFill.InitClass2();
        BubbleControllerNormal bubblecontrollernormal = new BubbleControllerNormal();
        bubblecontrollernormal.Init(this);
        bubblecontrollernormal.SetActive(true);
    }

    private void InitChecker() {
        this.m_checker = new Checker();
    }

    private void InitScore() {
        this.m_sp = new ScorePool();
    }

    public Image GetOffscreen() {
        return this.m_img_offscreen;
    }

    public void paint(Graphics g) {
        if (this.m_img_offscreen == null) {
            return;
        }
        Graphics g1 = this.m_img_offscreen.getGraphics();
        if (!this.IsGaugeEnd()) {
            return;
        }
        this.m_key_flag = false;
        this.m_real_g = g;
        BubbleController bubblecontroller = BubbleController.CurrentController();
        if (bubblecontroller == null) {
            return;
        }
        bubblecontroller.Draw(g1, this);
        if (this.m_first_draw_flag) {
            this.m_first_draw_flag = false;
            BubbleControllerDownAndFill bubblecontrollerdownandfill = new BubbleControllerDownAndFill();
            BubbleControllerDownAndFill.FirstTime();
            bubblecontrollerdownandfill.Init(BubbleController.m_offscreen);
            bubblecontrollerdownandfill.SetActive(true);
            this.repaint();
        }
        if (this.m_img_offscreen == null || g == null) {
            this.m_real_g = null;
            return;
        }
        g.drawImage(this.m_img_offscreen, 0, 0, 20);
        this.m_real_g = null;
    }

    protected void showNotify() {
        System.gc();
        System.out.println("show notify");
        this.InitThread();
    }

    public void Term() {
        this.m_pool.TermBubbles();
        this.m_checker.Term();
        this.m_cursor.Term();
        this.m_sp.Term();
        Bubble.TermClass();
        BubbleControllerDownAndFill.TermClass2();
        BubbleController.TermClass();
        this.m_pool = null;
        this.m_checker = null;
        this.m_cursor = null;
        this.m_sp = null;
        this.m_img_offscreen = null;
        this.m_img_back = null;
        this.m_img_bubble = null;
        this.m_bs = null;
        this.m_mode = null;
        this.m_thread = null;
        System.gc();
    }

    public final void DrawBoard(Graphics g) {
        g.drawImage(this.m_img_back, 0, 0, 20);
    }

    public final void DrawConstraint(Graphics g) {
        this.m_mode.Draw(g);
    }

    public final void DrawCombos(Graphics g) {
        System.out.println("draw scores");
        this.m_sp.DrawScores(g);
    }

    public final void DrawCursor(Graphics g) {
        this.m_cursor.Draw(g, this);
    }

    public void DrawScore(Graphics g) {
        int i;
        int k = 0;
        for (int j = i = this.m_sp.GetCurrentScore(); j > 0; j /= 10) {
            ++k;
        }
        BubbleSmile.DrawNumber(g, 129 - k * 7, 0, i, 4);
        this.m_sp.NextCurrentScore();
    }

    public final int Pos2Pixel(byte byte0, byte byte1) {
        boolean flag;
        short word0 = (short)(16 * byte0);
        boolean bl = flag = byte1 % 2 != 0;
        if (flag) {
            word0 = (short)(word0 + 8);
        }
        short word1 = (short)(15 * byte1);
        word1 = (short)(word1 - byte1 / 2 * 5);
        if (flag) {
            word1 = (short)(word1 - 2);
        }
        word0 = (short)(word0 + 5);
        word1 = (short)(word1 + 11);
        return word0 | word1 << 16;
    }

    public void StopThread() {
        if (this.m_thread == null) {
            return;
        }
        this.m_thread.SetExitFlag(true);
        try {
            this.m_thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.m_thread = null;
    }

    public void keyPressed(int i) {
        System.out.println("keypressed " + i);
        if (i == 35 || i == -8 || i == -7) {
            try {
                this.StopThread();
                this.DeleteRS();
                this.Save();
                BubbleSmile bubblesmile = this.m_bs;
                this.Term();
                bubblesmile.SetCurrent((Displayable)new BubbleLogo(bubblesmile));
            }
            catch (NullPointerException nullpointerexception) {
                // empty catch block
            }
            return;
        }
        if (this.m_key_flag) {
            return;
        }
        this.m_key_flag = true;
        BubbleController bubblecontroller = BubbleController.CurrentController();
        if (bubblecontroller != null) {
            bubblecontroller.KeyPressed(this, i);
        } else {
            this.repaint();
        }
    }

    public final Checker GetChecker() {
        return this.m_checker;
    }

    public final BubbleGameMode GetBubbleGameMode() {
        return this.m_mode;
    }

    public final ScorePool GetScorePool() {
        return this.m_sp;
    }

    public final Cursor GetCursor() {
        return this.m_cursor;
    }

    public final Image GetBubbleImages() {
        return this.m_img_bubble;
    }

    public final BubblePool GetBubblePool() {
        return this.m_pool;
    }

    public final void StepGauge() {
        ++this.m_gauge_pos;
        this.repaint();
    }

    public final boolean IsGaugeEnd() {
        return this.m_gauge_pos >= 8;
    }

    public final void EndGauge() {
        this.m_gauge_pos = 8;
    }

    public void ChangeDisplayToHighscore() {
        BubbleSmile bubblesmile = this.m_bs;
        int i = this.m_sp.GetTotalScore();
        this.StopThread();
        this.Term();
        System.gc();
        BubbleHighScore bubblehighscore = new BubbleHighScore(bubblesmile, i);
        bubblesmile.SetCurrent((Displayable)bubblehighscore);
    }

    public static final boolean IsSaved() {
        Object obj = null;
        try {
            RecordStore recordstore = RecordStore.openRecordStore((String)STG, (boolean)false);
            int i = 1;
            byte[] abyte0 = new byte[recordstore.getRecordSize(i)];
            recordstore.getRecord(i, abyte0, 0);
            if (abyte0[0] != 1 || abyte0[1] != 1) {
                return false;
            }
            recordstore.closeRecordStore();
        }
        catch (InvalidRecordIDException invalidrecordidexception) {
            return false;
        }
        catch (RecordStoreNotOpenException recordstorenotopenexception) {
            return false;
        }
        catch (RecordStoreException recordstoreexception) {
            return false;
        }
        return true;
    }

    public boolean Load() {
        Object obj = null;
        try {
            RecordStore recordstore = RecordStore.openRecordStore((String)STG, (boolean)false);
            int i = 1;
            byte[] abyte0 = new byte[recordstore.getRecordSize(i)];
            recordstore.getRecord(i, abyte0, 0);
            if (abyte0[0] != 1 || abyte0[1] != 1) {
                return false;
            }
            i = 2;
            abyte0 = new byte[recordstore.getRecordSize(i)];
            recordstore.getRecord(i, abyte0, 0);
            this.m_pool.Load(abyte0);
            i = 3;
            abyte0 = new byte[recordstore.getRecordSize(i)];
            recordstore.getRecord(i, abyte0, 0);
            this.m_cursor.Load(abyte0);
            i = 4;
            abyte0 = new byte[recordstore.getRecordSize(i)];
            recordstore.getRecord(i, abyte0, 0);
            this.m_sp.Load(abyte0);
            i = 5;
            abyte0 = new byte[recordstore.getRecordSize(i)];
            recordstore.getRecord(i, abyte0, 0);
            this.m_mode.Load(abyte0);
            recordstore.closeRecordStore();
        }
        catch (InvalidRecordIDException invalidrecordidexception) {
            this.DeleteRS();
            return false;
        }
        catch (RecordStoreException recordstoreexception) {
            this.DeleteRS();
            return false;
        }
        return true;
    }

    public void DeleteRS() {
        try {
            RecordStore.deleteRecordStore((String)STG);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean Save() {
        Object obj = null;
        try {
            RecordStore recordstore = RecordStore.openRecordStore((String)STG, (boolean)true);
            byte[] abyte0 = new byte[]{1, 1};
            recordstore.addRecord(abyte0, 0, abyte0.length);
            abyte0 = new byte[this.m_pool.GetSaveSize()];
            this.m_pool.Save(abyte0);
            recordstore.addRecord(abyte0, 0, abyte0.length);
            abyte0 = new byte[this.m_cursor.GetSaveSize()];
            this.m_cursor.Save(abyte0);
            recordstore.addRecord(abyte0, 0, abyte0.length);
            abyte0 = new byte[this.m_sp.GetSaveSize()];
            this.m_sp.Save(abyte0);
            recordstore.addRecord(abyte0, 0, abyte0.length);
            abyte0 = new byte[this.m_mode.GetSaveSize()];
            this.m_mode.Save(abyte0);
            recordstore.addRecord(abyte0, 0, abyte0.length);
            recordstore.closeRecordStore();
        }
        catch (RecordStoreException recordstoreexception) {
            this.DeleteRS();
        }
        return true;
    }

    class BubbleGameThread
    extends Thread {
        private static final int DELAY_TIME = 50;
        private BubbleGame m_game = null;
        private boolean m_exit = false;

        public void run() {
            BubbleGame.this.StepGauge();
            BubbleGame.this.InitImages();
            BubbleGame.this.StepGauge();
            BubbleGame.this.InitBubbles();
            BubbleGame.this.StepGauge();
            BubbleGame.this.InitCursor();
            BubbleGame.this.StepGauge();
            BubbleGame.this.InitChecker();
            BubbleGame.this.StepGauge();
            BubbleGame.this.InitController();
            BubbleGame.this.StepGauge();
            BubbleGame.this.InitScore();
            if (BubbleGame.this.m_continue_flag) {
                BubbleGame.this.StepGauge();
                if (BubbleGame.this.Load()) {
                    BubbleController bubblecontroller = BubbleController.GetNormal();
                    if (bubblecontroller != null) {
                        BubbleControllerNormal bubblecontrollernormal = (BubbleControllerNormal)bubblecontroller;
                        bubblecontrollernormal.Init(this.m_game);
                        bubblecontrollernormal.AdjustBonusFlagByScore(this.m_game.GetScorePool().GetTotalScore());
                    }
                } else {
                    BubbleGame.this.m_continue_flag = false;
                }
            }
            BubbleGame.this.DeleteRS();
            BubbleGame.this.EndGauge();
            while (!this.m_exit) {
                int i;
                try {
                    BubbleController bubblecontroller1 = BubbleController.CurrentController();
                    if (bubblecontroller1 == null) {
                        Thread.yield();
                        continue;
                    }
                    if (bubblecontroller1.IsRepaint()) {
                        bubblecontroller1.Repaint(this.m_game);
                    }
                    if ((bubblecontroller1 = BubbleController.CurrentController()) == null) continue;
                    i = bubblecontroller1.DelayTimeEntry();
                }
                catch (NullPointerException nullpointerexception) {
                    i = 10;
                }
                try {
                    if (i == 0) {
                        Thread.yield();
                        continue;
                    }
                    Thread.sleep(i);
                }
                catch (InterruptedException interruptedException) {}
            }
            Object obj = null;
            this.m_game = null;
        }

        public void SetExitFlag(boolean flag) {
            this.m_exit = flag;
        }

        public BubbleGameThread(BubbleGame bubblegame1) {
            this.m_game = bubblegame1;
        }
    }
}

