/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

class BubbleGameMode {
    public static final byte MODE_TIME = 1;
    public static final byte MODE_SKILL = 2;
    private static final short BAR_WIDTH = 66;
    private static final short BAR_HEIGHT = 2;
    private static final short BAR_OFFSET_X = 8;
    private static final short BAR_OFFSET_Y = 3;
    private static final int BAR_COLOR_0 = 65280;
    private static final int BAR_COLOR_1 = 0xFFFF00;
    private static final int BAR_COLOR_2 = 0xFF0000;
    private static final short MAX_VALUE = 90;
    private static final short MID_VALUE = 40;
    private static final short RISK_VALUE = 20;
    private static final byte TIME_SPEED = 1;
    private byte m_mode = 0;
    private int m_cur = 0;
    private int m_step = 0;

    BubbleGameMode() {
    }

    public void InitMode(byte byte0) {
        this.m_mode = byte0;
        this.m_cur = this.m_mode == 1 ? 90 : 27;
    }

    public boolean IsTimedMode() {
        return this.m_mode == 1;
    }

    public boolean IsSkilledMode() {
        return this.m_mode == 2;
    }

    public boolean IsValid() {
        return this.m_cur > 0;
    }

    public void MoveTimer() {
        ++this.m_step;
        if (this.m_step < 1) {
            return;
        }
        this.m_step = 0;
        --this.m_cur;
    }

    public void IncreaseTimer() {
        this.m_step = 0;
        ++this.m_cur;
        if (this.m_cur >= 90) {
            this.m_cur = 90;
        }
    }

    public void DecreaseRotation() {
        --this.m_cur;
    }

    public void IncreaseRotation() {
        ++this.m_cur;
        if (this.m_cur >= 90) {
            this.m_cur = 90;
        }
    }

    public void WeakenConstraint(byte byte0) {
        switch (this.m_mode) {
            default: {
                break;
            }
            case 1: {
                this.IncreaseTimer();
                break;
            }
            case 2: {
                if (byte0 < 5) break;
                this.IncreaseRotation();
            }
        }
    }

    public void Draw(Graphics g) {
        int i = g.getColor();
        short word0 = (short)(66 * this.m_cur / 90);
        int j = word0 > 40 ? 65280 : (word0 > 20 ? 0xFFFF00 : 0xFF0000);
        g.setColor(j);
        g.fillRect(6, 3, (int)word0, 2);
        g.setColor(i);
    }

    public int GetSaveSize() {
        return 5;
    }

    public int Save(byte[] abyte0) {
        abyte0[0] = this.m_mode;
        abyte0[1] = (byte)(this.m_cur & 0xFF);
        abyte0[2] = (byte)(this.m_cur >> 8 & 0xFF);
        abyte0[3] = (byte)(this.m_cur >> 16 & 0xFF);
        abyte0[4] = (byte)(this.m_cur >> 24 & 0xFF);
        return 5;
    }

    public void Load(byte[] abyte0) {
        this.m_mode = abyte0[0];
        int i = 0;
        i = abyte0[1];
        i |= abyte0[2] << 8;
        i |= abyte0[3] << 16;
        this.m_cur = i |= abyte0[4] << 24;
    }
}

