/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;

public class BubblePool {
    public static final byte POOL_SIZE_X = 7;
    public static final byte POOL_SIZE_Y = 9;
    public static final byte IT_NORMAL = 0;
    public static final byte IT_LINE = 1;
    public static final byte IT_RLDIAGONAL = 2;
    public static final byte IT_LRDIAGONAL = 3;
    private Bubble[][] m_pool = new Bubble[9][7];
    private byte m_ittype;
    private byte m_c;
    private byte m_r;
    private Vector m_move_pool = new Vector();

    public final Bubble GetBubble(byte byte0, byte byte1) {
        return this.m_pool[byte1][byte0];
    }

    public final void PutBubble(byte byte0, byte byte1, Bubble bubble) {
        this.m_pool[byte1][byte0] = bubble;
    }

    public void InitBubbles() {
        for (int byte0 = 0; byte0 < 9; byte0 = (int)((byte)(byte0 + 1))) {
            for (int byte1 = 0; byte1 < 7; byte1 = (int)((byte)(byte1 + 1))) {
                if (this.m_pool[byte0][byte1] == null) {
                    this.m_pool[byte0][byte1] = new Bubble();
                }
                this.m_pool[byte0][byte1].Randomize();
            }
        }
    }

    public void TermBubbles() {
        for (int byte0 = 0; byte0 < 9; byte0 = (int)((byte)(byte0 + 1))) {
            for (int byte1 = 0; byte1 < 7; byte1 = (int)((byte)(byte1 + 1))) {
                this.m_pool[byte0][byte1] = null;
            }
        }
        this.m_move_pool.removeAllElements();
        this.m_move_pool = null;
    }

    public final void Begin(byte byte0, byte byte1, byte byte2) {
        this.m_ittype = byte0;
        switch (this.m_ittype) {
            case 0: {
                this.m_r = 0;
                this.m_c = 0;
                break;
            }
            case 1: {
                this.m_r = byte2;
                this.m_c = 0;
                break;
            }
            case 2: 
            case 3: {
                this.m_r = byte2;
                this.m_c = byte1;
            }
        }
    }

    public final void Next() {
        switch (this.m_ittype) {
            default: {
                break;
            }
            case 0: {
                this.m_c = (byte)(this.m_c + 1);
                if (this.m_c < 7) break;
                this.m_c = 0;
                this.m_r = (byte)(this.m_r + 1);
                break;
            }
            case 1: {
                this.m_c = (byte)(this.m_c + 1);
                break;
            }
            case 3: {
                if (this.m_r % 2 != 0) {
                    this.m_c = (byte)(this.m_c + 1);
                }
                this.m_r = (byte)(this.m_r + 1);
                break;
            }
            case 2: {
                if (this.m_r % 2 == 0) {
                    this.m_c = (byte)(this.m_c - 1);
                }
                this.m_r = (byte)(this.m_r + 1);
            }
        }
    }

    public final boolean IsDone() {
        switch (this.m_ittype) {
            case 0: {
                return this.m_r >= 9;
            }
            case 1: {
                return this.m_c >= 7;
            }
            case 2: 
            case 3: {
                return this.m_r >= 9 || this.m_c >= 7 || this.m_c < 0;
            }
        }
        return true;
    }

    public final Bubble CurrentItem() {
        return this.m_pool[this.m_r][this.m_c];
    }

    public final byte CurrentItemCol() {
        return this.m_c;
    }

    public final byte CurrentItemRow() {
        return this.m_r;
    }

    public void MoveBubble() {
        Object obj = null;
        this.m_move_pool.removeAllElements();
        for (int byte0 = 0; byte0 < 7; byte0 = (int)((byte)(byte0 + 1))) {
            for (int byte1 = 0; byte1 < 9; byte1 = (int)((byte)(byte1 + 1))) {
                Bubble bubble = this.m_pool[byte1][byte0];
                if (bubble == null || !bubble.IsMoving()) continue;
                this.m_move_pool.addElement(bubble);
                this.m_pool[byte1][byte0] = null;
            }
        }
        int i = this.m_move_pool.size();
        for (int j = 0; j < i; ++j) {
            Bubble bubble1;
            this.m_pool[bubble1.m_dr][bubble1.m_dc] = bubble1 = (Bubble)this.m_move_pool.elementAt(j);
            bubble1.m_status = 0;
        }
    }

    public final boolean DeleteBubbles() {
        boolean flag = false;
        for (int byte0 = 0; byte0 < 9; byte0 = (int)((byte)(byte0 + 1))) {
            for (int byte1 = 0; byte1 < 7; byte1 = (int)((byte)(byte1 + 1))) {
                if (!this.m_pool[byte0][byte1].IsDelete()) continue;
                this.m_pool[byte0][byte1] = null;
                flag = true;
            }
        }
        return flag;
    }

    public final boolean DownBubbles(Vector vector) {
        boolean flag = false;
        boolean flag2 = false;
        boolean flag4 = false;
        for (byte byte1 = 0; byte1 < 7; byte1 = (byte)((byte)(byte1 + 1))) {
            boolean flag1 = false;
            boolean flag3 = true;
            for (int byte0 = 8; byte0 > 0; byte0 = (int)((byte)(byte0 - 1))) {
                Bubble bubble;
                byte byte2;
                if (null != this.m_pool[byte0][byte1]) continue;
                for (byte2 = (byte)(byte0 - 1); byte2 >= 0 && this.m_pool[byte2][byte1] == null; byte2 = (byte)(byte2 - 1)) {
                }
                if (byte2 < 0 || (bubble = this.m_pool[byte2][byte1]) == null) continue;
                if (flag3) {
                    vector.addElement(bubble);
                    flag3 = false;
                }
                flag1 = true;
                bubble.PutStatus((byte)3);
                bubble.PutSrcPos(byte1, byte2);
                bubble.PutDstPos(byte1, (byte)(byte2 + 1));
                if (byte2 % 2 == 0) {
                    bubble.PutDirection((byte)2);
                } else {
                    bubble.PutDirection((byte)-1);
                }
                byte0 = (byte)(byte2 + 1);
            }
            flag2 |= flag1;
        }
        return flag2;
    }

    public boolean IsFull() {
        for (int byte0 = 0; byte0 < 9; byte0 = (int)((byte)(byte0 + 1))) {
            for (int byte1 = 0; byte1 < 7; byte1 = (int)((byte)(byte1 + 1))) {
                if (this.m_pool[byte0][byte1] != null) continue;
                return false;
            }
        }
        return true;
    }

    public boolean FillFirstLine(Vector vector) {
        Object obj = null;
        boolean flag = false;
        for (byte byte0 = 0; byte0 < 7; byte0 = (byte)((byte)(byte0 + 1))) {
            if (this.m_pool[0][byte0] != null) continue;
            Bubble bubble = new Bubble();
            bubble.Randomize();
            this.m_pool[0][byte0] = bubble;
            bubble.PutSrcPos(byte0, (byte)0);
            vector.addElement(bubble);
            flag = true;
        }
        return flag;
    }

    public int GetSaveSize() {
        return 63;
    }

    public int Save(byte[] abyte0) {
        Object obj = null;
        int i = 0;
        byte[] abyte1 = new byte[10];
        for (int byte1 = 0; byte1 < 9; byte1 = (int)((byte)(byte1 + 1))) {
            for (int byte0 = 0; byte0 < 7; byte0 = (int)((byte)(byte0 + 1))) {
                Bubble bubble = this.m_pool[byte1][byte0];
                if (null == bubble) {
                    abyte1[0] = -1;
                } else {
                    bubble.Save(abyte1);
                }
                abyte0[i++] = abyte1[0];
            }
        }
        return i;
    }

    public void Load(byte[] abyte0) {
        Object obj = null;
        int i = 0;
        byte[] abyte1 = new byte[10];
        for (int byte1 = 0; byte1 < 9; byte1 = (int)((byte)(byte1 + 1))) {
            for (int byte0 = 0; byte0 < 7; byte0 = (int)((byte)(byte0 + 1))) {
                abyte1[0] = abyte0[i++];
                if (abyte1[0] < 0 || abyte1[0] > 6) {
                    this.m_pool[byte1][byte0] = null;
                    continue;
                }
                Bubble bubble = this.m_pool[byte1][byte0];
                if (bubble == null) {
                    this.m_pool[byte1][byte0] = bubble = new Bubble();
                }
                bubble.Load(abyte1);
            }
        }
    }
}

