/*
 * Decompiled with CFR 0.152.
 */
public class Checker {
    private static final int MAX_POOL_SIZE = 5;
    private static final int MINIMUM_BLOCK_COUNT = 3;
    private short[] m_pospool;
    private byte m_index = (byte)-1;
    private byte m_num = (byte)-1;
    private byte m_checked_total_bubbles = 0;
    private byte m_min_c;
    private byte m_max_c;
    private byte m_min_r;
    private byte m_max_r;
    private boolean m_bonus_mode = false;

    public Checker() {
        this.m_pospool = new short[9];
        this.m_index = (byte)-1;
    }

    public final void Clear() {
        this.m_index = (byte)-1;
        this.m_num = (byte)-1;
    }

    public final void Term() {
        this.m_pospool = null;
    }

    public final void ClearScoreRelatedVariables() {
        this.m_checked_total_bubbles = 0;
        this.m_min_c = (byte)100;
        this.m_max_c = (byte)-1;
        this.m_min_r = (byte)100;
        this.m_max_r = (byte)-1;
    }

    public final void Add(byte byte0, byte byte1) {
        short word0;
        this.m_index = (byte)(this.m_index + 1);
        this.m_pospool[this.m_index] = word0 = (short)((long)byte0 | (long)byte1 << 8);
    }

    public final short GetCount() {
        return (short)(this.m_index + 1);
    }

    public final boolean CheckSame(BubblePool bubblepool, BubbleGame bubblegame) {
        boolean flag = false;
        this.Clear();
        this.ClearScoreRelatedVariables();
        flag = this.CheckSameByLine(bubblepool, bubblegame);
        flag |= this.CheckSameByLRDiagonal(bubblepool, bubblegame);
        if (flag |= this.CheckSameByRLDiagonal(bubblepool, bubblegame)) {
            int i = bubblegame.Pos2Pixel((byte)((this.m_max_c + this.m_min_c) / 2), (byte)((this.m_max_r + this.m_min_r) / 2));
            ScorePool scorepool = bubblegame.GetScorePool();
            scorepool.AddScore(this.m_checked_total_bubbles, (short)(i & 0xFFFF), (short)(i >> 16 & 0xFFFF));
            if (this.m_checked_total_bubbles >= 3) {
                BubbleGameMode bubblegamemode = bubblegame.GetBubbleGameMode();
                bubblegamemode.WeakenConstraint(this.m_checked_total_bubbles);
            }
        }
        this.m_bonus_mode = false;
        return flag;
    }

    private final boolean CheckSameByLine(BubblePool bubblepool, BubbleGame bubblegame) {
        boolean flag = false;
        for (byte byte0 = 0; byte0 < 9; byte0 = (byte)(byte0 + 1)) {
            flag |= this.CheckSameByIterator(bubblepool, bubblegame, (byte)1, (byte)0, byte0);
        }
        return flag;
    }

    private final boolean CheckSameByLRDiagonal(BubblePool bubblepool, BubbleGame bubblegame) {
        boolean flag = false;
        for (byte byte0 = 0; byte0 < 7; byte0 = (byte)(byte0 + 1)) {
            flag |= this.CheckSameByIterator(bubblepool, bubblegame, (byte)3, byte0, (byte)0);
        }
        for (byte byte1 = 2; byte1 < 9; byte1 = (byte)(byte1 + 2)) {
            flag |= this.CheckSameByIterator(bubblepool, bubblegame, (byte)3, (byte)0, byte1);
        }
        return flag;
    }

    private final boolean CheckSameByRLDiagonal(BubblePool bubblepool, BubbleGame bubblegame) {
        boolean flag = false;
        for (byte byte0 = 0; byte0 < 7; byte0 = (byte)(byte0 + 1)) {
            flag |= this.CheckSameByIterator(bubblepool, bubblegame, (byte)2, byte0, (byte)0);
        }
        byte byte1 = 6;
        for (byte byte2 = 1; byte2 < 9; byte2 = (byte)(byte2 + 2)) {
            flag |= this.CheckSameByIterator(bubblepool, bubblegame, (byte)2, byte1, byte2);
        }
        return flag;
    }

    private final boolean CheckSameByIterator(BubblePool bubblepool, BubbleGame bubblegame, byte byte0, byte byte1, byte byte2) {
        boolean flag = false;
        boolean flag1 = false;
        int byte3 = -1;
        bubblepool.Begin(byte0, byte1, byte2);
        while (!bubblepool.IsDone()) {
            Bubble bubble = bubblepool.CurrentItem();
            if (bubble == null) {
                if (this.GetCount() >= 3) {
                    this.ApplyCheckedStatus(bubblepool, bubblegame);
                    flag1 = true;
                }
                this.Clear();
            } else {
                byte byte4 = bubble.GetNumber();
                if (this.m_bonus_mode) {
                    byte4 = (byte)(byte4 / 2);
                }
                if (byte4 != this.m_num) {
                    if (this.GetCount() >= 3) {
                        this.ApplyCheckedStatus(bubblepool, bubblegame);
                        flag1 = true;
                    } else {
                        this.Clear();
                    }
                    this.m_num = byte4;
                }
                this.Add(bubblepool.CurrentItemCol(), bubblepool.CurrentItemRow());
            }
            bubblepool.Next();
        }
        if (this.GetCount() >= 3) {
            this.ApplyCheckedStatus(bubblepool, bubblegame);
            flag1 = true;
        }
        this.Clear();
        return flag1;
    }

    private final void ApplyCheckedStatus(BubblePool bubblepool, BubbleGame bubblegame) {
        boolean flag = false;
        boolean flag1 = false;
        this.m_checked_total_bubbles = (byte)(this.m_checked_total_bubbles + (this.m_index + 1));
        while (this.m_index >= 0) {
            short word0 = this.m_pospool[this.m_index];
            byte byte0 = (byte)(word0 & 0xFF);
            byte byte1 = (byte)(word0 >> 8 & 0xFF);
            if (byte0 > this.m_max_c) {
                this.m_max_c = byte0;
            }
            if (byte0 < this.m_min_c) {
                this.m_min_c = byte0;
            }
            if (byte1 > this.m_max_r) {
                this.m_max_r = byte1;
            }
            if (byte1 < this.m_min_r) {
                this.m_min_r = byte1;
            }
            Bubble bubble = bubblepool.GetBubble(byte0, byte1);
            bubble.PutStatus((byte)10);
            this.m_index = (byte)(this.m_index - 1);
        }
    }

    public final void SetBonusMode() {
        System.out.println("bonus mode ");
        this.m_bonus_mode = true;
    }
}

