/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Cursor {
    public static final int POSITION_CNT = 3;
    public static final byte CURSOR_LEFT = 0;
    public static final byte CURSOR_RIGHT = 1;
    public static final byte CURSOR_TOP = 2;
    public static final byte CURSOR_BOTTOM = 3;
    public static final byte CURSOR_IMG_WIDTH = 31;
    public static final byte CURSOR_IMG_HEIGHT = 28;
    private static final int ANGLE_VALUE = 360;
    private boolean m_direction = true;
    private byte m_c;
    private byte m_r;
    private byte[] m_carr;
    private byte[] m_rarr;
    private short[] m_xarr;
    private short[] m_yarr;
    private int[] m_colors = new int[]{2816800, 2667809, 0x266D22};
    private int m_color_index = 0;
    private Image m_img = null;
    private boolean m_status = false;

    public Cursor() {
        this.m_c = (byte)3;
        this.m_r = (byte)4;
        this.m_carr = new byte[3];
        this.m_rarr = new byte[3];
        this.m_xarr = new short[3];
        this.m_yarr = new short[3];
        try {
            this.m_img = Image.createImage((String)"/cursor.png");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void Term() {
        this.m_carr = null;
        this.m_rarr = null;
        this.m_xarr = null;
        this.m_yarr = null;
        this.m_img = null;
    }

    public short GetLeft() {
        if (this.m_direction) {
            return (short)(this.m_xarr[2] - 20);
        }
        return (short)(this.m_xarr[0] - 20);
    }

    public short GetRight() {
        return (short)(this.m_xarr[1] + 15 + 20);
    }

    public short GetTop() {
        return this.m_yarr[0];
    }

    public short GetBottom() {
        return (short)(this.m_yarr[1] + 15 + 20);
    }

    public boolean IsIn(byte byte0, byte byte1) {
        return !(byte0 != this.m_carr[0] && byte0 != this.m_carr[1] && byte0 != this.m_carr[2] || byte1 != this.m_rarr[0] && byte1 != this.m_rarr[1] && byte1 != this.m_rarr[2]);
    }

    public short GetAt(int i) {
        short word0 = this.m_carr[i];
        word0 = (short)(word0 | this.m_rarr[i] << 8);
        return word0;
    }

    public boolean Move(byte byte0) {
        byte byte1 = this.m_c;
        byte byte2 = this.m_r;
        if (this.m_direction) {
            if (byte0 == 2 && this.m_r == 0) {
                return false;
            }
            if (byte0 == 0 && this.m_c == 0) {
                return false;
            }
            if (byte0 == 1 && this.m_c == 6) {
                return false;
            }
            if (byte0 == 3 && this.m_r == 7) {
                return false;
            }
            switch (byte0) {
                case 0: {
                    if (this.m_r % 2 == 0) {
                        this.m_c = (byte)(this.m_c - 1);
                    }
                    this.m_r = (byte)(this.m_r + 1);
                    break;
                }
                case 1: {
                    if (this.m_r % 2 != 0) {
                        this.m_c = (byte)(this.m_c + 1);
                    }
                    this.m_r = (byte)(this.m_r + 1);
                    break;
                }
                case 3: {
                    this.m_r = (byte)(this.m_r + 2);
                }
            }
        } else {
            if (byte0 == 2 && this.m_r == 1) {
                return false;
            }
            if (byte0 == 0 && this.m_c == 0) {
                return false;
            }
            if (byte0 == 1 && this.m_c == 6) {
                return false;
            }
            if (byte0 == 3 && this.m_r == 8) {
                return false;
            }
            switch (byte0) {
                default: {
                    break;
                }
                case 0: {
                    if (this.m_r % 2 == 0) {
                        this.m_c = (byte)(this.m_c - 1);
                    }
                    this.m_r = (byte)(this.m_r - 1);
                    break;
                }
                case 1: {
                    if (this.m_r % 2 != 0) {
                        this.m_c = (byte)(this.m_c + 1);
                    }
                    this.m_r = (byte)(this.m_r - 1);
                    break;
                }
                case 2: {
                    this.m_r = (byte)(this.m_r - 2);
                }
            }
        }
        if (this.m_r < 0 || this.m_r >= 9 || this.m_c < 0 || this.m_c >= 7) {
            this.m_r = byte2;
            this.m_c = byte1;
            return false;
        }
        this.m_direction = !this.m_direction;
        return true;
    }

    public void Draw(Graphics g, BubbleGame bubblegame) {
        this.m_status = !this.m_status;
        this.CalcBubblePosition();
        this.CalcBubblePixelPoint(bubblegame);
        if (this.m_direction) {
            this.DrawUpperCursor(g);
        } else {
            this.DrawBottomCursor(g);
        }
    }

    private void DrawUpperCursor(Graphics g) {
        int byte0 = !this.m_status ? 31 : 0;
        g.setClip((int)this.m_xarr[2], (int)this.m_yarr[0], 31, 28);
        g.drawImage(this.m_img, this.m_xarr[2] - byte0, this.m_yarr[0] - 28, 20);
        g.setClip(0, 0, 132, 176);
    }

    private void DrawBottomCursor(Graphics g) {
        int byte0 = !this.m_status ? 31 : 0;
        g.setClip((int)this.m_xarr[0], (int)this.m_yarr[0], 31, 28);
        g.drawImage(this.m_img, this.m_xarr[0] - byte0, (int)this.m_yarr[0], 20);
        g.setClip(0, 0, 132, 176);
    }

    public void CalcBubblePosition() {
        if (this.m_direction) {
            this.m_carr[0] = this.m_c;
            this.m_rarr[0] = this.m_r;
            if (this.m_r % 2 == 0) {
                this.m_carr[1] = this.m_c;
                this.m_rarr[1] = (byte)(this.m_r + 1);
                this.m_carr[2] = (byte)(this.m_c - 1);
                this.m_rarr[2] = this.m_rarr[1];
            } else {
                this.m_carr[1] = (byte)(this.m_c + 1);
                this.m_rarr[1] = (byte)(this.m_r + 1);
                this.m_carr[2] = this.m_c;
                this.m_rarr[2] = this.m_rarr[1];
            }
        } else {
            if (this.m_r % 2 == 0) {
                this.m_carr[0] = (byte)(this.m_c - 1);
                this.m_rarr[0] = (byte)(this.m_r - 1);
                this.m_carr[1] = this.m_c;
                this.m_rarr[1] = this.m_rarr[0];
            } else {
                this.m_carr[0] = this.m_c;
                this.m_rarr[0] = (byte)(this.m_r - 1);
                this.m_carr[1] = (byte)(this.m_c + 1);
                this.m_rarr[1] = this.m_rarr[0];
            }
            this.m_carr[2] = this.m_c;
            this.m_rarr[2] = this.m_r;
        }
    }

    public void CalcBubblePixelPoint(BubbleGame bubblegame) {
        for (int j = 0; j < 3; ++j) {
            int i = bubblegame.Pos2Pixel(this.m_carr[j], this.m_rarr[j]);
            this.m_xarr[j] = (short)((i & 0xFFFF) - 1);
            this.m_yarr[j] = (short)(i >> 16 & 0xFFFF);
            if (!this.m_direction) continue;
            int n = j;
            this.m_yarr[n] = (short)(this.m_yarr[n] - 1);
        }
    }

    private void NextColorIndex() {
        this.m_color_index = (this.m_color_index + 1) % 3;
    }

    public void Rotation(BubbleGame bubblegame, boolean flag) {
        this.CalcBubblePosition();
        BubblePool bubblepool = bubblegame.GetBubblePool();
        byte[] abyte0 = new byte[]{2, 3, 1, -1, -2, -3};
        byte[] abyte1 = new byte[]{-3, -1, -2, 2, 3, 1};
        for (int j = 0; j < 3; ++j) {
            int i = !flag && j == 0 ? 2 : (flag ? (j + 1) % 3 : (j - 1) % 3);
            byte byte0 = this.m_carr[j];
            byte byte1 = this.m_rarr[j];
            Bubble bubble = bubblepool.GetBubble(byte0, byte1);
            bubble.PutSrcPos(byte0, byte1);
            bubble.PutDstPos(this.m_carr[i], this.m_rarr[i]);
            if (this.m_direction) {
                if (flag) {
                    bubble.PutDirection(abyte0[j]);
                } else {
                    bubble.PutDirection(abyte0[j + 3]);
                }
            } else if (flag) {
                bubble.PutDirection(abyte1[j]);
            } else {
                bubble.PutDirection(abyte1[j + 3]);
            }
            bubble.PutStatus((byte)3);
        }
    }

    public int GetSaveSize() {
        return 3;
    }

    public int Save(byte[] abyte0) {
        abyte0[0] = this.m_direction ? (byte)1 : 0;
        abyte0[1] = this.m_c;
        abyte0[2] = this.m_r;
        return 3;
    }

    public void Load(byte[] abyte0) {
        this.m_direction = abyte0[0] == 1;
        this.m_c = abyte0[1];
        this.m_r = abyte0[2];
    }

    public void InvalidateCursorArea(BubbleGame bubblegame) {
        short word0 = this.GetLeft();
        short word1 = this.GetRight();
        short word2 = this.GetTop();
        short word3 = this.GetBottom();
        bubblegame.repaint(word0, word2, word1 - word0, word3 - word2);
    }

    public byte DebugGetX() {
        return this.m_c;
    }

    public byte DebugGetY() {
        return this.m_r;
    }
}

