/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public class ScorePool {
    private Vector m_pool = new Vector();
    private int m_tot_score = 0;
    private int m_cur_score = 0;
    private byte m_combo_cnt = 0;

    public int GetTotalScore() {
        return this.m_tot_score;
    }

    public int GetCurrentScore() {
        return this.m_cur_score;
    }

    public void NextCurrentScore() {
        if (this.m_cur_score >= this.m_tot_score) {
            return;
        }
        this.m_cur_score += 7;
        if (this.m_cur_score > this.m_tot_score) {
            this.m_cur_score = this.m_tot_score;
        }
    }

    public void Term() {
        this.m_pool.removeAllElements();
        this.m_pool = null;
    }

    public void Clear() {
        this.m_combo_cnt = 0;
    }

    public void IncreaseComboCnt() {
        this.m_combo_cnt = (byte)(this.m_combo_cnt + 1);
    }

    public void AddScore(byte byte0, short word0, short word1) {
        Score score = new Score();
        score.CalcScore(byte0, this.m_combo_cnt);
        score.PutPos(word0, word1);
        this.m_pool.addElement(score);
        this.m_tot_score += score.GetScore();
    }

    void VerifyPool() {
        for (int i = this.m_pool.size() - 1; i >= 0; --i) {
            Score score = (Score)this.m_pool.elementAt(i);
            if (!score.IsEnd()) continue;
            this.m_pool.removeElementAt(i);
        }
    }

    public void DrawScores(Graphics g) {
        if (this.m_pool.isEmpty()) {
            return;
        }
        this.VerifyPool();
        int i = this.m_pool.size();
        for (int j = 0; j < i; ++j) {
            Score score = (Score)this.m_pool.elementAt(j);
            if (score.IsLocked()) continue;
            score.Draw(g);
            score.MoveNext();
        }
    }

    public void UnlockScores() {
        int i = this.m_pool.size();
        for (int j = 0; j < i; ++j) {
            Score score = (Score)this.m_pool.elementAt(j);
            if (!score.IsLocked()) continue;
            score.Unlock();
        }
    }

    public int GetSaveSize() {
        return 4;
    }

    public int Save(byte[] abyte0) {
        abyte0[0] = (byte)(this.m_tot_score & 0xFF);
        abyte0[1] = (byte)(this.m_tot_score >> 8 & 0xFF);
        abyte0[2] = (byte)(this.m_tot_score >> 16 & 0xFF);
        abyte0[3] = (byte)(this.m_tot_score >> 24 & 0xFF);
        return 4;
    }

    public void Load(byte[] abyte0) {
        this.m_tot_score = abyte0[0] & 0xFF;
        this.m_tot_score |= abyte0[1] << 8 & 0xFF00;
        this.m_tot_score |= abyte0[2] << 16 & 0xFF0000;
        this.m_tot_score |= abyte0[3] << 24 & 0xFF000000;
        this.m_cur_score = this.m_tot_score;
    }
}

