/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import javax.microedition.lcdui.Graphics;

public class Scene {
    static final int PARAMS_BASE = 32000;
    static final short IMAGE = 0;
    static final short RECT = 1;
    static final short FILLRECT = 2;
    static final short LINE = 3;
    static final short SETCLIP = 4;
    static final short BEGIN_SOLID_IMAGE = 5;
    static final short END_SOLID_IMAGE = 6;
    static final short SPRITE = 7;
    static final short SOLID_IMAGE = 16;
    private static int l_nImgX;
    private static int l_nImgY;
    private static int l_nImgW;
    private static int l_nImgH;
    private static boolean l_bTransparent;
    private static javax.microedition.lcdui.Image l_imgSolidImage;
    private static Graphics l_graph;
    protected javax.microedition.lcdui.Image[] l_solidImages;
    static int m_nCatchY;
    public int m_nX = 0;
    public int m_nY = 0;
    protected boolean l_bUsedSetClip;
    protected int l_nClipX;
    protected int l_nClipY;
    protected int l_nClipWidth;
    protected int l_nClipHeight;
    public int m_nLeft = 0;
    public int m_nTop = 0;
    public int m_nRight = 132;
    public int m_nBottom = 176;
    public int m_nExitX;
    public int m_nExitY;
    public int m_nExitWidth = 0;
    public int m_nExitHeight;
    protected short m_shLength;
    protected short[] m_data;
    public short m_shParamCount;
    public short[] m_params;
    public short m_shImageCount;
    public Image[] m_images;
    public short m_shFloorCount;
    public short[] m_floor;
    public static short m_shFoundFloorId;
    public short m_shCatchCount;
    public short[] m_catch;
    public static short m_shFoundCatchId;
    public short m_shSpriteCount;
    public Image[] m_sprites;
    public javax.microedition.lcdui.Image[] m_solidImages;
    public short m_shSolidImageCount;
    static final int FRAME_OFFSET = 0;
    static final int FRAME_INDEX = 0;
    protected static short l_shX;
    protected static short l_shY;
    protected static short l_shW;
    protected static short l_shH;
    protected static short l_shPtr;
    protected static short l_shCounter;
    protected static short l_shInd;
    protected static short l_shFrame;

    void load(DataInputStream dis) throws Throwable {
        l_imgSolidImage = null;
        this.m_shSolidImageCount = 0;
        this.m_solidImages = null;
        System.gc();
        Thread.currentThread();
        Thread.sleep(20L);
        this.m_shImageCount = dis.readShort();
        this.m_images = new Image[this.m_shImageCount];
        l_shPtr = 0;
        while (l_shPtr < this.m_shImageCount) {
            short s = l_shPtr;
            l_shPtr = (short)(s + 1);
            this.m_images[s] = Image.get(dis.readShort());
        }
        this.m_shSpriteCount = dis.readShort();
        this.m_sprites = new Image[this.m_shSpriteCount];
        l_shPtr = 0;
        while (l_shPtr < this.m_shSpriteCount) {
            short s = l_shPtr;
            l_shPtr = (short)(s + 1);
            this.m_sprites[s] = Image.get(dis.readShort());
        }
        this.m_shParamCount = dis.readShort();
        this.m_params = new short[this.m_shParamCount];
        l_shPtr = 0;
        while (l_shPtr < this.m_shParamCount) {
            short s = l_shPtr;
            l_shPtr = (short)(s + 1);
            this.m_params[s] = dis.readShort();
        }
        this.m_shLength = dis.readShort();
        this.m_data = new short[this.m_shLength];
        l_shPtr = 0;
        l_shCounter = 0;
        while (l_shCounter < this.m_shLength) {
            short cmd = dis.readShort();
            if (l_imgSolidImage != null) {
                switch (cmd) {
                    case 0: {
                        l_shCounter = (short)(l_shCounter + 5);
                        l_shInd = dis.readShort();
                        l_shX = dis.readShort();
                        l_shY = dis.readShort();
                        if (dis.readShort() == 0) break;
                        this.m_images[l_shInd].paint(l_graph, 0, l_shX + 0, l_shY);
                        break;
                    }
                    case 7: {
                        l_shCounter = (short)(l_shCounter + 6);
                        l_shInd = dis.readShort();
                        l_shX = dis.readShort();
                        l_shY = dis.readShort();
                        l_shFrame = dis.readShort();
                        if (dis.readShort() == 0) break;
                        this.m_sprites[l_shInd].paint(l_graph, l_shFrame, l_shX, l_shY);
                        break;
                    }
                    case 2: {
                        l_shCounter = (short)(l_shCounter + 8);
                        this.setColor(l_graph, dis);
                        l_shX = dis.readShort();
                        l_shY = dis.readShort();
                        l_shW = dis.readShort();
                        l_shH = dis.readShort();
                        if (dis.readShort() == 0) break;
                        l_graph.fillRect((int)l_shX, (int)l_shY, (int)l_shW, (int)l_shH);
                        break;
                    }
                    case 1: {
                        l_shCounter = (short)(l_shCounter + 8);
                        this.setColor(l_graph, dis);
                        l_shX = dis.readShort();
                        l_shY = dis.readShort();
                        l_shW = dis.readShort();
                        l_shH = dis.readShort();
                        if (dis.readShort() == 0) break;
                        l_graph.drawRect((int)l_shX, (int)l_shY, (int)l_shW, (int)l_shH);
                        break;
                    }
                    case 3: {
                        this.setColor(l_graph, dis);
                        short nX = dis.readShort();
                        short nY = dis.readShort();
                        l_graph.drawLine((int)nX, (int)nY, nX + dis.readShort(), nY + dis.readShort());
                        break;
                    }
                    case 4: {
                        l_shCounter = (short)(l_shCounter + 6);
                        l_shX = dis.readShort();
                        l_shY = dis.readShort();
                        l_shW = dis.readShort();
                        l_shH = dis.readShort();
                        if (dis.readShort() == 0) break;
                        if (!this.l_bUsedSetClip) {
                            this.l_nClipX = l_graph.getClipX();
                            this.l_nClipY = l_graph.getClipY();
                            this.l_nClipWidth = l_graph.getClipWidth();
                            this.l_nClipHeight = l_graph.getClipHeight();
                            this.l_bUsedSetClip = true;
                        }
                        l_graph.setClip((int)l_shX, (int)l_shY, (int)l_shW, (int)l_shH);
                        break;
                    }
                    case 5: {
                        l_shCounter = (short)(l_shCounter + 6);
                        dis.skip(10L);
                        break;
                    }
                    case 6: {
                        l_shCounter = (short)(l_shCounter + 1);
                        short s = l_shPtr;
                        l_shPtr = (short)(s + 1);
                        this.m_data[s] = this.addSolidImage(l_imgSolidImage);
                        l_imgSolidImage = null;
                    }
                }
                continue;
            }
            short s = l_shPtr;
            l_shPtr = (short)(s + 1);
            this.m_data[s] = cmd;
            switch (cmd) {
                case 1: 
                case 2: 
                case 3: {
                    l_shCounter = (short)(l_shCounter + 2);
                    short s2 = l_shPtr;
                    l_shPtr = (short)(s2 + 1);
                    this.m_data[s2] = dis.readShort();
                    short s3 = l_shPtr;
                    l_shPtr = (short)(s3 + 1);
                    this.m_data[s3] = dis.readShort();
                }
                case 7: {
                    l_shCounter = (short)(l_shCounter + 1);
                    short s4 = l_shPtr;
                    l_shPtr = (short)(s4 + 1);
                    short s5 = dis.readShort();
                    this.m_data[s4] = s5;
                    l_shInd = s5;
                }
                case 0: {
                    l_shCounter = (short)(l_shCounter + 5);
                    short s6 = l_shPtr;
                    l_shPtr = (short)(s6 + 1);
                    short s7 = dis.readShort();
                    this.m_data[s6] = s7;
                    l_shInd = s7;
                    short s8 = l_shPtr;
                    l_shPtr = (short)(s8 + 1);
                    this.m_data[s8] = dis.readShort();
                    short s9 = l_shPtr;
                    l_shPtr = (short)(s9 + 1);
                    this.m_data[s9] = dis.readShort();
                    short s10 = l_shPtr;
                    l_shPtr = (short)(s10 + 1);
                    this.m_data[s10] = dis.readShort();
                    break;
                }
                case 4: {
                    l_shCounter = (short)(l_shCounter + 6);
                    short s11 = l_shPtr;
                    l_shPtr = (short)(s11 + 1);
                    this.m_data[s11] = dis.readShort();
                    short s12 = l_shPtr;
                    l_shPtr = (short)(s12 + 1);
                    short s13 = dis.readShort();
                    this.m_data[s12] = s13;
                    l_shY = s13;
                    short s14 = l_shPtr;
                    l_shPtr = (short)(s14 + 1);
                    this.m_data[s14] = dis.readShort();
                    short s15 = l_shPtr;
                    l_shPtr = (short)(s15 + 1);
                    short s16 = dis.readShort();
                    this.m_data[s15] = s16;
                    l_shH = s16;
                    short s17 = l_shPtr;
                    l_shPtr = (short)(s17 + 1);
                    this.m_data[s17] = dis.readShort();
                    GameProcess.m_nFenceY = l_shY + l_shH;
                    break;
                }
                case 5: {
                    l_shCounter = (short)(l_shCounter + 5);
                    l_shPtr = (short)(l_shPtr - 1);
                    l_bTransparent = dis.readShort() != 0;
                    l_nImgX = dis.readShort();
                    l_nImgY = dis.readShort();
                    l_nImgW = dis.readShort();
                    l_nImgH = dis.readShort();
                    l_imgSolidImage = Image.createEmptyImage(l_nImgW, l_nImgH, l_bTransparent);
                    l_graph = l_imgSolidImage.getGraphics();
                    l_graph.translate(-l_nImgX, -l_nImgY);
                    short s18 = l_shPtr;
                    l_shPtr = (short)(s18 + 1);
                    this.m_data[s18] = 16;
                    short s19 = l_shPtr;
                    l_shPtr = (short)(s19 + 1);
                    this.m_data[s19] = (short)l_nImgX;
                    short s20 = l_shPtr;
                    l_shPtr = (short)(s20 + 1);
                    this.m_data[s20] = (short)l_nImgY;
                    short s21 = l_shPtr;
                    l_shPtr = (short)(s21 + 1);
                    this.m_data[s21] = 0;
                    break;
                }
                case 6: {
                    l_shCounter = (short)(l_shCounter + 1);
                }
            }
        }
        this.m_shLength = l_shPtr;
        this.m_nLeft = dis.readShort();
        this.m_nTop = dis.readShort();
        this.m_nRight = 132 - dis.readShort();
        this.m_nBottom = 176 - dis.readShort();
        this.m_shFloorCount = dis.readShort();
        this.m_floor = new short[this.m_shFloorCount * 5];
        l_shPtr = 0;
        while (l_shPtr < this.m_floor.length) {
            short s = l_shPtr;
            l_shPtr = (short)(s + 1);
            this.m_floor[s] = dis.readShort();
        }
        this.m_shCatchCount = dis.readShort();
        this.m_catch = new short[this.m_shCatchCount * 5];
        l_shPtr = 0;
        l_shCounter = 0;
        while (l_shPtr < this.m_catch.length) {
            short s = l_shPtr;
            l_shPtr = (short)(s + 1);
            this.m_catch[s] = dis.readShort();
            short s22 = l_shCounter;
            l_shCounter = (short)(s22 + 1);
            if (s22 != 4) continue;
            if (this.m_catch[l_shPtr - 1] == 100) {
                this.m_nExitX = this.m_catch[l_shPtr - 5];
                this.m_nExitY = this.m_catch[l_shPtr - 4];
                this.m_nExitWidth = this.m_catch[l_shPtr - 3];
                this.m_nExitHeight = this.m_catch[l_shPtr - 2];
            }
            l_shCounter = 0;
        }
        System.gc();
        Thread.currentThread();
        Thread.sleep(20L);
    }

    protected short nextShort() {
        short s = l_shPtr;
        l_shPtr = (short)(s + 1);
        short shRes = this.m_data[s];
        if (shRes >= 32000) {
            return this.m_params[shRes - 32000];
        }
        return shRes;
    }

    protected int getNum(int num) {
        if (num >= 32000) {
            return this.m_params[num - 32000];
        }
        return num;
    }

    protected void setColor(Graphics g) {
        short s = l_shPtr;
        short s2 = l_shPtr = (short)(s + 1);
        l_shPtr = (short)(s2 + 1);
        g.setColor(this.m_data[s] << 16 | this.m_data[s2] & 0xFFFF);
    }

    protected void setColor(Graphics g, DataInputStream dis) throws Exception {
        g.setColor(dis.readShort() << 16 | dis.readShort() & 0xFFFF);
    }

    protected short addSolidImage(javax.microedition.lcdui.Image image) {
        if (this.m_solidImages == null || this.m_shSolidImageCount == this.m_solidImages.length) {
            if (this.m_shSolidImageCount > 0) {
                this.l_solidImages = this.m_solidImages;
                this.m_solidImages = new javax.microedition.lcdui.Image[this.l_solidImages.length + 4];
                System.arraycopy(this.l_solidImages, 0, this.m_solidImages, 0, this.m_shSolidImageCount);
            } else {
                this.m_solidImages = new javax.microedition.lcdui.Image[4];
            }
            this.l_solidImages = null;
        }
        this.m_solidImages[this.m_shSolidImageCount] = image;
        short s = this.m_shSolidImageCount;
        this.m_shSolidImageCount = (short)(s + 1);
        return s;
    }

    void paint(Graphics g) {
        l_shPtr = 0;
        this.l_bUsedSetClip = false;
        while (l_shPtr < this.m_shLength) {
            short s = l_shPtr;
            l_shPtr = (short)(s + 1);
            switch (this.m_data[s]) {
                case 0: {
                    l_shInd = this.nextShort();
                    l_shX = this.nextShort();
                    l_shY = this.nextShort();
                    if (this.nextShort() == 0) break;
                    this.m_images[l_shInd].paint(g, 0, l_shX + this.m_nX + 0, l_shY + this.m_nY);
                    break;
                }
                case 16: {
                    l_shX = this.nextShort();
                    l_shY = this.nextShort();
                    l_bTransparent = this.nextShort() != 0;
                    l_shInd = this.nextShort();
                    g.drawImage(this.m_solidImages[l_shInd], this.m_nX + l_shX, this.m_nY + l_shY, 0);
                    break;
                }
                case 2: {
                    this.setColor(g);
                    l_shX = this.nextShort();
                    l_shY = this.nextShort();
                    l_shW = this.nextShort();
                    l_shH = this.nextShort();
                    if (this.nextShort() == 0) break;
                    g.fillRect(l_shX + this.m_nX, l_shY + this.m_nY, (int)l_shW, (int)l_shH);
                    break;
                }
                case 1: {
                    this.setColor(g);
                    l_shX = this.nextShort();
                    l_shY = this.nextShort();
                    l_shW = this.nextShort();
                    l_shH = this.nextShort();
                    if (this.nextShort() == 0) break;
                    g.drawRect(l_shX + this.m_nX, l_shY + this.m_nY, (int)l_shW, (int)l_shH);
                    break;
                }
                case 7: {
                    l_shInd = this.nextShort();
                    l_shX = this.nextShort();
                    l_shY = this.nextShort();
                    l_shFrame = this.nextShort();
                    if (this.nextShort() == 0) break;
                    this.m_sprites[l_shInd].paint(g, l_shFrame, l_shX + this.m_nX, l_shY + this.m_nY);
                    break;
                }
                case 3: {
                    this.setColor(g);
                    int nX = this.nextShort() + this.m_nX;
                    int nY = this.nextShort() + this.m_nY;
                    g.drawLine(nX, nY, nX + this.nextShort(), nY + this.nextShort());
                    break;
                }
                case 4: {
                    l_shX = this.nextShort();
                    l_shY = this.nextShort();
                    l_shW = this.nextShort();
                    l_shH = this.nextShort();
                    if (this.nextShort() == 0) break;
                    if (!this.l_bUsedSetClip) {
                        this.l_nClipX = g.getClipX();
                        this.l_nClipY = g.getClipY();
                        this.l_nClipWidth = g.getClipWidth();
                        this.l_nClipHeight = g.getClipHeight();
                        this.l_bUsedSetClip = true;
                    }
                    g.setClip((int)l_shX, (int)l_shY, (int)l_shW, (int)l_shH);
                }
            }
        }
        if (this.l_bUsedSetClip) {
            g.setClip(this.l_nClipX, this.l_nClipY, this.l_nClipWidth, this.l_nClipHeight);
        }
    }

    public int findFloor(int nX, int nY) {
        int res = this.m_nBottom;
        l_shPtr = 0;
        m_shFoundFloorId = (short)-1;
        for (l_shCounter = 0; l_shCounter < this.m_shFloorCount; l_shCounter = (short)(l_shCounter + 1)) {
            short s = l_shPtr;
            l_shPtr = (short)(s + 1);
            l_shX = this.m_floor[s];
            short s2 = l_shPtr;
            l_shPtr = (short)(s2 + 1);
            l_shY = this.m_floor[s2];
            short s3 = l_shPtr;
            l_shPtr = (short)(s3 + 1);
            l_shW = this.m_floor[s3];
            short s4 = l_shPtr;
            l_shPtr = (short)(s4 + 1);
            l_shInd = this.m_floor[s4];
            short s5 = l_shPtr;
            l_shPtr = (short)(s5 + 1);
            l_shFrame = (short)this.getNum(this.m_floor[s5]);
            if (l_shFrame == 0 || l_shX > nX || nX >= l_shX + l_shW || l_shY <= nY || l_shY >= res) continue;
            res = l_shY;
            m_shFoundFloorId = l_shInd;
        }
        return res;
    }

    public boolean isCatch(int nX, int nY, int nYLen) {
        l_shPtr = 0;
        for (l_shCounter = 0; l_shCounter < this.m_shCatchCount; l_shCounter = (short)(l_shCounter + 1)) {
            short s = l_shPtr;
            l_shPtr = (short)(s + 1);
            l_shX = this.m_catch[s];
            short s2 = l_shPtr;
            l_shPtr = (short)(s2 + 1);
            l_shY = this.m_catch[s2];
            short s3 = l_shPtr;
            l_shPtr = (short)(s3 + 1);
            l_shW = this.m_catch[s3];
            short s4 = l_shPtr;
            l_shPtr = (short)(s4 + 1);
            l_shH = this.m_catch[s4];
            short s5 = l_shPtr;
            l_shPtr = (short)(s5 + 1);
            m_shFoundCatchId = this.m_catch[s5];
            if (l_shX > nX || nX >= l_shX + l_shW || l_shY > nY + nYLen || nY > l_shY + l_shH) continue;
            if (nY >= l_shY) {
                m_nCatchY = nY;
            } else {
                l_shH = (short)Math.min(nY + nYLen, l_shY + l_shH);
                m_nCatchY = l_shY + l_shH >> 1;
            }
            if (m_shFoundCatchId == 0) {
                return true;
            }
            if (!GameProcess.acceptCatch(m_shFoundCatchId)) continue;
            return true;
        }
        return false;
    }

    public boolean isCatch(int nX, int nY) {
        l_shPtr = 0;
        for (l_shCounter = 0; l_shCounter < this.m_shCatchCount; l_shCounter = (short)(l_shCounter + 1)) {
            short s = l_shPtr;
            l_shPtr = (short)(s + 1);
            l_shX = this.m_catch[s];
            short s2 = l_shPtr;
            l_shPtr = (short)(s2 + 1);
            l_shY = this.m_catch[s2];
            short s3 = l_shPtr;
            l_shPtr = (short)(s3 + 1);
            l_shW = this.m_catch[s3];
            short s4 = l_shPtr;
            l_shPtr = (short)(s4 + 1);
            l_shH = this.m_catch[s4];
            short s5 = l_shPtr;
            l_shPtr = (short)(s5 + 1);
            m_shFoundCatchId = this.m_catch[s5];
            if (l_shX > nX || nX >= l_shX + l_shW || l_shY > nY || nY >= l_shY + l_shH) continue;
            if (m_shFoundCatchId == 0) {
                return true;
            }
            if (!GameProcess.acceptCatch(m_shFoundCatchId)) continue;
            return true;
        }
        return false;
    }

    boolean isExit(int nX, int nY, int nWidth, int nHeight) {
        return this.m_nExitWidth != 0 && Game.intersectRect(nX, nY, nX + nWidth, nY + nHeight, this.m_nExitX, this.m_nExitY, this.m_nExitX + this.m_nExitWidth, this.m_nExitY + this.m_nExitHeight);
    }

    public void dispose() {
        this.m_images = null;
        this.m_data = null;
        this.m_params = null;
    }
}

