/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;

public class GameProcess
extends GameCanvas
implements CommandListener,
Runnable {
    static final int NEW_GAME = -1;
    static final int GAME_FIRST = 0;
    static final int GAME_MAIN = 0;
    static final int GAME_AQUARIUM = 1;
    static final int GAME_SARATOV = 2;
    static final int GAME_TV = 3;
    static final int GAME_BONUS = 4;
    static final int GAME_DOG = 5;
    static final int GAME_FISH = 6;
    static final int GAME_SPIDER = 7;
    static final int GAME_LAST = 7;
    static final int GAME_OVER = 8;
    static final int KILL_SCENE = 9;
    static final int SPLASH_SCENE = 8;
    static final int KILL_WAIT = 30;
    static final int SUCCESS_WAIT = 31;
    static final int MENU = 50;
    static final int STATE_WAIT = 100;
    static final int STATE_LOADING = 101;
    static final int STATE_UNLOAD = 102;
    static final int STATE_SPLASH = 80;
    static final int STATE_START_GAME = 200;
    static final int EXIT_WINDOW_CATCH = 100;
    static final int OBJECT_HIDDEN = 0;
    static final int OBJECT_APPEAR = 1;
    static final int OBJECT_VISIBLE = 2;
    static final int OBJECT_HIDE = 3;
    static final long SCENE_REFRESH = 56L;
    static final long DOG_REFRESH = 70L;
    static final int DOG_FILE = 10;
    static final int DUST_FILE = 12;
    static final int DOG_SPEED = 6;
    static final int DUST_SPEED = 5;
    static final int[] DOG_WAIT = new int[]{10000, 5000, 3000};
    static final int START_LIVES = 3;
    static final int BONK_FILE = 801;
    static final int BITE_FILE = 802;
    static final int ZAP_FILE = 10803;
    static final int KITTY_FILE = 112;
    static final int BAD_CAT_FILE = 113;
    static final int QUICK_SCORE_SHOW_TIME = 500;
    static final int MENU_CONTROLS_COUNT = 8;
    static final int CONTROL_MAIN = 0;
    static final int CONTROL_COMPL = 1;
    static final int CONTROL_OPTIONS = 2;
    static final int CONTROL_HISCORE = 3;
    static final int CONTROL_ABOUT = 4;
    static final int CONTROL_HELP = 5;
    static final int CONTROL_PAUSE = 6;
    static final int CONTROL_INPUT_NAME = 7;
    static final int SCORE_LIMIT_EASY = 6000;
    static final int SCORE_LIMIT_MEDIUM = 100000;
    static final int SPLASH_TIME = 1500;
    static final int HI_SCORE_COUNT = 5;
    static final int LOAIDNG_IMAGE = 124;
    static String[] m_names = new String[]{"/bg.mid", "/start.mid", "/die.mid", "/cpl.mid", "/pick.mid"};
    static String[] m_formats = new String[]{"audio/midi", "audio/midi", "audio/midi", "audio/midi", "audio/midi"};
    static int[] m_counts = new int[]{-1, 1, 1, 1, 1};
    static Player m_curSound;
    static byte[][] m_sounds;
    static int[] m_sizes;
    static int m_nCurrentSound;
    static final int SOUND_COUNT = 5;
    static final int SOUND_BACKGROUND = 0;
    static final int SOUND_START = 1;
    static final int SOUND_DIE = 2;
    static final int SOUND_COMPLETE = 3;
    static final int SOUND_PICK = 4;
    static long m_lCurrentTime;
    static long m_lLastTime;
    static boolean m_bFreezeTime;
    protected static int l_nGotoGame;
    static final int LEVEL_KILL_WAIT_TIME = 1000;
    static final int LEVEL_SHOW_SCORE_TIME = 3000;
    static final int SCORE_SPEED = 10;
    static final int LEVEL_CONTINUE = 0;
    static final int LEVEL_KILL = 1;
    static final int LEVEL_KILL_WAIT = 2;
    static final int LEVEL_DONE = 3;
    static final int LEVEL_EXIT = 4;
    static final int LEVEL_GOTO = 5;
    static final int LEVEL_PAUSE = 6;
    static final int IMAGE_BLINK_TIME = 100;
    static long m_lLevelWaitEnd;
    static int m_nCurrentLevelState;
    static String m_strScore;
    static int m_nScoreY;
    static Image m_imgBlink;
    static int m_nBlinkImageFrame;
    static boolean m_bBlink;
    static long m_lNextBlink;
    static int m_nBlinkX;
    static int m_nBlinkY;
    static long m_lScoreStart;
    static int m_nIterationCount;
    static final String CONFIG_NAME = "accfg";
    static int m_nLastGame;
    static final int[] BONUS_ARROW_V;
    static int m_nBonusLevels;
    static int[] m_nBonusLevY;
    static int m_nBonusHearts;
    static int m_nBonusHeartsPerLevel;
    static int m_nBonusArrowFloorChecked;
    static Monster[] m_mcat;
    static Monster m_kitty;
    static final int DOMIK_WIN_COUNT = 8;
    static final int DOMIK_WIN_FRAME_COUNT = 4;
    static final int DOMIK_WIN_VIS_PARAM_FIRST = 0;
    static final int DOMIK_WIN_FRAME_PARAM_FIRST = 8;
    static final int DOMIK_LEFT_BARREL = 16;
    static final int DOMIK_RIGHT_BARREL = 17;
    static final int DOMIK_WIN_CATCH_ID_FIRST = 10;
    static final int DOMIK_KILLER_FIRST = 16;
    static final int DOMIK_KILLER_FLOOR_FIRST = 18;
    static final int DOMIK_SCORE_DIGITS = 7;
    static final int DOMIK_LIVES = 20;
    static final int DOMIK_KILLER_SPEED = 4;
    static final int DOMIK_SAPOG_VX = 1;
    static final int DOMIK_SAPOG_DVY = 1;
    static final int DOMIK_SAPOG_X = 21;
    static final int DOMIK_SAPOG_Y = 22;
    static final int DOMIK_SAPOG_W = 23;
    static final int DOMIK_SAPOG_H = 23;
    static final int DOMIK_SAPOG_FRAME = 24;
    static final int DOMIK_SAPOG_VIS = 25;
    static final int[] DOMIK_KILLER_WAIT;
    static final int[] DOMIK_KILLER_STAY;
    static final int[] DOMIK_WINDOW_OPEN_TIME;
    static final int DOMIK_WINDOW_CLOSED_TIME = 100;
    static int m_nWinState;
    static int m_nWindowIndex;
    static int m_nWindowFrame;
    static int m_nFenceY;
    static int m_nSapogVx;
    static int m_nSapogVy;
    static int[] m_nWinCenterX;
    static int[] m_nWinCenterY;
    static long m_lNextWindowUpdate;
    static final int SARATOV_SPIDER_FIRST = 7;
    static final int SARATOV_MOUSE_FIRST = 0;
    static final int[] SARATOV_SPIDER_SPEED;
    static final int[] SARATOV_SPIDER_WAIT;
    static final int[] SARATOV_SPIDER_STAY;
    static final int SARATOV_MOUSE_SIGN = 10;
    static final int SARATOV_CATCH_ID_FIRST = 10;
    static final int[] SARATOV_MOUSE_WAIT;
    static final int[] SARATOV_MOUSE_STAY;
    static final int SARATOV_X_FIRST = 15;
    static final int SARATOV_Y_FIRST = 22;
    static final int SARATOV_MOUSE_SIZE = 24;
    static final int SARATOV_SPIDER_SIZE = 8;
    static final int SARATOV_SPIDER_X_FIRST = 29;
    static int m_nSaratovMouseCount;
    static final int SPIDER_VASE_X_FIRST = 0;
    static final int SPIDER_VASE_Y_FIRST = 12;
    static final int SPIDER_VASE_Y_BROKEN_FIRST = 16;
    static final int SPIDER_VASE_VISIBLE_FIRST = 4;
    static final int SPIDER_VASE_VISIBLE_BROKEN_FIRST = 8;
    static final int SPIDER_VASE_MAX_MOVE = 20;
    static final int SPIDER_VASE_WIDTH = 21;
    static final int SPIDER_VASE_CENTER_OFFSET_FIRST = 22;
    static final int SPIDER_VASE_INIT_X_FIRST = 8;
    static final int SPIDER_VASE_VY_FIRST = 4;
    static final int SPIDER_X = 26;
    static final int SPIDER_SIDE_Y = 27;
    static final int SPIDER_TOP_Y = 28;
    static final int SPIDER_SIDE_FRAME = 29;
    static final int SPIDER_TOP_FRAME = 30;
    static final int SPIDER_SIDE_VISIBLE = 31;
    static final int SPIDER_TOP_VISIBLE = 32;
    static final int SPIDER_KOMOD_LEFT = 33;
    static final int SPIDER_KOMOD_TOP = 34;
    static final int SPIDER_KOMOD_WIDTH = 35;
    static final int SPIDER_KOMOD_HEIGHT = 36;
    static final int SPIDER_KOMOD_CENTER_Y = 37;
    static final int SPIDER_SIDE_FRAME_COUNT = 4;
    static final int SPIDER_TOP_FRAME_COUNT = 4;
    static final int SPIDER_VASE_DV = 1;
    static final int[] SPIDER_VX;
    static final int[] SPIDER_VY;
    static final int SPIDER_REFRESH = 100;
    static int m_nSpiderKomodLeft;
    static int m_nSpiderKomodTop;
    static int m_nSpiderKomodWidth;
    static int m_nSpiderKomodHeight;
    static int m_nSpiderKomodCenterY;
    static int m_nSpiderTopW;
    static int m_nSpiderTopH;
    static int m_nSpiderTopH2;
    static int m_nSpiderSideW;
    static int m_nSpiderSideH;
    static boolean m_bSpiderSide;
    static long m_lNextSpiderProcess;
    static final int FISH_AQUARIUM_FLOOR = 10;
    static final int AQUA_CAT_REFRESH = 200;
    static final int AQUA_ELFISH_FILE = 601;
    static final int AQUA_PROGRESS_TOP = 0;
    static final int AQUA_PROGRESS_HEIGHT = 1;
    static final int[] AQUA_DIE;
    static final int[] AQUA_BREATHE;
    static final int AQUA_CAT_FALL = 3;
    static long m_lNextAquaCatProcess;
    static int m_nCatOffset;
    static boolean m_bCatMoveUp;
    static Monster[] m_fish;
    static Monster[] m_elFish;
    static int[] m_fishScore;
    static int m_nFishCount;
    static final int TV_CAGE_X = 0;
    static final int TV_CAGE_Y = 1;
    static final int TV_CAGE_BROKEN_Y = 2;
    static final int TV_CAGE_VISIBLE = 3;
    static final int TV_CAGE_BROKEN_VISIBLE = 4;
    static final int TV_CAGE_X_OFFSET = 5;
    static final int TV_CAGE_WIDTH = 6;
    static final int TV_CAGE_Y_OFFSET = 7;
    static final int TV_CAGE_HEIGHT = 8;
    static final int TV_CAGE_MOVE = 9;
    static final int TV_BIRD_X = 10;
    static final int TV_BIRD_Y = 11;
    static final int TV_BIRD_W = 12;
    static final int TV_BIRD_H = 13;
    static final int TV_BIRD_FRAME = 22;
    static final int TV_BIRD_FALL_V = 1;
    static final int TV_DROP_RECT_X = 23;
    static final int TV_DROP_RECT_Y = 24;
    static final int TV_DROP_RECT_W = 25;
    static final int TV_DROP_RECT_H = 26;
    static final int TV_DROP_BOTTOM = 27;
    static final int TV_DROP_VISIBLE = 28;
    static final int TV_DROP_X = 29;
    static final int TV_DROP_Y = 30;
    static final int TV_BIRD_V = 5;
    static final int TV_POINT_X = 14;
    static final int TV_POINT_Y = 18;
    static final int TV_CAGE_STATE = 0;
    static final int TV_CAGE_V = 1;
    static final int TV_CAGE_OFFS = 2;
    static final int TV_BIRD_STATE = 3;
    static final int TV_DROP_V = 4;
    static final int TV_CAGE_DV = 1;
    static final int TV_BIRD_SIT = 0;
    static final int TV_BIRD_FLY = 1;
    static final int TV_BIRD_FLY_FAR = 2;
    static final int TV_BIRD_DIE = 3;
    static final int TV_SCENE_REFRESH = 60;
    static final int[] TV_BIRD_SIT_TIME;
    static int m_nBirdTargetX;
    static int m_nBirdTargetY;
    static boolean m_bBirdFirstFly;
    protected static boolean l_bProcessDog_LastResult;
    static long m_lNextSceneProcess;
    public static long m_lThisTickCount;
    public Thread m_animationThread;
    public static int m_nState;
    public static int m_nLoadingState;
    public static boolean m_bProcessing;
    public static Image m_imgLogo;
    static int m_nStartingGame;
    static boolean m_bDrawLoadingSprite;
    static String m_sSelect;
    static String m_sBack;
    static Scene m_scene;
    static Monster m_cat;
    static Monster m_swimCat;
    static Monster m_broom;
    static Sprite m_dog;
    static Sprite m_dust;
    static int m_nComplication;
    static boolean m_bBonus;
    static int m_nKillerTopPos;
    static int m_nKillerBottomPos;
    static long[] m_lKillerStateChange;
    static int[] m_nKillerState;
    static int m_nKillerPos;
    static int m_nKillerIndex;
    static long m_lDogRespawn;
    static long m_lDogProcess;
    static String m_strQuickScore;
    static long m_lQuickScoreHideTime;
    static int m_nQuickScoreX;
    static int m_nQuickScoreY;
    static int m_nDustVx;
    static Image m_imgBonk;
    static Image m_imgKill;
    static Image m_imgLoading;
    static final String m_strScoreFont = "0123456789+x";
    static Image m_imgScoreFont;
    static final String m_strSmallScoreFont = "0123456789";
    static Image m_imgSmallScoreFont;
    static Control[] m_cControls;
    static int m_nCurrentControl;
    static String[] m_sHiScores;
    static int[] m_nHiScores;
    static String m_sEmptyHiScore;
    static boolean m_bMusic;
    static boolean m_bSound;
    static int m_nScore;
    static int m_nLives;
    protected static short l_shX;
    protected static short l_shY;
    protected static short l_shW;
    protected static short l_shH;
    protected static short l_shPtr;
    protected static short l_shCounter;
    protected static short l_shInd;

    static void initSound() throws Exception {
        try {
            m_sounds = new byte[m_names.length][];
            for (int nSound = 0; nSound < m_names.length; ++nSound) {
                InputStream is = "L".getClass().getResourceAsStream(m_names[nSound]);
                GameProcess.m_sounds[nSound] = new byte[m_sizes[nSound]];
                is.read(m_sounds[nSound]);
                is.close();
            }
            m_curSound = null;
            m_nCurrentSound = -1;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static void playSound(int nSound) {
        try {
            if (nSound == 0 && !m_bMusic) {
                return;
            }
            if (nSound != 0 && !m_bSound) {
                return;
            }
            GameProcess.stopSound();
            m_curSound = Manager.createPlayer((InputStream)new ByteArrayInputStream(m_sounds[nSound]), (String)m_formats[nSound]);
            m_curSound.setLoopCount(m_counts[nSound]);
            m_curSound.start();
            m_nCurrentSound = nSound;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static void stopSound() {
        if (m_curSound != null) {
            try {
                m_curSound.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        m_nCurrentSound = -1;
        m_curSound = null;
    }

    static void resetSound() {
        GameProcess.stopSound();
        if (m_bMusic && (m_nState == 50 || m_nState == 8)) {
            GameProcess.playSound(0);
        }
    }

    GameProcess() throws Exception {
        super(false);
        this.setFullScreenMode(true);
        m_nState = 80;
        m_lNextSceneProcess = System.currentTimeMillis() + 1500L;
        try {
            m_imgLogo = Image.createImage((String)"/sp.png");
        }
        catch (Exception ex) {
            m_lNextSceneProcess -= 1500L;
        }
        m_nLoadingState = 0;
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command.getCommandType() == 4) {
            this.doKey(-1000, true);
        } else if (command.getCommandType() == 3) {
            this.doKey(-1001, true);
        } else if (command.getCommandType() == 2) {
            this.doKey(-1002, true);
        }
    }

    public synchronized void start() {
        this.m_animationThread = new Thread(this);
        this.m_animationThread.start();
    }

    public synchronized void stop() {
        this.m_animationThread = null;
    }

    public void run() {
        Thread currentThread = Thread.currentThread();
        block4: while (true) {
            try {
                while (currentThread == this.m_animationThread) {
                    Graphics gbb = this.getGraphics();
                    this.draw(gbb);
                    this.flushGraphics();
                    m_lCurrentTime = System.currentTimeMillis();
                    if (!m_bFreezeTime) {
                        m_lThisTickCount += m_lCurrentTime - m_lLastTime;
                    }
                    m_lLastTime = m_lCurrentTime;
                    try {
                        Thread.sleep(1L);
                        currentThread.yield();
                        continue block4;
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
                break;
            }
            catch (Exception exception) {
                // empty catch block
                break;
            }
        }
    }

    static void freezeTime(boolean freeze) {
        m_bFreezeTime = freeze;
        if (!m_bFreezeTime) {
            m_lLastTime = System.currentTimeMillis();
        }
    }

    static void stopGame(boolean bSuccess) {
        Game.m_game.quitApp();
    }

    protected void keyPressed(int nKey) {
        this.doKey(nKey, true);
    }

    protected void keyReleased(int nKey) {
        this.doKey(nKey, false);
    }

    public void playerUpdate(Player player, String event, Object eventData) {
    }

    void doKey(int nKeyCode, boolean bIsDown) {
        try {
            if (m_nState == 8) {
                if (!bIsDown) {
                    return;
                }
                GameProcess.startGame(-1);
            } else if (m_nState == 50 || m_nCurrentLevelState == 6) {
                if (!bIsDown) {
                    return;
                }
                int nKey = Game.getMenuKey(nKeyCode);
                if (m_nCurrentControl == 7 && Game.getVirtualKey(nKeyCode) == 53) {
                    m_cControls[m_nCurrentControl].keyPressedEvent(nKeyCode);
                } else if (nKey == 20) {
                    block1 : switch (m_nCurrentControl) {
                        case 0: {
                            if (GameProcess.m_cControls[GameProcess.m_nCurrentControl].m_nSelected == GameProcess.m_cControls[GameProcess.m_nCurrentControl].m_sItems.length - 1) {
                                Game.quitApp();
                                return;
                            }
                            m_nCurrentControl = GameProcess.m_cControls[GameProcess.m_nCurrentControl].m_nSelected + 1;
                            break;
                        }
                        case 2: {
                            GameProcess.m_cControls[GameProcess.m_nCurrentControl].m_bChecks[GameProcess.m_cControls[GameProcess.m_nCurrentControl].m_nSelected] = !GameProcess.m_cControls[GameProcess.m_nCurrentControl].m_bChecks[GameProcess.m_cControls[GameProcess.m_nCurrentControl].m_nSelected];
                            break;
                        }
                        case 1: {
                            m_nComplication = GameProcess.m_cControls[GameProcess.m_nCurrentControl].m_nSelected;
                            GameProcess.startGame(-1);
                            GameProcess.resetSound();
                            break;
                        }
                        case 6: {
                            switch (GameProcess.m_cControls[GameProcess.m_nCurrentControl].m_nSelected) {
                                case 0: {
                                    m_nCurrentLevelState = 0;
                                    GameProcess.freezeTime(false);
                                    break block1;
                                }
                                case 1: {
                                    m_nCurrentLevelState = 0;
                                    GameProcess.startGame(50);
                                    GameProcess.resetSound();
                                    return;
                                }
                                case 2: {
                                    Game.quitApp();
                                    return;
                                }
                            }
                            break;
                        }
                        case 7: {
                            GameProcess.addHiScore(GameProcess.m_cControls[7].m_sItems[0], m_nScore);
                            m_nCurrentControl = 3;
                        }
                    }
                } else {
                    if (nKey == 21) {
                        if (m_nCurrentControl == 6) {
                            m_nCurrentLevelState = 0;
                            return;
                        }
                        if (m_nCurrentControl == 7) {
                            m_cControls[m_nCurrentControl].keyPressedEvent(-1003);
                        } else if (m_nCurrentControl != 0) {
                            if (m_nCurrentControl == 2) {
                                m_bMusic = GameProcess.m_cControls[2].m_bChecks[0];
                                m_bSound = GameProcess.m_cControls[2].m_bChecks[1];
                                GameProcess.resetSound();
                            }
                            nKey = m_nCurrentControl - 1;
                            m_nCurrentControl = 0;
                            GameProcess.m_cControls[GameProcess.m_nCurrentControl].m_nSelected = nKey;
                        }
                        return;
                    }
                    m_cControls[m_nCurrentControl].keyPressedEvent(nKeyCode);
                }
                return;
            }
            nKeyCode = Game.getGameKey(nKeyCode);
            switch (nKeyCode) {
                case 3: {
                    m_cat.setState(1280, bIsDown ? 256 : 0);
                    break;
                }
                case 4: {
                    m_cat.setState(1280, bIsDown ? 1024 : 0);
                    break;
                }
                case 1: {
                    m_cat.setState(512, bIsDown ? -1 : 0);
                    break;
                }
                case 2: {
                    m_cat.setState(2048, bIsDown ? -1 : 0);
                    break;
                }
                case 10: {
                    m_cat.setState(1024, 0);
                    m_cat.setState(768, bIsDown ? -1 : 0);
                    break;
                }
                case 11: {
                    m_cat.setState(256, 0);
                    m_cat.setState(1536, bIsDown ? -1 : 0);
                    break;
                }
                case 12: {
                    m_cat.setState(1024, 0);
                    m_cat.setState(2304, bIsDown ? -1 : 0);
                    break;
                }
                case 13: {
                    m_cat.setState(256, 0);
                    m_cat.setState(3072, bIsDown ? -1 : 0);
                    break;
                }
                case 17: {
                    if (!bIsDown) break;
                    GameProcess.freezeTime(true);
                    m_nCurrentControl = 6;
                    m_nCurrentLevelState = 6;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void draw(Graphics g) {
        m_bProcessing = true;
        try {
            g.setClip(0, 0, 132, 176);
            if (m_nState != 100 && m_nState != 200) {
                g.setColor(0);
                g.fillRect(0, 0, 132, 176);
            }
            switch (m_nState) {
                case 80: {
                    if (m_lNextSceneProcess < m_lThisTickCount) {
                        m_nState = 101;
                    }
                    g.drawImage(m_imgLogo, 0, 0, 20);
                    break;
                }
                case 200: {
                    if (m_bDrawLoadingSprite) {
                        if (m_imgLoading != null) {
                            m_imgLoading.paint(g, 0, 132 - GameProcess.m_imgLoading.m_nFrameWidth >> 1, 176 - GameProcess.m_imgLoading.m_nFrameHeight >> 1);
                        }
                    } else {
                        GameProcess.loadStartGame(m_nStartingGame);
                        if (m_nStartingGame == 50) {
                            m_nCurrentControl = m_nScore > m_nHiScores[4] ? 7 : 0;
                            GameProcess.resetSound();
                        } else if (m_nStartingGame == -1) {
                            // empty if block
                        }
                    }
                    m_bDrawLoadingSprite = !m_bDrawLoadingSprite;
                    break;
                }
                case 100: {
                    break;
                }
                case 101: {
                    if (m_imgLogo != null) {
                        g.drawImage(m_imgLogo, 66, 88, 3);
                    }
                    GameProcess.loadIteration(g);
                    break;
                }
                case 50: {
                    m_scene.paint(g);
                    m_cControls[m_nCurrentControl].paint(g);
                    if (m_nCurrentControl != 7) break;
                    Game.drawStringBmp(g, "" + m_nScore, 66, 166, 33, m_imgScoreFont, m_strScoreFont);
                    break;
                }
                case 8: {
                    if (m_scene == null) break;
                    m_scene.paint(g);
                    break;
                }
                case 0: {
                    GameProcess.process_houseScene();
                    m_scene.paint(g);
                    if (GameProcess.process_dog()) {
                        m_cat.cat_process();
                        GameProcess.m_cat.m_sprite.paint(g);
                        m_dog.paint(g);
                    } else {
                        m_dust.paint(g);
                    }
                    Game.drawStringBmp(g, m_strScore, 66, 2, 1, m_imgSmallScoreFont, m_strSmallScoreFont);
                    GameProcess.levelSwitch(g);
                    break;
                }
                case 2: 
                case 3: 
                case 7: {
                    switch (m_nState) {
                        case 2: {
                            GameProcess.process_saratovScene();
                            break;
                        }
                        case 7: {
                            GameProcess.process_spiderScene();
                            break;
                        }
                        case 3: {
                            GameProcess.process_tvScene();
                        }
                    }
                    m_scene.paint(g);
                    m_broom.broom_process();
                    if (GameProcess.process_dog()) {
                        m_cat.cat_process();
                        GameProcess.m_cat.m_sprite.paint(g);
                        m_dog.paint(g);
                    } else {
                        m_dust.paint(g);
                    }
                    Monster.soles_draw(g);
                    GameProcess.m_broom.m_sprite.paint(g);
                    if (m_scene.isExit(GameProcess.m_cat.m_sprite.m_nX + GameProcess.m_cat.m_sprite.m_nCollisionRectX, GameProcess.m_cat.m_sprite.m_nY + GameProcess.m_cat.m_sprite.m_nCollisionRectY, GameProcess.m_cat.m_sprite.m_nCollisionRectWidth, GameProcess.m_cat.m_sprite.m_nCollisionRectHeight)) {
                        m_nCurrentLevelState = 4;
                    }
                    GameProcess.levelSwitch(g);
                    break;
                }
                case 6: {
                    m_scene.paint(g);
                    m_broom.broom_process();
                    if (GameProcess.process_dog()) {
                        if (!m_cat.cat_process()) {
                            GameProcess.startGame(1);
                        }
                        GameProcess.m_cat.m_sprite.paint(g);
                        m_dog.paint(g);
                    } else {
                        m_dust.paint(g);
                    }
                    Monster.soles_draw(g);
                    GameProcess.m_broom.m_sprite.paint(g);
                    if (m_scene.isExit(GameProcess.m_cat.m_sprite.m_nX + GameProcess.m_cat.m_sprite.m_nCollisionRectX, GameProcess.m_cat.m_sprite.m_nY + GameProcess.m_cat.m_sprite.m_nCollisionRectY, GameProcess.m_cat.m_sprite.m_nCollisionRectWidth, GameProcess.m_cat.m_sprite.m_nCollisionRectHeight)) {
                        m_nCurrentLevelState = 4;
                    }
                    GameProcess.levelSwitch(g);
                    break;
                }
                case 1: {
                    m_scene.paint(g);
                    GameProcess.process_aquariumScene();
                    l_shCounter = 0;
                    for (l_shPtr = 0; l_shPtr < m_nFishCount; l_shPtr = (short)(l_shPtr + 1)) {
                        if (m_fish[l_shPtr] != null) {
                            if (m_fish[l_shPtr].fish_process()) {
                                if (GameProcess.m_swimCat.m_nState != 1 && GameProcess.m_swimCat.m_nState != 5) {
                                    GameProcess.playSound(4);
                                    l_shY = (short)(GameProcess.m_scene.m_nTop + 20);
                                    l_shH = (short)(GameProcess.m_scene.m_nBottom - l_shY);
                                    l_shW = (short)(GameProcess.m_scene.m_nBottom - GameProcess.m_scene.m_nTop);
                                    if (m_fishScore[l_shPtr] > 0) {
                                        GameProcess.showQuickScore(m_fishScore[l_shPtr], GameProcess.m_swimCat.m_sprite.m_nX + (GameProcess.m_swimCat.m_sprite.m_nFrW >> 1), GameProcess.m_swimCat.m_sprite.m_nY - 6);
                                    }
                                    if (GameProcess.m_swimCat.m_sprite.m_nY > l_shY + (l_shH >> 1)) {
                                        GameProcess.m_elFish[GameProcess.l_shPtr].m_sprite.setPosition(Game.random(l_shW - GameProcess.m_elFish[GameProcess.l_shPtr].m_sprite.m_nFrW) + GameProcess.m_scene.m_nLeft, Game.random((l_shH >> 1) - GameProcess.m_elFish[GameProcess.l_shPtr].m_sprite.m_nFrH) + l_shY);
                                    } else {
                                        GameProcess.m_elFish[GameProcess.l_shPtr].m_sprite.setPosition(Game.random(l_shW - GameProcess.m_elFish[GameProcess.l_shPtr].m_sprite.m_nFrW) + GameProcess.m_scene.m_nLeft, Game.random((l_shH >> 1) - (GameProcess.m_elFish[GameProcess.l_shPtr].m_sprite.m_nFrH << 1)) + l_shY + (l_shH >> 1) + GameProcess.m_elFish[GameProcess.l_shPtr].m_sprite.m_nFrH);
                                    }
                                    GameProcess.m_fish[GameProcess.l_shPtr] = null;
                                } else {
                                    GameProcess.m_fish[GameProcess.l_shPtr].m_sprite.paint(g);
                                }
                            } else {
                                GameProcess.m_fish[GameProcess.l_shPtr].m_sprite.paint(g);
                            }
                        } else if (m_elFish[l_shPtr].fish_process()) {
                            if (GameProcess.m_swimCat.m_nState != 1 && GameProcess.m_swimCat.m_nState != 5) {
                                m_imgBlink = m_imgKill;
                                if (GameProcess.m_imgBlink.m_images.length > 1) {
                                    m_swimCat.setFrameSequence(GameProcess.m_swimCat.m_nState < 4 ? 2 : 6);
                                    int n = m_nBlinkImageFrame = GameProcess.m_swimCat.m_sprite.m_nCurrentFrame < GameProcess.m_swimCat.m_sprite.m_nFrameCount >> 1 ? 0 : 1;
                                    if (m_nBlinkImageFrame > GameProcess.m_imgBlink.m_images.length) {
                                        m_nBlinkImageFrame = 0;
                                    }
                                }
                                GameProcess.endLevel(false);
                                return;
                            }
                            GameProcess.m_elFish[GameProcess.l_shPtr].m_sprite.paint(g);
                        } else {
                            GameProcess.m_elFish[GameProcess.l_shPtr].m_sprite.paint(g);
                            l_shCounter = (short)(l_shCounter + 1);
                        }
                        if (l_shCounter != m_nFishCount || m_nCurrentLevelState != 0) continue;
                        GameProcess.endLevel(true);
                        return;
                    }
                    if (GameProcess.m_swimCat.m_nState != 1 && GameProcess.m_swimCat.m_nState != 5) {
                        m_swimCat.swcat_process();
                    }
                    GameProcess.m_swimCat.m_sprite.m_nY += m_nCatOffset;
                    GameProcess.m_swimCat.m_sprite.paint(g);
                    GameProcess.m_swimCat.m_sprite.m_nY -= m_nCatOffset;
                    GameProcess.levelSwitch(g);
                    break;
                }
                case 4: {
                    GameProcess.process_bonusScene();
                    m_cat.cat_process();
                    m_scene.paint(g);
                    l_shPtr = (short)m_mcat.length;
                    while ((l_shPtr = (short)(l_shPtr - 1)) >= 0) {
                        GameProcess.m_mcat[GameProcess.l_shPtr].m_sprite.paint(g);
                    }
                    if (m_cat.getState(255) != 5) {
                        GameProcess.m_kitty.m_sprite.paint(g);
                    }
                    GameProcess.m_cat.m_sprite.paint(g);
                    GameProcess.levelSwitch(g);
                    break;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        m_bProcessing = false;
    }

    static void showQuickScore(int score, int x, int y) {
        m_nScore += score;
        m_strQuickScore = "+" + score;
        m_lQuickScoreHideTime = m_lThisTickCount + 500L;
        m_nQuickScoreX = x;
        m_nQuickScoreY = y;
    }

    static void levelSwitch(Graphics g) {
        switch (m_nCurrentLevelState) {
            case 6: {
                m_cControls[m_nCurrentControl].paint(g);
                break;
            }
            case 0: {
                if (m_strQuickScore == null) break;
                if (m_lQuickScoreHideTime <= m_lThisTickCount) {
                    m_strQuickScore = null;
                    break;
                }
                Game.drawStringBmp(g, m_strQuickScore, m_nQuickScoreX, m_nQuickScoreY, 3, m_imgScoreFont, m_strScoreFont);
                break;
            }
            case 4: {
                m_bBonus = false;
                GameProcess.startGame(0);
                break;
            }
            case 1: {
                m_bBonus = false;
                if (--m_nLives <= 0) {
                    GameProcess.startGame(8);
                    break;
                }
                GameProcess.startGame(0);
                break;
            }
            case 2: {
                if (m_lLevelWaitEnd == 0L) {
                    m_lLevelWaitEnd = m_lThisTickCount + 1000L;
                }
                if (m_lLevelWaitEnd <= m_lThisTickCount) {
                    m_bBonus = false;
                    if (--m_nLives <= 0) {
                        GameProcess.startGame(8);
                        break;
                    }
                    GameProcess.startGame(0);
                    break;
                }
                if (m_imgBlink == null) break;
                if (m_bBlink) {
                    l_shX = (short)(m_nState == 1 ? GameProcess.m_swimCat.m_sprite.m_nX + (GameProcess.m_swimCat.m_sprite.m_nFrW >> 1) : GameProcess.m_cat.m_sprite.m_nX + (GameProcess.m_cat.m_sprite.m_nFrW >> 1));
                    l_shY = (short)(m_nState == 1 ? GameProcess.m_swimCat.m_sprite.m_nY + (GameProcess.m_swimCat.m_sprite.m_nFrH >> 1) : GameProcess.m_cat.m_sprite.m_nY + (GameProcess.m_cat.m_sprite.m_nFrH >> 1));
                    m_imgBlink.paint(g, m_nBlinkImageFrame, l_shX - (GameProcess.m_imgBlink.m_nFrameWidth >> 1), l_shY - (GameProcess.m_imgBlink.m_nFrameHeight >> 1));
                }
                if (m_lNextBlink > m_lThisTickCount) break;
                m_lNextBlink = m_lThisTickCount + 100L;
                m_bBlink = !m_bBlink;
                break;
            }
            case 3: {
                if (m_lLevelWaitEnd == 0L) {
                    m_nScoreY = 176;
                    m_lLevelWaitEnd = m_lThisTickCount + 3000L;
                }
                if (m_lLevelWaitEnd <= m_lThisTickCount) {
                    m_bBonus = m_nState != 4;
                    GameProcess.startGame(0);
                    break;
                }
                if (m_nScoreY > 44) {
                    m_nScoreY -= 10;
                }
                Game.drawStringBmp(g, m_strScore, 66, m_nScoreY, 1, m_imgScoreFont, m_strScoreFont);
                break;
            }
            default: {
                if (m_nCurrentLevelState < 5) break;
                GameProcess.startGame(m_nCurrentLevelState - 5);
                GameProcess.startScore();
            }
        }
    }

    static void startScore() {
        m_lScoreStart = m_lThisTickCount;
    }

    static void endLevel(boolean success) {
        if (success) {
            m_lLevelWaitEnd = 0L;
            m_nCurrentLevelState = 3;
            int score = (int)(500L - (m_lThisTickCount - m_lScoreStart) / 100L);
            if (score < 100) {
                score = 100;
            }
            m_strScore = "+" + score;
            m_nScore += score;
            GameProcess.playSound(3);
        } else {
            m_lLevelWaitEnd = 0L;
            m_nCurrentLevelState = 2;
            GameProcess.playSound(2);
        }
    }

    static void drawLoadingProgress(Graphics g) {
        int nProgress = m_nLoadingState * 124 / m_nIterationCount;
        g.setColor(0xFFFFFF);
        g.drawRect(2, 166, 127, 7);
        g.setColor(0xFFFC00);
        g.fillRect(4, 168, nProgress, 4);
    }

    static void loadIteration(Graphics g) {
        System.gc();
        try {
            Thread.currentThread();
            Thread.sleep(20L);
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            GameProcess.drawLoadingProgress(g);
            switch (m_nLoadingState) {
                case 0: {
                    try {
                        m_imgLogo = Image.createImage((String)"/logo.png");
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    Game.pakPreload("gr.pak");
                    Game.pakPreload("scn.pak");
                    Game.pakPreload("obj.pak");
                    break;
                }
                case 1: {
                    Game.pakPreload("gr0.pak");
                    break;
                }
                case 2: {
                    Image.preloadGeneral();
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    Image.preload(m_nLoadingState - 3);
                    break;
                }
                case 8: {
                    GameProcess.loadData();
                    GameProcess.load();
                    break;
                }
                case 9: {
                    m_imgLogo = null;
                    GameProcess.initSound();
                    GameProcess.loadStartGame(50);
                    GameProcess.resetSound();
                }
            }
        }
        catch (Exception ex) {
            m_imgLogo = null;
        }
        System.gc();
        try {
            Thread.currentThread();
            Thread.sleep(20L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ++m_nLoadingState;
    }

    static void loadData() throws Exception {
        int i;
        m_imgScoreFont = Image.get(80);
        m_imgSmallScoreFont = Image.get(81);
        Control.m_imgMark = Image.get(123);
        DataInputStream dis = Game.pakGetStream("obj.pak", 0);
        m_cat = new Monster(Image.get(dis.readShort()), dis.readShort(), dis.readShort());
        GameProcess.m_cat.m_sprite.defineCollisionRectangle(dis.readShort(), dis.readShort(), dis.readShort(), dis.readShort());
        GameProcess.m_cat.m_frSq = new int[dis.readShort()][];
        for (i = 0; i < GameProcess.m_cat.m_frSq.length; ++i) {
            GameProcess.m_cat.m_frSq[i] = Game.readInts(dis);
        }
        dis.close();
        GameProcess.m_cat.m_nState = 0;
        m_cat.setFrameSequence(0);
        GameProcess.m_cat.m_nRefresh = 65;
        Monster.m_imSoles = Image.get(3);
        dis = Game.pakGetStream("obj.pak", 7);
        m_broom = new Monster(Image.get(dis.readShort()), dis.readShort(), dis.readShort());
        GameProcess.m_broom.m_sprite.defineCollisionRectangle(dis.readShort(), dis.readShort(), dis.readShort(), dis.readShort());
        GameProcess.m_broom.m_frSq = new int[dis.readShort()][];
        for (i = 0; i < GameProcess.m_broom.m_frSq.length; ++i) {
            GameProcess.m_broom.m_frSq[i] = Game.readInts(dis);
        }
        dis.close();
        dis = Game.pakGetStream("obj.pak", 10);
        m_dog = new Sprite(Image.get(dis.readShort()), dis.readShort(), dis.readShort());
        m_dog.setFrameSequence(Game.readInts(dis));
        dis.close();
        dis = Game.pakGetStream("obj.pak", 12);
        m_dust = new Sprite(Image.get(dis.readShort()), dis.readShort(), dis.readShort());
        m_dust.setFrameSequence(Game.readInts(dis));
        dis.close();
        dis = null;
        System.gc();
        Thread.currentThread();
        Thread.sleep(20L);
        i = Image.m_shImageID.length;
        while (--i >= 0 && 124 != Image.m_shImageID[i]) {
        }
        if (i >= 0) {
            m_imgLoading = Image.m_imImages[i];
        }
    }

    static void load() {
        m_sHiScores = new String[5];
        m_nHiScores = new int[5];
        try {
            DataInputStream dis = Game.rsGetStream(CONFIG_NAME);
            m_bSound = dis.readBoolean();
            m_bMusic = dis.readBoolean();
            m_sHiScores = new String[5];
            m_nHiScores = new int[5];
            for (int i = 0; i < 5; ++i) {
                GameProcess.m_sHiScores[i] = dis.readUTF();
                if (m_sHiScores[i].length() == 0) {
                    GameProcess.m_sHiScores[i] = null;
                }
                GameProcess.m_nHiScores[i] = dis.readInt();
            }
        }
        catch (Exception ex) {
            m_bSound = false;
            m_bMusic = true;
        }
    }

    static void save() {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            dos.writeBoolean(m_bSound);
            dos.writeBoolean(m_bMusic);
            for (int i = 0; i < 5; ++i) {
                if (m_sHiScores[i] == null) {
                    dos.writeUTF("");
                } else {
                    dos.writeUTF(m_sHiScores[i]);
                }
                dos.writeInt(m_nHiScores[i]);
            }
            Game.rsSave(CONFIG_NAME, baos);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static void stopGame() {
        m_nState = 50;
        m_nCurrentControl = 0;
    }

    static void loadScene(short shId) throws Exception, Throwable {
        if (m_scene != null) {
            m_scene.dispose();
        }
        m_scene = new Scene();
        DataInputStream dis = Game.pakGetStream("scn.pak", shId);
        m_scene.load(dis);
        dis.close();
        dis = null;
    }

    static void startGame(int nGame) {
        m_nState = 200;
        m_nStartingGame = nGame;
        m_bDrawLoadingSprite = nGame != 50;
    }

    static void loadStartGame(int nGame) {
        GameProcess.freezeTime(true);
        m_nState = 100;
        try {
            m_nCurrentLevelState = 0;
            m_nBlinkImageFrame = 0;
            if (nGame != m_nLastGame) {
                m_imgKill = null;
                m_imgBonk = null;
                m_imgBlink = null;
                m_strQuickScore = null;
                if (m_swimCat != null) {
                    m_swimCat.dispose();
                    m_swimCat = null;
                }
                Game.disposeArray(m_fish, 2);
                m_fish = null;
                Game.disposeArray(m_elFish, 2);
                m_elFish = null;
                if (m_scene != null) {
                    m_scene.dispose();
                    m_scene = null;
                }
                m_nKillerState = null;
                m_lKillerStateChange = null;
                System.gc();
                Thread.currentThread();
                Thread.sleep(20L);
                if (m_cControls != null) {
                    for (l_shPtr = 0; l_shPtr < 8; l_shPtr = (short)(l_shPtr + 1)) {
                        if (m_cControls[l_shPtr] == null || l_shPtr == 6) continue;
                        m_cControls[l_shPtr].dispose();
                        GameProcess.m_cControls[GameProcess.l_shPtr] = null;
                    }
                }
                m_fishScore = null;
                Game.disposeArray(m_mcat, 2);
                m_nBonusLevY = null;
                System.gc();
                Thread.currentThread();
                Thread.sleep(20L);
                l_shPtr = (short)m_nState;
                if (nGame == -1) {
                    m_bBonus = false;
                    m_nLives = 3;
                    m_nScore = 0;
                    nGame = 0;
                }
                if (nGame != 50) {
                    GameProcess.loadScene((short)nGame);
                } else {
                    GameProcess.loadScene((short)8);
                }
                System.gc();
            }
            if (nGame >= 0 && nGame <= 7) {
                if (nGame == 0 || nGame == 1 || nGame == 4) {
                    Monster.soles_reset((short)177);
                } else {
                    Monster.soles_reset((short)GameProcess.m_scene.m_nBottom);
                }
                GameProcess.m_cat.m_sprite.setPosition(GameProcess.m_scene.m_nLeft, GameProcess.m_scene.m_nBottom - GameProcess.m_cat.m_sprite.m_nFrH);
                m_cat.setState(-1, 0);
                m_cat.setFrameSequence(0);
                if (nGame != 0 && nGame != 1 && nGame != 4) {
                    GameProcess.m_broom.m_sprite.setPosition(GameProcess.m_scene.m_nRight - GameProcess.m_broom.m_sprite.m_nFrW, GameProcess.m_scene.m_nBottom - GameProcess.m_broom.m_sprite.m_nFrH);
                    m_broom.setState(-1, 3);
                    m_broom.setFrameSequence(0);
                    m_imgBonk = Image.get(801);
                }
                if (nGame != 1 && nGame != 4) {
                    m_dog.setPosition(132, GameProcess.m_scene.m_nBottom - GameProcess.m_dog.m_nFrH);
                    m_dust.setPosition(132, GameProcess.m_scene.m_nBottom - GameProcess.m_dust.m_nFrH);
                    m_nDustVx = 0;
                    m_lDogRespawn = m_lThisTickCount + (long)DOG_WAIT[m_nComplication];
                }
                m_nKillerState = null;
                switch (nGame) {
                    case 0: {
                        m_imgKill = Image.get(801);
                        m_nKillerTopPos = GameProcess.m_scene.m_params[16];
                        m_nKillerBottomPos = GameProcess.m_scene.m_params[17];
                        GameProcess.m_scene.m_params[16] = (short)m_nKillerBottomPos;
                        GameProcess.m_scene.m_params[18] = 1;
                        GameProcess.m_scene.m_params[19] = 1;
                        m_lKillerStateChange = new long[2];
                        m_nKillerState = new int[2];
                        for (l_shPtr = 0; l_shPtr < 2; l_shPtr = (short)(l_shPtr + 1)) {
                            GameProcess.m_lKillerStateChange[GameProcess.l_shPtr] = m_lThisTickCount + (long)Game.random(DOMIK_KILLER_WAIT[m_nComplication]);
                            GameProcess.m_nKillerState[GameProcess.l_shPtr] = 0;
                        }
                        l_shPtr = 0;
                        while (l_shCounter < GameProcess.m_scene.m_shCatchCount) {
                            short s = l_shPtr;
                            l_shPtr = (short)(s + 1);
                            l_shX = GameProcess.m_scene.m_catch[s];
                            short s2 = l_shPtr;
                            l_shPtr = (short)(s2 + 1);
                            l_shY = GameProcess.m_scene.m_catch[s2];
                            short s3 = l_shPtr;
                            l_shPtr = (short)(s3 + 1);
                            l_shW = GameProcess.m_scene.m_catch[s3];
                            short s4 = l_shPtr;
                            l_shPtr = (short)(s4 + 1);
                            l_shH = GameProcess.m_scene.m_catch[s4];
                            short s5 = l_shPtr;
                            l_shPtr = (short)(s5 + 1);
                            l_shInd = GameProcess.m_scene.m_catch[s5];
                            if (l_shInd >= 10 && l_shInd < 18) {
                                GameProcess.m_nWinCenterX[GameProcess.l_shInd - 10] = l_shX + (l_shW >> 1) - (GameProcess.m_scene.m_params[23] >> 1);
                                GameProcess.m_nWinCenterY[GameProcess.l_shInd - 10] = l_shY + (l_shH >> 1) - (GameProcess.m_scene.m_params[23] >> 1);
                            }
                            l_shCounter = (short)(l_shCounter + 1);
                        }
                        GameProcess.m_scene.m_params[25] = 0;
                        m_nState = nGame;
                        GameProcess.setScore(m_nScore);
                        GameProcess.setLives(m_nLives);
                        break;
                    }
                    case 2: {
                        m_nSaratovMouseCount = 0;
                        m_imgKill = Image.get(802);
                        m_nKillerTopPos = GameProcess.m_scene.m_params[7];
                        m_nKillerBottomPos = GameProcess.m_scene.m_params[8];
                        m_lKillerStateChange = new long[10];
                        m_nKillerState = new int[10];
                        for (l_shPtr = (short)7; l_shPtr < 10; l_shPtr = (short)(l_shPtr + 1)) {
                            GameProcess.m_lKillerStateChange[GameProcess.l_shPtr] = m_lThisTickCount + (long)Game.random(SARATOV_SPIDER_WAIT[m_nComplication]);
                            GameProcess.m_nKillerState[GameProcess.l_shPtr] = 0;
                            GameProcess.m_scene.m_params[GameProcess.l_shPtr] = (short)m_nKillerTopPos;
                        }
                        for (l_shPtr = 0; l_shPtr < 7; l_shPtr = (short)(l_shPtr + 1)) {
                            GameProcess.m_lKillerStateChange[GameProcess.l_shPtr] = m_lThisTickCount + (long)Game.random(SARATOV_MOUSE_WAIT[m_nComplication]);
                            GameProcess.m_nKillerState[GameProcess.l_shPtr] = 0;
                            GameProcess.m_scene.m_params[GameProcess.l_shPtr] = 0;
                        }
                        break;
                    }
                    case 1: {
                        m_imgKill = Image.get(10803);
                        DataInputStream dis = Game.pakGetStream("obj.pak", 1);
                        m_swimCat = new Monster(Image.get(dis.readShort()), dis.readShort(), dis.readShort());
                        GameProcess.m_swimCat.m_sprite.defineCollisionRectangle(dis.readShort(), dis.readShort(), dis.readShort(), dis.readShort());
                        GameProcess.m_swimCat.m_frSq = new int[dis.readShort()][];
                        for (l_shPtr = 0; l_shPtr < GameProcess.m_swimCat.m_frSq.length; l_shPtr = (short)(l_shPtr + 1)) {
                            GameProcess.m_swimCat.m_frSq[GameProcess.l_shPtr] = Game.readInts(dis);
                        }
                        dis.close();
                        GameProcess.m_swimCat.m_nState = 0;
                        m_swimCat.setFrameSequence(0);
                        GameProcess.m_swimCat.m_nRefresh = 70;
                        GameProcess.m_swimCat.m_sprite.setPosition((GameProcess.m_scene.m_nLeft + GameProcess.m_scene.m_nRight >> 1) - GameProcess.m_swimCat.m_sprite.m_nFrW, GameProcess.m_scene.m_nTop);
                        GameProcess.m_swimCat.m_nState = 0;
                        m_swimCat.setFrameSequence(0);
                        dis = Game.pakGetStream("obj.pak", 601);
                        m_nFishCount = dis.readShort();
                        m_fish = new Monster[m_nFishCount];
                        m_elFish = new Monster[m_nFishCount];
                        m_fishScore = new int[m_nFishCount];
                        Image img = null;
                        for (l_shPtr = 0; l_shPtr < m_nFishCount; l_shPtr = (short)(l_shPtr + 1)) {
                            if (l_shPtr == 0) {
                                img = Image.get(dis.readShort());
                                GameProcess.m_elFish[GameProcess.l_shPtr] = new Monster(img, dis.readShort(), dis.readShort());
                                GameProcess.m_elFish[GameProcess.l_shPtr].m_frSq = new int[2][];
                                GameProcess.m_elFish[GameProcess.l_shPtr].m_frSq[0] = Game.readInts(dis);
                                GameProcess.m_elFish[GameProcess.l_shPtr].m_frSq[1] = Game.readInts(dis);
                                dis.readShort();
                                l_shInd = dis.readShort();
                                continue;
                            }
                            GameProcess.m_elFish[GameProcess.l_shPtr] = new Monster(img, (short)GameProcess.m_elFish[0].m_sprite.m_nFrW, (short)GameProcess.m_elFish[0].m_sprite.m_nFrH);
                            GameProcess.m_elFish[GameProcess.l_shPtr].m_frSq = GameProcess.m_elFish[0].m_frSq;
                        }
                        dis.close();
                        l_shPtr = 0;
                        int shFishScore = 0;
                        while (l_shPtr < m_nFishCount && l_shInd != 0) {
                            dis = Game.pakGetStream("obj.pak", l_shInd);
                            Monster fish = null;
                            l_shCounter = dis.readShort();
                            while ((l_shCounter = (short)(l_shCounter - 1)) >= 0 && l_shPtr < m_nFishCount) {
                                if (fish == null) {
                                    img = Image.get(dis.readShort());
                                    fish = new Monster(img, dis.readShort(), dis.readShort());
                                    fish.m_frSq = new int[2][];
                                    fish.m_frSq[0] = Game.readInts(dis);
                                    fish.m_frSq[1] = Game.readInts(dis);
                                    short s = dis.readShort();
                                    shFishScore = s;
                                    GameProcess.m_fishScore[GameProcess.l_shPtr] = s;
                                    l_shInd = dis.readShort();
                                    GameProcess.m_fish[GameProcess.l_shPtr] = fish;
                                } else {
                                    GameProcess.m_fish[GameProcess.l_shPtr] = new Monster(img, (short)fish.m_sprite.m_nFrW, (short)fish.m_sprite.m_nFrH);
                                    GameProcess.m_fish[GameProcess.l_shPtr].m_frSq = fish.m_frSq;
                                    GameProcess.m_fishScore[GameProcess.l_shPtr] = shFishScore;
                                }
                                l_shPtr = (short)(l_shPtr + 1);
                            }
                        }
                        for (l_shPtr = 0; l_shPtr < m_nFishCount; l_shPtr = (short)(l_shPtr + 1)) {
                            if (m_fish[l_shPtr] != null) {
                                l_shW = (short)(GameProcess.m_scene.m_nRight - GameProcess.m_scene.m_nLeft - GameProcess.m_fish[GameProcess.l_shPtr].m_sprite.m_nFrW);
                                l_shH = (short)(GameProcess.m_scene.m_nBottom - GameProcess.m_scene.m_nTop - GameProcess.m_fish[GameProcess.l_shPtr].m_sprite.m_nFrH - 20);
                                GameProcess.m_fish[GameProcess.l_shPtr].m_sprite.m_nX = Game.random(l_shW) + GameProcess.m_scene.m_nLeft;
                                GameProcess.m_fish[GameProcess.l_shPtr].m_sprite.m_nY = Game.random(l_shH) + GameProcess.m_scene.m_nTop + 20;
                                GameProcess.m_fish[GameProcess.l_shPtr].m_nState = -1;
                                continue;
                            }
                            l_shW = (short)(GameProcess.m_scene.m_nRight - GameProcess.m_scene.m_nLeft - GameProcess.m_elFish[GameProcess.l_shPtr].m_sprite.m_nFrW);
                            l_shH = (short)(GameProcess.m_scene.m_nBottom - GameProcess.m_scene.m_nTop - GameProcess.m_elFish[GameProcess.l_shPtr].m_sprite.m_nFrH - 20 - GameProcess.m_swimCat.m_sprite.m_nFrH);
                            GameProcess.m_elFish[GameProcess.l_shPtr].m_sprite.m_nX = Game.random(l_shW) + GameProcess.m_scene.m_nLeft;
                            GameProcess.m_elFish[GameProcess.l_shPtr].m_sprite.m_nY = Game.random(l_shH) + GameProcess.m_scene.m_nTop + 20 + GameProcess.m_swimCat.m_sprite.m_nFrH;
                            GameProcess.m_elFish[GameProcess.l_shPtr].m_nState = -1;
                        }
                        m_nKillerTopPos = GameProcess.m_scene.m_params[0];
                        m_nKillerBottomPos = GameProcess.m_scene.m_params[1];
                        m_nKillerPos = 0;
                        break;
                    }
                    case 7: {
                        m_imgKill = Image.get(802);
                        m_nKillerState = new int[12];
                        for (l_shPtr = 0; l_shPtr < 4; l_shPtr = (short)(l_shPtr + 1)) {
                            GameProcess.m_nKillerState[GameProcess.l_shPtr] = 2;
                            GameProcess.m_nKillerState[GameProcess.l_shPtr + 4] = 0;
                            GameProcess.m_nKillerState[GameProcess.l_shPtr + 8] = GameProcess.m_scene.m_params[0 + l_shPtr];
                        }
                        m_nSpiderKomodLeft = GameProcess.m_scene.m_params[33];
                        m_nSpiderKomodTop = GameProcess.m_scene.m_params[34];
                        m_nSpiderKomodWidth = GameProcess.m_scene.m_params[35];
                        m_nSpiderKomodHeight = GameProcess.m_scene.m_params[36];
                        m_nSpiderKomodCenterY = GameProcess.m_scene.m_params[37];
                        m_nSpiderTopW = m_nSpiderSideW = m_nSpiderKomodLeft - GameProcess.m_scene.m_params[26];
                        m_nSpiderSideH = m_nSpiderKomodTop - GameProcess.m_scene.m_params[27];
                        m_nSpiderTopH = m_nSpiderKomodCenterY - GameProcess.m_scene.m_params[28];
                        m_nSpiderTopH2 = m_nSpiderTopH >> 2;
                        GameProcess.m_scene.m_params[26] = GameProcess.m_scene.m_params[1];
                        GameProcess.m_scene.m_params[31] = 1;
                        GameProcess.m_scene.m_params[32] = 0;
                        m_bSpiderSide = true;
                        break;
                    }
                    case 3: {
                        m_nKillerState = new int[5];
                        GameProcess.m_nKillerState[0] = 2;
                        GameProcess.m_nKillerState[1] = 0;
                        GameProcess.m_nKillerState[2] = GameProcess.m_scene.m_params[0];
                        GameProcess.m_nKillerState[3] = 0;
                        GameProcess.m_nKillerState[4] = 0;
                        m_nKillerTopPos = GameProcess.m_scene.m_params[11] - GameProcess.m_scene.m_params[1];
                        m_nKillerBottomPos = GameProcess.m_scene.m_params[10] - GameProcess.m_scene.m_params[0];
                        l_shW = (short)(GameProcess.m_scene.m_params[12] >> 1);
                        l_shH = GameProcess.m_scene.m_params[13];
                        for (l_shPtr = 0; l_shPtr < 4; l_shPtr = (short)(l_shPtr + 1)) {
                            int n = 14 + l_shPtr;
                            GameProcess.m_scene.m_params[n] = (short)(GameProcess.m_scene.m_params[n] - l_shW);
                            int n2 = 18 + l_shPtr;
                            GameProcess.m_scene.m_params[n2] = (short)(GameProcess.m_scene.m_params[n2] - l_shH);
                        }
                        break;
                    }
                    case 5: {
                        break;
                    }
                    case 4: {
                        m_nBonusHearts = GameProcess.m_scene.m_shFloorCount;
                        l_shPtr = 0;
                        l_shInd = (short)-100;
                        m_nBonusLevels = 0;
                        m_nBonusLevY = new int[10];
                        for (l_shCounter = 0; l_shCounter < GameProcess.m_scene.m_shFloorCount; l_shCounter = (short)(l_shCounter + 1)) {
                            short s = l_shPtr = (short)(l_shPtr + 1);
                            l_shPtr = (short)(s + 1);
                            l_shY = GameProcess.m_scene.m_floor[s];
                            l_shPtr = (short)(l_shPtr + 3);
                            if (l_shInd != l_shY) {
                                GameProcess.m_nBonusLevY[GameProcess.m_nBonusLevels++] = l_shY;
                            }
                            l_shInd = l_shY;
                        }
                        m_nBonusHeartsPerLevel = m_nBonusHearts / m_nBonusLevels;
                        for (l_shPtr = 0; l_shPtr < m_nBonusHearts; l_shPtr = (short)(l_shPtr + 1)) {
                            GameProcess.m_scene.m_params[GameProcess.l_shPtr] = 1;
                            GameProcess.m_scene.m_params[GameProcess.l_shPtr + GameProcess.m_nBonusHearts] = 0;
                        }
                        l_shPtr = (short)(m_nBonusHearts >> 2);
                        while ((l_shPtr = (short)(l_shPtr - 1)) >= 0) {
                            l_shInd = (short)(Game.random(m_nBonusHearts - 2) + 2);
                            GameProcess.m_scene.m_params[GameProcess.l_shInd] = 0;
                            GameProcess.m_scene.m_params[GameProcess.l_shInd + GameProcess.m_nBonusHearts] = 1;
                        }
                        m_mcat = new Monster[m_nBonusLevels - 2];
                        DataInputStream dis = Game.pakGetStream("obj.pak", 113);
                        GameProcess.m_mcat[0] = new Monster(Image.get(dis.readShort()), dis.readShort(), dis.readShort());
                        l_shX = dis.readShort();
                        l_shY = dis.readShort();
                        l_shW = dis.readShort();
                        l_shH = dis.readShort();
                        GameProcess.m_mcat[0].m_sprite.defineCollisionRectangle(l_shX, l_shY, l_shW, l_shH);
                        GameProcess.m_mcat[0].m_frSq = new int[dis.readShort()][];
                        for (l_shPtr = 0; l_shPtr < GameProcess.m_mcat[0].m_frSq.length; l_shPtr = (short)(l_shPtr + 1)) {
                            GameProcess.m_mcat[0].m_frSq[GameProcess.l_shPtr] = Game.readInts(dis);
                        }
                        dis.close();
                        GameProcess.m_mcat[0].m_nState = 0;
                        m_mcat[0].setFrameSequence(0);
                        GameProcess.m_mcat[0].m_nRefresh = 70;
                        GameProcess.m_mcat[0].m_sprite.m_nY = m_nBonusLevY[1] - GameProcess.m_mcat[0].m_sprite.m_nFrH;
                        for (l_shPtr = 1; l_shPtr < m_mcat.length; l_shPtr = (short)(l_shPtr + 1)) {
                            GameProcess.m_mcat[GameProcess.l_shPtr] = new Monster(GameProcess.m_mcat[0].m_sprite.m_image, (short)GameProcess.m_mcat[0].m_sprite.m_nFrW, (short)GameProcess.m_mcat[0].m_sprite.m_nFrH);
                            GameProcess.m_mcat[GameProcess.l_shPtr].m_sprite.defineCollisionRectangle(l_shX, l_shY, l_shW, l_shH);
                            GameProcess.m_mcat[GameProcess.l_shPtr].m_frSq = GameProcess.m_mcat[0].m_frSq;
                            GameProcess.m_mcat[GameProcess.l_shPtr].m_nState = 0;
                            m_mcat[l_shPtr].setFrameSequence(0);
                            GameProcess.m_mcat[GameProcess.l_shPtr].m_nRefresh = GameProcess.m_mcat[0].m_nRefresh;
                            GameProcess.m_mcat[GameProcess.l_shPtr].m_sprite.m_nY = m_nBonusLevY[l_shPtr + 1] - GameProcess.m_mcat[GameProcess.l_shPtr].m_sprite.m_nFrH;
                        }
                        dis = Game.pakGetStream("obj.pak", 112);
                        m_kitty = new Monster(Image.get(dis.readShort()), dis.readShort(), dis.readShort());
                        GameProcess.m_kitty.m_sprite.defineCollisionRectangle(dis.readShort(), dis.readShort(), dis.readShort(), dis.readShort());
                        GameProcess.m_kitty.m_frSq = new int[dis.readShort()][];
                        for (l_shPtr = 0; l_shPtr < GameProcess.m_kitty.m_frSq.length; l_shPtr = (short)(l_shPtr + 1)) {
                            GameProcess.m_kitty.m_frSq[GameProcess.l_shPtr] = Game.readInts(dis);
                        }
                        dis.close();
                        dis = null;
                        GameProcess.m_kitty.m_nState = 0;
                        m_kitty.setFrameSequence(0);
                        GameProcess.m_kitty.m_nRefresh = 70;
                        GameProcess.m_kitty.m_sprite.m_nY = m_nBonusLevY[m_nBonusLevels - 1] - GameProcess.m_kitty.m_sprite.m_nFrH;
                        GameProcess.m_cat.m_sprite.setPosition(GameProcess.m_scene.m_nLeft, m_nBonusLevY[0] - GameProcess.m_cat.m_sprite.m_nFrH);
                    }
                }
            } else {
                switch (nGame) {
                    case 50: {
                        m_nState = 100;
                        DataInputStream dis = new DataInputStream(((Object)((Object)Game.m_game)).getClass().getResourceAsStream("/mn.bin"));
                        int nBackgrColor = dis.readInt();
                        int nSelectedColor = dis.readInt();
                        int nItemColor = dis.readInt();
                        int nBorderColor = dis.readInt();
                        Font font = Font.getFont((int)dis.readInt(), (int)dis.readInt(), (int)dis.readInt());
                        m_cControls = new Control[8];
                        l_shH = GameProcess.m_scene.m_params[0];
                        String cap = null;
                        String inputCap = null;
                        int style = 0;
                        for (int nCurrentControl = 0; nCurrentControl < 7; ++nCurrentControl) {
                            if (nCurrentControl == 6) {
                                cap = dis.readUTF();
                            }
                            String[] sMnuMain = Game.readStrings(dis);
                            if (nCurrentControl == 3) {
                                inputCap = sMnuMain[0];
                                m_sEmptyHiScore = sMnuMain[1];
                                sMnuMain = new String[5];
                                for (l_shPtr = 0; l_shPtr < 5; l_shPtr = (short)(l_shPtr + 1)) {
                                    if (m_sHiScores[l_shPtr] == null || m_sHiScores[l_shPtr].length() == 0) {
                                        GameProcess.m_nHiScores[GameProcess.l_shPtr] = 0;
                                        sMnuMain[GameProcess.l_shPtr] = m_sEmptyHiScore;
                                        continue;
                                    }
                                    sMnuMain[GameProcess.l_shPtr] = m_sHiScores[l_shPtr] + ": " + m_nHiScores[l_shPtr];
                                }
                            }
                            style = dis.readInt();
                            GameProcess.m_cControls[nCurrentControl] = new Control(dis.readInt(), sMnuMain.length, nCurrentControl == 0 ? "" : (nCurrentControl == 6 ? cap : GameProcess.m_cControls[0].m_sItems[nCurrentControl - 1]), style, font, nBackgrColor, nItemColor, nBorderColor, nSelectedColor);
                            GameProcess.m_cControls[nCurrentControl].m_sItems = sMnuMain;
                            GameProcess.m_cControls[nCurrentControl].m_nSize = sMnuMain.length;
                            GameProcess.m_cControls[nCurrentControl].m_nX = 0;
                            GameProcess.m_cControls[nCurrentControl].m_nY = l_shH;
                            m_cControls[nCurrentControl].calcSizes();
                            GameProcess.m_cControls[nCurrentControl].m_commandListener = Game.m_gameProcess;
                            if (GameProcess.m_cControls[nCurrentControl].m_nHeight > 176 - l_shH) {
                                GameProcess.m_cControls[nCurrentControl].m_nHeight = 176 - l_shH;
                            }
                            GameProcess.m_cControls[0].m_nWidth = 132;
                        }
                        GameProcess.m_cControls[7] = new Control(3, 1, inputCap, style, font, nBackgrColor, nItemColor, nBorderColor, nSelectedColor);
                        m_cControls[7].append("");
                        GameProcess.m_cControls[7].m_sPossibleChars = new String[]{" 0", ".,?!1", "abc2", "def3", "ghi4", "jkl5", "mno6", "pqrs7", "tuv8", "wxyz9"};
                        m_cControls[7].calcSizes();
                        GameProcess.m_cControls[7].m_sItems[0] = "";
                        GameProcess.m_cControls[7].m_nWidth = 124;
                        GameProcess.m_cControls[7].m_commandListener = Game.m_gameProcess;
                        m_nCurrentControl = 0;
                        if (m_sSelect == null) {
                            try {
                                String[] sButtons = Game.readStrings(dis);
                                m_sSelect = sButtons[0];
                                m_sBack = sButtons[0];
                            }
                            catch (Exception ex) {
                                m_sSelect = "Select";
                                m_sBack = "Back";
                            }
                        }
                        GameProcess.m_cControls[2].m_bChecks[0] = m_bMusic;
                        GameProcess.m_cControls[2].m_bChecks[1] = m_bSound;
                        dis.close();
                        dis = null;
                        break;
                    }
                    case 8: {
                        GameProcess.startGame(50);
                        return;
                    }
                }
            }
            m_nLastGame = m_nState = nGame;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        GameProcess.freezeTime(false);
    }

    static void process_bonusScene() {
        if (m_nCurrentLevelState != 0) {
            return;
        }
        if (GameProcess.m_cat.m_sprite.m_nY > 176) {
            m_bBonus = false;
            GameProcess.startGame(0);
            return;
        }
        l_shPtr = (short)m_mcat.length;
        while ((l_shPtr = (short)(l_shPtr - 1)) >= 0) {
            if (!m_mcat[l_shPtr].mcat_process()) continue;
            ++GameProcess.m_cat.m_sprite.m_nY;
        }
        if (m_kitty.mcat_process()) {
            m_cat.setFrameSequence(m_cat.getState(255) < 6 ? 7 : 15);
            m_cat.setState(255, 5);
            GameProcess.m_cat.m_sprite.m_nY = m_nBonusLevY[m_nBonusLevels - 1] - GameProcess.m_cat.m_sprite.m_nFrH;
            m_strScore = m_nScore + "x2";
            m_nScore <<= 1;
            m_lLevelWaitEnd = 0L;
            ++m_nLives;
            m_nCurrentLevelState = 3;
            GameProcess.playSound(3);
            return;
        }
        short arrowSize = GameProcess.m_scene.m_params[(m_nBonusHearts << 1) + 2];
        if (GameProcess.m_scene.m_params[(m_nBonusHearts << 1) + 1] > 176 || GameProcess.m_scene.m_params[m_nBonusHearts << 1] > 132) {
            l_shX = (short)Game.random(308);
            if (l_shX < 132) {
                GameProcess.m_scene.m_params[(GameProcess.m_nBonusHearts << 1) + 1] = -arrowSize;
                GameProcess.m_scene.m_params[GameProcess.m_nBonusHearts << 1] = l_shX;
            } else {
                GameProcess.m_scene.m_params[(GameProcess.m_nBonusHearts << 1) + 1] = (short)(l_shX - 132 - arrowSize);
                GameProcess.m_scene.m_params[GameProcess.m_nBonusHearts << 1] = 0;
            }
            return;
        }
        int n = (m_nBonusHearts << 1) + 1;
        GameProcess.m_scene.m_params[n] = (short)(GameProcess.m_scene.m_params[n] + BONUS_ARROW_V[m_nComplication]);
        int n2 = m_nBonusHearts << 1;
        GameProcess.m_scene.m_params[n2] = (short)(GameProcess.m_scene.m_params[n2] + BONUS_ARROW_V[m_nComplication]);
        l_shPtr = 0;
        for (l_shCounter = 0; l_shCounter < GameProcess.m_scene.m_shFloorCount; l_shCounter = (short)(l_shCounter + 1)) {
            short s = l_shPtr;
            l_shPtr = (short)(s + 1);
            l_shX = GameProcess.m_scene.m_floor[s];
            short s2 = l_shPtr;
            l_shPtr = (short)(s2 + 1);
            l_shY = GameProcess.m_scene.m_floor[s2];
            short s3 = l_shPtr;
            l_shPtr = (short)(s3 + 1);
            l_shW = GameProcess.m_scene.m_floor[s3];
            l_shPtr = (short)(l_shPtr + 2);
            l_shInd = GameProcess.m_scene.m_params[m_nBonusHearts << 1];
            l_shH = GameProcess.m_scene.m_params[(m_nBonusHearts << 1) + 1];
            if (!Game.intersectRectWH(l_shX, l_shY, l_shW, 1, l_shInd, l_shH, arrowSize, BONUS_ARROW_V[m_nComplication])) continue;
            GameProcess.m_scene.m_params[GameProcess.l_shCounter] = (short)(1 - GameProcess.m_scene.m_params[l_shCounter]);
            GameProcess.m_scene.m_params[GameProcess.l_shCounter + GameProcess.m_nBonusHearts] = (short)(1 - GameProcess.m_scene.m_params[l_shCounter + m_nBonusHearts]);
        }
    }

    public static boolean acceptCatch(short id) {
        switch (m_nState) {
            case 0: {
                id = (short)(id - 10);
                return id < 0 || id >= 8;
            }
            case 2: {
                id = (short)(id - 10);
                if (id >= 0 && id < 7 && m_nKillerState[0 + id] != 0 && GameProcess.m_cat.m_sprite.collidesWith((l_shX = GameProcess.m_scene.m_params[15 + id]) - 12, (l_shY = GameProcess.m_scene.m_params[22 + id]) - 12, 24, 24)) {
                    GameProcess.m_nKillerState[id + 0] = 0;
                    GameProcess.m_lKillerStateChange[id + 0] = m_lThisTickCount + (long)Game.chooseNumber(SARATOV_MOUSE_WAIT[m_nComplication], 2);
                    GameProcess.m_scene.m_params[id + 0] = 0;
                    ++m_nSaratovMouseCount;
                    GameProcess.playSound(4);
                }
                return true;
            }
        }
        return true;
    }

    public static boolean acceptFloor(short id) {
        switch (m_nState) {
            case 6: {
                if (id != 10) break;
                return false;
            }
        }
        return true;
    }

    static void process_houseScene() {
        if (m_nCurrentLevelState != 0) {
            return;
        }
        if (m_lNextSceneProcess > m_lThisTickCount) {
            return;
        }
        m_lNextSceneProcess = m_lThisTickCount + 56L;
        block0 : switch (m_nWinState) {
            case 0: {
                if (m_lNextWindowUpdate > m_lThisTickCount) break;
                m_nWindowIndex = Game.random(8);
                m_nWindowFrame = 0;
                GameProcess.m_scene.m_params[0 + GameProcess.m_nWindowIndex] = 1;
                GameProcess.m_scene.m_params[8 + GameProcess.m_nWindowIndex] = (short)(m_bBonus ? 4 + m_nWindowFrame : m_nWindowFrame);
                m_nWinState = 1;
                break;
            }
            case 1: {
                GameProcess.m_scene.m_params[8 + GameProcess.m_nWindowIndex] = (short)(m_bBonus ? 4 + m_nWindowFrame : ++m_nWindowFrame);
                if (m_nWindowFrame != 3) break;
                m_lNextWindowUpdate = m_lThisTickCount + (long)DOMIK_WINDOW_OPEN_TIME[m_nComplication];
                m_nWinState = 2;
                if (m_bBonus || GameProcess.m_scene.m_params[25] != 0) break;
                l_shX = GameProcess.m_scene.m_params[21] = (short)m_nWinCenterX[m_nWindowIndex];
                l_shY = GameProcess.m_scene.m_params[22] = (short)m_nWinCenterY[m_nWindowIndex];
                GameProcess.m_scene.m_params[25] = 1;
                GameProcess.m_scene.m_params[24] = (short)Game.random(2);
                m_nSapogVx = l_shX > GameProcess.m_cat.m_sprite.m_nX ? -1 : 1;
                m_nSapogVy = 1;
                break;
            }
            case 2: {
                if (m_lNextWindowUpdate <= m_lThisTickCount) {
                    m_nWinState = 3;
                    break;
                }
                l_shPtr = 0;
                for (l_shCounter = 0; l_shCounter < GameProcess.m_scene.m_shCatchCount; l_shCounter = (short)(l_shCounter + 1)) {
                    short s = l_shPtr;
                    l_shPtr = (short)(s + 1);
                    l_shX = GameProcess.m_scene.m_catch[s];
                    short s2 = l_shPtr;
                    l_shPtr = (short)(s2 + 1);
                    l_shY = GameProcess.m_scene.m_catch[s2];
                    short s3 = l_shPtr;
                    l_shPtr = (short)(s3 + 1);
                    l_shW = GameProcess.m_scene.m_catch[s3];
                    short s4 = l_shPtr;
                    l_shPtr = (short)(s4 + 1);
                    l_shH = GameProcess.m_scene.m_catch[s4];
                    short s5 = l_shPtr;
                    l_shPtr = (short)(s5 + 1);
                    l_shInd = GameProcess.m_scene.m_catch[s5];
                    if (l_shInd - 10 != m_nWindowIndex) continue;
                    if (!GameProcess.m_cat.m_sprite.collidesWith(l_shX, l_shY, l_shW, l_shH)) break block0;
                    if (m_bBonus) {
                        m_nCurrentLevelState = 9;
                        continue;
                    }
                    switch (Game.random(4)) {
                        case 0: {
                            m_nCurrentLevelState = 7;
                            return;
                        }
                        case 1: {
                            m_nCurrentLevelState = 12;
                            return;
                        }
                        case 2: {
                            m_nCurrentLevelState = 8;
                            return;
                        }
                        case 3: {
                            m_nCurrentLevelState = 11;
                            return;
                        }
                    }
                }
                break;
            }
            case 3: {
                if (--m_nWindowFrame < 0) {
                    m_lNextWindowUpdate = m_lThisTickCount + 100L;
                    m_nWinState = 0;
                    GameProcess.m_scene.m_params[0 + GameProcess.m_nWindowIndex] = 0;
                    break;
                }
                GameProcess.m_scene.m_params[8 + GameProcess.m_nWindowIndex] = (short)(m_bBonus ? 4 + m_nWindowFrame : m_nWindowFrame);
            }
        }
        if (GameProcess.m_scene.m_params[25] != 0) {
            GameProcess.m_scene.m_params[21] = (short)(GameProcess.m_scene.m_params[21] + m_nSapogVx);
            if (m_nFenceY < (GameProcess.m_scene.m_params[22] = (short)(GameProcess.m_scene.m_params[22] + ++m_nSapogVy))) {
                GameProcess.m_scene.m_params[25] = 0;
            } else if (GameProcess.m_cat.m_sprite.collidesWith(GameProcess.m_scene.m_params[21], GameProcess.m_scene.m_params[22], GameProcess.m_scene.m_params[23], GameProcess.m_scene.m_params[23])) {
                m_imgBlink = m_imgKill;
                GameProcess.endLevel(false);
                return;
            }
        }
        block19: for (l_shPtr = 0; l_shPtr < 2; l_shPtr = (short)(l_shPtr + 1)) {
            switch (m_nKillerState[l_shPtr]) {
                case 0: {
                    if (m_lKillerStateChange[l_shPtr] >= m_lThisTickCount) continue block19;
                    GameProcess.m_nKillerState[GameProcess.l_shPtr] = 1;
                    GameProcess.m_scene.m_params[18 + GameProcess.l_shPtr] = 0;
                    continue block19;
                }
                case 1: {
                    int n = 16 + l_shPtr;
                    GameProcess.m_scene.m_params[n] = (short)(GameProcess.m_scene.m_params[n] - 4);
                    if (GameProcess.m_scene.m_params[n] > m_nKillerTopPos) continue block19;
                    GameProcess.m_scene.m_params[16 + GameProcess.l_shPtr] = (short)m_nKillerTopPos;
                    GameProcess.m_nKillerState[GameProcess.l_shPtr] = 2;
                    GameProcess.m_lKillerStateChange[GameProcess.l_shPtr] = m_lThisTickCount + (long)Game.chooseNumber(DOMIK_KILLER_STAY[m_nComplication], 1);
                    continue block19;
                }
                case 2: {
                    if (m_lKillerStateChange[l_shPtr] >= m_lThisTickCount) continue block19;
                    GameProcess.m_nKillerState[GameProcess.l_shPtr] = 3;
                    continue block19;
                }
                case 3: {
                    int n = 16 + l_shPtr;
                    GameProcess.m_scene.m_params[n] = (short)(GameProcess.m_scene.m_params[n] + 4);
                    if (GameProcess.m_scene.m_params[n] < m_nKillerBottomPos) continue block19;
                    GameProcess.m_scene.m_params[16 + GameProcess.l_shPtr] = (short)m_nKillerBottomPos;
                    GameProcess.m_scene.m_params[18 + GameProcess.l_shPtr] = 1;
                    GameProcess.m_nKillerState[GameProcess.l_shPtr] = 0;
                    GameProcess.m_lKillerStateChange[GameProcess.l_shPtr] = m_lThisTickCount + (long)Game.chooseNumber(DOMIK_KILLER_WAIT[m_nComplication], 1);
                }
            }
        }
    }

    static void process_saratovScene() {
        int shStart;
        if (m_nCurrentLevelState != 0) {
            return;
        }
        for (l_shPtr = 0; l_shPtr < 5; l_shPtr = (short)(l_shPtr + 1)) {
            GameProcess.m_scene.m_params[10 + GameProcess.l_shPtr] = (short)(l_shPtr < m_nSaratovMouseCount ? 1 : 0);
        }
        l_shCounter = 0;
        for (l_shPtr = (short)7; l_shPtr < 10; l_shPtr = (short)(l_shPtr + 1)) {
            if (m_nKillerState[l_shPtr] == 0) continue;
            l_shCounter = (short)(l_shCounter + 1);
        }
        for (l_shPtr = (short)7; l_shPtr < 10; l_shPtr = (short)(l_shPtr + 1)) {
            switch (m_nKillerState[l_shPtr]) {
                case 0: {
                    if (m_lKillerStateChange[l_shPtr] >= m_lThisTickCount || l_shCounter > m_nComplication) break;
                    GameProcess.m_nKillerState[GameProcess.l_shPtr] = 1;
                    l_shCounter = (short)(l_shCounter + 1);
                    break;
                }
                case 1: {
                    short s = l_shPtr;
                    GameProcess.m_scene.m_params[s] = (short)(GameProcess.m_scene.m_params[s] + SARATOV_SPIDER_SPEED[m_nComplication]);
                    if (GameProcess.m_scene.m_params[s] < m_nKillerBottomPos) break;
                    GameProcess.m_scene.m_params[GameProcess.l_shPtr] = (short)m_nKillerBottomPos;
                    GameProcess.m_nKillerState[GameProcess.l_shPtr] = 2;
                    GameProcess.m_lKillerStateChange[GameProcess.l_shPtr] = m_lThisTickCount + (long)Game.chooseNumber(SARATOV_SPIDER_STAY[m_nComplication], 2);
                    break;
                }
                case 2: {
                    if (m_lKillerStateChange[l_shPtr] >= m_lThisTickCount) break;
                    GameProcess.m_nKillerState[GameProcess.l_shPtr] = 3;
                    break;
                }
                case 3: {
                    short s = l_shPtr;
                    GameProcess.m_scene.m_params[s] = (short)(GameProcess.m_scene.m_params[s] - SARATOV_SPIDER_SPEED[m_nComplication]);
                    if (GameProcess.m_scene.m_params[s] > m_nKillerTopPos) break;
                    GameProcess.m_scene.m_params[GameProcess.l_shPtr] = (short)m_nKillerTopPos;
                    GameProcess.m_nKillerState[GameProcess.l_shPtr] = 0;
                    GameProcess.m_lKillerStateChange[GameProcess.l_shPtr] = m_lThisTickCount + (long)Game.chooseNumber(SARATOV_SPIDER_WAIT[m_nComplication], 2);
                }
            }
            if (m_nKillerState[l_shPtr] == 0 || !GameProcess.m_cat.m_sprite.collidesWith((l_shX = GameProcess.m_scene.m_params[29 + l_shPtr - 7]) - 4, l_shY = GameProcess.m_scene.m_params[7 + l_shPtr - 7], 8, 8)) continue;
            m_imgBlink = m_imgKill;
            GameProcess.endLevel(false);
            return;
        }
        l_shCounter = 0;
        for (l_shPtr = 0; l_shPtr < 7; l_shPtr = (short)(l_shPtr + 1)) {
            if (m_nKillerState[l_shPtr] == 0) continue;
            l_shCounter = (short)(l_shCounter + 1);
        }
        block16: for (int shPtr = shStart = (int)Game.random(7); shPtr < shStart + 7; shPtr = (int)((short)(shPtr + 1))) {
            l_shPtr = (short)((shPtr < 7 ? shPtr : shPtr - 7) + 0);
            switch (m_nKillerState[l_shPtr]) {
                case 0: {
                    if (m_lKillerStateChange[l_shPtr] >= m_lThisTickCount || l_shCounter >= 3 - m_nComplication || GameProcess.m_cat.m_sprite.collidesWith((l_shX = GameProcess.m_scene.m_params[15 + l_shPtr - 0]) - 12, (l_shY = GameProcess.m_scene.m_params[22 + l_shPtr - 0]) - 12, 24, 24)) continue block16;
                    GameProcess.m_nKillerState[GameProcess.l_shPtr] = 1;
                    GameProcess.m_scene.m_params[GameProcess.l_shPtr] = 0;
                    l_shCounter = (short)(l_shCounter + 1);
                    continue block16;
                }
                case 1: {
                    short s = l_shPtr;
                    GameProcess.m_scene.m_params[s] = (short)(GameProcess.m_scene.m_params[s] + 1);
                    if (GameProcess.m_scene.m_params[s] != 3) continue block16;
                    GameProcess.m_nKillerState[GameProcess.l_shPtr] = 2;
                    GameProcess.m_lKillerStateChange[GameProcess.l_shPtr] = m_lThisTickCount + (long)Game.chooseNumber(SARATOV_MOUSE_STAY[m_nComplication], 2);
                    continue block16;
                }
                case 2: {
                    if (m_lKillerStateChange[l_shPtr] >= m_lThisTickCount) continue block16;
                    GameProcess.m_nKillerState[GameProcess.l_shPtr] = 3;
                    continue block16;
                }
                case 3: {
                    short s = l_shPtr;
                    GameProcess.m_scene.m_params[s] = (short)(GameProcess.m_scene.m_params[s] - 1);
                    if (GameProcess.m_scene.m_params[s] != 0) continue block16;
                    GameProcess.m_nKillerState[GameProcess.l_shPtr] = 0;
                    GameProcess.m_lKillerStateChange[GameProcess.l_shPtr] = m_lThisTickCount + (long)Game.chooseNumber(SARATOV_MOUSE_WAIT[m_nComplication], 2);
                }
            }
        }
        if (m_nSaratovMouseCount >= 5) {
            GameProcess.endLevel(true);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    static void process_spiderScene() {
        if (m_lNextSceneProcess > m_lThisTickCount) {
            return;
        }
        if (m_nCurrentLevelState != 0) {
            return;
        }
        m_lNextSceneProcess = m_lThisTickCount + 56L;
        l_shCounter = 0;
        block5: for (l_shPtr = 0; l_shPtr < 4; l_shPtr = (short)(l_shPtr + 1)) {
            switch (m_nKillerState[l_shPtr]) {
                case 2: {
                    l_shW = GameProcess.m_scene.m_params[21];
                    l_shX = (short)(GameProcess.m_scene.m_params[0 + l_shPtr] + GameProcess.m_scene.m_params[22 + l_shPtr]);
                    l_shY = GameProcess.m_scene.m_params[12 + l_shPtr];
                    l_shH = (short)(l_shPtr < 2 ? m_nSpiderKomodTop - l_shY : m_nSpiderKomodCenterY - l_shY);
                    if (GameProcess.m_cat.m_sprite.collidesWith(l_shX - (l_shW >> 1), l_shY, l_shW, l_shH)) {
                        if (l_shX > GameProcess.m_cat.m_sprite.m_nX + (GameProcess.m_cat.m_sprite.m_nFrW >> 1)) {
                            l_shX = (short)(GameProcess.m_cat.m_sprite.m_nCollisionRectX + GameProcess.m_cat.m_sprite.m_nX + GameProcess.m_cat.m_sprite.m_nCollisionRectWidth);
                            if (l_shX > GameProcess.m_scene.m_nRight - l_shW) {
                                l_shX = (short)(GameProcess.m_scene.m_nRight - l_shW);
                            }
                            GameProcess.m_scene.m_params[0 + GameProcess.l_shPtr] = (short)(l_shX + (l_shW >> 1) - GameProcess.m_scene.m_params[22 + l_shPtr]);
                            if (l_shX + (l_shW >> 1) > m_nSpiderKomodLeft + m_nSpiderKomodWidth) {
                                GameProcess.m_nKillerState[GameProcess.l_shPtr] = 3;
                            }
                        } else {
                            l_shX = (short)(GameProcess.m_cat.m_sprite.m_nCollisionRectX + GameProcess.m_cat.m_sprite.m_nX);
                            if (l_shX < GameProcess.m_scene.m_nLeft + l_shW) {
                                l_shX = (short)(GameProcess.m_scene.m_nLeft + l_shW);
                            }
                            GameProcess.m_scene.m_params[0 + GameProcess.l_shPtr] = (short)(l_shX - (l_shW >> 1) - GameProcess.m_scene.m_params[22 + l_shPtr]);
                            if (l_shX - (l_shW >> 1) < m_nSpiderKomodLeft) {
                                GameProcess.m_nKillerState[GameProcess.l_shPtr] = 3;
                            }
                        }
                    }
                    if (Math.abs(m_nKillerState[l_shPtr + 8] - GameProcess.m_scene.m_params[l_shPtr + 0]) < GameProcess.m_scene.m_params[20]) continue block5;
                    GameProcess.m_nKillerState[GameProcess.l_shPtr] = 3;
                    continue block5;
                }
                case 3: {
                    int n = 12 + l_shPtr;
                    int n2 = 4 + l_shPtr;
                    GameProcess.m_scene.m_params[n2] = (short)(GameProcess.m_scene.m_params[n2] + 1);
                    GameProcess.m_scene.m_params[n] = (short)(GameProcess.m_scene.m_params[n] + GameProcess.m_scene.m_params[n2]);
                    if (GameProcess.m_scene.m_params[16 + l_shPtr] > GameProcess.m_scene.m_params[n]) continue block5;
                    GameProcess.playSound(4);
                    GameProcess.m_nKillerState[GameProcess.l_shPtr] = 0;
                    GameProcess.m_scene.m_params[4 + GameProcess.l_shPtr] = 0;
                    GameProcess.m_scene.m_params[8 + GameProcess.l_shPtr] = 1;
                    continue block5;
                }
                case 0: {
                    l_shCounter = (short)(l_shCounter + 1);
                    continue block5;
                }
            }
        }
        if (l_shCounter == 4) {
            GameProcess.endLevel(true);
            return;
        }
        if (m_lNextSpiderProcess > m_lThisTickCount) {
            return;
        }
        m_lNextSpiderProcess = m_lThisTickCount + 100L;
        if (!GameProcess.m_cat.m_sprite.collidesWith(m_nSpiderKomodLeft, 0, m_nSpiderKomodWidth, m_nSpiderKomodHeight + m_nSpiderKomodTop)) return;
        l_shX = (short)(GameProcess.m_cat.m_sprite.m_nX + GameProcess.m_cat.m_sprite.m_nCollisionRectX);
        l_shY = (short)(GameProcess.m_cat.m_sprite.m_nY + GameProcess.m_cat.m_sprite.m_nCollisionRectY);
        l_shW = (short)GameProcess.m_cat.m_sprite.m_nCollisionRectWidth;
        l_shH = (short)GameProcess.m_cat.m_sprite.m_nCollisionRectHeight;
        if (m_bSpiderSide) {
            if (GameProcess.m_cat.m_sprite.collidesWith(GameProcess.m_scene.m_params[26], GameProcess.m_scene.m_params[27] - m_nSpiderSideH, m_nSpiderSideW, m_nSpiderSideH << 1)) {
                m_imgBlink = m_imgKill;
                GameProcess.endLevel(false);
                return;
            }
            l_shPtr = (short)(GameProcess.m_scene.m_params[26] + (m_nSpiderSideW >> 1));
            if (l_shX < l_shPtr && l_shX + l_shW > l_shPtr) {
                GameProcess.m_scene.m_params[31] = 0;
                GameProcess.m_scene.m_params[32] = 1;
                m_bSpiderSide = false;
                if (l_shY > GameProcess.m_scene.m_params[27] + m_nSpiderSideH) {
                    GameProcess.m_scene.m_params[28] = (short)(GameProcess.m_scene.m_params[27] + m_nSpiderSideH - m_nSpiderTopH2);
                    GameProcess.m_scene.m_params[30] = 4;
                    return;
                }
                if (l_shY + l_shH < GameProcess.m_scene.m_params[27]) {
                    GameProcess.m_scene.m_params[28] = (short)(GameProcess.m_scene.m_params[27] + m_nSpiderSideH - m_nSpiderTopH + m_nSpiderTopH2);
                    GameProcess.m_scene.m_params[30] = 0;
                    return;
                }
                m_imgBlink = m_imgKill;
                GameProcess.endLevel(false);
                return;
            }
            if (l_shX + (l_shW >> 1) < GameProcess.m_scene.m_params[26] + (m_nSpiderSideW >> 1)) {
                GameProcess.m_scene.m_params[29] = (short)((GameProcess.m_scene.m_params[29] + 1) % 4 + 4);
                GameProcess.m_scene.m_params[26] = (short)(GameProcess.m_scene.m_params[26] - SPIDER_VX[m_nComplication]);
                if (GameProcess.m_scene.m_params[26] >= m_nSpiderKomodLeft) return;
                GameProcess.m_scene.m_params[26] = (short)m_nSpiderKomodLeft;
                return;
            }
            GameProcess.m_scene.m_params[29] = (short)((GameProcess.m_scene.m_params[29] + 1) % 4);
            GameProcess.m_scene.m_params[26] = (short)(GameProcess.m_scene.m_params[26] + SPIDER_VX[m_nComplication]);
            if (GameProcess.m_scene.m_params[26] <= m_nSpiderKomodLeft + m_nSpiderKomodWidth - m_nSpiderSideW) return;
            GameProcess.m_scene.m_params[26] = (short)(m_nSpiderKomodLeft + m_nSpiderKomodWidth - m_nSpiderSideW);
            return;
        }
        if (GameProcess.m_cat.m_sprite.collidesWith(GameProcess.m_scene.m_params[26], GameProcess.m_scene.m_params[28], m_nSpiderTopW, m_nSpiderTopH)) {
            m_imgBlink = m_imgKill;
            GameProcess.endLevel(false);
            return;
        }
        if (GameProcess.m_scene.m_params[30] < 4) {
            if (GameProcess.spiderGoUp()) {
                return;
            }
            GameProcess.spiderGoDown();
            return;
        }
        if (GameProcess.spiderGoDown()) {
            return;
        }
        GameProcess.spiderGoUp();
    }

    static boolean spiderGoDown() {
        if (GameProcess.m_scene.m_params[28] < l_shY + l_shH) {
            GameProcess.m_scene.m_params[30] = (short)((GameProcess.m_scene.m_params[30] + 1) % 4 + 4);
            GameProcess.m_scene.m_params[28] = (short)(GameProcess.m_scene.m_params[28] + SPIDER_VX[m_nComplication]);
            l_shPtr = GameProcess.m_scene.m_params[28];
            if (l_shPtr > m_nSpiderKomodTop + m_nSpiderKomodHeight - m_nSpiderTopH) {
                GameProcess.m_scene.m_params[28] = (short)(m_nSpiderKomodTop + m_nSpiderKomodHeight - m_nSpiderTopH);
            } else if (l_shPtr < m_nSpiderKomodTop - m_nSpiderTopH2 && l_shPtr + m_nSpiderTopH - m_nSpiderTopH2 > m_nSpiderKomodTop) {
                GameProcess.m_scene.m_params[31] = 1;
                GameProcess.m_scene.m_params[32] = 0;
                m_bSpiderSide = true;
                GameProcess.m_scene.m_params[27] = (short)(m_nSpiderKomodTop - m_nSpiderSideH);
                GameProcess.m_scene.m_params[30] = 0;
            } else if (l_shPtr < m_nSpiderKomodCenterY - m_nSpiderTopH2 && l_shPtr + m_nSpiderTopH - m_nSpiderTopH2 > m_nSpiderKomodCenterY) {
                GameProcess.m_scene.m_params[31] = 1;
                GameProcess.m_scene.m_params[32] = 0;
                m_bSpiderSide = true;
                GameProcess.m_scene.m_params[27] = (short)(m_nSpiderKomodCenterY - m_nSpiderSideH);
                GameProcess.m_scene.m_params[30] = 0;
            }
            return true;
        }
        return false;
    }

    static boolean spiderGoUp() {
        if (GameProcess.m_scene.m_params[28] > l_shY - m_nSpiderTopH) {
            GameProcess.m_scene.m_params[30] = (short)((GameProcess.m_scene.m_params[30] + 1) % 4);
            GameProcess.m_scene.m_params[28] = (short)(GameProcess.m_scene.m_params[28] - SPIDER_VY[m_nComplication]);
            l_shPtr = GameProcess.m_scene.m_params[28];
            if (l_shPtr < m_nSpiderKomodTop - m_nSpiderTopH2 && l_shPtr + m_nSpiderTopH > m_nSpiderKomodTop + m_nSpiderTopH2) {
                GameProcess.m_scene.m_params[31] = 1;
                GameProcess.m_scene.m_params[32] = 0;
                m_bSpiderSide = true;
                GameProcess.m_scene.m_params[27] = (short)(m_nSpiderKomodTop - m_nSpiderSideH);
                GameProcess.m_scene.m_params[30] = 0;
            } else if (l_shPtr < m_nSpiderKomodCenterY - m_nSpiderTopH2 && l_shPtr + m_nSpiderTopH > m_nSpiderKomodCenterY + m_nSpiderTopH2) {
                GameProcess.m_scene.m_params[31] = 1;
                GameProcess.m_scene.m_params[32] = 0;
                m_bSpiderSide = true;
                GameProcess.m_scene.m_params[27] = (short)(m_nSpiderKomodCenterY - m_nSpiderSideH);
                GameProcess.m_scene.m_params[30] = 0;
            }
            return true;
        }
        return false;
    }

    static void process_aquariumScene() {
        if (m_lNextSceneProcess > m_lThisTickCount) {
            return;
        }
        m_lNextSceneProcess = m_lThisTickCount + 56L;
        if (m_nCurrentLevelState != 0) {
            return;
        }
        if (GameProcess.m_swimCat.m_nState != 1 && GameProcess.m_swimCat.m_nState != 5) {
            if (m_lNextAquaCatProcess < m_lThisTickCount) {
                m_lNextAquaCatProcess = m_lThisTickCount + 200L;
                if ((m_swimCat.getState(255) == 0 || m_swimCat.getState(255) == 4) && GameProcess.m_swimCat.m_sprite.m_nY == GameProcess.m_scene.m_nTop) {
                    m_nKillerPos -= AQUA_BREATHE[m_nComplication];
                    if (m_bCatMoveUp) {
                        if (--m_nCatOffset == -1) {
                            m_bCatMoveUp = false;
                        }
                    } else if (++m_nCatOffset == 1) {
                        m_bCatMoveUp = true;
                    }
                } else {
                    m_nCatOffset = 0;
                    m_nKillerPos += AQUA_DIE[m_nComplication];
                }
                if (m_nKillerPos < 0) {
                    m_nKillerPos = 0;
                }
                if (m_nKillerPos >= 256) {
                    if (GameProcess.m_swimCat.m_nState < 4) {
                        GameProcess.m_swimCat.m_nState = 1;
                        m_swimCat.setFrameSequence(1);
                    } else {
                        GameProcess.m_swimCat.m_nState = 5;
                        m_swimCat.setFrameSequence(5);
                    }
                } else {
                    l_shH = (short)(m_nKillerBottomPos * m_nKillerPos >> 8);
                    GameProcess.m_scene.m_params[0] = (short)(m_nKillerTopPos + m_nKillerBottomPos - l_shH);
                    GameProcess.m_scene.m_params[1] = l_shH;
                }
            }
        } else if ((GameProcess.m_swimCat.m_sprite.m_nY += 3) >= GameProcess.m_scene.m_nBottom - GameProcess.m_swimCat.m_sprite.m_nFrH) {
            m_nCurrentLevelState = 1;
        }
    }

    static void process_tvScene() {
        if (m_lNextSceneProcess > m_lThisTickCount) {
            return;
        }
        if (m_nCurrentLevelState != 0) {
            return;
        }
        m_lNextSceneProcess = m_lThisTickCount + 60L;
        switch (m_nKillerState[0]) {
            case 2: {
                l_shW = GameProcess.m_scene.m_params[6];
                l_shH = GameProcess.m_scene.m_params[8];
                l_shX = (short)(GameProcess.m_scene.m_params[0] + GameProcess.m_scene.m_params[5]);
                l_shY = (short)(GameProcess.m_scene.m_params[1] + GameProcess.m_scene.m_params[7]);
                if (GameProcess.m_cat.m_sprite.collidesWith(l_shX, l_shY, l_shW, l_shH)) {
                    if (l_shX + (l_shW >> 1) > GameProcess.m_cat.m_sprite.m_nX + (GameProcess.m_cat.m_sprite.m_nFrW >> 1)) {
                        l_shX = (short)(GameProcess.m_cat.m_sprite.m_nCollisionRectX + GameProcess.m_cat.m_sprite.m_nX + GameProcess.m_cat.m_sprite.m_nCollisionRectWidth);
                        if (l_shX >= GameProcess.m_scene.m_nRight) {
                            l_shX = (short)(GameProcess.m_scene.m_nRight - 1);
                        }
                        GameProcess.m_scene.m_params[0] = (short)(l_shX - GameProcess.m_scene.m_params[5]);
                    } else {
                        l_shX = (short)(GameProcess.m_cat.m_sprite.m_nCollisionRectX + GameProcess.m_cat.m_sprite.m_nX);
                        if (l_shX <= GameProcess.m_scene.m_nLeft) {
                            l_shX = (short)(GameProcess.m_scene.m_nLeft + 1);
                        }
                        GameProcess.m_scene.m_params[0] = (short)(l_shX - l_shW - GameProcess.m_scene.m_params[5]);
                    }
                }
                if (Math.abs(m_nKillerState[2] - GameProcess.m_scene.m_params[0]) < GameProcess.m_scene.m_params[9]) break;
                GameProcess.m_nKillerState[0] = 3;
                break;
            }
            case 3: {
                m_nKillerState[1] = m_nKillerState[1] + 1;
                GameProcess.m_scene.m_params[1] = (short)(GameProcess.m_scene.m_params[1] + m_nKillerState[1]);
                if (GameProcess.m_scene.m_params[2] > GameProcess.m_scene.m_params[1]) break;
                GameProcess.m_nKillerState[0] = 0;
                m_bBirdFirstFly = true;
                GameProcess.m_scene.m_params[3] = 0;
                GameProcess.m_scene.m_params[4] = 1;
                break;
            }
        }
        if (m_nKillerState[0] != 0) {
            GameProcess.m_scene.m_params[10] = (short)(GameProcess.m_scene.m_params[0] + m_nKillerBottomPos);
            GameProcess.m_scene.m_params[11] = (short)(GameProcess.m_scene.m_params[1] + m_nKillerTopPos);
        } else {
            switch (m_nKillerState[3]) {
                case 0: {
                    if (m_lNextSpiderProcess > m_lThisTickCount) break;
                    m_nBirdTargetX = GameProcess.m_scene.m_params[10];
                    m_nBirdTargetY = GameProcess.m_scene.m_params[11];
                }
                case 1: 
                case 2: {
                    if (!Game.moveBy(GameProcess.m_scene.m_params[10], GameProcess.m_scene.m_params[11], m_nBirdTargetX, m_nBirdTargetY, 5)) {
                        if (m_nKillerState[3] == 2 || m_nKillerState[3] == 0) {
                            int state;
                            int nX = GameProcess.m_cat.m_sprite.m_nX + GameProcess.m_cat.m_sprite.m_nCollisionRectX + (GameProcess.m_cat.m_sprite.m_nCollisionRectWidth >> 1);
                            int nY = GameProcess.m_cat.m_sprite.m_nY + GameProcess.m_cat.m_sprite.m_nCollisionRectY + (GameProcess.m_cat.m_sprite.m_nCollisionRectHeight >> 1);
                            l_shX = GameProcess.m_scene.m_params[10];
                            l_shY = GameProcess.m_scene.m_params[11];
                            l_shW = GameProcess.m_scene.m_params[12];
                            l_shH = GameProcess.m_scene.m_params[13];
                            l_shInd = (short)((l_shY > GameProcess.m_scene.m_nTop + GameProcess.m_scene.m_nBottom >> 1 ? 2 : 0) + (l_shX > GameProcess.m_scene.m_nLeft + GameProcess.m_scene.m_nRight >> 1 ? 1 : 0));
                            l_shPtr = (short)((nY > GameProcess.m_scene.m_nTop + GameProcess.m_scene.m_nBottom >> 1 ? 2 : 0) + (nX > GameProcess.m_scene.m_nLeft + GameProcess.m_scene.m_nRight >> 1 ? 1 : 0));
                            switch (l_shPtr << 2 | l_shInd) {
                                case 0: {
                                    state = 2;
                                    l_shInd = (short)(Game.random(2) == 0 ? 1 : 2);
                                    break;
                                }
                                case 1: {
                                    state = 1;
                                    l_shInd = (short)3;
                                    break;
                                }
                                case 2: {
                                    state = 1;
                                    l_shInd = (short)3;
                                    break;
                                }
                                case 3: {
                                    state = 1;
                                    l_shInd = (short)(Game.random(2) == 0 ? 1 : 2);
                                    break;
                                }
                                case 4: {
                                    state = 1;
                                    l_shInd = (short)2;
                                    break;
                                }
                                case 5: {
                                    state = 2;
                                    l_shInd = (short)(Game.random(2) == 0 ? 0 : 3);
                                    break;
                                }
                                case 6: {
                                    state = 1;
                                    l_shInd = (short)(Game.random(2) == 0 ? 0 : 3);
                                    break;
                                }
                                case 7: {
                                    state = 1;
                                    l_shInd = (short)2;
                                    break;
                                }
                                case 8: {
                                    state = 1;
                                    l_shInd = 1;
                                    break;
                                }
                                case 9: {
                                    state = 2;
                                    l_shInd = (short)(Game.random(2) == 0 ? 0 : 3);
                                    break;
                                }
                                case 10: {
                                    state = 2;
                                    l_shInd = (short)(Game.random(2) == 0 ? 0 : 3);
                                    break;
                                }
                                case 11: {
                                    state = 1;
                                    l_shInd = 1;
                                    break;
                                }
                                case 12: {
                                    state = 1;
                                    l_shInd = (short)(Game.random(2) == 0 ? 1 : 2);
                                    break;
                                }
                                case 13: {
                                    state = 1;
                                    l_shInd = 0;
                                    break;
                                }
                                case 14: {
                                    state = 1;
                                    l_shInd = 0;
                                    break;
                                }
                                case 15: {
                                    state = 2;
                                    l_shInd = (short)(Game.random(2) == 0 ? 1 : 2);
                                    break;
                                }
                                default: {
                                    state = 1;
                                    l_shInd = (short)3;
                                }
                            }
                            GameProcess.m_nKillerState[3] = m_nKillerState[3] == 2 ? 1 : state;
                            m_nBirdTargetX = GameProcess.m_scene.m_params[14 + l_shInd];
                            m_nBirdTargetY = GameProcess.m_scene.m_params[18 + l_shInd];
                            break;
                        }
                        GameProcess.m_scene.m_params[22] = (short)(GameProcess.m_scene.m_params[22] < 3 ? 0 : 3);
                        GameProcess.m_nKillerState[3] = 0;
                        m_bBirdFirstFly = false;
                        m_lNextSpiderProcess = m_lThisTickCount + (long)TV_BIRD_SIT_TIME[m_nComplication];
                        break;
                    }
                    GameProcess.m_scene.m_params[22] = GameProcess.m_scene.m_params[22] == 0 || GameProcess.m_scene.m_params[22] == 3 ? (short)(Game.m_nMoveByX < 0 ? 1 : 4) : (short)(Game.m_nMoveByX < 0 ? 0 : 3);
                    GameProcess.m_scene.m_params[10] = (short)(GameProcess.m_scene.m_params[10] + Game.m_nMoveByX);
                    GameProcess.m_scene.m_params[11] = (short)(GameProcess.m_scene.m_params[11] + Game.m_nMoveByY);
                    if (GameProcess.m_scene.m_params[28] != 0 || !Game.intersectRectWH(GameProcess.m_scene.m_params[10], GameProcess.m_scene.m_params[11], GameProcess.m_scene.m_params[12], GameProcess.m_scene.m_params[13], GameProcess.m_scene.m_params[23], GameProcess.m_scene.m_params[24], GameProcess.m_scene.m_params[25], GameProcess.m_scene.m_params[26])) break;
                    GameProcess.m_scene.m_params[28] = 1;
                    GameProcess.m_scene.m_params[29] = GameProcess.m_scene.m_params[10];
                    GameProcess.m_scene.m_params[30] = GameProcess.m_scene.m_params[11];
                    break;
                }
                case 3: {
                    if (GameProcess.m_scene.m_params[11] < GameProcess.m_scene.m_nBottom - 10) {
                        m_nKillerState[1] = m_nKillerState[1] + 1;
                        GameProcess.m_scene.m_params[11] = (short)(GameProcess.m_scene.m_params[11] + m_nKillerState[1]);
                        break;
                    }
                    GameProcess.m_scene.m_params[11] = (short)(GameProcess.m_scene.m_nBottom - 10);
                    GameProcess.endLevel(true);
                    return;
                }
            }
            if (!m_bBirdFirstFly && GameProcess.m_cat.m_sprite.collidesWith(GameProcess.m_scene.m_params[10], GameProcess.m_scene.m_params[11], GameProcess.m_scene.m_params[12], GameProcess.m_scene.m_params[13])) {
                GameProcess.m_nKillerState[3] = 3;
                GameProcess.m_scene.m_params[22] = (short)(Game.m_nMoveByX < 0 ? 2 : 5);
            }
        }
        if (GameProcess.m_scene.m_params[28] != 0 && GameProcess.m_scene.m_params[30] < GameProcess.m_scene.m_params[27]) {
            m_nKillerState[4] = m_nKillerState[4] + 1;
            GameProcess.m_scene.m_params[30] = (short)(GameProcess.m_scene.m_params[30] + m_nKillerState[4]);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    static boolean process_dog() {
        block10: {
            block9: {
                if (m_lDogProcess > m_lThisTickCount) {
                    return l_bProcessDog_LastResult;
                }
                if (m_nCurrentLevelState != 0) {
                    return l_bProcessDog_LastResult;
                }
                m_lDogProcess = m_lThisTickCount + 70L;
                if (GameProcess.m_dog.m_nX < 132) break block9;
                if (m_nDustVx < 0 && GameProcess.m_dust.m_nX < -GameProcess.m_dust.m_nFrW || m_nDustVx >= 0 && GameProcess.m_dust.m_nX >= 132) {
                    if (m_lDogRespawn <= m_lThisTickCount) {
                        GameProcess.m_dog.m_nX = -GameProcess.m_dog.m_nFrW;
                    }
                    break block10;
                } else {
                    GameProcess.m_dust.m_nX += m_nDustVx;
                    m_dust.nextFrame();
                    if (GameProcess.m_dust.m_nX >= -GameProcess.m_dust.m_nFrW && GameProcess.m_dust.m_nX < 132) {
                        l_bProcessDog_LastResult = false;
                        return false;
                    }
                    m_nCurrentLevelState = 1;
                    return false;
                }
            }
            GameProcess.m_dog.m_nX += 6;
            m_dog.nextFrame();
            if (GameProcess.m_dog.m_nX >= 132) {
                m_lDogRespawn = m_lThisTickCount + (long)Game.chooseNumber(DOG_WAIT[m_nComplication], 2);
            } else {
                l_shH = (short)(GameProcess.m_dog.m_nFrH >> 1);
                if (GameProcess.m_cat.m_sprite.collidesWith(GameProcess.m_dog.m_nX, GameProcess.m_dog.m_nY + l_shH, GameProcess.m_dog.m_nFrW, l_shH)) {
                    GameProcess.playSound(2);
                    GameProcess.m_dust.m_nX = GameProcess.m_cat.m_sprite.m_nX + (GameProcess.m_cat.m_sprite.m_nFrW - GameProcess.m_dust.m_nFrW >> 1);
                    GameProcess.m_dog.m_nX = 132;
                    m_nDustVx = GameProcess.m_dust.m_nX + (GameProcess.m_dust.m_nFrW >> 1) < 66 ? 5 : -5;
                }
            }
        }
        l_bProcessDog_LastResult = true;
        return true;
    }

    static void setScore(int nScore) {
        m_nScore = nScore;
        if (m_nScore > 100000 && m_nComplication < 2) {
            m_nComplication = 2;
        } else if (m_nScore > 6000 && m_nComplication < 1) {
            m_nComplication = 1;
        }
        if (m_nState == 0) {
            m_strScore = "" + nScore;
        }
    }

    static void setLives(int nLives) {
        m_nLives = nLives;
        if (0 >= m_nLives) {
            m_nLives = 0;
        } else {
            if (m_nLives > 9) {
                m_nLives = 9;
            }
            GameProcess.m_scene.m_params[20] = (short)m_nLives;
        }
    }

    static void addHiScore(String sName, int nScore) {
        int i;
        for (i = 0; i < 5; ++i) {
            if (nScore <= m_nHiScores[i]) continue;
            System.arraycopy(m_nHiScores, i, m_nHiScores, i + 1, 4 - i);
            System.arraycopy(m_sHiScores, i, m_sHiScores, i + 1, 4 - i);
            GameProcess.m_sHiScores[i] = sName;
            GameProcess.m_nHiScores[i] = nScore;
            break;
        }
        for (i = 0; i < 5; ++i) {
            GameProcess.m_cControls[3].m_sItems[i] = m_sHiScores[i] == null || m_sHiScores[i].length() == 0 ? m_sEmptyHiScore : m_sHiScores[i] + ": " + m_nHiScores[i];
        }
        m_cControls[3].calcSizes();
        GameProcess.save();
    }

    static {
        m_sizes = new int[]{5867, 610, 332, 1091, 284};
        m_nCurrentSound = -1;
        m_nIterationCount = 10;
        m_nLastGame = 1000;
        BONUS_ARROW_V = new int[]{2, 4, 6};
        DOMIK_KILLER_WAIT = new int[]{10000, 5000, 3000};
        DOMIK_KILLER_STAY = new int[]{100, 1000, 2000};
        DOMIK_WINDOW_OPEN_TIME = new int[]{5000, 3000, 1500};
        m_nWinState = 0;
        m_nWinCenterX = new int[8];
        m_nWinCenterY = new int[8];
        SARATOV_SPIDER_SPEED = new int[]{1, 1, 2};
        SARATOV_SPIDER_WAIT = new int[]{15000, 10000, 5000};
        SARATOV_SPIDER_STAY = new int[]{2000, 500, 100};
        SARATOV_MOUSE_WAIT = new int[]{10, 200, 5000};
        SARATOV_MOUSE_STAY = new int[]{5000, 2000, 700};
        SPIDER_VX = new int[]{1, 1, 2};
        SPIDER_VY = new int[]{1, 1, 2};
        AQUA_DIE = new int[]{3, 5, 8};
        AQUA_BREATHE = new int[]{10, 10, 10};
        TV_BIRD_SIT_TIME = new int[]{1500, 700, 100};
    }
}

