/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.microedition.media.control.VolumeControl;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class cGameMIDlet
extends MIDlet
implements PlayerListener,
Runnable {
    private Thread thread = null;
    private cGameCanvas mGameCanvas = null;
    private Display mDisplay = null;
    private static RecordStore mSaveGameStore = null;
    public static byte[] mSaveStatusBuffer;
    private static byte[] mSaveScoreBuffer;
    public static Player[] mSoundBnk;
    public static byte[][] mSoundBytes;
    public static int mDaysLeft;
    private static long mCurrentTime;
    private static long mLastTimeTick;
    private boolean THREAD_STOP = false;
    static long var;
    public static char[] mCharBuffer;
    static int[] soundDims;
    static String[] soundNames;
    int lastSoundId = -1;

    public void startApp() {
        if (this.mGameCanvas != null) {
            this.mDisplay.setCurrent((Displayable)this.mGameCanvas);
            return;
        }
        this.mDisplay = Display.getDisplay((MIDlet)this);
        this.mGameCanvas = new cGameCanvas();
        this.mDisplay.setCurrent((Displayable)this.mGameCanvas);
        this.mGameCanvas.Init(this);
        this.mGameCanvas.SetGameState((byte)1);
        this.mGameCanvas.repaint();
        this.mGameCanvas.serviceRepaints();
        this.THREAD_STOP = false;
        this.thread = new Thread(this);
        this.thread.start();
    }

    protected void pauseApp() {
        this.mGameCanvas.cristiPause();
    }

    protected void destroyApp(boolean bl) {
        if (!bl) {
            try {
                mSaveGameStore.closeRecordStore();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((cGameCanvas.mMode & 0x10) != 0) {
            this.SoundStop();
        }
        this.freeAll();
        this.notifyDestroyed();
    }

    private void freeAll() {
        this.mDisplay.setCurrent(null);
        this.THREAD_STOP = true;
        this.thread = null;
        this.mGameCanvas = null;
    }

    long StringToLong(String string) {
        long l = 0L;
        if (string == null) {
            return 0L;
        }
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) < '0' || string.charAt(i) > '9') continue;
            l = (long)10 * l + (long)((byte)(string.charAt(i) - 48));
        }
        return l;
    }

    public void InitSaveGame() {
        mSaveStatusBuffer = new byte[412];
        mSaveScoreBuffer = new byte[120];
        try {
            mSaveGameStore = RecordStore.openRecordStore((String)"Solitaire.sav", (boolean)true);
            if (mSaveGameStore.getNumRecords() == 0) {
                int n;
                mSaveGameStore.addRecord(mSaveStatusBuffer, 0, mSaveStatusBuffer.length);
                for (n = 0; n < mSaveStatusBuffer.length; ++n) {
                    cGameMIDlet.mSaveStatusBuffer[n] = 0;
                }
                cGameMIDlet.mSaveStatusBuffer[0] = 50;
                mSaveGameStore.setRecord(1, mSaveStatusBuffer, 0, mSaveStatusBuffer.length);
                cGameCanvas.mPlayingAGame = false;
                mSaveGameStore.addRecord(mSaveScoreBuffer, 0, mSaveScoreBuffer.length);
                for (n = 0; n < 20; ++n) {
                    cGameMIDlet.mSaveScoreBuffer[n * 6] = 0;
                    cGameMIDlet.mSaveScoreBuffer[n * 6 + 1] = 0;
                    cGameCanvas.mHighScoreName[n] = "AAA";
                    byte[] byArray = cGameCanvas.mHighScoreName[n].getBytes();
                    cGameMIDlet.mSaveScoreBuffer[n * 6 + 2] = byArray[0];
                    cGameMIDlet.mSaveScoreBuffer[n * 6 + 3] = byArray[1];
                    cGameMIDlet.mSaveScoreBuffer[n * 6 + 4] = byArray[2];
                    cGameMIDlet.mSaveScoreBuffer[n * 6 + 5] = n < 10 ? 8 : 7;
                }
                mSaveGameStore.setRecord(2, mSaveScoreBuffer, 0, mSaveScoreBuffer.length);
                cGameCanvas.mFirstLaunch = 1;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void SaveGameWrite(byte by) {
        int n;
        if ((by & 1) != 0) {
            int n2;
            cGameMIDlet.mSaveStatusBuffer[0] = cGameCanvas.mMode;
            cGameMIDlet.mSaveStatusBuffer[1] = (byte)(Math.abs(cGameCanvas.mScore) % 100);
            cGameMIDlet.mSaveStatusBuffer[2] = (byte)((Math.abs(cGameCanvas.mScore) - Math.abs(cGameCanvas.mScore) % 100) / 100 % 100);
            cGameMIDlet.mSaveStatusBuffer[3] = cGameCanvas.mScore < 0 ? -1 : 1;
            cGameMIDlet.mSaveStatusBuffer[4] = (byte)(Math.abs(cGameCanvas.mTimer) % 100);
            cGameMIDlet.mSaveStatusBuffer[5] = (byte)((Math.abs(cGameCanvas.mTimer) - Math.abs(cGameCanvas.mTimer) % 100) / 100 % 100);
            cGameMIDlet.mSaveStatusBuffer[6] = cGameCanvas.mTurnedDeck;
            if (cGameCanvas.mPlayingAGame) {
                int n3;
                n2 = 7;
                for (n = 0; n < 7; ++n) {
                    for (n3 = 0; n3 < 18; ++n3) {
                        cGameMIDlet.mSaveStatusBuffer[n2] = cGameCanvas.mStack[n][n3][1];
                        cGameMIDlet.mSaveStatusBuffer[++n2] = cGameCanvas.mStack[n][n3][0];
                        ++n2;
                    }
                }
                for (n = 0; n < 4; ++n) {
                    for (n3 = 0; n3 < 13; ++n3) {
                        cGameMIDlet.mSaveStatusBuffer[n2] = cGameCanvas.mSuit[n][n3][1];
                        cGameMIDlet.mSaveStatusBuffer[++n2] = cGameCanvas.mSuit[n][n3][0];
                        ++n2;
                    }
                }
                for (n3 = 0; n3 < 24; ++n3) {
                    cGameMIDlet.mSaveStatusBuffer[n2] = cGameCanvas.mDeck[n3][1];
                    cGameMIDlet.mSaveStatusBuffer[++n2] = cGameCanvas.mDeck[n3][0];
                    ++n2;
                }
            } else {
                n2 = 411;
            }
            cGameMIDlet.mSaveStatusBuffer[n2] = cGameCanvas.mPlayingAGame ? (byte)1 : 0;
            try {
                mSaveGameStore.setRecord(1, mSaveStatusBuffer, 0, mSaveStatusBuffer.length);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((by & 2) != 0) {
            for (n = 0; n < 20; ++n) {
                cGameMIDlet.mSaveScoreBuffer[n * 6] = (byte)(Math.abs(cGameCanvas.mHighScoreValue[n]) % 100);
                cGameMIDlet.mSaveScoreBuffer[n * 6 + 1] = (byte)((Math.abs(cGameCanvas.mHighScoreValue[n]) - Math.abs(cGameCanvas.mHighScoreValue[n]) % 100) / 100 % 100);
                byte[] byArray = cGameCanvas.mHighScoreName[n].getBytes();
                cGameMIDlet.mSaveScoreBuffer[n * 6 + 2] = byArray[0];
                cGameMIDlet.mSaveScoreBuffer[n * 6 + 3] = byArray[1];
                cGameMIDlet.mSaveScoreBuffer[n * 6 + 4] = byArray[2];
                cGameMIDlet.mSaveScoreBuffer[n * 6 + 5] = cGameCanvas.mHighScoreMode[n];
            }
            try {
                mSaveGameStore.setRecord(2, mSaveScoreBuffer, 0, mSaveScoreBuffer.length);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void SaveGameRead(byte by) {
        int n;
        if ((by & 1) != 0) {
            int n2;
            try {
                mSaveStatusBuffer = mSaveGameStore.getRecord(1);
            }
            catch (Exception exception) {
                // empty catch block
            }
            cGameCanvas.mMode = mSaveStatusBuffer[0];
            cGameCanvas.mScore = mSaveStatusBuffer[1];
            cGameCanvas.mScore += mSaveStatusBuffer[2] * 100;
            cGameCanvas.mScore *= mSaveStatusBuffer[3];
            cGameCanvas.mTimer = mSaveStatusBuffer[4];
            cGameCanvas.mTimer += mSaveStatusBuffer[5] * 100;
            cGameCanvas.mTurnedDeck = mSaveStatusBuffer[6];
            int n3 = 7;
            for (n = 0; n < 7; ++n) {
                for (n2 = 0; n2 < 18; ++n2) {
                    cGameCanvas.mStack[n][n2][1] = mSaveStatusBuffer[n3];
                    cGameCanvas.mStack[n][n2][0] = mSaveStatusBuffer[++n3];
                    ++n3;
                }
            }
            for (n = 0; n < 4; ++n) {
                for (n2 = 0; n2 < 13; ++n2) {
                    cGameCanvas.mSuit[n][n2][1] = mSaveStatusBuffer[n3];
                    cGameCanvas.mSuit[n][n2][0] = mSaveStatusBuffer[++n3];
                    ++n3;
                }
            }
            for (n2 = 0; n2 < 24; ++n2) {
                cGameCanvas.mDeck[n2][1] = mSaveStatusBuffer[n3];
                cGameCanvas.mDeck[n2][0] = mSaveStatusBuffer[++n3];
                ++n3;
            }
            boolean bl = cGameCanvas.mPlayingAGame = mSaveStatusBuffer[n3] == 1;
        }
        if ((by & 2) != 0) {
            try {
                mSaveScoreBuffer = mSaveGameStore.getRecord(2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            for (n = 0; n < 20; ++n) {
                cGameCanvas.mHighScoreValue[n] = mSaveScoreBuffer[n * 6];
                int n4 = n;
                cGameCanvas.mHighScoreValue[n4] = cGameCanvas.mHighScoreValue[n4] + mSaveScoreBuffer[n * 6 + 1] * 100;
                String string = new String(mSaveScoreBuffer, n * 6 + 2, 3);
                cGameCanvas.mHighScoreName[n] = string;
                cGameCanvas.mHighScoreMode[n] = mSaveScoreBuffer[n * 6 + 5];
            }
        }
    }

    public static void SoundLoad() {
        for (int i = 0; i < 9; ++i) {
            try {
                cGameMIDlet.mSoundBytes[i] = new byte[soundDims[i]];
                String string = soundNames[i];
                int n = soundDims[i];
                InputStream inputStream = string.getClass().getResourceAsStream(string);
                inputStream.read(mSoundBytes[i]);
                inputStream.close();
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public synchronized void playerUpdate(Player player, String string, Object object) {
    }

    public void SoundPlay(byte by) {
        boolean bl = by == this.lastSoundId;
        System.out.println("SoundPlay");
        try {
            if (this.lastSoundId >= 0 && mSoundBnk[this.lastSoundId] != null) {
                try {
                    if (mSoundBnk[this.lastSoundId].getState() == 400) {
                        return;
                    }
                    try {
                        mSoundBnk[this.lastSoundId].stop();
                        if (!bl) {
                            mSoundBnk[this.lastSoundId].deallocate();
                            mSoundBnk[this.lastSoundId].close();
                            mSoundBnk[this.lastSoundId].removePlayerListener((PlayerListener)this);
                        }
                    }
                    catch (Exception exception) {
                        System.out.println(exception.getMessage());
                    }
                    if (!bl) {
                        cGameMIDlet.mSoundBnk[this.lastSoundId] = null;
                    }
                }
                catch (Exception exception) {
                    System.out.println(exception.getMessage());
                }
            }
            this.lastSoundId = by;
            try {
                if (!bl) {
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(mSoundBytes[by], 0, soundDims[by]);
                    cGameMIDlet.mSoundBnk[by] = Manager.createPlayer((InputStream)byteArrayInputStream, (String)"audio/midi");
                    mSoundBnk[by].addPlayerListener((PlayerListener)this);
                    mSoundBnk[by].realize();
                    try {
                        System.out.println("5");
                        ((VolumeControl)mSoundBnk[by].getControl("VolumeControl")).setLevel(75);
                    }
                    catch (Exception exception) {
                        System.out.println(exception.getMessage());
                    }
                }
                System.out.println("6");
                mSoundBnk[by].start();
                System.out.println("7");
            }
            catch (Exception exception) {
                System.out.println(exception.getMessage());
            }
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
        System.out.println("4");
    }

    public void SoundStop() {
        try {
            if (this.lastSoundId >= 0 && mSoundBnk[this.lastSoundId] != null) {
                try {
                    mSoundBnk[this.lastSoundId].stop();
                    mSoundBnk[this.lastSoundId].deallocate();
                    mSoundBnk[this.lastSoundId].close();
                    mSoundBnk[this.lastSoundId].removePlayerListener((PlayerListener)this);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                cGameMIDlet.mSoundBnk[this.lastSoundId] = null;
            }
            this.lastSoundId = -1;
        }
        catch (Exception exception) {
            System.out.println("FAILED: exception for stopAllSounds:".concat(String.valueOf(String.valueOf(exception.getMessage()))));
        }
    }

    public void UpdateTimer() {
        if (cGameCanvas.mTimer >= 0 && (mCurrentTime = System.currentTimeMillis()) > mLastTimeTick + (long)1000) {
            if (++cGameCanvas.mTimer > 999) {
                cGameCanvas.mTimer = 0;
            }
            if (cGameCanvas.mTimer % 10 == 0) {
                if ((cGameCanvas.mScore -= 2) < 0) {
                    cGameCanvas.mScore = 0;
                }
                cGameCanvas.mDirtyScore = 1;
            }
            cGameCanvas.mDirtyTimer = 1;
            mLastTimeTick = mCurrentTime;
        }
    }

    public void GetHighScoreChar(int n) {
        int n2 = (cGameCanvas.mMode & 8) != 0 ? 0 : 10;
        cGameCanvas.mHighScoreName[cGameCanvas.mHighScoreIdx + n2].getChars(0, 3, mCharBuffer, 0);
        switch (n) {
            case 50: {
                if (mCharBuffer[cGameCanvas.mHighScoreNameCurrentChar] == 'A') {
                    cGameMIDlet.mCharBuffer[cGameCanvas.mHighScoreNameCurrentChar] = 66;
                    break;
                }
                if (mCharBuffer[cGameCanvas.mHighScoreNameCurrentChar] == 'B') {
                    cGameMIDlet.mCharBuffer[cGameCanvas.mHighScoreNameCurrentChar] = 67;
                    break;
                }
                cGameMIDlet.mCharBuffer[cGameCanvas.mHighScoreNameCurrentChar] = 65;
                break;
            }
            case 51: {
                if (mCharBuffer[cGameCanvas.mHighScoreNameCurrentChar] == 'D') {
                    cGameMIDlet.mCharBuffer[cGameCanvas.mHighScoreNameCurrentChar] = 69;
                    break;
                }
                if (mCharBuffer[cGameCanvas.mHighScoreNameCurrentChar] == 'E') {
                    cGameMIDlet.mCharBuffer[cGameCanvas.mHighScoreNameCurrentChar] = 70;
                    break;
                }
                cGameMIDlet.mCharBuffer[cGameCanvas.mHighScoreNameCurrentChar] = 68;
                break;
            }
            case 52: {
                if (mCharBuffer[cGameCanvas.mHighScoreNameCurrentChar] == 'G') {
                    cGameMIDlet.mCharBuffer[cGameCanvas.mHighScoreNameCurrentChar] = 72;
                    break;
                }
                if (mCharBuffer[cGameCanvas.mHighScoreNameCurrentChar] == 'H') {
                    cGameMIDlet.mCharBuffer[cGameCanvas.mHighScoreNameCurrentChar] = 73;
                    break;
                }
                cGameMIDlet.mCharBuffer[cGameCanvas.mHighScoreNameCurrentChar] = 71;
                break;
            }
            case 53: {
                if (mCharBuffer[cGameCanvas.mHighScoreNameCurrentChar] == 'J') {
                    cGameMIDlet.mCharBuffer[cGameCanvas.mHighScoreNameCurrentChar] = 75;
                    break;
                }
                if (mCharBuffer[cGameCanvas.mHighScoreNameCurrentChar] == 'K') {
                    cGameMIDlet.mCharBuffer[cGameCanvas.mHighScoreNameCurrentChar] = 76;
                    break;
                }
                cGameMIDlet.mCharBuffer[cGameCanvas.mHighScoreNameCurrentChar] = 74;
                break;
            }
            case 54: {
                if (mCharBuffer[cGameCanvas.mHighScoreNameCurrentChar] == 'M') {
                    cGameMIDlet.mCharBuffer[cGameCanvas.mHighScoreNameCurrentChar] = 78;
                    break;
                }
                if (mCharBuffer[cGameCanvas.mHighScoreNameCurrentChar] == 'N') {
                    cGameMIDlet.mCharBuffer[cGameCanvas.mHighScoreNameCurrentChar] = 79;
                    break;
                }
                cGameMIDlet.mCharBuffer[cGameCanvas.mHighScoreNameCurrentChar] = 77;
                break;
            }
            case 55: {
                if (mCharBuffer[cGameCanvas.mHighScoreNameCurrentChar] == 'P') {
                    cGameMIDlet.mCharBuffer[cGameCanvas.mHighScoreNameCurrentChar] = 81;
                    break;
                }
                if (mCharBuffer[cGameCanvas.mHighScoreNameCurrentChar] == 'Q') {
                    cGameMIDlet.mCharBuffer[cGameCanvas.mHighScoreNameCurrentChar] = 82;
                    break;
                }
                if (mCharBuffer[cGameCanvas.mHighScoreNameCurrentChar] == 'R') {
                    cGameMIDlet.mCharBuffer[cGameCanvas.mHighScoreNameCurrentChar] = 83;
                    break;
                }
                cGameMIDlet.mCharBuffer[cGameCanvas.mHighScoreNameCurrentChar] = 80;
                break;
            }
            case 56: {
                if (mCharBuffer[cGameCanvas.mHighScoreNameCurrentChar] == 'T') {
                    cGameMIDlet.mCharBuffer[cGameCanvas.mHighScoreNameCurrentChar] = 85;
                    break;
                }
                if (mCharBuffer[cGameCanvas.mHighScoreNameCurrentChar] == 'U') {
                    cGameMIDlet.mCharBuffer[cGameCanvas.mHighScoreNameCurrentChar] = 86;
                    break;
                }
                cGameMIDlet.mCharBuffer[cGameCanvas.mHighScoreNameCurrentChar] = 84;
                break;
            }
            case 57: {
                if (mCharBuffer[cGameCanvas.mHighScoreNameCurrentChar] == 'W') {
                    cGameMIDlet.mCharBuffer[cGameCanvas.mHighScoreNameCurrentChar] = 88;
                    break;
                }
                if (mCharBuffer[cGameCanvas.mHighScoreNameCurrentChar] == 'X') {
                    cGameMIDlet.mCharBuffer[cGameCanvas.mHighScoreNameCurrentChar] = 89;
                    break;
                }
                if (mCharBuffer[cGameCanvas.mHighScoreNameCurrentChar] == 'Y') {
                    cGameMIDlet.mCharBuffer[cGameCanvas.mHighScoreNameCurrentChar] = 90;
                    break;
                }
                cGameMIDlet.mCharBuffer[cGameCanvas.mHighScoreNameCurrentChar] = 87;
            }
        }
        cGameCanvas.mHighScoreName[cGameCanvas.mHighScoreIdx + n2] = new String(mCharBuffer);
    }

    protected void SaveSettings() {
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)"Settings", (boolean)true);
            byte[] byArray = new byte[]{(byte)cGameCanvas.mAnimSpeed, (byte)cGameCanvas.mLastHighscoreEntry[0], (byte)cGameCanvas.mLastHighscoreEntry[1], (byte)cGameCanvas.mLastHighscoreEntry[2], (byte)cGameCanvas.mNbFannedCards, cGameCanvas.mNbCardToMove, cGameCanvas.mTakingLastCardOfStack, cGameCanvas.mTakeAll, cGameCanvas.mOrigPile, cGameCanvas.mDestPile, (byte)cGameCanvas.mOrigCardX, (byte)cGameCanvas.mOrigCardY, (byte)cGameCanvas.mDestCardX, (byte)cGameCanvas.mDestCardY, cGameCanvas.mCardToTurnIdx, (byte)cGameCanvas.mCurrentHandX, (byte)cGameCanvas.mCurrentHandY, (byte)cGameCanvas.mJitterX, (byte)cGameCanvas.mJitterY, (byte)cGameCanvas.mOrigHandX, (byte)cGameCanvas.mOrigHandY, (byte)cGameCanvas.mDestHandX, (byte)cGameCanvas.mDestHandY, cGameCanvas.mOrigPileOfMovingCard, cGameCanvas.mVisibleOnDeck, cGameCanvas.mHandOnDraw, (byte)cGameCanvas.iDropCardCounter, (byte)cGameCanvas.mModeTimer, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
            System.arraycopy(cGameCanvas.mCardToMove, 0, byArray, 28, cGameCanvas.mCardToMove.length);
            if (recordStore.getNumRecords() == 0) {
                recordStore.addRecord(byArray, 0, byArray.length);
            } else {
                recordStore.setRecord(1, byArray, 0, byArray.length);
            }
            recordStore.closeRecordStore();
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
    }

    public void run() {
        while (!this.THREAD_STOP) {
            if (cGameCanvas.paused) {
                Thread.yield();
                continue;
            }
            this.mGameCanvas.repaint();
            this.mGameCanvas.serviceRepaints();
        }
    }

    static {
        mSoundBnk = new Player[9];
        mSoundBytes = new byte[9][];
        var = 305419896L;
        soundDims = new int[]{201, 307, 1001, 231, 219, 201, 835, 439, 1391};
        soundNames = new String[]{"/dropcard.mid", "/error.mid", "/jackpot.mid", "/turncard.mid", "/takeallcards.mid", "/takecard.mid", "/youwin.mid", "/youlose.mid", "/title.mid"};
    }
}

