/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.Calendar;
import java.util.Random;

public class Boxer {
    public static final short PC_HP_BASE = 400;
    public static final short PC_HP_INC = 40;
    public static final short PC_STA_BASE = 100;
    public static final short PC_STA_INC = 15;
    public static String[] randomName = new String[]{"Iron", "Rock", "Animal", "Eagle", "King", "Great", "Shark", "Shadow", "Sabre", "Zebra", "Turtle", "Tiger", "Cheetah", "Devil", "Duke", "Dragon", "Hyper", "Big", "Quick"};
    public static String[] randomName2 = new String[]{"Smith", "Jones", "Gonzales", "Jackson", "Harris", "Graham", "Chang", "Tanaka", "McDuck", "Williams", "Taylor", "Walker", "White", "Martin", "Lewis", "Morris", "Baker", "Morgan", "Lee", "Miller", "Cook", "Price", "Hunt", "Fisher", "Ryan", "Owen", "Jack", "Foster", "Leone", "Lipi", "Moratti", "Carter", "Rossi", "James", "Palmer", "Mills", "Patel", "Murphy", "Brown", "Ho", "Greene", "Clark", "Scott"};
    public static final short[] NPC_HP_BASE = new short[]{150, 200, 300, 360, 420, 450, 465, 480, 490};
    public static final short[] NPC_HP_INC = new short[]{40, 40, 40, 40, 40, 40, 40, 40, 40};
    public static final short[] NPC_STA_BASE = new short[]{100, 110, 120, 130, 140, 150, 160, 170, 180};
    public static final short[] NPC_STA_INC = new short[]{10, 10, 10, 10, 10, 10, 10, 10, 10};
    public static final short[] NPC_GUARD = new short[]{75, 100, 105, 110, 115, 120, 125, 130, 135};
    public static final short[][] DMG_TBL = new short[][]{{5, 6, 7, 8, 9, 10, 11}, {7, 9, 10, 12, 13, 15, 16}, {13, 15, 18, 20, 22, 25, 27}, {4, 5, 5, 6, 6, 7, 7}, {5, 6, 7, 8, 9, 10, 11}, {10, 12, 14, 16, 18, 20, 22}};
    public static final short[][] STA_DMG_TBL = new short[][]{{0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1}};
    public static final short[] STA_COST = new short[]{10, 14, 18, 10, 14, 18, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0};
    public static final short STA_MIN = -50;
    public static final short STA_GAIN = 80;
    public static final short[] FRAME_MAX = new short[]{5, 6, 8, 5, 6, 8, 1, 1, 6, 3, 3, 8, 8, 10000, 10000, 8, 8};
    public static final short[] HIT_FRAME = new short[]{4, 4, 5, 4, 4, 5};
    public static final short[][] COUNTER_DMG = new short[][]{{120, 130, 150, 150, 120}, {120, 130, 150, 150, 130, 120}, {120, 120, 130, 150, 150, 130, 130, 120}, {120, 130, 150, 150, 120}, {120, 130, 150, 150, 130, 120}, {120, 120, 130, 150, 150, 130, 130, 120}};
    public static final short[] COUNTER_DMG_SWAY = new short[]{0, 0, 0, 0, 0, 150};
    public static final byte CONTROL_BASE = 22;
    public static final byte[][] CONTROL_INC = new byte[][]{{34, 0, 0, 0, 0, 0, 0}, {14, 20, 0, 0, 0, 0, 0}, {14, 20, 0, 0, 0, 0, 0}, {14, 20, 0, 0, 0, 0, 0}, {0, 0, 0, 17, 17, 0, 0}};
    public static final byte COMBINATION_BASE1 = 15;
    public static final byte COMBINATION_BASE2 = 91;
    public static final byte[][] COMBINATION_INC = new byte[][]{{30, 0, 0, 0, 0, 0, 0}, {0, 30, 0, 0, 0, 0, 0}, {0, 0, 30, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 30, 0}, {0, 0, 0, 30, 30, 0, 0}};
    public static final short GUARD_CHECK_FRAME = 2;
    public static final short GUARD_MIN = 4;
    public static final short GUARD_MAX = 20;
    public static final short GUARD_RECOVER = 10;
    public static final short DELAY_FRAME = 2;
    public static final short NUM_FACES = 6;
    public static final short NUM_TRAININGS = 3;
    public static final short NUM_PUNCHES = 6;
    public static final short ACTION_JAB = 0;
    public static final short ACTION_STRAIGHT = 1;
    public static final short ACTION_HOOK = 2;
    public static final short ACTION_BODY_L = 3;
    public static final short ACTION_BODY_R = 4;
    public static final short ACTION_UPPER = 5;
    public static final short ACTION_GUARD_U = 6;
    public static final short ACTION_GUARD_D = 7;
    public static final short ACTION_SWAY = 8;
    public static final short ACTION_HIT_R = 9;
    public static final short ACTION_HIT_L = 10;
    public static final short ACTION_DOWN_R = 11;
    public static final short ACTION_DOWN_L = 12;
    public static final short ACTION_REST_R = 13;
    public static final short ACTION_REST_L = 14;
    public static final short ACTION_STAND_R = 15;
    public static final short ACTION_STAND_L = 16;
    public static final short NAME_LEN = 12;
    public static final short DATE_LEN = 8;
    public String name;
    public short face;
    public short weight;
    public short rank;
    public short hpMax;
    public short staMax;
    public short guard;
    public short sway;
    public short win;
    public short lose;
    public short draw;
    public short ko;
    public short koTime;
    public short[] training = new short[3];
    public short[] pTraining = new short[5];
    public short[] punch = new short[5];
    public short[] dmg = new short[6];
    public short[] staDmg = new short[6];
    public short[][] control = new short[7][7];
    public short[][] combination = new short[6][7];
    public boolean retired;
    public String lastMatch;
    public short hp;
    public short sta;
    public short staLim;
    public short staLow;
    public boolean staOver;
    public short down;
    public short downTotal;
    public short downCount;
    public boolean waitFight;
    public short dmgAdj;
    public short lastAction;
    public short nextAction;
    public short actionFrame;
    public short delayFrame;
    public short lastActTime;
    public short lastGuard;
    public short guardRecover;
    public boolean hitNow;
    public String hitMes;
    public short hitPunch;
    public boolean counterHit;
    public boolean guardNow;
    public boolean swayNow;
    public boolean staSlow;
    public boolean swaySlow;
    public short slowCount;
    public boolean arena = false;
    protected static Random rand;
    public int[] usepunch = new int[5];
    public static String[] PUNCH_NAME;

    public boolean read(DataInputStream dataInputStream) throws Exception {
        int n;
        boolean bl;
        int n2 = dataInputStream.readByte();
        if (n2 == 11) {
            bl = true;
        } else if (n2 == 12) {
            bl = false;
        } else {
            throw new DataNotFoundException();
        }
        byte[] byArray = new byte[12];
        n2 = 0;
        while (n2 < 12) {
            byte by = dataInputStream.readByte();
            if (by != 0) {
                byArray[n2] = by;
            }
            ++n2;
        }
        this.name = new String(byArray, 0, n2);
        this.face = dataInputStream.readShort();
        this.weight = dataInputStream.readShort();
        this.rank = dataInputStream.readShort();
        this.hpMax = dataInputStream.readShort();
        this.staMax = dataInputStream.readShort();
        this.guard = dataInputStream.readShort();
        this.sway = dataInputStream.readShort();
        this.win = dataInputStream.readShort();
        this.lose = dataInputStream.readShort();
        this.draw = dataInputStream.readShort();
        this.ko = dataInputStream.readShort();
        this.koTime = dataInputStream.readShort();
        if (bl && this.win > 1) {
            this.koTime = (short)(this.koTime + (this.win - 2) * 180);
        }
        n2 = 0;
        while (n2 < 5) {
            this.pTraining[n2] = dataInputStream.readShort();
            ++n2;
        }
        n2 = 0;
        while (n2 < 5) {
            this.punch[n2] = dataInputStream.readShort();
            ++n2;
        }
        n2 = 0;
        while (n2 < 7) {
            n = 0;
            while (n < 7) {
                this.control[n2][n] = dataInputStream.readShort();
                ++n;
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < 6) {
            n = 0;
            while (n < 7) {
                this.combination[n2][n] = dataInputStream.readShort();
                ++n;
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < 6) {
            this.dmg[n2] = dataInputStream.readShort();
            ++n2;
        }
        n2 = 0;
        while (n2 < 6) {
            this.staDmg[n2] = dataInputStream.readShort();
            ++n2;
        }
        this.retired = dataInputStream.readByte() == 1;
        byte[] byArray2 = new byte[8];
        n2 = 0;
        while (n2 < 8) {
            byte by = dataInputStream.readByte();
            if (by != 0) {
                byArray2[n2] = by;
            }
            ++n2;
        }
        this.lastMatch = new String(byArray2, 0, n2);
        this.arena = false;
        return false;
    }

    public void write(DataOutputStream dataOutputStream) throws Exception {
        int n;
        int n2;
        dataOutputStream.writeByte(12);
        byte[] byArray = this.name.getBytes();
        int n3 = 0;
        while (n3 < 12) {
            if (n3 < byArray.length) {
                dataOutputStream.writeByte(byArray[n3]);
            } else {
                dataOutputStream.writeByte(0);
            }
            ++n3;
        }
        dataOutputStream.writeShort(this.face);
        dataOutputStream.writeShort(this.weight);
        dataOutputStream.writeShort(this.rank);
        dataOutputStream.writeShort(this.hpMax);
        dataOutputStream.writeShort(this.staMax);
        dataOutputStream.writeShort(this.guard);
        dataOutputStream.writeShort(this.sway);
        dataOutputStream.writeShort(this.win);
        dataOutputStream.writeShort(this.lose);
        dataOutputStream.writeShort(this.draw);
        dataOutputStream.writeShort(this.ko);
        dataOutputStream.writeShort(this.koTime);
        int n4 = 0;
        while (n4 < 5) {
            dataOutputStream.writeShort(this.pTraining[n4]);
            ++n4;
        }
        int n5 = 0;
        while (n5 < 5) {
            dataOutputStream.writeShort(this.punch[n5]);
            ++n5;
        }
        int n6 = 0;
        while (n6 < 7) {
            n2 = 0;
            while (n2 < 7) {
                dataOutputStream.writeShort(this.control[n6][n2]);
                ++n2;
            }
            ++n6;
        }
        n2 = 0;
        while (n2 < 6) {
            n = 0;
            while (n < 7) {
                dataOutputStream.writeShort(this.combination[n2][n]);
                ++n;
            }
            ++n2;
        }
        n = 0;
        while (n < 6) {
            dataOutputStream.writeShort(this.dmg[n]);
            ++n;
        }
        int n7 = 0;
        while (n7 < 6) {
            dataOutputStream.writeShort(this.staDmg[n7]);
            ++n7;
        }
        dataOutputStream.writeByte(this.retired ? 1 : 0);
        byte[] byArray2 = this.lastMatch.getBytes();
        int n8 = 0;
        while (n8 < 8) {
            if (n8 < byArray2.length) {
                dataOutputStream.writeByte(byArray2[n8]);
            } else {
                dataOutputStream.writeByte(0);
            }
            ++n8;
        }
    }

    public void upload(DataOutputStream dataOutputStream) throws Exception {
    }

    public boolean readArena(DataInputStream dataInputStream) throws Exception {
        int n = dataInputStream.readByte();
        byte[] byArray = new byte[12];
        n = 0;
        while (n < 12) {
            byte by = dataInputStream.readByte();
            if (by != 0) {
                byArray[n] = by;
            }
            ++n;
        }
        this.name = new String(byArray, 0, n);
        this.face = dataInputStream.readShort();
        this.weight = dataInputStream.readShort();
        this.rank = dataInputStream.readShort();
        this.hpMax = dataInputStream.readShort();
        this.staMax = dataInputStream.readShort();
        this.guard = dataInputStream.readShort();
        this.sway = dataInputStream.readShort();
        this.win = dataInputStream.readShort();
        this.lose = dataInputStream.readShort();
        this.draw = dataInputStream.readShort();
        this.ko = dataInputStream.readShort();
        this.koTime = dataInputStream.readShort();
        if (this.win > 1) {
            this.koTime = (short)(this.koTime + (this.win - 2) * 180);
        }
        byte[] byArray2 = new byte[8];
        n = 0;
        while (n < 8) {
            byte by = dataInputStream.readByte();
            if (by != 0) {
                byArray2[n] = by;
            }
            ++n;
        }
        this.lastMatch = new String(byArray2, 0, n);
        this.arena = true;
        return false;
    }

    public void writeArena(DataOutputStream dataOutputStream) throws Exception {
        dataOutputStream.writeByte(0);
        byte[] byArray = this.name.getBytes();
        int n = 0;
        while (n < 12) {
            if (n < byArray.length) {
                dataOutputStream.writeByte(byArray[n]);
            } else {
                dataOutputStream.writeByte(0);
            }
            ++n;
        }
        dataOutputStream.writeShort(this.face);
        dataOutputStream.writeShort(this.weight);
        dataOutputStream.writeShort(this.rank);
        dataOutputStream.writeShort(this.hpMax);
        dataOutputStream.writeShort(this.staMax);
        dataOutputStream.writeShort(this.guard);
        dataOutputStream.writeShort(this.sway);
        dataOutputStream.writeShort(this.win);
        dataOutputStream.writeShort(this.lose);
        dataOutputStream.writeShort(this.draw);
        dataOutputStream.writeShort(this.ko);
        dataOutputStream.writeShort(this.koTime);
        byte[] byArray2 = this.lastMatch.getBytes();
        int n2 = 0;
        while (n2 < 8) {
            if (n2 < byArray2.length) {
                dataOutputStream.writeByte(byArray2[n2]);
            } else {
                dataOutputStream.writeByte(0);
            }
            ++n2;
        }
    }

    public boolean isHiScore(Boxer boxer) {
        boolean bl = false;
        if (boxer == null) {
            return true;
        }
        if (this.win > boxer.win) {
            bl = true;
        }
        if (this.win < boxer.win) {
            bl = false;
        }
        if (this.win == boxer.win) {
            if (this.ko > boxer.ko) {
                bl = true;
            }
            if (this.ko < boxer.ko) {
                bl = false;
            }
            if (this.ko == boxer.ko) {
                if (this.lose < boxer.lose) {
                    bl = true;
                }
                if (this.lose > boxer.lose) {
                    bl = false;
                }
                if (this.lose == boxer.lose) {
                    if (this.koTime < boxer.koTime) {
                        bl = true;
                    }
                    if (this.koTime > boxer.koTime) {
                        bl = false;
                    }
                    if (this.koTime == boxer.koTime) {
                        bl = true;
                    }
                }
            }
        }
        return bl;
    }

    public void createRandomNPC(Boxer boxer) {
        String string = randomName[this.random(randomName.length)] + " " + randomName2[this.random(randomName.length)];
        short s = boxer.weight;
        short s2 = (short)(this.random(6) + 1);
        System.out.println("face:" + s2);
        short s3 = boxer.win;
        short s4 = s3 > 1 ? (short)this.random(s3 / 2) : (short)0;
        short s5 = this.random(8) == 0 ? (short)1 : 0;
        short[] sArray = new short[3];
        short[] sArray2 = new short[3];
        int n = 0;
        while (n < 3) {
            int n2 = this.random(3);
            this.training[n2] = (short)(this.training[n2] + 1);
            ++n;
        }
        int n3 = 0;
        while (n3 < 3) {
            sArray2[n3] = (short)this.random(5);
            ++n3;
        }
        short s6 = (short)(s3 * (3 + this.training[2] * 2) / 10);
        this.createBoxer(string, s, s2, this.training, sArray2, s3, s4, s5, s6, (short)0, (short)0);
    }

    public void createRandomRankNPC(Boxer boxer) {
        String string = randomName[this.random(randomName.length)] + " " + randomName2[this.random(randomName.length)];
        short s = boxer.weight;
        short s2 = (short)(this.random(6) + 1);
        System.out.println("face:" + s2);
        short s3 = boxer.win;
        int n = 0;
        short s4 = s3 > 1 ? (short)this.random(s3 / 2) : (short)0;
        short s5 = this.random(8) == 0 ? (short)1 : 0;
        short s6 = 0;
        if (s3 >= 8) {
            if (s3 == 8) {
                s3 = 9;
                s6 = (short)(this.random(10) + 1);
            } else if (s3 == 9) {
                s3 = 10;
                s6 = 11;
            } else if (s3 == 10) {
                s3 = 11;
                s6 = 12;
            } else {
                s3 = 9;
                s6 = (short)(this.random(10) + 1);
            }
            n = (short)(s3 - 8);
        }
        short[] sArray = new short[3];
        short[] sArray2 = new short[3];
        int n2 = 0;
        while (n2 < 3 + n) {
            int n3 = this.random(3);
            this.training[n3] = (short)(this.training[n3] + 1);
            ++n2;
        }
        int n4 = 0;
        while (n4 < 3) {
            sArray2[n4] = (short)this.random(5);
            ++n4;
        }
        short s7 = (short)(s3 * (3 + this.training[2] * 2) / 10);
        this.createBoxer(string, s, s2, this.training, sArray2, s3, s4, s5, s7, s6, (short)0);
    }

    public void createBoxer(String string, short s, short s2, short[] sArray, short[] sArray2, short s3, short s4, short s5, short s6, short s7, short s8) {
        int n;
        int n2;
        this.name = string;
        this.weight = s;
        this.face = s2;
        this.win = s3;
        this.lose = s4;
        this.draw = s5;
        this.ko = s6;
        this.koTime = (short)((180 + this.random(60)) * s6);
        this.rank = s7;
        if (s3 > 8) {
            s3 = (short)8;
        }
        if (s8 == 0) {
            this.hpMax = (short)((NPC_HP_BASE[s3] + sArray[0] * NPC_HP_INC[s3]) * (15 + s) / 16);
            this.staMax = (short)(NPC_STA_BASE[s3] + sArray[1] * NPC_STA_INC[s3]);
        } else {
            this.hpMax = (short)((400 + sArray[0] * NPC_HP_INC[s3]) * (15 + s) / 16);
            this.staMax = (short)(100 + sArray[1] * NPC_STA_INC[s3]);
        }
        this.guard = NPC_GUARD[s3];
        this.sway = (short)(this.guard / 2);
        int n3 = 0;
        while (n3 < this.punch.length) {
            this.pTraining[n3] = 0;
            this.punch[n3] = sArray[2];
            ++n3;
        }
        int n4 = 0;
        while (n4 < this.control.length) {
            n2 = 0;
            while (n2 < this.control[n4].length) {
                this.control[n4][n2] = 22;
                ++n2;
            }
            ++n4;
        }
        n2 = 0;
        while (n2 < this.combination.length) {
            n = 0;
            while (n < this.combination[n2].length - 1) {
                this.combination[n2][n] = 15;
                ++n;
            }
            this.combination[n2][n] = 91;
            ++n2;
        }
        n = 0;
        while (n < sArray2.length) {
            int n5;
            short s9 = sArray2[n];
            this.pTraining[s9] = (short)(this.pTraining[s9] + 1);
            short s10 = sArray2[n];
            this.punch[s10] = (short)(this.punch[s10] + 1);
            int n6 = 0;
            while (n6 < this.control.length) {
                n5 = 0;
                while (n5 < this.control[n6].length) {
                    short[] sArray3 = this.control[n6];
                    int n7 = n5;
                    sArray3[n7] = (short)(sArray3[n7] + CONTROL_INC[sArray2[n]][n5]);
                    ++n5;
                }
                ++n6;
            }
            n5 = 0;
            while (n5 < this.combination.length) {
                int n8 = 0;
                while (n8 < this.combination[n5].length) {
                    short[] sArray4 = this.combination[n5];
                    int n9 = n8;
                    sArray4[n9] = (short)(sArray4[n9] + COMBINATION_INC[sArray2[n]][n8]);
                    ++n8;
                }
                ++n5;
            }
            ++n;
        }
        this.updateDmg();
        this.lastMatch = "19700101";
        sArray[2] = 0;
        sArray[1] = 0;
        sArray[0] = 0;
    }

    public void updateDmg() {
        short[] sArray = new short[]{this.punch[0], this.punch[1], this.punch[2], this.punch[3], this.punch[3], this.punch[4]};
        int n = 0;
        while (n < this.dmg.length) {
            this.dmg[n] = DMG_TBL[n][sArray[n]];
            this.staDmg[n] = STA_DMG_TBL[n][sArray[n]];
            ++n;
        }
    }

    public void initBeforeMatch() {
        this.hp = this.hpMax;
        this.sta = this.staMax;
        this.staLim = this.staMax;
        this.staLow = 0;
        this.staOver = false;
        this.down = 0;
        this.downTotal = 0;
        this.downCount = 0;
        this.waitFight = false;
    }

    public void initBeforeRound() {
        this.sta = this.staLim;
        this.staOver = false;
        this.lastAction = (short)6;
        this.nextAction = (short)6;
        this.lastGuard = (short)6;
        this.actionFrame = 0;
        this.delayFrame = 0;
        this.down = 0;
        this.waitFight = false;
        this.guardRecover = (short)-1000;
    }

    public void nextNPCAction(Boxer boxer) {
        if (this.lastAction >= 11) {
            return;
        }
        if (this.nextAction >= 9) {
            return;
        }
        if (this.actionFrame < FRAME_MAX[this.lastAction] - 1) {
            return;
        }
        if (this.sta == this.staLim) {
            this.staOver = false;
        } else if (this.sta <= 0) {
            this.staOver = true;
        } else if (this.sta <= this.staLim / 3 && this.random(2) == 1 && boxer.win > 1) {
            this.staOver = true;
        } else if (this.sta > this.staLim * 6 / 10 && this.random(10) == 1) {
            this.staOver = false;
        }
        if (this.staOver && (this.random(30) != 1 || this.sta <= this.staLim / 3 || boxer.win <= 3)) {
            this.NPCGuard(boxer);
            return;
        }
        if (this.isPunch(this.lastAction)) {
            int n = 0;
            int n2 = 0;
            while (n2 < this.combination[this.lastAction].length) {
                n = (short)(n + this.combination[this.lastAction][n2]);
                ++n2;
            }
            int n3 = this.random(n);
            int n4 = 0;
            while (n4 < this.combination[this.lastAction].length - 1) {
                if (n3 < this.combination[this.lastAction][n4]) {
                    this.nextAction = (short)n4;
                    break;
                }
                n3 -= this.combination[this.lastAction][n4];
                ++n4;
            }
        } else {
            if (this.lastActTime <= this.random(17) + 4) {
                this.NPCGuard(boxer);
                return;
            }
            int n = this.isPunch(this.lastAction) ? (int)this.lastAction : 6;
            int n5 = 0;
            int n6 = 0;
            while (n6 < this.control[n].length) {
                n5 = (short)(n5 + this.control[n][n6]);
                ++n6;
            }
            int n7 = this.random(n5);
            int n8 = 0;
            while (n8 < this.control[n].length - 1) {
                if (n7 < this.control[n][n8]) {
                    this.nextAction = (short)n8;
                    break;
                }
                n7 -= this.control[n][n8];
                ++n8;
            }
            if (this.isUpPunch(this.nextAction)) {
                if (this.lastAction == 7) {
                    this.nextAction = (short)6;
                }
            } else if (this.isDownPunch(this.nextAction)) {
                if (this.lastAction == 7) {
                    this.nextAction = (short)7;
                }
            } else if (this.isGuard(this.nextAction)) {
                this.NPCGuard(boxer);
            }
        }
    }

    public void NPCGuard(Boxer boxer) {
        short s = this.guard;
        short s2 = this.sway;
        if (this.guardRecover > 0) {
            s = (short)(this.guard * (10 - this.guardRecover) / 10);
            s2 = (short)(this.sway * (10 - this.guardRecover) / 10);
            this.guardRecover = (short)(this.guardRecover - 1);
        }
        if (this.isPunch(boxer.lastAction)) {
            if (boxer.actionFrame == 2 && this.random(256) < s / 2) {
                if (this.isUpPunch(boxer.lastAction)) {
                    this.nextAction = (short)6;
                } else if (this.isDownPunch(boxer.lastAction)) {
                    this.nextAction = (short)7;
                }
            } else if (this.random(256) < s2 / 4) {
                this.nextAction = (short)8;
            }
        } else if (this.random(256) < s2 / 16) {
            this.nextAction = (short)8;
        }
    }

    public void process(Boxer boxer) {
        if (!(this.lastAction != 9 && this.lastAction != 10 || this.nextAction != 6 && this.nextAction != 7)) {
            this.lastGuard = this.nextAction;
        }
        if (this.actionFrame == FRAME_MAX[this.lastAction] - 1 && this.slowCount == 0 || this.hitNow || this.isRest(this.lastAction) && this.actionFrame >= this.downCount * 6 - FRAME_MAX[12] - FRAME_MAX[16]) {
            if (this.staSlow) {
                this.staSlow = false;
            }
            if (this.swaySlow) {
                this.swaySlow = false;
            }
            if (this.nextAction == 6 || this.nextAction == 7) {
                if (this.isPunch(this.lastAction)) {
                    this.lastActTime = 1;
                } else if (this.lastActTime < 255 && this.isGuard(this.lastAction)) {
                    this.lastActTime = (short)(this.lastActTime + 1);
                }
            } else if (this.lastActTime != 0) {
                this.lastActTime = 0;
            }
            if (this.lastAction == 6) {
                this.lastGuard = (short)6;
            } else if (this.lastAction == 7) {
                this.lastGuard = (short)7;
            }
            if (this.waitFight && (this.isPunch(this.nextAction) || this.nextAction == 8)) {
                this.nextAction = this.lastGuard;
            }
            if (this.isLeftPunch(this.lastAction) && this.isLeftPunch(this.nextAction) || this.isRightPunch(this.lastAction) && this.isRightPunch(this.nextAction)) {
                this.delayFrame = (short)2;
            }
            this.lastAction = this.nextAction;
            this.actionFrame = 0;
            switch (this.nextAction) {
                case 0: 
                case 1: 
                case 2: 
                case 6: {
                    this.nextAction = (short)6;
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 7: {
                    this.nextAction = (short)7;
                    break;
                }
                case 8: 
                case 9: 
                case 10: {
                    this.nextAction = this.lastGuard;
                    break;
                }
                case 12: {
                    this.nextAction = (short)14;
                    break;
                }
                case 11: {
                    this.nextAction = (short)13;
                    break;
                }
                case 14: {
                    this.nextAction = (short)16;
                    break;
                }
                case 13: {
                    this.nextAction = (short)15;
                    break;
                }
                case 15: 
                case 16: {
                    this.nextAction = (short)6;
                }
            }
            if (STA_COST[this.lastAction] > 0) {
                short s = this.sta;
                this.sta = (short)(this.sta - STA_COST[this.lastAction]);
                if (this.sta < -50) {
                    this.sta = (short)-50;
                }
                if (s > 0 && this.sta <= 0) {
                    this.staLow = (short)(this.staLow + 1);
                }
            } else {
                this.sta = (short)(this.sta + this.staMax / 80);
                if (this.sta > this.staLim) {
                    this.sta = this.staLim;
                }
            }
            if (this.sta <= 0) {
                this.staSlow = true;
            }
            if (this.lastAction < 8) {
                this.slowCount = (short)(this.staSlow ? (this.swaySlow ? 3 : 1) : (this.swaySlow ? 1 : 0));
            }
            if ((this.lastAction == 9 || this.lastAction == 10) && this.counterHit) {
                this.slowCount = 1;
            }
        } else if (this.slowCount > 0) {
            this.slowCount = (short)(this.slowCount - 1);
        } else {
            if (this.delayFrame > 0) {
                this.delayFrame = (short)(this.delayFrame - 1);
            } else {
                this.actionFrame = (short)(this.actionFrame + 1);
            }
            if (this.lastAction < 8) {
                this.slowCount = (short)(this.staSlow ? (this.swaySlow ? 3 : 1) : (this.swaySlow ? 1 : 0));
            }
            if ((this.lastAction == 9 || this.lastAction == 10) && this.counterHit) {
                this.slowCount = 1;
            }
        }
    }

    public void hitCheck(Boxer boxer) {
        this.hitNow = false;
        this.guardNow = false;
        this.swayNow = false;
        if (this.isPunch(boxer.lastAction) && boxer.actionFrame == HIT_FRAME[boxer.lastAction] && boxer.slowCount == 0) {
            this.hitMes = "";
            System.gc();
            if (this.isPunch(this.lastAction) || this.lastAction == 10 || this.lastAction == 9) {
                this.doHit(boxer);
            } else if (this.lastAction == 6) {
                if (this.isUpPunch(boxer.lastAction)) {
                    this.doGuard(boxer);
                } else {
                    this.doHit(boxer);
                }
            } else if (this.lastAction == 7) {
                if (this.isDownPunch(boxer.lastAction)) {
                    this.doGuard(boxer);
                } else {
                    this.doHit(boxer);
                }
            } else if (this.lastAction == 8) {
                if (this.actionFrame == 5) {
                    this.doHit(boxer);
                } else {
                    this.doSway(boxer);
                }
            }
        }
    }

    public void doGuard(Boxer boxer) {
        this.guardNow = true;
        this.hitPunch = boxer.lastAction;
    }

    public void doSway(Boxer boxer) {
        this.swayNow = true;
        boxer.swaySlow = true;
    }

    public void doHit(Boxer boxer) {
        int n;
        this.hitNow = true;
        this.hitPunch = boxer.lastAction;
        this.guardRecover = (short)10;
        if (this.isPunch(this.lastAction)) {
            n = COUNTER_DMG[this.lastAction][this.actionFrame];
            this.hitMes = "COUNTER!!";
        } else if (this.lastAction == 8) {
            n = COUNTER_DMG_SWAY[this.actionFrame];
            this.hitMes = "COUNTER!!";
        } else {
            n = 100;
        }
        if (this.lastAction == 10 || this.lastAction == 9) {
            this.hitMes = " 2 HITS!!";
        }
        this.counterHit = n > 100;
        this.hp = (short)(this.hp - boxer.dmg[boxer.lastAction] * n * (9 + boxer.weight) / 1000);
        if (this.hp < 0) {
            this.hp = 0;
        }
        this.sta = (short)(this.sta - boxer.staDmg[boxer.lastAction] * n / 100);
        if (this.sta < -50) {
            this.sta = (short)-50;
        }
        this.staLim = (short)(this.staLim - boxer.staDmg[boxer.lastAction]);
        if (this.staLim < 0) {
            this.staLim = 0;
        }
        this.nextAction = this.isLeftPunch(boxer.lastAction) ? (short)(this.hp > 0 ? 10 : 12) : (short)(this.hp > 0 ? 9 : 11);
        if (this.nextAction == 12 || this.nextAction == 11) {
            this.downCount = (short)(boxer.dmg[boxer.lastAction] * (15 + boxer.weight) / 160 + 3 + this.downTotal * 2);
            if (this.downCount < 3) {
                this.downCount = (short)3;
            }
            if (this.downCount >= 10) {
                this.downCount = (short)20;
            }
            this.down = (short)(this.down + 1);
            this.downTotal = (short)(this.downTotal + 1);
            this.waitFight = true;
            boxer.waitFight = true;
        }
    }

    public void learn() {
        if (this.isPunch(this.lastAction) && this.actionFrame == FRAME_MAX[this.lastAction] - 1) {
            int n;
            int n2 = n = this.isPunch(this.nextAction) ? (int)this.nextAction : 6;
            if (this.nextAction <= 8 && this.combination[this.lastAction][n] < 200) {
                int n3 = 0;
                while (n3 < this.combination[this.lastAction].length) {
                    if (this.combination[this.lastAction][n3] > 0) {
                        short[] sArray = this.combination[this.lastAction];
                        int n4 = n3;
                        sArray[n4] = (short)(sArray[n4] - 1);
                        short[] sArray2 = this.combination[this.lastAction];
                        int n5 = n;
                        sArray2[n5] = (short)(sArray2[n5] + 1);
                    }
                    ++n3;
                }
            }
        }
        if (this.hitNow && this.isGuard(this.lastAction) && this.guard > 0) {
            this.guard = (short)(this.guard - 1);
        }
        if (this.guardNow && this.guard < 255) {
            this.guard = (short)(this.guard + 1);
        }
        if (this.hitNow && this.isDefence(this.lastAction) && this.sway > 0) {
            this.sway = (short)(this.sway - 1);
        }
        if (this.swayNow && this.sway < 255) {
            this.sway = (short)(this.sway + 1);
        }
    }

    public void growUp(int n, int n2, int n3) {
        if (n == 1) {
            this.win = (short)(this.win + 1);
        } else if (n == 2) {
            this.lose = (short)(this.lose + 1);
        } else {
            this.draw = (short)(this.draw + 1);
        }
        if (n == 1 && (n2 == 1 || n2 == 2)) {
            this.koTime = (short)(this.koTime + ((Match.round - 1) * 180 + n3 / 6));
            this.ko = (short)(this.ko + 1);
        }
        if (this.win + this.lose + this.draw == 31 || this.win >= 11 && n == 2) {
            this.retired = true;
        }
        BoxingCanvas.upParam = "";
        if (this.win < 14) {
            if (this.win % 2 == 1) {
                int n4 = this.random(2);
                if (n4 == 0 && this.downTotal > 0) {
                    this.hpMax = (short)(this.hpMax + 20);
                    BoxingCanvas.upParam = "Health+20";
                } else if (n4 == 1 && this.staLow >= 5) {
                    this.staMax = (short)(this.staMax + 20);
                    BoxingCanvas.upParam = "Stamina+20";
                } else {
                    int n5 = 0;
                    while (n5 < 200) {
                        int n6 = this.random(5);
                        if (this.usepunch[n6] < 10) {
                            ++n5;
                            continue;
                        }
                        if (this.pTraining[n6] > 2) {
                            ++n5;
                            continue;
                        }
                        int n7 = n6;
                        this.pTraining[n7] = (short)(this.pTraining[n7] + 1);
                        int n8 = n6;
                        this.punch[n8] = (short)(this.punch[n8] + 1);
                        BoxingCanvas.upParam = PUNCH_NAME[n6] + "+1 ";
                        break;
                    }
                }
            } else {
                this.hpMax = (short)(this.hpMax + 10);
                BoxingCanvas.upParam = "Health+10";
            }
        }
    }

    public boolean canAction() {
        return this.nextAction <= 8;
    }

    private boolean isPunch(short s) {
        return s <= 5;
    }

    private boolean isGuard(short s) {
        return s == 6 || s == 7;
    }

    private boolean isDefence(short s) {
        return s >= 6 && s <= 8;
    }

    private boolean isRest(short s) {
        return s == 14 || s == 13;
    }

    private boolean isLeftPunch(short s) {
        return s == 0 || s == 3;
    }

    private boolean isRightPunch(short s) {
        return s == 1 || s == 2 || s == 4 || s == 5;
    }

    private boolean isUpPunch(short s) {
        return s == 0 || s == 1 || s == 2;
    }

    private boolean isDownPunch(short s) {
        return s == 3 || s == 4 || s == 5;
    }

    public boolean isTKO() {
        return (this.lastAction == 11 || this.lastAction == 12) && this.down == 3;
    }

    public boolean isKO() {
        return (this.lastAction == 13 || this.lastAction == 14) && this.actionFrame == 60 - FRAME_MAX[12];
    }

    public int random(int n) {
        int n2;
        if (rand == null) {
            rand = new Random(Calendar.getInstance().getTime().getTime());
        }
        while ((n2 = rand.nextInt()) <= 0) {
        }
        return n2 % n;
    }

    public String s2b(short s) {
        char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append('%');
        stringBuffer.append(cArray[s / 4096]);
        stringBuffer.append(cArray[s / 256 % 16]);
        stringBuffer.append('%');
        stringBuffer.append(cArray[s / 16 % 16]);
        stringBuffer.append(cArray[s % 16]);
        return new String(stringBuffer);
    }

    static {
        PUNCH_NAME = new String[]{"Jab", "Straight", "Hook", "Body", "Uppercut"};
    }
}

