/*
 * Decompiled with CFR 0.152.
 */
public class Match {
    public static final int FRAME_RATE = 6;
    public static final int ROUND_FRAME = 1080;
    public static final byte[] ROUND_MAX = new byte[]{2, 4, 4, 4, 4, 6, 6, 8, 10};
    public static final byte ROUND_MAX_RANKER = 10;
    public static final int RESULT_WIN = 1;
    public static final int RESULT_LOSE = 2;
    public static final int RESULT_DRAW = 3;
    public static final int END_KO = 1;
    public static final int END_TKO = 2;
    public static final int END_JUDGE = 3;
    public byte roundMax;
    public static byte round;
    public int time;
    public int downTime;
    public int waitTime;
    public int result;
    public int end;
    public boolean roundStart;
    public boolean roundEnd;
    public boolean matchEnd;
    public Boxer boxer1;
    public Boxer boxer2;

    public Match(Boxer boxer, Boxer boxer2) {
        this.boxer1 = boxer;
        this.boxer2 = boxer2;
        this.roundMax = (byte)(boxer.win >= ROUND_MAX.length ? 10 : ROUND_MAX[boxer.win]);
        round = 1;
        this.time = 0;
        this.downTime = 0;
        this.waitTime = 0;
        this.roundStart = false;
        this.roundEnd = false;
        this.matchEnd = false;
        this.result = 0;
        this.end = 0;
    }

    public void process() {
        if (!this.roundStart) {
            return;
        }
        this.boxer1.hitCheck(this.boxer2);
        this.boxer2.hitCheck(this.boxer1);
        if ((this.boxer1.nextAction >= 11 || this.boxer2.nextAction >= 11) && this.downTime == 0) {
            this.downTime = this.time;
            short s = this.boxer1.nextAction >= 11 ? this.boxer1.downCount : (short)0;
            short s2 = this.boxer2.nextAction >= 11 ? this.boxer2.downCount : (short)0;
            this.waitTime = 5 + this.downTime + (s > s2 ? s : s2) * 6;
        } else if (this.boxer1.lastAction < 11 && this.boxer2.lastAction < 11 && this.downTime != 0) {
            this.downTime = 0;
        }
        if (this.boxer1.waitFight && this.time == this.waitTime) {
            this.boxer1.waitFight = false;
            this.boxer2.waitFight = false;
            if (this.boxer1.hp == 0) {
                this.boxer1.hp = (short)(this.boxer1.hpMax / (this.boxer1.downTotal + 2));
            }
            if (this.boxer2.hp == 0) {
                this.boxer2.hp = (short)(this.boxer2.hpMax / (this.boxer2.downTotal + 2));
            }
        }
        if (this.boxer1.isTKO()) {
            if (this.boxer2.isTKO()) {
                this.setResult(3, 2);
                return;
            }
            this.setResult(2, 2);
            return;
        }
        if (this.boxer2.isTKO()) {
            this.setResult(1, 2);
            return;
        }
        if (this.boxer1.isKO()) {
            if (this.boxer2.isKO()) {
                this.setResult(3, 1);
                return;
            }
            this.setResult(2, 1);
            return;
        }
        if (this.boxer2.isKO()) {
            this.setResult(1, 1);
            return;
        }
        ++this.time;
        if (this.time > 1080 && !this.boxer1.waitFight && !this.boxer2.waitFight) {
            this.roundStart = false;
            this.roundEnd = true;
            round = (byte)(round + 1);
            this.time = 0;
            this.boxer1.initBeforeRound();
            this.boxer2.initBeforeRound();
            if (round > this.roundMax) {
                round = this.roundMax;
                if (this.boxer1.downTotal == this.boxer2.downTotal) {
                    this.setResult(3, 3);
                } else if (this.boxer1.downTotal < this.boxer2.downTotal) {
                    this.setResult(1, 3);
                } else {
                    this.setResult(2, 3);
                }
            }
            return;
        }
        this.boxer1.learn();
        this.boxer1.process(this.boxer2);
        this.boxer2.nextNPCAction(this.boxer1);
        this.boxer2.process(this.boxer1);
    }

    private void setResult(int n, int n2) {
        this.result = n;
        this.end = n2;
        this.matchEnd = true;
    }

    public String getResultStr(int n) {
        String string = "";
        if (n == 0) {
            string = this.end == 3 ? "Decision" : "KO";
        }
        if (n == 1) {
            string = this.result == 1 ? "Victory" : (this.result == 2 ? "Defeat" : "Draw");
        }
        return string;
    }
}

