/*
 * Decompiled with CFR 0.152.
 */
package be.aimproductions.doneIn50Secs;

import be.aimproductions.doneIn50Secs.GameScreen;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public final class DataProvider {
    private static int[] carRGBPalette = new int[256];
    private static int[] roadBlockRGBPalette;
    private static byte[] carBMPData;
    private static byte[] roadBlockBMPData;

    public static void releaseData() {
        int i = 0;
        while (i < GameScreen.roadBlocksImages.length) {
            GameScreen.roadBlocksImages[i] = null;
            i = (byte)(i + 1);
        }
        GameScreen.roadBlocksImages = null;
        i = 0;
        while (i < GameScreen.carsImages.length) {
            GameScreen.carsImages[i] = null;
            i = (byte)(i + 1);
        }
        GameScreen.carsImages = null;
        carRGBPalette = null;
        roadBlockRGBPalette = null;
        carBMPData = null;
        roadBlockBMPData = null;
    }

    public static Image getCarImage(byte ID, int rotation) {
        if (GameScreen.carsImages == null) {
            GameScreen.carsImages = new Image[29][4];
        }
        if (GameScreen.carsImages[ID][rotation] == null) {
            try {
                if (ID < 19) {
                    int imageHeight = 18;
                } else if (ID < 26) {
                    int imageHeight = 27;
                } else {
                    int imageHeight = 36;
                }
                GameScreen.carsImages[ID][rotation] = DataProvider.loadBMPFileCar("/c/" + (ID < 10 ? "0" : "") + ID, rotation);
            }
            catch (Throwable t) {
                return null;
            }
        }
        return GameScreen.carsImages[ID][rotation];
    }

    public static Image getRoadBlockImage(byte ID, int rotation) {
        if (GameScreen.roadBlocksImages == null) {
            GameScreen.roadBlocksImages = new Image[21][4];
        }
        try {
            if (GameScreen.roadBlocksImages[ID][rotation] == null) {
                GameScreen.roadBlocksImages[ID][rotation] = DataProvider.loadBMPFileRoadBlock("/r/" + (ID < 10 ? "0" : "") + ID, rotation);
            }
            return GameScreen.roadBlocksImages[ID][rotation];
        }
        catch (Throwable t) {
            return null;
        }
    }

    private static int get4ByteIntCar(int currOffset) {
        int result = carBMPData[currOffset] & 0xFF;
        int i = 3;
        while (i > 0) {
            result <<= 8;
            result |= carBMPData[--currOffset] & 0xFF;
            --i;
        }
        return result;
    }

    private static int getNextRGBCar(int currOffset) {
        int result = carBMPData[currOffset--] & 0xFF;
        int i = 2;
        while (i > 0) {
            result <<= 8;
            result |= carBMPData[currOffset--] & 0xFF;
            --i;
        }
        return result;
    }

    private static Image loadBMPFileCar(String name, int rotation) {
        Image result = null;
        try {
            InputStream bmpFile = ((Object)((Object)GameScreen.gameScreen)).getClass().getResourceAsStream(name);
            int readBytes = bmpFile.read(carBMPData);
            if (readBytes > 0) {
                int width = DataProvider.get4ByteIntCar(21);
                int height = DataProvider.get4ByteIntCar(25);
                int colors = DataProvider.get4ByteIntCar(29) >> 16;
                result = Image.createImage((int)(rotation == 0 || rotation == 2 ? width : height), (int)(rotation == 0 || rotation == 2 ? height : width));
                Graphics g = result.getGraphics();
                int adjustOffset = 4 - width * (colors / 8) % 4;
                int x = 0;
                int xInit = 0;
                int xOffset = 0;
                int y = 0;
                int yOffset = 0;
                boolean oddRotation = false;
                switch (rotation) {
                    case 0: {
                        xInit = 0;
                        x = 0;
                        xOffset = 1;
                        y = height - 1;
                        yOffset = -1;
                        break;
                    }
                    case 1: {
                        y = height - 1;
                        yOffset = -1;
                        x = xInit = width - 1;
                        xOffset = -1;
                        oddRotation = true;
                        break;
                    }
                    case 2: {
                        x = xInit = width - 1;
                        xOffset = -1;
                        y = 0;
                        yOffset = 1;
                        break;
                    }
                    case 3: {
                        y = 0;
                        yOffset = 1;
                        xInit = 0;
                        x = 0;
                        xOffset = 1;
                        oddRotation = true;
                    }
                }
                int currentOffset = 56;
                if (colors <= 8) {
                    int i = 0;
                    while (i < 256) {
                        DataProvider.carRGBPalette[i] = DataProvider.getNextRGBCar(currentOffset);
                        currentOffset += 4;
                        ++i;
                    }
                    byte lastColorIndex = 1;
                    byte currentColorIndex = 0;
                    int currentPixel = width * height - 1;
                    while (currentPixel > -1) {
                        if (lastColorIndex != (currentColorIndex = carBMPData[currentOffset++])) {
                            g.setColor(carRGBPalette[currentColorIndex]);
                            lastColorIndex = currentColorIndex;
                        }
                        if (oddRotation) {
                            g.fillRect(y, x, 1, 1);
                        } else {
                            g.fillRect(x, y, 1, 1);
                        }
                        if (currentPixel % width == 0) {
                            currentOffset += adjustOffset;
                            x = xInit;
                            y += yOffset;
                        } else {
                            x += xOffset;
                        }
                        --currentPixel;
                    }
                } else {
                    int lastColor = 1;
                    int currentColor = 0;
                    int currentPixel = width * height - 1;
                    while (currentPixel > -1) {
                        currentColor = DataProvider.getNextRGBCar(currentOffset);
                        if (lastColor != currentColor) {
                            g.setColor(currentColor);
                            lastColor = currentColor;
                        }
                        currentOffset += 3;
                        if (oddRotation) {
                            g.fillRect(y, x, 1, 1);
                        } else {
                            g.fillRect(x, y, 1, 1);
                        }
                        if (currentPixel % width == 0) {
                            currentOffset += adjustOffset;
                            x = xInit;
                            y += yOffset;
                        } else {
                            x += xOffset;
                        }
                        --currentPixel;
                    }
                }
            }
            bmpFile.close();
        }
        catch (Throwable t) {}
        return result;
    }

    private static int get4ByteIntRoadBlock(int currOffset) {
        int result = roadBlockBMPData[currOffset] & 0xFF;
        int i = 3;
        while (i > 0) {
            result <<= 8;
            result |= roadBlockBMPData[--currOffset] & 0xFF;
            --i;
        }
        return result;
    }

    private static int getNextRGBRoadBlock(int currOffset) {
        int result = roadBlockBMPData[currOffset--] & 0xFF;
        int i = 2;
        while (i > 0) {
            result <<= 8;
            result |= roadBlockBMPData[currOffset--] & 0xFF;
            --i;
        }
        return result;
    }

    private static Image loadBMPFileRoadBlock(String name, int rotation) {
        Image result = null;
        try {
            InputStream bmpFile = ((Object)((Object)GameScreen.gameScreen)).getClass().getResourceAsStream(name);
            int readBytes = bmpFile.read(roadBlockBMPData);
            if (readBytes > 0) {
                int width = DataProvider.get4ByteIntRoadBlock(21);
                int height = DataProvider.get4ByteIntRoadBlock(25);
                int colors = DataProvider.get4ByteIntRoadBlock(29) >> 16;
                result = Image.createImage((int)(rotation == 0 || rotation == 2 ? width : height), (int)(rotation == 0 || rotation == 2 ? height : width));
                Graphics g = result.getGraphics();
                int adjustOffset = 4 - width * (colors / 8) % 4;
                int x = 0;
                int xInit = 0;
                int xOffset = 0;
                int y = 0;
                int yOffset = 0;
                boolean oddRotation = false;
                switch (rotation) {
                    case 0: {
                        xInit = 0;
                        x = 0;
                        xOffset = 1;
                        y = height - 1;
                        yOffset = -1;
                        break;
                    }
                    case 1: {
                        y = height - 1;
                        yOffset = -1;
                        x = xInit = width - 1;
                        xOffset = -1;
                        oddRotation = true;
                        break;
                    }
                    case 2: {
                        x = xInit = width - 1;
                        xOffset = -1;
                        y = 0;
                        yOffset = 1;
                        break;
                    }
                    case 3: {
                        y = 0;
                        yOffset = 1;
                        xInit = 0;
                        x = 0;
                        xOffset = 1;
                        oddRotation = true;
                    }
                }
                int currentOffset = 56;
                if (colors <= 8) {
                    int i = 0;
                    while (i < 256) {
                        DataProvider.roadBlockRGBPalette[i] = DataProvider.getNextRGBRoadBlock(currentOffset);
                        currentOffset += 4;
                        ++i;
                    }
                    byte lastColorIndex = 1;
                    byte currentColorIndex = 0;
                    int currentPixel = width * height - 1;
                    while (currentPixel > -1) {
                        if (lastColorIndex != (currentColorIndex = roadBlockBMPData[currentOffset++])) {
                            g.setColor(roadBlockRGBPalette[currentColorIndex]);
                            lastColorIndex = currentColorIndex;
                        }
                        if (oddRotation) {
                            g.fillRect(y, x, 1, 1);
                        } else {
                            g.fillRect(x, y, 1, 1);
                        }
                        if (currentPixel % width == 0) {
                            currentOffset += adjustOffset;
                            x = xInit;
                            y += yOffset;
                        } else {
                            x += xOffset;
                        }
                        --currentPixel;
                    }
                } else {
                    int lastColor = 1;
                    int currentColor = 0;
                    int currentPixel = width * height - 1;
                    while (currentPixel > -1) {
                        currentColor = DataProvider.getNextRGBRoadBlock(currentOffset);
                        if (lastColor != currentColor) {
                            g.setColor(currentColor);
                            lastColor = currentColor;
                        }
                        currentOffset += 3;
                        if (oddRotation) {
                            g.fillRect(y, x, 1, 1);
                        } else {
                            g.fillRect(x, y, 1, 1);
                        }
                        if (currentPixel % width == 0) {
                            currentOffset += adjustOffset;
                            x = xInit;
                            y += yOffset;
                        } else {
                            x += xOffset;
                        }
                        --currentPixel;
                    }
                }
            }
            bmpFile.close();
        }
        catch (Throwable t) {}
        return result;
    }

    static {
        carBMPData = new byte[1511];
        roadBlockRGBPalette = new int[256];
        roadBlockBMPData = new byte[1511];
    }
}

