/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.Background;
import game.Barrier;
import game.Clone;
import game.Items;
import game.MCanvas;
import game.MedveD;
import game.MovingSprite;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Layer;
import javax.microedition.lcdui.game.LayerManager;
import javax.microedition.lcdui.game.Sprite;
import javax.microedition.lcdui.game.TiledLayer;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;

public class MManager
extends LayerManager {
    private Player musicPlayer = null;
    static int quakeCounter = -1;
    static int explosionX = -1;
    static int explosionY = -1;
    static int godMode = 0;
    static int timeEffect = 100;
    private boolean isSpeedUp = false;
    private boolean isMatrix = false;
    private int[] oldShootSpeed = new int[10];
    private int[] oldSpeedEnemy;
    static int CANVAS_X;
    static int CANVAS_Y;
    static int DISP_WIDTH;
    static int DISP_HEIGHT;
    int cameraX;
    int cameraY;
    int ticksSynchro = 0;
    MCanvas myCanvas;
    MedveD myHero;
    Clone[] myENEMIES;
    private int countLifeEnemies = 0;
    static int indexEnemy;
    static int crossFlash;
    MovingSprite[] shoot;
    Sprite[] bullets;
    Sprite[] healthAndArmor;
    Sprite[] stims;
    Sprite[] Explosion;
    Items[] flowers;
    Items[] chairs;
    Items[] tables;
    Items[] banches;
    private int[] firePause;
    private int[] scoreShowing;
    private int[] scoreShowingTime;
    Sprite exitLevel;
    Sprite[] shootFog;
    private boolean isNextLevel = false;
    Background myBackground;
    Barrier myBarrier;
    int movementSpeedX;
    int movementSpeedY;
    int speedFinal = 5;
    int oldMovementSpeed;
    static int myScore;
    static boolean isAutoCrosshair;
    static boolean isDrawCross;
    Items[] car;
    Items[] trees;
    Items[] traffic;
    Items[] flasks;
    int[] itemsParameters;
    private int[] fogTimeLife = new int[10];

    private static String guessContentType(String url) throws Exception {
        String ctype;
        if (url.endsWith("wav")) {
            ctype = "audio/x-wav";
        } else if (url.endsWith("jts")) {
            ctype = "audio/x-tone-seq";
        } else if (url.endsWith("mid")) {
            ctype = "audio/midi";
        } else {
            throw new Exception("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0442\u0438\u043f \u043f\u043e \u0441\u0441\u044b\u043b\u043a\u0435: " + url);
        }
        return ctype;
    }

    private void createMusicPlayer(String url) throws Exception {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream(url);
        String ctype = MManager.guessContentType(url);
        this.musicPlayer = Manager.createPlayer((InputStream)is, (String)ctype);
        this.musicPlayer.prefetch();
        this.musicPlayer.realize();
        this.musicPlayer.setLoopCount(-1);
    }

    private void changeVolume(Player player, int volume) {
        try {
            VolumeControl vc = (VolumeControl)player.getControl("VolumeControl");
            vc.setLevel(volume);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setSoundStop(Player player) throws Exception {
        player.stop();
    }

    private void setSoundStart(Player player) throws Exception {
        player.start();
        this.changeVolume(player, 40);
    }

    public void setMusicStart() {
        try {
            this.setSoundStart(this.musicPlayer);
        }
        catch (Exception e) {
            System.out.println("\u041e\u0448\u0438\u0431\u043a\u0430! \u041d\u0435\u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0437\u0430\u043f\u0443\u0441\u0442\u0438\u0442\u044c \u043c\u0443\u0437\u044b\u043a\u0443: " + e);
        }
    }

    public void setMusicStop() {
        try {
            this.setSoundStop(this.musicPlayer);
        }
        catch (Exception e) {
            System.out.println("\u041e\u0448\u0438\u0431\u043a\u0430! \u041d\u0435\u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0437\u0430\u043f\u0443\u0441\u0442\u0438\u0442\u044c \u043c\u0443\u0437\u044b\u043a\u0443: " + e);
        }
    }

    public void closeSounds() {
        try {
            this.musicPlayer.stop();
            this.musicPlayer.close();
            this.musicPlayer = null;
        }
        catch (Exception e) {
            System.out.println("\u041e\u0448\u0438\u0431\u043a\u0430! \u041d\u0435\u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0437\u0430\u043a\u0440\u044b\u0442\u044c \u0437\u0432\u0443\u043a: " + e);
        }
    }

    public int getScore() {
        return myScore;
    }

    public void setScore(int score) {
        myScore = score;
    }

    public MManager(int x, int y, int width, int height) {
        CANVAS_X = x;
        CANVAS_Y = y;
        DISP_WIDTH = width;
        DISP_HEIGHT = height;
        this.movementSpeedX = this.speedFinal;
        this.movementSpeedY = this.speedFinal;
    }

    public void setLoaded(int percent) {
        MCanvas.loadedProcess += percent;
    }

    public void loadResources() throws Exception {
        int i;
        int i2;
        int itemX;
        int index;
        int j;
        timeEffect = 100;
        this.myBarrier = null;
        this.myBackground = null;
        this.myHero = null;
        this.shoot = null;
        this.bullets = null;
        this.stims = null;
        this.myENEMIES = null;
        this.firePause = null;
        this.exitLevel = null;
        this.Explosion = null;
        this.healthAndArmor = null;
        this.itemsParameters = null;
        this.car = null;
        this.trees = null;
        this.traffic = null;
        this.tables = null;
        this.chairs = null;
        this.flowers = null;
        this.banches = null;
        this.flasks = null;
        System.gc();
        if (this.musicPlayer == null) {
            try {
                this.createMusicPlayer("/sound/m.mid");
            }
            catch (Exception e) {
                System.out.println("\u041e\u0448\u0438\u0431\u043a\u0430! \u041f\u0440\u0438 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u0438 \u043f\u043b\u0435\u0439\u0435\u0440\u0430 musicPlayer \u0432 \u0433\u043b\u0430\u0432\u043d\u043e\u043c \u043c\u0435\u043d\u044e: " + e);
            }
        }
        try {
            Thread.sleep(5000L);
        }
        catch (Exception e) {
            System.out.println("\u041e\u0448\u0438\u0431\u043a\u0430! \u043f\u0440\u0438 \u0437\u0430\u0434\u0435\u0440\u0436\u043a\u0435 \u043e\u0447\u0438\u0441\u0442\u043a\u0438 \u043f\u0430\u043c\u044f\u0442\u0438");
        }
        try {
            this.myBarrier = new Barrier();
        }
        catch (Exception e) {
            System.out.println("\u041e\u0448\u0438\u0431\u043a\u0430! \u041f\u0440\u0438 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u0438 \u0441\u0442\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0438\u0445 \u043f\u0440\u0435\u0433\u0440\u0430\u0434: " + e);
        }
        this.setLoaded(5);
        try {
            this.myBackground = new Background();
        }
        catch (Exception e) {
            System.out.println("\u041e\u0448\u0438\u0431\u043a\u0430! \u041f\u0440\u0438 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u0438 \u0437\u0430\u0434\u043d\u0435\u0433\u043e \u0444\u043e\u043d\u0430: " + e);
        }
        this.setLoaded(5);
        this.getItemsParameters(1);
        try {
            this.myHero = new MedveD(Image.createImage((String)"/img/medved.png"), 20, 26, DISP_WIDTH / 2 + 50, DISP_HEIGHT / 2);
        }
        catch (Exception e) {
            System.out.println("\u041e\u0448\u0438\u0431\u043a\u0430! \u041d\u0435\u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u043e\u0437\u0434\u0430\u0442\u044c \u043c\u043e\u0434\u0435\u043b\u044c \u0433\u043b\u0430\u0432\u043d\u043e\u0433\u043e \u0433\u0435\u0440\u043e\u044f: " + e.getMessage());
        }
        int heroX = this.itemsParameters[2];
        int heroY = this.itemsParameters[3];
        this.setCamera(heroX, heroY);
        this.myHero.setPosition(heroX, heroY);
        try {
            this.exitLevel = new Sprite(Image.createImage((String)"/img/exit.png"), 9, 12);
            this.exitLevel.setVisible(true);
            this.exitLevel.setPosition(this.itemsParameters[4], this.itemsParameters[5]);
            this.append((Layer)this.exitLevel);
        }
        catch (Exception e) {
            System.out.println("\u041e\u0448\u0438\u0431\u043a\u0430! \u041d\u0435\u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u043e\u0437\u0434\u0430\u0442\u044c \u043e\u0431\u044a\u0435\u043a\u0442 \u0434\u043b\u044f \u0432\u044b\u0445\u043e\u0434\u0430 \u0438\u0437 \u0443\u0440\u043e\u0432\u043d\u044f: " + e.getMessage());
        }
        this.setLoaded(5);
        this.shoot = new MovingSprite[10];
        this.setLoaded(5);
        this.getItemsParameters(2);
        try {
            this.firePause = new int[this.itemsParameters[0]];
            this.scoreShowing = new int[this.itemsParameters[0]];
            this.scoreShowingTime = new int[this.itemsParameters[0]];
            this.myENEMIES = new Clone[this.itemsParameters[0]];
            this.countLifeEnemies = this.itemsParameters[0];
            if (this.itemsParameters[0] != 0) {
                block60: for (int i3 = 0; i3 < this.myENEMIES.length; ++i3) {
                    j = 2;
                    index = this.itemsParameters[1] * i3 + j;
                    int itemType = this.itemsParameters[index];
                    String enemyFileName = "";
                    switch (itemType) {
                        case 1: {
                            enemyFileName = "/img/enemy1.png";
                            this.firePause[i3] = 19;
                            break;
                        }
                        case 2: {
                            enemyFileName = "/img/enemy2.png";
                            this.firePause[i3] = 29;
                            break;
                        }
                        case 3: {
                            enemyFileName = "/img/enemy3.png";
                            this.firePause[i3] = 6;
                            break;
                        }
                        case 4: {
                            enemyFileName = "/img/enemy4.png";
                            this.firePause[i3] = 20;
                            break;
                        }
                        case 5: {
                            enemyFileName = "/img/enemy5.png";
                            this.firePause[i3] = 29;
                        }
                    }
                    this.myENEMIES[i3] = new Clone(Image.createImage((String)enemyFileName), DISP_WIDTH / 2 + 20 * i3, DISP_HEIGHT / 2, this.myBarrier, 2);
                    this.myENEMIES[i3].setVisible(false);
                    index = this.itemsParameters[1] * i3 + ++j;
                    int itemX2 = this.itemsParameters[index];
                    index = this.itemsParameters[1] * i3 + ++j;
                    int itemY = this.itemsParameters[index];
                    this.myENEMIES[i3].setPosition(itemX2, itemY);
                    switch (itemType) {
                        case 1: {
                            this.myENEMIES[i3].setLife(100);
                            this.myENEMIES[i3].setScore(100);
                            this.myENEMIES[i3].setGun(1);
                            continue block60;
                        }
                        case 2: {
                            this.myENEMIES[i3].setLife(200);
                            this.myENEMIES[i3].setScore(200);
                            this.myENEMIES[i3].setGun(2);
                            continue block60;
                        }
                        case 3: {
                            this.myENEMIES[i3].setLife(400);
                            this.myENEMIES[i3].setScore(400);
                            this.myENEMIES[i3].setGun(3);
                            continue block60;
                        }
                        case 4: {
                            this.myENEMIES[i3].setLife(1400);
                            this.myENEMIES[i3].setScore(1400);
                            this.myENEMIES[i3].setGun(3);
                            continue block60;
                        }
                        case 5: {
                            this.myENEMIES[i3].setLife(3000);
                            this.myENEMIES[i3].setScore(3000);
                            this.myENEMIES[i3].setGun(4);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            System.out.println("\u041e\u0448\u0438\u0431\u043a\u0430! \u041d\u0435\u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u043e\u0437\u0434\u0430\u0442\u044c \u043a\u0430\u0440\u0442\u0438\u043d\u043a\u0443 \u0432\u0440\u0430\u0433\u0430  :: \u0432\u0441\u0435\u0433\u043e: " + this.itemsParameters[0] + "): " + e);
        }
        this.setLoaded(5);
        MManager mManager = this;
        this.myBackground.setMissionMap(mManager.myCanvas.getMission());
        this.setLoaded(5);
        MManager mManager2 = this;
        this.myBarrier.setMissionMap(mManager2.myCanvas.getMission());
        this.setLoaded(5);
        this.getItemsParameters(10);
        try {
            this.chairs = new Items[this.itemsParameters[0]];
            if (this.itemsParameters[0] != 0) {
                for (int i4 = 0; i4 < this.chairs.length; ++i4) {
                    this.chairs[i4] = new Items(Image.createImage((String)"/img/chairs.png"), 11, 16, false);
                    j = 2;
                    index = this.itemsParameters[1] * i4 + j;
                    this.chairs[i4].setFrame(this.itemsParameters[index]);
                    index = this.itemsParameters[1] * i4 + ++j;
                    if (this.itemsParameters[index] == 0) {
                        this.chairs[i4].setTransform(2);
                    }
                    index = this.itemsParameters[1] * i4 + ++j;
                    itemX = this.itemsParameters[index];
                    index = this.itemsParameters[1] * i4 + ++j;
                    int itemY = this.itemsParameters[index];
                    this.chairs[i4].setPosition(itemX, itemY);
                    this.chairs[i4].setVisible(false);
                    this.append((Layer)this.chairs[i4]);
                }
            }
        }
        catch (Exception e) {
            System.out.println("\u041e\u0448\u0438\u0431\u043a\u0430! \u041f\u0440\u0438 \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0438 \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \"\u0441\u0442\u0443\u043b\": " + e);
        }
        this.getItemsParameters(5);
        try {
            this.traffic = new Items[this.itemsParameters[0]];
            if (this.itemsParameters[0] != 0) {
                for (int i5 = 0; i5 < this.traffic.length; ++i5) {
                    this.traffic[i5] = new Items(Image.createImage((String)"/img/traffic.png"), 10, 24, false);
                    this.traffic[i5].defineCollisionRectangle(10, 18, 4, 6);
                    j = 2;
                    index = this.itemsParameters[1] * i5 + j;
                    this.traffic[i5].setItemColor(this.itemsParameters[index]);
                    index = this.itemsParameters[1] * i5 + ++j;
                    this.traffic[i5].setOrientation(this.itemsParameters[index]);
                    this.append((Layer)this.traffic[i5]);
                    index = this.itemsParameters[1] * i5 + ++j;
                    itemX = this.itemsParameters[index];
                    index = this.itemsParameters[1] * i5 + ++j;
                    int itemY = this.itemsParameters[index];
                    this.traffic[i5].setPosition(itemX, itemY);
                    this.traffic[i5].setVisible(false);
                }
            }
        }
        catch (Exception e) {
            System.out.println("\u041e\u0448\u0438\u0431\u043a\u0430! \u041f\u0440\u0438 \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0438 \u043e\u0431\u044a\u0435\u043a\u0442\u0430: " + e);
        }
        this.setLoaded(5);
        try {
            this.shootFog = new Sprite[10];
            for (int i6 = 0; i6 < this.shootFog.length; ++i6) {
                this.shootFog[i6] = new Sprite(Image.createImage((String)"/img/fog.png"), 6, 8);
                this.shootFog[i6].setVisible(false);
                this.append((Layer)this.shootFog[i6]);
                this.fogTimeLife[i6] = 0;
            }
        }
        catch (Exception e) {
            System.out.println("\u041e\u0448\u0438\u0431\u043a\u0430! \u041f\u0440\u0438 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u0438 \u0434\u044b\u043c\u0430 \u0432\u044b\u0441\u0442\u0440\u0435\u043b\u0430: " + e);
        }
        this.setLoaded(5);
        this.append((Layer)this.myHero);
        for (i2 = 0; i2 < this.shoot.length; ++i2) {
            this.shoot[i2] = new MovingSprite(0, 0, this.myBarrier, DISP_WIDTH, DISP_HEIGHT);
            this.shoot[i2].setVisible(false);
            this.append((Layer)this.shoot[i2]);
        }
        this.setLoaded(5);
        try {
            this.Explosion = new Sprite[10];
            for (i2 = 0; i2 < this.Explosion.length; ++i2) {
                this.Explosion[i2] = new Sprite(Image.createImage((String)"/img/explosion.png"), 55, 55);
                this.Explosion[i2].setVisible(false);
                this.append((Layer)this.Explosion[i2]);
            }
        }
        catch (IOException ioe) {
            System.out.println("\u041e\u0448\u0438\u0431\u043a\u0430! \u041d\u0435\u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u043e\u0437\u0434\u0430\u0442\u044c \u0430\u043d\u0438\u043c\u0430\u0446\u0438\u044e \u0432\u0437\u0440\u044b\u0432\u0430: " + ioe);
        }
        for (i = 0; i < this.myENEMIES.length; ++i) {
            this.append((Layer)this.myENEMIES[i]);
            this.myENEMIES[i].setVisible(true);
        }
        this.setLoaded(5);
        this.getItemsParameters(9);
        try {
            this.tables = new Items[this.itemsParameters[0]];
            if (this.itemsParameters[0] != 0) {
                for (i = 0; i < this.tables.length; ++i) {
                    this.tables[i] = new Items(Image.createImage((String)"/img/tables.png"), 17, 24, false);
                    j = 2;
                    index = this.itemsParameters[1] * i + j;
                    this.tables[i].setFrame(this.itemsParameters[index]);
                    if (this.itemsParameters[index] == 3 || this.itemsParameters[index] == 4) {
                        this.tables[i].setTransform(5);
                    }
                    index = this.itemsParameters[1] * i + ++j;
                    itemX = this.itemsParameters[index];
                    index = this.itemsParameters[1] * i + ++j;
                    int itemY = this.itemsParameters[index];
                    this.tables[i].setPosition(itemX, itemY);
                    this.tables[i].setVisible(false);
                    this.append((Layer)this.tables[i]);
                }
            }
        }
        catch (Exception e) {
            System.out.println("\u041e\u0448\u0438\u0431\u043a\u0430! \u041f\u0440\u0438 \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0438 \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \"\u0441\u0442\u043e\u043b\": " + e);
        }
        this.getItemsParameters(12);
        try {
            this.banches = new Items[this.itemsParameters[0]];
            if (this.itemsParameters[0] != 0) {
                for (int i7 = 0; i7 < this.banches.length; ++i7) {
                    this.banches[i7] = new Items(Image.createImage((String)"/img/banches.png"), 10, 24, false);
                    j = 2;
                    index = this.itemsParameters[1] * i7 + j;
                    this.banches[i7].setFrame(this.itemsParameters[index]);
                    if (this.itemsParameters[index] == 2 || this.itemsParameters[index] == 3) {
                        this.banches[i7].setTransform(5);
                    }
                    index = this.itemsParameters[1] * i7 + ++j;
                    itemX = this.itemsParameters[index];
                    index = this.itemsParameters[1] * i7 + ++j;
                    int itemY = this.itemsParameters[index];
                    this.banches[i7].setPosition(itemX, itemY);
                    this.banches[i7].setVisible(false);
                    this.append((Layer)this.banches[i7]);
                }
            }
        }
        catch (Exception e) {
            System.out.println("\u041e\u0448\u0438\u0431\u043a\u0430! \u041f\u0440\u0438 \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0438 \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \"\u0441\u0442\u043e\u043b\": " + e);
        }
        this.getItemsParameters(3);
        try {
            this.car = new Items[this.itemsParameters[0]];
            if (this.itemsParameters[0] != 0) {
                for (int i8 = 0; i8 < this.car.length; ++i8) {
                    j = 2;
                    index = this.itemsParameters[1] * i8 + j;
                    switch (this.itemsParameters[index]) {
                        case 0: {
                            this.car[i8] = new Items(Image.createImage((String)("/img/car" + this.itemsParameters[index] + ".png")), 40, 40, false);
                            break;
                        }
                        case 1: {
                            this.car[i8] = new Items(Image.createImage((String)("/img/car" + this.itemsParameters[index] + ".png")), 40, 40, false);
                            break;
                        }
                        case 2: {
                            this.car[i8] = new Items(Image.createImage((String)("/img/car" + this.itemsParameters[index] + ".png")), 40, 40, false);
                            break;
                        }
                        case 3: {
                            this.car[i8] = new Items(Image.createImage((String)("/img/car" + this.itemsParameters[index] + ".png")), 37, 40, false);
                        }
                    }
                    index = this.itemsParameters[1] * i8 + ++j;
                    this.car[i8].setOrientation(this.itemsParameters[index]);
                    this.append((Layer)this.car[i8]);
                    index = this.itemsParameters[1] * i8 + ++j;
                    itemX = this.itemsParameters[index];
                    index = this.itemsParameters[1] * i8 + ++j;
                    int itemY = this.itemsParameters[index];
                    this.car[i8].setPosition(itemX, itemY);
                    this.car[i8].setVisible(false);
                }
            }
        }
        catch (Exception e) {
            System.out.println("\u041e\u0448\u0438\u0431\u043a\u0430! \u041f\u0440\u0438 \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0438 \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \u043c\u0430\u0448\u0438\u043d\u044b: " + e);
        }
        this.getItemsParameters(13);
        try {
            this.flasks = new Items[this.itemsParameters[0]];
            if (this.itemsParameters[0] != 0) {
                for (int i9 = 0; i9 < this.flasks.length; ++i9) {
                    this.flasks[i9] = new Items(Image.createImage((String)"/img/flask.png"), 18, 23, false);
                    j = 2;
                    index = this.itemsParameters[1] * i9 + j;
                    this.flasks[i9].setFrame(this.itemsParameters[index]);
                    this.append((Layer)this.flasks[i9]);
                    index = this.itemsParameters[1] * i9 + ++j;
                    itemX = this.itemsParameters[index];
                    index = this.itemsParameters[1] * i9 + ++j;
                    int itemY = this.itemsParameters[index];
                    this.flasks[i9].setPosition(itemX, itemY);
                    this.flasks[i9].setVisible(false);
                    this.flasks[i9].setLifeLevel(100);
                }
            }
        }
        catch (Exception e) {
            System.out.println("\u041e\u0448\u0438\u0431\u043a\u0430! \u041f\u0440\u0438 \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0438 \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \u043a\u043e\u043b\u0431\u044b: " + e);
        }
        this.setLoaded(5);
        this.getItemsParameters(11);
        try {
            this.flowers = new Items[this.itemsParameters[0]];
            if (this.itemsParameters[0] != 0) {
                for (int i10 = 0; i10 < this.flowers.length; ++i10) {
                    this.flowers[i10] = new Items(Image.createImage((String)"/img/flowers.png"), 14, 22, false);
                    j = 2;
                    index = this.itemsParameters[1] * i10 + j;
                    this.flowers[i10].setFrame(this.itemsParameters[index]);
                    index = this.itemsParameters[1] * i10 + ++j;
                    itemX = this.itemsParameters[index];
                    index = this.itemsParameters[1] * i10 + ++j;
                    int itemY = this.itemsParameters[index];
                    this.flowers[i10].setPosition(itemX, itemY);
                    this.flowers[i10].setVisible(false);
                    this.append((Layer)this.flowers[i10]);
                }
            }
        }
        catch (Exception e) {
            System.out.println("\u041e\u0448\u0438\u0431\u043a\u0430! \u041f\u0440\u0438 \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0438 \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \"\u0446\u0432\u0435\u0442\u043e\u043a\": " + e);
        }
        this.setLoaded(5);
        this.getItemsParameters(4);
        try {
            this.trees = new Items[this.itemsParameters[0]];
            if (this.itemsParameters[0] != 0) {
                for (int i11 = 0; i11 < this.trees.length; ++i11) {
                    this.trees[i11] = new Items(Image.createImage((String)"/img/trees.png"), 20, 22, false);
                    j = 2;
                    index = this.itemsParameters[1] * i11 + j;
                    this.trees[i11].setItemColor(this.itemsParameters[index]);
                    index = this.itemsParameters[1] * i11 + ++j;
                    this.trees[i11].setOrientation(this.itemsParameters[index]);
                    this.append((Layer)this.trees[i11]);
                    index = this.itemsParameters[1] * i11 + ++j;
                    itemX = this.itemsParameters[index];
                    index = this.itemsParameters[1] * i11 + ++j;
                    int itemY = this.itemsParameters[index];
                    this.trees[i11].setPosition(itemX, itemY);
                    this.trees[i11].setVisible(false);
                }
            }
        }
        catch (Exception e) {
            System.out.println("\u041e\u0448\u0438\u0431\u043a\u0430! \u041f\u0440\u0438 \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0438 \u043e\u0431\u044a\u0435\u043a\u0442\u0430: " + e);
        }
        this.setLoaded(5);
        this.getItemsParameters(6);
        try {
            this.bullets = new Sprite[this.itemsParameters[0]];
            if (this.itemsParameters[0] != 0) {
                for (int i12 = 0; i12 < this.bullets.length; ++i12) {
                    this.bullets[i12] = new Sprite(Image.createImage((String)"/img/weapons.png"), 26, 14);
                    this.append((Layer)this.bullets[i12]);
                    j = 2;
                    index = this.itemsParameters[1] * i12 + j;
                    this.bullets[i12].setFrame(this.itemsParameters[index]);
                    index = this.itemsParameters[1] * i12 + ++j;
                    itemX = this.itemsParameters[index];
                    index = this.itemsParameters[1] * i12 + ++j;
                    int itemY = this.itemsParameters[index];
                    this.bullets[i12].setPosition(itemX, itemY);
                }
            }
        }
        catch (IOException e) {
            System.out.println("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u0438 \u0441\u043f\u0440\u0430\u0439\u0442\u0430 /img/weapons : " + e.getMessage());
        }
        this.getItemsParameters(7);
        try {
            this.healthAndArmor = new Sprite[this.itemsParameters[0]];
            if (this.itemsParameters[0] != 0) {
                for (int i13 = 0; i13 < this.healthAndArmor.length; ++i13) {
                    this.healthAndArmor[i13] = new Sprite(Image.createImage((String)"/img/health.png"), 14, 14);
                    this.append((Layer)this.healthAndArmor[i13]);
                    j = 2;
                    index = this.itemsParameters[1] * i13 + j;
                    this.healthAndArmor[i13].setFrame(this.itemsParameters[index]);
                    index = this.itemsParameters[1] * i13 + ++j;
                    itemX = this.itemsParameters[index];
                    index = this.itemsParameters[1] * i13 + ++j;
                    int itemY = this.itemsParameters[index];
                    this.healthAndArmor[i13].setPosition(itemX, itemY);
                }
            }
        }
        catch (IOException e) {
            System.out.println("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u0438 \u0441\u043f\u0440\u0430\u0439\u0442\u0430 /img/health.png : " + e.getMessage());
        }
        this.setLoaded(5);
        this.getItemsParameters(8);
        try {
            this.stims = new Sprite[this.itemsParameters[0]];
            if (this.itemsParameters[0] != 0) {
                for (int i14 = 0; i14 < this.stims.length; ++i14) {
                    this.stims[i14] = new Sprite(Image.createImage((String)"/img/stims.png"), 15, 11);
                    this.append((Layer)this.stims[i14]);
                    j = 2;
                    index = this.itemsParameters[1] * i14 + j;
                    this.stims[i14].setFrame(this.itemsParameters[index]);
                    index = this.itemsParameters[1] * i14 + ++j;
                    itemX = this.itemsParameters[index];
                    index = this.itemsParameters[1] * i14 + ++j;
                    int itemY = this.itemsParameters[index];
                    this.stims[i14].setPosition(itemX, itemY);
                }
            }
        }
        catch (IOException ioe) {
            System.out.println("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u0438 \u0441\u043f\u0440\u0430\u0439\u0442\u0430 /img/stims.png : " + ioe.getMessage());
        }
        this.setLoaded(5);
        this.append((Layer)this.myBackground);
        this.append((Layer)this.myBarrier);
        this.setLoaded(5);
        this.myBackground.advance(this.cameraX, this.cameraY);
        this.myBarrier.advance(this.cameraX, this.cameraY);
        this.setLoaded(5);
        this.setViewWindow(this.cameraX, this.cameraY, DISP_WIDTH, DISP_HEIGHT);
        this.setLoaded(5);
        this.itemsParameters = null;
    }

    private void setCamera(int xPos, int yPos) {
        this.cameraX = xPos - DISP_WIDTH / 2;
        this.cameraY = yPos - DISP_HEIGHT / 2;
        if (this.cameraX < CANVAS_X) {
            this.cameraX = CANVAS_X;
        } else if (this.cameraX + DISP_WIDTH > this.myBackground.getWidth()) {
            this.cameraX = this.myBackground.getWidth() - DISP_WIDTH;
        }
        if (this.cameraY < CANVAS_Y) {
            this.cameraY = CANVAS_Y;
        } else if (this.cameraY + DISP_HEIGHT > this.myBackground.getHeight()) {
            this.cameraY = this.myBackground.getHeight() - DISP_HEIGHT;
        }
    }

    public boolean setMatrix() {
        if (!this.isSpeedUp && timeEffect == 100) {
            int i;
            this.isMatrix = true;
            timeEffect = 0;
            for (i = 0; i < this.shoot.length; ++i) {
                if (!this.shoot[i].isVisible()) continue;
                int oldDetectGun = 0;
                switch (this.shoot[i].getSpeedX()) {
                    case 9: {
                        oldDetectGun = 1;
                        break;
                    }
                    case 8: {
                        oldDetectGun = 2;
                        break;
                    }
                    case 11: {
                        oldDetectGun = 3;
                        break;
                    }
                    case 7: {
                        oldDetectGun = 4;
                    }
                }
                this.oldShootSpeed[i] = oldDetectGun;
                this.shoot[i].setSpeedX(2);
                this.shoot[i].setSpeedY(2);
            }
            this.oldSpeedEnemy = new int[this.myENEMIES.length];
            for (i = 0; i < this.myENEMIES.length; ++i) {
                if (this.myENEMIES[i] == null) continue;
                this.oldSpeedEnemy[i] = this.myENEMIES[i].getSpeed();
            }
            return true;
        }
        return false;
    }

    public boolean setSpeedUpStart() {
        if (!this.isMatrix && timeEffect == 100) {
            this.isSpeedUp = true;
            timeEffect = 0;
            return true;
        }
        return false;
    }

    private void getItemsParameters(int itemType) {
        String fileName = "";
        switch (itemType) {
            case 1: {
                fileName = "hero";
                break;
            }
            case 2: {
                fileName = "enemy";
                break;
            }
            case 3: {
                fileName = "cars";
                break;
            }
            case 4: {
                fileName = "trees";
                break;
            }
            case 5: {
                fileName = "traffic";
                break;
            }
            case 6: {
                fileName = "bullets";
                break;
            }
            case 7: {
                fileName = "healthAndArmor";
                break;
            }
            case 8: {
                fileName = "stims";
                break;
            }
            case 9: {
                fileName = "tables";
                break;
            }
            case 10: {
                fileName = "chairs";
                break;
            }
            case 11: {
                fileName = "flowers";
                break;
            }
            case 12: {
                fileName = "banches";
                break;
            }
            case 13: {
                fileName = "flasks";
            }
        }
        try {
            MManager mManager = this;
            int mission = mManager.myCanvas.getMission();
            ++mission;
            String textFileContent = "";
            boolean lineCounter = false;
            int missionCounter = 0;
            DataInputStream dis = new DataInputStream(((Object)((Object)this)).getClass().getResourceAsStream("/data/" + fileName));
            textFileContent = "";
            try {
                do {
                    textFileContent = dis.readUTF().trim();
                } while (mission != ++missionCounter);
            }
            catch (EOFException eof) {
                // empty catch block
            }
            char[] tmpMass = textFileContent.toCharArray();
            String tmpValue = "";
            int[] tmpIntMass = new int[tmpMass.length];
            int counter = 0;
            for (int i = 0; i < tmpMass.length; ++i) {
                if (tmpMass[i] != ',') {
                    tmpValue = tmpValue + String.valueOf(tmpMass[i]);
                    continue;
                }
                tmpIntMass[counter] = Integer.valueOf(tmpValue);
                ++counter;
                tmpValue = "";
            }
            tmpMass = null;
            this.itemsParameters = null;
            if (tmpIntMass[0] != 0) {
                this.itemsParameters = new int[tmpIntMass[0] * tmpIntMass[1] + 2];
                int k = 0;
                for (int i = 0; i < tmpIntMass.length; ++i) {
                    this.itemsParameters[k] = tmpIntMass[i];
                    if (++k != this.itemsParameters.length) {
                        continue;
                    }
                    break;
                }
            } else {
                this.itemsParameters = new int[1];
                this.itemsParameters[0] = 0;
            }
            tmpIntMass = null;
            System.gc();
            dis.close();
        }
        catch (IOException ioe) {
            System.out.println("\u041e\u0448\u0438\u0431\u043a\u0430! " + ioe);
        }
    }

    public void paint(Graphics g) throws Exception {
        g.setColor(0);
        g.fillRect(-10, 0, 500, 720);
        this.paint(g, CANVAS_X, CANVAS_Y);
        if (isDrawCross) {
            this.crossHair(g, Math.abs(this.cameraX - this.myENEMIES[indexEnemy].getX()) + 6, Math.abs(this.cameraY - this.myENEMIES[indexEnemy].getY()) + 10);
        }
        if (this.isMatrix || this.isSpeedUp) {
            g.setColor(2336188);
            g.fillRect(2, 30, 50 - timeEffect / 2, 5);
            g.setColor(0xFFFFFF);
            g.drawRect(2, 30, 50 - timeEffect / 2, 5);
        }
        if (this.countLifeEnemies != 0 && this.countLifeEnemies <= 3) {
            this.drawPngString(g, "\u0432\u0440\u0430\u0433\u0438: " + this.countLifeEnemies, 2, 33);
        }
        for (int i = 0; i < this.scoreShowing.length; ++i) {
            if (this.scoreShowing[i] == 0) continue;
            this.drawPngString(g, "+" + this.scoreShowing[i], Math.abs(this.cameraX - this.myENEMIES[i].getX()), Math.abs(this.cameraY - this.myENEMIES[i].getY() + 10));
            int n = i;
            this.scoreShowingTime[n] = this.scoreShowingTime[n] + 1;
            if (this.scoreShowingTime[i] <= 50) continue;
            this.scoreShowingTime[i] = 0;
            this.scoreShowing[i] = 0;
        }
    }

    public void drawPngString(Graphics g, String str, int x, int y) {
        MManager mManager = this;
        int charWidth = mManager.myCanvas.getCharMainWidth();
        MManager mManager2 = this;
        int charHeight = mManager2.myCanvas.getCharMainHeight();
        int spaceWidth = 0;
        int strLength = str.length();
        int alphLength = MCanvas.alphabit.length;
        int lineCount = 0;
        char[] myChar = new char[strLength];
        str.getChars(0, strLength, myChar, 0);
        block0: for (int i = 0; i < strLength; ++i) {
            for (int j = 0; j < alphLength; ++j) {
                int lineX;
                if (myChar[i] == MCanvas.alphabit[j]) {
                    lineX = x + lineCount * (charWidth - 1) - spaceWidth;
                    if (lineX > DISP_WIDTH - 18) {
                        y += charHeight;
                        lineCount = 0;
                        spaceWidth = 0;
                        if (myChar[i] == ' ') continue block0;
                        lineX = x + lineCount * (charWidth - 1) - spaceWidth;
                    }
                    MCanvas.myFont.setFrame(j);
                    ++lineCount;
                    MCanvas.myFont.setPosition(lineX, y);
                    MCanvas.myFont.paint(g);
                    continue;
                }
                if (myChar[i] != '\n') continue;
                y += charHeight;
                lineCount = 0;
                spaceWidth = 0;
                lineX = x + lineCount * (charWidth - 1);
                ++i;
            }
        }
    }

    private void effectMatrix() {
        int i;
        this.speedFinal = 5;
        for (i = 0; i < this.myENEMIES.length; ++i) {
            if (this.myENEMIES[i] == null || !this.myENEMIES[i].isVisible()) continue;
            this.myENEMIES[i].setSpeed(1);
        }
        if (timeEffect == 100) {
            this.speedFinal = 5;
            this.isMatrix = false;
            for (i = 0; i < this.myENEMIES.length; ++i) {
                if (this.myENEMIES[i] == null || !this.myENEMIES[i].isVisible()) continue;
                this.myENEMIES[i].setSpeed(this.oldSpeedEnemy[i]);
            }
            for (i = 0; i < this.shoot.length; ++i) {
                if (!this.shoot[i].isVisible()) continue;
                this.shoot[i].setSpeedX(this.gunSpeedDetect(this.oldShootSpeed[i]));
                this.shoot[i].setSpeedY(this.gunSpeedDetect(this.oldShootSpeed[i]));
            }
        }
    }

    private void effectSpeedUp() {
        this.speedFinal = 10;
        if (timeEffect == 100) {
            this.speedFinal = 5;
            this.isSpeedUp = false;
        }
    }

    public void advance(int movementDirection) {
        if (++this.ticksSynchro % 2 == 0) {
            int i;
            int i2;
            int i3;
            this.myBackground.advance(this.cameraX, this.cameraY);
            this.myBarrier.advance(this.cameraX, this.cameraY);
            for (i3 = 0; i3 < this.car.length; ++i3) {
                this.car[i3].advance(this.cameraX, this.cameraY, DISP_WIDTH, DISP_HEIGHT);
                int carLife = this.car[i3].getLifeLevel();
                if (carLife > 0 || carLife == -200) continue;
                this.car[i3].nextFrame();
                this.setScore(this.getScore() + 23);
                this.car[i3].setLifeLevel(-200);
                if (quakeCounter == -1) {
                    quakeCounter = 0;
                }
                this.addExpolsion(this.car[i3], this.car[i3].getX(), this.car[i3].getY());
            }
            for (i3 = 0; i3 < this.trees.length; ++i3) {
                this.trees[i3].advance(this.cameraX, this.cameraY, DISP_WIDTH, DISP_HEIGHT);
            }
            for (i3 = 0; i3 < this.traffic.length; ++i3) {
                this.traffic[i3].advance(this.cameraX, this.cameraY, DISP_WIDTH, DISP_HEIGHT);
            }
            for (i3 = 0; i3 < this.chairs.length; ++i3) {
                this.chairs[i3].advance(this.cameraX, this.cameraY, DISP_WIDTH, DISP_HEIGHT);
            }
            for (i3 = 0; i3 < this.tables.length; ++i3) {
                this.tables[i3].advance(this.cameraX, this.cameraY, DISP_WIDTH, DISP_HEIGHT);
            }
            for (i3 = 0; i3 < this.flowers.length; ++i3) {
                this.flowers[i3].advance(this.cameraX, this.cameraY, DISP_WIDTH, DISP_HEIGHT);
            }
            for (i3 = 0; i3 < this.banches.length; ++i3) {
                this.banches[i3].advance(this.cameraX, this.cameraY, DISP_WIDTH, DISP_HEIGHT);
            }
            for (i3 = 0; i3 < this.flasks.length; ++i3) {
                this.flasks[i3].advance(this.cameraX, this.cameraY, DISP_WIDTH, DISP_HEIGHT);
                int flasksLife = this.flasks[i3].getLifeLevel();
                if (flasksLife > 0 || flasksLife == -200) continue;
                this.flasks[i3].nextFrame();
                this.setScore(this.getScore() + 18);
                this.flasks[i3].setLifeLevel(-200);
                if (quakeCounter == -1) {
                    quakeCounter = 0;
                }
                this.addExpolsion(this.flasks[i3], this.flasks[i3].getX(), this.flasks[i3].getY());
            }
            int myOldX = this.myHero.getX();
            int myOldY = this.myHero.getY();
            if (this.isMatrix) {
                ++timeEffect;
                this.effectMatrix();
            } else if (this.isSpeedUp) {
                ++timeEffect;
                this.effectSpeedUp();
            }
            this.movementSpeedX = this.speedFinal;
            this.movementSpeedY = this.speedFinal;
            if (godMode != 0) {
                movementDirection = 0;
            }
            this.myHero.advance(movementDirection, this.movementSpeedX, this.movementSpeedY);
            this.detectCross(this.myHero, movementDirection);
            for (i2 = 0; i2 < this.bullets.length; ++i2) {
                if (this.bullets[i2] == null || !this.bullets[i2].isVisible() || !this.myHero.collidesWith(this.bullets[i2], false)) continue;
                int countBullets = 0;
                switch (this.bullets[i2].getFrame()) {
                    case 1: {
                        countBullets = Integer.parseInt(MCanvas.inventory[1][1]);
                        MCanvas.inventory[1][1] = String.valueOf(countBullets + 20);
                        this.setScore(this.getScore() + 9);
                        break;
                    }
                    case 2: {
                        countBullets = Integer.parseInt(MCanvas.inventory[2][1]);
                        MCanvas.inventory[2][1] = String.valueOf(countBullets + 24);
                        this.setScore(this.getScore() + 16);
                        break;
                    }
                    case 3: {
                        countBullets = Integer.parseInt(MCanvas.inventory[3][1]);
                        MCanvas.inventory[3][1] = String.valueOf(countBullets + 45);
                        this.setScore(this.getScore() + 32);
                        break;
                    }
                    case 4: {
                        countBullets = Integer.parseInt(MCanvas.inventory[4][1]);
                        MCanvas.inventory[4][1] = String.valueOf(countBullets + 3);
                        this.setScore(this.getScore() + 55);
                    }
                }
                this.bullets[i2].setVisible(false);
                this.bullets[i2] = null;
            }
            for (i2 = 0; i2 < this.healthAndArmor.length; ++i2) {
                if (this.healthAndArmor[i2] == null || !this.healthAndArmor[i2].isVisible() || !this.myHero.collidesWith(this.healthAndArmor[i2], false)) continue;
                boolean takeItem = false;
                switch (this.healthAndArmor[i2].getFrame()) {
                    case 0: {
                        if (MCanvas.lifeLevel >= 100) break;
                        MCanvas.setUppendLife(50);
                        takeItem = true;
                        this.setScore(this.getScore() + 4);
                        break;
                    }
                    case 1: {
                        if (MCanvas.armorLevel >= 100) break;
                        MCanvas.setUppendArmor(50);
                        takeItem = true;
                        this.setScore(this.getScore() + 4);
                        break;
                    }
                    case 2: {
                        MCanvas.setUpperCountLife(1);
                        takeItem = true;
                        this.setScore(this.getScore() + 155);
                    }
                }
                if (!takeItem) continue;
                this.healthAndArmor[i2].setVisible(false);
                this.healthAndArmor[i2] = null;
            }
            for (i2 = 0; i2 < this.stims.length; ++i2) {
                if (this.stims[i2] == null || !this.stims[i2].isVisible() || !this.myHero.collidesWith(this.stims[i2], false)) continue;
                int countStims = 0;
                switch (this.stims[i2].getFrame()) {
                    case 0: {
                        countStims = Integer.parseInt(MCanvas.inventory[5][1]);
                        MCanvas.inventory[5][1] = String.valueOf(++countStims);
                        break;
                    }
                    case 1: {
                        countStims = Integer.parseInt(MCanvas.inventory[6][1]);
                        MCanvas.inventory[6][1] = String.valueOf(++countStims);
                    }
                }
                this.setScore(this.getScore() + 8);
                this.stims[i2].setVisible(false);
                this.stims[i2] = null;
            }
            boolean isCross = false;
            if (this.checkScreenRules(0, 0, 480, 720, this.myHero, this.speedFinal)) {
                isCross = true;
            }
            for (i = 0; i < this.car.length; ++i) {
                if (!this.car[i].isVisible() || !this.car[i].collidesWith(this.myHero, true)) continue;
                isCross = true;
                break;
            }
            for (i = 0; i < this.trees.length; ++i) {
                if (!this.trees[i].isVisible() || !this.trees[i].collidesWith(this.myHero, true)) continue;
                isCross = true;
                break;
            }
            for (i = 0; i < this.traffic.length; ++i) {
                if (!this.traffic[i].isVisible() || !this.traffic[i].collidesWith(this.myHero, false)) continue;
                isCross = true;
                break;
            }
            for (i = 0; i < this.chairs.length; ++i) {
                if (!this.chairs[i].isVisible() || !this.chairs[i].collidesWith(this.myHero, false)) continue;
                isCross = true;
                break;
            }
            for (i = 0; i < this.tables.length; ++i) {
                if (!this.tables[i].isVisible() || !this.tables[i].collidesWith(this.myHero, false)) continue;
                isCross = true;
                break;
            }
            for (i = 0; i < this.flowers.length; ++i) {
                if (!this.flowers[i].isVisible() || !this.flowers[i].collidesWith(this.myHero, false)) continue;
                isCross = true;
                break;
            }
            for (i = 0; i < this.banches.length; ++i) {
                if (!this.banches[i].isVisible() || !this.banches[i].collidesWith(this.myHero, false)) continue;
                isCross = true;
                break;
            }
            for (i = 0; i < this.flasks.length; ++i) {
                if (!this.flasks[i].isVisible() || !this.flasks[i].collidesWith(this.myHero, false)) continue;
                isCross = true;
                break;
            }
            if (this.myHero.collidesWith(this.myBarrier, false)) {
                isCross = true;
            }
            if (isCross) {
                this.myHero.setPosition(myOldX, myOldY);
            } else if (movementDirection != 0) {
                int chHeroX = this.myHero.getX();
                int chHeroY = this.myHero.getY();
                if (chHeroX >= this.myBackground.getX() + DISP_WIDTH / 2 - 0 && chHeroX <= this.myBackground.getWidth() - DISP_WIDTH / 2 - 0) {
                    this.cameraX += this.myHero.moveX;
                    if (this.cameraX < this.myBackground.getX()) {
                        this.cameraX = this.myBackground.getX();
                    }
                    if (this.cameraX > this.myBackground.getWidth() - DISP_WIDTH - 0) {
                        this.cameraX = this.myBackground.getWidth() - DISP_WIDTH;
                    }
                } else {
                    if (chHeroX < this.myBackground.getX() + DISP_WIDTH / 2 - 0) {
                        this.cameraX = 0;
                    }
                    if (chHeroX > this.myBackground.getWidth() - DISP_WIDTH / 2 - this.movementSpeedX) {
                        this.cameraX = this.myBackground.getWidth() - DISP_WIDTH;
                    }
                }
                if (chHeroY >= this.myBackground.getY() + DISP_HEIGHT / 2 && chHeroY <= this.myBackground.getHeight() - DISP_HEIGHT / 2 - 0) {
                    this.cameraY += this.myHero.moveY;
                    if (this.cameraY < this.myBackground.getY()) {
                        this.cameraY = this.myBackground.getY();
                    } else if (this.cameraY > this.myBackground.getHeight() - DISP_HEIGHT) {
                        this.cameraY = this.myBackground.getHeight() - DISP_HEIGHT;
                    }
                } else if (chHeroY < this.myBackground.getY() + DISP_HEIGHT / 2) {
                    this.cameraY = this.myBackground.getY();
                } else if (chHeroY > this.myBackground.getHeight() - DISP_HEIGHT / 2) {
                    this.cameraY = this.myBackground.getHeight() - DISP_HEIGHT;
                }
                this.setViewWindow(this.cameraX, this.cameraY, DISP_WIDTH, DISP_HEIGHT);
                if (this.myHero.collidesWith(this.exitLevel, false)) {
                    MCanvas.setMission(MCanvas.getMission() + 1);
                    this.setScore(this.getScore() + 60);
                    this.closeSounds();
                    MCanvas.saveGame();
                    MCanvas.loadedProcess = 0;
                }
            }
            if (quakeCounter != -1) {
                this.quakeScreen();
            }
            block41: for (int j = 0; j < this.myENEMIES.length; ++j) {
                int i4;
                if (this.myENEMIES[j] == null) continue;
                int tmpX = this.myENEMIES[j].getX();
                int tmpY = this.myENEMIES[j].getY();
                this.myENEMIES[j].advance(this.myHero.getX(), this.myHero.getY(), this.cameraX, this.cameraY, DISP_WIDTH, DISP_HEIGHT);
                if (this.myENEMIES[j].isFinallyDead()) {
                    this.myENEMIES[j].setVisible(false);
                    this.myENEMIES[j] = null;
                }
                if (this.myENEMIES[j] == null || !this.myENEMIES[j].isVisible()) continue;
                if (this.myENEMIES[j].getLife() > 0) {
                    int dx = this.myENEMIES[j].getX() - this.myHero.getX();
                    int dy = this.myENEMIES[j].getY() - this.myHero.getY();
                    int dz = Math.abs(dx * dx) + Math.abs(dy * dy);
                    int distanceShoot = 0;
                    distanceShoot = this.myENEMIES[j].getGun() == 2 ? 4225 : 6400;
                    if (dz <= distanceShoot) {
                        int activeGun = this.myENEMIES[j].getGun();
                        int shootPause = 20;
                        switch (activeGun) {
                            case 0: {
                                break;
                            }
                            case 1: {
                                shootPause = 20;
                                break;
                            }
                            case 2: {
                                shootPause = 30;
                                break;
                            }
                            case 3: {
                                shootPause = 10;
                                break;
                            }
                            case 4: {
                                shootPause = 30;
                            }
                        }
                        int n = j;
                        this.firePause[n] = this.firePause[n] + 1;
                        if (this.firePause[n] % shootPause == 0) {
                            this.addShoot(this.myENEMIES[j], j, activeGun);
                            this.firePause[j] = 0;
                        }
                    }
                }
                for (i4 = 0; i4 < this.car.length; ++i4) {
                    if (!this.car[i4].isVisible() || !this.myENEMIES[j].collidesWith(this.car[i4], true)) continue;
                    this.myENEMIES[j].setPosition(tmpX, tmpY);
                    break;
                }
                for (i4 = 0; i4 < this.trees.length; ++i4) {
                    if (!this.trees[i4].isVisible() || !this.myENEMIES[j].collidesWith(this.trees[i4], true)) continue;
                    this.myENEMIES[j].setPosition(tmpX, tmpY);
                    break;
                }
                for (i4 = 0; i4 < this.traffic.length; ++i4) {
                    if (!this.traffic[i4].isVisible() || !this.myENEMIES[j].collidesWith(this.traffic[i4], false)) continue;
                    this.myENEMIES[j].setPosition(tmpX, tmpY);
                    break;
                }
                for (i4 = 0; i4 < this.chairs.length; ++i4) {
                    if (!this.chairs[i4].isVisible() || !this.myENEMIES[j].collidesWith(this.chairs[i4], false)) continue;
                    this.myENEMIES[j].setPosition(tmpX, tmpY);
                    break;
                }
                for (i4 = 0; i4 < this.tables.length; ++i4) {
                    if (!this.tables[i4].isVisible() || !this.myENEMIES[j].collidesWith(this.tables[i4], false)) continue;
                    this.myENEMIES[j].setPosition(tmpX, tmpY);
                    break;
                }
                for (i4 = 0; i4 < this.flowers.length; ++i4) {
                    if (!this.flowers[i4].isVisible() || !this.myENEMIES[j].collidesWith(this.flowers[i4], false)) continue;
                    this.myENEMIES[j].setPosition(tmpX, tmpY);
                    break;
                }
                for (i4 = 0; i4 < this.banches.length; ++i4) {
                    if (!this.banches[i4].isVisible() || !this.myENEMIES[j].collidesWith(this.banches[i4], false)) continue;
                    this.myENEMIES[j].setPosition(tmpX, tmpY);
                    break;
                }
                for (i4 = 0; i4 < this.flasks.length; ++i4) {
                    if (!this.flasks[i4].isVisible() || !this.myENEMIES[j].collidesWith(this.flasks[i4], false)) continue;
                    this.myENEMIES[j].setPosition(tmpX, tmpY);
                    continue block41;
                }
            }
            for (i = 0; i < 10; ++i) {
                int j;
                if (this.shoot[i].isVisible()) {
                    int j2;
                    int frame = this.shoot[i].getFrame();
                    if (frame == 0 || frame == 2) {
                        for (j2 = 0; j2 < this.myENEMIES.length; ++j2) {
                            if (this.myENEMIES[j2] == null || !this.myENEMIES[j2].isVisible() || this.myENEMIES[j2].getLife() <= 0 || !this.shoot[i].collidesWith(this.myENEMIES[j2], false)) continue;
                            if (this.shoot[i].getCasualties() >= 100) {
                                if (quakeCounter == -1) {
                                    quakeCounter = 0;
                                }
                                this.addExpolsion(this.myENEMIES[j2], this.myENEMIES[j2].getX(), this.myENEMIES[j2].getY());
                            }
                            this.shootEnemy(j2, this.shoot[i].getCasualties());
                            this.shoot[i].setVisible(false);
                        }
                        for (j2 = 0; j2 < this.car.length; ++j2) {
                            if (!this.car[j2].isVisible() || !this.shoot[i].collidesWith(this.car[j2], false)) continue;
                            int carLife = this.car[j2].getLifeLevel();
                            if (carLife != -200) {
                                this.car[j2].setLifeLevel(carLife - this.shoot[i].getCasualties());
                            }
                            if (this.shoot[i].getCasualties() >= 100) {
                                if (quakeCounter == -1) {
                                    quakeCounter = 0;
                                }
                                this.addExpolsion(this.car[j2], this.car[j2].getX(), this.car[j2].getY());
                                if (carLife <= 0 && carLife != -200) {
                                    this.car[j2].setLifeLevel(-200);
                                    this.car[j2].nextFrame();
                                    this.setScore(this.getScore() + 23);
                                }
                            }
                            this.shoot[i].setVisible(false);
                        }
                        for (j2 = 0; j2 < this.flasks.length; ++j2) {
                            if (!this.flasks[j2].isVisible() || !this.shoot[i].collidesWith(this.flasks[j2], false)) continue;
                            int flasksLife = this.flasks[j2].getLifeLevel();
                            if (flasksLife != -200) {
                                this.flasks[j2].setLifeLevel(flasksLife - this.shoot[i].getCasualties());
                            }
                            if (this.shoot[i].getCasualties() >= 100) {
                                if (quakeCounter == -1) {
                                    quakeCounter = 0;
                                }
                                this.addExpolsion(this.flasks[j2], this.flasks[j2].getX(), this.flasks[j2].getY());
                                if (flasksLife <= 0 && flasksLife != -200) {
                                    this.flasks[j2].setLifeLevel(-200);
                                    this.flasks[j2].nextFrame();
                                    this.setScore(this.getScore() + 18);
                                }
                            }
                            this.shoot[i].setVisible(false);
                        }
                    } else {
                        if (this.shoot[i].collidesWith(this.myHero, false) && godMode == 0) {
                            if (this.shoot[i].getCasualties() >= 100) {
                                if (quakeCounter == -1) {
                                    quakeCounter = 0;
                                }
                                this.addExpolsion(this.myHero, this.myHero.getX(), this.myHero.getY());
                            }
                            MCanvas.setLifeLevelWidth(this.shoot[i].getCasualties() / 5 + 1);
                            this.shoot[i].setVisible(false);
                        }
                        for (j2 = 0; j2 < this.car.length; ++j2) {
                            if (!this.car[j2].isVisible() || !this.shoot[i].collidesWith(this.car[j2], false)) continue;
                            this.shoot[i].setVisible(false);
                        }
                        for (j2 = 0; j2 < this.flasks.length; ++j2) {
                            if (!this.flasks[j2].isVisible() || !this.shoot[i].collidesWith(this.flasks[j2], false)) continue;
                            this.shoot[i].setVisible(false);
                        }
                    }
                    this.shoot[i].advance(this.cameraX, this.cameraY);
                    if (explosionX != -1 && explosionY != -1) {
                        this.addExpolsion(null, explosionX, explosionY);
                    }
                }
                if (!this.Explosion[i].isVisible()) continue;
                for (j = 0; j < this.car.length; ++j) {
                    if (!this.car[j].isVisible() || this.car[j].getLifeLevel() == -200 || !this.car[j].collidesWith(this.Explosion[i], false)) continue;
                    this.car[j].setLifeLevel(this.car[j].getLifeLevel() - 100);
                    if (quakeCounter != -1) continue;
                    quakeCounter = 0;
                }
                for (j = 0; j < this.flasks.length; ++j) {
                    if (!this.flasks[j].isVisible() || this.flasks[j].getLifeLevel() == -200 || !this.flasks[j].collidesWith(this.Explosion[i], false)) continue;
                    this.flasks[j].setLifeLevel(this.flasks[j].getLifeLevel() - 100);
                    if (quakeCounter != -1) continue;
                    quakeCounter = 0;
                }
                for (j = 0; j < this.myENEMIES.length; ++j) {
                    if (this.myENEMIES[j] == null || !this.myENEMIES[j].isVisible() || this.myENEMIES[j].getLife() <= 0 || !this.myENEMIES[j].collidesWith(this.Explosion[i], false)) continue;
                    this.shootEnemy(j, 20);
                }
                if (this.myHero.collidesWith(this.Explosion[i], false) && godMode == 0) {
                    MCanvas.setLifeLevelWidth(5);
                }
                if (this.ticksSynchro % 6 == 0) {
                    this.Explosion[i].nextFrame();
                }
                if (this.Explosion[i].getFrame() == 0) {
                    this.Explosion[i].setVisible(false);
                }
                if (explosionX == -1 || explosionY == -1) continue;
                explosionX = -1;
                explosionY = -1;
            }
            for (i = 0; i < this.shootFog.length; ++i) {
                if (!this.shootFog[i].isVisible()) continue;
                int n = i;
                this.fogTimeLife[n] = this.fogTimeLife[n] + 1;
                if (this.fogTimeLife[n] % 4 != 0) continue;
                this.shootFog[i].setVisible(false);
            }
            if (godMode != 0) {
                int limit = 50;
                if (--godMode > limit) {
                    this.myHero.setVisible(true);
                } else if (godMode > 9 * limit / 10) {
                    this.myHero.setVisible(false);
                } else if (godMode > 8 * limit / 10) {
                    this.myHero.setVisible(true);
                } else if (godMode > 7 * limit / 10) {
                    this.myHero.setVisible(false);
                } else if (godMode > 6 * limit / 10) {
                    this.myHero.setVisible(true);
                } else if (godMode > 5 * limit / 10) {
                    this.myHero.setVisible(false);
                } else if (godMode > 4 * limit / 10) {
                    this.myHero.setVisible(true);
                } else if (godMode > 3 * limit / 10) {
                    this.myHero.setVisible(false);
                } else if (godMode > 2 * limit / 10) {
                    this.myHero.setVisible(true);
                } else if (godMode > limit / 10) {
                    this.myHero.setVisible(false);
                } else {
                    this.myHero.setVisible(true);
                }
            }
            if (this.ticksSynchro % 3 == 0) {
                if (this.exitLevel.isVisible()) {
                    this.exitLevel.nextFrame();
                }
                this.ticksSynchro = 10;
            }
        }
    }

    private void shootEnemy(int enemyShootIndex, int casualtes) {
        if (this.myENEMIES[enemyShootIndex] != null) {
            this.myENEMIES[enemyShootIndex].setLife(this.myENEMIES[enemyShootIndex].getLife() - casualtes);
            if (this.myENEMIES[enemyShootIndex].getLife() <= 0) {
                --this.countLifeEnemies;
                this.scoreShowing[enemyShootIndex] = this.myENEMIES[enemyShootIndex].getScore();
                this.setScore(this.getScore() + this.scoreShowing[enemyShootIndex]);
            }
        }
    }

    public void quakeScreen() {
        int quakeDispersion = 8;
        switch (++quakeCounter) {
            case 1: {
                this.cameraX -= quakeDispersion;
                break;
            }
            case 2: {
                this.cameraX += quakeDispersion;
                break;
            }
            case 3: {
                this.cameraX -= quakeDispersion;
                break;
            }
            case 4: {
                this.cameraX += quakeDispersion;
                break;
            }
            case 5: {
                this.cameraX -= quakeDispersion;
                break;
            }
            case 6: {
                this.cameraX += quakeDispersion;
                break;
            }
            case 7: {
                this.cameraX -= quakeDispersion;
                break;
            }
            case 8: {
                this.cameraX += quakeDispersion;
                break;
            }
            case 9: {
                this.cameraX -= quakeDispersion;
                break;
            }
            case 10: {
                this.cameraX += quakeDispersion;
                break;
            }
            default: {
                quakeCounter = -1;
                this.setCamera(this.myHero.getX(), this.myHero.getY());
            }
        }
        this.setViewWindow(this.cameraX, this.cameraY, DISP_WIDTH, DISP_HEIGHT);
    }

    public void addExpolsion(Sprite crashObject, int centerX, int centerY) {
        for (int i = 0; i < this.Explosion.length; ++i) {
            if (this.Explosion[i].isVisible()) continue;
            this.Explosion[i].setFrame(1);
            if (crashObject == null) {
                this.Explosion[i].setPosition(centerX - this.Explosion[i].getWidth() / 2, centerY - this.Explosion[i].getHeight() / 2);
            } else {
                this.Explosion[i].setPosition(centerX - (this.Explosion[i].getWidth() - crashObject.getWidth()) / 2, centerY - (this.Explosion[i].getHeight() - crashObject.getHeight()) / 2);
            }
            this.Explosion[i].setVisible(true);
            break;
        }
    }

    public void detectCross(Sprite sprite, int movementDirection) {
        int detectLength = 70;
        indexEnemy = 0;
        for (int i = 0; i < this.myENEMIES.length; ++i) {
            if (this.myENEMIES[i] == null || !this.myENEMIES[i].isVisible()) continue;
            if (this.myENEMIES[i].getLife() > 0) {
                if (sprite.getX() - this.myENEMIES[i].getX() <= detectLength && sprite.getY() - this.myENEMIES[i].getY() <= detectLength && sprite.getX() - this.myENEMIES[i].getX() >= 0 && sprite.getY() - this.myENEMIES[i].getY() >= 0) {
                    indexEnemy = i;
                    if (MCanvas.activeGun != 4) continue;
                    isAutoCrosshair = true;
                    isDrawCross = true;
                    continue;
                }
                if (this.myENEMIES[i].getX() - sprite.getX() <= detectLength && sprite.getY() - this.myENEMIES[i].getY() <= detectLength && this.myENEMIES[i].getX() - sprite.getX() >= 0 && sprite.getY() - this.myENEMIES[i].getY() >= 0) {
                    indexEnemy = i;
                    if (MCanvas.activeGun != 4) continue;
                    isAutoCrosshair = true;
                    isDrawCross = true;
                    continue;
                }
                if (sprite.getX() - this.myENEMIES[i].getX() <= detectLength && this.myENEMIES[i].getY() - sprite.getY() <= detectLength && sprite.getX() - this.myENEMIES[i].getX() >= 0 && this.myENEMIES[i].getY() - sprite.getY() >= 0) {
                    indexEnemy = i;
                    if (MCanvas.activeGun != 4) continue;
                    isAutoCrosshair = true;
                    isDrawCross = true;
                    continue;
                }
                if (this.myENEMIES[i].getX() - sprite.getX() > detectLength || this.myENEMIES[i].getY() - sprite.getY() > detectLength || this.myENEMIES[i].getX() - sprite.getX() < 0 || this.myENEMIES[i].getY() - sprite.getY() < 0) continue;
                indexEnemy = i;
                if (MCanvas.activeGun != 4) continue;
                isAutoCrosshair = true;
                isDrawCross = true;
                continue;
            }
            isAutoCrosshair = false;
            isDrawCross = false;
        }
    }

    public void crossHair(Graphics g, int crossX, int crossY) {
        g.setColor(52479);
        if (++crossFlash % 40 < 10) {
            g.setColor(0xFFFFFF);
        }
        if (crossFlash > 40) {
            crossFlash = 0;
        }
        g.drawLine(crossX, crossY, crossX + 1, crossY);
        g.drawLine(crossX, crossY, crossX, crossY + 1);
        g.drawLine(crossX, crossY + 5, crossX, crossY + 6);
        g.drawLine(crossX, crossY + 6, crossX + 1, crossY + 6);
        g.drawLine(crossX + 5, crossY, crossX + 6, crossY);
        g.drawLine(crossX + 6, crossY, crossX + 6, crossY + 1);
        g.drawLine(crossX + 5, crossY + 6, crossX + 6, crossY + 6);
        g.drawLine(crossX + 6, crossY + 5, crossX + 6, crossY + 6);
        g.drawLine(crossX + 2, crossY + 3, crossX + 4, crossY + 3);
        g.drawLine(crossX + 3, crossY + 2, crossX + 3, crossY + 4);
    }

    public void reset() {
        this.cameraX = (this.myBackground.getWidth() - DISP_WIDTH) / 2;
        this.cameraY = (this.myBackground.getHeight() - DISP_HEIGHT) / 2;
        int heroX = this.cameraX + (DISP_WIDTH - this.myHero.getWidth()) / 2;
        int heroY = this.cameraY + (DISP_HEIGHT - this.myHero.getHeight()) / 2;
        this.setViewWindow(this.cameraX, this.cameraY, DISP_WIDTH, DISP_HEIGHT);
        this.myHero.setPosition(heroX, heroY);
        for (int i = 0; i < this.myENEMIES.length; ++i) {
            this.myENEMIES[i].setPosition(heroX + 15 * i, heroY);
        }
    }

    public boolean moveToNextLevel(int heroX, int heroY) {
        boolean dx = false;
        int dy = DISP_HEIGHT - heroY;
        boolean isNext = true;
        for (int i = 0; i < this.myENEMIES.length; ++i) {
            if (this.myENEMIES[i] == null || this.myENEMIES[i].getLife() <= 0) continue;
            isNext = false;
        }
        if (isNext) {
            this.exitLevel.setVisible(true);
        }
        return isNext;
    }

    public boolean checkScreenRules(int BORDER_X, int BORDER_Y, int BORDER_WIDTH, int BORDER_HEIGHT, Sprite sprite, int speed) {
        boolean isBorderCross = false;
        if (this.myHero.getX() > BORDER_WIDTH - sprite.getWidth() - speed) {
            isBorderCross = true;
        } else if (sprite.getX() < BORDER_X + this.movementSpeedX) {
            isBorderCross = true;
        }
        if (sprite.getY() > BORDER_HEIGHT - sprite.getHeight() - speed) {
            isBorderCross = true;
        } else if (sprite.getY() < BORDER_Y + 20 + this.movementSpeedY) {
            isBorderCross = true;
        }
        return isBorderCross;
    }

    public void collidesWithItems(Sprite activeSprite, Sprite itemSprite, int movementDirection, int speed) {
        if (activeSprite.collidesWith(itemSprite, false)) {
            int dx = activeSprite.getX() - itemSprite.getX();
            int dy = activeSprite.getY() - itemSprite.getY();
            if (dx > 0) {
                this.movementSpeedX = 0;
                if (movementDirection == 6) {
                    this.movementSpeedX = speed;
                    activeSprite.move(this.movementSpeedX / 2, 0);
                }
            } else {
                this.movementSpeedX = 0;
                if (movementDirection == 4) {
                    this.movementSpeedX = speed;
                    activeSprite.move(-this.movementSpeedX / 2, 0);
                }
            }
            if (dy < 0) {
                this.movementSpeedY = 0;
                if (movementDirection == 2) {
                    this.movementSpeedY = speed;
                    activeSprite.move(0, -this.movementSpeedY / 2);
                }
            } else {
                this.movementSpeedY = 0;
                if (movementDirection == 8) {
                    this.movementSpeedY = speed;
                    activeSprite.move(0, this.movementSpeedY / 2);
                }
            }
            if (dx > 0 && dy <= 0) {
                if (movementDirection == 3) {
                    this.movementSpeedX = speed;
                    this.movementSpeedY = speed;
                    activeSprite.move(this.movementSpeedX / 2, -this.movementSpeedY / 2);
                } else if (movementDirection == 9) {
                    this.movementSpeedX = speed;
                    this.movementSpeedY = speed;
                    activeSprite.move(this.movementSpeedX / 2, this.movementSpeedY / 2);
                }
            } else if (dx >= 0 && dy > 0 && movementDirection == 9) {
                this.movementSpeedX = speed;
                this.movementSpeedY = speed;
                activeSprite.move(this.movementSpeedX / 2, this.movementSpeedY / 2);
            } else if (dx < 0 && dy <= 0) {
                if (movementDirection == 1) {
                    this.movementSpeedX = speed;
                    this.movementSpeedY = speed;
                    activeSprite.move(-this.movementSpeedX / 2, -this.movementSpeedY / 2);
                } else if (movementDirection == 7) {
                    this.movementSpeedX = speed;
                    this.movementSpeedY = speed;
                    activeSprite.move(-this.movementSpeedX / 2, this.movementSpeedY / 2);
                }
            } else if (dx < 0 && dy >= 0 && movementDirection == 7) {
                this.movementSpeedX = speed;
                this.movementSpeedY = speed;
                activeSprite.move(-this.movementSpeedX / 2, this.movementSpeedY / 2);
            }
        }
    }

    public void collidesWithBarrier(Sprite activeSprite, TiledLayer barrier, int movementDirection, int speed) {
        if (activeSprite.collidesWith(barrier, false)) {
            int dx = activeSprite.getX() - barrier.getX();
            int dy = activeSprite.getY() - barrier.getY();
            if (dx > 0) {
                this.movementSpeedX = 0;
                if (movementDirection == 6) {
                    this.movementSpeedX = speed;
                    activeSprite.move(this.movementSpeedX / 2, 0);
                }
            } else {
                this.movementSpeedX = 0;
                if (movementDirection == 4) {
                    this.movementSpeedX = speed;
                    activeSprite.move(-this.movementSpeedX / 2, 0);
                }
            }
            if (dy < 0) {
                this.movementSpeedY = 0;
                if (movementDirection == 2) {
                    this.movementSpeedY = speed;
                    activeSprite.move(0, -this.movementSpeedY / 2);
                }
            } else {
                this.movementSpeedY = 0;
                if (movementDirection == 8) {
                    this.movementSpeedY = speed;
                    activeSprite.move(0, this.movementSpeedY / 2);
                }
            }
            if (dx > 0 && dy <= 0) {
                if (movementDirection == 3) {
                    this.movementSpeedX = speed;
                    this.movementSpeedY = speed;
                    activeSprite.move(this.movementSpeedX / 2, -this.movementSpeedY / 2);
                } else if (movementDirection == 9) {
                    this.movementSpeedX = speed;
                    this.movementSpeedY = speed;
                    activeSprite.move(this.movementSpeedX / 2, this.movementSpeedY / 2);
                }
            } else if (dx >= 0 && dy > 0 && movementDirection == 9) {
                this.movementSpeedX = speed;
                this.movementSpeedY = speed;
                activeSprite.move(this.movementSpeedX / 2, this.movementSpeedY / 2);
            } else if (dx < 0 && dy <= 0) {
                if (movementDirection == 1) {
                    this.movementSpeedX = speed;
                    this.movementSpeedY = speed;
                    activeSprite.move(-this.movementSpeedX / 2, -this.movementSpeedY / 2);
                } else if (movementDirection == 7) {
                    this.movementSpeedX = speed;
                    this.movementSpeedY = speed;
                    activeSprite.move(-this.movementSpeedX / 2, this.movementSpeedY / 2);
                }
            } else if (dx < 0 && dy >= 0 && movementDirection == 7) {
                this.movementSpeedX = speed;
                this.movementSpeedY = speed;
                activeSprite.move(-this.movementSpeedX / 2, this.movementSpeedY / 2);
            }
        }
    }

    private void addShoot(Sprite sprite, int whom, int activeGun) {
        int k = 1;
        int speed = 0;
        if (activeGun == 2) {
            k = 3;
        }
        int speedX = 0;
        int speedY = 0;
        int distantion = 55;
        Sprite enemySprite = null;
        if (whom == -1) {
            if (this.myENEMIES.length != 0) {
                enemySprite = this.myENEMIES[indexEnemy];
            }
            if (activeGun == 4 && enemySprite != null && enemySprite.isVisible()) {
                if (this.myENEMIES[indexEnemy].getLife() > 0) {
                    isAutoCrosshair = true;
                    isDrawCross = true;
                } else {
                    isAutoCrosshair = false;
                }
            } else {
                isAutoCrosshair = false;
            }
        } else {
            enemySprite = this.myHero;
            isAutoCrosshair = true;
        }
        int movementDirection = 0;
        if (isAutoCrosshair) {
            int dx = enemySprite.getX() - sprite.getX();
            int dy = enemySprite.getY() - sprite.getY();
            movementDirection = dx > 0 && dy <= 0 ? (-dy > dx / 4 ? (dx < -dy / 4 ? 2 : 3) : 6) : (dx <= 0 && dy < 0 ? (-dy > dx / 4 ? (dx > dy / 4 ? 2 : (dy > dx / 4 ? 4 : 1)) : 2) : (dx < 0 && dy >= 0 ? (dy > -dx / 4 ? (-dx < dy / 4 ? 8 : 7) : 4) : (dx > dy / 4 ? (dy < dx / 4 ? 6 : 9) : 8)));
            if (whom == -1) {
                this.myHero.advance(movementDirection, 0, 0);
            } else {
                this.myENEMIES[whom].setShootMovement(movementDirection);
                this.addFog(whom, movementDirection);
            }
        }
        block32: while (k != 0) {
            --k;
            int rifle = 0;
            if (activeGun == 2) {
                rifle = 6 * k - 5;
            }
            for (int i = 0; i < 10; ++i) {
                if (this.shoot[i].isVisible()) continue;
                speed = this.isMatrix ? 2 : this.gunSpeedDetect(activeGun);
                this.oldShootSpeed[i] = this.gunSpeedDetect(activeGun);
                if (whom == -1) {
                    switch (activeGun) {
                        case 1: {
                            this.shoot[i].setFrame(0);
                            this.shoot[i].setDistanceShoot(0);
                            this.shoot[i].setCasualties(25);
                            break;
                        }
                        case 2: {
                            this.shoot[i].setFrame(2);
                            this.shoot[i].setDistanceShoot(6);
                            this.shoot[i].setCasualties(45);
                            break;
                        }
                        case 3: {
                            this.shoot[i].setFrame(2);
                            this.shoot[i].setDistanceShoot(0);
                            this.shoot[i].setCasualties(30);
                            break;
                        }
                        case 4: {
                            this.shoot[i].setFrame(0);
                            this.shoot[i].setDistanceShoot(0);
                            this.shoot[i].setCasualties(100);
                        }
                    }
                } else {
                    switch (activeGun) {
                        case 1: {
                            this.shoot[i].setFrame(1);
                            this.shoot[i].setDistanceShoot(0);
                            this.shoot[i].setCasualties(25);
                            break;
                        }
                        case 2: {
                            this.shoot[i].setFrame(3);
                            this.shoot[i].setDistanceShoot(6);
                            this.shoot[i].setCasualties(45);
                            break;
                        }
                        case 3: {
                            this.shoot[i].setFrame(3);
                            this.shoot[i].setDistanceShoot(0);
                            this.shoot[i].setCasualties(30);
                            break;
                        }
                        case 4: {
                            this.shoot[i].setFrame(1);
                            this.shoot[i].setDistanceShoot(0);
                            this.shoot[i].setCasualties(100);
                        }
                    }
                }
                int positionShoot = 0;
                if (whom == -1) {
                    positionShoot = MedveD.movementDirectionSaved;
                    this.addFog(whom, positionShoot);
                } else {
                    Clone cfr_ignored_0 = this.myENEMIES[indexEnemy];
                    positionShoot = Clone.movementOld;
                }
                if (isAutoCrosshair) {
                    switch (positionShoot) {
                        case 1: {
                            this.shoot[i].setPosition(sprite.getX() + rifle, sprite.getY() - rifle);
                            break;
                        }
                        case 2: {
                            this.shoot[i].setPosition(sprite.getX() + rifle + 5, sprite.getY());
                            break;
                        }
                        case 3: {
                            this.shoot[i].setPosition(sprite.getX() + sprite.getWidth() + rifle, sprite.getY() + rifle);
                            break;
                        }
                        case 4: {
                            this.shoot[i].setPosition(sprite.getX(), sprite.getY() + rifle + 8);
                            break;
                        }
                        case 6: {
                            this.shoot[i].setPosition(sprite.getX() + sprite.getWidth(), sprite.getY() + rifle + 8);
                            break;
                        }
                        case 7: {
                            this.shoot[i].setPosition(sprite.getX() + rifle, sprite.getY() + sprite.getHeight() + rifle - 6);
                            break;
                        }
                        case 8: {
                            this.shoot[i].setPosition(sprite.getX() + rifle + 7, sprite.getY() + sprite.getHeight());
                            break;
                        }
                        case 9: {
                            this.shoot[i].setPosition(sprite.getX() + sprite.getWidth() + rifle, sprite.getY() + sprite.getHeight() - rifle - 6);
                        }
                    }
                    this.shoot[i].setAutoXY(enemySprite.getX() + enemySprite.getWidth() / 2, enemySprite.getY() + enemySprite.getHeight() / 2);
                    this.shoot[i].setAutoCrosshair(true);
                    this.shoot[i].setMovementDirection(movementDirection);
                    speedX = speed;
                    speedY = speed;
                    this.shoot[i].setSpeedX(speedX);
                    this.shoot[i].setSpeedY(speedY);
                } else {
                    this.shoot[i].setAutoCrosshair(false);
                    speedX = speed;
                    speedY = speed;
                    switch (positionShoot) {
                        case 1: {
                            this.shoot[i].setPosition(sprite.getX() + rifle, sprite.getY() - rifle);
                            this.shoot[i].setMovementDirection(1);
                            break;
                        }
                        case 2: {
                            this.shoot[i].setPosition(sprite.getX() + rifle + 5, sprite.getY());
                            this.shoot[i].setMovementDirection(2);
                            break;
                        }
                        case 3: {
                            this.shoot[i].setPosition(sprite.getX() + sprite.getWidth() + rifle, sprite.getY() + rifle);
                            this.shoot[i].setMovementDirection(3);
                            break;
                        }
                        case 4: {
                            this.shoot[i].setPosition(sprite.getX(), sprite.getY() + rifle + 8);
                            this.shoot[i].setMovementDirection(4);
                            break;
                        }
                        case 6: {
                            this.shoot[i].setPosition(sprite.getX() + sprite.getWidth(), sprite.getY() + rifle + 8);
                            this.shoot[i].setMovementDirection(6);
                            break;
                        }
                        case 7: {
                            this.shoot[i].setPosition(sprite.getX() + rifle, sprite.getY() + sprite.getHeight() + rifle - 6);
                            this.shoot[i].setMovementDirection(7);
                            break;
                        }
                        case 8: {
                            this.shoot[i].setPosition(sprite.getX() + rifle + 7, sprite.getY() + sprite.getHeight());
                            this.shoot[i].setMovementDirection(8);
                            break;
                        }
                        case 9: {
                            this.shoot[i].setPosition(sprite.getX() + sprite.getWidth() + rifle, sprite.getY() + sprite.getHeight() - rifle - 6);
                            this.shoot[i].setMovementDirection(9);
                        }
                    }
                }
                this.shoot[i].setSpeedX(speedX);
                this.shoot[i].setSpeedY(speedY);
                this.shoot[i].setVisible(true);
                continue block32;
            }
        }
    }

    public void shoot(int activeGun) {
        if (activeGun != 0) {
            try {
                this.addShoot(this.myHero, -1, activeGun);
            }
            catch (Exception e) {
                System.out.println("\u041e\u0448\u0438\u0431\u043a\u0430! \u041d\u0435\u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0432\u044b\u0441\u0442\u0440\u0435\u043b\u0438\u0442\u044c: " + e.getMessage());
            }
        } else {
            for (int i = 0; i < this.myENEMIES.length; ++i) {
                if (this.myENEMIES[i] == null || !this.myENEMIES[i].isVisible() || this.myENEMIES[i].getLife() <= 0) continue;
                int dx = this.myHero.getX() - this.myENEMIES[i].getX();
                int dy = this.myHero.getY() - this.myENEMIES[i].getY();
                int dz = Math.abs(dx * dx) + Math.abs(dy * dy);
                if (dz >= 260) continue;
                if (this.isSpeedUp) {
                    this.shootEnemy(i, 80);
                    continue;
                }
                this.shootEnemy(i, 20);
            }
        }
    }

    private int gunSpeedDetect(int activeGun) {
        int detectedSpeed = 0;
        switch (activeGun) {
            case 1: {
                detectedSpeed = 9;
                break;
            }
            case 2: {
                detectedSpeed = 8;
                break;
            }
            case 3: {
                detectedSpeed = 11;
                break;
            }
            case 4: {
                detectedSpeed = 7;
                break;
            }
            default: {
                detectedSpeed = 9;
            }
        }
        return detectedSpeed;
    }

    private void addFog(int who, int direction) {
        Sprite person = null;
        person = who == -1 ? this.myHero : this.myENEMIES[who];
        int personX = Math.abs(this.cameraX - person.getX());
        int personY = Math.abs(this.cameraY - person.getY());
        personX = Math.abs(this.cameraX - person.getX()) + person.getWidth();
        personY = Math.abs(this.cameraY - person.getY()) + person.getHeight() / 2;
        for (int i = 0; i < this.shootFog.length; ++i) {
            if (this.shootFog[i].isVisible()) continue;
            switch (direction) {
                case 1: {
                    this.shootFog[i].setPosition(person.getX(), person.getY());
                    this.shootFog[i].setTransform(2);
                    break;
                }
                case 2: {
                    this.shootFog[i].setPosition(person.getX() + 5, person.getY());
                    this.shootFog[i].setTransform(5);
                    break;
                }
                case 3: {
                    this.shootFog[i].setPosition(person.getX() + person.getWidth(), person.getY());
                    this.shootFog[i].setTransform(0);
                    break;
                }
                case 4: {
                    this.shootFog[i].setPosition(person.getX(), person.getY() + 8);
                    this.shootFog[i].setTransform(2);
                    break;
                }
                case 6: {
                    this.shootFog[i].setPosition(person.getX() + person.getWidth(), person.getY() + 8);
                    this.shootFog[i].setTransform(0);
                    break;
                }
                case 7: {
                    this.shootFog[i].setPosition(person.getX(), person.getY() + person.getHeight() - 6);
                    this.shootFog[i].setTransform(2);
                    break;
                }
                case 8: {
                    this.shootFog[i].setPosition(person.getX() + 7, person.getY() + person.getHeight());
                    this.shootFog[i].setTransform(5);
                    break;
                }
                case 9: {
                    this.shootFog[i].setPosition(person.getX() + person.getWidth(), person.getY() + person.getHeight() - 6);
                    this.shootFog[i].setTransform(0);
                }
            }
            this.fogTimeLife[i] = 0;
            this.shootFog[i].setVisible(true);
            break;
        }
    }

    static {
        indexEnemy = 0;
        crossFlash = 0;
        isAutoCrosshair = false;
        isDrawCross = false;
    }
}

