/*
 * Decompiled with CFR 0.152.
 */
import java.util.Random;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.midlet.MIDlet;

public class Board
extends Canvas {
    MIDlet midlet;
    Display disp;
    Random rand;
    int[] g_iDie = new int[]{-1, -1, -1, -1, -1};
    int[] g_iToRoll = new int[]{0, 0, 0, 0, 0};
    int[] g_iScore = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    int g_iFocusItem = 0;
    int g_iOldFocusItem = -1;
    int g_iPlayers = 1;
    int g_iCurrentPlayer = 1;
    int g_iRollCount = 0;
    int[] g_iDieCount = new int[]{0, 0, 0, 0, 0, 0};
    int g_iGameState = 0;
    boolean bGameOver = false;
    Command cmdRoll;

    public Board(MIDlet mIDlet, int n, Command command, Command command2) {
        this.midlet = mIDlet;
        this.g_iPlayers = n;
        this.cmdRoll = command;
        this.addCommand(command2);
        this.rand = new Random();
        this.rand.setSeed(System.currentTimeMillis());
        this.initializeBoard();
        this.initializeDice();
    }

    public void keyPressed(int n) {
        if (this.g_iGameState == 2) {
            this.g_iGameState = 0;
            this.initializeBoard();
            this.initializeDice();
            return;
        }
        this.g_iOldFocusItem = this.g_iFocusItem--;
        switch (this.getGameAction(n)) {
            case 1: {
                if (this.g_iOldFocusItem < 6) {
                    if (this.g_iFocusItem < 0) {
                        this.g_iFocusItem = this.anyToRoll() ? 5 : 4;
                    }
                } else if (this.g_iOldFocusItem < 12) {
                    if (this.g_iFocusItem < 6) {
                        this.g_iFocusItem = 11;
                    }
                } else if (this.g_iFocusItem < 12) {
                    this.g_iFocusItem = 20;
                }
                if (this.g_iFocusItem == 5 && !this.anyToRoll()) {
                    --this.g_iFocusItem;
                }
                this.repaint();
                break;
            }
            case 6: {
                ++this.g_iFocusItem;
                if (this.g_iOldFocusItem < 6) {
                    if (this.anyToRoll()) {
                        if (this.g_iFocusItem > 5) {
                            this.g_iFocusItem = 0;
                        }
                    } else if (this.g_iFocusItem > 4) {
                        this.g_iFocusItem = 0;
                    }
                } else if (this.g_iOldFocusItem < 12) {
                    if (this.g_iFocusItem > 11) {
                        this.g_iFocusItem = 6;
                    }
                } else if (this.g_iFocusItem > 20) {
                    this.g_iFocusItem = 12;
                }
                this.repaint();
                break;
            }
            case 5: {
                if (this.g_iFocusItem == 0) {
                    this.g_iFocusItem = 6;
                } else if (this.g_iFocusItem == 1) {
                    this.g_iFocusItem = 8;
                } else if (this.g_iFocusItem == 2) {
                    this.g_iFocusItem = 9;
                } else if (this.g_iFocusItem == 3) {
                    this.g_iFocusItem = 10;
                } else if (this.g_iFocusItem == 4) {
                    this.g_iFocusItem = 11;
                } else if (this.g_iFocusItem == 5) {
                    this.g_iFocusItem = 11;
                } else if (this.g_iFocusItem == 6) {
                    this.g_iFocusItem = 12;
                } else if (this.g_iFocusItem == 7) {
                    this.g_iFocusItem = 13;
                } else if (this.g_iFocusItem == 8) {
                    this.g_iFocusItem = 14;
                } else if (this.g_iFocusItem == 9) {
                    this.g_iFocusItem = 15;
                } else if (this.g_iFocusItem == 10) {
                    this.g_iFocusItem = 16;
                } else if (this.g_iFocusItem == 11) {
                    this.g_iFocusItem = 17;
                }
                this.repaint();
                break;
            }
            case 2: {
                if (this.g_iFocusItem > 16) {
                    this.g_iFocusItem = 11;
                } else if (this.g_iFocusItem == 16) {
                    this.g_iFocusItem = 10;
                } else if (this.g_iFocusItem == 15) {
                    this.g_iFocusItem = 9;
                } else if (this.g_iFocusItem == 14) {
                    this.g_iFocusItem = 8;
                } else if (this.g_iFocusItem == 13) {
                    this.g_iFocusItem = 7;
                } else if (this.g_iFocusItem == 12) {
                    this.g_iFocusItem = 6;
                } else if (this.g_iFocusItem == 11) {
                    this.g_iFocusItem = 4;
                } else if (this.g_iFocusItem == 10) {
                    this.g_iFocusItem = 3;
                } else if (this.g_iFocusItem == 9) {
                    this.g_iFocusItem = 2;
                } else if (this.g_iFocusItem == 8 || this.g_iFocusItem == 7) {
                    this.g_iFocusItem = 1;
                } else if (this.g_iFocusItem == 6) {
                    this.g_iFocusItem = 0;
                }
                this.repaint();
                break;
            }
            case 8: {
                this.doAction();
                this.repaint();
            }
        }
    }

    public void doAction() {
        int n;
        if (this.g_iFocusItem < 5 && this.g_iRollCount < 2) {
            if (this.g_iToRoll[this.g_iFocusItem] != 0) {
                this.g_iToRoll[this.g_iFocusItem] = 0;
                if (!this.anyToRoll()) {
                    this.removeCommand(this.cmdRoll);
                }
            } else {
                this.g_iToRoll[this.g_iFocusItem] = 1;
                if (this.anyToRoll()) {
                    this.addCommand(this.cmdRoll);
                }
            }
        }
        if (this.g_iFocusItem == 5) {
            this.DoRoll();
            this.removeCommand(this.cmdRoll);
            return;
        }
        if (this.g_iFocusItem > 5 && this.g_iScore[(n = this.g_iFocusItem - 6) + 15 * (this.g_iCurrentPlayer - 1)] == -1) {
            int n2 = 0;
            int n3 = 0;
            while (n3 < 6) {
                this.g_iDieCount[n3] = 0;
                ++n3;
            }
            int n4 = 0;
            while (n4 < 5) {
                int n5 = this.g_iDie[n4] - 1;
                this.g_iDieCount[n5] = this.g_iDieCount[n5] + 1;
                ++n4;
            }
            block0 : switch (n) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    n2 = this.g_iDieCount[n] * (n + 1);
                    break;
                }
                case 6: {
                    int n6 = 5;
                    while (n6 >= 0) {
                        if (this.g_iDieCount[n6] > 1) {
                            n2 = (n6 + 1) * 2;
                            break block0;
                        }
                        --n6;
                    }
                    break;
                }
                case 7: {
                    int n7 = 0;
                    int n8 = 5;
                    while (n8 >= 0) {
                        if (this.g_iDieCount[n8] > 1) {
                            n2 += (n8 + 1) * 2;
                            if (++n7 == 2) break;
                        }
                        --n8;
                    }
                    if (n7 >= 2) break;
                    n2 = 0;
                    break;
                }
                case 8: {
                    int n9 = 5;
                    while (n9 >= 0) {
                        if (this.g_iDieCount[n9] > 2) {
                            n2 = (n9 + 1) * 3;
                            break block0;
                        }
                        --n9;
                    }
                    break;
                }
                case 9: {
                    int n10 = 5;
                    while (n10 >= 0) {
                        if (this.g_iDieCount[n10] > 2) {
                            n2 = (n10 + 1) * 4;
                            break block0;
                        }
                        --n10;
                    }
                    break;
                }
                case 10: {
                    if (this.g_iDieCount[0] > 0 && this.g_iDieCount[1] > 0 && this.g_iDieCount[2] > 0 && this.g_iDieCount[3] > 0) {
                        n2 = 30;
                    }
                    if (this.g_iDieCount[1] > 0 && this.g_iDieCount[2] > 0 && this.g_iDieCount[3] > 0 && this.g_iDieCount[4] > 0) {
                        n2 = 30;
                    }
                    if (this.g_iDieCount[2] <= 0 || this.g_iDieCount[3] <= 0 || this.g_iDieCount[4] <= 0 || this.g_iDieCount[5] <= 0) break;
                    n2 = 30;
                    break;
                }
                case 11: {
                    if (this.g_iDieCount[0] > 0 && this.g_iDieCount[1] > 0 && this.g_iDieCount[2] > 0 && this.g_iDieCount[3] > 0 && this.g_iDieCount[4] > 0) {
                        n2 = 40;
                    }
                    if (this.g_iDieCount[1] <= 0 || this.g_iDieCount[2] <= 0 || this.g_iDieCount[3] <= 0 || this.g_iDieCount[4] <= 0 || this.g_iDieCount[5] <= 0) break;
                    n2 = 40;
                    break;
                }
                case 12: {
                    int n11 = 0;
                    int n12 = 0;
                    while (n12 < 6) {
                        if (this.g_iDieCount[n12] == 3) {
                            ++n11;
                        }
                        ++n12;
                    }
                    if (n11 > 0) {
                        int n13 = 0;
                        while (n13 < 6) {
                            if (this.g_iDieCount[n13] == 2) {
                                ++n11;
                            }
                            ++n13;
                        }
                    }
                    if (n11 != 2) break;
                    n2 = 25;
                    break;
                }
                case 13: {
                    int n14 = 0;
                    while (n14 < 5) {
                        n2 += this.g_iDie[n14];
                        ++n14;
                    }
                    break;
                }
                case 14: {
                    int n15 = 0;
                    while (n15 < 6) {
                        if (this.g_iDieCount[n15] == 5) {
                            n2 = 50;
                        }
                        ++n15;
                    }
                    break;
                }
            }
            this.g_iScore[n + 15 * (this.g_iCurrentPlayer - 1)] = n2;
            this.initializeDice();
            this.g_iFocusItem = 0;
            this.g_iRollCount = 0;
            ++this.g_iCurrentPlayer;
            if (this.g_iCurrentPlayer > this.g_iPlayers) {
                this.g_iCurrentPlayer = 1;
            }
            if (this.isGameOver()) {
                this.g_iGameState = 2;
            }
        }
    }

    public void DoRoll() {
        if (this.g_iRollCount < 2) {
            int n = 0;
            int n2 = 0;
            while (n2 < 5) {
                if (this.g_iToRoll[n2] != 0) {
                    ++n;
                    this.g_iToRoll[n2] = 0;
                    this.g_iDie[n2] = this.getDieValue();
                }
                ++n2;
            }
            ++this.g_iRollCount;
            this.g_iFocusItem = this.g_iRollCount == 2 ? 6 : 0;
        }
    }

    public void paint(Graphics graphics) {
        if (this.isGameOver()) {
            this.paintScores(graphics);
            return;
        }
        if (this.g_iCurrentPlayer == 1) {
            graphics.setColor(0, 0, 128);
        }
        if (this.g_iCurrentPlayer == 2) {
            graphics.setColor(0, 128, 0);
        }
        if (this.g_iCurrentPlayer == 3) {
            graphics.setColor(128, 128, 0);
        }
        if (this.g_iCurrentPlayer == 4) {
            graphics.setColor(128, 0, 128);
        }
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        int n = 0;
        int n2 = 0;
        while (n2 < 5) {
            n += this.g_iToRoll[n2];
            this.paintDie(graphics, this.g_iDie[n2], n2, this.g_iToRoll[n2]);
            ++n2;
        }
        if (n == 0) {
            this.paintBtn(graphics, false);
        } else {
            this.paintBtn(graphics, true);
        }
        this.paintBoard(graphics);
        this.paintFocus(graphics);
    }

    public void paintScores(Graphics graphics) {
        graphics.setColor(255, 255, 255);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        graphics.setColor(0, 0, 0);
        graphics.fillRect(20, 9, 80, 15);
        graphics.drawRect(20, 28, 80, 14 * this.g_iPlayers + 4);
        graphics.setColor(255, 255, 0);
        graphics.drawString("Game Over!", 30, 10, 20);
        graphics.setColor(255, 0, 0);
        int n = 0;
        while (n < this.g_iPlayers) {
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            while (n4 < 15) {
                if (n4 < 6) {
                    n2 += this.g_iScore[n4 + 15 * n];
                } else {
                    n3 += this.g_iScore[n4 + 15 * n];
                }
                ++n4;
            }
            if (n2 > 63) {
                graphics.drawString("Player " + (n + 1) + ": " + (n2 + 35 + n3), 30, n * 14 + 30, 20);
            } else {
                graphics.drawString("Player " + (n + 1) + ": " + (n2 + n3), 30, n * 14 + 30, 20);
            }
            ++n;
        }
    }

    public void paintDie(Graphics graphics, int n, int n2, int n3) {
        n2 = n2 * 21 + 2;
        graphics.setColor(0, 0, 0);
        graphics.fillRect(2, n2, 19, 19);
        if (n3 == 0) {
            graphics.setColor(255, 255, 255);
        } else {
            graphics.setColor(255, 255, 0);
        }
        graphics.fillRect(3, n2 + 1, 17, 17);
        graphics.setColor(0, 0, 0);
        if (n == 1 || n == 3 || n == 5) {
            graphics.fillRect(10, n2 + 8, 3, 3);
        }
        if (n > 1) {
            graphics.fillRect(4, n2 + 2, 3, 3);
        }
        if (n == 6) {
            graphics.fillRect(4, n2 + 8, 3, 3);
        }
        if (n > 3) {
            graphics.fillRect(4, n2 + 14, 3, 3);
        }
        if (n > 3) {
            graphics.fillRect(16, n2 + 2, 3, 3);
        }
        if (n == 6) {
            graphics.fillRect(16, n2 + 8, 3, 3);
        }
        if (n > 1) {
            graphics.fillRect(16, n2 + 14, 3, 3);
        }
    }

    public void paintBtn(Graphics graphics, boolean bl) {
        if (!bl) {
            return;
        }
        graphics.setColor(0, 0, 0);
        graphics.drawRect(2, 112, 40, 12);
        graphics.setColor(255, 255, 192);
        graphics.fillRect(3, 113, 38, 10);
        graphics.setColor(0, 0, 0);
        graphics.setFont(Font.getFont((int)64, (int)1, (int)8));
        graphics.drawString("Roll", 10, 116, 20);
    }

    public void paintBoard(Graphics graphics) {
        graphics.setColor(255, 255, 255);
        graphics.fillRect(26, 2, 98, 71);
        graphics.fillRect(67, 71, 57, 38);
        graphics.setColor(0, 0, 0);
        graphics.drawLine(24, 2, 24, 73);
        graphics.drawLine(42, 2, 42, 73);
        graphics.drawLine(65, 2, 65, 109);
        graphics.drawLine(66, 2, 66, 109);
        graphics.drawLine(96, 2, 96, 109);
        graphics.drawLine(124, 2, 124, 109);
        graphics.drawLine(24, 1, 124, 1);
        graphics.drawLine(24, 13, 124, 13);
        graphics.drawLine(24, 25, 124, 25);
        graphics.drawLine(24, 37, 124, 37);
        graphics.drawLine(24, 49, 124, 49);
        graphics.drawLine(24, 61, 124, 61);
        graphics.drawLine(24, 73, 124, 73);
        graphics.drawLine(66, 85, 124, 85);
        graphics.drawLine(66, 97, 124, 97);
        graphics.drawLine(66, 109, 124, 109);
        graphics.setFont(Font.getFont((int)64, (int)0, (int)8));
        graphics.drawString("1s", 28, 5, 20);
        graphics.drawString("2s", 28, 17, 20);
        graphics.drawString("3s", 28, 29, 20);
        graphics.drawString("4s", 28, 41, 20);
        graphics.drawString("5s", 28, 53, 20);
        graphics.drawString("6s", 28, 65, 20);
        graphics.drawString("1 Pr", 69, 5, 20);
        graphics.drawString("2 Pr", 69, 17, 20);
        graphics.drawString("3 Kd", 69, 29, 20);
        graphics.drawString("4 Kd", 69, 41, 20);
        graphics.drawString("Sm S", 69, 54, 20);
        graphics.drawString("Lg S", 69, 66, 20);
        graphics.drawString("Fu H", 69, 77, 20);
        graphics.drawString("Chnc", 69, 89, 20);
        graphics.drawString("Yaht", 69, 101, 20);
        graphics.setColor(255, 0, 0);
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < 15) {
            if (n3 < 6 && this.g_iScore[n3 + 15 * (this.g_iCurrentPlayer - 1)] > -1) {
                n2 += this.g_iScore[n3 + 15 * (this.g_iCurrentPlayer - 1)];
            }
            if (this.g_iScore[n3 + 15 * (this.g_iCurrentPlayer - 1)] > -1) {
                n += this.g_iScore[n3 + 15 * (this.g_iCurrentPlayer - 1)];
            }
            if (this.g_iScore[n3 + 15 * (this.g_iCurrentPlayer - 1)] >= 0) {
                if (n3 < 6) {
                    graphics.drawString(this.g_iScore[n3 + 15 * (this.g_iCurrentPlayer - 1)] + "", 46, 5 + n3 * 12, 20);
                } else {
                    graphics.drawString(this.g_iScore[n3 + 15 * (this.g_iCurrentPlayer - 1)] + "", 100, 5 + (n3 - 6) * 12, 20);
                }
            }
            ++n3;
        }
        graphics.setColor(0, 0, 0);
        graphics.drawRect(25, 77, 38, 32);
        graphics.setColor(192, 255, 255);
        graphics.fillRect(26, 78, 36, 31);
        graphics.setColor(0, 0, 0);
        graphics.drawString("S:" + n2, 28, 81, 20);
        if (n2 > 63) {
            graphics.setColor(0, 0, 0);
            graphics.drawString("B:35", 28, 91, 20);
        }
        graphics.setColor(255, 0, 0);
        if (n2 > 63) {
            n += 35;
        }
        graphics.drawString("T:" + n, 28, 101, 20);
        graphics.setColor(255, 255, 255);
        graphics.drawString("Player " + this.g_iCurrentPlayer, 72, 116, 20);
    }

    void paintFocus(Graphics graphics) {
        if (this.g_iFocusItem < 5) {
            graphics.setColor(255, 0, 0);
            graphics.drawRect(2, 2 + this.g_iFocusItem * 21, 17, 17);
            graphics.drawRect(3, 3 + this.g_iFocusItem * 21, 15, 15);
        }
        if (this.g_iFocusItem == 5) {
            graphics.setColor(255, 0, 0);
            graphics.drawRect(2, 112, 40, 12);
            graphics.drawRect(3, 113, 38, 10);
        }
        if (this.g_iFocusItem > 5 && this.g_iFocusItem < 12) {
            graphics.setColor(255, 0, 0);
            graphics.drawRect(24, 2 + 12 * (this.g_iFocusItem - 6), 41, 11);
            graphics.drawRect(25, 3 + 12 * (this.g_iFocusItem - 6), 39, 9);
        }
        if (this.g_iFocusItem > 11) {
            graphics.setColor(255, 0, 0);
            graphics.drawRect(66, 2 + 12 * (this.g_iFocusItem - 12), 58, 11);
            graphics.drawRect(67, 3 + 12 * (this.g_iFocusItem - 12), 56, 9);
        }
    }

    int getDieValue() {
        int n = this.rand.nextInt() % 6;
        n = this.rand.nextInt() % 6;
        if (n < 1) {
            n += 6;
        }
        return n;
    }

    void initializeBoard() {
        int n = 0;
        while (n < 60) {
            this.g_iScore[n] = -1;
            ++n;
        }
        this.g_iRollCount = 0;
        this.g_iFocusItem = 0;
    }

    void initializeDice() {
        int n = 0;
        while (n < 5) {
            this.g_iDie[n] = this.getDieValue();
            this.g_iToRoll[n] = 0;
            ++n;
        }
    }

    boolean anyToRoll() {
        int n = 0;
        while (n < 5) {
            if (this.g_iToRoll[n] != 0) {
                return true;
            }
            ++n;
        }
        return false;
    }

    boolean isGameOver() {
        if (this.bGameOver) {
            return true;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < 15 * this.g_iPlayers) {
            if (this.g_iScore[n2] > -1) {
                ++n;
            }
            ++n2;
        }
        if (n == 15 * this.g_iPlayers) {
            this.bGameOver = true;
            return true;
        }
        return false;
    }
}

