/*
 * Decompiled with CFR 0.152.
 */
package vscroller;

import de.tuttas.GameAPI.MenuItem;
import de.tuttas.GameAPI.Score.Score;
import de.tuttas.GameAPI.Score.ScoreList;
import de.tuttas.GameAPI.Score.ScoreListManager;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import vscroller.Config;
import vscroller.Displayable;

public class MyScoreListManager
extends ScoreListManager {
    private boolean toggle = false;
    public static int color1 = 8225209;
    public static int color2 = 3882603;
    static Image upImage;
    static Image downImage;

    public MyScoreListManager(ScoreList sl) {
        super(sl);
        try {
            upImage = Image.createImage((String)"/up.png");
            downImage = Image.createImage((String)"/down.png");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void paint(Graphics g) {
        g.setFont(Config.MENU_HEADLINE_FONT);
        MenuItem.Text3D(g, "Local Scores", g.getClipWidth() / 2, Config.MENU_HEADLINE_FONT.getHeight(), 0xFFFFFF, 17);
        int y = 2 * g.getFont().getHeight();
        g.setFont(Config.MENU_FONT);
        int i = MyScoreListManager.paintScoreList(g, y + 2, this.scores, this.startIndex);
        this.setLastIndex(i);
        if (this.scores.scoreVector.size() > 0 && this.allowDown()) {
            g.drawImage(downImage, 176, 115, 24);
        }
        if (this.scores.scoreVector.size() > 0 && this.allowUp()) {
            g.drawImage(upImage, 176, 105, 40);
        }
    }

    public static int paintScoreList(Graphics g, int y, ScoreList scores, int startIndex) {
        int i = 0;
        boolean toggle = false;
        for (i = 0; i < startIndex; ++i) {
            toggle = !toggle;
        }
        if (scores.scoreVector.size() != 0) {
            int w = Displayable.score.width * 6;
            for (i = startIndex; i < scores.scoreVector.size(); ++i) {
                Score tmpScore = (Score)scores.scoreVector.elementAt(i);
                if (toggle) {
                    g.setColor(color1);
                } else {
                    g.setColor(color2);
                }
                g.fillRect(g.getClipX(), y, g.getClipWidth(), g.getFont().getHeight() + 2);
                g.setColor(0xFFFFFF);
                boolean bl = toggle = !toggle;
                if (y - 2 > g.getClipHeight() - 2 * g.getFont().getHeight()) {
                    --i;
                    break;
                }
                Displayable.score.digits = 4;
                Displayable.score.value = (int)tmpScore.value;
                Displayable.score.paint(g, 0, y);
                if (tmpScore.sync) {
                    g.drawString(String.valueOf(String.valueOf(tmpScore.name)).concat("*"), w, y, 20);
                } else {
                    g.drawString(tmpScore.name, w, y, 20);
                }
                y = y + g.getFont().getHeight() + 2;
            }
            return i;
        }
        g.drawString("- empty -", 88, 110, 17);
        return -1;
    }

    public void setLastIndex(int i) {
        this.lastIndex = i;
    }
}

