/*
 * Decompiled with CFR 0.152.
 */
import com.bsg.nokia.BSCanvas;
import com.nokia.mid.sound.Sound;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.Vector;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Gauge;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class BVWCanvas
extends BSCanvas {
    public int[][] testCoords = new int[][]{{-1, -1}, {-1, 0}, {-1, 1}, {0, -1}, {0, 1}, {1, -1}, {1, 0}, {1, 1}, {-2, -2}, {-2, -1}, {-2, 0}, {-2, 1}, {-2, 2}, {2, -2}, {2, -1}, {2, 0}, {2, 1}, {2, 2}, {-1, -2}, {-1, 2}, {0, -2}, {0, 2}, {1, -2}, {1, 2}};
    public int Black;
    public int White;
    public byte[][] board = new byte[9][9];
    public int presentTurn;
    private Image BackBuffer;
    private Image Board;
    private Graphics BackSurface;
    private Image WhiteScore;
    private Graphics WhitePane;
    private Image BlackScore;
    private Graphics BlackPane;
    private int CounterSize = 16;
    int humanColour;
    int SelectX;
    int SelectY;
    int SelectedX;
    int SelectedY;
    public ComputerThread AIThread;
    public Sound c2Melody;
    public Sound won;
    public Sound lost;

    public void nextLevel(Gauge progress) {
    }

    public BVWCanvas() {
        try {
            byte[] sound1 = new byte[]{2, 74, 58, 81, -47, -107, -51, -48, 4, 0, 27, 32, 70, 0, 0};
            this.c2Melody = new Sound(sound1, 1);
            this.c2Melody.init(sound1, 1);
            sound1 = new byte[]{2, 74, 58, 81, -47, -107, -51, -48, 4, 0, 27, 24, 70, 4, -32, 86, 5, -96, 98, 0, 0};
            this.won = new Sound(sound1, 1);
            this.won.init(sound1, 1);
            sound1 = new byte[]{2, 74, 58, 81, -47, -107, -51, -48, 4, 0, 27, 24, 98, 5, -96, 86, 4, -32, 70, 0, 0};
            this.lost = new Sound(sound1, 1);
            this.lost.init(sound1, 1);
            this.BackBuffer = Image.createImage((int)this.getWidth(), (int)this.getHeight());
            this.BackSurface = this.BackBuffer.getGraphics();
            this.Board = Image.createImage((String)"/Board7650.png");
            this.WhiteScore = Image.createImage((int)30, (int)72);
            this.WhitePane = this.WhiteScore.getGraphics();
            this.BlackScore = Image.createImage((int)30, (int)72);
            this.BlackPane = this.BlackScore.getGraphics();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void keyPressed(int keyCode) {
        if (this.presentTurn == this.humanColour) {
            if (keyCode == -7) {
                this.commandListener.commandAction(BSCanvas.DISPLAY_MENU, (Displayable)this);
                return;
            }
            if (this.paused) {
                return;
            }
            int action = this.getGameAction(keyCode);
            if (action == 2 || keyCode == 52) {
                --this.SelectX;
                if (this.SelectX < 0) {
                    this.SelectX = 0;
                }
            } else if (action == 1 || keyCode == 50) {
                --this.SelectY;
                if (this.SelectY < 0) {
                    this.SelectY = 0;
                }
            } else if (action == 5 || keyCode == 54) {
                ++this.SelectX;
                if (this.SelectX > 8) {
                    this.SelectX = 8;
                }
            } else if (action == 6 || keyCode == 56) {
                ++this.SelectY;
                if (this.SelectY > 8) {
                    this.SelectY = 8;
                }
            }
            if (action == 8 || keyCode == 53) {
                if (this.SelectedX >= 0 && this.SelectedY >= 0) {
                    if (this.SelectX == this.SelectedX && this.SelectY == this.SelectedY) {
                        this.SelectedX = -1;
                        this.SelectedY = -1;
                    } else if (this.board[this.SelectY][this.SelectX] != 0) {
                        this.SelectedX = -1;
                        this.SelectedY = -1;
                    } else {
                        if (Math.abs(this.SelectX - this.SelectedX) < 3 && Math.abs(this.SelectY - this.SelectedY) < 3) {
                            this.ExecuteMove(this.SelectedX, this.SelectedY, this.SelectX, this.SelectY);
                            this.SelectedX = -1;
                            this.SelectedY = -1;
                            this.UnifiedMethod(2);
                            this.paintBackBuffer(this.BackSurface);
                            this.UnifiedMethod(-1);
                            int cc = 0;
                            cc = this.humanColour == 1 ? 2 : 1;
                            if (!this.LegalMove(cc)) {
                                this.FinaliseBoard(this.humanColour);
                                this.UnifiedMethod(2);
                                this.paintBackBuffer(this.BackSurface);
                                this.UnifiedMethod(-1);
                                this.presentTurn = 10;
                                this.UnifiedMethod(0);
                                return;
                            }
                            this.UnifiedMethod(1);
                            this.UnifiedMethod(0);
                            return;
                        }
                        this.SelectedX = -1;
                        this.SelectedY = -1;
                    }
                } else if (this.board[this.SelectY][this.SelectX] == this.humanColour) {
                    this.SelectedX = this.SelectX;
                    this.SelectedY = this.SelectY;
                } else if (this.Near(this.SelectX, this.SelectY, this.humanColour) != null) {
                    byte[] b = this.Near(this.SelectX, this.SelectY, this.humanColour);
                    this.ExecuteMove(b[0], b[1], this.SelectX, this.SelectY);
                    this.SelectedX = -1;
                    this.SelectedY = -1;
                    this.UnifiedMethod(2);
                    this.paintBackBuffer(this.BackSurface);
                    this.UnifiedMethod(-1);
                    int cc = 0;
                    cc = this.humanColour == 1 ? 2 : 1;
                    if (!this.LegalMove(cc)) {
                        this.FinaliseBoard(this.humanColour);
                        this.UnifiedMethod(2);
                        this.paintBackBuffer(this.BackSurface);
                        this.UnifiedMethod(-1);
                        this.presentTurn = 10;
                        this.UnifiedMethod(0);
                        return;
                    }
                    this.UnifiedMethod(1);
                    this.UnifiedMethod(0);
                    return;
                }
            }
            this.paintBackBuffer(this.BackSurface);
            this.UnifiedMethod(-1);
        } else {
            this.UnifiedMethod(0);
        }
    }

    public void loadGame(byte[] saveData, Gauge progress) {
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(saveData);
            DataInputStream in = new DataInputStream(is);
            for (int y = 0; y < 9; ++y) {
                for (int x = 0; x < 9; ++x) {
                    this.board[y][x] = in.readByte();
                }
            }
            this.humanColour = in.readByte();
            this.SelectX = in.readByte();
            this.SelectY = in.readByte();
            this.SelectedX = in.readByte();
            this.SelectedY = in.readByte();
            this.presentTurn = this.humanColour;
            this.UnifiedMethod(2);
            this.WriteScores();
            this.paintBackBuffer(this.BackSurface);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public byte[] saveGame(Gauge progress) {
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(os);
            for (int y = 0; y < 9; ++y) {
                for (int x = 0; x < 9; ++x) {
                    out.writeByte(this.board[y][x]);
                }
            }
            out.writeByte((byte)this.humanColour);
            out.writeByte((byte)this.SelectX);
            out.writeByte((byte)this.SelectY);
            out.writeByte((byte)this.SelectedX);
            out.writeByte((byte)this.SelectedY);
            byte[] byArray = os.toByteArray();
            return byArray;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void startGame(int diff, Gauge progress) {
        this.SelectedX = -1;
        this.SelectedY = -1;
        this.presentTurn = 2;
        for (int y = 0; y < 9; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.board[y][x] = 0;
            }
        }
        if (diff < 0) {
            this.humanColour = 1;
            diff = -diff;
            this.SelectX = 0;
            this.SelectY = 0;
        } else {
            this.humanColour = 2;
            this.SelectX = 8;
            this.SelectY = 8;
        }
        if (diff > 20) {
            int nc = diff - 20;
            for (int i = 0; i < nc * 2; ++i) {
                int x = BSCanvas.getRandom(9);
                int y = BSCanvas.getRandom(9);
                if (this.board[y][x] == 0) {
                    if (i % 2 == 0) {
                        this.board[y][x] = 2;
                        if (this.humanColour != 2) continue;
                        this.SelectX = x;
                        this.SelectY = y;
                        continue;
                    }
                    this.board[y][x] = 1;
                    if (this.humanColour != 1) continue;
                    this.SelectX = x;
                    this.SelectY = y;
                    continue;
                }
                --i;
            }
        } else {
            int[][] bdat = new int[][]{{8, 8}, {7, 7}, {8, 7}, {7, 8}, {6, 6}};
            int[][] wdat = new int[][]{{0, 0}, {1, 1}, {1, 0}, {0, 1}, {2, 2}};
            int nc = diff - 10;
            for (int x = 0; x < nc; ++x) {
                this.board[bdat[x][0]][bdat[x][1]] = 2;
                this.board[wdat[x][0]][wdat[x][1]] = 1;
            }
        }
        this.UnifiedMethod(2);
        this.WriteScores();
        this.paintBackBuffer(this.BackSurface);
        this.commandListener.commandAction(BSCanvas.DISPLAY_CANVAS, (Displayable)this);
        System.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.presentTurn))).append(":").append(this.humanColour))));
    }

    public synchronized void UnifiedMethod(int i) {
        if (i == -1) {
            this.repaint();
        }
        if (!(i != 0 || this.AIThread != null && this.AIThread.running)) {
            this.AIThread = new ComputerThread();
        }
        if (i == 1) {
            this.presentTurn = this.presentTurn == 1 ? 2 : 1;
        }
        if (i == 2) {
            this.countUp();
        }
        if (i == 3) {
            if (this.humanColour == 1) {
                this.score = this.White;
                if (this.White > this.Black) {
                    BSCanvas.playSound(this.won);
                } else {
                    BSCanvas.playSound(this.lost);
                }
            } else {
                this.score = this.Black;
                if (this.White < this.Black) {
                    BSCanvas.playSound(this.won);
                } else {
                    BSCanvas.playSound(this.lost);
                }
            }
            this.commandListener.commandAction(BSCanvas.LEVEL_ENDED, (Displayable)this);
        }
    }

    public void WriteScores() {
        int h = this.BlackPane.getFont().getHeight();
        this.WhitePane.drawImage(this.Board, this.WhiteScore.getWidth(), -this.WhiteScore.getHeight(), 24);
        this.WhitePane.setColor(0);
        this.WhitePane.drawString("".concat(String.valueOf(String.valueOf(this.White))), this.WhiteScore.getWidth() / 2, (this.WhiteScore.getHeight() - h) / 2, 17);
        this.BlackPane.drawImage(this.Board, this.BlackScore.getWidth(), 0, 24);
        this.BlackPane.setColor(0xFFFFFF);
        this.BlackPane.drawString("".concat(String.valueOf(String.valueOf(this.Black))), this.BlackScore.getWidth() / 2, (this.BlackScore.getHeight() - h) / 2, 17);
    }

    private void countUp() {
        this.White = 0;
        this.Black = 0;
        for (int x = 0; x < 9; ++x) {
            for (int y = 0; y < 9; ++y) {
                if (this.board[x][y] == 1) {
                    ++this.White;
                    continue;
                }
                if (this.board[x][y] != 2) continue;
                ++this.Black;
            }
        }
        this.WriteScores();
    }

    private void DrawCounters(Graphics g) {
        int i = this.CounterSize * 3 / 4 - 1;
        g.setColor(0xFFFFFF);
        for (int j = 0; j < 9; ++j) {
            for (int k = 0; k < 9; ++k) {
                if (this.board[j][k] == 1) {
                    g.setColor(0xFFFFFF);
                    g.fillArc(k * this.CounterSize + 2, j * this.CounterSize + 2, i, i, 0, 360);
                    continue;
                }
                if (this.board[j][k] != 2) continue;
                g.setColor(0);
                g.fillArc(k * this.CounterSize + 2, j * this.CounterSize + 2, i, i, 0, 360);
            }
        }
    }

    public void paintBackBuffer(Graphics g) {
        g.setColor(0);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.drawImage(this.Board, 0, 0, 0x10 | 4);
        g.drawImage(this.WhiteScore, this.getWidth(), 0, 0x10 | 8);
        g.drawImage(this.BlackScore, this.getWidth(), this.WhiteScore.getHeight(), 0x10 | 8);
        this.DrawCounters(g);
        if (this.SelectedX >= 0 && this.SelectedY >= 0) {
            g.setColor(0xFFFC00);
            g.drawRect(this.SelectedX * this.CounterSize + 1, this.SelectedY * this.CounterSize + 1, this.CounterSize - 2, this.CounterSize - 2);
        }
        g.setColor(0xFFFC00);
        g.drawRect(this.SelectX * this.CounterSize, this.SelectY * this.CounterSize, this.CounterSize, this.CounterSize);
    }

    public void paint(Graphics g) {
        g.drawImage(this.BackBuffer, 0, 0, 0x10 | 4);
        if (this.paused) {
            this.drawText(g, this.langT[14], this.getWidth() / 2, this.getHeight() / 2);
            return;
        }
        if (this.presentTurn == 10) {
            this.drawText(g, this.langT[3], this.getWidth() / 2, this.getHeight() - g.getFont().getHeight() - 2);
            return;
        }
        if (this.humanColour != this.presentTurn && this.AIThread != null && this.AIThread.running && this.AIThread.displayText) {
            this.drawText(g, this.langT[15], this.getWidth() / 2, this.getHeight() / 2);
        }
    }

    public void drawText(Graphics g, String text, int centerX, int topY) {
        Font f = g.getFont();
        int Sw = f.stringWidth(text);
        int Sh = f.getHeight();
        g.setColor(0);
        g.fillRect(centerX - Sw / 2 - 1, topY - 2, Sw, Sh);
        g.setColor(0xFFFFFF);
        g.drawString(text, centerX, topY, 0x10 | 1);
    }

    public void ExecuteMove(int SelectedX, int SelectedY, int SelectX, int SelectY) {
        try {
            BSCanvas.playSound(this.c2Melody);
            byte col = this.board[SelectedY][SelectedX];
            if (Math.abs(SelectX - SelectedX) < 2 && Math.abs(SelectY - SelectedY) < 2) {
                this.ExpandMove(SelectX, SelectY, col);
            } else {
                this.board[SelectedY][SelectedX] = 0;
                this.ExpandMove(SelectX, SelectY, col);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void ExpandMove(int x, int y, int col) {
        this.board[y][x] = (byte)col;
        for (int i = 0; i < 8; ++i) {
            int yi = y + this.testCoords[i][0];
            int xi = x + this.testCoords[i][1];
            if (yi <= -1 || yi >= 9 || xi <= -1 || xi >= 9 || this.board[yi][xi] == 0) continue;
            if (this.board[yi][xi] != col) {
                BSCanvas.vibrate(50, 500);
            }
            this.board[yi][xi] = (byte)col;
        }
    }

    private byte[] Near(int x, int y, int col) {
        for (int i = 0; i < 8; ++i) {
            int yi = y + this.testCoords[i][0];
            int xi = x + this.testCoords[i][1];
            if (yi <= -1 || yi >= 9 || xi <= -1 || xi >= 9 || this.board[yi][xi] != col) continue;
            return new byte[]{(byte)xi, (byte)yi};
        }
        return null;
    }

    public byte CapturePieces(int x, int y, int humanColour) {
        byte retdat = 0;
        for (int i = 0; i < 8; ++i) {
            int xi = x + this.testCoords[i][0];
            int yi = y + this.testCoords[i][1];
            if (yi <= -1 || yi >= 9 || xi <= -1 || xi >= 9 || this.board[yi][xi] != humanColour) continue;
            retdat = (byte)(retdat + 1);
        }
        return retdat;
    }

    public boolean LegalMove(int col) {
        for (int y = 0; y < 9; ++y) {
            for (int x = 0; x < 9; ++x) {
                if (this.board[y][x] != col) continue;
                for (int i = 0; i < 24; ++i) {
                    int yi = y + this.testCoords[i][1];
                    int xi = x + this.testCoords[i][0];
                    if (yi <= -1 || yi >= 9 || xi <= -1 || xi >= 9 || this.board[yi][xi] != 0) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public void FinaliseBoard(int col) {
        for (int y = 0; y < 9; ++y) {
            for (int x = 0; x < 9; ++x) {
                if (this.board[y][x] != 0) continue;
                this.board[y][x] = (byte)col;
            }
        }
    }

    private class ComputerThread
    extends Thread {
        private int bar = 0;
        public boolean running = true;
        public boolean displayText = true;

        public ComputerThread() {
            this.start();
        }

        public void run() {
            if (BVWCanvas.this.presentTurn == 10) {
                BVWCanvas.this.UnifiedMethod(-1);
                try {
                    Thread.sleep(2000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                BVWCanvas.this.UnifiedMethod(3);
                this.running = false;
                return;
            }
            try {
                BVWCanvas.this.UnifiedMethod(-1);
                Thread.sleep(1000L);
                byte col = 0;
                col = BVWCanvas.this.humanColour == 1 ? (byte)2 : 1;
                Vector<byte[]> Pieces = new Vector<byte[]>();
                Vector<byte[]> Moves = new Vector<byte[]>();
                for (int y = 0; y < 9; ++y) {
                    for (int x = 0; x < 9; ++x) {
                        if (BVWCanvas.this.board[y][x] != col) continue;
                        Pieces.addElement(new byte[]{(byte)x, (byte)y});
                    }
                }
                for (int i = 0; i < Pieces.size(); ++i) {
                    byte[] data = (byte[])Pieces.elementAt(i);
                    for (int j = 0; j < 24; ++j) {
                        int xi = data[0] + BVWCanvas.this.testCoords[j][0];
                        int yi = data[1] + BVWCanvas.this.testCoords[j][1];
                        if (yi <= -1 || yi >= 9 || xi <= -1 || xi >= 9 || BVWCanvas.this.board[yi][xi] != 0) continue;
                        byte rating = 0;
                        if (j < 8) {
                            rating = (byte)(rating + 1);
                        }
                        if ((rating = (byte)((byte)(rating + BVWCanvas.this.CapturePieces(xi, yi, BVWCanvas.this.humanColour)))) <= 0) continue;
                        Moves.addElement(new byte[]{data[0], data[1], (byte)xi, (byte)yi, rating});
                    }
                }
                byte[] winningMove = (byte[])Moves.elementAt(0);
                for (int i = 0; i < Moves.size(); ++i) {
                    byte[] d = (byte[])Moves.elementAt(i);
                    if (d[4] > winningMove[4]) {
                        winningMove = d;
                        continue;
                    }
                    if (d[4] != winningMove[4] || BSCanvas.getRandom(100) <= 60) continue;
                    winningMove = d;
                }
                this.displayText = false;
                BVWCanvas.this.paintBackBuffer(BVWCanvas.this.BackSurface);
                BVWCanvas.this.UnifiedMethod(-1);
                Thread.sleep(1000L);
                BVWCanvas.this.ExecuteMove(winningMove[0], winningMove[1], winningMove[2], winningMove[3]);
                BVWCanvas.this.UnifiedMethod(2);
                BVWCanvas.this.paintBackBuffer(BVWCanvas.this.BackSurface);
                BVWCanvas.this.UnifiedMethod(-1);
                Thread.sleep(500L);
                if (!BVWCanvas.this.LegalMove(BVWCanvas.this.humanColour)) {
                    BVWCanvas.this.FinaliseBoard(col);
                    BVWCanvas.this.UnifiedMethod(2);
                    BVWCanvas.this.paintBackBuffer(BVWCanvas.this.BackSurface);
                    BVWCanvas.this.UnifiedMethod(-1);
                    BVWCanvas.this.presentTurn = 10;
                    this.running = false;
                    BVWCanvas.this.UnifiedMethod(0);
                    return;
                }
                this.running = false;
                BVWCanvas.this.UnifiedMethod(1);
                BVWCanvas.this.paintBackBuffer(BVWCanvas.this.BackSurface);
                BVWCanvas.this.UnifiedMethod(-1);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

