/*
 * Decompiled with CFR 0.152.
 */
package com.bsg.bw.nokiacolor;

import com.bsg.bw.nokiacolor.Baddy;
import com.bsg.bw.nokiacolor.Fruit;
import com.bsg.bw.nokiacolor.Line;
import com.bsg.nokia.BSCanvas;
import com.nokia.mid.sound.Sound;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Gauge;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class BlackWidowCanvas
extends BSCanvas
implements Runnable {
    private Thread instance;
    private boolean running;
    private Image backBuffer;
    private Image statusBarImage;
    private Image baddyImages;
    private Image playerImages;
    private Image fruitImages;
    private Image stunnersImage;
    private Image livesImage;
    private Image[] digits;
    private Image optionsImage;
    private Graphics backSurface;
    private Graphics statusBarSurface;
    private int levelScore;
    private int totalLength;
    private int extraLifeAt;
    private int extraLifeCounter;
    private int extraStunnerAt;
    private int extraStunnerCounter;
    private int levelTime;
    private int fruitTimer;
    private int stunTimer;
    private boolean up;
    private boolean upHeld;
    private boolean down;
    private boolean downHeld;
    private boolean left;
    private boolean leftHeld;
    private boolean right;
    private boolean rightHeld;
    private boolean fire;
    private Line[] lines;
    private int pXPos;
    private int pOldXPos;
    private int pYPos;
    private int pOldYPos;
    private int pLine;
    private int pOrigXPos;
    private int pOrigYPos;
    private int pOrigLine;
    private int pOldLine;
    private int pMove;
    private int pCurrentMove;
    private int pCurrentFrame;
    private int pFrameCounter;
    private int pStunner;
    private int pLives;
    private int pWidth;
    private int pHalfWidth;
    private int pHeight;
    private int pHalfHeight;
    private int bWidth;
    private int bHalfWidth;
    private int bHeight;
    private int bHalfHeight;
    private int fWidth;
    private int fHalfWidth;
    private int fHeight;
    private int fHalfHeight;
    private int screenWidth;
    private int halfScreenWidth;
    private int screenHeight;
    private int halfScreenHeight;
    private int statusBarHeight = 7;
    private int backBufferWidth;
    private int backBufferHeight;
    private int xOffSet;
    private int yOffSet;
    private int segmentLength;
    private int difficulty;
    private int currentLevel;
    public static final int L_UP = 0;
    public static final int L_DOWN = 1;
    public static final int L_LEFT = 2;
    public static final int L_RIGHT = 3;
    private boolean levelClear;
    private boolean gameover;
    private boolean won;
    private boolean dead;
    private boolean start;
    private boolean stunned;
    private boolean keyPressed;
    private Baddy baddy;
    private Vector fruit;
    boolean updateStatus;
    boolean extraLife;
    boolean extraStunner;
    private Sound[] sounds;
    private final byte[][] soundBytes = new byte[][]{{2, 74, 58, 81, -47, -107, -51, -48, 4, 0, 27, 24, 70, 4, -32, 86, 5, -96, 98, 0, 0}, {2, 74, 58, 81, -47, -107, -51, -48, 4, 0, 27, 24, 98, 5, -96, 86, 4, -32, 70, 0, 0}, {2, 74, 58, 81, -47, -107, -51, -48, 4, 0, 27, 24, 69, -123, 96, 90, 6, 32, -94, 44, 65, 22, 0, 0}, {2, 74, 58, 81, -47, -107, -51, -48, 4, 0, 27, 20, -125, 12, 0, 0}, {2, 74, 58, 81, -47, -107, -51, -48, 4, 0, 27, 32, 86, 0, 0}, {2, 74, 58, 81, -47, -107, -51, -48, 4, 0, 27, 20, -94, -84, 0, 0}};
    private final int WONMELODY;
    private final int DEADMELODY;
    private final int BONUSMELODY;
    private final int BEEP_LOW;
    private final int BEEP_MED;
    private final int BEEP_HIGH;

    public BlackWidowCanvas(int n) {
        this.WONMELODY = 0;
        this.DEADMELODY = 1;
        this.BONUSMELODY = 2;
        this.BEEP_LOW = 3;
        this.BEEP_MED = 4;
        this.BEEP_HIGH = 5;
        this.screenWidth = this.getWidth();
        this.halfScreenWidth = this.screenWidth / 2;
        this.screenHeight = this.getHeight() - this.statusBarHeight;
        this.halfScreenHeight = this.screenHeight / 2;
        this.sounds = new Sound[this.soundBytes.length];
        for (int i = 0; i < this.sounds.length; ++i) {
            this.sounds[i] = new Sound(this.soundBytes[i], 1);
            this.sounds[i].init(this.soundBytes[i], 1);
        }
        try {
            this.baddyImages = Image.createImage((String)"/EnemyImages.png");
            this.playerImages = Image.createImage((String)"/PlayerImages.png");
            this.fruitImages = Image.createImage((String)"/FruitImages.png");
            Image image = Image.createImage((String)"/Status.png");
            this.livesImage = this.getImage(image, 7, 7, -30, 0);
            this.stunnersImage = this.getImage(image, 5, 7, -37, 0);
            this.optionsImage = this.getImage(image, image.getWidth() - 42, 7, -42, 0);
            this.digits = new Image[10];
            for (int i = 0; i < this.digits.length; ++i) {
                this.digits[i] = this.getImage(image, 3, 5, -3 * i, 0);
            }
            this.statusBarImage = Image.createImage((int)this.screenWidth, (int)12);
            this.statusBarSurface = this.statusBarImage.getGraphics();
        }
        catch (Exception exception) {
            System.out.println("Failed To Load Images");
        }
        this.pWidth = this.playerImages.getWidth() / 2;
        this.pHalfWidth = this.pWidth / 2;
        this.pHeight = this.playerImages.getHeight() / 4;
        this.pHalfHeight = this.pHeight / 2;
        this.bWidth = this.baddyImages.getWidth() / 2;
        this.bHalfWidth = this.bWidth / 2;
        this.bHeight = this.baddyImages.getHeight() / 4;
        this.bHalfHeight = this.bHeight / 2;
        this.fWidth = this.fruitImages.getWidth() / 3;
        this.fHalfWidth = this.fWidth / 2;
        this.fHeight = this.fruitImages.getHeight();
        this.fHalfHeight = this.fHeight / 2;
        this.segmentLength = n;
        this.backBuffer = Image.createImage((int)(18 * this.segmentLength), (int)(18 * this.segmentLength));
        this.backSurface = this.backBuffer.getGraphics();
    }

    public Image getImage(Image image, int n, int n2, int n3, int n4) {
        Image image2 = Image.createImage((int)n, (int)n2);
        Graphics graphics = image2.getGraphics();
        graphics.drawImage(image, n3, n4, 20);
        return image2;
    }

    public void startGame(int n, Gauge gauge) {
        this.difficulty = n;
        this.currentLevel = 0;
        this.score = 0;
        this.pStunner = 1;
        this.pLives = 3;
        this.extraLifeAt = 3000 * (this.difficulty + 1);
        this.extraStunnerAt = 750 * (this.difficulty + 1);
        try {
            this.loadLevel(gauge, null);
        }
        catch (Exception exception) {
            System.out.println("Error Loading Level 1");
        }
        this.commandListener.commandAction(BSCanvas.DISPLAY_CANVAS, (Displayable)this);
    }

    public void loadLevel(Gauge gauge, DataInputStream dataInputStream) throws IOException {
        int n;
        int n2;
        InputStream inputStream = this.getClass().getResourceAsStream(String.valueOf(String.valueOf(new StringBuffer("/Levels/level").append(this.currentLevel).append(".txt"))));
        DataInputStream dataInputStream2 = new DataInputStream(inputStream);
        this.lines = new Line[dataInputStream2.readByte()];
        gauge.setValue(20);
        for (n2 = 0; n2 < this.lines.length; ++n2) {
            this.lines[n2] = new Line(n2, this.segmentLength, dataInputStream2.readByte(), dataInputStream2.readByte(), dataInputStream2.readByte(), dataInputStream2.readByte(), dataInputStream2.readByte(), dataInputStream2.readByte(), dataInputStream2.readByte(), dataInputStream2.readByte(), dataInputStream2.readByte(), dataInputStream2.readByte(), dataInputStream2.readByte(), dataInputStream2.readByte());
        }
        this.pMove = this.difficulty + 1;
        gauge.setValue(40);
        if (dataInputStream == null) {
            this.pOrigXPos = this.pXPos = dataInputStream2.readByte() * this.segmentLength;
            this.pOrigYPos = this.pYPos = dataInputStream2.readByte() * this.segmentLength;
            this.pOrigLine = this.pLine = (int)dataInputStream2.readByte();
            this.levelTime = 0;
            this.fruitTimer = 0;
            this.pCurrentMove = 0;
        } else {
            this.pOrigXPos = dataInputStream2.readByte() * this.segmentLength;
            this.pOrigYPos = dataInputStream2.readByte() * this.segmentLength;
            this.pOrigLine = dataInputStream2.readByte();
        }
        this.baddy = new Baddy(dataInputStream2.readByte() * this.segmentLength, dataInputStream2.readByte() * this.segmentLength, dataInputStream2.readByte(), this.pMove, 70, this.lines);
        dataInputStream2.close();
        gauge.setValue(60);
        this.fruit = new Vector(5);
        n2 = 0;
        int n3 = 0;
        this.totalLength = 0;
        for (n = 0; n < this.lines.length; ++n) {
            this.totalLength += this.lines[n].length;
            if (this.lines[n].xPos2 > n2) {
                n2 = this.lines[n].xPos2;
            }
            if (this.lines[n].yPos2 <= n3) continue;
            n3 = this.lines[n].yPos2;
        }
        gauge.setValue(70);
        this.pOldLine = 0;
        this.backBufferWidth = n2 + this.segmentLength;
        this.backBufferHeight = n3 + this.segmentLength;
        this.xOffSet = this.backBufferWidth < this.screenWidth ? (this.screenWidth - this.backBufferWidth) / 2 : 0;
        this.yOffSet = this.backBufferHeight < this.screenHeight ? (this.screenHeight - this.backBufferHeight) / 2 : 0;
        gauge.setValue(80);
        this.backSurface.setColor(0xFFFFFF);
        this.backSurface.fillRect(0, 0, this.backBuffer.getWidth(), this.backBuffer.getHeight());
        this.backSurface.setColor(0);
        for (n = 0; n < this.lines.length; ++n) {
            if (this.lines[n].type == 0) {
                this.backSurface.drawLine(this.lines[n].xPos1 - 1, this.lines[n].yPos1 - 1, this.lines[n].xPos2 + 1, this.lines[n].yPos2 - 1);
                this.backSurface.drawLine(this.lines[n].xPos1 - 1, this.lines[n].yPos1, this.lines[n].xPos2 + 1, this.lines[n].yPos2);
                this.backSurface.drawLine(this.lines[n].xPos1 - 1, this.lines[n].yPos1 + 1, this.lines[n].xPos2 + 1, this.lines[n].yPos2 + 1);
                continue;
            }
            if (this.lines[n].type != 1) continue;
            this.backSurface.drawLine(this.lines[n].xPos1 - 1, this.lines[n].yPos1 - 1, this.lines[n].xPos2 - 1, this.lines[n].yPos2 + 1);
            this.backSurface.drawLine(this.lines[n].xPos1, this.lines[n].yPos1 - 1, this.lines[n].xPos2, this.lines[n].yPos2 + 1);
            this.backSurface.drawLine(this.lines[n].xPos1 + 1, this.lines[n].yPos1 - 1, this.lines[n].xPos2 + 1, this.lines[n].yPos2 + 1);
        }
        this.backSurface.setColor(65280);
        gauge.setValue(100);
        this.stop();
        this.start = true;
        this.won = false;
        this.dead = false;
        this.gameover = false;
        this.levelClear = false;
        this.paused = false;
        this.keyPressed = false;
        this.extraLife = false;
        this.extraLifeCounter = 0;
        this.extraStunner = false;
        this.extraStunnerCounter = 0;
        this.levelScore = 0;
        this.stunTimer = 0;
        this.updateStatus = true;
    }

    public void nextLevel(Gauge gauge) {
        ++this.currentLevel;
        try {
            this.loadLevel(gauge, null);
        }
        catch (Exception exception) {
            this.currentLevel = 0;
            try {
                this.loadLevel(gauge, null);
            }
            catch (Exception exception2) {
                System.out.println("Couldnt loop levels");
            }
        }
        this.commandListener.commandAction(BSCanvas.DISPLAY_CANVAS, (Displayable)this);
    }

    public void loadGame(byte[] byArray, Gauge gauge) {
        try {
            int n;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            this.currentLevel = dataInputStream.readByte();
            this.difficulty = dataInputStream.readByte();
            this.pLives = dataInputStream.readByte();
            this.pStunner = dataInputStream.readByte();
            this.pXPos = dataInputStream.readInt();
            this.pYPos = dataInputStream.readInt();
            this.pCurrentMove = dataInputStream.readByte();
            this.pLine = dataInputStream.readByte();
            this.extraLifeAt = dataInputStream.readInt();
            this.extraStunnerAt = dataInputStream.readInt();
            this.score = dataInputStream.readInt();
            this.levelTime = dataInputStream.readInt();
            this.fruitTimer = dataInputStream.readInt();
            this.loadLevel(gauge, dataInputStream);
            for (n = 0; n < this.lines.length; ++n) {
                this.lines[n].oldCursor = dataInputStream.readInt();
                this.lines[n].newCursor = dataInputStream.readInt();
                this.lines[n].filled1 = dataInputStream.readInt();
                this.lines[n].filled2 = dataInputStream.readInt();
                this.lines[n].filled = dataInputStream.readBoolean();
                if (this.lines[n].type == 0) {
                    if (this.lines[n].filled1 > 0) {
                        this.backSurface.drawLine(this.lines[n].xPos1, this.lines[n].yPos1, this.lines[n].xPos1 + this.lines[n].filled1, this.lines[n].yPos1);
                    }
                    if (this.lines[n].filled2 == this.lines[n].length) continue;
                    this.backSurface.drawLine(this.lines[n].xPos2, this.lines[n].yPos2, this.lines[n].xPos1 + this.lines[n].filled2, this.lines[n].yPos1);
                    continue;
                }
                if (this.lines[n].filled1 > 0) {
                    this.backSurface.drawLine(this.lines[n].xPos1, this.lines[n].yPos1, this.lines[n].xPos1, this.lines[n].yPos1 + this.lines[n].filled1);
                }
                if (this.lines[n].filled2 == this.lines[n].length) continue;
                this.backSurface.drawLine(this.lines[n].xPos2, this.lines[n].yPos2, this.lines[n].xPos1, this.lines[n].yPos1 + this.lines[n].filled2);
            }
            this.baddy.bXPos = dataInputStream.readInt();
            this.baddy.bYPos = dataInputStream.readInt();
            this.baddy.bLine = dataInputStream.readByte();
            this.baddy.bCurrentMove = dataInputStream.readByte();
            n = dataInputStream.readByte();
            for (int i = 0; i < n; ++i) {
                this.fruit.addElement(new Fruit(dataInputStream.readInt(), dataInputStream.readInt(), dataInputStream.readByte()));
            }
            dataInputStream.close();
        }
        catch (Exception exception) {
            System.out.println("Error Loading Saved Data");
        }
    }

    public byte[] saveGame(Gauge gauge) {
        try {
            int n;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeByte(this.currentLevel);
            dataOutputStream.writeByte(this.difficulty);
            dataOutputStream.writeByte(this.pLives);
            dataOutputStream.writeByte(this.pStunner);
            dataOutputStream.writeInt(this.pXPos);
            dataOutputStream.writeInt(this.pYPos);
            dataOutputStream.writeByte(this.pCurrentMove);
            dataOutputStream.writeByte(this.pLine);
            dataOutputStream.writeInt(this.extraLifeAt);
            dataOutputStream.writeInt(this.extraStunnerAt);
            dataOutputStream.writeInt(this.score);
            dataOutputStream.writeInt(this.levelTime);
            dataOutputStream.writeInt(this.fruitTimer);
            for (n = 0; n < this.lines.length; ++n) {
                dataOutputStream.writeInt(this.lines[n].oldCursor);
                dataOutputStream.writeInt(this.lines[n].newCursor);
                dataOutputStream.writeInt(this.lines[n].filled1);
                dataOutputStream.writeInt(this.lines[n].filled2);
                dataOutputStream.writeBoolean(this.lines[n].filled);
            }
            dataOutputStream.writeInt(this.baddy.bXPos);
            dataOutputStream.writeInt(this.baddy.bYPos);
            dataOutputStream.writeByte(this.baddy.bLine);
            dataOutputStream.writeByte(this.baddy.bCurrentMove);
            dataOutputStream.writeByte(this.fruit.size());
            for (n = 0; n < this.fruit.size(); ++n) {
                Fruit fruit = (Fruit)this.fruit.elementAt(n);
                dataOutputStream.writeInt(fruit.fXPos);
                dataOutputStream.writeInt(fruit.fYPos);
                dataOutputStream.writeByte(fruit.fruitImage);
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
        catch (Exception exception) {
            System.out.println("Error producing Saved data");
            byte[] byArray = null;
            return byArray;
        }
    }

    public void paint(Graphics graphics) {
        int n;
        graphics.setColor(0xFFFFFF);
        graphics.fillRect(0, 0, this.screenWidth, this.screenHeight);
        if (this.updateStatus) {
            this.statusBarSurface.setColor(0xFFFFFF);
            this.statusBarSurface.fillRect(0, 0, this.screenWidth, this.statusBarHeight);
            this.statusBarSurface.drawImage(this.optionsImage, this.screenWidth, this.statusBarHeight, 40);
            n = 0;
            int n2 = 100000;
            for (int i = 6; i > 0; --i) {
                this.statusBarSurface.drawImage(this.digits[this.score / n2 % 10], n, 2, 20);
                n2 /= 10;
                n += this.digits[0].getWidth() + 1;
            }
            this.statusBarSurface.drawImage(this.livesImage, n, 1, 20);
            this.statusBarSurface.drawImage(this.digits[this.pLives / 10 % 10], n += this.livesImage.getWidth() + 1, 2, 20);
            this.statusBarSurface.drawImage(this.digits[this.pLives % 10], n += this.digits[0].getWidth() + 1, 2, 20);
            this.statusBarSurface.drawImage(this.stunnersImage, n += this.digits[0].getWidth() + 1, 0, 20);
            this.statusBarSurface.drawImage(this.digits[this.pStunner / 10 % 10], n += this.stunnersImage.getWidth() + 1, 2, 20);
            this.statusBarSurface.drawImage(this.digits[this.pStunner % 10], n += this.digits[0].getWidth() + 1, 2, 20);
            this.updateStatus = false;
        }
        if (this.pXPos > this.halfScreenWidth && this.backBufferWidth + this.xOffSet > this.screenWidth || this.pXPos < this.halfScreenWidth - this.xOffSet && this.xOffSet < 0) {
            this.xOffSet = this.halfScreenWidth - this.pXPos;
            if (this.backBufferWidth + this.xOffSet < this.screenWidth) {
                this.xOffSet = -(this.backBufferWidth - this.screenWidth);
            } else if (this.xOffSet > 0) {
                this.xOffSet = 0;
            }
        }
        if (this.pYPos > this.halfScreenHeight && this.backBufferHeight + this.yOffSet > this.screenHeight || this.pYPos < this.halfScreenHeight - this.yOffSet && this.yOffSet < 0) {
            this.yOffSet = this.halfScreenHeight - this.pYPos;
            if (this.backBufferHeight + this.yOffSet < this.screenHeight) {
                this.yOffSet = -(this.backBufferHeight - this.screenHeight);
            } else if (this.yOffSet > 0) {
                this.yOffSet = 0;
            }
        }
        graphics.drawImage(this.backBuffer, this.xOffSet, this.yOffSet, 20);
        graphics.setClip(this.xOffSet + this.baddy.bXPos - this.bHalfWidth, this.yOffSet + this.baddy.bYPos - this.bHalfHeight, this.bWidth, this.bHeight);
        graphics.drawImage(this.baddyImages, this.xOffSet + this.baddy.bXPos - this.bWidth * this.baddy.bCurrentFrame - this.bHalfWidth, this.yOffSet + this.baddy.bYPos - this.bHeight * this.baddy.bCurrentMove - this.bHalfHeight, 20);
        graphics.setClip(this.xOffSet + this.pXPos - this.pHalfWidth, this.yOffSet + this.pYPos - this.pHalfHeight, this.pWidth, this.pHeight);
        graphics.drawImage(this.playerImages, this.xOffSet + this.pXPos - this.pWidth * this.pCurrentFrame - this.pHalfWidth, this.yOffSet + this.pYPos - this.pHeight * this.pCurrentMove - this.pHalfHeight, 20);
        if (this.baddy.stunned) {
            ++this.baddy.bCurrentMove;
            if (this.baddy.bCurrentMove == 4) {
                this.baddy.bCurrentMove = 0;
            }
        }
        for (n = 0; n < this.fruit.size(); ++n) {
            Fruit fruit = (Fruit)this.fruit.elementAt(n);
            graphics.setClip(fruit.fXPos + this.xOffSet - this.fHalfWidth, fruit.fYPos + this.yOffSet - this.fHalfHeight, this.fWidth, this.fWidth);
            graphics.drawImage(this.fruitImages, fruit.fXPos + this.xOffSet - this.fWidth * fruit.fruitImage - this.fHalfWidth, fruit.fYPos + this.yOffSet - this.fHalfHeight, 20);
        }
        graphics.setClip(0, 0, this.screenWidth, this.screenHeight + this.statusBarHeight);
        graphics.drawImage(this.statusBarImage, 0, this.screenHeight, 20);
        if (this.extraLife && !this.extraStunner) {
            this.drawText(graphics, this.parseString(this.langT[4]), this.getFont(this.langA[4]), true, this.halfScreenWidth, 5);
        } else if (this.extraStunner && !this.extraLife) {
            this.drawText(graphics, this.parseString(this.langT[5]), this.getFont(this.langA[5]), true, this.halfScreenWidth, 5);
        } else if (this.extraLife && this.extraStunner) {
            this.drawText(graphics, this.parseString(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.langT[4]))).append(",").append(this.langT[5])))), this.getFont(this.langA[4]), true, this.halfScreenWidth, 5);
        }
        if (this.start) {
            this.drawText(graphics, this.parseString(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.langT[6]))).append(this.currentLevel + 1)))), this.getFont(this.langA[6]), true, this.halfScreenWidth, this.halfScreenHeight);
        }
        if (this.paused) {
            this.drawText(graphics, this.parseString(this.langT[7]), this.getFont(this.langA[7]), true, this.halfScreenWidth, this.halfScreenHeight);
        }
        if (this.levelClear) {
            this.drawText(graphics, this.parseString(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.langT[0]))).append(",").append(this.langT[1]).append(",").append(this.levelScore)))), new Font[]{this.getFont(this.langA[0]), this.getFont(this.langA[1]), this.getFont(this.langA[1])}, true, this.halfScreenWidth, 5);
        } else if (this.gameover) {
            this.drawText(graphics, this.parseString(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.langT[2]))).append(",").append(this.langT[3]).append(this.score)))), new Font[]{this.getFont(this.langA[2]), this.getFont(this.langA[3])}, true, this.halfScreenWidth, 5);
        }
    }

    public void start() {
        if (this.instance == null || !this.running && !this.paused && !this.instance.isAlive()) {
            this.instance = new Thread(this);
            this.running = true;
            this.instance.start();
        } else if (this.instance.isAlive()) {
            this.running = true;
        }
    }

    public void pause() {
        this.stop();
        this.running = false;
        this.keyPressed = false;
    }

    public void destroy() {
        this.running = false;
        this.instance = null;
    }

    public void hideNotify() {
        this.pause();
    }

    public void showNotify() {
        this.start();
    }

    public void run() {
        while (this.running) {
            try {
                if (this.start) {
                    this.repaint();
                    Thread.sleep(2000L);
                    this.start = false;
                    this.repaint();
                }
                if (!this.levelClear && !this.gameover && this.keyPressed) {
                    int n;
                    ++this.levelTime;
                    if (this.extraLife) {
                        --this.extraLifeCounter;
                        if (this.extraLifeCounter <= 0) {
                            this.extraLife = false;
                        }
                    }
                    if (this.extraStunner) {
                        --this.extraStunnerCounter;
                        if (this.extraStunnerCounter <= 0) {
                            this.extraStunner = false;
                        }
                    }
                    ++this.fruitTimer;
                    if (this.fruitTimer == 250) {
                        BSCanvas.playSound(this.sounds[4]);
                        BSCanvas.vibrate(50, 100);
                        this.fruitTimer = 0;
                        if (this.fruit.size() < 5) {
                            n = BSCanvas.getRandom(this.lines.length);
                            this.fruit.addElement(new Fruit(this.lines[n].xPos1, this.lines[n].yPos1, BSCanvas.getRandom(3)));
                        }
                    }
                    if (this.stunned) {
                        ++this.stunTimer;
                        if (this.stunTimer == 50) {
                            this.baddy.bCurrentMove = this.baddy.bOldMove;
                            this.baddy.stunned = false;
                            this.stunTimer = 0;
                            this.stunned = false;
                        }
                    }
                    if (this.up || this.upHeld) {
                        if (this.lines[this.pLine].yPos1 < this.pYPos) {
                            this.pOldYPos = this.pYPos;
                            this.pYPos -= this.pMove;
                            if (this.pYPos < this.lines[this.pLine].yPos1) {
                                this.pYPos = this.lines[this.pLine].yPos1;
                            }
                            this.backSurface.drawLine(this.pXPos, this.pOldYPos, this.pXPos, this.pYPos);
                            this.pCurrentMove = 0;
                            this.lines[this.pLine].setNewCursorPos(this.pXPos, this.pYPos);
                        } else if (this.upHeld && this.changeLine(0)) {
                            this.up = true;
                            this.down = false;
                            this.left = false;
                            this.right = false;
                        } else {
                            this.up = false;
                        }
                    }
                    if (this.down || this.downHeld) {
                        if (this.lines[this.pLine].yPos2 > this.pYPos) {
                            this.pOldYPos = this.pYPos;
                            this.pYPos += this.pMove;
                            if (this.pYPos > this.lines[this.pLine].yPos2) {
                                this.pYPos = this.lines[this.pLine].yPos2;
                            }
                            this.backSurface.drawLine(this.pXPos, this.pOldYPos, this.pXPos, this.pYPos);
                            this.pCurrentMove = 1;
                            this.lines[this.pLine].setNewCursorPos(this.pXPos, this.pYPos);
                        } else if (this.downHeld && this.changeLine(1)) {
                            this.up = false;
                            this.down = true;
                            this.left = false;
                            this.right = false;
                        } else {
                            this.down = false;
                        }
                    }
                    if (this.left || this.leftHeld) {
                        if (this.lines[this.pLine].xPos1 < this.pXPos) {
                            this.pOldXPos = this.pXPos;
                            this.pXPos -= this.pMove;
                            if (this.pXPos < this.lines[this.pLine].xPos1) {
                                this.pXPos = this.lines[this.pLine].xPos1;
                            }
                            this.backSurface.drawLine(this.pOldXPos, this.pYPos, this.pXPos, this.pYPos);
                            this.pCurrentMove = 2;
                            this.lines[this.pLine].setNewCursorPos(this.pXPos, this.pYPos);
                        } else if (this.leftHeld && this.changeLine(2)) {
                            this.up = false;
                            this.down = false;
                            this.left = true;
                            this.right = false;
                        } else {
                            this.left = false;
                        }
                    }
                    if (this.right || this.rightHeld) {
                        if (this.lines[this.pLine].xPos2 > this.pXPos) {
                            this.pOldXPos = this.pXPos;
                            this.pXPos += this.pMove;
                            if (this.pXPos > this.lines[this.pLine].xPos2) {
                                this.pXPos = this.lines[this.pLine].xPos2;
                            }
                            this.backSurface.drawLine(this.pOldXPos, this.pYPos, this.pXPos, this.pYPos);
                            this.pCurrentMove = 3;
                            this.lines[this.pLine].setNewCursorPos(this.pXPos, this.pYPos);
                        } else if (this.rightHeld && this.changeLine(3)) {
                            this.up = false;
                            this.down = false;
                            this.left = false;
                            this.right = true;
                        } else {
                            this.right = false;
                        }
                    }
                    if (this.fire) {
                        this.fire();
                        this.fire = false;
                    }
                    if (this.up || this.upHeld || this.down || this.downHeld || this.left || this.leftHeld || this.right || this.rightHeld) {
                        ++this.pFrameCounter;
                        if (this.pFrameCounter == 3) {
                            this.pFrameCounter = 0;
                            ++this.pCurrentFrame;
                            if (this.pCurrentFrame == 2) {
                                this.pCurrentFrame = 0;
                            }
                        }
                    }
                    this.baddy.move(this.pXPos, this.pYPos);
                    for (n = 0; n < this.fruit.size(); ++n) {
                        Fruit fruit = (Fruit)this.fruit.elementAt(n);
                        if (this.pXPos < fruit.fXPos - 5 || this.pXPos > fruit.fXPos + 5 || this.pYPos < fruit.fYPos - 5 || this.pYPos > fruit.fYPos + 5) continue;
                        BSCanvas.playSound(this.sounds[3]);
                        this.score += 50 * (this.difficulty + 1);
                        this.fruit.removeElementAt(n);
                        --n;
                        this.updateStatus = true;
                        this.checkBonuses();
                    }
                    this.repaint();
                    this.won = true;
                    for (n = 0; n < this.lines.length; ++n) {
                        if (this.lines[n].filled) continue;
                        this.won = false;
                    }
                    if (this.won) {
                        BSCanvas.playSound(this.sounds[0]);
                        n = this.totalLength / (10 * this.pMove);
                        this.levelTime /= 20;
                        this.levelScore = (this.totalLength - (this.levelTime - n) * 15) * (this.difficulty + 1);
                        if (this.levelScore < 100) {
                            this.levelScore = 100;
                        }
                        this.score += this.levelScore;
                        this.checkBonuses();
                        this.updateStatus = true;
                        this.repaint();
                        Thread.sleep(1500L);
                        this.extraLife = false;
                        this.extraStunner = false;
                        this.levelClear = true;
                        this.repaint();
                        Thread.sleep(3000L);
                        this.commandListener.commandAction(BSCanvas.LEVEL_ENDED, (Displayable)this);
                    }
                    if (!this.baddy.stunned && this.pXPos >= this.baddy.bXPos - 5 && this.pXPos <= this.baddy.bXPos + 5 && this.pYPos >= this.baddy.bYPos - 5 && this.pYPos <= this.baddy.bYPos + 5) {
                        this.dead = true;
                        --this.pLives;
                        this.updateStatus = true;
                    }
                    if (this.dead) {
                        BSCanvas.playSound(this.sounds[1]);
                        BSCanvas.vibrate(50, 500);
                        this.stop();
                        for (n = 0; n < 30; ++n) {
                            ++this.pCurrentMove;
                            if (this.pCurrentMove >= 4) {
                                this.pCurrentMove = 0;
                            }
                            this.repaint();
                            Thread.sleep(50L);
                        }
                        if (this.dead && this.pLives == 0) {
                            this.gameover = true;
                            this.repaint();
                            Thread.sleep(3000L);
                            this.commandListener.commandAction(BSCanvas.GAME_ENDED, (Displayable)this);
                        } else {
                            this.pXPos = this.pOrigXPos;
                            this.pYPos = this.pOrigYPos;
                            this.pLine = this.pOrigLine;
                            this.xOffSet = 0;
                            this.yOffSet = 0;
                            this.baddy.bXPos = this.baddy.bOrigXPos;
                            this.baddy.bYPos = this.baddy.bOrigYPos;
                            this.baddy.bCurrentMove = this.baddy.bOrigMove;
                            this.baddy.bLine = this.baddy.bOrigLine;
                            this.repaint();
                            Thread.sleep(1000L);
                            this.dead = false;
                            this.keyPressed = false;
                        }
                    }
                }
                Thread.sleep(1000 / (this.segmentLength * 2));
            }
            catch (InterruptedException interruptedException) {
                System.out.println("Thread error");
            }
        }
    }

    public void checkBonuses() {
        if (this.score >= this.extraLifeAt) {
            BSCanvas.playSound(this.sounds[2]);
            this.extraLife = true;
            this.extraLifeAt += 3000 * (this.difficulty + 1);
            this.extraLifeCounter = 30;
            if (this.pLives != 99) {
                ++this.pLives;
            }
            this.updateStatus = true;
        }
        if (this.score >= this.extraStunnerAt) {
            BSCanvas.playSound(this.sounds[2]);
            this.extraStunner = true;
            this.extraStunnerAt += 750 * (this.difficulty + 1);
            this.extraStunnerCounter = 30;
            if (this.pStunner != 99) {
                ++this.pStunner;
            }
            this.updateStatus = true;
        }
    }

    public void stop() {
        this.up = false;
        this.upHeld = false;
        this.down = false;
        this.downHeld = false;
        this.left = false;
        this.leftHeld = false;
        this.right = false;
        this.rightHeld = false;
    }

    public boolean changeLine(int n) {
        if (this.lines[this.pLine].conn1[n] != -1 && this.lines[this.pLine].at1(this.pXPos, this.pYPos)) {
            this.pOldLine = this.pLine;
            this.pLine = this.lines[this.pLine].conn1[n];
            this.pOldXPos = this.pXPos;
            this.pOldYPos = this.pYPos;
            switch (n) {
                case 0: {
                    this.pYPos -= this.pMove;
                    break;
                }
                case 1: {
                    this.pYPos += this.pMove;
                    break;
                }
                case 2: {
                    this.pXPos -= this.pMove;
                    break;
                }
                case 3: {
                    this.pXPos += this.pMove;
                }
            }
            this.backSurface.drawLine(this.pOldXPos, this.pOldYPos, this.pXPos, this.pYPos);
            this.lines[this.pOldLine].setNewCursorPos(this.lines[this.pOldLine].xPos1, this.lines[this.pOldLine].yPos1);
            this.lines[this.pLine].setOldCursorPos(this.lines[this.pOldLine].xPos1, this.lines[this.pOldLine].yPos1);
            this.lines[this.pLine].setNewCursorPos(this.pXPos, this.pYPos);
            this.pCurrentMove = n;
            return true;
        }
        if (this.lines[this.pLine].conn2[n] != -1 && this.lines[this.pLine].at2(this.pXPos, this.pYPos)) {
            this.pOldLine = this.pLine;
            this.pLine = this.lines[this.pLine].conn2[n];
            this.pOldXPos = this.pXPos;
            this.pOldYPos = this.pYPos;
            switch (n) {
                case 0: {
                    this.pYPos -= this.pMove;
                    break;
                }
                case 1: {
                    this.pYPos += this.pMove;
                    break;
                }
                case 2: {
                    this.pXPos -= this.pMove;
                    break;
                }
                case 3: {
                    this.pXPos += this.pMove;
                }
            }
            this.backSurface.drawLine(this.pOldXPos, this.pOldYPos, this.pXPos, this.pYPos);
            this.lines[this.pOldLine].setNewCursorPos(this.lines[this.pOldLine].xPos2, this.lines[this.pOldLine].yPos2);
            this.lines[this.pLine].setOldCursorPos(this.lines[this.pOldLine].xPos2, this.lines[this.pOldLine].yPos2);
            this.lines[this.pLine].setNewCursorPos(this.pXPos, this.pYPos);
            this.pCurrentMove = n;
            return true;
        }
        return false;
    }

    public void fire() {
        if (this.pStunner != 0 && !this.stunned) {
            BSCanvas.playSound(this.sounds[5]);
            BSCanvas.vibrate(50, 200);
            this.baddy.bOldMove = this.baddy.bCurrentMove;
            this.baddy.stunned = true;
            --this.pStunner;
            this.stunned = true;
            this.updateStatus = true;
        }
    }

    public void keyPressed(int n) {
        this.keyPressed = true;
        if (!this.dead && !this.won) {
            int n2 = this.getGameAction(n);
            if (n == -7) {
                this.commandListener.commandAction(BSCanvas.DISPLAY_MENU, (Displayable)this);
            } else if (!this.paused) {
                block0 : switch (n2) {
                    case 1: {
                        this.upHeld = true;
                        if (this.lines[this.pLine].yPos1 >= this.pYPos && !this.changeLine(0)) break;
                        this.up = true;
                        this.down = false;
                        this.left = false;
                        this.right = false;
                        break;
                    }
                    case 6: {
                        this.downHeld = true;
                        if (this.lines[this.pLine].yPos2 <= this.pYPos && !this.changeLine(1)) break;
                        this.up = false;
                        this.down = true;
                        this.left = false;
                        this.right = false;
                        break;
                    }
                    case 2: {
                        this.leftHeld = true;
                        if (this.lines[this.pLine].xPos1 >= this.pXPos && !this.changeLine(2)) break;
                        this.up = false;
                        this.down = false;
                        this.left = true;
                        this.right = false;
                        break;
                    }
                    case 5: {
                        this.rightHeld = true;
                        if (this.lines[this.pLine].xPos2 <= this.pXPos && !this.changeLine(3)) break;
                        this.up = false;
                        this.down = false;
                        this.left = false;
                        this.right = true;
                        break;
                    }
                    case 8: {
                        this.fire = true;
                        break;
                    }
                    default: {
                        switch (n) {
                            case 49: {
                                this.fire = true;
                                break block0;
                            }
                            case 51: {
                                this.stop();
                                break block0;
                            }
                            case 50: {
                                this.upHeld = true;
                                if (this.lines[this.pLine].yPos1 >= this.pYPos && !this.changeLine(0)) break block0;
                                this.up = true;
                                this.down = false;
                                this.left = false;
                                this.right = false;
                                break block0;
                            }
                            case 56: {
                                this.downHeld = true;
                                if (this.lines[this.pLine].yPos2 <= this.pYPos && !this.changeLine(1)) break block0;
                                this.up = false;
                                this.down = true;
                                this.left = false;
                                this.right = false;
                                break block0;
                            }
                            case 52: {
                                this.leftHeld = true;
                                if (this.lines[this.pLine].xPos1 >= this.pXPos && !this.changeLine(2)) break block0;
                                this.up = false;
                                this.down = false;
                                this.left = true;
                                this.right = false;
                                break block0;
                            }
                            case 54: {
                                this.rightHeld = true;
                                if (this.lines[this.pLine].xPos2 <= this.pXPos && !this.changeLine(3)) break block0;
                                this.up = false;
                                this.down = false;
                                this.left = false;
                                this.right = true;
                            }
                        }
                    }
                }
            }
        }
    }

    public void keyReleased(int n) {
        int n2 = this.getGameAction(n);
        block0 : switch (n2) {
            case 1: {
                this.upHeld = false;
                break;
            }
            case 6: {
                this.downHeld = false;
                break;
            }
            case 2: {
                this.leftHeld = false;
                break;
            }
            case 5: {
                this.rightHeld = false;
                break;
            }
            default: {
                switch (n) {
                    case 50: {
                        this.upHeld = false;
                        break block0;
                    }
                    case 56: {
                        this.downHeld = false;
                        break block0;
                    }
                    case 52: {
                        this.leftHeld = false;
                        break block0;
                    }
                    case 54: {
                        this.rightHeld = false;
                    }
                }
            }
        }
    }

    public String[] parseString(String string) {
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != ',') continue;
            ++n;
        }
        String[] stringArray = new String[n + 1];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = string.substring(0, string.indexOf(44));
            string = string.substring(string.indexOf(44) + 1);
        }
        stringArray[n] = string;
        return stringArray;
    }

    public void drawText(Graphics graphics, String[] stringArray, Font font, boolean bl, int n, int n2) {
        Font[] fontArray = new Font[stringArray.length];
        for (int i = 0; i < fontArray.length; ++i) {
            fontArray[i] = font;
        }
        this.drawText(graphics, stringArray, fontArray, bl, n, n2);
    }

    public void drawText(Graphics graphics, String[] stringArray, Font[] fontArray, boolean bl, int n, int n2) {
        int n3;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        for (n3 = 0; n3 < stringArray.length; ++n3) {
            n5 = Math.max(fontArray[n3].stringWidth(stringArray[n3]), n5);
            n7 += fontArray[n3].getHeight();
        }
        graphics.setColor(0xFFFFFF);
        graphics.fillRect(n - n5 / 2 - 2, n2 - 2, n5 + 2, n7 + 2);
        graphics.setColor(0);
        for (n3 = 0; n3 < stringArray.length; ++n3) {
            n4 = fontArray[n3].stringWidth(stringArray[n3]);
            graphics.setFont(fontArray[n3]);
            graphics.drawString(stringArray[n3], n, n2 + n6, 17);
            n6 += fontArray[n3].getHeight();
        }
        if (bl) {
            graphics.drawRect(n - n5 / 2 - 2, n2 - 2, n5 + 2, n7 + 2);
        }
    }

    static {
        L_UP = 0;
        L_DOWN = 1;
        L_LEFT = 2;
        L_RIGHT = 3;
    }
}

