/*
 * Decompiled with CFR 0.152.
 */
package bomber;

import bomber.Bomber;
import bomber.Enemies;
import bomber.Player;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Playfield {
    int levPtr = 0;
    String lev = null;
    String[] levels = new String[]{"10;9;ACAAAAAACAABABBABABAAAACAACAAACBABABBABCAAACAGCAAACBABBABABCAAACAACAAAABABABBABAACAAAAAACAM4,4,6;7,6,8;7,2,8;2,2,8;2,6,8;M", "10;15;AAAAAAAACAABABABBABAACAAAACAAAABABBBBABAAAACAAAACAABABBABABAACAAAAAAAABBCBBBBCBBAAAAAABAAAABABBABABAABAAAABAAAAAAABABBBCABBABABAAAAAAAAABAGABBBBBACAAAM3,2,6;5,8,4;0,11,8;0,6,8;1,0,8;6,0,8;9,6,8;5,12,7;2,11,7;9,4,8;M", "18;9;AABAAAAABAABABABAAAAAABBBAAAABAAABAABAABAAABAAABCBACAABABAAAAABABBAAABBABACAABAACAACABAACGBABAAAAABABBAAABBABAABAAABAAABCBACAAAAAABBBAAAABAAABAAAABAAAAABAABABABAAM9,0,1;8,6,1;10,6,1;6,0,1;3,7,1;6,4,4;4,3,4;5,3,8;5,5,8;4,5,8;6,3,8;17,5,5;17,3,5;14,1,5;14,7,5;0,0,6;M", "16;20;AAABAAABBAAABAAAAAACABAAAABACAOAAAABAAAAAAAABAAABBBBBBBAABBBBBBBAAAAAABAABAAAAAABBBBBBBSSBBBBBBBAAAAQAAAAAAQAAAAABABBAAAAAABBABAAAABACBAABCABAAAABBBACAAAACABBBAABAAABAAAABCBABAABAAABAAAABAAABAAQABBBBBBBBABAQAABAAAABAAAAACABAABAABABABABABABAABAAAABAAACAAABAABBBABBBBBBABBBAAAABOBAAAABOBAAAABABBBAAAABBBABAAAAAAAABBAAAAAAAM1,1,6;15,16,7;9,17,7;6,17,7;5,13,5;3,13,5;9,13,5;7,13,5;9,10,4;6,10,4;11,2,5;11,1,5;11,0,5;15,9,3;0,9,3;0,16,7;8,9,5;MTs14,1:8,5,7,5;s11,17:14,12,1,12;s4,17:11,6,4,6;T", "12;12;AABBAABBBAAAAAAAAAAACABABBAABBABCAOAAABBAAAACBBCAAACABABBAAAABACAAAACABAAABBBBAACAAAAAACAABABBNBBAACAAAABAAGBSBBABBABAAGAAABAAAABBNBUAUBBBAACAAAM0,0,6;9,0,1;11,0,1;11,2,1;4,3,8;7,5,8;7,8,8;0,6,8;11,5,8;6,10,7;1,8,7;7,11,1;MTc0,11:2;c2,11:8;s10,2:1,9;T", "11;20;AAAAAAAAAAABCBBOBBBBBAAAABABUAABAAAABABUAANAAUUBABOAABCCBBBSBBBBBAABAAAAABAAAABABAAABABAABAAABABAAAABOBAAABABBABAAABABAAAAKAAAAIBABABBBBKBBBAAAAAAAAAAQAAAABBCBBBBBBBABAAABABAAAABAAAKAKAHAABAAABABAAAABBBBBCBBABAAAAAQAAAAAM0,3,3;4,15,5;4,17,5;2,17,5;2,15,5;8,11,1;10,11,1;10,7,1;8,7,1;3,8,4;5,9,4;1,3,7;2,3,3;7,2,7;7,3,3;7,4,7;MTs4,1:4,5;s6,4:5,19;c1,4:8;c2,4:1;c6,2:6;c6,3:8;s2,9:7,13;T"};
    public static final byte EMPTY = 0;
    public static final byte WALL = 1;
    public static final byte BRICK = 2;
    public static final byte BRICK_BREAK = 3;
    public static final byte FLAME = 4;
    public static final byte POWERUP = 5;
    public static final byte CLOSED_DOOR = 6;
    public static final byte OPEN_DOOR = 7;
    public static final byte SPAWNER = 8;
    public static final byte SPAWNER_BREAK = 9;
    public static final byte ROCK = 10;
    public static final byte ROCK_BREAK = 11;
    public static final byte GATE_OPEN = 12;
    public static final byte GATE_CLOSED = 13;
    public static final byte SWITCH_OFF = 14;
    public static final byte SWITCH_ON = 15;
    public static final byte SGATEV_CLOSED = 16;
    public static final byte SGATEV_OPEN = 17;
    public static final byte SGATEH_CLOSED = 18;
    public static final byte SGATEH_OPEN = 19;
    public static final byte CHEST = 20;
    public static final byte TREASURE = 21;
    boolean[] passableTiles = new boolean[]{true, false, false, false, true, true, true, true, false, false, false, false, true, false, true, true, false, true, false, true, false, true};
    public static final byte BOMB = 101;
    public static final byte RINGBOMB = 104;
    public static final byte POWERBOMB = 105;
    public static final byte BRANCHBOMB = 106;
    public static final byte HUGEBOMB = 107;
    public static final int TILESIZE = 16;
    public static final byte POWER_BOMB = 1;
    public static final byte POWER_FLAME = 2;
    public static final byte POWER_FOOT = 3;
    public static final byte POWER_RINGBOMB = 4;
    public static final byte POWER_POWERBOMB = 5;
    public static final byte POWER_BRANCHBOMB = 6;
    public static final byte POWER_HUGEBOMB = 7;
    public static final byte GOLD = 8;
    public static final byte EFF_NONE = 0;
    public static final byte EFF_BURN = 10;
    public static final byte EFF_EXIT = 11;
    private static final int SPAWNRATE = 120;
    public static final byte FIRE_NONE = 0;
    public static final byte FIRE_STRAIGHT = 1;
    public static final byte FIRE_FLAMECAST = 2;
    public static final byte FIRE_POWER = 3;
    public static final byte FIRE_BRANCH = 4;
    private static final int numFires = 28;
    private Fire[] fires = null;
    int firstEmpty = 0;
    int width = 0;
    int height = 0;
    int pwidth = 0;
    int pheight = 0;
    int drawWidth = 0;
    int drawHeight = 0;
    int pAnim = 0;
    int bombs = 0;
    byte[][] grid = null;
    byte[][] cnt = null;
    byte[][] occ = null;
    byte[][] trace = null;
    boolean levelClear = false;
    byte levelObjective = 0;
    int switchActivationId = 0;
    int nextSwitchActivationId = 0;
    public Player player = null;
    public Enemies enemies = null;
    public static final byte OBJECTIVE_NONE = 0;
    public static final byte OBJECTIVE_COLLECT = 1;
    public static final byte OBJECTIVE_CLEAN = 2;
    Image floorIm = null;
    Image brickIm = null;
    Image closedDoorIm = null;
    Image openDoorIm = null;
    Image chestIm = null;
    Image treasureIm = null;
    Image wallIm = null;
    Image bombIm = null;
    Image flameIm = null;
    Image powerIm = null;
    Image rockIm = null;
    Image spawnerIm = null;
    Image[] gateIm = null;
    Image[] icons = null;
    Image[] switchIm = null;
    Image[] powerItemIm = null;
    Image[] sgateIm = null;

    public int decodeFire(InputStream inputStream) {
        try {
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            byte by = dataInputStream.readByte();
            byte by2 = dataInputStream.readByte();
            int n = dataInputStream.readInt();
            int n2 = dataInputStream.readInt();
            int n3 = dataInputStream.readInt();
            int n4 = dataInputStream.readInt();
            int n5 = this.addFire(by, n, n2, n3, n4, by2);
            return n5;
        }
        catch (IOException iOException) {
            int n = -1;
            return n;
        }
    }

    public boolean encodeAllFires(OutputStream outputStream) {
        try {
            DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
            dataOutputStream.writeInt(28);
            int n = 0;
            while (n < 28) {
                if (this.fires[n].type != 0) {
                    this.fires[n].encode(outputStream);
                }
                ++n;
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException iOException) {
            boolean bl = false;
            return bl;
        }
    }

    public boolean decodeAllFires(InputStream inputStream) {
        try {
            this.reset();
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            int n = dataInputStream.readInt();
            int n2 = 0;
            while (n2 < n) {
                if (this.decodeFire(inputStream) == -1) {
                    boolean bl = false;
                    return bl;
                }
                ++n2;
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException iOException) {
            boolean bl = false;
            return bl;
        }
    }

    public int addFire(byte by, int n, int n2, int n3, int n4, byte by2) {
        int n5 = this.firstEmpty;
        while (n5 < 28 && this.fires[n5].type != 0) {
            ++n5;
        }
        if (n5 == 28) {
            return -1;
        }
        this.fires[n5].type = by;
        this.fires[n5].x = n;
        this.fires[n5].y = n2;
        this.fires[n5].xsp = n3;
        this.fires[n5].ysp = n4;
        this.fires[n5].cnt = by2;
        this.firstEmpty = n5;
        return n5;
    }

    private void removeFire(int n) {
        this.fires[n].type = 0;
        if (this.firstEmpty > n) {
            this.firstEmpty = n;
        }
    }

    private void resetFires() {
        int n = 0;
        while (n < 28) {
            this.fires[n].type = 0;
            ++n;
        }
        this.firstEmpty = 0;
    }

    public byte[] encode() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeInt(this.width);
            dataOutputStream.writeInt(this.height);
            dataOutputStream.writeInt(this.pwidth);
            dataOutputStream.writeInt(this.pheight);
            dataOutputStream.writeInt(this.drawWidth);
            dataOutputStream.writeInt(this.drawHeight);
            dataOutputStream.writeInt(this.pAnim);
            dataOutputStream.writeInt(this.bombs);
            dataOutputStream.writeBoolean(this.levelClear);
            dataOutputStream.writeByte(this.levelObjective);
            int n = 0;
            while (n < this.height) {
                ((OutputStream)dataOutputStream).write(this.grid[n]);
                ((OutputStream)dataOutputStream).write(this.cnt[n]);
                ((OutputStream)dataOutputStream).write(this.occ[n]);
                ((OutputStream)dataOutputStream).write(this.trace[n]);
                ++n;
            }
            this.encodeAllFires(dataOutputStream);
            this.enemies.encodeAllEnemies(dataOutputStream);
            this.player.encode(dataOutputStream);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            dataOutputStream.close();
            byteArrayOutputStream.close();
            byte[] byArray2 = "Hello".getBytes();
            return byArray2;
        }
        catch (IOException iOException) {
            byte[] byArray = null;
            return byArray;
        }
    }

    public boolean decode(byte[] byArray) {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            this.width = dataInputStream.readInt();
            this.height = dataInputStream.readInt();
            this.pwidth = dataInputStream.readInt();
            this.pheight = dataInputStream.readInt();
            this.drawWidth = dataInputStream.readInt();
            this.drawHeight = dataInputStream.readInt();
            this.pAnim = dataInputStream.readInt();
            this.bombs = dataInputStream.readInt();
            this.levelClear = dataInputStream.readBoolean();
            this.levelObjective = dataInputStream.readByte();
            int n = 0;
            while (n < this.height) {
                dataInputStream.read(this.grid[n], 0, this.width);
                dataInputStream.read(this.cnt[n], 0, this.width);
                dataInputStream.read(this.occ[n], 0, this.width);
                dataInputStream.read(this.trace[n], 0, this.width);
                ++n;
            }
            byte[] byArray2 = new byte[dataInputStream.available()];
            dataInputStream.read(byArray2);
            this.decodeAllFires(dataInputStream);
            this.enemies.decodeAllEnemies(dataInputStream);
            this.player.decode(dataInputStream);
            dataInputStream.close();
            byteArrayInputStream.close();
            boolean bl = true;
            return bl;
        }
        catch (IOException iOException) {
            boolean bl = false;
            return bl;
        }
    }

    private void openStr(String string) {
        this.lev = string;
        this.levPtr = 0;
    }

    private int readNext() {
        if (this.levPtr >= this.lev.length()) {
            return -1;
        }
        return this.lev.charAt(this.levPtr++);
    }

    public void loadLevel(int n) {
        try {
            int n2;
            int n3;
            int n4;
            if (--n >= this.levels.length) {
                n = this.levels.length - 1;
            }
            this.openStr(this.levels[n]);
            StringBuffer stringBuffer = new StringBuffer();
            while ((n4 = this.readNext()) != 59) {
                stringBuffer.append((char)n4);
            }
            this.width = Integer.parseInt(stringBuffer.toString());
            stringBuffer = new StringBuffer();
            while ((n4 = this.readNext()) != 59) {
                stringBuffer.append((char)n4);
            }
            this.height = Integer.parseInt(stringBuffer.toString());
            this.newGrid(this.width, this.height);
            this.pwidth = this.width * 16;
            this.pheight = this.height * 16;
            int n5 = 0;
            while (n5 < this.height) {
                n3 = 0;
                while (n3 < this.width) {
                    this.grid[n5][n3] = (byte)((byte)this.readNext() - 65);
                    this.trace[n5][n3] = -1;
                    ++n3;
                }
                ++n5;
            }
            this.enemies.reset();
            n3 = this.readNext();
            if (n3 == 77) {
                n2 = 1;
                while (n2 != 0) {
                    int n6;
                    StringBuffer stringBuffer2 = new StringBuffer();
                    while ((n6 = this.readNext()) != 59) {
                        if (n6 == 77) {
                            n2 = 0;
                            break;
                        }
                        stringBuffer2.append((char)n6);
                    }
                    if (n2 == 0) continue;
                    this.enemies.decode(stringBuffer2.toString());
                }
                n3 = this.readNext();
            }
            if (n3 == 84) {
                n2 = 1;
                byte by = 1;
                while (n2 != 0) {
                    int n7;
                    StringBuffer stringBuffer3 = new StringBuffer();
                    while ((n7 = this.readNext()) != 59) {
                        if (n7 == 84) {
                            n2 = 0;
                            break;
                        }
                        stringBuffer3.append((char)n7);
                    }
                    if (n2 == 0) break;
                    String string = stringBuffer3.toString();
                    try {
                        int n8;
                        int n9;
                        int n10;
                        int n11;
                        if (string.charAt(0) == 's') {
                            string = string.substring(1);
                            int n12 = string.indexOf(44);
                            n11 = string.indexOf(58);
                            n10 = 0;
                            n9 = Integer.parseInt(string.substring(0, n12));
                            n8 = Integer.parseInt(string.substring(n12 + 1, n11));
                            while (n10 != string.length()) {
                                int n13 = string.indexOf(44, n11 + 1);
                                n10 = string.indexOf(44, n13 + 1);
                                if (n10 == -1) {
                                    n10 = string.length();
                                }
                                int n14 = Integer.parseInt(string.substring(n11 + 1, n13));
                                int n15 = Integer.parseInt(string.substring(n13 + 1, n10));
                                n11 = n10;
                                byte[] byArray = this.cnt[n15];
                                int n16 = n14;
                                byArray[n16] = (byte)(byArray[n16] + by);
                            }
                            this.cnt[n8][n9] = by;
                            by = (byte)(by * 2);
                            continue;
                        }
                        if (string.charAt(0) != 'c') continue;
                        int n17 = string.indexOf(44);
                        n11 = string.indexOf(58);
                        n10 = Integer.parseInt(string.substring(1, n17));
                        n9 = Integer.parseInt(string.substring(n17 + 1, n11));
                        n8 = Integer.parseInt(string.substring(n11 + 1));
                        this.cnt[n9][n10] = (byte)n8;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        Bomber.quitApp();
                    }
                }
            }
            n2 = 0;
            while (n2 < this.height) {
                int n18 = 0;
                while (n18 < this.width) {
                    if (this.grid[n2][n18] == 1) {
                        int n19 = 0;
                        if (n2 < this.height - 1 && this.grid[n2 + 1][n18] == 1) {
                            n19 = (byte)(n19 + 1);
                        }
                        if (n18 > 0 && this.grid[n2][n18 - 1] == 1) {
                            n19 = (byte)(n19 + 2);
                        }
                        if (n2 > 0 && this.grid[n2 - 1][n18] == 1) {
                            n19 = (byte)(n19 + 4);
                        }
                        if (n18 < this.width - 1 && this.grid[n2][n18 + 1] == 1) {
                            n19 = (byte)(n19 + 8);
                        }
                        this.cnt[n2][n18] = n19;
                    }
                    ++n18;
                }
                ++n2;
            }
            this.player.resetPos();
            this.levelObjective = (byte)2;
            this.levelClear = false;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Bomber.quitApp();
        }
    }

    private void newGrid(int n, int n2) {
        this.grid = new byte[n2][n];
        this.cnt = new byte[n2][n];
        this.occ = new byte[n2][n];
        this.trace = new byte[n2][n];
        this.switchActivationId = 0;
        this.nextSwitchActivationId = 0;
    }

    public Playfield(int n, int n2) {
        this.width = n;
        this.height = n2;
        this.pwidth = n * 16;
        this.pheight = n2 * 16;
        this.newGrid(n, n2);
        this.fires = new Fire[28];
        int n3 = 0;
        while (n3 < 28) {
            this.fires[n3] = new Fire();
            ++n3;
        }
        this.resetFires();
        this.floorIm = Bomber.getImage("set1/floor");
        this.brickIm = Bomber.getImage("set1/brick");
        this.closedDoorIm = Bomber.getImage("set1/doorClosed");
        this.openDoorIm = Bomber.getImage("set1/doorOpen");
        this.chestIm = Bomber.getImage("set1/chest");
        this.treasureIm = Bomber.getImage("set1/treasure");
        this.powerItemIm = new Image[3];
        this.gateIm = new Image[2];
        this.icons = new Image[3];
        this.switchIm = new Image[2];
        this.sgateIm = new Image[4];
        this.bombIm = Bomber.getImage("bomb0");
        this.flameIm = Bomber.getImage("flame5");
        this.powerIm = Bomber.getImage("power0");
        this.wallIm = Bomber.getImage("set1/wall0");
        this.spawnerIm = Bomber.getImage("set1/spawner0");
        this.rockIm = Bomber.getImage("set1/rock0");
        int n4 = 0;
        while (n4 < 12) {
            if (n4 < this.powerItemIm.length) {
                this.powerItemIm[n4] = Bomber.getImage("powerI".concat(String.valueOf(String.valueOf(n4))));
            }
            if (n4 < this.gateIm.length) {
                this.gateIm[n4] = Bomber.getImage("set1/gate".concat(String.valueOf(String.valueOf(n4))));
            }
            if (n4 < this.icons.length) {
                this.icons[n4] = Bomber.getImage("icon".concat(String.valueOf(String.valueOf(n4))));
            }
            if (n4 < this.switchIm.length) {
                this.switchIm[n4] = Bomber.getImage("set1/switch".concat(String.valueOf(String.valueOf(n4))));
            }
            if (n4 < this.sgateIm.length) {
                this.sgateIm[n4] = Bomber.getImage("set1/sgate".concat(String.valueOf(String.valueOf(n4))));
            }
            ++n4;
        }
        this.pAnim = 0;
    }

    public void reset() {
        int n = 0;
        while (n < this.height) {
            int n2 = 0;
            while (n2 < this.width) {
                this.grid[n][n2] = 0;
                this.cnt[n][n2] = 0;
                this.trace[n][n2] = -1;
                ++n2;
            }
            ++n;
        }
        this.bombs = 0;
    }

    int getGridX(int n) {
        return n / 16;
    }

    int getGridY(int n) {
        return n / 16;
    }

    public boolean setBomb(byte by, int n, int n2, int n3) {
        if (this.bombs >= this.player.bombs) {
            return false;
        }
        if (this.grid[n2][n] != 0 && this.grid[n2][n] != 4) {
            return false;
        }
        this.grid[n2][n] = by;
        this.cnt[n2][n] = (byte)n3;
        ++this.bombs;
        return true;
    }

    public boolean setFlame(int n, int n2, int n3, boolean bl) {
        if (n < 0 || n >= this.width || n2 < 0 || n2 >= this.height) {
            return true;
        }
        byte by = this.grid[n2][n];
        if (by == 0 || by == 4 || by == 5) {
            this.grid[n2][n] = 4;
            this.cnt[n2][n] = (byte)(0 - n3);
            return false;
        }
        if (by == 2) {
            this.player.givePoints(1);
            this.grid[n2][n] = 3;
            this.cnt[n2][n] = (byte)(0 - n3);
            if (bl) {
                return false;
            }
        } else if (by == 20) {
            this.player.givePoints(1);
            this.grid[n2][n] = this.cnt[n2][n] == 8 ? 21 : 5;
            if (bl) {
                return false;
            }
        } else if (by == 10) {
            if (this.cnt[n2][n] == 2 || bl) {
                this.player.givePoints(2);
                this.grid[n2][n] = 11;
                this.cnt[n2][n] = (byte)(0 - n3);
                if (bl) {
                    return false;
                }
            } else {
                byte[] byArray = this.cnt[n2];
                int n4 = n;
                byArray[n4] = (byte)(byArray[n4] + 1);
            }
        }
        if (by >= 100) {
            this.cnt[n2][n] = (byte)Math.min(this.cnt[n2][n], (byte)(1 + n3));
            if (bl) {
                return false;
            }
        }
        if (by == 13) {
            this.cnt[n2][n] = (byte)(100 - n3);
        }
        if (by == 8) {
            this.player.givePoints(10);
            this.grid[n2][n] = 9;
            this.cnt[n2][n] = (byte)(0 - n3);
            if (bl) {
                return false;
            }
        }
        if (by == 12 || by == 19 || by == 17) {
            return false;
        }
        if (by == 14 || by == 15) {
            this.nextSwitchActivationId |= this.cnt[n2][n];
            this.grid[n2][n] = by == 14 ? 15 : 14;
        }
        return true;
    }

    boolean isPassable(int n, int n2, int n3) {
        if (n < 0 || n >= this.width || n2 < 0 || n2 >= this.height) {
            return false;
        }
        byte by = this.grid[n2][n];
        if (by > 100) {
            return false;
        }
        return this.passableTiles[by];
    }

    boolean isBomb(int n, int n2) {
        if (n < 0 || n >= this.width || n2 < 0 || n2 >= this.height) {
            return false;
        }
        byte by = this.grid[n2][n];
        return by == 101;
    }

    boolean isOccupied(int n, int n2) {
        return this.occ[n2][n] != 0;
    }

    void occupy(int n, int n2) {
        this.occ[n2][n] = 2;
    }

    void setDrawDimensions(int n, int n2) {
        if (n > this.pwidth || n2 > this.pheight) {
            Bomber.quitApp();
        }
        this.drawWidth = n;
        this.drawHeight = n2 - 16;
    }

    public byte passThrough(int n, int n2, boolean bl) {
        byte by = this.grid[n2][n];
        switch (by) {
            default: {
                break;
            }
            case 4: {
                if (this.cnt[n2][n] < 0) break;
                return 10;
            }
            case 7: {
                return 11;
            }
            case 21: {
                if (!bl) {
                    return 0;
                }
                this.grid[n2][n] = 0;
                return 8;
            }
            case 5: {
                if (!bl) {
                    return 0;
                }
                byte by2 = this.cnt[n2][n];
                this.grid[n2][n] = 0;
                return by2;
            }
        }
        return 0;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void update(Graphics var1_1) {
        var2_2 = 0;
        this.switchActivationId = this.nextSwitchActivationId;
        this.nextSwitchActivationId = 0;
        var3_3 = 0;
        while (var3_3 < this.width) {
            var4_4 = 0;
            while (var4_4 < this.height) {
                if (this.occ[var4_4][var3_3] > 0) {
                    v0 = this.occ[var4_4];
                    v1 = var3_3;
                    v0[v1] = (byte)(v0[v1] - 1);
                }
                if ((var5_5 = this.grid[var4_4][var3_3]) == 101 || var5_5 == 106 || var5_5 == 105 || var5_5 == 107) {
                    v2 = this.cnt[var4_4];
                    v3 = var3_3;
                    v2[v3] = (byte)(v2[v3] - 1);
                    if (this.cnt[var4_4][var3_3] == 0) {
                        --this.bombs;
                        this.grid[var4_4][var3_3] = 4;
                        this.cnt[var4_4][var3_3] = 0;
                        if (var5_5 == 107) {
                            this.setFlame(var3_3, var4_4, 1, false);
                            return;
                        }
                        var6_6 = var5_5 != 101 ? (byte)(var5_5 != 106 ? 3 : 4) : 1;
                        this.addFire(var6_6, var3_3 * 16, var4_4 * 16, -16, 0, (byte)(this.player.flames + 1));
                        this.addFire(var6_6, var3_3 * 16, var4_4 * 16, 16, 0, (byte)(this.player.flames + 1));
                        this.addFire(var6_6, var3_3 * 16, var4_4 * 16, 0, -16, (byte)(this.player.flames + 1));
                        this.addFire(var6_6, var3_3 * 16, var4_4 * 16, 0, 16, (byte)(this.player.flames + 1));
                    }
                } else if (var5_5 == 104) {
                    v4 = this.cnt[var4_4];
                    v5 = var3_3;
                    v4[v5] = (byte)(v4[v5] - 1);
                    if (this.cnt[var4_4][var3_3] == 0) {
                        --this.bombs;
                        var6_6 = -2;
                        while (var6_6 <= 2) {
                            this.setFlame(var3_3 - 2, var4_4 + var6_6, 1, false);
                            this.setFlame(var3_3 + 2, var4_4 + var6_6, 1, false);
                            this.setFlame(var3_3 + var6_6, var4_4 - 2, 1, false);
                            this.setFlame(var3_3 + var6_6, var4_4 + 2, 1, false);
                            ++var6_6;
                        }
                        this.grid[var4_4][var3_3] = 0;
                        this.cnt[var4_4][var3_3] = 0;
                    }
                } else if (var5_5 == 4) {
                    v6 = this.cnt[var4_4];
                    v7 = var3_3;
                    v6[v7] = (byte)(v6[v7] + 1);
                    if (this.cnt[var4_4][var3_3] == 9) {
                        this.grid[var4_4][var3_3] = 0;
                    }
                } else if (var5_5 == 3) {
                    this.grid[var4_4][var3_3] = 0;
                } else if (var5_5 == 11) {
                    this.grid[var4_4][var3_3] = 0;
                } else if (var5_5 == 12) {
                    v8 = this.cnt[var4_4];
                    v9 = var3_3;
                    v8[v9] = (byte)(v8[v9] - 1);
                    if (this.cnt[var4_4][var3_3] == 0) {
                        this.grid[var4_4][var3_3] = 13;
                        this.cnt[var4_4][var3_3] = 9;
                    }
                } else if (var5_5 == 13) {
                    if (this.cnt[var4_4][var3_3] > 50) {
                        this.grid[var4_4][var3_3] = 12;
                        this.cnt[var4_4][var3_3] = 24;
                    } else if (this.cnt[var4_4][var3_3] > 0) {
                        v10 = this.cnt[var4_4];
                        v11 = var3_3;
                        v10[v11] = (byte)(v10[v11] - 1);
                    }
                } else if (var5_5 == 6) {
                    if (this.levelClear) {
                        this.grid[var4_4][var3_3] = 7;
                    }
                } else if (var5_5 >= 16 && var5_5 <= 19 && (this.cnt[var4_4][var3_3] & this.switchActivationId) != 0) {
                    switch (var5_5) {
                        case 18: {
                            this.grid[var4_4][var3_3] = 19;
                            break;
                        }
                        case 19: {
                            this.grid[var4_4][var3_3] = 18;
                            break;
                        }
                        case 16: {
                            this.grid[var4_4][var3_3] = 17;
                            break;
                        }
                        case 17: {
                            this.grid[var4_4][var3_3] = 16;
                        }
                    }
                } else if (var5_5 == 9) {
                    this.grid[var4_4][var3_3] = 0;
                } else if (var5_5 == 8) {
                    ++var2_2;
                    v12 = this.cnt[var4_4];
                    v13 = var3_3;
                    v12[v13] = (byte)(v12[v13] + 1);
                    if (this.cnt[var4_4][var3_3] == 120) {
                        this.cnt[var4_4][var3_3] = 0;
                        if (!this.isOccupied(var3_3, var4_4)) {
                            this.enemies.addEnemy((byte)2, var3_3, var4_4, (byte)0, (byte)2, 0);
                        }
                    }
                }
                ++var4_4;
            }
            ++var3_3;
        }
        var4_4 = this.player.x + 8;
        var5_5 = this.player.y + 8;
        var6_6 = var4_4 - this.drawWidth / 2;
        var7_7 = var5_5 - this.drawHeight / 2;
        if (var6_6 < -1) {
            var6_6 = -1;
        } else if (var6_6 > this.pwidth - this.drawWidth + 1) {
            var6_6 = this.pwidth - this.drawWidth + 1;
        }
        if (var7_7 < -1) {
            var7_7 = -1;
        } else if (var7_7 > this.pheight - this.drawHeight + 1) {
            var7_7 = this.pheight - this.drawHeight + 1;
        }
        var8_8 = -(var6_6 % 16);
        var9_9 = -(var7_7 % 16);
        var10_10 = Math.max(var6_6 / 16, 0);
        var11_11 = Math.max(var7_7 / 16, 0);
        var12_12 = (this.drawWidth - var8_8 + 16 - 1) / 16;
        var13_13 = (this.drawHeight - var9_9 + 16 - 1) / 16;
        if (var6_6 == this.pwidth - this.drawWidth + 1) {
            --var12_12;
        }
        if (var7_7 == this.pheight - this.drawHeight + 1) {
            --var13_13;
        }
        var14_14 = false;
        var15_15 = false;
        var1_1.setClip(0, 16, this.drawWidth, this.drawHeight + 16);
        var16_16 = 0;
        while (var16_16 < var12_12) {
            var17_17 = 0;
            while (var17_17 < var13_13) {
                var18_18 /* !! */  = this.floorIm;
                var19_19 = this.grid[var11_11 + var17_17][var10_10 + var16_16];
                var20_21 = this.cnt[var11_11 + var17_17][var10_10 + var16_16];
                switch (var19_19) {
                    default: {
                        break;
                    }
                    case 1: {
                        var18_18 /* !! */  = this.wallIm;
                        break;
                    }
                    case 2: {
                        var18_18 /* !! */  = this.brickIm;
                        break;
                    }
                    case 10: {
                        var18_18 /* !! */  = this.rockIm;
                        break;
                    }
                    case 101: {
                        var21_22 = var20_21 / 2 % 4;
                        if (var21_22 == 3) {
                            var21_22 = 1;
                        }
                        var18_18 /* !! */  = this.bombIm;
                        break;
                    }
                    case 104: {
                        var22_23 = var20_21 / 2 % 2;
                        var18_18 /* !! */  = this.bombIm;
                        break;
                    }
                    case 105: {
                        var23_24 = var20_21 / 2 % 2;
                        var18_18 /* !! */  = this.bombIm;
                        break;
                    }
                    case 106: {
                        var24_25 = var20_21 / 2 % 4;
                        if (var24_25 == 3) {
                            var24_25 = 1;
                        }
                        var18_18 /* !! */  = this.bombIm;
                        break;
                    }
                    case 107: {
                        var25_26 = var20_21 / 2 % 4;
                        if (var25_26 == 3) {
                            var25_26 = 1;
                        }
                        var18_18 /* !! */  = this.bombIm;
                        break;
                    }
                    case 4: {
                        if (var20_21 < 0) break;
                        var18_18 /* !! */  = this.flameIm;
                        break;
                    }
                    case 5: {
                        var18_18 /* !! */  = this.powerIm;
                        break;
                    }
                    case 12: {
                        var18_18 /* !! */  = this.gateIm[1];
                        break;
                    }
                    case 7: {
                        var18_18 /* !! */  = this.openDoorIm;
                        break;
                    }
                    case 6: {
                        var18_18 /* !! */  = this.closedDoorIm;
                        break;
                    }
                    case 13: {
                        var18_18 /* !! */  = this.gateIm[0];
                        break;
                    }
                    case 8: {
                        var26_27 = false;
                        var18_18 /* !! */  = this.spawnerIm;
                        break;
                    }
                    case 14: {
                        var18_18 /* !! */  = this.switchIm[1];
                        break;
                    }
                    case 15: {
                        var18_18 /* !! */  = this.switchIm[0];
                        break;
                    }
                    case 18: {
                        var18_18 /* !! */  = this.sgateIm[2];
                        break;
                    }
                    case 19: {
                        var18_18 /* !! */  = this.sgateIm[3];
                        break;
                    }
                    case 16: {
                        var18_18 /* !! */  = this.sgateIm[0];
                        break;
                    }
                    case 17: {
                        var18_18 /* !! */  = this.sgateIm[1];
                        break;
                    }
                    case 20: {
                        var18_18 /* !! */  = this.chestIm;
                        break;
                    }
                    case 21: {
                        var18_18 /* !! */  = this.treasureIm;
                    }
                }
                var1_1.drawImage(var18_18 /* !! */ , var16_16 * 16 + var8_8, 16 + var17_17 * 16 + var9_9, 20);
                if (var19_19 == 5) {
                    var1_1.drawImage(this.powerItemIm[var20_21 - 1], var16_16 * 16 + var8_8 + 3, 16 + var17_17 * 16 + var9_9 + 3, 20);
                }
                ++var17_17;
            }
            ++var16_16;
        }
        var1_1.setColor(120, 120, 120);
        if (var6_6 == -1) {
            var1_1.drawLine(0, 16, 0, 16 + this.drawHeight - 1);
        }
        if (var7_7 == -1) {
            var1_1.drawLine(0, 16, this.drawWidth - 1, 16);
        }
        if (var6_6 == this.pwidth - this.drawWidth + 1) {
            var1_1.drawLine(this.drawWidth - 1, 16, this.drawWidth - 1, 16 + this.drawHeight - 1);
        }
        if (var7_7 == this.pheight - this.drawHeight + 1) {
            var1_1.drawLine(0, 16 + this.drawHeight - 1, this.drawWidth - 1, 16 + this.drawHeight - 1);
        }
        var17_17 = 0;
        while (var17_17 < 28) {
            block108: {
                block110: {
                    block109: {
                        if (this.fires[var17_17].type == 0) break block108;
                        var18_18 /* !! */  = this.fires[var17_17];
                        var18_18 /* !! */ .x += var18_18 /* !! */ .xsp;
                        var18_18 /* !! */ .y += var18_18 /* !! */ .ysp;
                        var18_18 /* !! */ .cnt = (byte)(var18_18 /* !! */ .cnt - 1);
                        if (var18_18 /* !! */ .cnt != 0) break block109;
                        this.removeFire(var17_17);
                        break block108;
                    }
                    var19_19 = this.getGridX(var18_18 /* !! */ .x);
                    var20_21 = this.getGridY(var18_18 /* !! */ .y);
                    if (var18_18 /* !! */ .type != 1 || !this.setFlame(var19_19, var20_21, 1, false)) break block110;
                    this.removeFire(var17_17);
                    break block108;
                }
                if (var18_18 /* !! */ .type != 4) ** GOTO lbl-1000
                if (var18_18 /* !! */ .cnt > 1) {
                    if (var18_18 /* !! */ .xsp != 0) {
                        if (this.isPassable(var19_19, var20_21 + 1, -1)) {
                            this.addFire((byte)1, var18_18 /* !! */ .x, var18_18 /* !! */ .y, 0, 16, (byte)(var18_18 /* !! */ .cnt - 2));
                        }
                        if (this.isPassable(var19_19, var20_21 - 1, -1)) {
                            this.addFire((byte)1, var18_18 /* !! */ .x, var18_18 /* !! */ .y, 0, -16, (byte)(var18_18 /* !! */ .cnt - 2));
                        }
                    }
                    if (var18_18 /* !! */ .ysp != 0) {
                        if (this.isPassable(var19_19 + 1, var20_21, -1)) {
                            this.addFire((byte)1, var18_18 /* !! */ .x, var18_18 /* !! */ .y, 16, 0, (byte)(var18_18 /* !! */ .cnt - 2));
                        }
                        if (this.isPassable(var19_19 - 1, var20_21, -1)) {
                            this.addFire((byte)1, var18_18 /* !! */ .x, var18_18 /* !! */ .y, -16, 0, (byte)(var18_18 /* !! */ .cnt - 2));
                        }
                    }
                }
                if (this.setFlame(var19_19, var20_21, 1, false)) {
                    this.removeFire(var17_17);
                } else if (var18_18 /* !! */ .type == 3 && this.setFlame(var19_19, var20_21, 1, true)) {
                    this.removeFire(var17_17);
                }
            }
            ++var17_17;
        }
        var1_1.setClip(0, 16, this.drawWidth, this.drawHeight + 16);
        var2_2 += this.enemies.update(-var6_6 + 8, 16 + -var7_7 + 8, this.drawWidth, this.drawHeight + 16, var1_1);
        if (this.player.invinc % 3 < 2) {
            var18_18 /* !! */  = this;
            if (this.player.mode != 1 || this.player.step <= 8 || this.player.step % 2 != 0) {
                var1_1.drawImage(this.player.getImage(), this.player.x - var6_6 + 8, 16 + this.player.y - var7_7 + 8, 3);
            }
        }
        var1_1.setClip(0, 0, this.drawWidth, 16 + this.drawHeight);
        var1_1.setColor(0, 0, 0);
        var1_1.fillRect(0, 0, this.drawWidth, 16);
        var1_1.setColor(200, 180, 160);
        var1_1.drawImage(this.icons[0], 2, 2, 20);
        var1_1.drawImage(this.icons[1], 26, 2, 20);
        var1_1.drawImage(this.icons[2], 50, 2, 20);
        var18_18 /* !! */  = this;
        if (this.player.extra != 0) {
            var19_20 = this.floorIm;
            switch (this.player.extra) {
                case 104: {
                    var19_20 = this.bombIm;
                    break;
                }
                case 105: {
                    var19_20 = this.bombIm;
                    break;
                }
                case 106: {
                    var19_20 = this.bombIm;
                    break;
                }
                case 107: {
                    var19_20 = this.bombIm;
                }
            }
            var1_1.drawImage(var19_20, 74, 0, 20);
            if (this.player.exCnt > 0) {
                var1_1.drawString(Integer.toString(this.player.exCnt), 90, 12, 68);
            }
        }
        var1_1.drawString(Integer.toString(this.player.lives - 1), 14, 12, 68);
        var1_1.drawString(Integer.toString(this.player.bombs), 38, 12, 68);
        var1_1.drawString(Integer.toString(this.player.flames), 62, 12, 68);
        var1_1.drawString(Integer.toString(this.player.points), this.drawWidth - 2, 12, 72);
        var1_1.setColor(255, 80, 0);
        var1_1.drawString(Integer.toString(var2_2), 128, 12, 68);
        ++this.pAnim;
        if (this.pAnim == 120) {
            this.pAnim = 0;
        }
        if (this.levelObjective == 2 && var2_2 == 0) {
            this.levelClear = true;
        }
    }

    public class Fire {
        public static final int DATA_LENGTH = 18;
        byte type = 0;
        byte cnt = 0;
        int x = 0;
        int y = 0;
        int xsp = 0;
        int ysp = 0;

        public boolean encode(OutputStream outputStream) {
            try {
                DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
                dataOutputStream.writeByte(this.type);
                dataOutputStream.writeByte(this.cnt);
                dataOutputStream.writeInt(this.x);
                dataOutputStream.writeInt(this.y);
                dataOutputStream.writeInt(this.xsp);
                dataOutputStream.writeInt(this.ysp);
                boolean bl = true;
                return bl;
            }
            catch (IOException iOException) {
                boolean bl = false;
                return bl;
            }
        }
    }
}

