/*
 * Decompiled with CFR 0.152.
 */
package bomber;

import bomber.SingleItemDB;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class HighScores {
    public static final int NUM_SCORES = 10;
    private int[] scores = new int[10];
    private String[] names = new String[10];

    private HighScores(int[] nArray, String[] stringArray) {
        int n = 0;
        while (n < 10) {
            if (nArray != null && stringArray != null && n < nArray.length && n < stringArray.length) {
                this.scores[n] = nArray[n];
                this.names[n] = stringArray[n];
            } else {
                this.scores[n] = 0;
                this.names[n] = "-";
            }
            ++n;
        }
    }

    private static HighScores unpack(byte[] byArray) {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            int[] nArray = new int[10];
            String[] stringArray = new String[10];
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < 10) {
                nArray[n] = dataInputStream.readInt();
                ++n;
            }
            int n2 = 0;
            while (n2 < 10) {
                int n3;
                stringBuffer.delete(0, stringBuffer.length());
                while ((n3 = dataInputStream.read()) != 59) {
                    stringBuffer.append((char)n3);
                }
                stringArray[n2] = stringBuffer.toString();
                if (stringArray[n2].length() > 10) {
                    stringArray[n2] = stringArray[n2].substring(0, 10);
                }
                ++n2;
            }
            dataInputStream.close();
            byteArrayInputStream.close();
            HighScores highScores = new HighScores(nArray, stringArray);
            return highScores;
        }
        catch (Exception exception) {
            HighScores highScores = null;
            return highScores;
        }
    }

    private byte[] pack() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            int n = 0;
            while (n < 10) {
                dataOutputStream.writeInt(this.scores[n]);
                ++n;
            }
            int n2 = 0;
            while (n2 < 10) {
                dataOutputStream.writeChars(String.valueOf(this.names[n2]) + String.valueOf(';'));
                ++n2;
            }
            dataOutputStream.close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream.close();
            byte[] byArray2 = byArray;
            return byArray2;
        }
        catch (IOException iOException) {
            byte[] byArray = null;
            return byArray;
        }
    }

    public int getScore(int n) {
        if (n < 0 || n >= 10) {
            return -1;
        }
        return this.scores[n];
    }

    public String getName(int n) {
        if (n < 0 || n >= 10) {
            return "";
        }
        return this.names[n];
    }

    public boolean isHighScore(int n) {
        return n > this.scores[9];
    }

    public boolean setHighScore(int n, String string) {
        if (!this.isHighScore(n)) {
            return false;
        }
        int n2 = 9;
        while (n2 > 0 && this.scores[n2 - 1] <= n) {
            --n2;
        }
        int n3 = 9;
        while (n3 > n2) {
            this.scores[n3] = this.scores[n3 - 1];
            this.names[n3] = this.names[n3 - 1];
            --n3;
        }
        this.scores[n2] = n;
        this.names[n2] = string;
        if (HighScores.saveHighScores(this)) {
            System.out.println("Saved high scores.");
        } else {
            System.out.println("Could not save high scores.");
        }
        return true;
    }

    public static void resetHighScores() {
        SingleItemDB.delete("HighScores");
    }

    public static HighScores loadHighScores() {
        byte[] byArray = SingleItemDB.load("HighScores");
        HighScores highScores = HighScores.unpack(byArray);
        if (highScores == null) {
            System.out.println("High scores could not be loaded.");
            highScores = new HighScores(null, null);
        }
        return highScores;
    }

    public static boolean saveHighScores(HighScores highScores) {
        byte[] byArray = highScores.pack();
        if (byArray == null) {
            return false;
        }
        return SingleItemDB.save("HighScores", byArray);
    }
}

