/*
 * Decompiled with CFR 0.152.
 */
package bomber;

import bomber.Bomber;
import bomber.Player;
import bomber.Playfield;
import bomber.RandomNumbers;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Enemies {
    public static final byte NONE = 0;
    public static final byte GHOST = 1;
    public static final byte BLOB = 2;
    public static final byte TROLL = 3;
    public static final byte BUG = 4;
    public static final byte MAGE = 5;
    public static final byte PLAYER = 6;
    public static final byte YETI = 7;
    public static final byte BLUE_BUG = 8;
    public static final byte NO_FACE = -1;
    public static final byte FACE_DOWN = 0;
    public static final byte FACE_LEFT = 1;
    public static final byte FACE_UP = 2;
    public static final byte FACE_RIGHT = 3;
    public static final byte MOVING = 0;
    public static final byte IMMOBILE = 1;
    public static final byte THINKING = 2;
    public static final byte DYING = 3;
    public static final byte CASTING = 4;
    public static final byte FROZEN = 5;
    public static final byte NORMAL = 6;
    public static final int[] STEPS5 = new int[]{0, 1, 2, 1, 0, 3, 4, 3};
    public static final byte[] enemySpeeds = new byte[]{0, 4, 2, 3, 1, 2, 0, 3, 2};
    public static final byte[] enemyHits = new byte[]{0, 1, 1, 3, 3, 1, 0, 3, 1};
    public static final int[] enemyPoints = new int[]{0, 7, 5, 30, 8, 20, 0, 20, 10};
    int numEnemies = 0;
    int activeEnemies = 0;
    int firstEmpty = 0;
    private Enemy[] enemies = null;
    public Playfield playfield = null;
    public Player player = null;
    Image ghostIm = null;
    Image ghostDIm = null;
    Image blobIm = null;
    Image blobDIm = null;
    Image trollDIm = null;
    Image bugIm = null;
    Image bugbIm = null;
    Image yetiDIm = null;
    Image trollIm = null;
    Image mageIm = null;
    Image yetiIm = null;

    public int decodeAllData(InputStream inputStream) {
        try {
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            byte by = dataInputStream.readByte();
            int n = dataInputStream.readInt();
            int n2 = dataInputStream.readInt();
            byte by2 = dataInputStream.readByte();
            byte by3 = dataInputStream.readByte();
            byte by4 = dataInputStream.readByte();
            byte by5 = dataInputStream.readByte();
            byte by6 = dataInputStream.readByte();
            byte by7 = dataInputStream.readByte();
            int n3 = dataInputStream.readInt();
            byte by8 = dataInputStream.readByte();
            int n4 = dataInputStream.readInt();
            boolean bl = dataInputStream.readBoolean();
            int n5 = this.addEnemy(by, n, n2, by2, by3, by4, by5, by6, by7, n3, by8, n4, bl);
            return n5;
        }
        catch (IOException iOException) {
            int n = -1;
            return n;
        }
    }

    public boolean encodeAllEnemies(OutputStream outputStream) {
        try {
            DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
            dataOutputStream.writeInt(this.numEnemies);
            int n = 0;
            while (n < this.numEnemies) {
                if (this.enemies[n].type != 0 && !this.enemies[n].encodeAllData(outputStream)) {
                    boolean bl = false;
                    return bl;
                }
                ++n;
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException iOException) {
            boolean bl = false;
            return bl;
        }
    }

    public boolean decodeAllEnemies(InputStream inputStream) {
        try {
            this.reset();
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            int n = dataInputStream.readInt();
            int n2 = 0;
            while (n2 < n) {
                if (this.decodeAllData(inputStream) == -1) {
                    boolean bl = false;
                    return bl;
                }
                ++n2;
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException iOException) {
            boolean bl = false;
            return bl;
        }
    }

    public Enemies(int n) {
        this.numEnemies = n;
        this.enemies = new Enemy[n];
        int n2 = 0;
        while (n2 < n) {
            this.enemies[n2] = new Enemy();
            ++n2;
        }
        this.reset();
        this.blobIm = Bomber.getImage("set1/blob0");
        this.ghostIm = Bomber.getImage("set1/ghost0");
        this.bugIm = Bomber.getImage("set1/bug0");
        this.bugbIm = Bomber.getImage("set1/bugb0");
        this.mageIm = Bomber.getImage("set1/mage00");
        this.trollIm = Bomber.getImage("set1/troll00");
        this.yetiIm = Bomber.getImage("set1/yeti00");
        this.yetiDIm = Bomber.getImage("set1/yetiD0");
    }

    public void reset() {
        int n = 0;
        while (n < this.numEnemies) {
            this.enemies[n].type = 0;
            ++n;
        }
        this.activeEnemies = 0;
        this.firstEmpty = 0;
    }

    private byte faceLeft(byte by) {
        if (by == 0) {
            return 3;
        }
        return (byte)(by - 1);
    }

    private byte faceRight(byte by) {
        if (by == 3) {
            return 0;
        }
        return (byte)(by + 1);
    }

    public int addEnemy(byte by, int n, int n2, byte by2, byte by3, int n3) {
        return this.addEnemy(by, n * 16, n2 * 16, by2, by3, enemySpeeds[by], (byte)0, (byte)6, enemyHits[by], 0, (byte)0, 0, false);
    }

    public int addEnemy(byte by, int n, int n2, byte by2, byte by3, byte by4, byte by5, byte by6, byte by7, int n3, byte by8, int n4, boolean bl) {
        int n5 = this.firstEmpty;
        while (n5 < this.numEnemies && this.enemies[n5].type != 0) {
            ++n5;
        }
        if (n5 == this.numEnemies) {
            return -1;
        }
        this.enemies[n5].type = by;
        this.enemies[n5].x = n;
        this.enemies[n5].y = n2;
        this.enemies[n5].face = by2;
        this.enemies[n5].state = by3;
        this.enemies[n5].speed = by4;
        this.enemies[n5].step = by5;
        this.enemies[n5].mode = by6;
        this.enemies[n5].hits = by7;
        this.enemies[n5].span = n3;
        this.enemies[n5].invinc = by8;
        this.enemies[n5].power = n4;
        this.enemies[n5].immaterial = bl;
        this.firstEmpty = n5;
        return n5;
    }

    private void removeEnemy(int n) {
        this.enemies[n].type = 0;
        if (this.firstEmpty > n) {
            this.firstEmpty = n;
        }
    }

    public void decode(String string) {
        int n = 0;
        int n2 = 0;
        byte by = 0;
        try {
            int n3 = string.indexOf(44);
            int n4 = string.indexOf(44, n3 + 1);
            n = Integer.parseInt(string.substring(0, n3));
            n2 = Integer.parseInt(string.substring(n3 + 1, n4));
            by = (byte)Integer.parseInt(string.substring(n4 + 1));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Bomber.quitApp();
        }
        if (by == 6) {
            this.player.startX = n * 16;
            this.player.startY = n2 * 16;
            return;
        }
        this.addEnemy(by, n, n2, (byte)0, (byte)2, 0);
    }

    public int update(int n, int n2, int n3, int n4, Graphics graphics) {
        int n5 = 0;
        int n6 = 8;
        int n7 = 0;
        while (n7 < this.numEnemies) {
            if (this.enemies[n7].type != 0) {
                int n8;
                int n9;
                ++n5;
                Image image = this.ghostIm;
                Enemy enemy = this.enemies[n7];
                int n10 = this.playfield.getGridX(enemy.x + n6);
                int n11 = this.playfield.getGridY(enemy.y + n6);
                int n12 = (enemy.x + n6) % 16;
                int n13 = (enemy.y + n6) % 16;
                if (enemy.invinc > 0) {
                    enemy.invinc = (byte)(enemy.invinc - 1);
                }
                if (enemy.state != 3) {
                    if (n10 == this.player.fx && n11 == this.player.fy && this.player.mode != 1 && this.player.mode != 2) {
                        this.player.kill();
                    }
                    if ((n9 = this.playfield.passThrough(n10, n11, false)) == 10 && enemy.invinc == 0) {
                        if (enemy.type == 7) {
                            if (enemy.mode == 5) {
                                enemy.state = (byte)3;
                                enemy.mode = (byte)6;
                                this.player.givePoints(enemyPoints[enemy.type]);
                                enemy.span = 1;
                            } else {
                                enemy.mode = (byte)5;
                                enemy.step = (byte)70;
                            }
                        } else {
                            enemy.hits = (byte)(enemy.hits - 1);
                        }
                        enemy.invinc = (byte)15;
                        if (enemy.hits == 0) {
                            enemy.state = (byte)3;
                            this.player.givePoints(enemyPoints[enemy.type]);
                            enemy.span = 0;
                        }
                    }
                }
                if (enemy.type == 1) {
                    enemy.step = (byte)(enemy.step + 1);
                    if (enemy.step == 8) {
                        enemy.step = 0;
                    }
                    if (enemy.state == 2) {
                        if (this.canMove(n10, n11, enemy.face, n7)) {
                            enemy.state = 0;
                            enemy.span = 16;
                        } else {
                            enemy.face = this.getRandomStrollDirection(n10, n11, enemy.face, true);
                        }
                    }
                    image = this.ghostIm;
                }
                if (enemy.type == 3) {
                    if (enemy.state == 2) {
                        enemy.speed = (byte)(6 - enemy.hits);
                        n9 = this.getRandomStrollDirection(n10, n11, enemy.face, true);
                        if (n9 != -1) {
                            enemy.face = n9;
                            enemy.state = 0;
                            enemy.span = 16;
                        }
                        if ((n9 = this.canISeeThePlayer(n10, n11)) != -1) {
                            enemy.speed = (byte)5;
                            enemy.face = n9;
                            enemy.span = n9 != 0 && n9 != 2 ? Math.abs(this.player.fx - n10) : Math.abs(this.player.fy - n11);
                            enemy.span *= 16;
                        }
                    }
                    if (enemy.state != 0) {
                        enemy.step = 0;
                    } else {
                        enemy.step = (byte)(enemy.step + 1);
                        if (enemy.step == 8) {
                            enemy.step = 0;
                        }
                    }
                    image = this.trollIm;
                }
                if (enemy.type == 4 || enemy.type == 8) {
                    if (enemy.state == 2 && (n9 = this.getRandomStrollDirection(n10, n11, enemy.face, true)) != -1) {
                        enemy.face = n9;
                        enemy.state = 0;
                        enemy.span = 16;
                    }
                    Image image2 = image = enemy.type != 4 ? this.bugbIm : this.bugIm;
                }
                if (enemy.type == 7) {
                    if (enemy.mode == 5) {
                        System.out.println(enemy.step);
                        enemy.step = (byte)(enemy.step - 1);
                        if (enemy.step == 0) {
                            enemy.step = 0;
                            enemy.mode = (byte)6;
                        }
                        image = enemy.step >= 15 || enemy.step % 2 != 0 ? this.yetiDIm : this.yetiIm;
                    } else {
                        if (enemy.state == 2 && (n8 = (n9 = this.playfield.trace[n11][n10]) == -1 ? this.getRandomStrollDirection(n10, n11, enemy.face, true) : (this.canMove(n10, n11, n9, n7) ? n9 : -1)) != -1) {
                            enemy.face = (byte)n8;
                            enemy.state = 0;
                            enemy.span = 16;
                        }
                        if (enemy.state != 0) {
                            enemy.step = 0;
                        } else {
                            enemy.step = (byte)(enemy.step + 1);
                            if (enemy.step == 16) {
                                enemy.step = 0;
                            }
                        }
                        image = this.yetiIm;
                    }
                }
                if (enemy.type == 5) {
                    if (enemy.power < 30) {
                        ++enemy.power;
                    }
                    if (enemy.state != 3 && enemy.face == this.canISeeThePlayer(n10, n11) && enemy.mode != 4) {
                        enemy.mode = (byte)4;
                        enemy.step = (byte)15;
                    }
                    if (enemy.mode == 4) {
                        enemy.step = (byte)(enemy.step - 1);
                        if (enemy.step == 10) {
                            byte by = enemy.face != 1 ? (byte)(enemy.face == 3 ? 1 : 0) : (byte)(n9 = -1);
                            n8 = enemy.face != 2 ? (int)(enemy.face == 0 ? 1 : 0) : -1;
                            this.playfield.addFire((byte)1, n10 * 16, n11 * 16, n9 * 16, n8 * 16, (byte)4);
                            enemy.power = 0;
                        } else if (enemy.step == 0) {
                            enemy.mode = (byte)6;
                        }
                        image = this.mageIm;
                    } else {
                        image = this.mageIm;
                        if (enemy.state == 2 && (n9 = (int)this.getRandomStrollDirection(n10, n11, enemy.face, true)) != -1) {
                            enemy.face = (byte)n9;
                            enemy.state = 0;
                            enemy.span = 16;
                        }
                        if (enemy.state != 0) {
                            enemy.step = 0;
                        } else {
                            enemy.step = (byte)(enemy.step + 1);
                            if (enemy.step == 8) {
                                enemy.step = 0;
                            }
                        }
                    }
                }
                if (enemy.type == 2) {
                    enemy.step = (byte)(enemy.step + 1);
                    if (enemy.step == 8) {
                        enemy.step = 0;
                    }
                    enemy.speed = (byte)(1 + RandomNumbers.next() % 3);
                    if (enemy.state == 2) {
                        int n14;
                        int n15;
                        n9 = this.player.fx - n10;
                        n8 = this.player.fy - n11;
                        byte by = n9 != 0 ? (byte)(n9 <= 0 ? 1 : 3) : (byte)(n15 = -1);
                        byte by2 = n8 != 0 ? (byte)(n8 <= 0 ? 2 : 0) : (byte)(n14 = -1);
                        if (Math.abs(n9) < Math.abs(n8)) {
                            int n16 = n15;
                            n15 = n14;
                            n14 = n16;
                        }
                        if (this.canMove(n10, n11, n15, n7)) {
                            enemy.state = 0;
                            enemy.face = (byte)n15;
                            enemy.span = 16;
                        } else if (this.canMove(n10, n11, n14, n7)) {
                            enemy.state = 0;
                            enemy.face = (byte)n14;
                            enemy.span = 16;
                        }
                    }
                    image = this.blobIm;
                }
                if (enemy.state == 3) {
                    this.removeEnemy(n7);
                } else {
                    if (enemy.state == 0 && enemy.mode == 6) {
                        n9 = Math.min(enemy.speed, enemy.span);
                        switch (enemy.face) {
                            default: {
                                break;
                            }
                            case 0: {
                                if (!this.playfield.isPassable(this.playfield.getGridX(enemy.x + n6), this.playfield.getGridY(enemy.y + 16), n7)) {
                                    enemy.face = (byte)2;
                                    enemy.span = n13 <= n6 ? n13 + n6 : n13 - n6;
                                    break;
                                }
                                enemy.y += n9;
                                enemy.span -= n9;
                                if (enemy.span > 0) break;
                                enemy.state = (byte)2;
                                break;
                            }
                            case 2: {
                                if (!this.playfield.isPassable(this.playfield.getGridX(enemy.x + n6), this.playfield.getGridY(enemy.y - 1), n7)) {
                                    enemy.face = 0;
                                    enemy.span = n13 >= n6 ? n6 * 3 - n13 : n6 - n13;
                                    break;
                                }
                                enemy.y -= n9;
                                enemy.span -= n9;
                                if (enemy.span > 0) break;
                                enemy.state = (byte)2;
                                break;
                            }
                            case 3: {
                                if (!this.playfield.isPassable(this.playfield.getGridX(enemy.x + 16), this.playfield.getGridY(enemy.y + n6), n7)) {
                                    enemy.face = 1;
                                    enemy.span = n12 <= n6 ? n12 + n6 : n12 - n6;
                                    break;
                                }
                                enemy.x += n9;
                                enemy.span -= n9;
                                if (enemy.span > 0) break;
                                enemy.state = (byte)2;
                                break;
                            }
                            case 1: {
                                if (!this.playfield.isPassable(this.playfield.getGridX(enemy.x - 1), this.playfield.getGridY(enemy.y + n6), n7)) {
                                    enemy.face = (byte)3;
                                    enemy.span = n12 >= n6 ? n6 * 3 - n12 : n6 - n12;
                                    break;
                                }
                                enemy.x -= n9;
                                enemy.span -= n9;
                                if (enemy.span > 0) break;
                                enemy.state = (byte)2;
                            }
                        }
                    }
                    if (enemy.type == 2) {
                        this.playfield.occupy(n10, n11);
                    }
                    n9 = enemy.x + n;
                    n8 = enemy.y + n2;
                    if (n9 > -8 && n9 < n3 + 8 && n8 > -8 && n8 < n4 + 8 && (enemy.invinc % 2 == 0 || enemy.state == 3)) {
                        graphics.drawImage(image, n9, n8, 3);
                    }
                }
            }
            ++n7;
        }
        return n5;
    }

    byte getRandomStrollDirection(int n, int n2, byte by, boolean bl) {
        byte by2 = (byte)(RandomNumbers.next() % 2 != 0 ? -1 : 1);
        boolean[] blArray = new boolean[]{this.canMove(n, n2, by, -1), this.canMove(n, n2, this.turn(by, by2), -1), this.canMove(n, n2, this.turn(by, -by2), -1), this.canMove(n, n2, this.turn(by, 2), -1)};
        if (!blArray[0]) {
            if (!blArray[1]) {
                if (!blArray[2]) {
                    if (!blArray[3]) {
                        return -1;
                    }
                    return this.turn(by, 2);
                }
                return this.turn(by, -by2);
            }
            return this.turn(by, by2);
        }
        if (!bl) {
            return by;
        }
        if (blArray[1] && RandomNumbers.next() % 4 == 0) {
            return this.turn(by, by2);
        }
        if (blArray[2] && RandomNumbers.next() % 4 == 0) {
            return this.turn(by, -by2);
        }
        return by;
    }

    byte turn(byte by, int n) {
        if ((by = (byte)(by + n)) > 3) {
            by = (byte)(by - 4);
        }
        if (by < 0) {
            by = (byte)(by + 4);
        }
        return by;
    }

    byte getRandomSafeDirection(int n, int n2, int n3) {
        return -1;
    }

    boolean bombAhead(int n, int n2, byte by) {
        int n3;
        byte by2 = by != 1 ? (byte)(by == 3 ? 1 : 0) : (byte)(n3 = -1);
        int n4 = by != 2 ? (int)(by == 0 ? 1 : 0) : -1;
        int n5 = 0;
        while (n5 < 7) {
            if (this.playfield.isBomb(n, n2)) {
                return true;
            }
            n += n3;
            n2 += n4;
            ++n5;
        }
        return false;
    }

    byte canISeeThePlayer(int n, int n2) {
        if (this.player.mode == 2) {
            return -1;
        }
        if (this.player.fx == n) {
            if (this.player.fy == n2) {
                return -1;
            }
            int n3 = this.player.fy;
            int n4 = n2;
            byte by = 2;
            if (this.player.fy > n2) {
                n4 = n3;
                n3 = n2;
                by = 0;
            }
            int n5 = n3;
            while (n5 <= n4) {
                if (!this.playfield.isPassable(n, n5, -1)) {
                    return -1;
                }
                ++n5;
            }
            return by;
        }
        if (this.player.fy == n2) {
            int n6 = this.player.fx;
            int n7 = n;
            byte by = 1;
            if (this.player.fx > n) {
                n7 = n6;
                n6 = n;
                by = 3;
            }
            int n8 = n6;
            while (n8 <= n7) {
                if (!this.playfield.isPassable(n8, n2, -1)) {
                    return -1;
                }
                ++n8;
            }
            return by;
        }
        return -1;
    }

    boolean canMove(int n, int n2, int n3, int n4) {
        int n5;
        if (n3 == -1) {
            return false;
        }
        byte by = n3 != 1 ? (byte)(n3 == 3 ? 1 : 0) : (byte)(n5 = -1);
        int n6 = n3 != 2 ? (int)(n3 == 0 ? 1 : 0) : -1;
        return this.playfield.isPassable(n + n5, n2 + n6, n4) && !this.playfield.isOccupied(n + n5, n2 + n6);
    }

    public class Enemy {
        public static final int DATA_LENGTH = 25;
        byte type = 0;
        int x = 0;
        int y = 0;
        byte face = 0;
        byte state = 0;
        byte speed = 0;
        byte step = 0;
        byte mode = 0;
        byte hits = 0;
        int span = 0;
        byte invinc = 0;
        int power = 0;
        boolean immaterial = false;

        public boolean encodeAllData(OutputStream outputStream) {
            try {
                DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
                dataOutputStream.writeByte(this.type);
                dataOutputStream.writeInt(this.x);
                dataOutputStream.writeInt(this.y);
                dataOutputStream.writeByte(this.face);
                dataOutputStream.writeByte(this.state);
                dataOutputStream.writeByte(this.speed);
                dataOutputStream.writeByte(this.step);
                dataOutputStream.writeByte(this.mode);
                dataOutputStream.writeByte(this.hits);
                dataOutputStream.writeInt(this.span);
                dataOutputStream.writeByte(this.invinc);
                dataOutputStream.writeInt(this.power);
                dataOutputStream.writeBoolean(this.immaterial);
                boolean bl = true;
                return bl;
            }
            catch (IOException iOException) {
                boolean bl = false;
                return bl;
            }
        }
    }
}

