/*
 * Decompiled with CFR 0.152.
 */
package bombjack;

import bombjack.ImageLoader;
import bombjack.Player;
import gamelib.GameObject;
import java.util.Random;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Enemy
extends GameObject {
    public static final int[] POWERPOINTS = new int[]{100, 200, 300, 500, 800, 1200, 2000};
    public static final byte MAXROBOTFACTORIES = 2;
    public static final byte ENEMY_ROBOT = 10;
    public static final byte ENEMY_BIRD = 11;
    public static final byte ENEMY_HAT = 12;
    public static final byte ENEMY_BALL = 13;
    public static final byte ENEMY_ANTENNA = 14;
    public static final byte ENEMY_BALL2 = 15;
    public static final byte ENEMY_UFO = 16;
    public static final byte POWERBALL = 97;
    public static final byte BCOIN = 98;
    public static final byte ECOIN = 99;
    private static final Image smileyImage = ImageLoader.getImage(11);
    private static final Image appearImage = ImageLoader.getImage(4);
    public byte type;
    public int points = 100;
    public byte powertype = 1;
    protected byte direction = (byte)2;
    public boolean active = false;
    private int animCount = 0;
    private Image animImage;
    protected int[][] anim;
    public int destinationX;
    public int destinationY;
    public int speedX = 200;
    public int speedY = 0;
    public int calcX;
    public int calcY;
    public int latencyX;
    public int latencyY;
    public int cyclecount = 0;
    public int cyclesToRevision = 5;
    public int turnCount = 0;
    public byte factory;
    public short ID;
    public boolean transformToUfo = false;
    public static byte[] gridX = new byte[2];
    public static byte[] gridY = new byte[2];
    public static byte[] maxRobots = new byte[2];
    public static byte[] producedRobots = new byte[2];
    public static int[] productionCycle = new int[2];
    public static int[] cycleCounter = new int[2];
    public static byte[] robotTurns = new byte[2];
    public static int[] wait = new int[2];
    private static Random random = new Random();
    private static Enemy[] allEnemies = new Enemy[12];

    private Enemy() {
        super(0, 0);
    }

    public static void freeAll() {
        for (int i = 0; i < allEnemies.length; ++i) {
            Enemy.allEnemies[i].active = false;
        }
    }

    public static void addRobotFactory(int n, byte by, byte by2, byte by3, int n2, byte by4, int n3) {
        if (n > 1) {
            return;
        }
        Enemy.gridX[n] = by;
        Enemy.gridY[n] = by2;
        Enemy.maxRobots[n] = by3;
        if (maxRobots[n] > 4) {
            Enemy.maxRobots[n] = 4;
        }
        if (n > 0) {
            Enemy.maxRobots[n] = 2;
            if (maxRobots[0] > 3) {
                Enemy.maxRobots[0] = 3;
            }
        }
        Enemy.producedRobots[n] = 0;
        Enemy.productionCycle[n] = n2 + 13;
        Enemy.cycleCounter[n] = n2;
        Enemy.robotTurns[n] = by4;
        Enemy.wait[n] = n3;
    }

    public static void resetRobotFactories() {
        for (int i = 0; i < 2; ++i) {
            Enemy.cycleCounter[i] = productionCycle[i] - wait[i];
            Enemy.producedRobots[i] = 0;
        }
    }

    public static Enemy getEnemy() {
        for (int i = 0; i < allEnemies.length; ++i) {
            if (Enemy.allEnemies[i].active) continue;
            Enemy.allEnemies[i].active = true;
            return allEnemies[i];
        }
        return null;
    }

    public static Enemy produceRobot(byte by) {
        byte by2 = by;
        cycleCounter[by2] = cycleCounter[by2] + 1;
        if (cycleCounter[by2] >= productionCycle[by] && producedRobots[by] < maxRobots[by]) {
            Enemy.cycleCounter[by] = 0;
            byte by3 = by;
            producedRobots[by3] = (byte)(producedRobots[by3] + 1);
            for (int i = 0; i < allEnemies.length; ++i) {
                if (Enemy.allEnemies[i].active) continue;
                allEnemies[i].init((byte)10, gridX[by] * 5, gridY[by] * 7, ImageLoader.getImage(1), -1);
                Enemy.allEnemies[i].factory = by;
                Enemy.allEnemies[i].cyclesToRevision = robotTurns[by];
                Enemy.allEnemies[i].cyclecount = 0;
                Enemy.allEnemies[i].speedX = 100;
                Enemy.allEnemies[i].speedY = 0;
                Enemy.allEnemies[i].transformToUfo = false;
                if (producedRobots == maxRobots) {
                    Enemy.allEnemies[i].transformToUfo = true;
                } else if (random.nextInt() % 100 * 2 > 100) {
                    Enemy.allEnemies[i].transformToUfo = true;
                }
                Enemy.allEnemies[i].active = true;
                return allEnemies[i];
            }
        }
        return null;
    }

    public void init(byte by, int n, int n2, Image image, int n3) {
        this.x = n;
        this.y = n2;
        this.points = 100;
        this.powertype = 1;
        this.direction = (byte)2;
        this.animCount = 0;
        this.speedX = 200;
        this.speedY = 0;
        this.cyclecount = 0;
        this.cyclesToRevision = 5;
        this.turnCount = 0;
        this.type = by;
        this.mode = 6;
        this.ID = (short)n3;
        this.isDying = false;
        this.transformToUfo = false;
        this.destinationX = n;
        this.destinationY = n2;
        this.calcX = n * 100;
        this.calcY = n2 * 100;
        this.animImage = image;
        if (by == 10) {
            this.width = 12;
            this.height = 14;
            this.anim = new int[5][];
            this.anim[0] = new int[]{5, 5, 6, 6, 7, 7};
            this.anim[1] = new int[]{2, 2, 3, 3, 4, 4};
            this.anim[2] = new int[]{0};
            this.anim[4] = new int[]{1};
            this.anim[3] = new int[]{1};
            this.direction = 1;
        } else if (by == 12) {
            this.width = 12;
            this.height = 12;
            this.anim = new int[5][];
            this.anim[0] = new int[]{4, 4, 5, 5, 6, 6, 7, 7};
            this.anim[1] = new int[]{0, 0, 1, 1, 2, 2, 3, 3};
            this.anim[2] = new int[]{0, 0, 1, 1, 2, 2, 3, 3};
            this.anim[4] = new int[]{0, 0, 1, 1, 2, 2, 3, 3};
            this.anim[3] = new int[]{4, 4, 5, 5, 6, 6, 7, 7};
            this.direction = 1;
            this.mode = 5;
        } else if (by == 13) {
            this.width = 12;
            this.height = 12;
            this.anim = new int[5][];
            this.anim[0] = new int[]{0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8};
            this.anim[1] = new int[]{0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8};
            this.anim[2] = new int[]{0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8};
            this.anim[4] = new int[]{0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8};
            this.anim[3] = new int[]{0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8};
            this.direction = 1;
            this.mode = 5;
            this.speedX = 100;
            this.speedY = -100;
        } else if (by == 15) {
            this.width = 11;
            this.height = 11;
            this.anim = new int[5][];
            this.anim[0] = new int[]{0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5};
            this.anim[1] = new int[]{0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5};
            this.anim[2] = new int[]{0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5};
            this.anim[4] = new int[]{0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5};
            this.anim[3] = new int[]{0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5};
            this.direction = 0;
            this.mode = 5;
            this.speedX = -110;
            this.speedY = 130;
        } else if (by == 14) {
            this.width = 12;
            this.height = 12;
            this.anim = new int[5][];
            this.anim[0] = new int[]{0, 0, 1, 1, 2, 2, 3, 3};
            this.anim[1] = new int[]{0, 0, 1, 1, 2, 2, 3, 3};
            this.anim[2] = new int[]{0, 0, 1, 1, 2, 2, 3, 3};
            this.anim[4] = new int[]{0, 0, 1, 1, 2, 2, 3, 3};
            this.anim[3] = new int[]{0, 0, 1, 1, 2, 2, 3, 3};
            this.direction = 1;
            this.mode = 5;
            this.speedX = 200;
            this.speedY = -200;
        } else if (by == 16) {
            this.width = 13;
            this.height = 8;
            this.anim = new int[5][];
            this.anim[0] = new int[]{0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5};
            this.anim[1] = new int[]{0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5};
            this.anim[2] = new int[]{0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5};
            this.anim[4] = new int[]{0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5};
            this.anim[3] = new int[]{0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5};
            this.direction = 0;
            this.mode = 5;
            this.speedX = -20;
            this.speedY = -2;
        } else if (by == 11) {
            this.width = 12;
            this.height = 10;
            this.anim = new int[5][];
            this.anim[0] = new int[]{6, 6, 7, 7, 8, 8};
            this.anim[1] = new int[]{3, 3, 4, 4, 5, 5};
            this.anim[2] = new int[]{0, 0, 1, 1, 2, 2};
            this.anim[4] = new int[]{0, 0, 1, 1, 2, 2};
            this.anim[3] = new int[]{0, 0, 1, 1, 2, 2};
            this.direction = (byte)2;
            this.mode = 5;
        } else if (by == 97) {
            this.width = 10;
            this.height = 10;
            this.speedX = 200;
            this.speedY = -200;
            this.direction = 1;
            this.mode = 5;
            this.powertype = 0;
        } else if (by == 98) {
            this.width = 11;
            this.height = 11;
            this.speedX = 100;
            this.speedY = 0;
            this.direction = 1;
            this.mode = 0;
        } else if (by == 99) {
            this.width = 11;
            this.height = 11;
            this.speedX = 100;
            this.speedY = 0;
            this.direction = 1;
            this.mode = 0;
        }
    }

    public void appear() {
        if (this.animCount++ >= 6) {
            this.mode = this.type == 10 ? 0 : 5;
            this.animCount = 0;
        }
    }

    public void changePowertype() {
        this.powertype = (byte)((this.powertype + 1) % POWERPOINTS.length);
    }

    public void move(int n, int n2) {
        if (this.active && this.mode != 7) {
            this.calcX += n;
            this.calcY += n2;
            this.x = this.calcX / 100;
            this.y = this.calcY / 100;
            byte by = this.direction;
            if (n < 0) {
                this.direction = 0;
            } else if (n > 0) {
                this.direction = 1;
            } else if (this.type != 12) {
                this.direction = (byte)2;
            }
            if (this.type != 12) {
                if (n2 < 0) {
                    this.direction = (byte)3;
                } else if (n2 > 0) {
                    this.direction = (byte)4;
                }
            }
            if (by != this.direction) {
                this.animCount = 0;
            }
            try {
                if (this.type == 10 && (n != 0 || n2 != 0)) {
                    this.animate();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void draw(Graphics graphics) {
        this.draw(graphics, this.x, this.y);
    }

    public void draw(Graphics graphics, int n, int n2) {
        n2 += 2;
        if (this.type == 97) {
            graphics.setClip(n - 1, n2 - 2, this.width, this.height);
            graphics.clipRect(3, 0, 170, 182);
            graphics.drawImage(this.animImage, n - 1 - this.powertype * this.width, n2 - 2, 20);
            this.ox = n - 1;
            this.oy = n2 - 2;
            this.owidth = this.width;
            this.oheight = this.height;
            return;
        }
        if (this.type == 98) {
            graphics.setClip(n - 1, n2, this.width, this.height);
            graphics.clipRect(3, 0, 170, 182);
            graphics.drawImage(this.animImage, n - 1, n2 - 10, 20);
            this.ox = n - 1;
            this.oy = n2;
            this.owidth = this.width;
            this.oheight = this.height;
            return;
        }
        if (this.type == 99) {
            graphics.setClip(n - 1, n2, this.width, this.height);
            graphics.clipRect(3, 0, 170, 182);
            graphics.drawImage(this.animImage, n - 1 - this.width, n2 - 10, 20);
            this.ox = n - 1;
            this.oy = n2;
            this.owidth = this.width;
            this.oheight = this.height;
            return;
        }
        if (Player.player.powerMode || this.mode == 7) {
            if (Player.player.powerTime >= 60 || Player.player.powerTime % 6 >= 2) {
                this.animCount = (this.animCount + 1) % 5;
                int n3 = -(10 - this.height) / 2;
                int n4 = -(10 - this.width) / 2;
                graphics.setClip(n + n4, n2 + n3, 10, 10);
                graphics.clipRect(3, 0, 170, 182);
                graphics.drawImage(smileyImage, n + n4 - this.animCount * 10, n2 + n3, 20);
                this.ox = n + n4;
                this.oy = n2 + n3;
                this.owidth = 10;
                this.oheight = 10;
            }
            return;
        }
        if (this.mode == 6) {
            int n5 = -(25 - this.height) / 2;
            int n6 = -(25 - this.width) / 2;
            graphics.setClip(n + n6, n2 + n5, 25, 25);
            graphics.clipRect(3, 0, 170, 182);
            graphics.drawImage(appearImage, n + n6 - this.animCount * 25, n2 + n5, 20);
            this.ox = n + n6;
            this.oy = n2 + n5;
            this.owidth = 25;
            this.oheight = 25;
            return;
        }
        if (this.active) {
            int n7 = -2;
            int n8 = 0;
            if (this.type == 12) {
                n7 = -3;
            }
            this.animCount %= this.anim[this.direction].length;
            graphics.setClip(n - 1 + n8, n2 + n7, this.width, this.height);
            graphics.clipRect(3, 0, 170, 182);
            graphics.drawImage(this.animImage, n - 1 + n8 - this.anim[this.direction][this.animCount] * this.width, n2 + n7, 20);
            this.ox = n - 1 + n8;
            this.oy = n2 + n7;
            this.owidth = this.width;
            this.oheight = this.height;
            if (this.type != 10) {
                this.animate();
            }
        }
    }

    public int getPoints() {
        if (this.type == 97) {
            return POWERPOINTS[this.powertype];
        }
        if (Player.player.powerMode) {
            return POWERPOINTS[Player.player.enemyCollect];
        }
        return 100;
    }

    public boolean isDestroyable() {
        return this.mode == 7;
    }

    public void animate() {
        this.animCount = (this.animCount + 1) % this.anim[this.direction].length;
    }

    public int[][] getGridPos(int n, int n2) {
        int n3 = (this.x + n) / 5;
        int n4 = (this.y + n2) / 7;
        return new int[][]{{n3, n4}, {n3 + 1, n4}, {n3, n4 + 1}, {n3 + 1, n4 + 1}};
    }

    static {
        for (int i = 0; i < allEnemies.length; ++i) {
            Enemy.allEnemies[i] = new Enemy();
            Enemy.allEnemies[i].active = false;
        }
    }
}

