/*
 * Decompiled with CFR 0.152.
 */
package bombjack;

import bombjack.BombJackScreen;
import bombjack.ImageLoader;
import gamelib.GameObject;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Player
extends GameObject {
    public byte direction = 1;
    private Image playerImage;
    private int[][][] playerAnim;
    public int animCount = 0;
    public int score = 0;
    public short lives = (short)3;
    public short orderCollect = 0;
    public short bombCollect = 0;
    public short bonus = (short)2;
    public short allbombs = 0;
    public static Player player = new Player();
    public boolean powerMode = false;
    public int powerTime = 0;
    public int enemyCollect = 0;
    public int lastBonus = 0;
    public int lastExtra = 0;

    private Player() {
        super(0, 0);
        this.playerImage = ImageLoader.getImage(9);
        this.playerAnim = new int[5][][];
        this.playerAnim[0] = new int[3][];
        this.playerAnim[0][0] = new int[]{7, 7, 8, 8, 9, 9, 10, 10};
        this.playerAnim[0][1] = new int[]{11, 11, 12, 12, 13, 13, 14, 14};
        this.playerAnim[0][2] = new int[]{0};
        this.playerAnim[1] = new int[3][];
        this.playerAnim[1][0] = new int[]{5};
        this.playerAnim[1][1] = new int[]{6};
        this.playerAnim[1][2] = new int[]{4};
        this.playerAnim[2] = new int[3][];
        this.playerAnim[2][0] = new int[]{2};
        this.playerAnim[2][1] = new int[]{3};
        this.playerAnim[2][2] = new int[]{1};
        this.playerAnim[4] = new int[3][];
        this.playerAnim[4][0] = new int[]{2};
        this.playerAnim[4][1] = new int[]{3};
        this.playerAnim[4][2] = new int[]{1};
        this.dieAnim = new int[]{7, 7, 11, 11, 7, 7, 11, 11, 15, 15, 15};
        this.width = 15;
        this.height = 18;
        this.mode = 0;
        this.direction = (byte)2;
    }

    public void die() {
        this.isDying = true;
        this.animCount = 0;
        BombJackScreen.stopSound(BombJackScreen.musicPlayer);
        if (!BombJackScreen.doVibrate) {
            BombJackScreen.playSound(BombJackScreen.sndDead);
        }
    }

    public void score(int n) {
        this.score += n * this.bonus;
    }

    public void reset() {
        this.score = 0;
        this.lives = (short)3;
        this.orderCollect = 0;
        this.bombCollect = 0;
        this.allbombs = 0;
        this.bonus = 1;
        this.animCount = 0;
        this.lastBonus = 0;
        this.lastExtra = 0;
        this.isDying = false;
        this.isDead = false;
    }

    public void draw(Graphics graphics) {
        this.draw(graphics, this.x, this.y);
    }

    public void draw(Graphics graphics, int n, int n2) {
        n2 += 2;
        int n3 = -3;
        int n4 = -4;
        if (this.isDying) {
            graphics.setClip(n + n3, n2 + n4, this.width, this.height);
            graphics.clipRect(3, 0, 170, 182);
            graphics.drawImage(this.playerImage, n + n3 - this.dieAnim[this.animCount] * this.width, n2 + n4, 20);
            if (++this.animCount >= this.dieAnim.length || this.isDead) {
                this.isDead = true;
                this.animCount = this.dieAnim.length - 1;
            }
            return;
        }
        if (this.mode == 2) {
            n4 = -7;
        }
        graphics.setClip(n + n3, n2 + n4, this.width, this.height);
        graphics.clipRect(3, 0, 170, 182);
        graphics.drawImage(this.playerImage, n + n3 - this.playerAnim[this.mode][this.direction][this.animCount] * this.width, n2 + n4, 20);
        this.ox = n + n3;
        this.oy = n2 + n4;
        this.owidth = this.width;
        this.oheight = this.height;
    }

    public void animate() {
        this.animCount = (this.animCount + 1) % this.playerAnim[this.mode][this.direction].length;
    }

    public void move(int n, int n2) {
        this.x += n;
        this.y += n2;
        if (n < 0) {
            if (this.direction != 0) {
                this.animCount = 0;
            }
            this.direction = 0;
        } else if (n > 0) {
            if (this.direction != 1) {
                this.animCount = 0;
            }
            this.direction = 1;
        } else {
            if (this.direction != 2) {
                this.animCount = 0;
            }
            this.direction = (byte)2;
        }
        if (n != 0 || n2 != 0) {
            this.animate();
        }
    }

    public int[][] getGridPos(int n, int n2) {
        int n3 = (this.x + n) / 5;
        int n4 = (this.y + n2) / 7;
        int n5 = (this.x + n) % 5;
        if (n < 0) {
            if (n5 > 2) {
                ++n3;
            }
        } else if (n > 0 && n5 > 2) {
            ++n3;
        }
        if (this.x + n < 0) {
            n3 = -1;
        }
        if (this.y + n2 < 0) {
            n4 = -1;
        }
        int[][] nArrayArray = new int[][]{{n3, n4}, {n3 + 1, n4}, {n3, n4 + 1}, {n3 + 1, n4 + 1}};
        return nArrayArray;
    }
}

