/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class GameCanvas
extends Canvas
implements CommandListener {
    static final int KEY_UP_1 = -1;
    static final int KEY_DOWN_1 = -2;
    static final int KEY_LEFT_1 = -3;
    static final int KEY_RIGHT_1 = -4;
    static final int KEY_FIRE_1 = 32;
    static final int KEY_COMR_1 = -5;
    static final int INIT = 0;
    static final int MENU = 1;
    static final int EXPLAIN = 2;
    static final int OPENING = 3;
    static final int PLAYING = 4;
    static final int GAME_END = 5;
    static final int GAME_OVER = 6;
    static final int FINAL_ENDING = 7;
    static final int DRAW_PAUSE = 9;
    static final int PAUSE_HELP = 10;
    static final int CREATE_BALL = 0;
    static final int READY = 1;
    static final int JUMP = 2;
    static final int FLY = 3;
    static final int SUCCESS = 4;
    static final int EXPLODE = 5;
    static final int SCROLL = 6;
    static final int BONUS = 7;
    static final int BONUS_SUCCESS = 8;
    static final int BONUS_FAIL = 9;
    static final int ENDING_ANI = 10;
    public static int menuItemHeight;
    public static int menuItemStartY;
    static final int[] MENU_ITEM;
    public static boolean lightEnable;
    public static boolean vibration;
    public static boolean sound;
    public static boolean keyEnable;
    static int menuIndex;
    public static int state;
    public static int playState;
    public static Image backImg;
    public static Image ballImg;
    public static Image basketImg;
    public static Image letterImg;
    public static Image mountainImg;
    public static Image cannonImg;
    public static Image gunportImg;
    public static Image planeImg;
    public static Image statusImg;
    public static Image inject1Img;
    public static Image inject2Img;
    public static Image endingImg;
    public static Image menuImg;
    public static Image finalImg;
    public static Image stageImg;
    public static Image greatFireImg;
    public static Image titleImg;
    Image offImage;
    Image offImage2;
    Graphics offScreen;
    Graphics offScreen2;
    public static Cannon midlet;
    public static GeneralThread generalThread;
    public static Vector vector;
    public static Command startCommand;
    public static Command helpCommand;
    public static Command storyCommand;
    public static Command soundOnCommand;
    public static Command soundOffCommand;
    public static Command toTopCommand;
    public static boolean needAllClear;
    public static boolean checkSuccess;
    public static boolean isBonus;
    public static boolean bonusSuccess;
    public static int endingLineNb;
    public static int endingMaxLine;
    public static int basket1X;
    public static int basket1Y;
    public static int basket1Velo;
    public static int v1X;
    public static int v1Y;
    public static int bound1X1;
    public static int bound1X2;
    public static int fix1Y;
    public static int fix2Y;
    public static int basket2Velo;
    public static int basket2X;
    public static int basket2Y;
    public static int v2X;
    public static int v2Y;
    public static int bound2X1;
    public static int bound2X2;
    public static boolean centerVary1;
    public static boolean centerVary2;
    public static int basket3X;
    public static int basket3Y;
    public static int distance2;
    public static int v3Y;
    public static int add;
    public static int tempCurHeight;
    public static int tempBallY;
    public static int tempBasket1Y;
    public static int tempBasket2Y;
    public static int tempBasket3Y;
    public static int ballX;
    public static int ballY;
    public static int ballVelo;
    public static int ballType;
    public static int distance;
    public static int stateCount;
    public static int curBasket;
    public static int curHeight;
    public static int curStage;
    public static int life;
    public static int time;
    public static final int JUMP_VELO = -20;
    public static final int ACCEL = 4;
    public static final int STD_HEIGHT = 52;
    public static int LAND_HEIGHT;
    public static int THIS_HEIGHT;
    public static int BASKET_WIDTH;
    public static int STATUS_HEIGHT;
    public static int LCD_WIDTH;
    public static int LCD_HEIGHT;
    public static int WIDTH;
    public static int HEIGHT;
    public static int MAX_BASKET;
    public static int BG_HEIGHT;
    public static int MOUNTAIN_HEIGHT;
    public static int[][] explodePos;
    public static String[][] OPENING_STR;
    public static String ENDING_STR;
    public static final int[][] BASKET_INFO;

    public void showNotify() {
        this.gameInitialize();
        this.show();
    }

    public GameCanvas(Cannon cannon) {
        midlet = cannon;
        LCD_WIDTH = this.getWidth();
        LCD_HEIGHT = this.getHeight();
        STATUS_HEIGHT = 22;
        WIDTH = LCD_WIDTH;
        HEIGHT = LCD_HEIGHT - STATUS_HEIGHT;
        THIS_HEIGHT = HEIGHT / 2;
        LAND_HEIGHT = (HEIGHT - 10) * 3 * 52 / (4 * THIS_HEIGHT);
        menuItemHeight = (LCD_HEIGHT - 14) / 5;
        menuItemStartY = 7 + menuItemHeight;
        endingMaxLine = (LCD_HEIGHT - 63) / 13;
        this.offImage = Image.createImage((int)WIDTH, (int)LCD_HEIGHT);
        this.offScreen = this.offImage.getGraphics();
        this.offImage2 = Image.createImage((int)WIDTH, (int)HEIGHT);
        this.offScreen2 = this.offImage2.getGraphics();
        startCommand = new Command("Game Start", 1, 1);
        helpCommand = new Command("Help", 1, 2);
        storyCommand = new Command("Story", 1, 3);
        soundOnCommand = new Command("Sound : On", 1, 4);
        soundOffCommand = new Command("Sound : Off", 1, 5);
        toTopCommand = new Command("To Top", 1, 6);
        this.addCommand(startCommand);
        this.addCommand(helpCommand);
        this.addCommand(storyCommand);
        if (sound) {
            this.addCommand(soundOnCommand);
        } else {
            this.addCommand(soundOffCommand);
        }
        this.setCommandListener(this);
        try {
            titleImg = Image.createImage((String)"/title_e.png");
            endingImg = Image.createImage((String)"/ending.png");
            System.gc();
            greatFireImg = Image.createImage((String)"/greatfire.png");
            backImg = Image.createImage((String)"/back.png");
            finalImg = Image.createImage((String)"/final.png");
            menuImg = Image.createImage((String)"/menu_e2.png");
            mountainImg = Image.createImage((String)"/mountain.png");
            stageImg = Image.createImage((String)"/stage.png");
            ballImg = Image.createImage((String)"/ball.png");
            basketImg = Image.createImage((String)"/basket.png");
            letterImg = Image.createImage((String)"/letter_e2.png");
            cannonImg = Image.createImage((String)"/cannon.png");
            gunportImg = Image.createImage((String)"/gunport.png");
            planeImg = Image.createImage((String)"/plane.png");
            inject1Img = Image.createImage((String)"/inject1.png");
            inject2Img = Image.createImage((String)"/inject2.png");
            statusImg = Image.createImage((String)"/status.png");
        }
        catch (Exception exception) {
            // empty catch block
        }
        vector = new Vector();
        generalThread = new GeneralThread();
        generalThread.setPriority(10);
        generalThread.start();
    }

    public void stringParser(Vector vector, Font font, String string, int n) {
        Font font2 = font;
        vector.removeAllElements();
        boolean bl = false;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n2 <= string.length()) {
            String string2;
            n3 = string.indexOf(" ", n4 + 1);
            if (n3 < 0) {
                n3 = string.length() + 1;
                string2 = string.substring(n2);
            } else {
                string2 = string.substring(n2, n3);
            }
            if (font2.stringWidth(string2) < n && n3 <= string.length()) {
                n4 = n3;
                continue;
            }
            if (font2.stringWidth(string2) < n) {
                n4 = n3;
            }
            if (n4 > string.length()) {
                vector.addElement(string.substring(n2));
            } else {
                vector.addElement(string.substring(n2, n4));
            }
            n2 = n4;
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == startCommand) {
            this.removeCommand(startCommand);
            this.removeCommand(helpCommand);
            this.removeCommand(storyCommand);
            this.addCommand(toTopCommand);
            state = 3;
            this.drawOpening();
            this.repaint();
        } else if (command == helpCommand) {
            midlet.viewHelp();
        } else if (command == storyCommand) {
            midlet.viewStory();
        } else if (command == soundOnCommand) {
            sound = false;
            this.removeCommand(soundOnCommand);
            this.addCommand(soundOffCommand);
        } else if (command == soundOffCommand) {
            sound = true;
            this.removeCommand(soundOffCommand);
            this.addCommand(soundOnCommand);
        } else if (command == toTopCommand) {
            this.removeCommand(toTopCommand);
            this.addCommand(startCommand);
            this.addCommand(helpCommand);
            this.addCommand(storyCommand);
            if (sound) {
                this.removeCommand(soundOnCommand);
                this.addCommand(soundOnCommand);
            } else {
                this.removeCommand(soundOffCommand);
                this.addCommand(soundOffCommand);
            }
            this.gameInitialize();
            state = 0;
            this.show();
        }
    }

    public void gameInitialize() {
        curStage = 0;
        playState = 0;
        life = 20;
    }

    public void show() {
        switch (state) {
            case 0: {
                Drawer.clearScreen(this.offScreen);
                this.repaint();
                break;
            }
            case 1: {
                menuIndex = 0;
                this.drawFrame();
                this.repaint();
            }
        }
    }

    private void drawFrame() {
        Drawer.drawFillRect(this.offScreen, 5, 5, WIDTH - 10, LCD_HEIGHT - 10, Drawer.rgbPixel(255, 192, 0));
        Drawer.drawClipImage(this.offScreen, menuImg, 5, 7 + (menuItemHeight - 16) / 2, 110, 16, 0, 52);
        Drawer.drawClipImage(this.offScreen, menuImg, 5, menuItemStartY + menuIndex * menuItemHeight + (menuItemHeight - 16) / 2, 110, 16, 0, 68);
        int n = 0;
        while (n < 4) {
            Drawer.drawClipImage(this.offScreen, menuImg, 17, menuItemStartY + n * menuItemHeight + (menuItemHeight - 16) / 2 + 1, MENU_ITEM[n] & 0xFF, 13, 0, MENU_ITEM[n] >> 10 & 0xFF);
            ++n;
        }
        Drawer.drawClipImage(this.offScreen, menuImg, 55, menuItemStartY + 2 * menuItemHeight + (menuItemHeight - 16) / 2 + 1, 21, 10, 53, 39);
        if (lightEnable) {
            Drawer.drawClipImage(this.offScreen, menuImg, 65, menuItemStartY + 3 * menuItemHeight + (menuItemHeight - 16) / 2 + 1, 15, 10, 35, 39);
        } else {
            Drawer.drawClipImage(this.offScreen, menuImg, 65, menuItemStartY + 3 * menuItemHeight + (menuItemHeight - 16) / 2 + 1, 21, 10, 53, 39);
        }
    }

    private void drawOpening() {
        int n = (WIDTH - 140) / 2;
        int n2 = (LCD_HEIGHT - 140) / 2;
        Drawer.clearScreen(this.offScreen);
        this.drawRoundBox(n, n2, 140, 140);
        Drawer.drawClipImage(this.offScreen, menuImg, (WIDTH - 110) / 2, n2 + 9, 110, 16, 0, 68);
        Drawer.drawClipImage(this.offScreen, stageImg, (WIDTH - 110) / 2 + 17, n2 + 10, 9, 12, 9 * curStage, 0);
        Drawer.drawClipImage(this.offScreen, stageImg, (WIDTH - 110) / 2 + 29, n2 + 10, 62, 12, 27, 0);
        Drawer.drawString(this.offScreen, (WIDTH - this.offScreen.getFont().stringWidth("*MISSION*")) / 2, n2 + 32, "*MISSION*");
        int n3 = 0;
        while (n3 < OPENING_STR[curStage].length) {
            Drawer.drawString(this.offScreen, n + 7, n2 + 53 + 14 * n3, OPENING_STR[curStage][n3]);
            ++n3;
        }
        Drawer.drawString(this.offScreen, n + 7, n2 + 107, " -BOMB:");
        Drawer.drawClipImage(this.offScreen, ballImg, n + 67, n2 + 104, 15, 15, 0, 15 * curStage);
    }

    private void drawRoundBox(int n, int n2, int n3, int n4) {
        Drawer.drawFillRect(this.offScreen, n + 2, n2 + 2, n3 - 4, n4 - 4, Drawer.rgbPixel(255, 192, 0));
        Drawer.drawLine(this.offScreen, n + 4, n2 + 0, n + 4, n2 + n4, Drawer.rgbPixel(128, 0, 0));
        Drawer.drawLine(this.offScreen, n + 0, n2 + 4, n + n3, n2 + 4, Drawer.rgbPixel(128, 0, 0));
        Drawer.drawLine(this.offScreen, n + 0, n2 + n4 - 5, n + n3, n2 + n4 - 5, Drawer.rgbPixel(128, 0, 0));
        Drawer.drawLine(this.offScreen, n + n3 - 5, n2 + 0, n + n3 - 5, n2 + n4, Drawer.rgbPixel(128, 0, 0));
        Drawer.drawFillRect(this.offScreen, n + 2, n2 + 0, 2, n4, Drawer.rgbPixel(255, 192, 0));
        Drawer.drawFillRect(this.offScreen, n + 0, n2 + 2, n3, 2, Drawer.rgbPixel(255, 192, 0));
        Drawer.drawFillRect(this.offScreen, n + n3 - 4, n2 + 0, 2, n4, Drawer.rgbPixel(255, 192, 0));
        Drawer.drawFillRect(this.offScreen, n + 0, n2 + n4 - 4, n3, 2, Drawer.rgbPixel(255, 192, 0));
    }

    public void playStart() {
        this.initialize();
        Drawer.drawFillRect(this.offScreen, 0, 0, WIDTH, LCD_HEIGHT, 8438015);
        Drawer.drawImage(this.offScreen, 0, LCD_HEIGHT - MOUNTAIN_HEIGHT, mountainImg);
        Drawer.drawImage(this.offScreen, 0, STATUS_HEIGHT + curHeight % BG_HEIGHT - BG_HEIGHT, backImg);
        Drawer.drawImage(this.offScreen, 0, STATUS_HEIGHT + curHeight % BG_HEIGHT, backImg);
        Drawer.drawImage(this.offScreen2, 0, -STATUS_HEIGHT, this.offImage);
        this.drawStatusWin();
        this.setBasketInfo();
        this.repaint();
        playState = 0;
    }

    public void initialize() {
        time = 150;
        curHeight = 0;
        curBasket = 0;
        isBonus = false;
    }

    public void drawStatusWin() {
        Drawer.drawImage(this.offScreen, 0, 0, statusImg);
        this.drawLife();
        this.drawTime(time / 10);
        this.drawHeight();
    }

    public void drawLife() {
        Drawer.drawFillRect(this.offScreen, 4, 4, 39, 14, Drawer.rgbPixel(255, 204, 0));
        if (life > 8) {
            Drawer.drawClipImage(this.offScreen, letterImg, 10, 7, 6, 7, 66, 12);
            Drawer.drawClipImage(this.offScreen, letterImg, 18, 7, 5, 7, 66, 21);
            Drawer.drawClipImage(this.offScreen, letterImg, 25, 7, 7, 8, 7 * (life / 10), 0);
            Drawer.drawClipImage(this.offScreen, letterImg, 33, 7, 7, 8, 7 * (life % 10), 0);
        } else {
            int n = 0;
            while (n < life) {
                Drawer.drawClipImage(this.offScreen, letterImg, 7 + 9 * (n % 4), 4 + 7 * (n / 4), 6, 7, 66, 12);
                ++n;
            }
        }
    }

    public void drawTime(int n) {
        Drawer.drawFillRect(this.offScreen, 157, 7, 14, 8, Drawer.rgbPixel(255, 204, 0));
        Drawer.drawClipImage(this.offScreen, letterImg, 157, 7, 7, 8, 7 * (n / 10), 0);
        Drawer.drawClipImage(this.offScreen, letterImg, 164, 7, 7, 8, 7 * (n % 10), 0);
    }

    public void drawHeight() {
        int n = curBasket * 5;
        boolean bl = false;
        int n2 = n / 100;
        Drawer.drawFillRect(this.offScreen, 52, 7, 18, 8, Drawer.rgbPixel(255, 204, 0));
        if (n2 != 0) {
            Drawer.drawClipImage(this.offScreen, letterImg, 52, 7, 7, 8, 7 * n2, 0);
            bl = true;
        }
        if ((n2 = n % 100 / 10) != 0 || bl) {
            Drawer.drawClipImage(this.offScreen, letterImg, 56, 7, 7, 8, 7 * n2, 0);
        }
        n2 = n % 10;
        Drawer.drawClipImage(this.offScreen, letterImg, 63, 7, 7, 8, 7 * n2, 0);
    }

    public void setBasketInfo() {
        if (curBasket > 0) {
            basket1X = basket2X;
            basket1Y = basket2Y;
            v1X = v2X;
            bound1X1 = bound2X1;
            bound1X2 = bound2X2;
            v1Y = v2Y;
            fix1Y = basket1Y;
            centerVary1 = centerVary2;
        } else {
            basket1X = WIDTH * (BASKET_INFO[curStage][curBasket] >> 10 & 0xF) / 8 - BASKET_WIDTH / 2;
            fix1Y = basket1Y = LAND_HEIGHT;
            v1X = (BASKET_INFO[curStage][curBasket] >> 6 & 0xF) - 8;
            v1Y = (BASKET_INFO[curStage][curBasket] >> 2 & 0xF) - 8;
            bound1X1 = WIDTH * (BASKET_INFO[curStage][curBasket] >> 25 & 0xF) / 4;
            bound1X2 = WIDTH * (BASKET_INFO[curStage][curBasket] >> 21 & 0xF) / 4;
            centerVary1 = (BASKET_INFO[curStage][curBasket] & 3) == 1;
        }
        v2X = (BASKET_INFO[curStage][curBasket + 1] >> 6 & 0xF) - 8;
        v2Y = (BASKET_INFO[curStage][curBasket + 1] >> 2 & 0xF) - 8;
        basket2X = WIDTH * (BASKET_INFO[curStage][curBasket + 1] >> 10 & 0xF) / 8 - BASKET_WIDTH / 2;
        distance = BASKET_INFO[curStage][curBasket + 1] >> 14 & 0x7F;
        if (basket2X < 0) {
            basket2X = basket1X;
            v2Y = v1Y;
            v2X = v1X;
            basket2Y -= distance;
        } else {
            basket2Y = LAND_HEIGHT - distance - Math.abs(WIDTH / 2 - basket2X) * v2Y / 4;
        }
        fix2Y = basket2Y;
        bound2X1 = WIDTH * (BASKET_INFO[curStage][curBasket + 1] >> 25 & 0xF) / 4;
        bound2X2 = WIDTH * (BASKET_INFO[curStage][curBasket + 1] >> 21 & 0xF) / 4;
        centerVary2 = (BASKET_INFO[curStage][curBasket + 1] & 3) == 1;
    }

    public void setMoreBasketInfo() {
        v3Y = (BASKET_INFO[curStage][curBasket + 2] >> 2 & 0xF) - 8;
        basket3X = WIDTH * (BASKET_INFO[curStage][curBasket + 2] >> 10 & 0xF) / 8 - BASKET_WIDTH / 2;
        distance2 = BASKET_INFO[curStage][curBasket + 2] >> 14 & 0x7F;
        if (basket3X < 0) {
            basket3X = basket2X;
            v3Y = v2Y;
            basket3Y = basket2Y - distance2;
        } else {
            basket3Y = LAND_HEIGHT - distance2 - distance - Math.abs(WIDTH / 2 - basket3X) * v3Y / 4;
        }
    }

    public void paint(Graphics graphics) {
        if (state == 0) {
            Drawer.drawImage(graphics, (LCD_WIDTH - 176) / 2, (LCD_HEIGHT - 144) / 2, titleImg);
        } else {
            if (needAllClear) {
                Drawer.clearScreen(graphics);
            }
            Drawer.drawImage(graphics, (LCD_WIDTH - WIDTH) / 2, 0, this.offImage);
        }
    }

    public void keyPressed(int n) {
        if (!keyEnable) {
            return;
        }
        switch (state) {
            case 0: {
                break;
            }
            case 3: {
                this.playStart();
                state = 4;
                break;
            }
            case 4: {
                if (playState != 1) break;
                generalThread.setJumpInit();
                break;
            }
            case 10: {
                this.drawStatusWin();
                state = 4;
            }
        }
    }

    public void keyReleased(int n) {
    }

    public void drawBallFirst1() {
        int n = STATUS_HEIGHT + basket1Y * THIS_HEIGHT / 52;
        int n2 = STATUS_HEIGHT + basket2Y * THIS_HEIGHT / 52;
        if (curBasket == MAX_BASKET - 1) {
            Drawer.drawClipImage(this.offScreen, ballImg, basket1X, n, 15, 15, 0, 15 * curStage);
            Drawer.drawImage(this.offScreen, basket1X, n, basketImg);
            Drawer.drawImage(this.offScreen, basket2X - 2, n2, gunportImg);
        } else if (curBasket == MAX_BASKET) {
            Drawer.drawImage(this.offScreen, basket1X - 2, n, gunportImg);
            Drawer.drawClipImage(this.offScreen, inject1Img, basket1X - 2 + 5, n, 10, 8, 10 * curStage, 0);
            Drawer.drawImage(this.offScreen, basket2X - 15, n2, planeImg);
        } else {
            Drawer.drawClipImage(this.offScreen, ballImg, basket1X, n, 15, 15, 0, 15 * curStage);
            Drawer.drawImage(this.offScreen, basket1X, n, basketImg);
            Drawer.drawImage(this.offScreen, basket2X, n2, basketImg);
        }
    }

    public void drawBallFirst2() {
        int n = STATUS_HEIGHT + basket1Y * THIS_HEIGHT / 52;
        int n2 = STATUS_HEIGHT + basket2Y * THIS_HEIGHT / 52;
        if (curBasket == MAX_BASKET - 1) {
            Drawer.drawImage(this.offScreen, basket1X, n, basketImg);
            Drawer.drawImage(this.offScreen, basket2X - 2, n2, gunportImg);
            Drawer.drawClipImage(this.offScreen, inject1Img, basket2X - 2 + 5, n2, 10, 8, 10 * curStage, 0);
        } else if (curBasket == MAX_BASKET) {
            Drawer.drawImage(this.offScreen, basket1X - 2, n, gunportImg);
            Drawer.drawImage(this.offScreen, basket2X - 15, n2, planeImg);
            Drawer.drawClipImage(this.offScreen, inject2Img, basket2X - 15 + 17, n2, 12, 9, 12 * curStage, 0);
        } else {
            Drawer.drawClipImage(this.offScreen, ballImg, basket2X, n2, 15, 15, 0, 15 * curStage);
            Drawer.drawImage(this.offScreen, basket1X, n, basketImg);
            Drawer.drawImage(this.offScreen, basket2X, n2, basketImg);
        }
    }

    public void drawBasketFirst() {
        int n = STATUS_HEIGHT + basket1Y * THIS_HEIGHT / 52;
        int n2 = STATUS_HEIGHT + basket2Y * THIS_HEIGHT / 52;
        if (curBasket == MAX_BASKET - 1) {
            Drawer.drawImage(this.offScreen, basket1X, n, basketImg);
            Drawer.drawImage(this.offScreen, basket2X - 2, n2, gunportImg);
        } else if (curBasket == MAX_BASKET) {
            Drawer.drawImage(this.offScreen, basket1X - 2, n, gunportImg);
            Drawer.drawImage(this.offScreen, basket2X - 15, n2, planeImg);
        } else {
            Drawer.drawImage(this.offScreen, basket1X, n, basketImg);
            Drawer.drawImage(this.offScreen, basket2X, n2, basketImg);
        }
        Drawer.drawClipImage(this.offScreen, ballImg, ballX, STATUS_HEIGHT + ballY * THIS_HEIGHT / 52, 15, 15, 15 * ballType, 15 * curStage);
    }

    public void drawEndingBg() {
        Drawer.drawFillRect(this.offScreen, 0, 0, WIDTH, LCD_HEIGHT, 8438015);
        Drawer.drawImage(this.offScreen, 0, LCD_HEIGHT - BG_HEIGHT - 50, backImg);
    }

    public void nextStage() {
        stateCount = 0;
        if (curStage < 2) {
            ++curStage;
            state = 3;
            this.drawOpening();
        } else {
            stateCount = 0;
            endingLineNb = -endingMaxLine + 1;
            this.stringParser(vector, this.offScreen.getFont(), ENDING_STR, WIDTH - 5);
            state = 7;
        }
    }

    public void pause(int n) {
        try {
            Thread.sleep(n);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        MENU_ITEM = new int[]{13380, 82, 39970, 26669};
        lightEnable = false;
        vibration = true;
        sound = true;
        keyEnable = true;
        state = -1;
        needAllClear = false;
        checkSuccess = false;
        curBasket = 0;
        curHeight = 0;
        BASKET_WIDTH = 15;
        MAX_BASKET = 20;
        BG_HEIGHT = 122;
        MOUNTAIN_HEIGHT = 33;
        explodePos = new int[][]{{5, -25}, {-60, -35}, {60, -30}, {-30, -28}, {30, -28}};
        OPENING_STR = new String[][]{{" -TARGET:", "     Armored", "        Troop"}, {" -TARGET:", "     Air-Force", "         Base"}, {" -LAST TARGET:", "  Presidential", "      Mansion"}};
        ENDING_STR = "The enemy Striked his Flag!! Finally We escaped from pressure of the enemy,and Winned the Peace!!";
        BASKET_INFO = new int[][]{{9245216, 9248160, 9242400, 9247264, 9247264, 9248032, 9242272, 9248032, 9243168, 9243168, 9242400, 9241376, 9242272, 9248032, 42802592, 9247264, 9247264, 9247904, 9247264, 9242400, 9245216, 13436576}, {9245216, 9248032, 9242528, 9248164, 5048096, 7144736, 9243168, 9247904, 9248160, 9242404, 9243168, 9243168, 9242396, 9248032, 76356896, 9247904, 9242396, 9247264, 9242404, 9248164, 9245216, 13436576}, {9245216, 9241888, 9248036, 9248032, 5048224, 9242396, 9247264, 9242528, 9248160, 9242396, 9241372, 9247264, 9242397, 9248032, 40703264, 9248028, 9242400, 9242405, 40703392, 9242532, 9245216, 13436576}};
    }

    public class GeneralThread
    extends Thread {
        boolean alive = true;
        int move1Y;
        int move2Y;

        public void setJumpInit() {
            playState = 2;
            stateCount = 0;
            ballVelo = -20;
            checkSuccess = false;
        }

        public void run() {
            while (this.alive) {
                if (state == 4) {
                    if (playState != 6 && playState != 7 && playState != 10) {
                        Drawer.drawImage(GameCanvas.this.offScreen, 0, STATUS_HEIGHT, GameCanvas.this.offImage2);
                        if (basket1X + v1X < bound1X1 || basket1X + v1X / 2 > bound1X2 - BASKET_WIDTH) {
                            v1X *= -1;
                            v1Y *= -1;
                        } else if (centerVary1 && (WIDTH / 2 - 7 - (basket1X + v1X)) * (WIDTH / 2 - 7 - basket1X) < 0) {
                            v1Y *= -1;
                        }
                        if (basket2X + v2X < bound2X1 || basket2X + v2X > bound2X2 - BASKET_WIDTH) {
                            v2X *= -1;
                            v2Y *= -1;
                        } else if (centerVary2 && (WIDTH / 2 - 7 - (basket2X + v2X)) * (WIDTH / 2 - 7 - basket2X) < 0) {
                            v2Y *= -1;
                        }
                        this.move1Y += Math.abs(v1X) * v1Y;
                        this.move2Y += Math.abs(v2X) * v2Y;
                        basket1X += v1X;
                        basket1Y = fix1Y + this.move1Y / 4;
                        basket2X += v2X;
                        basket2Y = fix2Y + this.move2Y / 4;
                        if (--time % 10 == 0) {
                            GameCanvas.this.drawTime(time / 10);
                        }
                        if (time < 0) {
                            time = 9;
                            playState = 5;
                            stateCount = 0;
                        }
                    }
                    switch (playState) {
                        case 0: {
                            if (++stateCount < 2) {
                                ballX = LCD_WIDTH + 5;
                                GameCanvas.this.drawBasketFirst();
                                break;
                            }
                            ballX = basket1X;
                            ballY = basket1Y - 12 + (stateCount - 3) * 3;
                            ballType = 0;
                            GameCanvas.this.drawBasketFirst();
                            if (stateCount < 5) {
                                Drawer.drawClipImage(GameCanvas.this.offScreen, letterImg, ballX - 5, STATUS_HEIGHT + ballY * THIS_HEIGHT / 52 - 21, 25, 23, 55, 57);
                            }
                            if (stateCount < 5) break;
                            stateCount = 0;
                            ballY = basket1Y;
                            playState = 1;
                            break;
                        }
                        case 1: {
                            ballX = basket1X;
                            GameCanvas.this.drawBallFirst1();
                            break;
                        }
                        case 2: {
                            ballX = basket1X;
                            ballY = basket1Y += 3;
                            ballType = 0;
                            GameCanvas.this.drawBallFirst1();
                            playState = 3;
                            stateCount = 0;
                            ballY = basket1Y -= 3;
                            break;
                        }
                        case 3: {
                            ballY += ballVelo;
                            ballVelo += 4;
                            if (++ballType > 4) {
                                ballType = 0;
                            }
                            if (!checkSuccess && ballVelo >= 0 && ballY + ballVelo >= basket2Y) {
                                checkSuccess = true;
                                if (ballX > basket2X - 6 && ballX < basket2X + 6) {
                                    stateCount = 0;
                                    playState = isBonus ? 8 : 4;
                                }
                            } else if (isBonus && ballY + ballVelo >= basket1Y) {
                                stateCount = 0;
                                playState = 9;
                            } else if ((ballY + ballVelo) * THIS_HEIGHT / 52 > HEIGHT) {
                                stateCount = 0;
                                playState = 5;
                            }
                            GameCanvas.this.drawBasketFirst();
                            break;
                        }
                        case 4: {
                            if (stateCount == 0) {
                                basket2Y += 2;
                            } else if (stateCount == 2) {
                                basket2Y -= 2;
                            }
                            ballY = basket2Y;
                            ballX = basket2X;
                            ballType = 0;
                            if (++stateCount > 3) {
                                stateCount = -1;
                                playState = 6;
                                GameCanvas.this.setMoreBasketInfo();
                                tempCurHeight = curHeight;
                                tempBallY = ballY;
                                tempBasket1Y = basket1Y;
                                tempBasket2Y = basket2Y;
                                tempBasket3Y = basket3Y;
                            }
                            GameCanvas.this.drawBallFirst2();
                            break;
                        }
                        case 5: {
                            ++stateCount;
                            GameCanvas.this.drawBasketFirst();
                            if (ballY * THIS_HEIGHT / 52 > HEIGHT) {
                                Drawer.drawClipImage(GameCanvas.this.offScreen, menuImg, ballX - 7, LCD_HEIGHT - 15, 29, 29, 79, 12);
                            } else {
                                Drawer.drawClipImage(GameCanvas.this.offScreen, menuImg, ballX - 7, STATUS_HEIGHT + ballY * THIS_HEIGHT / 52 - 11, 29, 29, 79, 12);
                            }
                            if (stateCount <= 3) break;
                            if (--life < 0) {
                                stateCount = 3;
                                ballX = LCD_WIDTH + 1;
                                state = 6;
                                break;
                            }
                            stateCount = 0;
                            time = 150;
                            GameCanvas.this.drawLife();
                            GameCanvas.this.drawTime(time / 10);
                            playState = 0;
                            break;
                        }
                        case 6: {
                            if (++stateCount == 6) {
                                ++curBasket;
                                time = 150;
                                GameCanvas.this.setBasketInfo();
                                Drawer.drawFillRect(GameCanvas.this.offScreen, 0, 0, WIDTH, LCD_HEIGHT, 8438015);
                                Drawer.drawImage(GameCanvas.this.offScreen, 0, LCD_HEIGHT - MOUNTAIN_HEIGHT, mountainImg);
                                Drawer.drawImage(GameCanvas.this.offScreen, 0, STATUS_HEIGHT + curHeight % BG_HEIGHT - BG_HEIGHT, backImg);
                                Drawer.drawImage(GameCanvas.this.offScreen, 0, STATUS_HEIGHT + curHeight % BG_HEIGHT, backImg);
                                GameCanvas.this.drawStatusWin();
                                Drawer.drawImage(GameCanvas.this.offScreen2, 0, -STATUS_HEIGHT, GameCanvas.this.offImage);
                                GameCanvas.this.drawBallFirst1();
                                ++stateCount;
                                break;
                            }
                            if (stateCount >= 7) {
                                stateCount = 0;
                                this.move2Y = 0;
                                this.move1Y = 0;
                                if (curBasket == MAX_BASKET) {
                                    playState = 7;
                                    if (curStage >= 2) break;
                                    Drawer.drawClipImage(GameCanvas.this.offScreen, letterImg, (WIDTH - 58) / 2, STATUS_HEIGHT + (HEIGHT - 32) / 2, 58, 14, 3, 8);
                                    Drawer.drawClipImage(GameCanvas.this.offScreen, letterImg, (WIDTH - 64) / 2, STATUS_HEIGHT + (HEIGHT - 32) / 2 + 18, 64, 14, 0, 22);
                                    break;
                                }
                                playState = 1;
                                break;
                            }
                            if (stateCount < 1) break;
                            add = stateCount * distance / 5;
                            curHeight = tempCurHeight + stateCount * (distance * THIS_HEIGHT / 52) / 5;
                            ballY = tempBallY + add;
                            basket1Y = tempBasket1Y + add;
                            basket2Y = tempBasket2Y + add;
                            basket3Y = tempBasket3Y + add;
                            Drawer.drawFillRect(GameCanvas.this.offScreen, 0, 0, WIDTH, LCD_HEIGHT, 8438015);
                            Drawer.drawImage(GameCanvas.this.offScreen, 0, LCD_HEIGHT - MOUNTAIN_HEIGHT, mountainImg);
                            Drawer.drawImage(GameCanvas.this.offScreen, 0, STATUS_HEIGHT + curHeight % BG_HEIGHT - BG_HEIGHT, backImg);
                            Drawer.drawImage(GameCanvas.this.offScreen, 0, STATUS_HEIGHT + curHeight % BG_HEIGHT, backImg);
                            if (curBasket == MAX_BASKET - 2) {
                                Drawer.drawImage(GameCanvas.this.offScreen, basket3X - 2, STATUS_HEIGHT + basket3Y * THIS_HEIGHT / 52, gunportImg);
                            } else if (curBasket == MAX_BASKET - 1) {
                                Drawer.drawImage(GameCanvas.this.offScreen, basket3X - 15, STATUS_HEIGHT + basket3Y * THIS_HEIGHT / 52, planeImg);
                            } else {
                                Drawer.drawImage(GameCanvas.this.offScreen, basket3X, STATUS_HEIGHT + basket3Y * THIS_HEIGHT / 52, basketImg);
                            }
                            GameCanvas.this.drawBallFirst2();
                            GameCanvas.this.drawStatusWin();
                            break;
                        }
                        case 7: {
                            if (++stateCount != 7) break;
                            isBonus = true;
                            playState = 1;
                            break;
                        }
                        case 8: {
                            if (++stateCount < 10) {
                                GameCanvas.this.drawBallFirst2();
                                if (curStage >= 2) break;
                                Drawer.drawClipImage(GameCanvas.this.offScreen, letterImg, (WIDTH - 80) / 2, STATUS_HEIGHT + (HEIGHT - 15) / 2, 80, 15, 0, 36);
                                if (curStage == 1) {
                                    Drawer.drawFillRect(GameCanvas.this.offScreen, (WIDTH - 80) / 2 + 61, STATUS_HEIGHT + (HEIGHT - 15) / 2, 9, 11, 8438015);
                                    Drawer.drawClipImage(GameCanvas.this.offScreen, letterImg, (WIDTH - 80) / 2 + 61, STATUS_HEIGHT + (HEIGHT - 15) / 2, 9, 11, 71, 25);
                                }
                                if (stateCount != 4) break;
                                life = curStage == 0 ? (life += 3) : (life += 7);
                                GameCanvas.this.drawLife();
                                break;
                            }
                            stateCount = -10;
                            bonusSuccess = true;
                            playState = 10;
                            break;
                        }
                        case 9: {
                            if (++stateCount < 10) {
                                GameCanvas.this.drawBallFirst1();
                                if (curStage >= 2) break;
                                Drawer.drawClipImage(GameCanvas.this.offScreen, letterImg, (WIDTH - 52) / 2, STATUS_HEIGHT + (HEIGHT - 15) / 2, 52, 15, 0, 51);
                                break;
                            }
                            stateCount = -10;
                            bonusSuccess = false;
                            playState = 10;
                            break;
                        }
                        case 10: {
                            if (++stateCount < 10) {
                                if (stateCount == -9) {
                                    GameCanvas.this.drawEndingBg();
                                    Drawer.drawFillRect(GameCanvas.this.offScreen, 0, LCD_HEIGHT - 10, WIDTH, 11, Drawer.rgbPixel(0, 160, 0));
                                    Drawer.drawImage(GameCanvas.this.offScreen, 0, LCD_HEIGHT - 40, mountainImg);
                                    Drawer.drawImage(GameCanvas.this.offScreen2, 0, -STATUS_HEIGHT, GameCanvas.this.offImage);
                                    ballX = 40;
                                    ballY = LCD_HEIGHT - 50;
                                } else {
                                    Drawer.drawImage(GameCanvas.this.offScreen, 0, STATUS_HEIGHT, GameCanvas.this.offImage2);
                                }
                                if (bonusSuccess) {
                                    Drawer.drawImage(GameCanvas.this.offScreen, WIDTH * stateCount / 10, 25, planeImg);
                                    Drawer.drawClipImage(GameCanvas.this.offScreen, inject2Img, WIDTH * stateCount / 10 + 17, 25, 12, 9, 12 * curStage, 0);
                                    if (stateCount >= 0) break;
                                    Drawer.drawClipImage(GameCanvas.this.offScreen, letterImg, (WIDTH - 53) / 2, (LCD_HEIGHT - 15) / 2, 53, 15, 0, 66);
                                    break;
                                }
                                if (stateCount == 3) {
                                    Drawer.drawImage(GameCanvas.this.offScreen, 7, LCD_HEIGHT - 45, cannonImg);
                                } else {
                                    Drawer.drawImage(GameCanvas.this.offScreen, 10, LCD_HEIGHT - 45, cannonImg);
                                }
                                if (stateCount > 4) {
                                    ballX += (WIDTH - 3 - ballX) / (10 - stateCount);
                                    ballY += (25 - ballY) / (10 - stateCount);
                                }
                                if (stateCount > 3) {
                                    if (curStage < 2) {
                                        if (++ballType > 4) {
                                            ballType = 0;
                                        }
                                    } else {
                                        ballType = 4;
                                    }
                                    Drawer.drawClipImage(GameCanvas.this.offScreen, ballImg, ballX, ballY, 15, 15, 15 * ballType, 15 * curStage);
                                }
                                if (stateCount >= 0) break;
                                Drawer.drawClipImage(GameCanvas.this.offScreen, letterImg, (WIDTH - 53) / 2, (LCD_HEIGHT - 15) / 2, 53, 15, 0, 66);
                                break;
                            }
                            if (stateCount < 35) {
                                if (stateCount == 10) {
                                    GameCanvas.this.drawEndingBg();
                                    Drawer.drawClipImage(GameCanvas.this.offScreen, endingImg, 0, LCD_HEIGHT - 40, 176, 40, 0, 40 * curStage);
                                    Drawer.drawImage(GameCanvas.this.offScreen2, 0, -STATUS_HEIGHT, GameCanvas.this.offImage);
                                    ballX = -3;
                                    ballY = 25;
                                } else {
                                    Drawer.drawImage(GameCanvas.this.offScreen, 0, STATUS_HEIGHT, GameCanvas.this.offImage2);
                                }
                                if (bonusSuccess) {
                                    Drawer.drawImage(GameCanvas.this.offScreen, WIDTH * (stateCount - 10) / 8, 25, planeImg);
                                    if (stateCount < 14) {
                                        Drawer.drawClipImage(GameCanvas.this.offScreen, inject2Img, WIDTH * (stateCount - 10) / 8 + 17, 25, 12, 9, 12 * curStage, 0);
                                        break;
                                    }
                                    if (stateCount < 17) {
                                        Drawer.drawClipImage(GameCanvas.this.offScreen, ballImg, WIDTH * 3 / 8, 25 + (LCD_HEIGHT - 20 - 25) * (stateCount - 14) / 3, 15, 15, 0, 15 * curStage);
                                        break;
                                    }
                                    if (stateCount < 23) {
                                        int n = 0;
                                        while (n < stateCount - 17) {
                                            Drawer.drawClipImage(GameCanvas.this.offScreen, menuImg, WIDTH * 1 / 2 + explodePos[n][0] - 7, 25 + (LCD_HEIGHT - 25) + explodePos[n][1], 29, 29, 79, 12);
                                            ++n;
                                        }
                                        break;
                                    }
                                    Drawer.drawImage(GameCanvas.this.offScreen, 0, LCD_HEIGHT - (40 + curStage * 20), greatFireImg);
                                    break;
                                }
                                if (stateCount < 17) {
                                    if (curStage < 2) {
                                        if (++ballType > 4) {
                                            ballType = 0;
                                        }
                                    } else {
                                        ballType = 3;
                                    }
                                    if (stateCount > 10) {
                                        ballX += (WIDTH / 2 - ballX) / (17 - stateCount);
                                        ballY += (LCD_HEIGHT - 20 - ballY) / (17 - stateCount);
                                    }
                                    Drawer.drawClipImage(GameCanvas.this.offScreen, ballImg, ballX, ballY, 15, 15, 15 * ballType, 15 * curStage);
                                    break;
                                }
                                if (stateCount < 23) {
                                    int n = 0;
                                    while (n < stateCount - 17) {
                                        Drawer.drawClipImage(GameCanvas.this.offScreen, menuImg, WIDTH * 3 / 8 + explodePos[n][0] - 7, 25 + (LCD_HEIGHT - 25) + explodePos[n][1], 29, 29, 79, 12);
                                        ++n;
                                    }
                                    break;
                                }
                                Drawer.drawImage(GameCanvas.this.offScreen, 0, LCD_HEIGHT - (40 + curStage * 20), greatFireImg);
                                break;
                            }
                            GameCanvas.this.nextStage();
                        }
                    }
                    GameCanvas.this.repaint();
                    GameCanvas.this.pause(100);
                    continue;
                }
                if (state == 6) {
                    Drawer.drawFillRect(GameCanvas.this.offScreen, 0, 0, LCD_WIDTH, LCD_HEIGHT, -5);
                    String string = "GAME OVER";
                    int n = 0;
                    while (n <= string.length()) {
                        Drawer.drawString(GameCanvas.this.offScreen, (WIDTH - GameCanvas.this.offScreen.getFont().stringWidth("GAME OVER")) / 2, (LCD_HEIGHT - 12) / 2, -2, -5, string.substring(0, n));
                        GameCanvas.this.repaint();
                        GameCanvas.this.pause(300);
                        ++n;
                    }
                    GameCanvas.this.pause(1000);
                    stateCount = 0;
                    GameCanvas.this.gameInitialize();
                    state = 0;
                    Drawer.clearScreen(GameCanvas.this.offScreen);
                    GameCanvas.this.show();
                    continue;
                }
                if (state == 7) {
                    if (stateCount == 0) {
                        Drawer.clearScreen(GameCanvas.this.offScreen);
                        Drawer.drawImage(GameCanvas.this.offScreen, 0, 0, finalImg);
                        stateCount = 1;
                    }
                    if (stateCount == 1) {
                        Drawer.drawFillRect(GameCanvas.this.offScreen, 0, 63, WIDTH, LCD_HEIGHT - 63, -2);
                        int n = 0;
                        while (n < endingMaxLine) {
                            if (n + endingLineNb >= 0 && n + endingLineNb < vector.size()) {
                                Drawer.drawString(GameCanvas.this.offScreen, 4, 63 + 13 * n, (String)vector.elementAt(n + endingLineNb));
                            }
                            ++n;
                        }
                        GameCanvas.this.repaint();
                        GameCanvas.this.pause(1000);
                        if (n + endingLineNb >= vector.size() + 2) {
                            stateCount = 2;
                            Drawer.drawString(GameCanvas.this.offScreen, (WIDTH - GameCanvas.this.offScreen.getFont().stringWidth("-THE END-")) / 2, 63 + 13 * (endingMaxLine - 1), "-THE END-");
                            GameCanvas.this.repaint();
                            continue;
                        }
                        ++endingLineNb;
                        continue;
                    }
                    GameCanvas.this.pause(300);
                    continue;
                }
                GameCanvas.this.pause(300);
            }
        }
    }
}

