/*
 * Decompiled with CFR 0.152.
 */
package puzzlebubble;

import java.io.IOException;
import java.io.InputStream;
import java.util.Random;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;
import puzzlebubble.font;
import puzzlebubble.hiscoreMenu;
import puzzlebubble.puzzlebubble;

class GameScreen
extends GameCanvas
implements Runnable {
    private Random random;
    private static int MAGICX = 0;
    private static int MAGICY = -3;
    private static final boolean DEBUG = false;
    private static final int BALLS = 9;
    private static final int NORMALBALLS = 7;
    private static final int SCREENWIDTH = 176;
    private static final int SCREENHEIGHT = 208;
    private static final int LEFTCROWDSIZE = 16;
    private static final int RIGHTCROWDSIZE = 16;
    private static final int TOPCROWDSIZE = 16;
    private static final int TOPADDCROWDSIZE = 16;
    private static final int PLAYGROUNDWIDTH = 9;
    private static final int PLAYGROUNDHEIGHT = 13;
    private static final int PLAYGROUNDLOOSELEVEL = 12;
    private static final int BALLDIAMETER = 16;
    private static final int BALLDIAMETER2 = 256;
    private static final int BALLRADIUS = 8;
    private static final int BALLSPACINGHEIGHT = 13;
    private static final int BALLSPACINGWIDTH = 16;
    private static final int CHANGEBACKGROUNDEACH = 10;
    private static final int HALFSCREENWIDTH = 88;
    private static final int HALFSCREENHEIGHT = 104;
    private static final int KEYREPEATTIME = 3;
    private static final int FIXPOINT = 5;
    private static final int NOF_LEVELS = 50;
    private static final int BALLSPEEDFIXX = 200;
    private static final int BALLSPEEDFIXY = 100;
    private static final int PLAYERANIMSPEED = 4;
    private static final int FALLINGBALLSDY = 15;
    private static int EXPLOSIONPARTWIDTH;
    private static int EXPLOSIONWIDTH;
    private static int EXPLOSIONHEIGHT;
    private static int FLASHWIDTH;
    private static int FLASHHEIGHT;
    int[] circleX = new int[]{-16, -15, -15, -14, -13, -13, -12, -11, -10, -9, -8, -7, -6, -5, -4, -3, -2, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 19, 19};
    int[] circleY = new int[]{16, 17, 18, 19, 20, 21, 22, 23, 24, 24, 25, 26, 26, 27, 27, 27, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 27, 26, 26, 25, 24, 23, 22, 21, 20, 19, 18, 17, 16};
    private static int HALFCIRCLERADIUS;
    private static int NOFCURSORPOS;
    private static int NEWBALLDELTAY;
    private static int MENU_INTRO_SPLASH;
    private static int MENU_INTRO_SPLASH_KEY_DOWN;
    private static int MENU_MENU;
    private static int MENU_MENU_DIFFICULTY;
    private static int MENU_YOU_DIED_ANIM;
    private static int MENU_LOST_A_LIFE;
    private static int MENU_LOST_A_LIFE_ANIM;
    private static int MENU_HISCORE;
    private static int MENU_PLAY_START;
    private static int MENU_PLAY;
    private static int MENU_INTRO_LOGO;
    private static int MENU_STAGE_CLEAR;
    private static int MENU_STAGE_CLEAR_ANIM;
    private static int MENU_HELP;
    private static int MENU_CREDITS;
    private static int MENU_PAUSE;
    hiscoreMenu hiscoremenu = null;
    private static int SHOW_NOF_HISCORES;
    int i;
    int a;
    int b;
    puzzlebubble midlet;
    private static int MAXNOFFALLINGTHINGS;
    int[] fallingBalls_x = new int[MAXNOFFALLINGTHINGS];
    int[] fallingBalls_y = new int[MAXNOFFALLINGTHINGS];
    int[] fallingBalls_dx = new int[MAXNOFFALLINGTHINGS];
    int[] fallingBalls_dy = new int[MAXNOFFALLINGTHINGS];
    int[] fallingBalls_what = new int[MAXNOFFALLINGTHINGS];
    int nofFallingBalls;
    font myfont;
    int menu = MENU_INTRO_LOGO;
    int menu_value = 0;
    Image intro;
    Image iTemp = null;
    Image iTemp2 = null;
    Image iTemp3 = null;
    Image iHelp1 = null;
    Image iHelp2 = null;
    Image iHelp3 = null;
    Image[] ballon = new Image[9];
    Image life;
    Image spark;
    Image score;
    Image backgroundpeople;
    Image backgroundleft;
    Image backgroundright;
    Image background;
    Image halfCircle;
    Image nextBall;
    Image cursor;
    Image menuBackground;
    Image menuForeground;
    Image logo;
    Image logo1;
    Image logo2;
    Image playerAnim;
    Image arrow;
    Image player;
    int player_anim;
    Image explosion;
    byte[][] playground = new byte[9][13];
    byte[][] countground = new byte[9][13];
    int ingame_level;
    int ingame_start_level = 0;
    int ingame_lives;
    boolean ingame_ball_rolling;
    int ingame_fix_x;
    int ingame_fix_y;
    int ingame_ball_fix_dx;
    int ingame_ball_fix_dy;
    int ingame_cursorpos = 10;
    int ingame_concrete_level;
    int ingame_ball;
    int ingame_next_ball;
    boolean[] ingame_ball_on = new boolean[9];
    boolean ingame_level_completed;
    int ingame_score;
    int ingame_time;
    int ingame_combo;
    boolean ingame_pause = false;
    boolean key_left = false;
    boolean key_right = false;
    boolean key_fire = false;
    boolean key_down = false;
    boolean key_up = false;
    boolean key_menu_right = false;
    boolean key_menu_left = false;
    int key_left_time = 0;
    int key_right_time = 0;
    int key_fire_time = 0;
    int key_down_time = 0;
    boolean key_numeric_5 = false;
    boolean key_left_down = false;
    boolean key_right_down = false;
    boolean key_fire_down = false;
    boolean key_down_down = false;
    boolean key_ok = false;
    int prelude_x = 0;
    int prelude_y = 0;
    int prelude_dx = 0;
    int prelude_dy = 0;
    int frames = 0;
    Graphics glob_g;
    byte r_ball;
    boolean b_check_out;

    public GameScreen(puzzlebubble midlet) {
        super(false);
        this.setFullScreenMode(true);
        this.midlet = midlet;
        this.random = new Random();
        this.myfont = new font();
        try {
            this.arrow = Image.createImage((String)"/gfx/menuscreen_arrow.png");
        }
        catch (Exception ioe) {
            System.out.println("ERROR: chargement des Images");
            ioe.printStackTrace();
            return;
        }
        new Thread(this).start();
    }

    public void keyPressed(int keyCode) {
        System.out.println("".concat(String.valueOf(String.valueOf(keyCode))));
        if (keyCode == 1) {
            this.key_fire = true;
            this.key_fire_down = true;
            this.key_up = true;
        }
        if (keyCode == 50 || keyCode == 53 || keyCode == 56) {
            this.key_fire = true;
        }
        if (keyCode == 49 || keyCode == 50 || keyCode == 51) {
            this.key_up = true;
        }
        if (keyCode == 6) {
            this.key_down = true;
            this.key_down_down = true;
        }
        if (keyCode == 2 || keyCode == 49 || keyCode == 52 || keyCode == 55) {
            this.key_left = true;
            this.key_left_down = true;
        }
        if (keyCode == 5 || keyCode == 51 || keyCode == 54 || keyCode == 57) {
            this.key_right = true;
            this.key_right_down = true;
        }
        if (keyCode == 20 || keyCode == 21) {
            this.key_menu_left = true;
        }
        if (keyCode == 22) {
            this.key_menu_right = true;
        }
        if (keyCode == 50 || keyCode == 53 || keyCode == 56 || keyCode == 20 || keyCode == 21) {
            this.key_numeric_5 = true;
        }
    }

    public void keyReleased(int keyCode) {
        if (keyCode == 49 || keyCode == 50 || keyCode == 51) {
            this.key_up = false;
        }
        if (keyCode == 1) {
            this.key_fire = false;
            this.key_fire_down = false;
        }
        if (keyCode == 50 || keyCode == 53 || keyCode == 56) {
            this.key_fire = false;
        }
        if (keyCode == 6) {
            this.key_down = false;
        }
        if (keyCode == 2 || keyCode == 49 || keyCode == 52 || keyCode == 55) {
            this.key_left = false;
        }
        if (keyCode == 5 || keyCode == 51 || keyCode == 54 || keyCode == 57) {
            this.key_right = false;
        }
        if (keyCode == 20 || keyCode == 21) {
            this.key_menu_left = false;
        }
        if (keyCode == 22) {
            this.key_menu_right = false;
        }
        if (keyCode == 50 || keyCode == 53 || keyCode == 56 || keyCode == 20 || keyCode == 21) {
            this.key_numeric_5 = false;
        }
    }

    public void run() {
        boolean stopGame = false;
        while (!stopGame) {
            if (this.menu == MENU_INTRO_LOGO) {
                if (this.frames == 0) {
                    this.prelude_x = -1504;
                    this.prelude_y = -1792;
                    this.prelude_dx = 64;
                    this.prelude_dy = 160;
                }
                this.repaint();
            }
            if (this.menu == MENU_INTRO_SPLASH || this.menu == MENU_INTRO_SPLASH_KEY_DOWN) {
                if (this.frames > 16 && this.menu == MENU_INTRO_SPLASH) {
                    this.menu = MENU_INTRO_SPLASH_KEY_DOWN;
                    this.logo1 = null;
                    this.logo2 = null;
                    this.intro = null;
                    System.gc();
                }
                if (this.menu == MENU_INTRO_SPLASH_KEY_DOWN && !this.key_numeric_5) {
                    this.menu_value = 0;
                    this.menu = MENU_MENU;
                }
                System.out.println("frames=".concat(String.valueOf(String.valueOf(this.frames))));
                if (this.menu == MENU_INTRO_SPLASH) {
                    this.repaint();
                }
            }
            if (this.menu == MENU_MENU_DIFFICULTY) {
                if (this.key_up) {
                    this.key_up = false;
                    this.ingame_start_level -= 10;
                }
                if (this.key_down) {
                    this.key_down = false;
                    this.ingame_start_level += 10;
                }
                if (this.ingame_start_level < 0) {
                    this.ingame_start_level = 20;
                }
                if (this.ingame_start_level > 20) {
                    this.ingame_start_level = 0;
                }
                if (this.key_numeric_5) {
                    this.menu = MENU_PLAY_START;
                    this.ingame_lives = 4;
                    this.ingame_level = this.ingame_start_level;
                    this.ingame_score = 0;
                    this.key_numeric_5 = false;
                    this.key_fire = false;
                    this.background = null;
                    System.gc();
                } else {
                    this.repaint();
                }
                this.sleep(30);
            }
            if (this.menu == MENU_MENU) {
                if (this.key_numeric_5 && this.menu_value == 0) {
                    this.ingame_start_level = 0;
                    this.key_numeric_5 = false;
                    this.key_up = false;
                    this.key_down = false;
                    this.menu = MENU_MENU_DIFFICULTY;
                }
                if (this.key_numeric_5 && this.menu_value == 1) {
                    this.key_numeric_5 = false;
                    this.menu = MENU_HELP;
                }
                if (this.key_numeric_5 && this.menu_value == 2) {
                    this.stopGame();
                    this.hiscoremenu = new hiscoreMenu(SHOW_NOF_HISCORES, -1, 176, 208);
                    this.key_fire_down = false;
                    this.key_menu_left = false;
                    this.menu = MENU_HISCORE;
                }
                if (this.key_numeric_5 && this.menu_value == 3) {
                    this.key_numeric_5 = false;
                    this.menu = MENU_CREDITS;
                }
                if (this.key_numeric_5 && this.menu_value == 4) {
                    stopGame = true;
                }
                if (this.key_down) {
                    this.key_down = false;
                    if (++this.menu_value == 5) {
                        this.menu_value = 0;
                    }
                }
                if (this.key_fire) {
                    this.key_fire = false;
                    if (--this.menu_value == -1) {
                        this.menu_value = 4;
                    }
                }
                if (this.menu == MENU_MENU) {
                    this.repaint();
                }
            }
            if (this.menu == MENU_LOST_A_LIFE) {
                if (--this.ingame_lives > 0) {
                    this.frames = 0;
                    this.menu = MENU_LOST_A_LIFE_ANIM;
                } else {
                    this.frames = 0;
                    this.key_numeric_5 = false;
                    this.key_fire = false;
                    this.key_up = false;
                    this.menu = MENU_YOU_DIED_ANIM;
                }
            }
            if (this.menu == MENU_YOU_DIED_ANIM) {
                this.repaint();
            }
            if (this.menu == MENU_STAGE_CLEAR_ANIM) {
                this.repaint();
            }
            if (this.menu == MENU_HELP || this.menu == MENU_CREDITS) {
                this.repaint();
                if (this.key_numeric_5) {
                    this.key_numeric_5 = false;
                    this.iHelp1 = null;
                    this.iHelp2 = null;
                    this.iHelp3 = null;
                    System.gc();
                    this.menu = MENU_MENU;
                }
            }
            if (this.menu == MENU_STAGE_CLEAR) {
                this.frames = 0;
                this.repaint();
                this.menu = MENU_STAGE_CLEAR_ANIM;
            }
            if (this.menu == MENU_HISCORE) {
                if (this.hiscoremenu.run(this.key_left_down, this.key_right_down, this.key_fire_down, this.key_menu_left, this.key_menu_right, this.key_menu_left, this.key_menu_right)) {
                    this.hiscoremenu = null;
                    this.menu = MENU_MENU;
                    this.key_menu_left = false;
                    this.key_menu_right = false;
                    this.key_numeric_5 = false;
                    this.key_fire = false;
                    this.menu_value = 0;
                } else {
                    this.repaint();
                }
                this.key_left_down = false;
                this.key_right_down = false;
                this.key_fire_down = false;
                this.key_numeric_5 = false;
                this.key_menu_left = false;
                this.key_menu_right = false;
                this.sleep(30);
            }
            if (this.menu == MENU_LOST_A_LIFE_ANIM) {
                this.repaint();
            }
            if (this.menu == MENU_PLAY_START) {
                this.intro = null;
                this.menuBackground = null;
                this.menuForeground = null;
                this.logo1 = null;
                this.logo2 = null;
                this.playerAnim = null;
                System.gc();
                this.startGame();
                this.menu = MENU_PLAY;
            }
            if (this.menu != MENU_PLAY) continue;
            boolean cont = true;
            while (cont) {
                if (this.key_left) {
                    if (this.key_left_time != 0 && this.key_left_time <= 3) {
                        if (this.key_left_time > 15) {
                            // empty if block
                        }
                    } else if (--this.ingame_cursorpos < 0) {
                        this.ingame_cursorpos = 0;
                    }
                    ++this.key_left_time;
                } else {
                    this.key_left_time = 0;
                }
                if (this.key_right) {
                    if ((this.key_right_time == 0 || this.key_right_time > 3 && (this.key_left_time & 2) == 0) && ++this.ingame_cursorpos >= NOFCURSORPOS) {
                        this.ingame_cursorpos = NOFCURSORPOS - 1;
                    }
                    ++this.key_right_time;
                } else {
                    this.key_right_time = 0;
                }
                if (this.key_fire && !this.ingame_ball_rolling && !this.ingame_level_completed) {
                    this.ingame_ball_rolling = true;
                    this.player_anim = 4;
                    this.ingame_ball_fix_dx = this.circleX[this.ingame_cursorpos] * 200 >> 4;
                    this.ingame_ball_fix_dy = -((this.circleY[this.ingame_cursorpos] - NEWBALLDELTAY) * 100) >> 4;
                }
                this.checkBallStops();
                this.ingame_fix_x += this.ingame_ball_fix_dx;
                this.ingame_fix_y += this.ingame_ball_fix_dy;
                if (this.ingame_fix_x >> 5 > 135) {
                    this.ingame_fix_x = 270 - (this.ingame_fix_x >> 5) << 5;
                    this.ingame_ball_fix_dx = -this.ingame_ball_fix_dx;
                    this.checkBallStops();
                }
                if (this.ingame_fix_x >> 5 < 9) {
                    this.ingame_fix_x = 576 - this.ingame_fix_x;
                    this.ingame_ball_fix_dx = -this.ingame_ball_fix_dx;
                    this.checkBallStops();
                }
                if (++this.ingame_time == 800 - this.ingame_level * 8) {
                    this.ingame_time = 0;
                    if (!this.ingame_level_completed) {
                        ++this.ingame_concrete_level;
                    }
                    if (!this.ingame_ball_rolling) {
                        this.ingame_fix_y -= 512;
                    }
                }
                if ((this.ingame_time & 3) == 0) {
                    this.countBalls();
                    if (this.ingame_level_completed && this.nofFallingBalls == 0 && this.menu != MENU_STAGE_CLEAR) {
                        this.menu = MENU_STAGE_CLEAR;
                        this.frames = 0;
                    }
                }
                try {
                    Thread.sleep(30L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.repaint();
                if (this.win()) {
                    // empty if block
                }
                if (this.loose()) {
                    this.menu = MENU_LOST_A_LIFE;
                    cont = false;
                }
                this.ingame_score += this.ingame_combo * 5;
                int p = this.ingame_combo / 5;
                if (p > 0) {
                    this.ingame_score += this.ingame_combo * 5 * p;
                    this.addCombo(p);
                    if (p > 5) {
                        p = 5;
                    }
                }
                this.ingame_combo = 0;
                if (!this.key_menu_right) continue;
                this.key_menu_right = false;
                this.menu = MENU_PAUSE;
                while (this.menu == MENU_PAUSE) {
                    this.sleep(30);
                    if (this.key_menu_right) {
                        this.key_menu_right = false;
                        this.menu = MENU_PLAY;
                        this.menuBackground = null;
                        System.gc();
                        continue;
                    }
                    if (this.key_menu_left) {
                        this.key_menu_left = false;
                        this.stopGame();
                        this.menu = MENU_INTRO_SPLASH;
                        this.menu_value = 1;
                        cont = false;
                        continue;
                    }
                    this.repaint();
                }
            }
        }
        this.midlet.quit();
    }

    public void drawBall(int x, int y, int ball) {
        this.glob_g.setClip(x, y, 16, 16);
        if (ball < 7) {
            if (this.ballon[ball] != null) {
                this.glob_g.drawImage(this.ballon[ball], x, y, 0);
            }
        } else if (ball == 7) {
            int d = this.ingame_time / (9 + ball - 7) & 3;
            if (d == 3) {
                d = 1;
            }
            if (this.ballon[ball] != null) {
                this.glob_g.drawImage(this.ballon[ball], x - d * 16, y, 0);
            }
            this.glob_g.setClip(0, 0, 176, 208);
        } else {
            int d = this.ingame_time / (9 + ball - 7) % 5;
            if (d < 0) {
                d = -d;
            }
            if (this.ballon[ball] != null) {
                this.glob_g.drawImage(this.ballon[ball], x - d * 16, y, 0);
            }
            this.glob_g.setClip(0, 0, 176, 208);
        }
    }

    public void drawPlayGround(Graphics g) {
        int h = this.ingame_concrete_level * 13 / 32 + 1;
        int yh = this.ingame_concrete_level * 13 - 32;
        if (this.backgroundpeople != null) {
            for (int i = 0; i <= h; ++i) {
                g.drawImage(this.backgroundpeople, 16, yh, 0);
                yh -= 32;
            }
        }
        if (this.background != null) {
            g.drawImage(this.background, 16, this.ingame_concrete_level * 13, 0);
        }
        if (this.backgroundleft != null) {
            g.drawImage(this.backgroundleft, 0, 0, 0);
        }
        if (this.backgroundright != null) {
            g.drawImage(this.backgroundright, 160, 0, 0);
        }
        if (this.halfCircle != null) {
            g.drawImage(this.halfCircle, 88 - HALFCIRCLERADIUS, 208 - this.halfCircle.getHeight() + 12 - 26, 0);
        }
        int delta = 0;
        this.b = 0;
        while (this.b < 13) {
            this.a = 0;
            while (this.a < 9) {
                if (this.getBallCase(this.a, this.b) > 0) {
                    this.drawBall(delta + 16 + this.a * 16, 16 + (this.ingame_concrete_level + this.b) * 13, this.getBallCase(this.a, this.b) - 1);
                }
                ++this.a;
            }
            delta = 8 - delta;
            ++this.b;
        }
    }

    public void paint(Graphics g) {
        block75: {
            int n;
            int dx;
            boolean px;
            int n2;
            int x;
            int i;
            int y;
            ++this.frames;
            if (this.menu == MENU_PLAY) {
                int n3;
                this.glob_g = g;
                this.drawPlayGround(g);
                this.drawBall((this.ingame_fix_x >> 5) - 8 + 16, (this.ingame_fix_y >> 5) - 8 + 16 + this.ingame_concrete_level * 16, this.ingame_ball);
                g.setClip(0, 0, 176, 208);
                if (this.cursor != null) {
                    g.drawImage(this.cursor, 88 + this.circleX[this.ingame_cursorpos] - 3, 208 - this.circleY[this.ingame_cursorpos] - 28, 0);
                }
                y = this.nextBall.getHeight();
                g.setClip(0, 0, 176, 208);
                if (this.nextBall != null) {
                    g.drawImage(this.nextBall, 0, this.getHeight() + 4, 36);
                }
                this.drawBall(26, 187, this.ingame_next_ball);
                g.setClip(0, 0, 176, 208);
                if (this.life != null) {
                    for (int l = 0; l < this.ingame_lives - 1; ++l) {
                        g.drawImage(this.life, 117 + l * 17, 189, 0);
                    }
                }
                int s = this.ingame_score;
                int sl = 0;
                while (s > 0) {
                    s /= 10;
                    ++sl;
                }
                s = this.ingame_score;
                if (sl == 0) {
                    sl = 1;
                }
                int sx = 90;
                int sy = 194;
                for (i = 0; i < sl; ++i) {
                    n3 = s % 10;
                    s /= 10;
                    g.setClip(sx, sy, 6, 9);
                    g.drawImage(this.score, sx - 6 * n3, sy, 0);
                    sx -= 7;
                }
                if (this.player_anim > 0 && ++this.player_anim >= 20) {
                    this.player_anim = 0;
                }
                int pl = this.player_anim / 4;
                x = this.player.getWidth();
                y = this.player.getHeight();
                n3 = x / 5;
                g.setClip(96, 208 - y - 26, n3, y);
                if (this.player != null) {
                    g.drawImage(this.player, 96 - pl * n3, 208 - y - 26, 0);
                }
                this.animate(g);
                g.setClip(0, 0, 176, 208);
            }
            if (this.menu == MENU_HELP) {
                if (this.menuBackground == null) {
                    this.menuBackground = this.reLoadImage("/gfx/menuscreen_bg.png");
                }
                if (this.menuBackground != null) {
                    g.drawImage(this.menuBackground, 0, 0, 0);
                }
                if (this.iHelp1 == null) {
                    this.iHelp1 = this.reLoadImage("/gfx/ballon7.png");
                }
                if (this.iHelp2 == null) {
                    this.iHelp2 = this.reLoadImage("/gfx/bonus_color.png");
                }
                if (this.iHelp3 == null) {
                    this.iHelp3 = this.reLoadImage("/gfx/bonus_spark_01.png");
                }
                n2 = 0;
                this.myfont.print(g, n2 + 0, 8, "      HELP");
                this.myfont.print(g, n2 + 10, 22, "Shoot the balls");
                this.myfont.print(g, n2 + 10, 34, "on balls of same");
                this.myfont.print(g, n2 + 10, 46, "color to make");
                this.myfont.print(g, n2 + 10, 58, "them go away");
                this.myfont.print(g, n2 + 10, 70, "1 ball counts");
                this.myfont.print(g, n2 + 10, 82, "5 points");
                this.myfont.print(g, n2 + 10, 94, "      Combo");
                this.myfont.print(g, n2 + 10, 106, "  5 Balls  2x");
                this.myfont.print(g, n2 + 10, 118, " 10 Balls  3x");
                this.myfont.print(g, n2 + 10, 130, " 15 Balls  4x");
                this.myfont.print(g, n2 + 10, 142, " Bonus Balls");
                this.myfont.print(g, n2 + 10, 156, "    a Player");
                this.myfont.print(g, n2 + 10, 170, "   Colorchanger");
                this.myfont.print(g, n2 + 10, 184, "    Flash");
                g.setClip(0, 0, 176, 208);
                g.drawImage(this.iHelp1, 24, 153, 0);
                n2 = this.frames >> 1 & 3;
                if (n2 == 3) {
                    n2 = 1;
                }
                g.setClip(14, 167, 16, 16);
                g.drawImage(this.iHelp2, 14 - n2 * 16, 167, 0);
                n2 = (this.frames >> 1) % 5;
                if (n2 < 0) {
                    n2 = -n2;
                }
                g.setClip(24, 181, 16, 16);
                g.drawImage(this.iHelp3, 24 - n2 * 16, 181, 0);
                this.myfont.print(g, 2, 191, "OK");
            }
            if (this.menu == MENU_CREDITS) {
                if (this.menuBackground == null) {
                    this.menuBackground = this.reLoadImage("/gfx/menuscreen_bg.png");
                }
                if (this.menuBackground != null) {
                    g.drawImage(this.menuBackground, 0, 0, 0);
                }
                n2 = 12;
                this.myfont.print(g, n2, 10, "    Credits");
                this.myfont.print(g, n2, 30, "Lead developper");
                this.myfont.print(g, n2, 44, "Ludvig Larsson");
                this.myfont.print(g, n2, 65, "Lead designer");
                this.myfont.print(g, n2, 79, "Michael Garcini");
                this.myfont.print(g, n2, 140, " Bubble Soccer");
                this.myfont.print(g, n2 - 5, 152, "is the exclusive");
                this.myfont.print(g, n2, 164, "  property of");
                this.myfont.print(g, n2 - 5, 176, "Mediaplazza 2003");
                this.myfont.print(g, 2, 191, "OK");
            }
            if (this.menu == MENU_INTRO_LOGO) {
                int y2 = 60;
                if (this.logo1 == null) {
                    this.logo1 = this.reLoadImage("/gfx/logo_mediaplazza_01.png");
                }
                if (this.logo2 == null) {
                    this.logo2 = this.reLoadImage("/gfx/logo_mediaplazza_02.png");
                }
                this.prelude_x += this.prelude_dx;
                this.prelude_y += this.prelude_dy;
                if (this.frames > 50) {
                    this.frames = 0;
                    this.menu = MENU_INTRO_SPLASH;
                } else {
                    if (this.frames < 46) {
                        this.prelude_dy += 34;
                    } else {
                        this.prelude_dx = 0;
                        this.prelude_dy = 0;
                    }
                    if (this.prelude_y > y2 << 5) {
                        this.prelude_y = (y2 << 5) - (this.prelude_y - (y2 << 5));
                        this.prelude_dy = -(this.prelude_dy / 2);
                        if (this.frames > 45) {
                            this.prelude_dx = 0;
                            this.prelude_dy = 0;
                        }
                    }
                }
                g.setColor(255, 255, 255);
                g.fillRect(0, 0, 176, 208);
                g.drawImage(this.logo2, 28, 118, 0);
                g.drawImage(this.logo1, 60, this.prelude_y >> 5, 0);
            }
            if (this.menu == MENU_INTRO_SPLASH) {
                if (this.intro == null) {
                    this.intro = this.reLoadImage("/gfx/introscreen.png");
                }
                g.setClip(0, 0, 176, 208);
                g.drawImage(this.intro, 0, 0, 0);
            }
            if (this.menu == MENU_STAGE_CLEAR || this.menu == MENU_STAGE_CLEAR_ANIM) {
                if (this.playerAnim == null) {
                    this.playerAnim = this.reLoadImage("/gfx/player_run.png");
                }
                if (this.iTemp == null) {
                    this.iTemp = this.reLoadImage("/gfx/stage_clear_foule.png");
                }
                if (this.iTemp2 == null) {
                    this.iTemp2 = this.reLoadImage("/gfx/stage_clear_text.png");
                }
                g.setClip(0, 0, 176, 208);
                for (i = 0; i < this.ingame_concrete_level; ++i) {
                    g.drawImage(this.backgroundpeople, 16, i * 16, 0);
                }
                g.drawImage(this.background, 16, this.ingame_concrete_level * 16, 0);
                g.drawImage(this.backgroundleft, 0, 0, 0);
                g.drawImage(this.backgroundright, 160, 0, 0);
                for (i = -1; i < 176 / this.iTemp.getWidth() + 1; ++i) {
                    g.drawImage(this.iTemp, i * this.iTemp.getWidth() + this.frames % this.iTemp.getWidth(), 208 - this.iTemp.getHeight(), 0);
                }
                g.drawImage(this.iTemp2, this.frames - this.iTemp2.getWidth(), 208 - this.iTemp2.getHeight(), 0);
                px = false;
                x = 136;
                y = 208 - this.playerAnim.getHeight() / 2;
                int n4 = this.frames & 7;
                int dy = (n4 >> 2) * 42;
                dx = (n4 & 3) * 34;
                g.setClip(x, y, 34, 42);
                g.drawImage(this.playerAnim, x - dx, y - dy, 0);
                if (this.frames > (88 + this.iTemp.getWidth() * 3) / 2 || this.key_numeric_5) {
                    this.getNextLevel();
                    this.playerAnim = null;
                    this.iTemp = null;
                    this.iTemp2 = null;
                    System.gc();
                    this.menu = MENU_PLAY;
                    this.key_numeric_5 = false;
                    this.key_fire = false;
                }
            }
            if (this.menu == MENU_LOST_A_LIFE_ANIM) {
                if (this.playerAnim == null) {
                    this.playerAnim = this.reLoadImage("/gfx/player_cry.png");
                }
                if (this.iTemp == null) {
                    this.iTemp = this.reLoadImage("/gfx/stage_clear_foule.png");
                }
                if (this.iTemp2 == null) {
                    this.iTemp2 = this.reLoadImage("/gfx/gameover.png");
                }
                if (this.nextBall == null) {
                    this.nextBall = this.reLoadImage("/gfx/interface_next.png");
                }
                if (this.life == null) {
                    this.life = this.reLoadImage("/gfx/lives.png");
                }
                g.setClip(0, 0, 176, 208);
                this.drawPlayGround(g);
                g.setClip(0, 0, 176, 208);
                g.drawImage(this.nextBall, 0, 186, 0);
                if (this.life != null) {
                    for (int l = 0; l < this.ingame_lives - 1; ++l) {
                        g.drawImage(this.life, 117 + l * 17, 189, 0);
                    }
                }
                px = false;
                x = 98;
                y = 208 - this.playerAnim.getHeight() - 25;
                n = this.frames / 2 % 3;
                dx = n * 38;
                g.setClip(x, y, 38, 37);
                g.drawImage(this.playerAnim, x - dx, y, 0);
                if (this.frames > 26) {
                    this.playerAnim = null;
                    this.iTemp = null;
                    this.iTemp2 = null;
                    this.nextBall = null;
                    System.gc();
                    --this.ingame_level;
                    this.getNextLevel();
                    this.menu = MENU_PLAY_START;
                    this.key_numeric_5 = false;
                }
            }
            if (this.menu == MENU_YOU_DIED_ANIM) {
                if (this.playerAnim == null) {
                    this.playerAnim = this.reLoadImage("/gfx/player_cry.png");
                }
                if (this.iTemp == null) {
                    this.iTemp = this.reLoadImage("/gfx/stage_clear_foule.png");
                }
                if (this.iTemp2 == null) {
                    this.iTemp2 = this.reLoadImage("/gfx/gameover.png");
                }
                g.setClip(0, 0, 176, 208);
                this.drawPlayGround(g);
                g.setClip(0, 0, 176, 208);
                for (i = -1; i < 176 / this.iTemp.getWidth() + 1; ++i) {
                    g.drawImage(this.iTemp, i * this.iTemp.getWidth(), 208 - this.iTemp.getHeight(), 0);
                }
                g.drawImage(this.iTemp2, 104 - this.iTemp2.getWidth() / 2 - 20, 208 - this.iTemp2.getHeight(), 0);
                px = false;
                x = 146;
                y = 208 - this.playerAnim.getHeight();
                n = this.frames / 2 % 3;
                dx = n * 38;
                g.setClip(x - 10, y, 38, 37);
                g.drawImage(this.playerAnim, x - dx - 10, y, 0);
                if (this.frames > 34 || this.key_numeric_5) {
                    this.key_numeric_5 = false;
                    this.playerAnim = null;
                    this.iTemp = null;
                    this.iTemp2 = null;
                    System.gc();
                    this.stopGame();
                    this.hiscoremenu = new hiscoreMenu(SHOW_NOF_HISCORES, this.ingame_score, 176, 208);
                    this.key_fire_down = false;
                    this.menu = MENU_HISCORE;
                    this.key_numeric_5 = false;
                }
            }
            if (this.menu == MENU_HISCORE && this.hiscoremenu != null) {
                this.hiscoremenu.paint(g);
            }
            if (this.menu == MENU_PAUSE) {
                if (this.menuBackground == null) {
                    this.menuBackground = this.reLoadImage("/gfx/menuscreen_bg.png");
                }
                g.drawImage(this.menuBackground, 0, 0, 0);
                this.myfont.print(g, 53, 84, "Game in");
                this.myfont.print(g, 53, 99, " Pause");
                this.myfont.print(g, 49, 114, "  Mode");
                this.myfont.print(g, 2, 191, "MENU");
                this.myfont.print(g, 134, 191, "BACK");
            }
            if (this.menu == MENU_MENU_DIFFICULTY) {
                if (this.menuBackground == null) {
                    this.menuBackground = this.reLoadImage("/gfx/menuscreen_bg.png");
                }
                if (this.iTemp3 == null) {
                    this.iTemp3 = this.reLoadImage("/gfx/menuscreen_text_02.png");
                }
                if (this.arrow == null) {
                    this.arrow = this.reLoadImage("/gfx/menuscreen_arrow.png");
                }
                g.drawImage(this.menuBackground, 0, 0, 0);
                g.drawImage(this.iTemp3, (176 - this.iTemp3.getWidth()) / 2, (208 - this.iTemp3.getHeight()) / 2, 0);
                int xs = this.arrow.getWidth() / 6;
                int ys = this.arrow.getHeight();
                x = 0;
                y = (208 + this.iTemp3.getHeight()) / 2;
                y = -10;
                if (this.ingame_start_level == 0) {
                    x = 45;
                    y += 78;
                }
                if (this.ingame_start_level == 10) {
                    x = 60;
                    y += 104;
                }
                if (this.ingame_start_level == 20) {
                    x = 49;
                    y += 130;
                }
                g.setClip(88 + x - 13, y, xs, ys);
                g.drawImage(this.arrow, 88 + x - 13 - (this.frames >> 1) % 3 * xs, y, 0);
                g.setClip(88 - x - 13, y, xs, ys);
                g.drawImage(this.arrow, 88 - x - 13 - (3 + (this.frames >> 1) % 3) * xs, y, 0);
                this.myfont.print(g, 2, 191, "OK");
            }
            if (this.menu != MENU_MENU) break block75;
            if (this.playerAnim == null) {
                this.playerAnim = this.reLoadImage("/gfx/player_run.png");
            }
            if (this.menuForeground == null) {
                this.menuForeground = this.reLoadImage("/gfx/menuscreen_text.png");
            }
            if (this.menuBackground == null) {
                this.menuBackground = this.reLoadImage("/gfx/menuscreen_bg.png");
            }
            if (this.logo == null) {
                this.logo = this.reLoadImage("/gfx/menuscreen_logo.png");
            }
            g.setClip(0, 0, 176, 208);
            g.drawImage(this.menuBackground, 0, 0, 0);
            ++this.prelude_x;
            int px2 = 0;
            int x2 = 124;
            int y3 = 8;
            n = this.prelude_x & 7;
            int dy = (n >> 2) * 42;
            int dx2 = (n & 3) * 34;
            g.setClip(x2, y3, 34, 42);
            g.drawImage(this.playerAnim, x2 - dx2, y3 - dy, 0);
            g.setClip(0, 0, 176, 208);
            g.drawImage(this.menuForeground, 41, 61, 0);
            g.drawImage(this.logo, 2, 2, 0);
            this.myfont.print(g, 2, 191, "OK");
            if (this.menu_value == 0) {
                px2 = 40;
            }
            if (this.menu_value == 1) {
                px2 = 40;
            }
            if (this.menu_value == 2) {
                px2 = 63;
            }
            if (this.menu_value == 3) {
                px2 = 55;
            }
            if (this.menu_value == 4) {
                px2 = 42;
            }
            x2 = 88 - px2 - 12;
            y3 = 60 + this.menu_value * 25;
            n = this.prelude_x & 3;
            if (n == 3) {
                n = 1;
            }
            g.setClip(x2, y3, 25, 18);
            g.drawImage(this.arrow, x2 - 75 - n * 25, y3, 0);
            if (this.menu_value < 2) {
                px2 -= 2;
            }
            x2 = 88 + px2 - 12;
            g.setClip(x2, y3, 25, 18);
            g.drawImage(this.arrow, x2 - n * 25, y3, 0);
            g.setClip(0, 0, 176, 208);
        }
    }

    public void loadLevel(int nr) {
        int a;
        int b;
        System.out.print("Chargement Level(0..):".concat(String.valueOf(String.valueOf(nr %= 50))));
        for (b = 0; b < 13; ++b) {
            for (a = 0; a < 9; ++a) {
                this.setBallCase(a, b, 0);
            }
        }
        for (a = 0; a < 9; ++a) {
            this.ingame_ball_on[a] = false;
        }
        a = 0;
        b = 0;
        int maxlevel = nr / 5;
        System.out.print(String.valueOf(String.valueOf(new StringBuffer(" levelmax").append(maxlevel + 1).append(".txt"))));
        System.out.println(String.valueOf(String.valueOf(new StringBuffer(" Inner level:").append(nr %= 5).append(" (0-4)"))));
        byte[] bb = new byte[1];
        InputStream is = this.getClass().getResourceAsStream(String.valueOf(String.valueOf(new StringBuffer("/level/levelmax").append(maxlevel + 1).append(".txt"))));
        try {
            boolean done = false;
            if (nr == 0) {
                done = true;
            }
            while (!done) {
                is.read(bb);
                if (bb[0] != 88 || --nr != 0) continue;
                done = true;
            }
            StringBuffer str = new StringBuffer();
            is.read(bb);
            while (bb[0] != -1 && bb[0] != 88) {
                if (bb[0] != 13 && bb[0] != 10) {
                    byte bc = (byte)(bb[0] - 48);
                    this.setBallCase(a++, b, bc);
                    if (b / 2 * 2 == b && a == 9) {
                        a = 0;
                        ++b;
                    } else if (b / 2 * 2 != b && a == 8) {
                        a = 0;
                        ++b;
                    }
                }
                is.read(bb);
            }
        }
        catch (IOException e) {
            System.out.println("ERROR: chargement Level");
        }
        this.ingame_level_completed = false;
        this.ingame_concrete_level = 0;
        this.ingame_time = 0;
        this.countBalls();
    }

    public void startGame() {
        this.i = 0;
        while (this.i < 7) {
            this.ballon[this.i] = this.reLoadImage(String.valueOf(String.valueOf(new StringBuffer("/gfx/ballon").append(this.i + 1).append(".png"))));
            ++this.i;
        }
        this.ballon[7] = this.reLoadImage("/gfx/bonus_color.png");
        this.ballon[8] = this.reLoadImage("/gfx/bonus_spark_01.png");
        this.spark = this.reLoadImage("/gfx/bonus_spark_02.png");
        this.life = this.reLoadImage("/gfx/lives.png");
        if (this.background == null) {
            this.background = this.reLoadImage("/gfx/bg_A_02.png");
        }
        this.backgroundleft = this.reLoadImage("/gfx/bg_A_01.png");
        this.backgroundright = this.reLoadImage("/gfx/bg_A_03.png");
        this.backgroundpeople = this.reLoadImage("/gfx/bg_A_04.png");
        this.halfCircle = this.reLoadImage("/gfx/interface_cercle.png");
        this.nextBall = this.reLoadImage("/gfx/interface_next.png");
        this.cursor = this.reLoadImage("/gfx/interface_viseur.png");
        this.player = this.reLoadImage("/gfx/player.png");
        this.explosion = this.reLoadImage("/gfx/explode.png");
        this.score = this.reLoadImage("/gfx/interface_score.png");
        System.gc();
        this.ingame_ball_rolling = false;
        this.ingame_cursorpos = NOFCURSORPOS / 2 - 2;
        this.ingame_concrete_level = 0;
        this.loadLevel(this.ingame_level);
        this.ingame_combo = 0;
        this.newBall();
        this.newBall();
        this.resetAnimations();
        this.player_anim = 0;
        this.ingame_time = 0;
    }

    public void stopGame() {
        for (int i = 0; i < 9; ++i) {
            this.ballon[i] = null;
        }
        this.spark = null;
        this.life = null;
        this.background = null;
        this.backgroundleft = null;
        this.backgroundright = null;
        this.backgroundpeople = null;
        this.halfCircle = null;
        this.nextBall = null;
        this.cursor = null;
        this.player = null;
        this.explosion = null;
        this.score = null;
        System.gc();
    }

    public void getNextLevel() {
        ++this.ingame_level;
        this.loadLevel(this.ingame_level);
        this.ingame_combo = 0;
        this.background = null;
        System.gc();
        this.background = this.reLoadImage(String.valueOf(String.valueOf(new StringBuffer("/gfx/bg_").append((char)(65 + this.ingame_level % 4)).append("_02.png"))));
        this.newBall();
        this.newBall();
        this.player_anim = 0;
        this.resetAnimations();
    }

    public int xpixel(int x, int y) {
        int r = 8 + x * 16;
        if ((y & 1) == 1) {
            r += 8;
        }
        return r;
    }

    public int ypixel(int x, int y) {
        return 8 + y * 13;
    }

    public int xcase(int xpix, int ypix) {
        int x = xpix + MAGICX;
        int y = ypix + MAGICY;
        x = ((y /= 13) & 1) == 1 ? (x - 8) / 16 : (x /= 16);
        return x;
    }

    public int ycase(int xpix, int ypix) {
        boolean d = false;
        int x = xpix + MAGICX;
        int y = ypix + MAGICY;
        return y /= 13;
    }

    public void setBallCase(int cx, int cy, int newball) {
        int d = cy & 1;
        if (cx >= 0 && cx < 9 - d && cy < 13 && cy >= 0) {
            if (newball == 0 && this.playground[cx][cy] > 0) {
                ++this.ingame_combo;
            }
            this.playground[cx][cy] = (byte)newball;
        }
    }

    public byte getBallCase(int cx, int cy) {
        int d = cy & 1;
        if (cx >= 0 && cx < 9 - d && cy < 13 && cy >= 0) {
            return this.playground[cx][cy];
        }
        return 0;
    }

    public boolean inBallCase(int cx, int cy) {
        int d = cy & 1;
        return cx >= 0 && cx < 9 - d && cy < 13 && cy >= 0;
    }

    public boolean dist(int x1, int y1, int x2, int y2) {
        return (x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2) < 256;
    }

    public void doBonusBallColorChanger(int cx, int cy) {
        byte color = this.getBallCase(cx, cy);
        this.addExplosion(this.xpixel(cx, cy), this.ypixel(cx, cy));
        if (color == 7) {
            return;
        }
        if (color == 0) {
            return;
        }
        for (int b = 0; b < 13; ++b) {
            for (int a = 0; a < 9; ++a) {
                if (this.getBallCase(a, b) != color) continue;
                this.setBallCase(a, b, 0);
                this.addExplosion(this.xpixel(a, b), this.ypixel(a, b));
            }
        }
        this.ballsFall();
    }

    public void doBonusBallFlash(int cx, int cy) {
        this.addFlash(cx, cy, -1);
        this.addFlash(cx, cy, 1);
    }

    public void doNeighbourBall(int cx, int cy, int mycx, int mycy) {
        int b = this.getBallCase(cx, cy) - 1;
        if (b < 7) {
            return;
        }
        if (b == 7) {
            this.doBonusBallColorChanger(mycx, mycy);
            this.setBallCase(cx, cy, 0);
            this.addExplosion(this.xpixel(cx, cy), this.ypixel(cx, cy));
        }
        if (b == 8) {
            this.doBonusBallFlash(cx, cy - 1);
        }
    }

    public boolean checkBall(int cx, int cy, int x, int y) {
        if (this.getBallCase(cx, cy) > 0 && this.dist(this.xpixel(cx, cy), this.ypixel(cx, cy), x, y)) {
            if (this.ingame_ball < 7) {
                this.setBallCase(this.xcase(x, y), this.ycase(x, y), this.ingame_ball + 1);
                this.eatBalls(this.xcase(x, y), this.ycase(x, y), (byte)(this.ingame_ball + 1));
            } else {
                if (this.ingame_ball == 7) {
                    this.doBonusBallColorChanger(cx, cy);
                }
                if (this.ingame_ball == 8) {
                    this.doBonusBallFlash(cx, cy);
                }
            }
            this.newBall();
            return true;
        }
        return false;
    }

    public void checkBallStops() {
        int x = this.ingame_fix_x >> 5;
        int y = this.ingame_fix_y >> 5;
        int cx = this.xcase(x, y);
        int cy = this.ycase(x, y);
        int d = cy & 1;
        if (y <= 8) {
            if (this.ingame_ball < 7) {
                this.setBallCase(this.xcase(x, 0), this.ycase(x, 0), this.ingame_ball + 1);
                this.eatBalls(this.xcase(x, y), this.ycase(x, y), (byte)(this.ingame_ball + 1));
            } else {
                if (this.ingame_ball == 7) {
                    this.doBonusBallColorChanger(cx, cy);
                }
                if (this.ingame_ball == 8) {
                    this.doBonusBallFlash(cx, -1);
                }
            }
            this.newBall();
        } else if (!(this.checkBall(cx - 1, cy - 1, x, y) || this.checkBall(cx, cy - 1, x, y) || this.checkBall(cx + 1, cy - 1, x, y) || this.checkBall(cx - 1, cy, x, y) || this.checkBall(cx + 1, cy, x, y) || this.checkBall(cx - 1, cy + 1, x, y) || this.checkBall(cx, cy + 1, x, y) || this.checkBall(cx + 1, cy + 1, x, y))) {
            return;
        }
        d = (cy & 1) * 2 - 1;
        this.doNeighbourBall(cx + 1, cy, cx, cy);
        this.doNeighbourBall(cx - 1, cy, cx, cy);
        this.doNeighbourBall(cx, cy + 1, cx, cy);
        this.doNeighbourBall(cx, cy - 1, cx, cy);
        this.doNeighbourBall(cx + d, cy - 1, cx, cy);
        this.doNeighbourBall(cx + d, cy + 1, cx, cy);
    }

    public boolean loose() {
        for (int a = 0; a < 9; ++a) {
            if (this.getBallCase(a, 11 - this.ingame_concrete_level) <= 0) continue;
            return true;
        }
        return false;
    }

    public boolean win() {
        return false;
    }

    public void newBall() {
        int n = 200;
        this.ingame_ball_rolling = false;
        boolean done = false;
        this.ingame_ball = this.ingame_next_ball;
        while (!done) {
            this.ingame_next_ball = Math.abs(this.random.nextInt() % 9);
            done = this.ingame_ball_on[this.ingame_next_ball];
            if (--n != 0) continue;
            this.ingame_next_ball = 0;
            if (this.ingame_ball_on[1]) {
                this.ingame_next_ball = 1;
            }
            if (this.ingame_ball_on[2]) {
                this.ingame_next_ball = 2;
            }
            if (this.ingame_ball_on[3]) {
                this.ingame_next_ball = 3;
            }
            if (this.ingame_ball_on[4]) {
                this.ingame_next_ball = 4;
            }
            if (this.ingame_ball_on[5]) {
                this.ingame_next_ball = 5;
            }
            if (this.ingame_ball_on[6]) {
                this.ingame_next_ball = 6;
            }
            if (this.ingame_ball_on[7]) {
                this.ingame_next_ball = 7;
            }
            done = true;
        }
        this.ingame_fix_x = 2304;
        this.ingame_fix_y = 196 - this.halfCircle.getHeight() + NEWBALLDELTAY - 16 + HALFCIRCLERADIUS - this.ingame_concrete_level * 16 << 5;
        this.ingame_ball_fix_dx = 0;
        this.ingame_ball_fix_dy = 0;
    }

    public byte getCountCase(int cx, int cy) {
        int d = cy & 1;
        if (cx >= 0 && cx < 9 - d && cy < 13 && cy >= 0) {
            return this.countground[cx][cy];
        }
        return 1;
    }

    public void setCountCase(int cx, int cy) {
        int d = cy & 1;
        if (cx >= 0 && cx < 9 - d && cy < 13 && cy >= 0) {
            this.countground[cx][cy] = 1;
        }
    }

    public void reSetCountCase(int cx, int cy) {
        if (cx >= 0 && cx < 9 && cy < 13 && cy >= 0) {
            this.countground[cx][cy] = 0;
        }
    }

    public int countBallsRec(int cx, int cy) {
        int r = 0;
        byte c = this.getCountCase(cx, cy);
        if (this.getBallCase(cx, cy) == this.r_ball && c == 0) {
            ++r;
        } else {
            return r;
        }
        this.setCountCase(cx, cy);
        this.b_check_out = true;
        r += this.countBallsRec(cx - 1, cy);
        r += this.countBallsRec(cx + 1, cy);
        r += this.countBallsRec(cx, cy - 1);
        r += this.countBallsRec(cx, cy + 1);
        if ((cy & 1) == 1) {
            r += this.countBallsRec(cx + 1, cy - 1);
            r += this.countBallsRec(cx + 1, cy + 1);
        } else {
            r += this.countBallsRec(cx - 1, cy - 1);
            r += this.countBallsRec(cx - 1, cy + 1);
        }
        return r;
    }

    public void eatBalls(int cx, int cy, byte ball) {
        block5: {
            int x;
            int y;
            this.b_check_out = false;
            for (y = 0; y < 13; ++y) {
                for (x = 0; x < 9; ++x) {
                    this.reSetCountCase(x, y);
                }
            }
            this.r_ball = ball;
            if (this.countBallsRec(cx, cy) > 2) {
                for (y = 0; y < 13; ++y) {
                    for (x = 0; x < 9; ++x) {
                        if (this.getCountCase(x, y) == 0) continue;
                        this.setBallCase(x, y, 0);
                        if (x >= 9 - (y & 1)) continue;
                        this.addExplosion(this.xpixel(x, y), this.ypixel(x, y));
                    }
                }
            }
            this.ballsFall();
            if (!this.b_check_out) break block5;
            this.countBalls();
        }
    }

    void fallingBallsRec(int cx, int cy) {
        if (this.getCountCase(cx, cy) > 0) {
            return;
        }
        if (this.getBallCase(cx, cy) == 0) {
            return;
        }
        this.setCountCase(cx, cy);
        this.fallingBallsRec(cx - 1, cy);
        this.fallingBallsRec(cx + 1, cy);
        this.fallingBallsRec(cx, cy - 1);
        this.fallingBallsRec(cx, cy + 1);
        if ((cy & 1) == 1) {
            this.fallingBallsRec(cx + 1, cy - 1);
            this.fallingBallsRec(cx + 1, cy + 1);
        } else {
            this.fallingBallsRec(cx - 1, cy - 1);
            this.fallingBallsRec(cx - 1, cy + 1);
        }
    }

    public void ballsFall() {
        int x;
        int y;
        for (y = 0; y < 13; ++y) {
            for (x = 0; x < 9; ++x) {
                this.reSetCountCase(x, y);
            }
        }
        for (x = 0; x < 9; ++x) {
            if (this.getBallCase(x, 0) <= 0) continue;
            this.fallingBallsRec(x, 0);
        }
        for (y = 0; y < 13; ++y) {
            for (x = 0; x < 9; ++x) {
                if (this.getCountCase(x, y) != 0 || this.getBallCase(x, y) <= 0) continue;
                this.addFallingBall(x, y, this.getBallCase(x, y));
                this.setBallCase(x, y, 0);
            }
        }
    }

    public void countBalls() {
        int a;
        for (a = 0; a < 9; ++a) {
            this.ingame_ball_on[a] = false;
        }
        for (int y = 0; y < 13; ++y) {
            for (int x = 0; x < 9; ++x) {
                byte b = this.getBallCase(x, y);
                if (b <= 0 || b > 9) continue;
                this.ingame_ball_on[b - 1] = true;
            }
        }
        this.ingame_level_completed = true;
        for (a = 0; a < 9; ++a) {
            if (!this.ingame_ball_on[a]) continue;
            this.ingame_level_completed = false;
        }
        this.ingame_ball_on[6] = false;
    }

    public void addCombo(int niv) {
        int i;
        for (i = 0; i < MAXNOFFALLINGTHINGS && this.fallingBalls_what[i] > 0; ++i) {
        }
        if (i >= MAXNOFFALLINGTHINGS) {
            return;
        }
        if (this.fallingBalls_what[i] == 0) {
            this.fallingBalls_what[i] = 300 + niv;
            this.fallingBalls_x[i] = 53;
            this.fallingBalls_y[i] = -224;
            this.fallingBalls_dy[i] = 128;
            ++this.nofFallingBalls;
        }
    }

    public void addFlash(int x, int y, int xdir) {
        int i;
        for (i = 0; i < MAXNOFFALLINGTHINGS && this.fallingBalls_what[i] > 0; ++i) {
        }
        if (i >= MAXNOFFALLINGTHINGS) {
            return;
        }
        if (this.fallingBalls_what[i] == 0) {
            this.fallingBalls_what[i] = 200;
            this.fallingBalls_x[i] = this.xpixel(x, y) << 5;
            this.fallingBalls_y[i] = this.ypixel(x, y) + 14 << 5;
            this.fallingBalls_dx[i] = xdir * 5 << 5;
            ++this.nofFallingBalls;
        }
    }

    public void addExplosion(int x, int y) {
        int i;
        for (i = 0; i < MAXNOFFALLINGTHINGS && this.fallingBalls_what[i] > 0; ++i) {
        }
        if (i >= MAXNOFFALLINGTHINGS) {
            return;
        }
        if (this.fallingBalls_what[i] == 0) {
            this.fallingBalls_what[i] = 100;
            this.fallingBalls_x[i] = x;
            this.fallingBalls_y[i] = y - 3;
            ++this.nofFallingBalls;
        }
    }

    public void addFallingBall(int x, int y, int ball) {
        int i;
        for (i = 0; i < MAXNOFFALLINGTHINGS && this.fallingBalls_what[i] > 0; ++i) {
        }
        if (i >= MAXNOFFALLINGTHINGS) {
            return;
        }
        if (this.fallingBalls_what[i] == 0) {
            this.fallingBalls_what[i] = ball;
            this.fallingBalls_x[i] = this.xpixel(x, y) << 5;
            this.fallingBalls_y[i] = this.ypixel(x, y) << 5;
            this.fallingBalls_dy[i] = -32;
            this.fallingBalls_dx[i] = this.xpixel(x, y) > 88 ? 64 : -64;
            ++this.nofFallingBalls;
        }
    }

    public void animate(Graphics g) {
        int i = 0;
        int n = 0;
        int ccrt = this.ingame_concrete_level * 16;
        if (this.nofFallingBalls == 0) {
            return;
        }
        boolean done = false;
        boolean checkBallsFall = false;
        while (!done) {
            while (this.fallingBalls_what[i] == 0) {
                if (++i != MAXNOFFALLINGTHINGS) continue;
                i = 0;
            }
            if (this.fallingBalls_what[i] >= 300 && this.fallingBalls_what[i] < 340) {
                int p = this.fallingBalls_what[i] - 299;
                String s = "Combo ".concat(String.valueOf(String.valueOf(p)));
                int y = this.fallingBalls_y[i] >> 5;
                if (y < 65) {
                    y = 65;
                }
                this.myfont.print(g, this.fallingBalls_x[i], y, s);
                int n2 = i;
                this.fallingBalls_y[n2] = this.fallingBalls_y[n2] + this.fallingBalls_dy[i];
                int n3 = i;
                this.fallingBalls_dy[n3] = this.fallingBalls_dy[n3] + 1;
                if (this.fallingBalls_y[i] >> 5 > 208) {
                    this.fallingBalls_what[i] = 0;
                    --this.nofFallingBalls;
                }
            } else if (this.fallingBalls_what[i] >= 100 && this.fallingBalls_what[i] < 200) {
                g.setClip(this.fallingBalls_x[i], this.fallingBalls_y[i] + ccrt, EXPLOSIONPARTWIDTH, EXPLOSIONHEIGHT);
                g.drawImage(this.explosion, this.fallingBalls_x[i] - (this.fallingBalls_what[i] - 100) / 2 * EXPLOSIONPARTWIDTH, this.fallingBalls_y[i] + ccrt, 0);
                int n4 = i;
                this.fallingBalls_what[n4] = this.fallingBalls_what[n4] + 1;
                if (this.fallingBalls_what[n4] == 110) {
                    this.fallingBalls_what[i] = 0;
                    --this.nofFallingBalls;
                }
            } else if (this.fallingBalls_what[i] < 100) {
                g.setClip(this.fallingBalls_x[i] >> 5, (this.fallingBalls_y[i] >> 5) + ccrt, 8, 8);
                this.drawBall(this.fallingBalls_x[i] >> 5, (this.fallingBalls_y[i] >> 5) + ccrt, this.fallingBalls_what[i] - 1);
                int n5 = i;
                this.fallingBalls_x[n5] = this.fallingBalls_x[n5] + this.fallingBalls_dx[i];
                int n6 = i;
                this.fallingBalls_y[n6] = this.fallingBalls_y[n6] + this.fallingBalls_dy[i];
                int n7 = i;
                this.fallingBalls_dy[n7] = this.fallingBalls_dy[n7] + 15;
                if (this.fallingBalls_y[i] >> 5 > 208) {
                    this.fallingBalls_what[i] = 0;
                    --this.nofFallingBalls;
                }
            } else {
                g.setClip(this.fallingBalls_x[i] >> 5, (this.fallingBalls_y[i] >> 5) + ccrt, FLASHWIDTH, FLASHHEIGHT);
                if (this.fallingBalls_dx[i] < 0) {
                    g.drawImage(this.spark, (this.fallingBalls_x[i] >> 5) - FLASHWIDTH, (this.fallingBalls_y[i] >> 5) + ccrt, 0);
                } else {
                    g.drawImage(this.spark, this.fallingBalls_x[i] >> 5, (this.fallingBalls_y[i] >> 5) + ccrt, 0);
                }
                int n8 = i;
                this.fallingBalls_x[n8] = this.fallingBalls_x[n8] + this.fallingBalls_dx[i];
                int x = this.fallingBalls_x[i] >> 5;
                int y = this.fallingBalls_y[i] >> 5;
                int cx = this.xcase(x, y);
                int cy = this.ycase(x, y);
                if (x < -8 || x > 176) {
                    this.fallingBalls_what[i] = 0;
                    --this.nofFallingBalls;
                }
                if (this.getBallCase(cx, cy) > 0) {
                    this.addExplosion(x, y);
                    this.setBallCase(cx, cy, 0);
                    checkBallsFall = true;
                }
            }
            ++i;
            if (++n < this.nofFallingBalls) continue;
            done = true;
        }
        if (checkBallsFall) {
            this.ballsFall();
        }
    }

    public void resetAnimations() {
        for (int i = 0; i < MAXNOFFALLINGTHINGS; ++i) {
            this.fallingBalls_what[i] = 0;
        }
        this.nofFallingBalls = 0;
    }

    public void sleep(int time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    Image reLoadImage(String name) {
        Image im = null;
        try {
            im = Image.createImage((String)name);
            System.out.println(String.valueOf(String.valueOf(new StringBuffer("LOAD img[").append(name).append("] mem free(after):").append(Runtime.getRuntime().freeMemory()))));
        }
        catch (Exception ioe) {
            System.out.println(String.valueOf(String.valueOf(new StringBuffer("ERROR: reLoadImage(): chargement des Images (").append(name).append(")"))));
            ioe.printStackTrace();
        }
        return im;
    }

    void drawImage(Graphics g, Image im, int x, int y) {
        if (im != null) {
            g.drawImage(im, x, y, 0);
        } else {
            System.out.println(String.valueOf(String.valueOf(new StringBuffer("IMAGE == NULL    at (x,y)=").append(x).append(" ").append(y))));
        }
    }

    static {
        DEBUG = false;
        BALLS = 9;
        NORMALBALLS = 7;
        SCREENWIDTH = 176;
        SCREENHEIGHT = 208;
        LEFTCROWDSIZE = 16;
        RIGHTCROWDSIZE = 16;
        TOPCROWDSIZE = 16;
        TOPADDCROWDSIZE = 16;
        PLAYGROUNDWIDTH = 9;
        PLAYGROUNDHEIGHT = 13;
        PLAYGROUNDLOOSELEVEL = 12;
        BALLDIAMETER = 16;
        BALLDIAMETER2 = 256;
        BALLRADIUS = 8;
        BALLSPACINGHEIGHT = 13;
        BALLSPACINGWIDTH = 16;
        CHANGEBACKGROUNDEACH = 10;
        HALFSCREENWIDTH = 88;
        HALFSCREENHEIGHT = 104;
        KEYREPEATTIME = 3;
        FIXPOINT = 5;
        NOF_LEVELS = 50;
        BALLSPEEDFIXX = 200;
        BALLSPEEDFIXY = 100;
        PLAYERANIMSPEED = 4;
        FALLINGBALLSDY = 15;
        EXPLOSIONPARTWIDTH = 32;
        EXPLOSIONWIDTH = 160;
        EXPLOSIONHEIGHT = 32;
        FLASHWIDTH = 14;
        FLASHHEIGHT = 16;
        HALFCIRCLERADIUS = 20;
        NOFCURSORPOS = 40;
        NEWBALLDELTAY = -2;
        MENU_INTRO_SPLASH = 0;
        MENU_INTRO_SPLASH_KEY_DOWN = 1;
        MENU_MENU = 6;
        MENU_MENU_DIFFICULTY = 14;
        MENU_YOU_DIED_ANIM = 2;
        MENU_LOST_A_LIFE = 3;
        MENU_LOST_A_LIFE_ANIM = 4;
        MENU_HISCORE = 5;
        MENU_PLAY_START = 98;
        MENU_PLAY = 99;
        MENU_INTRO_LOGO = 7;
        MENU_STAGE_CLEAR = 10;
        MENU_STAGE_CLEAR_ANIM = 11;
        MENU_HELP = 12;
        MENU_CREDITS = 13;
        MENU_PAUSE = 16;
        SHOW_NOF_HISCORES = 7;
        MAXNOFFALLINGTHINGS = 117;
    }
}

