/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Random;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.microedition.midlet.MIDlet;

public class Main
extends GameCanvas
implements Runnable,
PlayerListener {
    protected static final int COLOR_RED = 0xFF0000;
    protected static final int COLOR_BLUE = 255;
    protected static final int COLOR_GREEN = 26112;
    protected static final int COLOR_WHITE = 0xFFFFFF;
    protected static final int COLOR_BLACK = 0;
    protected static final int COLOR_LIGHT_GRAY = 0xC0C0C0;
    protected static final int COLOR_DARK_GRAY = 0x404040;
    protected static final int COLOR_LIGHT_BROWN = 14067051;
    protected static final int COLOR_DARK_GREEN_BLUE = 15169;
    protected static final int COLOR_LIGHT_GREEN_BLUE = 30080;
    protected static final int LT = 20;
    protected static final int LC = 6;
    protected static final int CT = 17;
    protected static final int CC = 3;
    protected final int SCREEN_WIDTH;
    protected final int SCREEN_HEIGHT;
    protected final Font FONT_LARGE = Font.getFont((int)0, (int)0, (int)16);
    protected final Font FONT_MEDIUM = Font.getFont((int)0, (int)0, (int)0);
    protected final Font FONT_MEDIUM_BOLD = Font.getFont((int)0, (int)1, (int)0);
    protected final Font FONT_SMALL = Font.getFont((int)0, (int)0, (int)8);
    protected final Font FONT_SMALL_BOLD = Font.getFont((int)0, (int)1, (int)8);
    public Display display;
    protected static byte[] bySettings = new byte[4];
    private Thread thread;
    private Midlet midlet;
    private int nCurrentIndex;
    protected static final int STATE_NOKIA = 0;
    protected static final int STATE_COM2US = 1;
    protected static final int STATE_LOAD = 2;
    protected static final int STATE_GAME = 3;
    protected static final int STATE_TITLE = 4;
    protected static final int STATE_GAMEOVER = 5;
    protected static final int STATE_GAMEOVER_2 = 6;
    protected static final int STATE_SCORE = 7;
    protected static final int STATE_INSTRUCTIONS = 8;
    protected static final int STATE_ABOUT = 9;
    protected static final int STATE_SETTINGS = 10;
    protected static final int STATE_OPTIONS = 11;
    protected static final int STATE_OPTIONS_PLAY = 12;
    protected static final int STATE_RANKING_GETRANK = 21;
    protected static final int STATE_RANKING_MENUSCORE = 22;
    protected static final int STATE_RANKING_UPDATE = 23;
    protected static final int STATE_RANKING_LASTUPDATE = 24;
    protected static final int GAME_STATE_CHOOSE_CHARACTER = 0;
    protected static final int GAME_STATE_SET_FIRSTTURN = 1;
    protected static final int GAME_STATE_FIRSTTURN_ANI = 2;
    protected static final int GAME_STATE_FIRSTTURN_RESULT = 3;
    protected static final int GAME_STATE_DICE_READY = 4;
    protected static final int GAME_STATE_DICE_ANI = 5;
    protected static final int GAME_STATE_DICE_RESULT = 6;
    protected static final int GAME_STATE_FOCUS = 7;
    protected static final int GAME_STATE_MOVE_CHECKER = 8;
    protected static final int GAME_STATE_PLAY_VIEW = 9;
    protected static final int GAME_STATE_PLAY_VIEW2 = 10;
    protected static final int GAME_STATE_COM_PLAY = 11;
    protected static final int GAME_STATE_GAME_RESULT = 12;
    protected static final int GAME_STATE_GAME_RESULT2 = 13;
    protected static final int GAME_STATE_BET_ANI = 14;
    protected static final int GAME_STATE_USER_REPLY_DOUBLE = 15;
    protected static final int GAME_STATE_CALL_DOUBLE = 16;
    protected static final int GAME_STATE_COM_REPLY_DOUBLE = 17;
    protected static final int GAME_STATE_COM_REPLY_DOUBLE2 = 18;
    protected static final int GAME_STATE_BACKGAMMON_ANI = 19;
    protected static final int GAME_STATE_ASK_RESET = 20;
    protected int nState;
    protected int nGameState;
    protected int nPrevGameState;
    protected int commandCurrent1;
    protected int commandCurrent2;
    protected int COMMAND_NULL = 0;
    protected int COMMAND_OPTIONS = 1;
    protected int COMMAND_CHANGE = 2;
    protected int COMMAND_PLAY = 3;
    protected int COMMAND_UNDO = 4;
    protected int COMMAND_NO = 5;
    protected int COMMAND_YES = 6;
    protected int COMMAND_CONTINUE = 7;
    protected int COMMAND_MENU = 8;
    protected int COMMAND_SELECT = 9;
    protected int COMMAND_BACK = 10;
    protected int COMMAND_EXIT = 11;
    protected int COMMAND_OK = 12;
    protected int COMMAND_RETRY = 13;
    protected int VIEW_HEIGHT = 204 - this.FONT_MEDIUM.getHeight() - 1;
    protected String[] STR_COMMAND = new String[]{" ", "Options", "Change", "Play", "Undo", "No", "Yes", "Continue", "Menu", "Select", "Back", "Exit", "OK", "Retry"};
    protected static final int KEY_OFF = 0;
    protected static final int KEY_PRESSED = 1;
    protected static final int KEY_RELEASED = 2;
    protected static final int KEY_REPEATED = 3;
    protected static final int KEY_SOFTKEY1 = 21;
    protected static final int KEY_SOFTKEY2 = 22;
    protected int nKeyCode;
    protected int nKeyState;
    protected static final int CHARACTER_COUNT = 4;
    protected boolean blnRollDicePlayer1 = false;
    protected boolean blnRollDicePlayer2 = false;
    protected int nCurrentRollPlayer;
    protected boolean blnCanNotMove;
    protected boolean blnPlayComputer;
    int nCurrentMoveCheckerIndex = 0;
    protected static final int IDB_NOKIA = 0;
    protected static final int IDB_COM2US = 1;
    protected static final int IDB_ABOUT = 2;
    protected static final int IDB_ICON = 3;
    protected static final int IDB_COPYRIGHT = 4;
    protected static final int IDB_TITLE = 5;
    protected static final int IDB_BG = 6;
    protected static final int IDB_CHECKER_1 = 7;
    protected static final int IDB_CHECKER_2 = 8;
    protected static final int IDB_FOCUS = 9;
    protected static final int IDB_MARK_UP = 10;
    protected static final int IDB_MARK_DOWN = 11;
    protected static final int IDB_OK = 12;
    protected static final int IDB_BIG_DICE = 13;
    protected static final int IDB_SMALL_DICE = 14;
    protected static final int IDB_BIG_DICE_ANI_1 = 15;
    protected static final int IDB_BIG_DICE_ANI_2 = 16;
    protected static final int IDB_BIG_DICE_ANI_3 = 17;
    protected static final int IDB_BIG_DICE_ANI_4 = 18;
    protected static final int IDB_SMALL_DICE_ANI_1 = 19;
    protected static final int IDB_SMALL_DICE_ANI_2 = 20;
    protected static final int IDB_SMALL_DICE_ANI_3 = 21;
    protected static final int IDB_SMALL_DICE_ANI_4 = 22;
    protected static final int IDB_SMALL_DICE_ANI_5 = 23;
    protected static final int IDB_SMALL_DICE_ANI_6 = 24;
    protected static final int IDB_SMALL_DICE_ANI_7 = 25;
    protected static final int IDB_SMALL_DICE_ANI_8 = 26;
    protected static final int IDB_MARK_OUT = 27;
    protected static final int IDB_BETTING_BG_LOGO = 28;
    protected static final int IDB_MARK_UP_WHITE = 29;
    protected static final int IDB_MARK_DOWN_WHITE = 30;
    protected static final int IDB_CHARACTER = 31;
    protected static final int IDB_GOLD_1 = 32;
    protected static final int IDB_GOLD_2 = 33;
    protected static final int IDB_GOLD_3 = 34;
    protected static final int IDB_SILVER_1 = 35;
    protected static final int IDB_COPPER_1 = 36;
    protected static final int IDB_BET_BOARD_UP = 37;
    protected static final int IDB_BET_BOARD_RIGHT = 38;
    protected static final int IDB_BET_BOARD_DOWN = 39;
    protected static final int IDB_BET_BOARD_LEFT = 40;
    protected static final int IDB_NUMBER = 41;
    protected static final int IDB_SANDGLASS = 42;
    protected static final int IDB_GAME_RESULT_TEXT = 43;
    protected static final int IDB_CHARACTER_BG = 44;
    protected static final int IDB_SET_FIRSTTURN_BG = 45;
    protected static final int IDB_SET_TURN_PLAYER1 = 46;
    protected static final int IDB_SET_TURN_PLAYER2 = 47;
    protected static final int IDB_SET_TURN_COM = 48;
    protected static final int IDB_SET_TURN_ARROW_L = 49;
    protected static final int IDB_SET_TURN_ARROW_R = 50;
    protected static final int IDB_MESSAGE_BOX_RIGHT = 51;
    protected static final int IDB_MESSAGE_BOX_LEFT = 52;
    protected static final int IDB_MESSAGE_BOX_UP = 53;
    protected static final int IDB_MESSAGE_BOX_DOWN = 54;
    protected static final int IDB_OUT_CHECKER_1 = 55;
    protected static final int IDB_OUT_CHECKER_2 = 56;
    protected static final int IDB_SOUND_ON = 57;
    protected static final int IDB_SOUND_OFF = 58;
    protected static final int IDB_COUNT = 59;
    protected static final int IDS_TITLE = 0;
    protected static final int IDS_SELECT = 1;
    protected static final int IDS_MOVE_CHECKER = 2;
    protected static final int IDS_ROLL_DICE = 3;
    protected static final int IDS_WIN = 4;
    protected static final int IDS_LOSE = 5;
    protected static final int IDS_DOUBLE = 6;
    protected static final int IDS_NOT_MOVE = 7;
    protected static final int IDS_BET_GOLD = 8;
    protected static final int IDS_COUNT = 9;
    protected static final short[] IMG_DICE_START = new short[]{0, 471, 744, 1199, 1622, 2026, 2461, 2779, 3096, 3390, 3690, 4004, 4328, 4636};
    protected static final short[] IMG_DICE_SIZE = new short[]{471, 273, 455, 423, 404, 435, 318, 317, 294, 300, 314, 324, 308, 301};
    protected byte[] IMG_BUFFER = null;
    protected Image[] image = new Image[59];
    protected InputStream is = null;
    public static final int PLAYER1 = 0;
    public static final int PLAYER2 = 1;
    protected Random rndRandom = new Random();
    protected int[] nRandDice = new int[4];
    protected boolean blnContinue = false;
    protected boolean blnAllScreenRepaint = false;
    protected int nCurrentPlayer;
    protected int nPlayer1CharacterID = 0;
    protected int nPlayer2CharacterID = 1;
    protected int[] nDiceAnimation = new int[2];
    protected int[] nRollDiceWidthState = new int[2];
    protected int[] nRollDiceHeightState = new int[2];
    protected int[] nRollDiceX = new int[2];
    protected int[] nRollDiceY = new int[2];
    protected int[] nRollDiceFirstX = new int[2];
    protected int[] nRollDiceFirstY = new int[2];
    protected int[] nRollDiceGap = new int[2];
    protected int[] nRollDiceAimX = new int[2];
    protected int[] nRollDiceAimY = new int[2];
    protected static final int NOT_AVAIL_POSITION = -90;
    protected static final int OUT_READY_POSITION = 100;
    protected static final int OUT_DONE_POSITION = 105;
    protected static final int DUMMY_POSITION = 110;
    protected int[] arrDice = new int[4];
    protected int[] nPlayComFromX = new int[4];
    protected int[] nPlayComToX = new int[4];
    protected int[][] nPlayComCheckerX = new int[4][28];
    protected int[][] nPlayComCheckerY = new int[4][28];
    protected int nPlayComChecker;
    protected int nPlayComCheckerMax;
    protected int nPlayComCheckerIndex;
    protected int[] nFrame = new int[4];
    protected static final byte POSITION = 0;
    protected static final byte DICE = 1;
    protected static final byte BOARD_SIZE = 28;
    protected static final byte BAR = 24;
    protected static final byte OUT = 26;
    protected static final byte[] initialBoard = new byte[]{2, 0, 0, 0, 0, -5, 0, -3, 0, 0, 0, 5, -5, 0, 0, 0, 3, 0, 5, 0, 0, 0, 0, -2};
    protected byte[] m_byBoard;
    protected byte[] m_byTmpBoard;
    protected byte[] m_byTmpBoard2;
    protected static final int DEFAULT_BET = 1;
    protected int nOtherMoney;
    protected int nUserMoney;
    protected int nCurrentBetMoney = 0;
    protected int nCurrentDoubleBetMoney = 0;
    protected int nCurrentDoubleAuthority;
    protected int nBackgammon;
    protected int nBetAniFrame;
    protected static final int OPTIONS_TITLE = 0;
    protected static final int OPTIONS_CONTINUE = 1;
    protected static final int OPTIONS_GAME = 2;
    protected static final int OPTIONS_PLAY = 3;
    protected static final String[] TITLE_OPTIONS_GAME = new String[]{"Instructions", "Record", "Settings", "About", "Quit"};
    protected static final String[] TITLE_OPTIONS_CONTINUE = new String[]{"Continue", "Play", "Instructions", "Record", "Settings", "About", "Exit"};
    protected static final String[] TITLE_OPTIONS = new String[]{"Play", "Instructions", "Record", "Settings", "About", "Exit"};
    protected String[] arrInstructionsText;
    protected int nInstructionsLength;
    protected int nInstructionsIndex;
    protected static final int SOUND = 0;
    protected static final byte OFF = 1;
    protected static final byte ON = 0;
    protected static Player currentSound = null;
    protected int nCurrentSoundIndex = -1;
    protected long lStopWatchStartTime;
    private int nAniSeq;
    protected int nAniTemp;
    protected int nMotoAniX = 0;
    protected static final int CHECKER_GAP = 12;
    protected static final int CHECKER_WIDTH = 13;
    protected static final int CHECKER_HEIGHT = 14;
    protected int nSleepTime = 100;
    protected int nFocus;
    protected int nMarkColor;
    protected static final int MARK_WHITE = 19;
    protected static final int MARK_YELLOW = 0;
    protected boolean blnDrawMoveChecker = true;
    int[] nVerifiedCheckerPosition = new int[4];
    int m_nMoveCount;
    byte[][] m_byMoves = new byte[4][2];
    protected int nMoveIndex = -1;
    protected int nPoint = -50000;
    protected int nPointTemp = 0;
    protected boolean blnForfeitLose;
    protected boolean blnDouble = false;
    protected int nTurn = 0;
    protected int nPlayOptionsIndex;
    protected static final String[] TITLE_OPTIONS_PLAY = new String[]{"Player1 Vs Computer", "Player1 Vs Player2"};
    protected int nTitleOptionsIndex;
    protected int nContinueOptionsIndex;
    protected int nGameOptionsIndex;
    InputStreamReader isReader;
    char[] charBuffer = new char[40000];
    InputStream soundInputStream = null;

    public Main(Midlet midlet) {
        super(false);
        this.SCREEN_WIDTH = 176;
        this.SCREEN_HEIGHT = 204;
        this.setFullScreenMode(true);
        this.midlet = midlet;
        this.display = Display.getDisplay((MIDlet)midlet);
    }

    public void hideNotify() {
        if (this.nState == 3) {
            this.doPause();
        }
    }

    public void doPause() {
        this.stopSound();
        this.showOptions();
    }

    protected void start() {
        this.display.setCurrent((Displayable)this);
        if (this.thread == null) {
            this.thread = new Thread(this);
            this.thread.start();
        }
    }

    public void run() {
        this.arrInstructionsText = Main.getStringArray(this.FONT_SMALL, "In COM2US Backgammon, choose an opponent from four different characters, and then roll one die to decide who will go first. The player with the highest roll starts the game. Each player takes alternate turns and moves the checkers in accordance with the number on the dice. If you feel you have an advantage over your opponent during the game, you can propose to double the bet before you roll by pressing 1. The stake will then be doubled. If your opponent accepts the double, the right to redouble will go to your opponent. Should one of the players decline to double (to decline, press 2), the game is forfeited by that player. Make all four of your opponents go bankrupt to win the entire game.&1. Use the D-pad to move a checker up, down, left or right.&2. Click the Centre key or press 5 to select and place a checker, and also to roll the dice.&3. To double the bet, press 1.&4. To accept a doubling of the bet, press 1.&5. To decline, press 2.  You will forfeit the game.&6. Press the right soft key to pause the game.", 164);
        this.nInstructionsLength = this.arrInstructionsText.length + 1;
        this.nCurrentIndex = 0;
        this.waitForID(this.nCurrentIndex);
        this.waitForID(this.nCurrentIndex);
        this.nState = 1;
        this.resetStopWatch();
        while (true) {
            if (this.nState == 3) {
                this.repaint();
                this.keyReset();
                switch (this.nGameState) {
                    case 0: 
                    case 1: 
                    case 4: 
                    case 20: {
                        this.sleep(200);
                        break;
                    }
                    case 2: 
                    case 5: {
                        this.sleep(this.nSleepTime);
                        break;
                    }
                    case 3: 
                    case 7: 
                    case 8: {
                        this.sleep(200);
                        break;
                    }
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: {
                        this.sleep(1000);
                        break;
                    }
                    case 6: 
                    case 13: 
                    case 19: {
                        this.sleep(100);
                        break;
                    }
                    case 9: 
                    case 10: {
                        this.sleep(300);
                        break;
                    }
                    case 11: {
                        this.sleep(80);
                        break;
                    }
                    case 12: {
                        this.sleep(100);
                        break;
                    }
                    case 14: {
                        this.sleep(100);
                    }
                }
                continue;
            }
            if (this.nState >= 4 && this.nState <= 12) {
                this.repaint();
                this.sleep(200);
                continue;
            }
            if (this.nState == 0) {
                this.repaint();
                this.waitForID(this.nCurrentIndex);
                if (this.getStopWatchTime() < 3000L) continue;
                this.nState = 1;
                continue;
            }
            if (this.nState == 1) {
                this.repaint();
                this.waitForID(this.nCurrentIndex);
                if (this.getStopWatchTime() < 3000L) continue;
                this.nState = 2;
                continue;
            }
            if (this.nState == 2) {
                if (this.waitForID(this.nCurrentIndex)) {
                    this.initialize();
                    this.loadRMS();
                    this.initTitle();
                    continue;
                }
                this.repaint();
                continue;
            }
            this.sleep(100);
        }
    }

    public void paint(Graphics graphics) {
        if (this.nState == 3) {
            this.drawGame(graphics);
        } else if (this.nState == 5) {
            this.drawGameOver(graphics);
        } else if (this.nState == 11) {
            this.drawOptions(graphics);
        } else if (this.nState == 12) {
            this.drawPlayOptions(graphics);
        } else if (this.nState == 4) {
            this.drawTitle(graphics);
        } else if (this.nState == 8) {
            this.drawInstructions(graphics);
        } else if (this.nState == 7) {
            this.drawScore(graphics);
        } else if (this.nState == 10) {
            this.drawSettings(graphics);
        } else if (this.nState == 9) {
            this.drawAbout(graphics);
        } else if (this.nState == 0) {
            if (null != this.image[0]) {
                this.clearScreen(graphics, 0);
                graphics.drawImage(this.image[0], 88, 102, 3);
            }
        } else if (this.nState == 1) {
            if (null != this.image[1]) {
                this.clearScreen(graphics, 0xFFFFFF);
                graphics.drawImage(this.image[1], 88, 102, 3);
                this.drawLoading(graphics);
            }
        } else if (this.nState == 2) {
            this.drawLoading(graphics);
        }
        if (this.nState > 3 && this.nState < 21 || this.nGameState == 20) {
            this.drawCurrentCommands(graphics, 30080);
        }
    }

    protected void callBack(String string) {
        if (string == null) {
            this.showOptions();
        } else if (string.equals("Back")) {
            if (this.nState == 11) {
                this.blnAllScreenRepaint = true;
                this.updateGameCommands(this.nGameState);
                this.nState = 3;
                this.repaint();
            } else {
                this.showOptions();
            }
        } else if (string.equals("Continue")) {
            this.blnAllScreenRepaint = true;
            if (this.blnContinue) {
                Score.nContinueFlag = 2;
                this.updateGameCommands(this.nGameState);
                this.nState = 3;
                this.repaint();
            } else {
                this.updateGameCommands(this.nGameState);
                this.initGame(false, false);
                this.repaint();
            }
        } else if (string.equals("Play")) {
            this.GO_Options_Play();
        } else if (string.equals("Player1 Vs Computer")) {
            this.initGame(true, true);
            this.repaint();
        } else if (string.equals("Player1 Vs Player2")) {
            this.initGame(true, false);
            this.repaint();
        } else if (string.equals("Instructions")) {
            this.nInstructionsIndex = 0;
            this.setCurrentState(8);
            this.repaint();
        } else if (string.equals("Record")) {
            this.setCurrentState(7);
            this.repaint();
        } else if (string.equals("Settings")) {
            this.setCurrentState(10);
            this.repaint();
        } else if (string.equals("About")) {
            this.setCurrentState(9);
            this.repaint();
        } else if (string.equals("Quit")) {
            this.initTitle();
            switch (this.nGameState) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    Score.nContinueFlag = 0;
                    break;
                }
                default: {
                    Score.nContinueFlag = 1;
                    break;
                }
            }
        } else if (string.equals("Exit")) {
            this.destroyApp(true);
        }
    }

    private void showOptions() {
        this.GO_Options();
    }

    private void drawCurrentCommands(Graphics graphics, int n) {
        graphics.setClip(0, 0, 176, 204);
        graphics.setColor(n);
        graphics.fillRect(0, this.VIEW_HEIGHT, 176, 204 - this.VIEW_HEIGHT);
        graphics.setColor(0xFFFFFF);
        graphics.setFont(this.FONT_MEDIUM_BOLD);
        if (this.commandCurrent1 != 0) {
            graphics.drawString(this.STR_COMMAND[this.commandCurrent1], 2, 204, 36);
        }
        if (this.commandCurrent2 != 0) {
            graphics.drawString(this.STR_COMMAND[this.commandCurrent2], 174, 204, 40);
        }
    }

    public void DO_commandAction(int n) {
        if (n == this.COMMAND_OPTIONS || n == this.COMMAND_MENU || n == this.COMMAND_NO) {
            this.callBack(null);
        } else if (n == this.COMMAND_BACK) {
            if (this.nState == 11 && (Score.nContinueFlag == 0 || Score.nContinueFlag == 1)) {
                this.initTitle();
            } else {
                this.callBack("Back");
            }
        } else if (n == this.COMMAND_SELECT) {
            if (this.nState == 11) {
                this.keyPressed_Options(53);
            } else {
                this.keyPressed_Options_Play(53);
            }
        } else if (n == this.COMMAND_PLAY) {
            this.GO_Options_Play();
        } else if (n == this.COMMAND_UNDO) {
            this.unDo();
        } else if (n == this.COMMAND_CONTINUE) {
            if (this.blnPlayComputer) {
                this.setCurrentGameState(14);
            } else {
                this.setCurrentGameState(1);
            }
            this.initGame(true, true);
            this.chooseCharacter(8);
        } else if (n == this.COMMAND_CHANGE) {
            Main.bySettings[0] = bySettings[0] == 0 ? (byte)1 : 0;
            this.saveRMS();
            this.repaint();
        } else if (n == this.COMMAND_OK) {
            int n2 = 0;
            while (n2 < 5) {
                Score.nTotalMoney[n2] = 10000;
                Score.nTotalWin[n2] = 0;
                Score.nTotalLose[n2] = 0;
                ++n2;
            }
            Score.nContinueFlag = 0;
            this.callBack(null);
        } else if (n == this.COMMAND_RETRY) {
            this.setCurrentGameState(14);
            this.initGame(true, true);
            this.chooseCharacter(8);
        }
    }

    public void setCurrentState(int n) {
        this.nState = n;
        this.updateCommands(n);
    }

    public void setCurrentGameState(int n) {
        this.nPrevGameState = this.nGameState;
        this.nGameState = n;
        switch (n) {
            case 7: {
                this.nMarkColor = 19;
                break;
            }
            case 2: {
                this.nSleepTime = 80;
                this.playSound(3);
                break;
            }
            case 5: {
                this.nSleepTime = 80;
                this.playSound(3);
                break;
            }
            case 12: {
                if (this.nCurrentPlayer == 0) {
                    this.playSound(4);
                    if (this.blnPlayComputer) {
                        Score.nTotalWin[0] = Score.nTotalWin[0] + 1;
                        int n2 = this.nPlayer2CharacterID;
                        Score.nTotalLose[n2] = Score.nTotalLose[n2] + 1;
                    }
                } else {
                    this.playSound(5);
                    if (this.blnPlayComputer) {
                        int n3 = this.nPlayer2CharacterID;
                        Score.nTotalWin[n3] = Score.nTotalWin[n3] + 1;
                        Score.nTotalLose[0] = Score.nTotalLose[0] + 1;
                    }
                }
                Score.nContinueFlag = 0;
                this.nBetAniFrame = 0;
                this.blnContinue = false;
                this.setGameResultMoney();
                if (this.nBackgammon == 1) break;
                this.nGameState = 19;
                break;
            }
            case 13: {
                this.nBetAniFrame = 0;
            }
        }
        this.updateGameCommands(n);
    }

    public void updateCommands(int n) {
        switch (n) {
            case 4: {
                this.addCommands(this.COMMAND_OPTIONS, this.COMMAND_PLAY);
                break;
            }
            case 11: 
            case 12: {
                this.addCommands(this.COMMAND_SELECT, this.COMMAND_BACK);
                break;
            }
            case 5: {
                this.addCommands(this.COMMAND_CONTINUE, this.COMMAND_MENU);
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                this.addCommands(this.COMMAND_NULL, this.COMMAND_BACK);
                break;
            }
            case 10: {
                this.addCommands(this.COMMAND_CHANGE, this.COMMAND_BACK);
                break;
            }
            case 6: {
                this.addCommands(this.COMMAND_RETRY, this.COMMAND_MENU);
            }
        }
    }

    public void updateGameCommands(int n) {
        if (n == 8) {
            this.addCommands(this.COMMAND_UNDO, this.COMMAND_OPTIONS);
        } else if (n == 20) {
            this.addCommands(this.COMMAND_OK, this.COMMAND_NULL);
        } else {
            this.addCommands(this.COMMAND_NULL, this.COMMAND_OPTIONS);
        }
    }

    public void addCommands(int n, int n2) {
        this.commandCurrent1 = n;
        this.commandCurrent2 = n2;
    }

    protected void keyPressed(int n) {
        block33: {
            block32: {
                if (n == 21) {
                    this.DO_commandAction(this.commandCurrent1);
                    return;
                }
                if (n == 22) {
                    this.DO_commandAction(this.commandCurrent2);
                    return;
                }
                if (this.nState != 3) break block32;
                this.nKeyCode = this.getGameAction(n);
                this.nKeyState = 1;
                switch (this.nGameState) {
                    case 1: {
                        this.setFirstTurn();
                        break;
                    }
                    case 0: {
                        this.chooseCharacter(this.nKeyCode);
                        break;
                    }
                    case 12: 
                    case 13: {
                        if (!this.blnPlayComputer) {
                            Score.nContinueFlag = 0;
                            this.blnContinue = false;
                            this.callBack(null);
                            return;
                        }
                        this.setCurrentState(5);
                        this.repaint();
                        break;
                    }
                    case 15: {
                        this.replyDouble(n);
                        break;
                    }
                    case 14: {
                        if (this.nBetAniFrame > 205) {
                            this.nBetAniFrame = 210;
                            if (this.blnRollDicePlayer1 && this.blnRollDicePlayer2) {
                                if (this.blnPlayComputer && this.nCurrentPlayer == 1) {
                                    this.nCurrentPlayer = 0;
                                    this.changePlayer();
                                    break;
                                }
                                this.setCurrentGameState(4);
                                break;
                            }
                            this.setCurrentGameState(1);
                            break;
                        }
                        break block33;
                    }
                    default: {
                        if (!this.blnPlayComputer || this.blnPlayComputer && this.nCurrentPlayer == 0) {
                            this.controlCheckers(n);
                            break;
                        }
                        break block33;
                    }
                }
                break block33;
            }
            if (this.nState == 4) {
                this.showOptions();
            } else if (this.nState == 11) {
                this.keyPressed_Options(n);
            } else if (this.nState == 12) {
                this.keyPressed_Options_Play(n);
            } else if (this.nState == 8) {
                this.nKeyCode = this.getGameAction(n);
                this.nKeyState = 1;
                int n2 = 156 / this.FONT_SMALL.getHeight();
                if (this.nKeyCode == 1 && this.nInstructionsIndex > 0) {
                    --this.nInstructionsIndex;
                } else if (this.nKeyCode == 6 && this.nInstructionsIndex < this.nInstructionsLength - n2) {
                    ++this.nInstructionsIndex;
                }
                if (this.nKeyCode == 8) {
                    this.callBack(null);
                    return;
                }
                this.repaint();
            } else if (this.nState == 7 || this.nState == 9 || this.nState == 10) {
                this.nKeyCode = this.getGameAction(n);
                this.nKeyState = 1;
                if (this.nKeyCode == 8) {
                    this.callBack(null);
                }
            } else if (this.nState == 0) {
                this.nState = 1;
            } else if (this.nState == 1) {
                this.nState = 2;
            }
        }
    }

    protected void keyRepeated(int n) {
    }

    protected void keyReleased(int n) {
        if (this.nKeyState == 1) {
            this.nKeyState = 0;
        } else {
            this.nKeyState = 0;
            this.nKeyCode = 0;
        }
    }

    protected void keyReset() {
        if (this.nKeyState == 1) {
            this.nKeyState = 0;
        } else if (this.nKeyState == 2) {
            this.nKeyState = 0;
            this.nKeyCode = 0;
        }
    }

    protected void drawScore(Graphics graphics) {
        this.drawMenuBG(graphics);
        this.drawMessageBox(graphics, 0);
        this.drawTextInMessageBox(graphics, this.nState == 3 ? "Game Over" : "Record", 0, true);
        this.drawCharacterBG(graphics, 10, 35);
        this.drawUserCharacter(graphics, 11, 35, 20, 0);
        int n = 113;
        int n2 = 48;
        graphics.setColor(0);
        graphics.setFont(this.FONT_SMALL_BOLD);
        graphics.drawString("Won:" + Score.nTotalWin[0] + "", n, n2, 17);
        graphics.drawString("Lost:" + Score.nTotalLose[0] + "", n, n2 + 20, 17);
        graphics.drawString("Coin(s):", 30, 140, 20);
        this.drawGolds(graphics, Score.nTotalMoney[0], 150, 139, false);
        graphics.drawString(Score.nTotalMoney[0] + "", n + 20, 150, 17);
    }

    protected void drawCharacterBG(Graphics graphics, int n, int n2) {
        graphics.setColor(0);
        graphics.fillRect(n, n2, 52, 59);
        graphics.setColor(14067051);
        graphics.fillRect(n + 1, n2 + 1, 50, 57);
    }

    protected void chooseCharacter(int n) {
        switch (n) {
            case 8: {
                if (Score.nTotalMoney[this.nPlayer2CharacterID] < 1) {
                    return;
                }
                if (this.blnPlayComputer) {
                    this.setCurrentGameState(14);
                    this.playSound(8);
                    this.nOtherMoney = Score.nTotalMoney[this.nPlayer2CharacterID] - 1;
                    this.nUserMoney = Score.nTotalMoney[0] - 1;
                    Score.nTotalMoney[this.nPlayer2CharacterID] = this.nOtherMoney;
                    Score.nTotalMoney[0] = this.nUserMoney;
                } else {
                    this.setCurrentGameState(1);
                }
                this.nBetAniFrame = 0;
                break;
            }
            case 2: {
                --this.nPlayer2CharacterID;
                if (this.nPlayer2CharacterID < 1) {
                    this.nPlayer2CharacterID = 1;
                }
                this.nMotoAniX = 0;
                break;
            }
            case 5: {
                ++this.nPlayer2CharacterID;
                if (this.nPlayer2CharacterID > 4) {
                    this.nPlayer2CharacterID = 4;
                }
                this.nMotoAniX = 0;
            }
        }
        this.repaint();
    }

    protected void setFirstTurn() {
        if (this.blnPlayComputer) {
            if (!this.blnRollDicePlayer1 && this.nKeyCode == 8) {
                while (this.blnRollDicePlayer2) {
                    this.nRandDice[0] = this.getRandomDiceOne();
                    this.nRandDice[1] = this.getRandomDiceOne();
                    if (this.nRandDice[0] != this.nRandDice[1]) break;
                }
                this.nCurrentRollPlayer = 0;
                this.blnRollDicePlayer1 = true;
                this.setCurrentGameState(2);
            }
        } else if (!this.blnRollDicePlayer1 && this.nKeyCode == 2) {
            do {
                this.nRandDice[0] = this.getRandomDiceNumber();
            } while (this.nRandDice[0] == this.nRandDice[1]);
            this.nCurrentRollPlayer = 0;
            this.blnRollDicePlayer1 = true;
            this.setCurrentGameState(2);
        } else if (!this.blnRollDicePlayer2 && this.nKeyCode == 5) {
            do {
                this.nRandDice[1] = this.getRandomDiceNumber();
            } while (this.nRandDice[0] == this.nRandDice[1]);
            this.nCurrentRollPlayer = 1;
            this.blnRollDicePlayer2 = true;
            this.setCurrentGameState(2);
        }
        if (this.blnRollDicePlayer1 && this.blnRollDicePlayer2) {
            this.nCurrentPlayer = this.nRandDice[0] > this.nRandDice[1] ? 0 : 1;
        }
        this.nSleepTime = 100;
    }

    protected void controlFocus() {
        if (this.m_byBoard[24 + this.nCurrentPlayer] > 0) {
            this.nFocus = this.nCurrentPlayer == 0 ? -1 : 24;
            return;
        }
        switch (this.nKeyCode) {
            case 2: {
                if (this.nFocus <= 11) {
                    int n = this.nFocus + 1;
                    while (n < 24) {
                        if (this.searchChecker(n)) {
                            return;
                        }
                        ++n;
                    }
                } else {
                    if (this.nFocus > 23) break;
                    int n = this.nFocus - 1;
                    while (n >= 0) {
                        if (this.searchChecker(n)) {
                            return;
                        }
                        --n;
                    }
                }
                break;
            }
            case 5: {
                if (this.nFocus <= 11) {
                    int n = this.nFocus - 1;
                    while (n >= 0) {
                        if (this.searchChecker(n)) {
                            return;
                        }
                        --n;
                    }
                    int n2 = 23;
                    while (n2 >= 12) {
                        if (this.searchChecker(n2)) {
                            return;
                        }
                        --n2;
                    }
                } else {
                    if (this.nFocus > 23) break;
                    int n = this.nFocus + 1;
                    while (n <= 23) {
                        if (this.searchChecker(n)) {
                            return;
                        }
                        ++n;
                    }
                    int n3 = 0;
                    while (n3 <= 11) {
                        if (this.searchChecker(n3)) {
                            return;
                        }
                        ++n3;
                    }
                }
                break;
            }
            case 1: {
                if (this.nFocus < 12) break;
                int n = 23 - this.nFocus;
                int n4 = 23 - this.nFocus - 1;
                while (n <= 11 || n4 >= 0) {
                    if (n >= 0 && this.searchChecker(n)) {
                        return;
                    }
                    if (n4 >= 0 && this.searchChecker(n4)) {
                        return;
                    }
                    ++n;
                    --n4;
                }
                break;
            }
            case 6: {
                if (this.nFocus > 11) break;
                int n = 23 - this.nFocus;
                int n5 = 23 - this.nFocus;
                while (n <= 23 || n5 >= 12) {
                    if (n <= 23 && this.searchChecker(n)) {
                        return;
                    }
                    if (n5 >= 12 && this.searchChecker(n5)) {
                        return;
                    }
                    ++n;
                    --n5;
                }
                break;
            }
        }
    }

    protected void controlCheckers(int n) {
        if (this.nKeyState != 0) {
            switch (this.nGameState) {
                case 4: {
                    if (this.nKeyCode == 8) {
                        this.setRandomDice();
                        System.arraycopy(this.nRandDice, 0, this.arrDice, 0, this.nRandDice.length);
                        int n2 = 0;
                        while (n2 < 28) {
                            this.m_byTmpBoard[n2] = this.m_byBoard[n2];
                            ++n2;
                        }
                        if (this.m_byBoard[24 + this.nCurrentPlayer] > 0) {
                            this.nFocus = this.nCurrentPlayer == 0 ? -1 : 24;
                            this.setNextPosition(this.nFocus);
                            this.blnCanNotMove = false;
                            if (!this.isMovingAvailable()) {
                                this.blnCanNotMove = true;
                            }
                        } else {
                            this.setNextPosition(this.nFocus);
                            this.blnCanNotMove = !this.searchFocus();
                        }
                        this.setRollDiceXY(false);
                        this.setCurrentGameState(5);
                        break;
                    }
                    if (n != 49) break;
                    if (!this.blnPlayComputer) {
                        return;
                    }
                    if ((this.nCurrentPlayer != 0 || this.nCurrentDoubleAuthority == 1) && (this.nCurrentPlayer != 1 || this.nCurrentDoubleAuthority == 0)) break;
                    if (this.nCurrentBetMoney >= 128 || Score.nTotalMoney[0] < this.nCurrentBetMoney / 2) {
                        return;
                    }
                    this.playSound(6);
                    this.setCurrentGameState(16);
                    this.blnAllScreenRepaint = true;
                    this.blnDouble = this.verifyDouble();
                    break;
                }
                case 7: {
                    if (this.blnCanNotMove) {
                        this.playSound(7);
                        this.changePlayer();
                        this.blnCanNotMove = false;
                        break;
                    }
                    if (this.nKeyCode == 8) {
                        this.playSound(1);
                        this.setMoveCheckerIndex();
                        this.setCurrentGameState(8);
                        break;
                    }
                    this.controlFocus();
                    this.setNextPosition(this.nFocus);
                    break;
                }
                case 8: {
                    this.moveChecker();
                    break;
                }
                case 9: {
                    this.changePlayer();
                }
            }
            this.repaint();
        }
    }

    protected void moveChecker() {
        switch (this.nKeyCode) {
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                this.nCurrentMoveCheckerIndex = this.getNextCheckerIndex(this.nKeyCode, this.nCurrentMoveCheckerIndex);
                break;
            }
            case 8: {
                if (!this.makeMoveChecker(this.nCurrentPlayer, this.m_byBoard, (byte)this.nFocus, (byte)this.nVerifiedCheckerPosition[this.nCurrentMoveCheckerIndex])) {
                    return;
                }
                this.playSound(2);
                this.setRandomDiceArray();
                if (this.isGameOver()) {
                    this.setCurrentGameState(12);
                    return;
                }
                if (this.isTurnOver()) {
                    this.changePlayer();
                    break;
                }
                if (this.m_byBoard[24 + this.nCurrentPlayer] > 0) {
                    this.nFocus = this.nCurrentPlayer == 0 ? -1 : 24;
                    this.setNextPosition(this.nFocus);
                    if (!this.isMovingAvailable()) {
                        this.changePlayer();
                        return;
                    }
                } else {
                    this.nFocus = this.nVerifiedCheckerPosition[this.nCurrentMoveCheckerIndex];
                    if (this.nFocus < 0 || this.nFocus > 23) {
                        if (!this.searchFocus()) {
                            this.changePlayer();
                            return;
                        }
                    } else {
                        this.setNextPosition(this.nFocus);
                        if (!this.isMovingAvailable() && !this.searchFocus()) {
                            this.changePlayer();
                            return;
                        }
                    }
                }
                this.setCurrentGameState(7);
            }
        }
    }

    protected boolean isGameOver() {
        if (this.nCurrentPlayer == 0) {
            int n = 0;
            while (n < 24) {
                if (this.m_byBoard[n] > 0) {
                    return false;
                }
                ++n;
            }
        } else {
            int n = 0;
            while (n < 24) {
                if (this.m_byBoard[n] < 0) {
                    return false;
                }
                ++n;
            }
        }
        return true;
    }

    protected int getBackgammon(int n) {
        if (this.blnForfeitLose) {
            return 1;
        }
        if (this.m_byBoard[26 + n] < 1) {
            int n2;
            int n3 = n2 = n == 0 ? 0 : 18;
            if (this.m_byBoard[24 + n] > 0) {
                return 3;
            }
            int n4 = n2;
            while (n4 < n2 + 6) {
                if (this.m_byBoard[n4] != 0) {
                    return 3;
                }
                ++n4;
            }
            return 2;
        }
        return 1;
    }

    protected void setGameResultMoney() {
        int n;
        if (!this.blnPlayComputer) {
            this.nBackgammon = 1;
            return;
        }
        if (this.nCurrentPlayer == 0) {
            this.nBackgammon = this.getBackgammon(1);
            n = 0;
            int n2 = this.nPlayer2CharacterID;
            Score.nTotalMoney[n2] = Score.nTotalMoney[n2] - this.nCurrentBetMoney / 2 * (this.nBackgammon - 1);
            if (Score.nTotalMoney[this.nPlayer2CharacterID] < 0) {
                Score.nTotalMoney[this.nPlayer2CharacterID] = 0;
            }
        } else {
            this.nBackgammon = this.getBackgammon(0);
            n = this.nPlayer2CharacterID;
            Score.nTotalMoney[0] = Score.nTotalMoney[0] - this.nCurrentBetMoney / 2 * (this.nBackgammon - 1);
            if (Score.nTotalMoney[0] < 0) {
                Score.nTotalMoney[0] = 0;
            }
        }
        this.nUserMoney = Score.nTotalMoney[0];
        this.nOtherMoney = Score.nTotalMoney[this.nPlayer2CharacterID];
        this.nCurrentDoubleBetMoney = this.nCurrentBetMoney / 2 * (this.nBackgammon - 1);
        int n3 = n;
        Score.nTotalMoney[n3] = Score.nTotalMoney[n3] + (this.nCurrentBetMoney + this.nCurrentDoubleBetMoney);
    }

    protected boolean searchFocus() {
        int n = 0;
        while (n < 24) {
            if (this.searchChecker(n)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    protected boolean isTurnOver() {
        int n = 0;
        while (n < 4) {
            if (this.nRandDice[n] > 0) {
                return false;
            }
            ++n;
        }
        return true;
    }

    protected void setRandomDiceArray() {
        int n;
        if (this.nCurrentMoveCheckerIndex < 2 && this.nRandDice[0] != this.nRandDice[1]) {
            this.nRandDice[this.nCurrentMoveCheckerIndex] = -1;
        } else {
            n = 0;
            while (n <= this.nCurrentMoveCheckerIndex) {
                this.nRandDice[n] = -1;
                ++n;
            }
        }
        n = 0;
        while (n < 3) {
            if (this.nRandDice[n] < 0) {
                int n2 = n + 1;
                while (n2 < 4) {
                    if (this.nRandDice[n2] > 0) {
                        this.nRandDice[n] = this.nRandDice[n2];
                        this.nRandDice[n2] = -1;
                        break;
                    }
                    ++n2;
                }
            }
            ++n;
        }
    }

    protected void unDo() {
        this.setCurrentGameState(7);
        this.setNextPosition(this.nFocus);
        this.repaint();
    }

    protected int getNextCheckerIndex(int n, int n2) {
        int[] nArray = new int[4];
        System.arraycopy(this.nVerifiedCheckerPosition, 0, nArray, 0, this.nVerifiedCheckerPosition.length);
        try {
            switch (n) {
                case 2: {
                    if (this.nCurrentPlayer == 0 && nArray[n2] <= 11 || this.nCurrentPlayer == 1 && nArray[n2] >= 12) {
                        int n3 = n2 + 1;
                        while (n3 < 4) {
                            if (nArray[n3] >= 0) {
                                return n3;
                            }
                            ++n3;
                        }
                    } else {
                        int n4 = n2 - 1;
                        while (n4 >= 0) {
                            if (nArray[n4] >= 0) {
                                return n4;
                            }
                            --n4;
                        }
                    }
                    break;
                }
                case 5: {
                    if (this.nCurrentPlayer == 0 && nArray[n2] <= 11 || this.nCurrentPlayer == 1 && nArray[n2] >= 12) {
                        int n5 = n2 - 1;
                        while (n5 >= 0) {
                            if (nArray[n5] >= 0) {
                                return n5;
                            }
                            --n5;
                        }
                    } else {
                        int n6 = n2 + 1;
                        while (n6 < 4) {
                            if (nArray[n6] >= 0) {
                                return n6;
                            }
                            ++n6;
                        }
                    }
                    break;
                }
                case 1: {
                    if (nArray[n2] < 12) break;
                    int n7 = 0;
                    while (n7 < 4) {
                        if (nArray[n7] <= 11 && nArray[n7] != -90) {
                            return n7;
                        }
                        ++n7;
                    }
                    break;
                }
                case 6: {
                    if (nArray[n2] > 11) break;
                    int n8 = 0;
                    while (n8 < 4) {
                        if (nArray[n8] >= 12) {
                            return n8;
                        }
                        ++n8;
                    }
                    break;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n2;
    }

    protected void resetStopWatch() {
        this.lStopWatchStartTime = System.currentTimeMillis();
    }

    protected long getStopWatchTime() {
        return System.currentTimeMillis() - this.lStopWatchStartTime;
    }

    protected void sleep(int n) {
        try {
            Thread.sleep(n);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private int getKeyDirection(int n) {
        if (n == 53) {
            return 8;
        }
        return this.getGameAction(n);
    }

    protected void clearScreen(Graphics graphics, int n) {
        graphics.setClip(0, 0, 176, 204);
        graphics.setColor(n);
        graphics.fillRect(0, 0, 176, 204);
    }

    private void drawClipImage(Graphics graphics, int n, int n2, Image image, int n3, int n4, int n5, int n6, int n7) {
        graphics.setClip(n, n2, n5, n6);
        graphics.drawImage(image, n - n3, n2 - n4, n7);
        graphics.setClip(0, 0, 176, 204);
    }

    private void drawAlert(Graphics graphics, int n, int n2, String string, int n3, int n4, int n5, int n6, int n7, Font font) {
        graphics.setClip(0, 0, 176, 204);
        graphics.setColor(n3);
        graphics.fillRect(0, n - n2, 176, n2);
        graphics.setColor(n4);
        graphics.fillRect(4, n - n2 + 4, 171, n2 - 5);
        graphics.setColor(n5);
        graphics.fillRect(2, n - n2 + 2, 171, n2 - 5);
        graphics.setColor(n6);
        graphics.fillRect(3, n - n2 + 3, 169, n2 - 7);
        graphics.setColor(n7);
        graphics.setFont(font);
        graphics.drawString(string, 10, n - n2 + 9, 20);
    }

    protected void initTitle() {
        this.setCurrentState(4);
        this.resetStopWatch();
        this.repaint();
        this.playSound(0);
    }

    private void drawTitle(Graphics graphics) {
        this.clearScreen(graphics, 0xFFFFFF);
        graphics.drawImage(this.image[5], 88, 87, 3);
    }

    private void drawLoading(Graphics graphics) {
        int n = this.nCurrentIndex * 146 / 67;
        if (n > 146) {
            n = 146;
        }
        this.drawAlert(graphics, 204, 45, "Loading...", 0xFFFFFF, 0xC0C0C0, 0, 0xFFFFFF, 0x404040, this.FONT_MEDIUM);
        graphics.setColor(0x404040);
        graphics.fillRect(14, 186, 148, 11);
        graphics.setColor(0xFFFFFF);
        graphics.fillRect(15, 187, 146, 9);
        graphics.setColor(0xC0C0C0);
        graphics.fillRect(15, 187, n, 9);
    }

    /*
     * Loose catch block
     */
    private boolean waitForID(int n) {
        block18: {
            if (n < 59) {
                if (n == 0) {
                    this.is = this.getClass().getResourceAsStream("/image/Img_Dice_Comp.png");
                    this.isReader = new InputStreamReader(this.is);
                    this.isReader.read(this.charBuffer, 0, 40000);
                    this.IMG_BUFFER = new String(this.charBuffer).getBytes();
                    this.is.read(this.IMG_BUFFER);
                    this.is.close();
                    this.is = null;
                }
                this.image[n] = n >= 13 && n <= 26 ? Image.createImage((byte[])this.IMG_BUFFER, (int)IMG_DICE_START[n - 13], (int)IMG_DICE_SIZE[n - 13]) : Image.createImage((String)("/image/" + (n + 100) + ".png"));
                try {
                    if (this.is != null) {
                        this.is.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                break block18;
                catch (Exception exception) {}
                {
                    try {
                        if (this.is != null) {
                            this.is.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        break block18;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (this.is != null) {
                                this.is.close();
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                }
            }
            if (n < 68) {
                this.loadSound(n - 59);
            } else {
                this.IMG_BUFFER = null;
                return true;
            }
        }
        ++this.nCurrentIndex;
        return false;
    }

    protected void initGame(boolean bl, boolean bl2) {
        this.nState = 3;
        this.blnContinue = true;
        Score.nContinueFlag = 2;
        this.blnAllScreenRepaint = true;
        if (bl) {
            if (bl2) {
                this.nCurrentBetMoney = 0;
                this.nCurrentDoubleAuthority = 2;
                this.nCurrentDoubleBetMoney = 1;
                this.blnPlayComputer = true;
                this.blnRollDicePlayer1 = false;
                this.blnRollDicePlayer2 = true;
            } else {
                this.blnPlayComputer = false;
                this.blnRollDicePlayer1 = false;
                this.blnRollDicePlayer2 = false;
            }
            this.initStage();
            this.setRandomDice();
        } else if (this.m_byBoard[24 + this.nCurrentPlayer] > 0) {
            this.nFocus = this.nCurrentPlayer == 0 ? -1 : 24;
            this.setNextPosition(this.nFocus);
        } else {
            this.blnCanNotMove = !this.searchFocus();
        }
    }

    protected void initialize() {
        this.m_byBoard = new byte[28];
        this.m_byTmpBoard = new byte[28];
        this.m_byTmpBoard2 = new byte[28];
        this.nTitleOptionsIndex = 0;
        this.nContinueOptionsIndex = 0;
        this.nGameOptionsIndex = 0;
        this.nPlayOptionsIndex = 0;
    }

    protected void initStage() {
        this.initializeBoard();
        if (this.blnPlayComputer) {
            if (Score.nTotalMoney[0] < 1) {
                this.blnContinue = false;
                Score.nContinueFlag = 0;
                this.setCurrentGameState(20);
                return;
            }
            if (Score.nTotalMoney[1] < 1 && Score.nTotalMoney[2] < 1 && Score.nTotalMoney[3] < 1 && Score.nTotalMoney[4] < 1) {
                this.setCurrentGameState(20);
                return;
            }
            this.setCurrentGameState(0);
            this.nMotoAniX = 0;
        } else {
            this.setCurrentGameState(1);
        }
        this.setRollDiceXY(true);
        this.blnForfeitLose = false;
    }

    protected int getRandomDiceOne() {
        this.rndRandom.nextInt();
        return Math.abs(this.rndRandom.nextInt() % 6) + 1;
    }

    protected int getRandomDiceNumber() {
        int[] nArray = new int[6];
        int n = 0;
        while (n < 6) {
            nArray[n] = n + 1;
            ++n;
        }
        int n2 = 0;
        while (n2 < 10) {
            int n3 = this.getRandomDiceOne() - 1;
            int n4 = nArray[n2 % 6];
            nArray[n2 % 6] = nArray[n3];
            nArray[n3] = n4;
            ++n2;
        }
        return nArray[this.getRandomDiceOne() - 1];
    }

    protected void setRandomDice() {
        this.nRandDice[0] = this.getRandomDiceNumber();
        this.nRandDice[1] = this.getRandomDiceNumber();
        if (this.nRandDice[0] == this.nRandDice[1]) {
            this.nRandDice[2] = this.nRandDice[0];
            this.nRandDice[3] = this.nRandDice[0];
        } else {
            if (this.nRandDice[0] > this.nRandDice[1]) {
                int n = this.nRandDice[0];
                this.nRandDice[0] = this.nRandDice[1];
                this.nRandDice[1] = n;
            }
            this.nRandDice[2] = -1;
            this.nRandDice[3] = -1;
        }
    }

    protected void drawGame(Graphics graphics) {
        if (this.blnAllScreenRepaint) {
            this.drawBoard(graphics);
            this.drawCheckerAll(graphics, this.m_byBoard);
            this.blnAllScreenRepaint = false;
        }
        switch (this.nGameState) {
            case 0: {
                this.drawChooseCharacter(graphics);
                this.drawMessageBox(graphics, 0);
                this.drawTextInMessageBox(graphics, "Select opponent", 0, true);
                this.drawChooseCharacterArrows(graphics);
                this.drawChooseCharacterDetail(graphics, this.nPlayer2CharacterID);
                break;
            }
            case 1: {
                this.drawBoard(graphics);
                this.drawCheckerAll(graphics, this.m_byBoard);
                this.drawSetFirstTurn(graphics);
                this.drawSetFirstTurnBigDices(graphics);
                this.nDiceAnimation[0] = 0;
                this.nDiceAnimation[1] = 0;
                break;
            }
            case 2: {
                this.drawSetFirstTurn(graphics);
                if (this.nDiceAnimation[this.nCurrentRollPlayer] >= 10) {
                    this.drawSetFirstTurnBigDices(graphics);
                    if (this.blnRollDicePlayer1 && this.blnRollDicePlayer2) {
                        if (this.nDiceAnimation[this.nCurrentRollPlayer] >= 15) {
                            this.setCurrentGameState(3);
                        }
                    } else {
                        this.setCurrentGameState(1);
                    }
                } else {
                    this.drawFirstTurnRollDiceAnimation(graphics, this.nCurrentRollPlayer);
                }
                int n = this.nCurrentRollPlayer;
                this.nDiceAnimation[n] = this.nDiceAnimation[n] + 1;
                break;
            }
            case 3: {
                if (this.nCurrentPlayer == 1 && this.blnPlayComputer) {
                    this.nCurrentPlayer = 0;
                    this.changePlayer();
                    break;
                }
                this.setCurrentGameState(4);
                if (!this.blnPlayComputer) break;
                break;
            }
            case 4: {
                this.drawBoard(graphics);
                this.drawCheckerAll(graphics, this.m_byBoard);
                this.drawMessageBox(graphics, 1);
                if (this.blnPlayComputer) {
                    this.drawCurrentPlayerCharacter(graphics);
                    if (this.nCurrentPlayer == 1) {
                        this.drawTextInMessageBox(graphics, "My turn", 1, false);
                    } else if (this.nCurrentPlayer == 0 && this.nCurrentDoubleAuthority != 1 && this.nCurrentBetMoney < 128 && Score.nTotalMoney[0] >= this.nCurrentBetMoney / 2) {
                        this.drawTextInMessageBox(graphics, "OK:Roll   1:Double", 1, false);
                    } else {
                        this.drawTextInMessageBox(graphics, "OK:Roll", 1, false);
                    }
                } else {
                    this.drawTextInMessageBox(graphics, "OK:Roll", 1, false);
                }
                this.nDiceAnimation[0] = 0;
                this.nDiceAnimation[1] = 0;
                break;
            }
            case 5: {
                this.drawBoard(graphics);
                this.drawCheckerAll(graphics, this.m_byTmpBoard);
                if (this.nDiceAnimation[1] >= 17) {
                    if (this.blnPlayComputer && this.nCurrentPlayer == 1 && this.arrDice[0] == this.arrDice[1]) {
                        graphics.drawImage(this.image[42], 88, 86, 3);
                    }
                    this.setCurrentGameState(6);
                    break;
                }
                this.drawRollDiceAnimation(graphics, this.nRollDiceX, this.nRollDiceY, this.nRollDiceFirstX, this.nRollDiceFirstY, this.nRollDiceAimX, this.nRollDiceAimY, this.nDiceAnimation, this.nRollDiceGap);
                this.nDiceAnimation[0] = this.nDiceAnimation[0] + 1;
                this.nDiceAnimation[1] = this.nDiceAnimation[1] + 1;
                this.nSleepTime = this.nDiceAnimation[0] % 4 == 0 ? this.nSleepTime + 20 : this.nSleepTime;
                break;
            }
            case 6: {
                if (this.blnPlayComputer && this.nCurrentPlayer == 1) {
                    this.setCurrentGameState(9);
                    this.runComputerAI();
                } else {
                    this.setCurrentGameState(7);
                }
                this.blnAllScreenRepaint = true;
                break;
            }
            case 7: {
                this.drawSmallDices(graphics, this.nRandDice);
                this.drawFocus(graphics);
                this.nMarkColor = this.nMarkColor == 19 ? 0 : 19;
                this.DrawAvailPositionMark(graphics, this.nMarkColor);
                this.blnAllScreenRepaint = true;
                break;
            }
            case 8: {
                this.nMarkColor = this.nMarkColor == 19 ? 0 : 19;
                this.DrawAvailPositionMark(graphics, this.nMarkColor);
                this.drawSmallDices(graphics, this.nRandDice);
                this.drawMoveChecker(graphics);
                this.drawUndoCommand(graphics);
                this.blnAllScreenRepaint = true;
                break;
            }
            case 9: {
                this.drawBoard(graphics);
                this.drawCheckerAll(graphics, this.m_byTmpBoard2);
                this.drawSmallDices(graphics, this.arrDice);
                if (this.arrDice[0] == this.arrDice[1]) {
                    graphics.drawImage(this.image[42], 88, 86, 3);
                }
                this.nPlayComCheckerIndex = 0;
                this.nPlayComChecker = 0;
                this.setCurrentGameState(11);
                break;
            }
            case 11: {
                this.drawBoard(graphics);
                this.drawCheckerAll(graphics, this.m_byTmpBoard2);
                this.drawSmallDices(graphics, this.arrDice);
                if (this.nPlayComChecker <= this.nPlayComCheckerMax) {
                    if (this.nPlayComCheckerIndex < this.nFrame[this.nPlayComChecker]) {
                        if (this.nPlayComCheckerIndex == 0) {
                            this.makeMoveChecker(1, this.m_byTmpBoard2, (byte)this.nPlayComFromX[this.nPlayComChecker], (byte)110);
                        }
                        this.drawPlayComChecker(graphics, this.nPlayComChecker, this.nPlayComCheckerIndex);
                        ++this.nPlayComCheckerIndex;
                        break;
                    }
                    this.makeMoveChecker(1, this.m_byTmpBoard2, (byte)110, (byte)this.nPlayComToX[this.nPlayComChecker]);
                    this.playSound(2);
                    this.nPlayComCheckerIndex = 0;
                    ++this.nPlayComChecker;
                    break;
                }
                if (this.isGameOver()) {
                    this.setCurrentGameState(12);
                    break;
                }
                if (this.nPlayComCheckerMax == -1) {
                    this.playSound(7);
                }
                this.changePlayer();
                break;
            }
            case 10: {
                this.drawBoard(graphics);
                this.drawCheckerAll(graphics, this.m_byBoard);
                this.drawSmallDices(graphics, this.arrDice);
                this.sleep(300);
                this.setCurrentGameState(4);
                break;
            }
            case 14: {
                this.drawBoard(graphics);
                this.drawCheckerAll(graphics, this.m_byBoard);
                this.drawBetAnimation(graphics);
                ++this.nBetAniFrame;
                if (this.nBetAniFrame > 225) {
                    if (this.blnRollDicePlayer1 && this.blnRollDicePlayer2) {
                        if (this.blnPlayComputer && this.nCurrentPlayer == 1) {
                            this.nCurrentPlayer = 0;
                            this.changePlayer();
                            break;
                        }
                        this.setCurrentGameState(4);
                        break;
                    }
                    this.setCurrentGameState(1);
                    break;
                }
                if (this.nBetAniFrame == 9) {
                    this.nCurrentBetMoney += this.nCurrentDoubleBetMoney * 2;
                    this.nBetAniFrame = 200;
                    break;
                }
                this.blnAllScreenRepaint = true;
                break;
            }
            case 15: {
                this.drawMessageBox(graphics, 1);
                this.drawTextInMessageBox(graphics, "1.Accept  2.Forfeit", 1, false);
                this.nCurrentPlayer = 0;
                this.drawCurrentPlayerCharacter(graphics);
                this.nCurrentPlayer = 1;
                break;
            }
            case 16: {
                this.drawMessageBox(graphics, 1);
                this.drawTextInMessageBox(graphics, "Double~!", 1, false);
                this.drawCurrentPlayerCharacter(graphics);
                if (this.nCurrentPlayer == 0) {
                    this.setCurrentGameState(17);
                } else {
                    this.setCurrentGameState(15);
                }
                this.blnAllScreenRepaint = true;
                break;
            }
            case 17: {
                this.sleep(1000);
                this.drawMessageBox(graphics, 1);
                this.drawTextInMessageBox(graphics, this.blnDouble ? "Accept~!!" : "Forfeit~", 1, false);
                this.nCurrentPlayer = 1;
                this.drawCurrentPlayerCharacter(graphics);
                this.nCurrentPlayer = 0;
                this.setCurrentGameState(18);
                break;
            }
            case 18: {
                if (this.blnDouble) {
                    this.doDouble();
                } else {
                    this.blnForfeitLose = true;
                    this.setCurrentGameState(12);
                }
                this.blnDouble = false;
                break;
            }
            case 19: {
                if (this.blnPlayComputer) {
                    this.drawBackgammonAnimation(graphics);
                }
                this.drawGameResult(graphics);
                ++this.nBetAniFrame;
                if (this.nBetAniFrame >= 202) {
                    this.setCurrentGameState(13);
                    break;
                }
                if (this.nBetAniFrame == 9) {
                    this.nBetAniFrame = 200;
                    this.nCurrentBetMoney += this.nCurrentDoubleBetMoney;
                    break;
                }
                this.blnAllScreenRepaint = true;
                break;
            }
            case 12: 
            case 13: {
                if (this.blnPlayComputer) {
                    this.drawGetGoldsAnimation(graphics);
                }
                this.drawGameResult(graphics);
                ++this.nBetAniFrame;
                if (this.nBetAniFrame > 225) {
                    this.nBetAniFrame = 250;
                    break;
                }
                if (this.nBetAniFrame == 9) {
                    this.nUserMoney = Score.nTotalMoney[0];
                    this.nOtherMoney = Score.nTotalMoney[this.nPlayer2CharacterID];
                    this.nBetAniFrame = 200;
                    break;
                }
                this.blnAllScreenRepaint = true;
                break;
            }
            case 20: {
                this.drawReset(graphics);
            }
        }
    }

    protected void drawBoard(Graphics graphics) {
        graphics.drawImage(this.image[6], 88, 102, 3);
    }

    protected void drawBottomInfo(Graphics graphics, byte[] byArray) {
        if (this.blnPlayComputer) {
            int n = this.blnRollDicePlayer1 && this.blnRollDicePlayer2 ? Score.nTotalMoney[this.nPlayer2CharacterID] : this.nOtherMoney;
            int n2 = this.blnRollDicePlayer1 && this.blnRollDicePlayer2 ? Score.nTotalMoney[0] : this.nUserMoney;
            graphics.drawImage(this.image[7], 155, 187, 20);
            graphics.drawImage(this.image[8], 10, 187, 20);
            this.drawGolds(graphics, 30000, 95, 192, false);
            graphics.setColor(0xFFFFFF);
            graphics.setFont(this.FONT_SMALL_BOLD);
            graphics.drawString(n + "          " + n2, 88, 183, 17);
        } else if (this.blnRollDicePlayer1 && this.blnRollDicePlayer2) {
            graphics.drawImage(this.image[7 + this.nCurrentPlayer], 55, 187, 20);
            graphics.setColor(0xFFFFFF);
            graphics.setFont(this.FONT_SMALL_BOLD);
            graphics.drawString(this.nCurrentPlayer == 0 ? "Player1" : "Player2", 100, 183, 17);
        }
    }

    protected void drawUndoCommand(Graphics graphics) {
        int n = this.FONT_SMALL_BOLD.stringWidth("Undo");
        graphics.setColor(15169);
        graphics.fillRect(0, 179, 176, 25);
        graphics.setColor(30080);
        graphics.fillRect(1, 180, 174, 23);
        graphics.setColor(0xFFFFFF);
        graphics.setFont(this.FONT_SMALL_BOLD);
        graphics.drawString("Undo", n / 2 + 10, 184, 17);
    }

    protected void drawMessageBox(Graphics graphics, int n) {
        int n2 = -1;
        int n3 = n == 0 ? 0 : 146;
        graphics.setColor(15169);
        graphics.fillRect(n2, n3, 176, 27);
        graphics.setColor(30080);
        graphics.fillRect(n2 + 5, 5 + n3, 176, 17);
        graphics.drawImage(this.image[52], n2, n3, 20);
        graphics.drawImage(this.image[51], n2 + 173, n3, 20);
        graphics.drawImage(this.image[53], 88, n3, 17);
        graphics.drawImage(this.image[54], 88, 23 + n3, 17);
    }

    protected void drawTextInMessageBox(Graphics graphics, String string, int n, boolean bl) {
        int n2 = n == 0 ? 8 : 154;
        graphics.setColor(0xFFFFFF);
        graphics.setFont(this.FONT_SMALL_BOLD);
        if (bl) {
            graphics.drawString(string, 88, n2 - 4, 17);
        } else {
            graphics.drawString(string, 7, n2 - 4, 20);
        }
    }

    protected void drawUserCharacter(Graphics graphics, int n, int n2, int n3, int n4) {
        if (n4 == 0) {
            this.drawClipImage(graphics, n, n2, this.image[31], 190, 0, 47, 59, n3);
        } else {
            this.drawClipImage(graphics, n, n2, this.image[31], 237, 0, 47, 59, n3);
        }
    }

    protected void drawOtherCharacter(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        switch (n) {
            case 1: {
                n6 = 0;
                n5 = 50;
                break;
            }
            case 2: {
                n6 = 50;
                n5 = 49;
                break;
            }
            case 3: {
                n6 = 99;
                n5 = 47;
                break;
            }
            case 4: {
                n6 = 146;
                n5 = 44;
                break;
            }
            default: {
                n6 = 500;
                n5 = 500;
            }
        }
        this.drawClipImage(graphics, n2, n3, this.image[31], n6, 0, n5, 59, n4);
    }

    protected void drawChooseCharacterDetail(Graphics graphics, int n) {
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        switch (n) {
            case 1: {
                string5 = "Roberto";
                string4 = "Sailor";
                string3 = "None but the brave";
                string2 = "deserve the fair.";
                string = "";
                break;
            }
            case 2: {
                string5 = "Emile";
                string4 = "Diplomat";
                string3 = "Nothing new to";
                string2 = "discover under the sun.";
                string = "";
                break;
            }
            case 3: {
                string5 = "Alain";
                string4 = "Writer";
                string3 = "All or nothing.";
                string2 = "";
                string = "";
                break;
            }
            case 4: {
                string5 = "Diane";
                string4 = "Governess";
                string3 = "Look before you leap!";
                string2 = "";
                string = "";
                break;
            }
            default: {
                string5 = "";
                string4 = "";
                string3 = "";
                string2 = "";
                string = "";
            }
        }
        int n2 = 113;
        int n3 = 45;
        graphics.setColor(0);
        graphics.setFont(this.FONT_SMALL_BOLD);
        graphics.drawString(string5, n2, n3, 17);
        graphics.drawString(string4, n2, n3 + 25, 17);
        graphics.drawString("Won:" + Score.nTotalWin[this.nPlayer2CharacterID] + "", n2 - 70, n3 + 60, 17);
        graphics.drawString("Lost:" + Score.nTotalLose[this.nPlayer2CharacterID] + "", n2 - 70, n3 + 77, 17);
        this.drawGolds(graphics, Score.nTotalMoney[this.nPlayer2CharacterID], 155, 115, false);
        graphics.drawString(Score.nTotalMoney[this.nPlayer2CharacterID] + "", n2 + 25, 126, 17);
        if (Score.nTotalMoney[this.nPlayer2CharacterID] < 1) {
            graphics.setColor(0);
            graphics.drawLine(0, 92, 176, 92);
            graphics.drawLine(0, 112, 176, 112);
            graphics.setColor(0xFFFFFF);
            graphics.fillRect(0, 93, 176, 19);
            graphics.setColor(0xFF0000);
            graphics.drawString("Bankrupt!!", 88, 97, 17);
        }
        n3 = 145;
        graphics.setColor(0);
        if (string2 == "" && string == "") {
            graphics.drawString(string3, 88, n3 + 10, 17);
        } else if (string == "") {
            graphics.drawString(string3, 5, n3, 20);
            graphics.drawString(string2, 5, n3 + 15, 20);
        } else {
            graphics.drawString(string3, 5, n3, 20);
            graphics.drawString(string2, 5, n3 + 15, 20);
            graphics.drawString(string, 5, n3 + 30, 20);
        }
    }

    protected void drawChooseCharacter(Graphics graphics) {
        this.drawMenuBG(graphics);
        this.drawCharacterBG(graphics, 10, 35);
        this.drawOtherCharacter(graphics, this.nPlayer2CharacterID, 11, 35, 20);
    }

    protected void drawCurrentPlayerCharacter(Graphics graphics) {
        if (this.nCurrentPlayer == 0) {
            this.drawUserCharacter(graphics, 129, 88, 20, 1);
        } else {
            this.drawOtherCharacter(graphics, this.nPlayer2CharacterID, 0, 88, 20);
        }
    }

    protected int getDrawCheckerPositionX(int n) {
        if (n <= 11) {
            return n <= 5 ? 132 - n * 12 + 12 : 132 - n * 12 + 3;
        }
        if (n <= 23) {
            return n <= 17 ? (n - 12) * 12 + 3 : (n - 12) * 12 + 12;
        }
        if (n == 100) {
            return this.nCurrentPlayer == 1 && this.blnPlayComputer ? 156 : 130;
        }
        if (n == 24 && this.nCurrentPlayer == 1) {
            return 88 + 6 * this.m_byTmpBoard[25];
        }
        return 1000;
    }

    protected int getDrawCheckerPositionY(int n, int n2) {
        if (n == 100) {
            return this.nCurrentPlayer == 1 && this.blnPlayComputer ? 79 : 79;
        }
        if (this.nCurrentPlayer == 1 && n == 24) {
            return 114;
        }
        n2 = n2 < 5 ? (n2 *= 12) : (n2 < 9 ? (n2 - 5) * 12 + 6 : (n2 < 12 ? (n2 - 8) * 12 : (n2 - 11) * 12 + 6));
        return n <= 11 ? n2 + 5 : 167 - n2 - 13 + 4;
    }

    protected void drawChecker(Graphics graphics, int n, int n2, int n3) {
        graphics.drawImage(this.image[7 + n3], this.getDrawCheckerPositionX(n), this.getDrawCheckerPositionY(n, n2), 20);
    }

    protected void drawCheckerBottom(Graphics graphics, int n, int n2, int n3) {
        int n4;
        if (n2 > 4) {
            n4 = 4;
            while (n4 >= 0) {
                this.drawChecker(graphics, n, n4, n3);
                --n4;
            }
        } else {
            int n5 = n2 - 1;
            while (n5 >= 0) {
                this.drawChecker(graphics, n, n5, n3);
                --n5;
            }
            return;
        }
        if (n2 > 8) {
            n4 = 8;
            while (n4 >= 5) {
                this.drawChecker(graphics, n, n4, n3);
                --n4;
            }
        } else {
            n4 = n2 - 1;
            while (n4 >= 5) {
                this.drawChecker(graphics, n, n4, n3);
                --n4;
            }
            return;
        }
        if (n2 > 11) {
            n4 = 11;
            while (n4 >= 9) {
                this.drawChecker(graphics, n, n4, n3);
                --n4;
            }
        } else {
            n4 = n2 - 1;
            while (n4 >= 9) {
                this.drawChecker(graphics, n, n4, n3);
                --n4;
            }
            return;
        }
        if (n2 > 13) {
            n4 = 13;
            while (n4 >= 12) {
                this.drawChecker(graphics, n, n4, n3);
                --n4;
            }
        } else {
            n4 = n2 - 1;
            while (n4 >= 12) {
                this.drawChecker(graphics, n, n4, n3);
                --n4;
            }
            return;
        }
        this.drawChecker(graphics, n, 14, n3);
    }

    protected void drawCheckerAll(Graphics graphics, byte[] byArray) {
        int n = 0;
        while (n < 24) {
            int n2 = byArray[n] > 0 ? 0 : 1;
            int n3 = Math.abs(byArray[n]);
            if (n >= 12) {
                this.drawCheckerBottom(graphics, n, n3, n2);
            } else {
                int n4 = 0;
                while (n4 < n3) {
                    this.drawChecker(graphics, n, n4, n2);
                    ++n4;
                }
            }
            ++n;
        }
        this.drawCatchedChecker(graphics, byArray);
        this.drawOutChecker(graphics, byArray);
        this.drawBottomInfo(graphics, byArray);
    }

    protected void drawCatchedChecker(Graphics graphics, byte[] byArray) {
        int n;
        int n2 = byArray[24];
        int n3 = byArray[25];
        int n4 = 0;
        while (n4 < n2) {
            n = 88 + 6 * n4 - 10;
            graphics.drawImage(this.image[7], n, 76, 3);
            ++n4;
        }
        int n5 = 0;
        while (n5 < n3) {
            n = 88 + 6 * n5 - 10;
            graphics.drawImage(this.image[8], n, 100, 3);
            ++n5;
        }
    }

    protected void drawOutChecker(Graphics graphics, byte[] byArray) {
        int n = 161;
        int n2 = byArray[26];
        int n3 = byArray[27];
        int n4 = 0;
        while (n4 < n2) {
            graphics.drawImage(this.image[55], n, 166 - n4 * 5, 20);
            ++n4;
        }
        int n5 = 0;
        while (n5 < n3) {
            graphics.drawImage(this.image[56], n, n5 * 5 + 4, 20);
            ++n5;
        }
    }

    protected void drawSmallDices(Graphics graphics, int[] nArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < 4) {
            if (nArray[n2] > 0) {
                ++n;
            }
            ++n2;
        }
        int n3 = n == 4 ? 12 : 16;
        int n4 = (88 - n * 14) / 2 + 8;
        n2 = 0;
        int n5 = 0;
        while (n2 < 4) {
            if (nArray[n2] > 0) {
                this.drawSmallDice(graphics, nArray[n2], n4 + n3 * n5, 82, 20);
                ++n5;
            }
            ++n2;
        }
    }

    protected void drawSmallDice(Graphics graphics, int n, int n2, int n3, int n4) {
        this.drawClipImage(graphics, n2 - 7, n3 - 7, this.image[14], (n - 1) * 14, 0, 14, 14, n4);
    }

    protected void drawBigDices(Graphics graphics, int n, int n2) {
        if (n > 0) {
            this.drawClipImage(graphics, 61, 89, this.image[13], (n - 1) * 24, 0, 24, 26, 20);
        }
        if (n2 > 0) {
            this.drawClipImage(graphics, 91, 89, this.image[13], (n2 - 1) * 24, 0, 24, 26, 20);
        }
    }

    protected void drawBigDice(Graphics graphics, int n, int n2, int n3) {
        this.drawClipImage(graphics, n2 - 12, n3, this.image[13], (n - 1) * 24, 0, 24, 26, 20);
    }

    protected void drawSetFirstTurn(Graphics graphics) {
        graphics.drawImage(this.image[45], 88, 102, 3);
        graphics.drawImage(this.image[46], 55, 75, 3);
        graphics.drawImage(this.image[this.blnPlayComputer ? 48 : 47], 120, 75, 3);
        if (!this.blnPlayComputer) {
            if (!this.blnRollDicePlayer1) {
                graphics.drawImage(this.image[49], 63, 134, 3);
            }
            if (!this.blnRollDicePlayer2) {
                graphics.drawImage(this.image[50], 113, 134, 3);
            }
        } else {
            graphics.drawImage(this.image[12], 88, 134, 3);
        }
    }

    protected void drawSetFirstTurnBigDices(Graphics graphics) {
        this.drawBigDice(graphics, this.nRandDice[0], 53, 94);
        this.drawBigDice(graphics, this.nRandDice[1], 123, 94);
    }

    protected void drawFirstTurnRollDiceAnimation(Graphics graphics, int n) {
        graphics.drawImage(this.image[15 + this.nDiceAnimation[n] % 4], this.nRollDiceX[n], this.nRollDiceY[n], 3);
        if (this.blnPlayComputer) {
            graphics.drawImage(this.image[15 + this.nDiceAnimation[0] % 4], this.nRollDiceX[1], this.nRollDiceY[1], 3);
        }
        if (n == 0) {
            if (!this.blnPlayComputer) {
                this.drawBigDice(graphics, this.nRandDice[1], 123, 94);
            }
        } else {
            this.drawBigDice(graphics, this.nRandDice[0], 53, 94);
        }
    }

    protected void drawChooseCharacterArrows(Graphics graphics) {
        if (this.nPlayer2CharacterID != 1) {
            graphics.drawImage(this.image[49], 0, 190, 20);
        }
        if (this.nPlayer2CharacterID != 4) {
            graphics.drawImage(this.image[50], 160, 190, 20);
        }
        if (Score.nTotalMoney[this.nPlayer2CharacterID] >= 1) {
            graphics.drawImage(this.image[12], 88, 189, 17);
        }
    }

    protected void drawRollDiceAnimation(Graphics graphics, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, int[] nArray5, int[] nArray6, int[] nArray7, int[] nArray8) {
        if (nArray7[0] > 2 && Math.abs(nArray2[0] - nArray2[1]) < 22) {
            nArray6[0] = nArray6[0] - 15;
            nArray6[1] = nArray6[1] + 15;
            nArray8[0] = 4;
            nArray8[1] = 4;
        }
        int n = 0;
        while (n < 2) {
            if (nArray7[1] <= 10) {
                if (this.nCurrentPlayer == 0) {
                    int n2 = n;
                    nArray[n2] = nArray[n2] - nArray8[n];
                } else {
                    int n3 = n;
                    nArray[n3] = nArray[n3] + nArray8[n];
                }
                nArray2[n] = this.getY(nArray3[n], nArray4[n], nArray5[n], nArray6[n], nArray[n]);
            }
            if (nArray7[1] > 10) {
                this.drawSmallDice(graphics, this.arrDice[n], nArray[n] + 7, nArray2[n] + 7, 20);
            } else {
                graphics.drawImage(this.image[19 + nArray7[n] % 8], nArray[n], nArray2[n], 20);
            }
            ++n;
        }
    }

    protected void setRollDiceAimXY() {
        Random random = new Random();
        this.nRollDiceAimX[0] = this.nCurrentPlayer == 0 ? 0 : 137;
        this.nRollDiceAimY[0] = Math.abs(random.nextInt() % 154);
        this.nRollDiceAimX[1] = this.nCurrentPlayer == 0 ? 0 : 137;
        this.nRollDiceAimY[1] = Math.abs(random.nextInt() % 154);
    }

    protected int getRollDicePower() {
        Random random = new Random();
        return Math.abs(random.nextInt() % 3);
    }

    protected void drawGameOver(Graphics graphics) {
        this.drawScore(graphics);
    }

    protected void drawGameResult(Graphics graphics) {
        int n = this.nCurrentPlayer + (this.blnPlayComputer ? 0 : 2);
        this.drawClipImage(graphics, -1, 69, this.image[43], 0, n * 35, 176, 35, 20);
    }

    protected void drawFocus(Graphics graphics) {
        if (this.blnCanNotMove) {
            return;
        }
        if (this.m_byBoard[24 + this.nCurrentPlayer] > 0) {
            int n = 88 + 6 * (this.m_byBoard[24 + this.nCurrentPlayer] - 1) - 10;
            int n2 = this.nCurrentPlayer == 0 ? 76 : 100;
            graphics.drawImage(this.image[9], n, n2, 3);
            return;
        }
        if (this.nFocus < 0 || this.nFocus > 23) {
            return;
        }
        graphics.drawImage(this.image[9], this.getDrawCheckerPositionX(this.nFocus), this.getDrawCheckerPositionY(this.nFocus, Math.abs(this.m_byTmpBoard[this.nFocus]) - 1), 20);
    }

    protected void DrawAvailPositionMark(Graphics graphics, int n) {
        int n2 = 0;
        int[] nArray = this.nVerifiedCheckerPosition;
        int n3 = 0;
        while (n3 < 4) {
            if (nArray[n3] >= 0) {
                int n4 = n2 = nArray[n3] <= 11 ? 0 : 171;
                if (nArray[n3] <= 5) {
                    graphics.drawImage(this.image[10 + n], 132 - nArray[n3] * 12 + 15, n2, 20);
                } else if (nArray[n3] <= 11) {
                    graphics.drawImage(this.image[10 + n], 132 - nArray[n3] * 12 + 6, n2, 20);
                } else if (nArray[n3] <= 17) {
                    graphics.drawImage(this.image[11 + n], (nArray[n3] - 12) * 12 + 6, n2, 20);
                } else if (nArray[n3] <= 23) {
                    graphics.drawImage(this.image[11 + n], (nArray[n3] - 12) * 12 + 15, n2, 20);
                } else if (nArray[n3] == 100) {
                    graphics.drawImage(this.image[27], 145, 86, 6);
                }
            }
            ++n3;
        }
    }

    protected void drawMoveChecker(Graphics graphics) {
        int n = this.nCurrentMoveCheckerIndex;
        int n2 = this.nCurrentPlayer == 0 ? 1 : -1;
        try {
            int n3;
            if (this.nVerifiedCheckerPosition[n] == 100) {
                n3 = 0;
            } else {
                int n4 = n3 = this.m_byBoard[this.nVerifiedCheckerPosition[n]] == -1 * n2 ? 0 : Math.abs(this.m_byBoard[this.nVerifiedCheckerPosition[n]]);
            }
            if (this.blnDrawMoveChecker) {
                this.drawChecker(graphics, this.nVerifiedCheckerPosition[n], n3, this.nCurrentPlayer);
                this.blnDrawMoveChecker = false;
            } else {
                this.blnDrawMoveChecker = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void drawReset(Graphics graphics) {
        this.drawMenuBG(graphics);
        graphics.setColor(0);
        graphics.setFont(this.FONT_SMALL);
        if (Score.nTotalMoney[0] < 1) {
            graphics.drawString("You are bankrupt.", 88, 72, 17);
            graphics.drawString("The game will now reset", 88, 87, 17);
            graphics.drawString("and clear your record.", 88, 102, 17);
        } else {
            graphics.drawString("Congratulations!", 88, 57, 17);
            graphics.drawString("You're the king of Backgammon.", 88, 72, 17);
            graphics.drawString("All your opponets have gone", 88, 87, 17);
            graphics.drawString("backrupt.  The game will reset", 88, 102, 17);
            graphics.drawString("and clear your record,", 88, 117, 17);
            graphics.drawString("allowing you to play again.", 88, 132, 17);
        }
    }

    protected boolean searchChecker(int n) {
        int n2;
        int n3 = n2 = this.nCurrentPlayer == 0 ? 1 : -1;
        if (this.m_byBoard[n] * n2 > 0) {
            this.setNextPosition(n);
            if (this.isMovingAvailable()) {
                this.nFocus = n;
                return true;
            }
        }
        return false;
    }

    protected void changePlayer() {
        this.setRandomDice();
        if (this.blnPlayComputer && this.nCurrentPlayer == 0) {
            this.nCurrentPlayer = 1;
            if (this.verifyDouble()) {
                this.playSound(6);
                this.setCurrentGameState(16);
                this.repaint();
                this.sleep(400);
                return;
            }
            this.setCurrentGameState(4);
            this.repaint();
            this.serviceRepaints();
            this.sleep(1200);
            int n = 0;
            while (n < 28) {
                this.m_byTmpBoard[n] = this.m_byBoard[n];
                ++n;
            }
            this.setRollDiceXY(false);
            this.nDiceAnimation[1] = 0;
            this.setCurrentGameState(5);
            this.setRandomDice();
            this.doCheetDice();
            System.arraycopy(this.nRandDice, 0, this.arrDice, 0, this.nRandDice.length);
            return;
        }
        this.nCurrentPlayer = this.nCurrentPlayer == 0 ? 1 : 0;
        this.setCurrentGameState(4);
    }

    protected void setRollDiceXY(boolean bl) {
        if (!bl) {
            Random random = new Random();
            if (this.nCurrentPlayer == 0) {
                this.nRollDiceFirstX[0] = 136;
                this.nRollDiceFirstX[1] = 136;
            } else {
                this.nRollDiceFirstX[0] = 10;
                this.nRollDiceFirstX[1] = 10;
            }
            this.nRollDiceFirstY[0] = 82;
            this.nRollDiceFirstY[1] = 122;
            int n = 0;
            while (n < 2) {
                this.nRollDiceX[n] = this.nRollDiceFirstX[n];
                this.nRollDiceY[n] = this.nRollDiceFirstY[n];
                ++n;
            }
            this.nRollDiceGap[0] = this.getRollDicePower() + 6;
            this.nRollDiceGap[1] = this.getRollDicePower() + 8;
            this.setRollDiceAimXY();
        } else {
            this.nRollDiceX[0] = 53;
            this.nRollDiceY[0] = 105;
            this.nRollDiceX[1] = 123;
            this.nRollDiceY[1] = 105;
        }
    }

    protected void setNextPosition(int n) {
        int n2;
        int[] nArray = new int[4];
        boolean bl = false;
        int n3 = this.nCurrentPlayer == 0 ? 1 : -1;
        int n4 = 0;
        while (n4 < 28) {
            this.m_byTmpBoard[n4] = this.m_byBoard[n4];
            ++n4;
        }
        n4 = 0;
        while (n4 < 4) {
            nArray[n4] = -90;
            ++n4;
        }
        if (this.nRandDice[0] == this.nRandDice[3] && this.nRandDice[0] > 0) {
            n2 = 0;
            while (n2 < 4) {
                nArray[n2] = n + this.nRandDice[0] * (n2 + 1) * n3;
                ++n2;
            }
            bl = true;
        } else if (this.nRandDice[0] == this.nRandDice[2] && this.nRandDice[1] > 0) {
            n2 = 0;
            while (n2 < 3) {
                nArray[n2] = n + this.nRandDice[1] * (n2 + 1) * n3;
                ++n2;
            }
            nArray[3] = -90;
            bl = true;
        } else if (this.nRandDice[0] == this.nRandDice[1] && this.nRandDice[0] > 0) {
            n2 = 0;
            while (n2 < 2) {
                nArray[n2] = n + this.nRandDice[1] * (n2 + 1) * n3;
                nArray[n2 + 2] = -90;
                ++n2;
            }
            bl = true;
        } else if (this.nRandDice[1] < 0) {
            nArray[0] = n + this.nRandDice[0] * n3;
            n2 = 1;
            while (n2 < 4) {
                nArray[n2] = -90;
                ++n2;
            }
        } else {
            nArray[0] = n + this.nRandDice[0] * n3;
            nArray[1] = n + this.nRandDice[1] * n3;
            nArray[2] = n + (this.nRandDice[0] + this.nRandDice[1]) * n3;
            nArray[3] = -90;
        }
        n4 = 0;
        while (n4 < 4) {
            this.nVerifiedCheckerPosition[n4] = n4 > 0 && bl && this.nVerifiedCheckerPosition[n4 - 1] == -90 ? -90 : (nArray[n4] < 0 || nArray[n4] > 23 || this.m_byTmpBoard[nArray[n4]] * (n3 * -1) >= 2 ? -90 : nArray[n4]);
            ++n4;
        }
        if (this.nVerifiedCheckerPosition[0] == -90 && this.nVerifiedCheckerPosition[1] == -90) {
            this.nVerifiedCheckerPosition[2] = -90;
        }
        if (this.m_byTmpBoard[24 + this.nCurrentPlayer] > 1) {
            this.nVerifiedCheckerPosition[2] = -90;
        }
        if (this.isAllInHome(this.nCurrentPlayer, this.m_byTmpBoard)) {
            n4 = 0;
            while (n4 < 4) {
                if (n4 > 0 && bl && this.nVerifiedCheckerPosition[n4 - 1] == -90) {
                    this.nVerifiedCheckerPosition[n4] = -90;
                } else if (nArray[n4] == 24 || nArray[n4] == -1) {
                    this.nVerifiedCheckerPosition[n4] = 100;
                } else if ((nArray[n4] >= 24 || nArray[n4] <= -1) && this.nRandDice[n4] >= 1) {
                    if (n4 < 2) {
                        int n5;
                        int n6 = n2 = this.nRandDice[0] == this.nRandDice[3] && n4 == 0 && this.nRandDice[0] != -1 ? 4 : 1;
                        if (this.nCurrentPlayer == 0) {
                            n5 = 18;
                            while (n5 < 24) {
                                if (this.m_byTmpBoard[n5] > 0 && n5 + this.nRandDice[n4] < nArray[n4]) {
                                    n2 -= this.m_byTmpBoard[n5];
                                    if (n5 == n) {
                                        ++n2;
                                    }
                                }
                                ++n5;
                            }
                        } else {
                            n5 = 5;
                            while (n5 > -1) {
                                if (this.m_byTmpBoard[n5] < 0 && n5 - this.nRandDice[n4] > nArray[n4]) {
                                    n2 -= Math.abs(this.m_byTmpBoard[n5]);
                                    if (n5 == n) {
                                        ++n2;
                                    }
                                }
                                --n5;
                            }
                        }
                        if (n2 > 0) {
                            this.nVerifiedCheckerPosition[n4] = 100;
                        }
                    }
                    if (this.m_byTmpBoard[26 + this.nCurrentPlayer] == 14) {
                        if (this.nCurrentPlayer == 0) {
                            if (nArray[2] > 24 || nArray[3] > 24) {
                                this.nVerifiedCheckerPosition[0] = 100;
                            }
                        } else if (nArray[2] < -1 || nArray[3] < -1) {
                            this.nVerifiedCheckerPosition[0] = 100;
                        }
                    }
                }
                ++n4;
            }
        }
    }

    protected boolean isMovingAvailable() {
        int n = 0;
        while (n < 4) {
            if (this.nVerifiedCheckerPosition[n] >= 0 || this.nVerifiedCheckerPosition[n] == 100) {
                return true;
            }
            ++n;
        }
        return false;
    }

    protected void setMoveCheckerIndex() {
        int n = 0;
        while (n < 4) {
            if (this.nVerifiedCheckerPosition[n] >= 0) {
                this.nCurrentMoveCheckerIndex = n;
                return;
            }
            ++n;
        }
    }

    protected void drawPlayComChecker(Graphics graphics, int n, int n2) {
        graphics.drawImage(this.image[7 + this.nCurrentPlayer], this.nPlayComCheckerX[n][n2], this.nPlayComCheckerY[n][n2], 20);
    }

    protected void setPlayComCheckerDrawPosition(byte[] byArray, byte[] byArray2, int n) {
        int n2;
        int n3 = 7;
        byte by = byArray2[0];
        int n4 = byArray2[0] - byArray2[1];
        int n5 = 0;
        int n6 = 0;
        if (by < 24) {
            int n7 = n5 = byArray[by] == 0 ? 0 : Math.abs(byArray[by]);
        }
        if (n4 >= 0) {
            n6 = byArray[n4] == 0 ? 0 : Math.abs(byArray[n4]) - 1;
        }
        int n8 = this.getDrawCheckerPositionX(by);
        int n9 = this.getDrawCheckerPositionY(by, by >= 24 ? 0 : n5);
        int n10 = this.getDrawCheckerPositionX(n4 <= -1 ? 100 : n4);
        int n11 = this.getDrawCheckerPositionY(n4 <= -1 ? 100 : n4, n4 <= -1 ? 0 : n6);
        if (n8 == n10) {
            n2 = Math.abs(n11 - n9) / n3;
            int n12 = 1;
            while (n12 <= n2) {
                this.nPlayComCheckerX[n][n12] = n8;
                this.nPlayComCheckerY[n][n12] = n9 > n11 ? n9 - n12 * n3 : n9 + n12 * n3;
                ++n12;
            }
        } else if (n9 == n11) {
            n2 = Math.abs(n10 - n8) / n3;
            int n13 = 1;
            while (n13 <= n2) {
                this.nPlayComCheckerX[n][n13] = n8 > n10 ? n8 - n13 * n3 : n8 + n13 * n3;
                this.nPlayComCheckerY[n][n13] = n9;
                ++n13;
            }
        } else if (Math.abs(n10 - n8) > Math.abs(n11 - n9)) {
            n2 = Math.abs(n10 - n8) / n3;
            int n14 = 1;
            while (n14 <= n2) {
                this.nPlayComCheckerX[n][n14] = n8 > n10 ? n8 - n14 * n3 : n8 + n14 * n3;
                this.nPlayComCheckerY[n][n14] = this.getY(n8, n9, n10, n11, this.nPlayComCheckerX[n][n14]);
                ++n14;
            }
        } else {
            n2 = Math.abs(n11 - n9) / n3;
            int n15 = 1;
            while (n15 < n2) {
                this.nPlayComCheckerY[n][n15] = n9 > n11 ? n9 - n15 * n3 : n9 + n15 * n3;
                this.nPlayComCheckerX[n][n15] = this.getX(n8, n9, n10, n11, this.nPlayComCheckerY[n][n15]);
                ++n15;
            }
        }
        this.nPlayComCheckerX[n][0] = n8;
        this.nPlayComCheckerY[n][0] = n9;
        this.nPlayComCheckerX[n][n2] = n10;
        this.nPlayComCheckerY[n][n2] = n11;
        this.nPlayComCheckerMax = n;
        this.nFrame[n] = n2;
    }

    protected int getY(int n, int n2, int n3, int n4, int n5) {
        if (n == n3 || n == n5) {
            if (n == n5) {
                return n2;
            }
            return n2;
        }
        if (n3 > n && n5 > n && n5 < n3 || n > n3 && n5 > n3 && n5 < n) {
            return (n5 - n) * (n4 - n2) / (n3 - n) + n2;
        }
        return -1;
    }

    protected int getX(int n, int n2, int n3, int n4, int n5) {
        if (n2 == n4) {
            if (n2 == n5) {
                return n;
            }
            return n;
        }
        if (n4 > n2 && n5 > n2 && n5 < n4 || n2 > n4 && n5 > n4 && n5 < n2) {
            return (n5 - n2) * (n3 - n) / (n4 - n2) + n;
        }
        return -1;
    }

    protected void saveRMS() {
        int n = 0;
        while (n < 28) {
            Score.board[n] = this.m_byBoard[n];
            ++n;
        }
        int n2 = 0;
        while (n2 < 4) {
            Score.dice[n2] = (byte)this.nRandDice[n2];
            ++n2;
        }
        Score.currentPlayer = this.nCurrentPlayer;
        Score.blnPlayComputer = this.blnPlayComputer;
        Score.nDoubleAuthority = this.nCurrentDoubleAuthority;
        Score.nCurrentBetMoney = this.nCurrentBetMoney;
        if (this.nGameState == 14) {
            Score.gameState = this.blnRollDicePlayer1 && this.blnRollDicePlayer2 ? 4 : 0;
        } else if (this.blnPlayComputer && this.nCurrentPlayer == 1) {
            if (this.nGameState == 6 || this.nGameState == 4 || this.nGameState == 5) {
                Score.gameState = 6;
            } else {
                Score.gameState = 4;
                Score.currentPlayer = 0;
            }
        } else {
            Score.gameState = this.nGameState;
        }
        Score.save();
    }

    protected void loadRMS() {
        Score.load();
        int n = 0;
        while (n < 28) {
            this.m_byBoard[n] = Score.board[n];
            ++n;
        }
        int n2 = 0;
        while (n2 < 4) {
            this.nRandDice[n2] = Score.dice[n2];
            ++n2;
        }
        this.nCurrentPlayer = Score.currentPlayer;
        this.nGameState = Score.gameState;
        this.blnPlayComputer = Score.blnPlayComputer;
        this.nCurrentDoubleAuthority = Score.nDoubleAuthority;
        this.nCurrentBetMoney = Score.nCurrentBetMoney;
        switch (this.nGameState) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                Score.nContinueFlag = 0;
                break;
            }
            default: {
                this.blnRollDicePlayer1 = true;
                this.blnRollDicePlayer2 = true;
            }
        }
        if (Score.nContinueFlag == 2) {
            Score.nContinueFlag = 1;
        }
    }

    protected void runComputerAI() {
        byte[] byArray = new byte[2];
        this.nPoint = -10000;
        byArray[0] = (byte)this.nRandDice[0];
        byArray[1] = (byte)this.nRandDice[1];
        int n = 0;
        while (n < 28) {
            this.m_byTmpBoard2[n] = this.m_byBoard[n];
            ++n;
        }
        this.m_nMoveCount = 0;
        this.getAllMoves(1, this.m_byBoard, byArray);
        if (this.m_nMoveCount == 0) {
            this.nPlayComCheckerMax = -1;
        } else {
            int n2 = 0;
            while (n2 < this.m_nMoveCount) {
                this.nPlayComFromX[n2] = this.m_byMoves[n2][0];
                this.nPlayComToX[n2] = this.m_byMoves[n2][0] - this.m_byMoves[n2][1];
                this.makeMoveChecker(1, this.m_byBoard, this.m_byMoves[n2]);
                this.setPlayComCheckerDrawPosition(this.m_byBoard, this.m_byMoves[n2], n2);
                ++n2;
            }
        }
    }

    protected int getMovedPositionPoint(byte[] byArray, byte[][] byArray2) {
        int n;
        int n2;
        int n3 = 0;
        int n4 = byArray2.length;
        int n5 = 0;
        while (n5 < 28) {
            this.m_byTmpBoard[n5] = byArray[n5];
            ++n5;
        }
        int n6 = 0;
        while (n6 < n4) {
            n2 = byArray2[n6][0];
            if (n2 != 24) {
                int n7 = n2;
                this.m_byTmpBoard[n7] = (byte)(this.m_byTmpBoard[n7] + 1);
            }
            if ((n = n2 - byArray2[n6][1]) <= -1) {
                n3 += 5000;
                if (this.m_byTmpBoard[n2] == -1) {
                    n5 = 0;
                    while (n5 < n2) {
                        if (this.m_byTmpBoard[n5] > 0) {
                            n3 -= 5000;
                        }
                        ++n5;
                    }
                }
            } else if (this.m_byTmpBoard[n] == 1) {
                this.m_byTmpBoard[n] = -1;
                n3 = this.getPlayerPositionPoint(1, this.m_byTmpBoard) - this.getPlayerPositionPoint(0, this.m_byTmpBoard) > 70 ? (n3 += 1000) : (n < 6 ? (n3 += 100) : (n3 += 500));
            } else {
                int n8 = n;
                this.m_byTmpBoard[n8] = (byte)(this.m_byTmpBoard[n8] - 1);
            }
            ++n6;
        }
        n6 = 0;
        while (n6 < n4) {
            n2 = byArray2[n6][0];
            n = n2 - byArray2[n6][1];
            if (n > -1) {
                n3 += this.getNextPositionPoint(n);
                n3 += this.getCheckerCountPoint(Math.abs(this.m_byTmpBoard[n]));
                if (Math.abs(this.m_byTmpBoard[n]) >= 2 && n <= 5) {
                    n3 -= 1000;
                }
            }
            if (n2 != 24 && this.m_byTmpBoard[n2] == -1) {
                n3 = n2 < 7 ? (this.m_byTmpBoard[24] > 0 ? (n3 -= 3000) : (n3 -= 2000)) : (n2 >= 18 ? (n3 += 300) : (n3 -= 500));
            }
            if (n2 != 24 && n2 >= 18 && this.m_byTmpBoard[n2] == 0) {
                n3 += 200;
            }
            ++n6;
        }
        return n3;
    }

    protected int getNextPositionPoint(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                return 100;
            }
            case 3: {
                return 200;
            }
            case 4: 
            case 6: {
                return 300;
            }
            case 5: {
                return 100;
            }
            case 15: 
            case 17: {
                return 0;
            }
        }
        return 0;
    }

    protected int getCheckerCountPoint(int n) {
        switch (n) {
            case 1: {
                return -300;
            }
            case 2: {
                return 1300;
            }
            case 3: {
                return 300;
            }
            case 4: {
                return 200;
            }
            case 5: 
            case 6: {
                return 100;
            }
        }
        return 0;
    }

    protected int getPlayerPositionPoint(int n, byte[] byArray) {
        int n2 = 0;
        if (n == 0) {
            int n3 = 0;
            while (n3 < 24) {
                if (byArray[n3] > 0) {
                    n2 += byArray[n3] * (24 - n3);
                }
                ++n3;
            }
        } else {
            int n4 = 0;
            while (n4 < 24) {
                if (byArray[n4] < 0) {
                    n2 += Math.abs(byArray[n4]) * (n4 + 1);
                }
                ++n4;
            }
        }
        if (byArray[24 + n] > 0) {
            n2 += 24 * byArray[24 + n];
        }
        return n2;
    }

    protected void getAllMoves(int n, byte[] byArray, byte[] byArray2) {
        if (byArray == null) {
            return;
        }
        if (byArray2 != null) {
            if (byArray2.length != 2) {
                return;
            }
        } else {
            return;
        }
        byte[][] byArray3 = new byte[0][0];
        this.getAllMoves2(n, byArray, byArray, byArray2, byArray3);
        if (byArray2[0] != byArray2[1]) {
            byte[] byArray4 = new byte[]{byArray2[1], byArray2[0]};
            this.getAllMoves2(n, byArray, byArray, byArray4, byArray3);
        }
    }

    protected void getAllMoves2(int n, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[][] byArray4) {
        if (this.verifyMove(n, byArray, byArray3, byArray4)) {
            this.nPointTemp = this.getMovedPositionPoint(byArray, byArray4);
            if (this.nPointTemp > this.nPoint) {
                this.nPoint = this.nPointTemp;
                this.m_nMoveCount = 0;
                int n2 = 0;
                while (n2 < byArray4.length) {
                    ++this.m_nMoveCount;
                    int n3 = 0;
                    while (n3 < 2) {
                        this.m_byMoves[n2][n3] = byArray4[n2][n3];
                        ++n3;
                    }
                    ++n2;
                }
            }
            return;
        }
        if (byArray3[0] == byArray3[1] ? byArray4.length == 4 : byArray4.length == 2) {
            return;
        }
        byte[][] byArray5 = new byte[byArray4.length + 1][2];
        int n4 = byArray4.length;
        System.arraycopy(byArray4, 0, byArray5, 0, byArray4.length);
        int n5 = byArray5.length - 1;
        byArray5[n5][1] = byArray4.length == 0 ? byArray3[0] : byArray3[1];
        byte[] byArray6 = new byte[28];
        int n6 = 24;
        while (n6 > -2) {
            byArray5[n5][0] = (byte)n6;
            if (this.verifySingleMove(n, byArray2, byArray5[n5])) {
                int n7 = 0;
                while (n7 < 28) {
                    byArray6[n7] = byArray2[n7];
                    ++n7;
                }
                this.makeMoveChecker(n, byArray6, byArray5[n5]);
                this.getAllMoves2(n, byArray, byArray6, byArray3, byArray5);
            }
            --n6;
        }
    }

    public void initializeBoard() {
        int n = 0;
        while (n < 24) {
            this.m_byBoard[n] = initialBoard[n];
            ++n;
        }
        n = 0;
        while (n < 2) {
            this.m_byBoard[24 + n] = 0;
            this.m_byBoard[26 + n] = 0;
            ++n;
        }
    }

    protected boolean verifySingleMove(int n, byte[] byArray, byte[] byArray2) {
        byte by = n == 0 ? (byte)(byArray2[0] + byArray2[1]) : (byte)(byArray2[0] - byArray2[1]);
        byte by2 = byArray2[0];
        if (byArray[24 + n] > 0) {
            if (n == 0 ? by2 != -1 : by2 != 24) {
                return false;
            }
        } else {
            if (by2 == -1 || by2 == 24) {
                return false;
            }
            if (n == 0 && byArray[by2] <= 0 || n == 1 && byArray[by2] >= 0) {
                return false;
            }
        }
        if (by < -1) {
            if (!this.isAllInHome(n, byArray)) {
                return false;
            }
            int n2 = by2 + 1;
            while (n2 < 6) {
                if (byArray[n2] < 0) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
        if (by > 24) {
            if (!this.isAllInHome(n, byArray)) {
                return false;
            }
            int n3 = by2 - 1;
            while (n3 > 18) {
                if (byArray[n3] > 0) {
                    return false;
                }
                --n3;
            }
            return true;
        }
        return !(by == -1 || by == 24 ? !this.isAllInHome(n, byArray) : (n == 0 ? byArray[by] < -1 : byArray[by] > 1));
    }

    protected boolean makeMoveChecker(int n, byte[] byArray, byte[] byArray2) {
        byte by = byArray2[0];
        byte by2 = n == 0 ? (byte)(by + byArray2[1]) : (byte)(by - byArray2[1]);
        this.makeMoveChecker(n, byArray, by, by2);
        return true;
    }

    protected boolean makeMoveChecker(int n, byte[] byArray, byte by, byte by2) {
        if (by2 == 110) {
            if (by == 24) {
                int n2 = 24 + n;
                byArray[n2] = (byte)(byArray[n2] - 1);
                return true;
            }
            byte by3 = by;
            byArray[by3] = (byte)(byArray[by3] + 1);
            return true;
        }
        if (by2 <= -1 || by2 >= 24) {
            by2 = (byte)100;
        }
        if (by == 110) {
            if (by2 == 100) {
                int n3 = 26 + n;
                byArray[n3] = (byte)(byArray[n3] + 1);
                return true;
            }
            if (byArray[by2] <= 0) {
                byte by4 = by2;
                byArray[by4] = (byte)(byArray[by4] - 1);
            } else {
                byArray[by2] = -1;
            }
            return true;
        }
        if (by2 == 100) {
            int n4 = 26 + n;
            byArray[n4] = (byte)(byArray[n4] + 1);
            if (n == 0) {
                byte by5 = by;
                byArray[by5] = (byte)(byArray[by5] - 1);
            } else {
                byte by6 = by;
                byArray[by6] = (byte)(byArray[by6] + 1);
            }
            return true;
        }
        if (n == 0) {
            if (by >= 0 && by < 24) {
                byte by7 = by;
                byArray[by7] = (byte)(byArray[by7] - 1);
            } else {
                byArray[24] = (byte)(byArray[24] - 1);
            }
            if (byArray[by2] >= 0) {
                byte by8 = by2;
                byArray[by8] = (byte)(byArray[by8] + 1);
            } else {
                byArray[25] = (byte)(byArray[25] + 1);
                byArray[by2] = 1;
            }
        } else {
            if (by >= 0 && by < 24) {
                byte by9 = by;
                byArray[by9] = (byte)(byArray[by9] + 1);
            } else {
                byArray[25] = (byte)(byArray[25] - 1);
            }
            if (byArray[by2] <= 0) {
                byte by10 = by2;
                byArray[by10] = (byte)(byArray[by10] - 1);
            } else {
                byArray[24] = (byte)(byArray[24] + 1);
                byArray[by2] = -1;
            }
        }
        return true;
    }

    protected boolean isAllInHome(int n, byte[] byArray) {
        if (byArray[24 + n] > 0) {
            return false;
        }
        if (n == 0) {
            int n2 = 0;
            while (n2 < 18) {
                if (byArray[n2] > 0) {
                    return false;
                }
                ++n2;
            }
        } else {
            int n3 = 6;
            while (n3 < 24) {
                if (byArray[n3] < 0) {
                    return false;
                }
                ++n3;
            }
        }
        return true;
    }

    protected boolean existsSingleMove(int n, byte[] byArray, byte by) {
        byte[] byArray2 = new byte[2];
        if (byArray[24 + n] > 0) {
            byArray2[0] = n == 0 ? -1 : 24;
            byArray2[1] = by;
            return this.verifySingleMove(n, byArray, byArray2);
        }
        int n2 = 0;
        while (n2 < 24) {
            if (n == 0 && byArray[n2] > 0 || n == 1 && byArray[n2] < 0) {
                byArray2[0] = (byte)n2;
                byArray2[1] = by;
                if (this.verifySingleMove(n, byArray, byArray2)) {
                    return true;
                }
            }
            ++n2;
        }
        return false;
    }

    protected boolean existsSingleMove(int n, byte[] byArray, byte[] byArray2) {
        if (this.existsSingleMove(n, byArray, byArray2[0])) {
            return true;
        }
        return this.existsSingleMove(n, byArray, byArray2[1]);
    }

    protected boolean existsMove2(int n, byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = new byte[28];
        byte[] byArray4 = new byte[2];
        byte[] byArray5 = new byte[2];
        byArray4[1] = byArray2[0];
        byArray5[1] = byArray2[1];
        int n2 = -1;
        while (n2 < 25) {
            byArray4[0] = (byte)n2;
            if (this.verifySingleMove(n, this.m_byBoard, byArray4)) {
                int n3 = 0;
                while (n3 < 28) {
                    byArray3[n3] = this.m_byBoard[n3];
                    ++n3;
                }
                this.makeMoveChecker(n, byArray3, byArray4);
                n3 = -1;
                while (n3 < 25) {
                    byArray5[0] = (byte)n3;
                    if (this.verifySingleMove(n, byArray3, byArray5)) {
                        return true;
                    }
                    ++n3;
                }
            }
            ++n2;
        }
        return false;
    }

    protected boolean existsMove(int n, byte[] byArray, byte[] byArray2) {
        if (this.existsMove2(n, byArray, byArray2)) {
            return true;
        }
        if (byArray2[0] != byArray2[1]) {
            byte[] byArray3 = new byte[]{byArray2[1], byArray2[0]};
            if (this.existsMove2(n, byArray, byArray3)) {
                return true;
            }
        }
        return false;
    }

    public String toString(byte[] byArray) {
        String string = "Bar: " + byArray[24] + " , " + byArray[25] + "\n" + "Out: " + byArray[26] + " , " + byArray[27] + "\n";
        String string2 = "";
        int n = 0;
        while (n < 24) {
            string2 = string2 + byArray[n] + " : ";
            ++n;
        }
        string = string + string2 + "\n";
        return string;
    }

    protected boolean verifyMove(int n, byte[] byArray, byte[] byArray2, byte[][] byArray3) {
        byte[] byArray4 = this.getOrderedDices(n, byArray2, byArray3);
        if (byArray4.length != 2) {
            return false;
        }
        byte[] byArray5 = new byte[28];
        int n2 = 0;
        while (n2 < 28) {
            byArray5[n2] = byArray[n2];
            ++n2;
        }
        int n3 = 0;
        while (n3 >= 0) {
            switch (n3) {
                case 0: {
                    if (byArray3.length == 0) {
                        n3 = 1;
                        break;
                    }
                    n3 = 2;
                    break;
                }
                case 1: {
                    if (this.existsSingleMove(n, byArray5, byArray4)) {
                        return false;
                    }
                    return false;
                }
                case 2: {
                    if (this.verifySingleMove(n, byArray5, byArray3[0])) {
                        this.makeMoveChecker(n, byArray5, byArray3[0]);
                        n3 = 3;
                        break;
                    }
                    n3 = 4;
                    break;
                }
                case 3: {
                    if (byArray3.length < 2) {
                        n3 = 5;
                        break;
                    }
                    n3 = 6;
                    break;
                }
                case 4: {
                    if (this.verifyBearOff(n, byArray5, byArray3[0])) {
                        this.makeMoveChecker(n, byArray5, byArray3[0]);
                        n3 = 3;
                        break;
                    }
                    return false;
                }
                case 5: {
                    if (this.existsMove(n, byArray5, byArray4)) {
                        return false;
                    }
                    n3 = 7;
                    break;
                }
                case 6: {
                    if (this.verifySingleMove(n, byArray5, byArray3[1])) {
                        this.makeMoveChecker(n, byArray5, byArray3[1]);
                        n3 = 8;
                        break;
                    }
                    n3 = 9;
                    break;
                }
                case 7: {
                    if (byArray4[0] >= byArray4[1]) {
                        return true;
                    }
                    n3 = 10;
                    break;
                }
                case 8: {
                    if (byArray4[0] == byArray4[1]) {
                        n3 = 11;
                        break;
                    }
                    return true;
                }
                case 9: {
                    if (this.verifyBearOff(n, byArray5, byArray3[1])) {
                        this.makeMoveChecker(n, byArray5, byArray3[1]);
                        n3 = 8;
                        break;
                    }
                    return false;
                }
                case 10: {
                    return !this.existsSingleMove(n, byArray5, byArray4[1]);
                }
                case 11: {
                    if (byArray3.length >= 3) {
                        n3 = 13;
                        break;
                    }
                    n3 = 12;
                    break;
                }
                case 12: {
                    return !this.existsSingleMove(n, byArray5, byArray4[0]);
                }
                case 13: {
                    if (this.verifySingleMove(n, byArray5, byArray3[2])) {
                        this.makeMoveChecker(n, byArray5, byArray3[2]);
                        n3 = 14;
                        break;
                    }
                    n3 = 15;
                    break;
                }
                case 14: {
                    if (byArray3.length == 4) {
                        n3 = 17;
                        break;
                    }
                    n3 = 16;
                    break;
                }
                case 15: {
                    if (this.verifyBearOff(n, byArray5, byArray3[2])) {
                        this.makeMoveChecker(n, byArray5, byArray3[2]);
                        n3 = 14;
                        break;
                    }
                    return false;
                }
                case 16: {
                    return !this.existsSingleMove(n, byArray5, byArray4[1]);
                }
                case 17: {
                    if (this.verifySingleMove(n, byArray5, byArray3[3])) {
                        return true;
                    }
                    n3 = 18;
                    break;
                }
                case 18: {
                    return this.verifyBearOff(n, byArray5, byArray3[3]);
                }
                default: {
                    return false;
                }
            }
        }
        return false;
    }

    protected byte[] getOrderedDices(int n, byte[] byArray, byte[][] byArray2) {
        if (byArray.length != 2) {
            return new byte[0];
        }
        byte[] byArray3 = new byte[2];
        if (byArray2.length > 0) {
            if (byArray[0] == byArray2[0][1]) {
                byArray3[0] = byArray[0];
                byArray3[1] = byArray[1];
            } else if (byArray[1] == byArray2[0][1]) {
                byArray3[0] = byArray[1];
                byArray3[1] = byArray[0];
            } else {
                return new byte[0];
            }
            if (byArray2.length > 1) {
                int n2 = 1;
                while (n2 < byArray2.length) {
                    if (byArray3[1] != byArray2[n2][1]) {
                        return new byte[0];
                    }
                    ++n2;
                }
            }
        } else {
            byArray3[0] = byArray[0];
            byArray3[1] = byArray[1];
        }
        return byArray3;
    }

    protected boolean verifyBearOff(int n, byte[] byArray, byte[] byArray2) {
        return false;
    }

    protected void drawBetAnimation(Graphics graphics) {
        this.drawBetBoard(graphics);
        this.drawCurrentDoubldBetGold(graphics);
        this.drawGolds(graphics, this.nCurrentBetMoney, 48, 86, false);
        int n = this.blnRollDicePlayer1 && this.blnRollDicePlayer2 ? Score.nTotalMoney[this.nPlayer2CharacterID] : this.nOtherMoney;
        int n2 = this.blnRollDicePlayer1 && this.blnRollDicePlayer2 ? Score.nTotalMoney[0] : this.nUserMoney;
        this.drawGolds(graphics, n, 72, 13, true);
        this.drawGolds(graphics, n2, 72, 157, false);
        this.drawGoldsToNumber(graphics, n, 72, 5);
        this.drawGoldsToNumber(graphics, n2, 72, 163);
    }

    protected void drawBackgammonAnimation(Graphics graphics) {
        this.drawBetBoard(graphics);
        if (this.nCurrentPlayer == 0) {
            this.drawGolds(graphics, this.nCurrentDoubleBetMoney, 48, 13 + this.nBetAniFrame * 6, true);
        } else {
            this.drawGolds(graphics, this.nCurrentDoubleBetMoney, 48, 157 - this.nBetAniFrame * 6, false);
        }
        this.drawGolds(graphics, this.nCurrentBetMoney, 48, 86, false);
        this.drawBetBoardPlayersGolds(graphics);
    }

    protected void drawGetGoldsAnimation(Graphics graphics) {
        this.drawBetBoard(graphics);
        if (this.nCurrentPlayer == 0) {
            this.drawGolds(graphics, this.nCurrentBetMoney, 48, 78 + this.nBetAniFrame * 6, false);
        } else {
            this.drawGolds(graphics, this.nCurrentBetMoney, 48, 78 - this.nBetAniFrame * 6, true);
        }
        this.drawBetBoardPlayersGolds(graphics);
    }

    protected void drawBetBoardPlayersGolds(Graphics graphics) {
        this.drawGolds(graphics, this.nOtherMoney, 72, 13, true);
        this.drawGolds(graphics, this.nUserMoney, 72, 157, false);
        this.drawGoldsToNumber(graphics, this.nOtherMoney, 72, 5);
        this.drawGoldsToNumber(graphics, this.nUserMoney, 72, 163);
    }

    protected void drawBetBoard(Graphics graphics) {
        int n = 0;
        int n2 = 0;
        graphics.setColor(26112);
        graphics.fillRect(n, n2, 77, 175);
        graphics.drawImage(this.image[28], n + 38, 83, 3);
        graphics.drawImage(this.image[37], n, n2, 20);
        graphics.drawImage(this.image[40], n, n2 + 4, 20);
        graphics.drawImage(this.image[38], n + 77 - 5, n2 + 4, 20);
        graphics.drawImage(this.image[39], n, n2 + 171, 20);
    }

    protected void drawGolds(Graphics graphics, int n, int n2, int n3, boolean bl) {
        String string = String.valueOf(n);
        int n4 = string.length();
        int n5 = n2;
        int n6 = n4 - 1;
        while (n6 >= 0) {
            int n7 = string.charAt(n6) - 48;
            if (n7 != 0) {
                int n8;
                int n9;
                n5 -= this.image[32 + n6 + (5 - n4)].getWidth() + 2;
                if (this.image[32 + n6 + (5 - n4)].getWidth() > 6) {
                    n9 = 3;
                    n8 = n3 - 2;
                } else {
                    n9 = 2;
                    n8 = n3;
                }
                if (bl) {
                    n8 += n7 * n9;
                }
                int n10 = 0;
                while (n10 < n7) {
                    graphics.drawImage(this.image[32 + n6 + (5 - n4)], n5, n8 - n10 * n9, 20);
                    ++n10;
                }
            }
            --n6;
        }
    }

    protected void drawGoldsToNumber(Graphics graphics, int n, int n2, int n3) {
        String string = String.valueOf(n);
        int n4 = string.length();
        int n5 = n2 - n4 * 6;
        int n6 = 0;
        while (n6 < n4) {
            int n7 = string.charAt(n6) - 48;
            this.drawClipImage(graphics, n5 + n6 * 6, n3, this.image[41], n7 * 4, 0, 4, 6, 20);
            ++n6;
        }
    }

    protected void drawCurrentDoubldBetGold(Graphics graphics) {
        this.drawGolds(graphics, this.nCurrentDoubleBetMoney, 48, 13 + this.nBetAniFrame * 8, true);
        this.drawGolds(graphics, this.nCurrentDoubleBetMoney, 48, 157 - this.nBetAniFrame * 8, false);
    }

    protected boolean verifyDouble() {
        if (this.nCurrentPlayer == 1 && this.nCurrentDoubleAuthority != 0 && Score.nTotalMoney[this.nPlayer2CharacterID] >= this.nCurrentBetMoney / 2) {
            if (this.nCurrentBetMoney >= 128) {
                return false;
            }
            if (this.getPlayerPositionPoint(0, this.m_byTmpBoard) - this.getPlayerPositionPoint(1, this.m_byTmpBoard) > 20) {
                return true;
            }
        } else if (this.nCurrentPlayer == 0 && this.getPlayerPositionPoint(0, this.m_byTmpBoard) - this.getPlayerPositionPoint(1, this.m_byTmpBoard) > -30) {
            return true;
        }
        return false;
    }

    protected void replyDouble(int n) {
        switch (n) {
            case 49: {
                this.doDouble();
                break;
            }
            case 50: {
                this.blnForfeitLose = true;
                this.setCurrentGameState(12);
            }
        }
        this.repaint();
    }

    protected void doDouble() {
        this.nBetAniFrame = 0;
        this.nCurrentDoubleBetMoney = this.nCurrentBetMoney / 2;
        Score.nTotalMoney[0] = Score.nTotalMoney[0] - this.nCurrentDoubleBetMoney;
        int n = this.nPlayer2CharacterID;
        Score.nTotalMoney[n] = Score.nTotalMoney[n] - this.nCurrentDoubleBetMoney;
        this.setCurrentGameState(14);
        this.playSound(8);
        this.nCurrentDoubleAuthority = this.nCurrentPlayer == 0 ? 1 : 0;
    }

    protected void doCheetDice() {
        ++this.nTurn;
        if (this.m_byBoard[25] > 0 && Math.abs(this.rndRandom.nextInt()) % 8 < 5) {
            int n = 18;
            while (n < 24) {
                if (this.m_byBoard[n] == 1) {
                    this.nRandDice[0] = 24 - n;
                    break;
                }
                ++n;
            }
            if (this.nRandDice[0] == this.nRandDice[1]) {
                this.nRandDice[2] = this.nRandDice[0];
                this.nRandDice[3] = this.nRandDice[0];
            } else {
                this.nRandDice[2] = -1;
                this.nRandDice[3] = -1;
            }
        }
        if (this.isAllInHome(0, this.m_byBoard) && this.isAllInHome(1, this.m_byBoard) && this.rndRandom.nextInt() % 6 < 3 && this.nRandDice[0] < 3) {
            this.nRandDice[0] = Math.abs(this.rndRandom.nextInt()) % 6 + 1;
            if (this.nRandDice[0] == this.nRandDice[1]) {
                this.nRandDice[2] = this.nRandDice[0];
                this.nRandDice[3] = this.nRandDice[0];
            } else {
                this.nRandDice[2] = -1;
                this.nRandDice[3] = -1;
            }
        }
    }

    protected void drawPlayOptions(Graphics graphics) {
        this.drawMenuBG(graphics);
        this.drawPlayOptionsString(graphics);
    }

    protected void drawPlayOptionsString(Graphics graphics) {
        int n = (this.VIEW_HEIGHT - TITLE_OPTIONS_PLAY.length * 20) / 2;
        graphics.setFont(this.FONT_MEDIUM_BOLD);
        graphics.setColor(0);
        int n2 = 0;
        while (n2 < TITLE_OPTIONS_PLAY.length) {
            graphics.drawString(TITLE_OPTIONS_PLAY[n2], 88, n + n2 * 20 - 4, 17);
            ++n2;
        }
        graphics.setColor(30080);
        graphics.fillRect(0, n + this.nPlayOptionsIndex * 20 - 4, 176, 20);
        graphics.setColor(0xFFFFFF);
        graphics.drawString(TITLE_OPTIONS_PLAY[this.nPlayOptionsIndex], 88, n + this.nPlayOptionsIndex * 20 - 4, 17);
    }

    protected void GO_Options_Play() {
        this.nPlayOptionsIndex = 0;
        this.setCurrentState(12);
        this.repaint();
    }

    protected void keyPressed_Options_Play(int n) {
        this.nKeyCode = this.getKeyDirection(n);
        this.nKeyState = 1;
        switch (this.nKeyCode) {
            case 1: {
                --this.nPlayOptionsIndex;
                if (this.nPlayOptionsIndex >= 0) break;
                this.nPlayOptionsIndex = TITLE_OPTIONS_PLAY.length - 1;
                break;
            }
            case 6: {
                ++this.nPlayOptionsIndex;
                if (this.nPlayOptionsIndex < TITLE_OPTIONS_PLAY.length) break;
                this.nPlayOptionsIndex = 0;
                break;
            }
            case 8: {
                this.callBack(TITLE_OPTIONS_PLAY[this.nPlayOptionsIndex]);
            }
        }
        this.repaint();
    }

    protected void drawOptions(Graphics graphics) {
        this.drawMenuBG(graphics);
        this.drawOptionsString(graphics);
    }

    protected void drawOptionsString(Graphics graphics) {
        String[] stringArray = null;
        int n = 0;
        switch (Score.nContinueFlag) {
            case 0: {
                stringArray = TITLE_OPTIONS;
                n = this.nTitleOptionsIndex;
                break;
            }
            case 1: {
                stringArray = TITLE_OPTIONS_CONTINUE;
                n = this.nContinueOptionsIndex;
                break;
            }
            case 2: {
                stringArray = TITLE_OPTIONS_GAME;
                n = this.nGameOptionsIndex;
                break;
            }
            case 3: {
                stringArray = TITLE_OPTIONS_PLAY;
                n = this.nPlayOptionsIndex;
            }
        }
        int n2 = (this.VIEW_HEIGHT - stringArray.length * 20) / 2;
        graphics.setFont(this.FONT_MEDIUM_BOLD);
        graphics.setColor(0);
        int n3 = 0;
        while (n3 < stringArray.length) {
            graphics.drawString(stringArray[n3], 88, n2 + n3 * 20 - 4, 17);
            ++n3;
        }
        graphics.setColor(30080);
        graphics.fillRect(0, n2 + n * 20 - 4, 176, 20);
        graphics.setColor(0xFFFFFF);
        graphics.drawString(stringArray[n], 88, n2 + n * 20 - 4, 17);
    }

    protected void GO_Options() {
        this.stopSound();
        this.setCurrentState(11);
        this.repaint();
    }

    protected void keyPressed_Options(int n) {
        this.nKeyCode = this.getKeyDirection(n);
        this.nKeyState = 1;
        if (Score.nContinueFlag == 0) {
            switch (this.nKeyCode) {
                case 1: {
                    --this.nTitleOptionsIndex;
                    if (this.nTitleOptionsIndex >= 0) break;
                    this.nTitleOptionsIndex = TITLE_OPTIONS.length - 1;
                    break;
                }
                case 6: {
                    ++this.nTitleOptionsIndex;
                    if (this.nTitleOptionsIndex < TITLE_OPTIONS.length) break;
                    this.nTitleOptionsIndex = 0;
                    break;
                }
                case 8: {
                    this.callBack(TITLE_OPTIONS[this.nTitleOptionsIndex]);
                }
            }
        } else if (Score.nContinueFlag == 1) {
            switch (this.nKeyCode) {
                case 1: {
                    --this.nContinueOptionsIndex;
                    if (this.nContinueOptionsIndex >= 0) break;
                    this.nContinueOptionsIndex = TITLE_OPTIONS_CONTINUE.length - 1;
                    break;
                }
                case 6: {
                    ++this.nContinueOptionsIndex;
                    if (this.nContinueOptionsIndex < TITLE_OPTIONS_CONTINUE.length) break;
                    this.nContinueOptionsIndex = 0;
                    break;
                }
                case 8: {
                    this.callBack(TITLE_OPTIONS_CONTINUE[this.nContinueOptionsIndex]);
                }
            }
        } else {
            switch (this.nKeyCode) {
                case 1: {
                    --this.nGameOptionsIndex;
                    if (this.nGameOptionsIndex >= 0) break;
                    this.nGameOptionsIndex = TITLE_OPTIONS_GAME.length - 1;
                    break;
                }
                case 6: {
                    ++this.nGameOptionsIndex;
                    if (this.nGameOptionsIndex < TITLE_OPTIONS_GAME.length) break;
                    this.nGameOptionsIndex = 0;
                    break;
                }
                case 8: {
                    this.callBack(TITLE_OPTIONS_GAME[this.nGameOptionsIndex]);
                }
            }
        }
        this.repaint();
    }

    protected void drawAbout(Graphics graphics) {
        this.drawMenuBG(graphics);
        this.drawMessageBox(graphics, 0);
        this.drawTextInMessageBox(graphics, "About", 0, true);
        graphics.drawImage(this.image[2], 88, 112, 3);
    }

    private void drawInstructions(Graphics graphics) {
        int n = this.nInstructionsIndex * (this.FONT_SMALL.getHeight() + 1);
        int n2 = 156 / this.FONT_SMALL.getHeight();
        this.drawMenuBG(graphics);
        this.drawMessageBox(graphics, 0);
        this.drawTextInMessageBox(graphics, "Instructions", 0, true);
        graphics.setFont(this.FONT_SMALL);
        this.drawScrollBar(graphics, this.VIEW_HEIGHT - 27, 8, this.nInstructionsIndex, this.nInstructionsIndex + n2, this.nInstructionsLength, 0, 0xC0C0C0, 15169);
        graphics.setColor(0);
        graphics.setClip(0, 31, 166, this.VIEW_HEIGHT);
        Main.drawStringArray(graphics, 31, this.VIEW_HEIGHT, this.FONT_SMALL, this.arrInstructionsText, 2, 31 - n, 20);
    }

    public static String[] getStringArray(Font font, String string, int n) {
        String[] stringArray;
        int n2 = string.length();
        int n3 = font.stringWidth(string) / n * 3;
        if (n3 < 5) {
            n3 = 5;
        }
        String[] stringArray2 = new String[n3];
        boolean bl = false;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = string.indexOf(38);
        if (-1 == n8) {
            n8 = n2;
        }
        do {
            if (-1 == (n6 = string.indexOf(32, n6 + 1))) {
                n6 = n2;
            } else {
                int n9;
                n7 = string.indexOf(32, n6 + 1);
                if (-1 == n7) {
                    n7 = n2;
                }
                if (n8 != n2 && (n9 = string.indexOf(38, n6 + 1)) < n7) {
                    n7 = n9;
                }
            }
            if (n8 <= n6) {
                bl = true;
                n6 = n8;
                if (-1 == (n8 = string.indexOf(38, n8 + 1))) {
                    n8 = n2;
                }
            }
            if (!bl && n >= font.substringWidth(string, n5, n7 - n5)) continue;
            bl = false;
            if (n < font.substringWidth(string, n5, n6 - n5)) {
                while (n - 10 < font.substringWidth(string, n5, --n6 - n5)) {
                }
                stringArray2[n4] = string.substring(n5, n6) + "-";
                --n6;
            } else {
                stringArray2[n4] = string.substring(n5, n6);
            }
            if (++n4 >= n3) {
                stringArray = new String[n3];
                System.arraycopy(stringArray2, 0, stringArray, 0, n3);
                stringArray2 = new String[n3 *= 2];
                System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
                stringArray = null;
            }
            n5 = ++n6;
        } while (n6 < n2);
        stringArray = new String[n4];
        System.arraycopy(stringArray2, 0, stringArray, 0, n4);
        return stringArray;
    }

    public static int drawStringArray(Graphics graphics, int n, int n2, Font font, String[] stringArray, int n3, int n4, int n5) {
        int n6 = font.getHeight() + 1;
        int n7 = 0;
        while (n7 < stringArray.length) {
            if (n <= n4 && n4 < n2) {
                graphics.drawString(stringArray[n7], n3, n4, n5);
            }
            n4 += n6;
            ++n7;
        }
        return n4;
    }

    private void drawScrollBar(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        int n9 = n * n3 / n5;
        if (n4 > n5) {
            n4 = n5;
        }
        graphics.setColor(n6);
        graphics.fillRect(176 - n2, 27, n2, n);
        graphics.setColor(n7);
        graphics.fillRect(177 - n2, 28, n2 - 2, n - 2);
        graphics.setColor(n8);
        graphics.fillRect(177 - n2, n9 + 28, n2 - 2, n * n4 / n5 - n9 - 2);
    }

    protected void drawSettings(Graphics graphics) {
        this.drawMenuBG(graphics);
        this.drawMessageBox(graphics, 0);
        this.drawTextInMessageBox(graphics, "Settings", 0, true);
        graphics.drawImage(this.image[57 + bySettings[0]], 88, 65, 17);
        graphics.setFont(this.FONT_SMALL_BOLD);
        graphics.setColor(0xFFFFFF);
        graphics.drawString(bySettings[0] == 0 ? "Sound On" : "Sound Off", 88, 130, 17);
    }

    protected void playSound(int n) {
        if (n == 1 || n == 2) {
            return;
        }
        if (bySettings[0] == 0) {
            this.stopSound();
            try {
                if (n == 0 || n == 4 || n == 5) {
                    this.soundInputStream = this.getClass().getResourceAsStream("/Sound/" + n + ".mid");
                    currentSound = Manager.createPlayer((InputStream)this.soundInputStream, (String)"audio/midi");
                } else {
                    this.soundInputStream = this.getClass().getResourceAsStream("/Sound/" + n + ".amr");
                    currentSound = Manager.createPlayer((InputStream)this.soundInputStream, (String)"audio/amr");
                }
                currentSound.addPlayerListener((PlayerListener)this);
                if (currentSound.getState() == 100) {
                    currentSound.realize();
                }
                currentSound.start();
                this.nCurrentSoundIndex = n;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void stopSound() {
        if (this.nCurrentSoundIndex != -1) {
            try {
                currentSound.stop();
                currentSound.removePlayerListener((PlayerListener)this);
                currentSound.close();
                this.nCurrentSoundIndex = -1;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void playerUpdate(Player player, String string, Object object) {
        if (string.equals("endOfMedia")) {
            this.stopSound();
        }
    }

    protected void loadSound(int n) {
    }

    protected void drawMenuBG(Graphics graphics) {
        int n = 204 / this.image[44].getHeight() + 1;
        int n2 = 0;
        while (n2 < n) {
            graphics.drawImage(this.image[44], 88, n2 * this.image[44].getHeight(), 0x10 | 1);
            ++n2;
        }
    }

    public void destroyApp(boolean bl) {
        this.saveRMS();
        this.midlet.notifyDestroyed();
    }
}

