/*
 * Decompiled with CFR 0.152.
 */
package checkers;

import checkers.Board;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class Store {
    private RecordStore record = null;
    int s_moves;
    int s_status;
    int[] s_A;
    int level = 0;
    int noLoad = 0;
    String name;
    String nameL;

    public Store(String name) {
        this.name = name;
    }

    public Store() {
    }

    public Board load() {
        boolean whiteMoves = false;
        boolean singlePlayer = false;
        int[] board = new int[32];
        int[] drawnBoard = new int[32];
        String status = new String();
        try {
            this.record = RecordStore.openRecordStore((String)this.name, (boolean)true);
            ByteArrayInputStream bais = new ByteArrayInputStream(this.record.getRecord(1));
            DataInputStream inputStream = new DataInputStream(bais);
            try {
                int j;
                this.level = inputStream.readInt();
                whiteMoves = inputStream.readBoolean();
                singlePlayer = inputStream.readBoolean();
                int len = inputStream.readInt();
                byte[] str = new byte[len];
                inputStream.read(str, 0, len);
                status = new String(str);
                board = new int[32];
                for (j = 0; j < 32; ++j) {
                    board[j] = inputStream.readInt();
                }
                for (j = 0; j < 32; ++j) {
                    drawnBoard[j] = inputStream.readInt();
                }
                this.record.closeRecordStore();
            }
            catch (EOFException eofe) {
                System.out.println(eofe);
                eofe.printStackTrace();
            }
        }
        catch (RecordStoreException rse) {
            System.out.println((Object)rse);
            rse.printStackTrace();
        }
        catch (IOException ioe) {
            System.out.println(ioe);
            ioe.printStackTrace();
        }
        Board b = Board.instance;
        if (b == null) {
            b = new Board(1, false, 1, board);
        }
        for (int k = 0; k < 32; ++k) {
            b.drawnBoard[k] = drawnBoard[k];
        }
        b.setBoard(board);
        b.gameLevel = this.level;
        b.singlePlayer = singlePlayer;
        b.showGameStatus(status);
        b.whiteMoves = whiteMoves;
        b.gameOver = false;
        return b;
    }

    public void save(int[] board, int[] drawnBoard, boolean whiteMoves, boolean singlePlayer, String status, int _level) {
        byte[] b;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream outputStream = new DataOutputStream(baos);
        try {
            int j;
            outputStream.writeInt(_level);
            outputStream.writeBoolean(whiteMoves);
            outputStream.writeBoolean(singlePlayer);
            b = status.getBytes();
            outputStream.writeInt(b.length);
            ((OutputStream)outputStream).write(b);
            for (j = 0; j < 32; ++j) {
                outputStream.writeInt(board[j]);
            }
            for (j = 0; j < 32; ++j) {
                outputStream.writeInt(drawnBoard[j]);
            }
        }
        catch (IOException ioe) {
            System.out.println("Error ".concat(String.valueOf(String.valueOf(ioe))));
        }
        b = baos.toByteArray();
        try {
            this.record = RecordStore.openRecordStore((String)this.name, (boolean)true);
            this.record.closeRecordStore();
            RecordStore.deleteRecordStore((String)this.name);
            this.record = RecordStore.openRecordStore((String)this.name, (boolean)true);
            this.record.addRecord(b, 0, b.length);
            this.record.closeRecordStore();
        }
        catch (RecordStoreException rse) {
            System.out.println("Error :".concat(String.valueOf(String.valueOf((Object)rse))));
        }
    }

    public boolean isLoad() {
        try {
            this.nameL = "Game 1";
            this.record = RecordStore.openRecordStore((String)this.nameL, (boolean)false);
            this.record.closeRecordStore();
        }
        catch (RecordStoreException rse) {
            ++this.noLoad;
        }
        try {
            this.nameL = "Game 2";
            this.record = RecordStore.openRecordStore((String)this.nameL, (boolean)false);
            this.record.closeRecordStore();
        }
        catch (RecordStoreException rse) {
            ++this.noLoad;
        }
        try {
            this.nameL = "Game 3";
            this.record = RecordStore.openRecordStore((String)this.nameL, (boolean)false);
            this.record.closeRecordStore();
        }
        catch (RecordStoreException rse) {
            ++this.noLoad;
        }
        try {
            this.nameL = "Game 4";
            this.record = RecordStore.openRecordStore((String)this.nameL, (boolean)false);
            this.record.closeRecordStore();
        }
        catch (RecordStoreException rse) {
            ++this.noLoad;
        }
        return this.noLoad < 4;
    }
}

