/*
 * Decompiled with CFR 0.152.
 */
package checkers;

import checkers.CheckersMIDlet;
import checkers.Color;
import checkers.Cursor;
import checkers.Move;
import checkers.Splash;
import com.nokia.mid.sound.Sound;
import com.nokia.mid.ui.FullCanvas;
import java.io.InputStream;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Choice;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.TextField;
import javax.microedition.midlet.MIDlet;

public class Board
extends FullCanvas
implements Runnable {
    public static Board instance = null;
    private volatile Thread gameThread;
    private static final int Red = 0;
    private static final int Blk = 1;
    private static final int NoSquare = -1;
    private static final int xx = -1;
    private static final int AnySquare = -2;
    private static final int RedPawn = 0;
    private static final int BlkPawn = 1;
    private static final int RedKing = 2;
    private static final int BlkKing = 3;
    private static final int NoPiece = 4;
    private static final int SideMask = 1;
    private static final int MaxMoves = 48;
    private static final int BoardSquares = 32;
    private static final int Board = 0;
    private static final int Piece = 1;
    private static final int Normal = 0;
    private static final int Light = 1;
    private static final int Dark = 2;
    private static final int KLight = 35;
    private static final int KShadow = -18;
    private static final int BoardRedR = 204;
    private static final int BoardRedG = 51;
    private static final int BoardRedB = 51;
    private static final int BoardBlkR = 90;
    private static final int BoardBlkG = 90;
    private static final int BoardBlkB = 90;
    private static final int PieceRedR = 255;
    private static final int PieceRedG = 0;
    private static final int PieceRedB = 0;
    private static final int PieceBlkR = 69;
    private static final int PieceBlkG = 69;
    private static final int PieceBlkB = 69;
    private Image osImg;
    private Image scratchImg;
    private Graphics osG;
    private int dragSquare;
    private int dragOffX;
    private int dragOffY;
    private int hilightedSq;
    public int[] board;
    public int[] drawnBoard;
    private Move[][] movesStack;
    private int stackDepth;
    private int wasPiece;
    private int wasSq;
    private boolean pieceOutlineDrawn;
    private int wasOffsetX;
    private int wasOffsetY;
    private int jumpAgainFromThisSq;
    private int boardX;
    private int boardY;
    private int squareSize;
    private int borderWidth;
    private int pieceSize;
    private int innerSize;
    private int crownSize;
    private Choice skillChoice;
    private TextField statusText;
    private int stableSkillLevel;
    private static final int Margin = 15;
    private static final int ControlMargin = 20;
    static final String DF_TITLE = "Checkers";
    static final String DF_NEWGAME = "New Game";
    static final String DF_FIRST = "First Move";
    static final String DF_LEVEL = "Level";
    static final String DF_L1 = " 1";
    static final String DF_L2 = " 2";
    static final String DF_L3 = " 3";
    static final String DF_L4 = " 4";
    static final String DF_L5 = " 5";
    static final String DF_L6 = " 6";
    static final String DF_L7 = " 7";
    static final String DF_L8 = " 8";
    static final String DF_L9 = " 9";
    static final String DF_L10 = " 10";
    static final String DF_WIN = " You win !";
    static final String DF_LOSE = " I win !";
    static final String DF_YOUR_MOVE = " Your move.";
    static final String DF_JUMP_AGAIN = " Jump again !";
    static final String DF_MUST_JUMP = " Gotta jump !";
    static final String DF_THINKING = " I'm thinking...";
    private String TITLE;
    private String NEWGAME;
    private String FIRST;
    private String LEVEL;
    private String L1;
    private String L2;
    private String L3;
    private String L4;
    private String L5;
    private String L6;
    private String L7;
    private String L8;
    private String L9;
    private String L10;
    private String WIN;
    private String LOSE;
    private String YOUR_MOVE;
    private String JUMP_AGAIN;
    private String MUST_JUMP;
    private String THINKING;
    private String WHITE_MOVES;
    private String BLACK_MOVES;
    private boolean firstSelection = true;
    private int selectedI = -1;
    private int selectedJ = -1;
    private int jumpI = -1;
    private int jumpJ = -1;
    public String gameStatus = "";
    public boolean singlePlayer = false;
    public boolean whiteMoves = true;
    private Image your_move_img;
    private Image thinking;
    private Image jump;
    private Image jump_again;
    private Image i_win;
    private Image you_win;
    private Image statusImg;
    private Image black_win;
    private Image white_win;
    public boolean gameOver = false;
    private static final int[][] validMoves;
    private static final int[][] pieceScore;
    private static final int[][] validCaptures;
    private int[][][] potentialMoves;
    private static final int PawnValue = 200;
    private static final int KingValue = 300;
    private static final int Huge = 9999;
    private static final int RandBits = 0x28424824;
    private int randMask;
    private Color[] colorTable;
    private int sqToRefresh;
    private int[] squaresToHilight;
    private int nSquaresToHilight;
    public int gameMode;
    public int gameLevel;
    private boolean gameSound;
    Image boardImg;
    Image whitePuck;
    Image blackPuck;
    Image whiteKing;
    Image blackKing;
    Image white_moves;
    Image black_moves;
    int ci;
    int cj;
    byte[] bait;
    Sound s;
    Cursor c = new Cursor();

    public Board(int mode, boolean sound, int level, int[] _board) {
        this.c.setDimensions(1, 1, 178, 178);
        Image icon = null;
        try {
            icon = Image.createImage((String)"/Icon.png");
        }
        catch (Exception exception) {
            // empty catch block
        }
        Alert alert = new Alert("Load", "Loading...", icon, AlertType.INFO);
        alert.setTimeout(4000);
        Display.getDisplay((MIDlet)CheckersMIDlet.instance).setCurrent(alert, (Displayable)this);
        instance = this;
        this.gameOver = false;
        this.bait = new byte[4122];
        try {
            InputStream is = this.getClass().getResourceAsStream("/move.wav");
            is.read(this.bait, 0, this.bait.length);
            this.s = new Sound(this.bait, 5);
            this.s.init(this.bait, 5);
        }
        catch (Exception e) {
            System.out.println("Error :".concat(String.valueOf(String.valueOf(e))));
        }
        this.singlePlayer = true;
        if (mode == 2) {
            this.singlePlayer = false;
        }
        this.gameMode = mode;
        this.gameSound = sound;
        this.gameLevel = level;
        this.stableSkillLevel = level;
        this.dragSquare = -1;
        this.hilightedSq = -1;
        this.board = new int[32];
        this.drawnBoard = new int[32];
        this.stackDepth = -1;
        this.pieceOutlineDrawn = false;
        this.potentialMoves = new int[4][32][14];
        this.squaresToHilight = new int[48];
        try {
            this.blackPuck = Image.createImage((String)"/BPuck.png");
            this.whitePuck = Image.createImage((String)"/WPuck.png");
            this.blackKing = Image.createImage((String)"/BKingPuck.png");
            this.whiteKing = Image.createImage((String)"/WKingPuck.png");
            this.your_move_img = Image.createImage((String)"/your_move.png");
            this.thinking = Image.createImage((String)"/thinking.png");
            this.jump = Image.createImage((String)"/jump.png");
            this.jump_again = Image.createImage((String)"/jump_again.png");
            this.i_win = Image.createImage((String)"/i_win.png");
            this.you_win = Image.createImage((String)"/you_win.png");
            this.white_moves = Image.createImage((String)"/white_moves.png");
            this.black_moves = Image.createImage((String)"/black_moves.png");
            this.white_win = Image.createImage((String)"/white_win.png");
            this.black_win = Image.createImage((String)"/black_win.png");
        }
        catch (Exception e) {
            // empty catch block
        }
        this.statusImg = this.singlePlayer ? this.your_move_img : this.white_moves;
        this.cj = 0;
        this.ci = 0;
        try {
            this.boardImg = Image.createImage((String)"/Table.png");
        }
        catch (Exception e) {
            // empty catch block
        }
        if (this.WIN == null) {
            this.WIN = new String(DF_WIN);
        }
        if (this.LOSE == null) {
            this.LOSE = new String(DF_LOSE);
        }
        if (this.YOUR_MOVE == null) {
            this.YOUR_MOVE = new String(DF_YOUR_MOVE);
        }
        if (this.JUMP_AGAIN == null) {
            this.JUMP_AGAIN = new String(DF_JUMP_AGAIN);
        }
        if (this.MUST_JUMP == null) {
            this.MUST_JUMP = new String(DF_MUST_JUMP);
        }
        if (this.THINKING == null) {
            this.THINKING = new String(DF_THINKING);
        }
        if (this.WHITE_MOVES == null) {
            this.WHITE_MOVES = new String(" White moves");
        }
        if (this.BLACK_MOVES == null) {
            this.BLACK_MOVES = new String(" Black moves");
        }
        this.searchInit();
        if (_board == null) {
            for (int i = 0; i < 32; ++i) {
                this.drawnBoard[i] = 4;
            }
            this.newGame();
        } else {
            for (int k = 0; k < 32; ++k) {
                this.board[k] = _board[k];
            }
        }
    }

    public void setBoard(int[] b) {
        this.board = b;
    }

    private void validateMovesStack(int i) {
        if ((i *= 10) > this.stackDepth) {
            this.stackDepth = i;
            this.movesStack = new Move[this.stackDepth][48];
            for (int j = 0; j < this.stackDepth; ++j) {
                for (int k = 0; k < 48; ++k) {
                    this.movesStack[j][k] = new Move();
                }
            }
        }
    }

    public int skillLevel() {
        return this.gameLevel;
    }

    private void playSound() {
        if (this.gameSound) {
            this.s.play(1);
        }
    }

    private final boolean applyMove(Move tgmove) {
        boolean flag = false;
        if (this.board[tgmove.from] == 1 && tgmove.to <= 3) {
            this.board[tgmove.from] = 3;
            flag = true;
        } else if (this.board[tgmove.from] == 0 && tgmove.to >= 28) {
            this.board[tgmove.from] = 2;
            flag = true;
        }
        this.board[tgmove.to] = this.board[tgmove.from];
        this.board[tgmove.from] = 4;
        if (tgmove.captured != -1) {
            this.board[tgmove.captured] = 4;
        }
        this.repaint();
        this.serviceRepaints();
        this.playSound();
        if (this.gameSound) {
            this.snooze(150);
        }
        return flag;
    }

    private static final int coordToSq(int i, int j) {
        if ((j + i & 1) != 0) {
            return (j << 2) + (i - (1 - (j & 1)) >> 1);
        }
        return -1;
    }

    private static final int sqToRow(int i) {
        return i >> 2;
    }

    private static final int sqToCol(int i) {
        return ((i & 3) << 1) + 1 - (checkers.Board.sqToRow(i) & 1);
    }

    private int whichSquare(int i, int j) {
        if (i < this.boardX || i > this.boardX + 8 * this.squareSize || j < this.boardY || j > this.boardY + 8 * this.squareSize) {
            return -1;
        }
        return checkers.Board.coordToSq((i - this.boardX) / this.squareSize, (j - this.boardY) / this.squareSize);
    }

    private int squareX(int i) {
        return checkers.Board.sqToCol(i) * this.squareSize + this.boardX;
    }

    private int squareY(int i) {
        return checkers.Board.sqToRow(i) * this.squareSize + this.boardY;
    }

    private static final int firstDir(int i) {
        return i != 0 ? 0 : 2;
    }

    private static final int lastDir(int i) {
        return i != 1 ? 3 : 1;
    }

    private final int score(int i) {
        return pieceScore[this.board[i]][i];
    }

    private static final boolean differentSide(int i, int j) {
        return ((i ^ j) & 1) != 0;
    }

    private int getListOfMoves(int i, int j, Move[] atgmove) {
        int k = 0;
        boolean flag = false;
        int l = j != -2 ? j : 0;
        int i1 = j != -2 ? l + 1 : 32;
        for (int j1 = l; j1 < i1; ++j1) {
            int k1;
            int l1 = this.board[j1];
            if (l1 == 4 || checkers.Board.differentSide(i, l1)) continue;
            int[] ai = this.potentialMoves[l1][j1];
            int k2 = 0;
            while ((k1 = ai[k2++]) != -1) {
                int j2;
                int i2 = ai[k2++];
                if (this.board[k1] != 4 || (j2 = this.board[i2]) == 4 || !checkers.Board.differentSide(l1, j2)) continue;
                if (!flag) {
                    k = 0;
                    flag = true;
                }
                atgmove[k].from = j1;
                atgmove[k].to = k1;
                atgmove[k].captured = i2;
                ++k;
            }
            if (flag) continue;
            while ((k1 = ai[k2++]) != -1) {
                if (this.board[k1] != 4) continue;
                atgmove[k].from = j1;
                atgmove[k].to = k1;
                atgmove[k].captured = -1;
                ++k;
            }
        }
        return k;
    }

    private boolean pieceCanCaptureAgain(Move tgmove) {
        int j;
        int j1 = 0;
        if (tgmove.captured == -1) {
            return false;
        }
        int i = tgmove.to;
        int k = this.board[i];
        int[] ai = this.potentialMoves[k][i];
        while ((j = ai[j1++]) != -1) {
            int i1;
            int l = ai[j1++];
            if (this.board[j] != 4 || (i1 = this.board[l]) == 4 || !checkers.Board.differentSide(k, i1)) continue;
            return true;
        }
        return false;
    }

    private int searchForBestMove(int i, int j, Move tgmove, int k, int l, int i1) {
        int i2;
        int k3 = 4;
        boolean flag = (this.stableSkillLevel - i & 1) == 0;
        int n = i2 = flag ? -9999 : 9999;
        if (tgmove != null) {
            tgmove.from = -1;
            tgmove.to = -1;
        }
        boolean flag1 = true;
        if (i1 < 0) {
            System.out.println("Checkers internal error:  Moves stack underflow!");
            return i2;
        }
        Move[] atgmove = this.movesStack[i1];
        int k1 = this.getListOfMoves(flag ? 0 : 1, k, atgmove);
        for (int j1 = 0; j1 < k1; ++j1) {
            int j2 = atgmove[j1].from;
            int l2 = atgmove[j1].to;
            int j3 = atgmove[j1].captured;
            int k2 = this.board[j2];
            int i3 = this.board[l2];
            int l1 = j;
            boolean flag2 = false;
            l1 -= this.score(j2);
            if (k2 == 1 && l2 <= 3) {
                this.board[l2] = 3;
                flag2 = true;
            } else if (k2 == 0 && l2 >= 28) {
                this.board[l2] = 2;
                flag2 = true;
            } else {
                this.board[l2] = k2;
            }
            this.board[j2] = 4;
            l1 += this.score(l2);
            if (j3 != -1) {
                k3 = this.board[j3];
                l1 -= this.score(j3);
                this.board[j3] = 4;
            }
            if (j3 != -1 && !flag2 && this.pieceCanCaptureAgain(atgmove[j1])) {
                l1 = this.searchForBestMove(i, l1, null, atgmove[j1].to, i2, i1 - 1);
            } else if (i > 1) {
                l1 = this.searchForBestMove(i - 1, l1, null, -2, i2, i1 - 1);
            }
            if (flag1 || flag && l1 > i2 || !flag && l1 < i2) {
                i2 = l1;
                if (tgmove != null) {
                    tgmove.from = atgmove[j1].from;
                    tgmove.to = atgmove[j1].to;
                    tgmove.captured = atgmove[j1].captured;
                }
                flag1 = false;
            } else if (i2 == l1) {
                this.randMask <<= 1;
                if (this.randMask == 0) {
                    this.randMask = 1;
                }
                if ((0x28424824 & this.randMask) != 0 && tgmove != null) {
                    tgmove.from = atgmove[j1].from;
                    tgmove.to = atgmove[j1].to;
                    tgmove.captured = atgmove[j1].captured;
                }
            }
            this.board[j2] = k2;
            this.board[l2] = i3;
            if (j3 != -1) {
                this.board[j3] = k3;
            }
            if (flag && i2 > l || !flag && i2 < l) break;
        }
        return i2;
    }

    private Move findBestMoveForRed(int i) {
        Move tgmove = new Move();
        this.stableSkillLevel = this.skillLevel();
        this.validateMovesStack(this.stableSkillLevel);
        int k = 0;
        for (int j = 0; j < 32; ++j) {
            if (this.board[j] == 4) continue;
            k += this.score(j);
        }
        int l = this.searchForBestMove(this.stableSkillLevel, k, tgmove, i, 9999, this.stackDepth - 1);
        return tgmove;
    }

    private void searchInit() {
        int i = 0;
        while (i < 32) {
            int[] nArray = pieceScore[0];
            int n = i;
            nArray[n] = nArray[n] + 200;
            int[] nArray2 = pieceScore[2];
            int n2 = i;
            nArray2[n2] = nArray2[n2] + 300;
            int[] nArray3 = pieceScore[1];
            int n3 = i;
            nArray3[n3] = nArray3[n3] + 200;
            int[] nArray4 = pieceScore[3];
            int n4 = i;
            nArray4[n4] = nArray4[n4] + 300;
            int[] nArray5 = pieceScore[1];
            int n5 = i;
            nArray5[n5] = nArray5[n5] * -1;
            int[] nArray6 = pieceScore[3];
            int n6 = i++;
            nArray6[n6] = nArray6[n6] * -1;
        }
        this.randMask = 1 << ((int)System.currentTimeMillis() & 0x1F) - 1;
        for (int k = 0; k < 32; ++k) {
            for (int l = 0; l <= 3; ++l) {
                int j = 0;
                for (int i1 = checkers.Board.firstDir(l); i1 <= checkers.Board.lastDir(l); ++i1) {
                    if (validCaptures[i1][k] == -1) continue;
                    this.potentialMoves[l][k][j++] = validCaptures[i1][k];
                    this.potentialMoves[l][k][j++] = validMoves[i1][k];
                }
                this.potentialMoves[l][k][j++] = -1;
                for (int j1 = checkers.Board.firstDir(l); j1 <= checkers.Board.lastDir(l); ++j1) {
                    if (validMoves[j1][k] == -1) continue;
                    this.potentialMoves[l][k][j++] = validMoves[j1][k];
                }
                this.potentialMoves[l][k][j] = -1;
            }
        }
    }

    public void showGameStatus(String s) {
        this.gameStatus = s;
        if (this.singlePlayer) {
            if (s.equals(this.THINKING)) {
                this.statusImg = this.thinking;
            } else if (s.equals(this.YOUR_MOVE)) {
                this.statusImg = this.your_move_img;
            } else if (s.equals(this.JUMP_AGAIN)) {
                this.statusImg = this.jump_again;
            } else if (s.equals(this.MUST_JUMP)) {
                this.statusImg = this.jump;
            } else if (s.equals(this.LOSE)) {
                this.statusImg = this.i_win;
            } else if (s.equals(this.WIN)) {
                this.statusImg = this.you_win;
            }
        } else if (s.equals(this.WHITE_MOVES)) {
            this.statusImg = this.white_moves;
        } else if (s.equals(this.BLACK_MOVES)) {
            this.statusImg = this.black_moves;
        } else if (s.equals(this.LOSE)) {
            this.statusImg = this.black_win;
        } else if (s.equals(this.WIN)) {
            this.statusImg = this.white_win;
        }
    }

    private void newGame() {
        for (int i = 0; i <= 11; ++i) {
            this.board[i] = 0;
        }
        for (int j = 12; j < 20; ++j) {
            this.board[j] = 4;
        }
        for (int k = 20; k < 32; ++k) {
            this.board[k] = 1;
        }
        this.listHilightCandidatesFrom();
    }

    private boolean humanMove(Move tgmove) {
        Move[] atgmove = new Move[48];
        for (int i = 0; i < 48; ++i) {
            atgmove[i] = new Move();
        }
        int k = !this.singlePlayer ? (this.whiteMoves ? this.getListOfMoves(1, -2, atgmove) : this.getListOfMoves(0, -2, atgmove)) : this.getListOfMoves(1, -2, atgmove);
        for (int j = 0; j < k; ++j) {
            if (atgmove[j].from != tgmove.from || atgmove[j].to != tgmove.to) continue;
            boolean flag = this.applyMove(atgmove[j]);
            this.repaint();
            if (!flag && this.pieceCanCaptureAgain(atgmove[j])) {
                this.jumpAgainFromThisSq = atgmove[j].to;
                if (this.singlePlayer) {
                    this.showGameStatus(this.JUMP_AGAIN);
                }
                return false;
            }
            return true;
        }
        return false;
    }

    private void snooze(int i) {
        try {
            Thread.sleep(i);
            return;
        }
        catch (InterruptedException _ex) {
            return;
        }
    }

    private boolean computerMove(int i) {
        Move[] atgmove = new Move[48];
        this.showGameStatus(this.THINKING);
        this.repaint();
        this.serviceRepaints();
        this.snooze(1000);
        for (int j = 0; j < 48; ++j) {
            atgmove[j] = new Move();
        }
        Move tgmove = this.getListOfMoves(0, -2, atgmove) == 1 ? atgmove[0] : this.findBestMoveForRed(i);
        if (tgmove.to != -1) {
            this.jumpI = checkers.Board.sqToRow(tgmove.from);
            this.jumpJ = checkers.Board.sqToCol(tgmove.from);
            this.repaint();
            this.serviceRepaints();
            if (this.singlePlayer) {
                this.snooze(500);
            }
            boolean flag = this.applyMove(tgmove);
            this.repaint();
            this.serviceRepaints();
            if (!flag && this.pieceCanCaptureAgain(tgmove)) {
                this.computerMove(tgmove.to);
            } else {
                this.jumpI = checkers.Board.sqToRow(tgmove.to);
                this.jumpJ = checkers.Board.sqToCol(tgmove.to);
                this.repaint();
                this.serviceRepaints();
                if (this.singlePlayer) {
                    this.snooze(500);
                }
            }
            return true;
        }
        return false;
    }

    private boolean listHilightCandidatesFrom() {
        Move[] atgmove = new Move[48];
        boolean flag1 = false;
        for (int j = 0; j < 48; ++j) {
            atgmove[j] = new Move();
        }
        this.nSquaresToHilight = 0;
        int i1 = this.getListOfMoves(1, -2, atgmove);
        for (int k = 0; k < i1; ++k) {
            int i = atgmove[k].from;
            if (Math.abs(atgmove[k].from - atgmove[k].to) >= 7) {
                flag1 = true;
            }
            boolean flag = true;
            for (int l = 0; l < this.nSquaresToHilight; ++l) {
                if (i != this.squaresToHilight[l]) continue;
                flag = false;
                break;
            }
            if (!flag) continue;
            this.squaresToHilight[this.nSquaresToHilight++] = i;
        }
        return flag1;
    }

    private void listHilightCandidatesTo(int i) {
        Move[] atgmove = new Move[48];
        for (int j = 0; j < 48; ++j) {
            atgmove[j] = new Move();
        }
        this.nSquaresToHilight = 0;
        int l = this.getListOfMoves(1, -2, atgmove);
        for (int k = 0; k < l; ++k) {
            if (atgmove[k].from != i) continue;
            this.squaresToHilight[this.nSquaresToHilight++] = atgmove[k].to;
        }
    }

    private void listHilightCandidatesNone() {
        this.nSquaresToHilight = 0;
    }

    private void listJustThisHilightCandidate(int i) {
        this.squaresToHilight[0] = i;
        this.nSquaresToHilight = 1;
    }

    private int squaresInHilightList() {
        return this.nSquaresToHilight;
    }

    private boolean isSquareInHilightList(int i) {
        for (int j = 0; j < this.nSquaresToHilight; ++j) {
            if (this.squaresToHilight[j] != i) continue;
            return true;
        }
        return false;
    }

    private int[] convertCoord(int i, int j) {
        int[] coords = new int[2];
        int lx = 22;
        int ly = 22;
        int cx = 1 + j * lx;
        int cy = 1 + i * ly;
        coords[0] = cx;
        coords[1] = cy;
        return coords;
    }

    private void drawPiece(Graphics g, int i, int j, int k) {
        boolean i1;
        int[] coord = new int[2];
        coord = this.convertCoord(i, j);
        int x = coord[0];
        int y = coord[1];
        if (k == 4) {
            return;
        }
        if (k == 0 || k == 2) {
            i1 = false;
            g.drawImage(this.blackPuck, x, y, 0);
        } else {
            i1 = true;
            g.drawImage(this.whitePuck, x, y, 0);
        }
        if (k == 2 || k == 3) {
            if (!i1) {
                g.drawImage(this.blackKing, x, y, 0);
            }
            if (i1) {
                g.drawImage(this.whiteKing, x, y, 0);
            }
        }
    }

    private void drawPieces(Graphics g, boolean flag) {
        for (int i = 0; i < 32; ++i) {
            int j = this.board[i];
            if (flag && j == this.drawnBoard[i]) continue;
            if (j != 4) {
                this.drawPiece(g, checkers.Board.sqToRow(i), checkers.Board.sqToCol(i), j);
            }
            this.drawnBoard[i] = j;
        }
    }

    public boolean moveTo(int i, int j) {
        String s = this.YOUR_MOVE;
        this.jumpAgainFromThisSq = -1;
        if (this.dragSquare != -1) {
            boolean flag = false;
            int k = checkers.Board.coordToSq(j, i);
            if (k != -1 && this.board[k] == 4) {
                Move tgmove = new Move();
                tgmove.from = this.dragSquare;
                tgmove.to = k;
                tgmove.captured = -1;
                if (this.humanMove(tgmove)) {
                    flag = true;
                    this.repaint();
                    if (this.singlePlayer) {
                        if (!this.computerMove(-2)) {
                            s = this.WIN;
                            this.gameOver = true;
                        }
                    } else {
                        Move[] atgmove = new Move[48];
                        for (int l = 0; l < 48; ++l) {
                            atgmove[l] = new Move();
                        }
                        if (this.getListOfMoves(0, -2, atgmove) == 0) {
                            s = this.WIN;
                            this.gameOver = true;
                            this.showGameStatus(s);
                        } else {
                            boolean bl = this.whiteMoves = !this.whiteMoves;
                            if (this.whiteMoves) {
                                this.showGameStatus(this.WHITE_MOVES);
                            } else {
                                this.showGameStatus(this.BLACK_MOVES);
                            }
                        }
                    }
                }
            }
            if (!flag) {
                // empty if block
            }
            this.dragSquare = -1;
        }
        if (this.jumpAgainFromThisSq != -1) {
            s = this.JUMP_AGAIN;
            this.listJustThisHilightCandidate(this.jumpAgainFromThisSq);
        } else if (this.listHilightCandidatesFrom()) {
            s = this.MUST_JUMP;
        }
        if (this.squaresInHilightList() <= 0) {
            s = this.LOSE;
            this.gameOver = true;
            this.showGameStatus(s);
        }
        if (this.singlePlayer) {
            this.showGameStatus(s);
        }
        return true;
    }

    public void commandAction(Command p0, Displayable p1) {
    }

    protected void keyPressed(int keyCode) {
        if (this.gameOver) {
            Splash sp = new Splash(CheckersMIDlet.instance, this);
            Display.getDisplay((MIDlet)CheckersMIDlet.instance).setCurrent((Displayable)sp);
        }
        if (keyCode == 48 || keyCode == -7) {
            Alert end = new Alert("Title", "The game is paused!", null, AlertType.CONFIRMATION);
            end.setTimeout(-2);
            Display.getDisplay((MIDlet)CheckersMIDlet.instance).setCurrent(end, (Displayable)this);
        }
        int gameAction = this.getGameAction(keyCode);
        if (keyCode == -6) {
            Splash sp = new Splash(CheckersMIDlet.instance, this);
            Display.getDisplay((MIDlet)CheckersMIDlet.instance).setCurrent((Displayable)sp);
        }
        switch (gameAction) {
            case 8: {
                if (this.firstSelection) {
                    this.dragSquare = checkers.Board.coordToSq(this.cj, this.ci);
                    this.firstSelection = false;
                    this.selectedI = this.ci;
                    this.selectedJ = this.cj;
                    break;
                }
                this.selectedJ = -1;
                this.selectedI = -1;
                this.moveTo(this.ci, this.cj);
                this.firstSelection = true;
                break;
            }
            case 5: {
                if (this.cj >= 7) break;
                ++this.cj;
                break;
            }
            case 6: {
                if (this.ci >= 7) break;
                ++this.ci;
                break;
            }
            case 2: {
                if (this.cj <= 0) break;
                --this.cj;
                break;
            }
            case 1: {
                if (this.ci <= 0) break;
                --this.ci;
                break;
            }
        }
        this.repaint();
    }

    public void markSquare(int i, int j, boolean flag) {
        int lx = 22;
        int ly = 22;
        int cx = 1 + j * lx;
        int cy = 1 + i * ly;
        if (flag) {
            this.osG.setColor(255, 0, 0);
        } else {
            this.osG.setColor(0, 255, 0);
        }
        this.osG.drawRect(cx - 1, cy - 1, lx - 1, ly - 1);
    }

    public void paint(Graphics g) {
        this.osG = g;
        g.drawImage(this.boardImg, 0, 0, 0);
        this.drawPieces(g, false);
        if (this.selectedI != -1 && this.selectedJ != -1) {
            this.markSquare(this.selectedI, this.selectedJ, true);
        }
        if (this.jumpI != -1 && this.jumpJ != -1) {
            this.markSquare(this.jumpI, this.jumpJ, false);
            this.jumpJ = -1;
            this.jumpI = -1;
        }
        g.setColor(255, 255, 255);
        this.c.setGraphics(g);
        this.c.moveTo(this.ci, this.cj);
        g.drawImage(this.statusImg, 15, 177, 0);
    }

    public void run() {
        Thread thread = Thread.currentThread();
        try {
            while (thread == this.gameThread) {
                long l = System.currentTimeMillis();
                this.repaint();
                this.serviceRepaints();
                long l1 = System.currentTimeMillis() - l;
                Board board = this;
                synchronized (board) {
                    if (l1 < 50L) {
                        this.wait(50L - l1);
                    }
                    this.wait(20L);
                }
                if (this.isShown()) continue;
                this.stop();
            }
        }
        catch (InterruptedException interruptedException) {
        }
    }

    synchronized void start() {
        this.gameThread = new Thread(this);
        this.gameThread.start();
    }

    synchronized void stop() {
        this.gameThread = null;
        this.repaint();
        this.serviceRepaints();
    }

    static {
        Red = 0;
        Blk = 1;
        NoSquare = -1;
        xx = -1;
        AnySquare = -2;
        RedPawn = 0;
        BlkPawn = 1;
        RedKing = 2;
        BlkKing = 3;
        NoPiece = 4;
        SideMask = 1;
        MaxMoves = 48;
        BoardSquares = 32;
        Board = 0;
        Piece = 1;
        Normal = 0;
        Light = 1;
        Dark = 2;
        KLight = 35;
        KShadow = -18;
        BoardRedR = 204;
        BoardRedG = 51;
        BoardRedB = 51;
        BoardBlkR = 90;
        BoardBlkG = 90;
        BoardBlkB = 90;
        PieceRedR = 255;
        PieceRedG = 0;
        PieceRedB = 0;
        PieceBlkR = 69;
        PieceBlkG = 69;
        PieceBlkB = 69;
        Margin = 15;
        ControlMargin = 20;
        DF_TITLE = DF_TITLE;
        DF_NEWGAME = DF_NEWGAME;
        DF_FIRST = DF_FIRST;
        DF_LEVEL = DF_LEVEL;
        DF_L1 = DF_L1;
        DF_L2 = DF_L2;
        DF_L3 = DF_L3;
        DF_L4 = DF_L4;
        DF_L5 = DF_L5;
        DF_L6 = DF_L6;
        DF_L7 = DF_L7;
        DF_L8 = DF_L8;
        DF_L9 = DF_L9;
        DF_L10 = DF_L10;
        DF_WIN = DF_WIN;
        DF_LOSE = DF_LOSE;
        DF_YOUR_MOVE = DF_YOUR_MOVE;
        DF_JUMP_AGAIN = DF_JUMP_AGAIN;
        DF_MUST_JUMP = DF_MUST_JUMP;
        DF_THINKING = DF_THINKING;
        validMoves = new int[][]{{-1, -1, -1, -1, -1, 0, 1, 2, 4, 5, 6, 7, -1, 8, 9, 10, 12, 13, 14, 15, -1, 16, 17, 18, 20, 21, 22, 23, -1, 24, 25, 26}, {-1, -1, -1, -1, 0, 1, 2, 3, 5, 6, 7, -1, 8, 9, 10, 11, 13, 14, 15, -1, 16, 17, 18, 19, 21, 22, 23, -1, 24, 25, 26, 27}, {4, 5, 6, 7, -1, 8, 9, 10, 12, 13, 14, 15, -1, 16, 17, 18, 20, 21, 22, 23, -1, 24, 25, 26, 28, 29, 30, 31, -1, -1, -1, -1}, {5, 6, 7, -1, 8, 9, 10, 11, 13, 14, 15, -1, 16, 17, 18, 19, 21, 22, 23, -1, 24, 25, 26, 27, 29, 30, 31, -1, -1, -1, -1, -1}};
        pieceScore = new int[][]{{3, 0, 3, 0, 0, 1, 1, 1, 2, 2, 2, 1, 2, 3, 3, 3, 4, 4, 4, 3, 4, 5, 5, 5, 6, 6, 6, 5, 6, 7, 7, 7}, {7, 7, 7, 6, 5, 6, 6, 6, 5, 5, 5, 4, 3, 4, 4, 4, 3, 3, 3, 2, 1, 2, 2, 2, 1, 1, 1, 0, 0, 3, 0, 3}, {0, 0, 0, -5, 0, 1, 1, 1, 1, 2, 2, 0, 0, 2, 3, 1, 1, 3, 2, 0, 0, 2, 2, 1, 1, 1, 1, 0, -5, 0, 0, 0}, {0, 0, 0, -5, 0, 1, 1, 1, 1, 2, 2, 0, 0, 2, 3, 1, 1, 3, 2, 0, 0, 2, 2, 1, 1, 1, 1, 0, -5, 0, 0, 0}};
        validCaptures = new int[][]{{-1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, -1, 4, 5, 6, -1, 8, 9, 10, -1, 12, 13, 14, -1, 16, 17, 18, -1, 20, 21, 22}, {-1, -1, -1, -1, -1, -1, -1, -1, 1, 2, 3, -1, 5, 6, 7, -1, 9, 10, 11, -1, 13, 14, 15, -1, 17, 18, 19, -1, 21, 22, 23, -1}, {-1, 8, 9, 10, -1, 12, 13, 14, -1, 16, 17, 18, -1, 20, 21, 22, -1, 24, 25, 26, -1, 28, 29, 30, -1, -1, -1, -1, -1, -1, -1, -1}, {9, 10, 11, -1, 13, 14, 15, -1, 17, 18, 19, -1, 21, 22, 23, -1, 25, 26, 27, -1, 29, 30, 31, -1, -1, -1, -1, -1, -1, -1, -1, -1}};
        PawnValue = 200;
        KingValue = 300;
        Huge = 9999;
        RandBits = 0x28424824;
    }
}

